/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.Experimentality;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.CoroutineCompatibilitySupport;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0006\u0012\u0013\u0014\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findRelevantDataClassPropertyIfAny", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ClassifierUsage", "Companion", "ExperimentalityDiagnostic", "ExperimentalityDiagnostic2", "ExperimentalityDiagnostics", "Overrides", "frontend"})
public final class ExperimentalUsageChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;
    @NotNull
    private static final Name WARNING_LEVEL;
    @NotNull
    private static final Name ERROR_LEVEL;
    @NotNull
    private static final ExperimentalityDiagnostics USAGE_DIAGNOSTICS;

    public ExperimentalUsageChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(resultingDescriptor, "resultingDescriptor");
        Set experimentalities = org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, (DeclarationDescriptor)resultingDescriptor, this.moduleAnnotationsResolver, context2.getLanguageVersionSettings(), null, false, 12, null);
        if (resultingDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)resultingDescriptor).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED && (propertyDescriptor = this.findRelevantDataClassPropertyIfAny((FunctionDescriptor)resultingDescriptor, context2)) != null) {
            Companion.reportNotAcceptedExperimentalities(SetsKt.plus(experimentalities, org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, propertyDescriptor, this.moduleAnnotationsResolver, context2.getLanguageVersionSettings(), null, false, 12, null)), reportOn, context2);
            return;
        }
        Companion.reportNotAcceptedExperimentalities(experimentalities, reportOn, context2);
    }

    private final PropertyDescriptor findRelevantDataClassPropertyIfAny(FunctionDescriptor $this$findRelevantDataClassPropertyIfAny, CallCheckerContext context2) {
        String string2 = $this$findRelevantDataClassPropertyIfAny.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        Integer index2 = StringsKt.toIntOrNull(StringsKt.removePrefix(string2, (CharSequence)"component"));
        DeclarationDescriptor declarationDescriptor = $this$findRelevantDataClassPropertyIfAny.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "containingDeclaration");
        DeclarationDescriptor container2 = declarationDescriptor;
        if (container2 instanceof ClassDescriptor && ((ClassDescriptor)container2).isData() && index2 != null) {
            List<ValueParameterDescriptor> list2;
            ValueParameterDescriptor dataClassParameterDescriptor;
            ClassConstructorDescriptor classConstructorDescriptor = ((ClassDescriptor)container2).getUnsubstitutedPrimaryConstructor();
            ValueParameterDescriptor valueParameterDescriptor = classConstructorDescriptor == null ? null : (dataClassParameterDescriptor = (list2 = classConstructorDescriptor.getValueParameters()) == null ? null : CollectionsKt.getOrNull(list2, index2 - 1));
            if (dataClassParameterDescriptor != null) {
                return (PropertyDescriptor)context2.getTrace().getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, dataClassParameterDescriptor);
            }
        }
        return null;
    }

    static {
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2 = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "identifier(\"level\")");
        LEVEL = diagnosticFactory2;
        diagnosticFactory2 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "identifier(\"message\")");
        MESSAGE = diagnosticFactory2;
        diagnosticFactory2 = Name.identifier("WARNING");
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "identifier(\"WARNING\")");
        WARNING_LEVEL = diagnosticFactory2;
        diagnosticFactory2 = Name.identifier("ERROR");
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "identifier(\"ERROR\")");
        ERROR_LEVEL = diagnosticFactory2;
        diagnosticFactory2 = Errors.EXPERIMENTAL_API_USAGE;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "EXPERIMENTAL_API_USAGE");
        ExperimentalityDiagnostic experimentalityDiagnostic = new ExperimentalityDiagnostic2(diagnosticFactory2, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental and its usage should be marked"));
        diagnosticFactory2 = Errors.EXPERIMENTAL_API_USAGE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "EXPERIMENTAL_API_USAGE_ERROR");
        ExperimentalityDiagnostic experimentalityDiagnostic2 = new ExperimentalityDiagnostic2(diagnosticFactory2, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental and its usage must be marked"));
        diagnosticFactory2 = Errors.EXPERIMENTAL_API_USAGE_FUTURE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "EXPERIMENTAL_API_USAGE_FUTURE_ERROR");
        USAGE_DIAGNOSTICS = new ExperimentalityDiagnostics(experimentalityDiagnostic, experimentalityDiagnostic2, new ExperimentalityDiagnostic2(diagnosticFactory2, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental due to signature types and its usage must be marked (will become an error in 1.6)")));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "", "frontend"})
    public static interface ExperimentalityDiagnostic {
        public void report(@NotNull BindingTrace var1, @NotNull PsiElement var2, @NotNull FqName var3, @Nullable String var4);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic2;", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/name/FqName;", "", "defaultMessage", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lkotlin/jvm/functions/Function1;)V", "getDefaultMessage", "()Lkotlin/jvm/functions/Function1;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "message", "frontend"})
    public static final class ExperimentalityDiagnostic2
    implements ExperimentalityDiagnostic {
        @NotNull
        private final DiagnosticFactory2<PsiElement, FqName, String> factory;
        @NotNull
        private final Function1<FqName, String> defaultMessage;

        public ExperimentalityDiagnostic2(@NotNull DiagnosticFactory2<PsiElement, FqName, String> factory2, @NotNull Function1<? super FqName, String> defaultMessage) {
            Intrinsics.checkNotNullParameter(factory2, "factory");
            Intrinsics.checkNotNullParameter(defaultMessage, "defaultMessage");
            this.factory = factory2;
            this.defaultMessage = defaultMessage;
        }

        @NotNull
        public final DiagnosticFactory2<PsiElement, FqName, String> getFactory() {
            return this.factory;
        }

        @NotNull
        public final Function1<FqName, String> getDefaultMessage() {
            return this.defaultMessage;
        }

        @Override
        public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName2, @Nullable String message2) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(fqName2, "fqName");
            String string2 = message2;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = this.factory.on(element, fqName2, string2 == null ? this.defaultMessage.invoke(fqName2) : string2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "factory.on(element, fqNa\u2026: defaultMessage(fqName))");
            DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "", "warning", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "error", "futureError", "(Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;)V", "getError", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostic;", "getFutureError", "getWarning", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class ExperimentalityDiagnostics {
        @NotNull
        private final ExperimentalityDiagnostic warning;
        @NotNull
        private final ExperimentalityDiagnostic error;
        @NotNull
        private final ExperimentalityDiagnostic futureError;

        public ExperimentalityDiagnostics(@NotNull ExperimentalityDiagnostic warning, @NotNull ExperimentalityDiagnostic error, @NotNull ExperimentalityDiagnostic futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            this.warning = warning;
            this.error = error;
            this.futureError = futureError;
        }

        @NotNull
        public final ExperimentalityDiagnostic getWarning() {
            return this.warning;
        }

        @NotNull
        public final ExperimentalityDiagnostic getError() {
            return this.error;
        }

        @NotNull
        public final ExperimentalityDiagnostic getFutureError() {
            return this.futureError;
        }

        @NotNull
        public final ExperimentalityDiagnostic component1() {
            return this.warning;
        }

        @NotNull
        public final ExperimentalityDiagnostic component2() {
            return this.error;
        }

        @NotNull
        public final ExperimentalityDiagnostic component3() {
            return this.futureError;
        }

        @NotNull
        public final ExperimentalityDiagnostics copy(@NotNull ExperimentalityDiagnostic warning, @NotNull ExperimentalityDiagnostic error, @NotNull ExperimentalityDiagnostic futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            return new ExperimentalityDiagnostics(warning, error, futureError);
        }

        public static /* synthetic */ ExperimentalityDiagnostics copy$default(ExperimentalityDiagnostics experimentalityDiagnostics, ExperimentalityDiagnostic experimentalityDiagnostic, ExperimentalityDiagnostic experimentalityDiagnostic2, ExperimentalityDiagnostic experimentalityDiagnostic3, int n, Object object) {
            if ((n & 1) != 0) {
                experimentalityDiagnostic = experimentalityDiagnostics.warning;
            }
            if ((n & 2) != 0) {
                experimentalityDiagnostic2 = experimentalityDiagnostics.error;
            }
            if ((n & 4) != 0) {
                experimentalityDiagnostic3 = experimentalityDiagnostics.futureError;
            }
            return experimentalityDiagnostics.copy(experimentalityDiagnostic, experimentalityDiagnostic2, experimentalityDiagnostic3);
        }

        @NotNull
        public String toString() {
            return "ExperimentalityDiagnostics(warning=" + this.warning + ", error=" + this.error + ", futureError=" + this.futureError + ')';
        }

        public int hashCode() {
            int result2 = this.warning.hashCode();
            result2 = result2 * 31 + this.error.hashCode();
            result2 = result2 * 31 + this.futureError.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExperimentalityDiagnostics)) {
                return false;
            }
            ExperimentalityDiagnostics experimentalityDiagnostics = (ExperimentalityDiagnostics)other;
            if (!Intrinsics.areEqual(this.warning, experimentalityDiagnostics.warning)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.error, experimentalityDiagnostics.error)) {
                return false;
            }
            return Intrinsics.areEqual(this.futureError, experimentalityDiagnostics.futureError);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011J!\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0017J4\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bJ$\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J0\u0010#\u001a\u00020$*\u00020\u001d2!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020$0\u0011H\u0082\bJ\u001c\u0010(\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u0010,\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010-\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+J\u001c\u0010-\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J:\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0/*\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u00103\u001a\b\u0012\u0004\u0012\u000200042\b\b\u0002\u00105\u001a\u00020$J2\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0/*\u0004\u0018\u0001062\u0006\u00101\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020004H\u0002J\u001d\u00108\u001a\u0004\u0018\u00010\u001b*\u0002092\b\b\u0002\u00105\u001a\u00020$H\u0000\u00a2\u0006\u0002\b:R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Companion;", "", "()V", "ERROR_LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "LEVEL", "MESSAGE", "USAGE_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "WARNING_LEVEL", "checkCompilerArguments", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "reportError", "Lkotlin/Function1;", "", "reportWarning", "getDefaultDiagnosticMessage", "Lorg/jetbrains/kotlin/name/FqName;", "prefix", "getDefaultDiagnosticMessage$frontend", "reportNotAcceptedExperimentalities", "experimentalities", "", "Lorg/jetbrains/kotlin/resolve/checkers/Experimentality;", "element", "Lcom/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnostics", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "anyParentMatches", "", "predicate", "Lkotlin/ParameterName;", "name", "isDeclarationAnnotatedWith", "annotationFqName", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isElementAnnotatedWithUseExperimentalOf", "isExperimentalityAccepted", "loadExperimentalities", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "visited", "", "useFutureError", "Lorg/jetbrains/kotlin/types/KotlinType;", "visitedClassifiers", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "loadExperimentalityForMarkerAnnotation$frontend", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<FqName, String> getDefaultDiagnosticMessage$frontend(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            return new Function1<FqName, String>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull FqName fqName2) {
                    Intrinsics.checkNotNullParameter(fqName2, "fqName");
                    return this.$prefix + " with '@" + fqName2.asString() + "' or '@OptIn(" + fqName2.asString() + "::class)'";
                }
            };
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context2, "context");
            this.reportNotAcceptedExperimentalities(experimentalities, element, context2.getLanguageVersionSettings(), context2.getTrace(), USAGE_DIAGNOSTICS);
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace, @NotNull ExperimentalityDiagnostics diagnostics2) {
            Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(diagnostics2, "diagnostics");
            for (Experimentality experimentality : experimentalities) {
                ExperimentalityDiagnostic experimentalityDiagnostic;
                FqName annotationFqName = experimentality.component1();
                Experimentality.Severity severity = experimentality.component2();
                String message2 = experimentality.component3();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
                if (this.isExperimentalityAccepted(element, annotationFqName, languageVersionSettings, bindingContext)) continue;
                Experimentality.Severity severity2 = severity;
                int n = WhenMappings.$EnumSwitchMapping$0[severity2.ordinal()];
                switch (n) {
                    case 1: {
                        experimentalityDiagnostic = diagnostics2.getWarning();
                        break;
                    }
                    case 2: {
                        experimentalityDiagnostic = diagnostics2.getError();
                        break;
                    }
                    case 3: {
                        experimentalityDiagnostic = diagnostics2.getFutureError();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ExperimentalityDiagnostic diagnostic = experimentalityDiagnostic;
                diagnostic.report(trace, element, annotationFqName, message2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Experimentality> loadExperimentalities(@NotNull DeclarationDescriptor $this$loadExperimentalities, @NotNull ModuleAnnotationsResolver moduleAnnotationsResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Set<DeclarationDescriptor> visited2, boolean useFutureError) {
            DeclarationDescriptor container2;
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block15: {
                Object it;
                Intrinsics.checkNotNullParameter($this$loadExperimentalities, "<this>");
                Intrinsics.checkNotNullParameter(moduleAnnotationsResolver, "moduleAnnotationsResolver");
                Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
                Intrinsics.checkNotNullParameter(visited2, "visited");
                if (!visited2.add($this$loadExperimentalities)) {
                    return SetsKt.emptySet();
                }
                result2 = SmartSet.Companion.create();
                if ($this$loadExperimentalities instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$loadExperimentalities).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)$this$loadExperimentalities).getOverriddenDescriptors()) {
                        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "overridden");
                        result2.addAll(this.loadExperimentalities(callableMemberDescriptor, moduleAnnotationsResolver, languageVersionSettings, visited2, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures)));
                    }
                    return result2;
                }
                for (AnnotationDescriptor annotationDescriptor : $this$loadExperimentalities.getAnnotations()) {
                    ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor == null ? null : this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor, useFutureError));
                }
                if ($this$loadExperimentalities instanceof CallableDescriptor && !($this$loadExperimentalities instanceof ClassConstructorDescriptor)) {
                    result2.addAll(this.loadExperimentalities(((CallableDescriptor)$this$loadExperimentalities).getReturnType(), moduleAnnotationsResolver, languageVersionSettings, visited2));
                    List<ValueParameterDescriptor> list2 = ((CallableDescriptor)$this$loadExperimentalities).getExtensionReceiverParameter();
                    result2.addAll(this.loadExperimentalities(list2 == null ? null : list2.getType(), moduleAnnotationsResolver, languageVersionSettings, visited2));
                    if ($this$loadExperimentalities instanceof FunctionDescriptor) {
                        list2 = ((FunctionDescriptor)$this$loadExperimentalities).getValueParameters();
                        Intrinsics.checkNotNullExpressionValue(list2, "valueParameters");
                        Iterable $this$forEach$iv = list2;
                        boolean bl2 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (ValueParameterDescriptor)element$iv;
                            boolean bl22 = false;
                            result2.addAll(Companion.loadExperimentalities(it.getType(), moduleAnnotationsResolver, languageVersionSettings, visited2));
                        }
                    }
                }
                if ($this$loadExperimentalities instanceof TypeAliasDescriptor) {
                    result2.addAll(this.loadExperimentalities(((TypeAliasDescriptor)$this$loadExperimentalities).getExpandedType(), moduleAnnotationsResolver, languageVersionSettings, visited2));
                }
                Iterable $this$any$iv = $this$loadExperimentalities.getAnnotations();
                boolean bl3 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (AnnotationDescriptor)element$iv;
                        boolean bl32 = false;
                        if (!Intrinsics.areEqual(it.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($this$loadExperimentalities, languageVersionSettings)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                void $this$mapNotNullTo$iv$iv;
                Object element$iv;
                Iterable iterable = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                boolean $i$f$mapNotNull = false;
                element$iv = iterable;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Experimentality experimentality;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    ClassDescriptor it = (ClassDescriptor)element$iv$iv;
                    boolean bl5 = false;
                    if (org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalityForMarkerAnnotation$frontend$default(Companion, it, false, 1, null) == null) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Experimentality it$iv$iv = experimentality;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                smartSet.addAll(list3);
            }
            if ((container2 = $this$loadExperimentalities.getContainingDeclaration()) instanceof ClassDescriptor && !($this$loadExperimentalities instanceof ConstructorDescriptor)) {
                result2.addAll(this.loadExperimentalities(container2, moduleAnnotationsResolver, languageVersionSettings, visited2, useFutureError));
            }
            for (ClassId moduleAnnotationClassId : moduleAnnotationsResolver.getAnnotationsOnContainingModule($this$loadExperimentalities)) {
                ClassDescriptor annotationClass = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule($this$loadExperimentalities), moduleAnnotationClassId);
                ClassDescriptor classDescriptor = annotationClass;
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor == null ? null : org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalityForMarkerAnnotation$frontend$default(this, classDescriptor, false, 1, null));
            }
            return result2;
        }

        public static /* synthetic */ Set loadExperimentalities$default(Companion companion, DeclarationDescriptor declarationDescriptor, ModuleAnnotationsResolver moduleAnnotationsResolver, LanguageVersionSettings languageVersionSettings, Set set, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                boolean bl2 = false;
                set = new LinkedHashSet();
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.loadExperimentalities(declarationDescriptor, moduleAnnotationsResolver, languageVersionSettings, set, bl);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Experimentality> loadExperimentalities(KotlinType $this$loadExperimentalities, ModuleAnnotationsResolver moduleAnnotationsResolver, LanguageVersionSettings languageVersionSettings, Set<DeclarationDescriptor> visitedClassifiers) {
            Set<Experimentality> set;
            Object object = $this$loadExperimentalities;
            if (!(object == null ? false : !KotlinTypeKt.isError((KotlinType)object))) {
                set = SetsKt.emptySet();
            } else if ($this$loadExperimentalities instanceof AbbreviatedType) {
                object = ((AbbreviatedType)$this$loadExperimentalities).getAbbreviation().getConstructor().getDeclarationDescriptor();
                object = object == null ? null : this.loadExperimentalities((DeclarationDescriptor)object, moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures));
                boolean bl = false;
                Object object2 = object;
                if (object2 == null) {
                    object2 = SetsKt.emptySet();
                }
                set = SetsKt.plus(object2, (Iterable)this.loadExperimentalities(((AbbreviatedType)$this$loadExperimentalities).getExpandedType(), moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers));
            } else {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                object = $this$loadExperimentalities.getConstructor().getDeclarationDescriptor();
                object = object == null ? null : this.loadExperimentalities((DeclarationDescriptor)object, moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures));
                boolean bl = false;
                Object object3 = object;
                if (object3 == null) {
                    object3 = SetsKt.emptySet();
                }
                object = $this$loadExperimentalities.getArguments();
                Object object4 = object3;
                boolean $i$f$flatMap = false;
                void var7_9 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TypeProjection it = (TypeProjection)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = it.isStarProjection() ? SetsKt.emptySet() : Companion.loadExperimentalities(it.getType(), moduleAnnotationsResolver, languageVersionSettings, visitedClassifiers);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                set = SetsKt.plus(object4, list2);
            }
            return set;
        }

        @Nullable
        public final Experimentality loadExperimentalityForMarkerAnnotation$frontend(@NotNull ClassDescriptor $this$loadExperimentalityForMarkerAnnotation, boolean useFutureError) {
            Name name;
            AnnotationDescriptor annotationDescriptor;
            Intrinsics.checkNotNullParameter($this$loadExperimentalityForMarkerAnnotation, "<this>");
            AnnotationDescriptor annotationDescriptor2 = $this$loadExperimentalityForMarkerAnnotation.getAnnotations().findAnnotation(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME());
            if (annotationDescriptor2 == null) {
                AnnotationDescriptor annotationDescriptor3 = $this$loadExperimentalityForMarkerAnnotation.getAnnotations().findAnnotation(OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME());
                if (annotationDescriptor3 == null) {
                    return null;
                }
                annotationDescriptor = annotationDescriptor3;
            } else {
                annotationDescriptor = annotationDescriptor2;
            }
            AnnotationDescriptor experimental = annotationDescriptor;
            Map<Name, ConstantValue<?>> arguments2 = experimental.getAllValueArguments();
            ConstantValue<?> constantValue = arguments2.get(LEVEL);
            ConstantValue constantValue2 = constantValue instanceof EnumValue ? (EnumValue)constantValue : null;
            Name name2 = name = constantValue2 == null ? null : ((EnumValue)constantValue2).getEnumEntryName();
            Experimentality.Severity severity = Intrinsics.areEqual(name, WARNING_LEVEL) ? Experimentality.Severity.WARNING : (Intrinsics.areEqual(name, ERROR_LEVEL) ? (useFutureError ? Experimentality.Severity.FUTURE_ERROR : Experimentality.Severity.ERROR) : (Experimentality.Companion.getDEFAULT_SEVERITY() == Experimentality.Severity.ERROR && useFutureError ? Experimentality.Severity.FUTURE_ERROR : Experimentality.Companion.getDEFAULT_SEVERITY()));
            constantValue = arguments2.get(MESSAGE);
            constantValue2 = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            String message2 = constantValue2 == null ? null : (String)constantValue2.getValue();
            return new Experimentality(DescriptorUtilsKt.getFqNameSafe($this$loadExperimentalityForMarkerAnnotation), severity, message2);
        }

        public static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$frontend$default(Companion companion, ClassDescriptor classDescriptor, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor, bl);
        }

        private final boolean isExperimentalityAccepted(PsiElement $this$isExperimentalityAccepted, FqName annotationFqName, CheckerContext context2) {
            LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
            return this.isExperimentalityAccepted($this$isExperimentalityAccepted, annotationFqName, languageVersionSettings, bindingContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isExperimentalityAccepted(@NotNull PsiElement $this$isExperimentalityAccepted, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter($this$isExperimentalityAccepted, "<this>");
            Intrinsics.checkNotNullParameter(annotationFqName, "annotationFqName");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            if (languageVersionSettings.getFlag(AnalysisFlags.getExperimental()).contains(annotationFqName.asString())) return true;
            if (languageVersionSettings.getFlag(AnalysisFlags.getUseExperimental()).contains(annotationFqName.asString())) return true;
            Companion companion = this;
            PsiElement $this$anyParentMatches$iv = $this$isExperimentalityAccepted;
            boolean $i$f$anyParentMatches = false;
            PsiElement element$iv = $this$anyParentMatches$iv;
            while (true) {
                PsiElement element = element$iv;
                boolean bl = false;
                if (Companion.isDeclarationAnnotatedWith(element, annotationFqName, bindingContext)) return true;
                if (Companion.isElementAnnotatedWithUseExperimentalOf(element, annotationFqName, bindingContext)) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
                PsiElement psiElement = element$iv.getParent();
                if (psiElement == null) {
                    return false;
                }
                element$iv = psiElement;
            }
        }

        private final boolean isDeclarationAnnotatedWith(PsiElement $this$isDeclarationAnnotatedWith, FqName annotationFqName, BindingContext bindingContext) {
            if (!($this$isDeclarationAnnotatedWith instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$isDeclarationAnnotatedWith);
            return descriptor2 != null && descriptor2.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithUseExperimentalOf(PsiElement $this$isElementAnnotatedWithUseExperimentalOf, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($this$isElementAnnotatedWithUseExperimentalOf instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list2 = ((KtAnnotated)$this$isElementAnnotatedWithUseExperimentalOf).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "annotationEntries");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor2 = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (descriptor2 != null && CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getUSE_EXPERIMENTAL_FQ_NAMES(), descriptor2.getFqName())) {
                    ConstantValue<?> annotationClasses = descriptor2.getAllValueArguments().get(OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS());
                    if (annotationClasses instanceof ArrayValue) {
                        boolean bl3;
                        Iterable $this$any$iv2 = (Iterable)((ArrayValue)annotationClasses).getValue();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ConstantValue annotationClass = (ConstantValue)element$iv2;
                                boolean bl4 = false;
                                if (annotationClass instanceof KClassValue) {
                                    Object t = ((KClassValue)annotationClass).getValue();
                                    boolean bl5 = false;
                                    boolean bl6 = false;
                                    KClassValue.Value value2 = (KClassValue.Value)t;
                                    boolean bl7 = false;
                                    if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual(((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                                        return true;
                                    }
                                    boolean bl8 = false;
                                    if (bl8) {
                                        return true;
                                    }
                                }
                                boolean bl9 = false;
                                if (!bl9) continue;
                                return true;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError2, @NotNull Function1<? super String, Unit> reportWarning) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(reportError2, "reportError");
            Intrinsics.checkNotNullParameter(reportWarning, "reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager("ExperimentalUsageChecker"), languageVersionSettings, CoroutineCompatibilitySupport.Companion.getENABLED(), DeprecationSettings.Default.INSTANCE);
            Iterable $this$filter$iv = languageVersionSettings.getFlag(AnalysisFlags.getExperimental());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String p0 = (String)element$iv$iv;
                boolean bl = false;
                if (!org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, deprecationResolver, reportError2, p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validExperimental = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = languageVersionSettings.getFlag(AnalysisFlags.getUseExperimental());
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String fqName2 = (String)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(fqName2, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString()) || Intrinsics.areEqual(fqName2, OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME().asString()) || org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, deprecationResolver, reportError2, fqName2))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List validUseExperimental = (List)destination$iv$iv2;
            for (String fqName3 : CollectionsKt.intersect(validExperimental, validUseExperimental)) {
                reportError2.invoke("'-Xopt-in=" + fqName3 + "' has no effect because '-Xexperimental=" + fqName3 + "' is used");
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean checkCompilerArguments$checkAnnotation(ModuleDescriptor $module, Function1<? super String, Unit> $reportWarning, DeprecationResolver deprecationResolver, Function1<? super String, Unit> $reportError, String fqName2) {
            ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName($module, new FqName(fqName2), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
            if (descriptor2 == null) {
                $reportWarning.invoke("Opt-in requirement marker " + fqName2 + " is unresolved. Please make sure it's present in the module dependencies");
                return false;
            }
            if (org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalityForMarkerAnnotation$frontend$default(Companion, descriptor2, false, 1, null) == null) {
                $reportWarning.invoke("Class " + fqName2 + " is not an opt-in requirement marker");
                return false;
            }
            for (Deprecation deprecation : deprecationResolver.getDeprecations(descriptor2)) {
                String string2;
                Function1<? super String, Unit> report2;
                Function1<? super String, Unit> function1;
                Object object = deprecation.getDeprecationLevel();
                int n = WhenMappings.$EnumSwitchMapping$1[object.ordinal()];
                switch (n) {
                    case 1: {
                        function1 = $reportWarning;
                        break;
                    }
                    case 2: 
                    case 3: {
                        function1 = $reportError;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Function1<? super String, Unit> function12 = report2 = function1;
                StringBuilder stringBuilder2 = new StringBuilder().append("Opt-in requirement marker ").append(fqName2).append(" is deprecated");
                object = deprecation.getMessage();
                if (object == null) {
                    string2 = null;
                } else {
                    void it;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object object3 = object2;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    Function1<? super String, Unit> function13 = function12;
                    boolean bl3 = false;
                    String string3 = Intrinsics.stringPlus(". ", it);
                    function12 = function13;
                    stringBuilder2 = stringBuilder3;
                    string2 = string3;
                }
                object = string2;
                n = 0;
                Object object4 = object;
                if (object4 == null) {
                    object4 = "";
                }
                function12.invoke(stringBuilder2.append((String)object4).toString());
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Experimentality.Severity.values().length];
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
                nArray[Experimentality.Severity.FUTURE_ERROR.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DeprecationLevelValue.values().length];
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
                nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
                nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\fH\u0002J\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinExperimentalOrUseExperimental", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsQualifier", "", "isUsageAsUseExperimentalArgument", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public ClassifierUsage(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            void $this$getParentOfType$iv;
            ClassDescriptor targetClass;
            Object object;
            Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context2, "context");
            Name name = targetDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name, "targetDescriptor.name");
            Name name2 = name;
            if (Intrinsics.areEqual(name2, OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME().shortName()) || Intrinsics.areEqual(name2, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().shortName()) || Intrinsics.areEqual(name2, OptInNames.INSTANCE.getOLD_USE_EXPERIMENTAL_FQ_NAME().shortName()) || Intrinsics.areEqual(name2, OptInNames.INSTANCE.getOPT_IN_FQ_NAME().shortName())) {
                FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(targetDescriptor);
                if (OptInNames.INSTANCE.getEXPERIMENTAL_FQ_NAMES().contains(fqName2) || OptInNames.INSTANCE.getUSE_EXPERIMENTAL_FQ_NAMES().contains(fqName2)) {
                    this.checkUsageOfKotlinExperimentalOrUseExperimental(element, context2);
                    return;
                }
            }
            ClassDescriptor classDescriptor = (object = targetDescriptor) instanceof ClassDescriptor ? (ClassDescriptor)targetDescriptor : (targetClass = object instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
            if (targetClass != null && org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalityForMarkerAnnotation$frontend$default(Companion, targetClass, false, 1, null) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element)) {
                object = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(object, "context.trace.bindingContext");
                if (!this.isUsageAsUseExperimentalArgument(element, (BindingContext)object)) {
                    context2.getTrace().report(Errors.EXPERIMENTAL_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_USE_EXPERIMENTAL.on(element));
                }
            }
            object = element;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, strict$iv) == null) {
                boolean bl = false;
                Set experimentalities = new LinkedHashSet();
                DeclarationDescriptor[] declarationDescriptorArray = (DeclarationDescriptor[])experimentalities;
                Iterable iterable = org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, targetDescriptor, this.moduleAnnotationsResolver, context2.getLanguageVersionSettings(), null, false, 12, null);
                boolean bl2 = false;
                CollectionsKt.addAll(declarationDescriptorArray, iterable);
                if (targetDescriptor instanceof TypeAliasDescriptor) {
                    declarationDescriptorArray = new DeclarationDescriptor[]{targetDescriptor};
                    experimentalities.addAll(Companion.loadExperimentalities(((TypeAliasDescriptor)targetDescriptor).getExpandedType(), this.moduleAnnotationsResolver, context2.getLanguageVersionSettings(), SetsKt.mutableSetOf(declarationDescriptorArray)));
                }
                Companion.reportNotAcceptedExperimentalities(experimentalities, element, context2);
            }
        }

        private final void checkUsageOfKotlinExperimentalOrUseExperimental(PsiElement element, CheckerContext context2) {
            List<String> useExperimentalFqNames = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getUseExperimental());
            if (!useExperimentalFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString()) && !useExperimentalFqNames.contains(OptInNames.INSTANCE.getOLD_EXPERIMENTAL_FQ_NAME().asString())) {
                context2.getTrace().report(Errors.EXPERIMENTAL_IS_NOT_ENABLED.on(element));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsQualifier(element)) {
                context2.getTrace().report(Errors.EXPERIMENTAL_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element));
            }
        }

        private final boolean isUsageAsQualifier(PsiElement $this$isUsageAsQualifier) {
            KtExpression qualifier;
            PsiElement psiElement;
            KtQualifiedExpression ktQualifiedExpression;
            return $this$isUsageAsQualifier instanceof KtSimpleNameExpression && Intrinsics.areEqual((ktQualifiedExpression = (psiElement = (qualifier = (ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$this$isUsageAsQualifier)) == null ? (KtExpression)$this$isUsageAsQualifier : (KtExpression)ktQualifiedExpression).getParent()) instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null) == null ? null : ((KtDotQualifiedExpression)ktQualifiedExpression).getReceiverExpression(), qualifier);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsUseExperimentalArgument(PsiElement $this$isUsageAsUseExperimentalArgument, BindingContext bindingContext) {
            KtQualifiedExpression ktQualifiedExpression;
            KtSimpleNameExpression ktSimpleNameExpression;
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression = $this$isUsageAsUseExperimentalArgument instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)$this$isUsageAsUseExperimentalArgument : null;
            PsiElement qualifier = ktSimpleNameExpression == null ? $this$isUsageAsUseExperimentalArgument : ((ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(ktSimpleNameExpression)) == null ? $this$isUsageAsUseExperimentalArgument : (PsiElement)ktQualifiedExpression);
            PsiElement parent2 = qualifier.getParent();
            if (!(parent2 instanceof KtClassLiteralExpression)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent() instanceof KtValueArgument)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent().getParent() instanceof KtValueArgumentList)) return false;
            PsiElement psiElement = ((KtClassLiteralExpression)parent2).getParent().getParent().getParent();
            boolean bl = false;
            boolean bl2 = false;
            PsiElement psiElement2 = psiElement;
            boolean bl3 = false;
            if (!(psiElement2 instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, psiElement2);
            if (annotationDescriptor == null) {
                return false;
            }
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            boolean bl4 = false;
            boolean bl5 = false;
            AnnotationDescriptor annotation2 = annotationDescriptor2;
            boolean bl6 = false;
            if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getUSE_EXPERIMENTAL_FQ_NAMES(), annotation2.getFqName())) return true;
            if (!Intrinsics.areEqual(annotation2.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) return false;
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class Overrides
    implements DeclarationChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public Overrides(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
            Object list$iv$iv22;
            Object object;
            void $this$flatMapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context2, "context");
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return;
            }
            Object object2 = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(object2, "descriptor.overriddenDescriptors");
            Iterable $this$flatMap$iv = (Iterable)object2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CallableMemberDescriptor member2 = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(member2, "member");
                object = org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion.loadExperimentalities$default(Companion, member2, this.moduleAnnotationsResolver, context2.getLanguageVersionSettings(), null, false, 12, null);
                boolean $i$f$map = false;
                void var16_23 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void experimentality;
                    Experimentality experimentality2 = (Experimentality)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Pair<void, CallableMemberDescriptor> pair = TuplesKt.to(experimentality, member2);
                    collection.add(pair);
                }
                list$iv$iv22 = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv22);
            }
            Map experimentalOverridden = MapsKt.toMap((List)destination$iv$iv);
            Object object3 = experimentalOverridden;
            boolean $this$flatMapTo$iv$iv2 = false;
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                Pair<DiagnosticFactory2<PsiElement, FqName, String>, String> pair;
                Object element$iv$iv;
                destination$iv$iv = object3 = (Map.Entry)object2.next();
                $i$f$flatMapTo2 = false;
                Experimentality experimentality = (Experimentality)destination$iv$iv.getKey();
                Object $i$f$flatMapTo2 = object3;
                boolean bl = false;
                CallableMemberDescriptor member3 = (CallableMemberDescriptor)$i$f$flatMapTo2.getValue();
                if (Companion.isExperimentalityAccepted(declaration2, experimentality.getAnnotationFqName(), context2)) continue;
                Object object4 = element$iv$iv = declaration2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration2 : null;
                Object object5 = element$iv$iv == null ? (PsiElement)declaration2 : ((list$iv$iv22 = element$iv$iv.getNameIdentifier()) == null ? (PsiElement)declaration2 : list$iv$iv22);
                PsiElement reportOn = object5;
                element$iv$iv = experimentality.getSeverity();
                int list$iv$iv22 = WhenMappings.$EnumSwitchMapping$0[((Enum)element$iv$iv).ordinal()];
                switch (list$iv$iv22) {
                    case 1: {
                        pair = TuplesKt.to(Errors.EXPERIMENTAL_OVERRIDE, "should");
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to(Errors.EXPERIMENTAL_OVERRIDE_ERROR, "must");
                        break;
                    }
                    case 3: {
                        pair = TuplesKt.to(Errors.EXPERIMENTAL_OVERRIDE_ERROR, "must");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                object5 = pair;
                DiagnosticFactory2 diagnostic = (DiagnosticFactory2)((Pair)object5).component1();
                String defaultMessageVerb = (String)((Pair)object5).component2();
                object = experimentality.getMessage();
                Object message2 = object == null ? "This declaration overrides experimental member of supertype '" + member3.getContainingDeclaration().getName().asString() + "' and " + defaultMessageVerb + " be annotated with '@" + experimentality.getAnnotationFqName().asString() + '\'' : object;
                context2.getTrace().report(diagnostic.on(reportOn, experimentality.getAnnotationFqName(), message2));
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Experimentality.Severity.values().length];
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
                nArray[Experimentality.Severity.FUTURE_ERROR.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

