#!/usr/bin/env python
# -*- coding: utf-8 -*-

import collections

Function = collections.namedtuple('Function', ('type', 'derefcnt', 'name', 'args'))
Argument = collections.namedtuple('Argument', ('type', 'derefcnt', 'name'))

functions = {'ASN1_BIT_STRING_check': Function(type='int', derefcnt=0, name='ASN1_BIT_STRING_check', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=1, name='flags'), Argument(type='int', derefcnt=0, name='flags_len')]),
 'ASN1_BIT_STRING_free': Function(type='void', derefcnt=0, name='ASN1_BIT_STRING_free', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='a')]),
 'ASN1_BIT_STRING_get_bit': Function(type='int', derefcnt=0, name='ASN1_BIT_STRING_get_bit', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n')]),
 'ASN1_BIT_STRING_name_print': Function(type='int', derefcnt=0, name='ASN1_BIT_STRING_name_print', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='ASN1_BIT_STRING', derefcnt=1, name='bs'), Argument(type='BIT_STRING_BITNAME', derefcnt=1, name='tbl'), Argument(type='int', derefcnt=0, name='indent')]),
 'ASN1_BIT_STRING_new': Function(type='ASN1_BIT_STRING', derefcnt=1, name='ASN1_BIT_STRING_new', args=[]),
 'ASN1_BIT_STRING_num_asc': Function(type='int', derefcnt=0, name='ASN1_BIT_STRING_num_asc', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='BIT_STRING_BITNAME', derefcnt=1, name='tbl')]),
 'ASN1_BIT_STRING_set': Function(type='int', derefcnt=0, name='ASN1_BIT_STRING_set', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='length')]),
 'ASN1_BIT_STRING_set_asc': Function(type='int', derefcnt=0, name='ASN1_BIT_STRING_set_asc', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='bs'), Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='value'), Argument(type='BIT_STRING_BITNAME', derefcnt=1, name='tbl')]),
 'ASN1_BIT_STRING_set_bit': Function(type='int', derefcnt=0, name='ASN1_BIT_STRING_set_bit', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n'), Argument(type='int', derefcnt=0, name='value')]),
 'ASN1_BMPSTRING_free': Function(type='void', derefcnt=0, name='ASN1_BMPSTRING_free', args=[Argument(type='ASN1_BMPSTRING', derefcnt=1, name='a')]),
 'ASN1_BMPSTRING_new': Function(type='ASN1_BMPSTRING', derefcnt=1, name='ASN1_BMPSTRING_new', args=[]),
 'ASN1_ENUMERATED_free': Function(type='void', derefcnt=0, name='ASN1_ENUMERATED_free', args=[Argument(type='ASN1_ENUMERATED', derefcnt=1, name='a')]),
 'ASN1_ENUMERATED_get': Function(type='long', derefcnt=0, name='ASN1_ENUMERATED_get', args=[Argument(type='ASN1_ENUMERATED', derefcnt=1, name='a')]),
 'ASN1_ENUMERATED_new': Function(type='ASN1_ENUMERATED', derefcnt=1, name='ASN1_ENUMERATED_new', args=[]),
 'ASN1_ENUMERATED_set': Function(type='int', derefcnt=0, name='ASN1_ENUMERATED_set', args=[Argument(type='ASN1_ENUMERATED', derefcnt=1, name='a'), Argument(type='long', derefcnt=0, name='v')]),
 'ASN1_ENUMERATED_to_BN': Function(type='BIGNUM', derefcnt=1, name='ASN1_ENUMERATED_to_BN', args=[Argument(type='ASN1_ENUMERATED', derefcnt=1, name='ai'), Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'ASN1_GENERALIZEDTIME_adj': Function(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='ASN1_GENERALIZEDTIME_adj', args=[Argument(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=0, name='t'), Argument(type='int', derefcnt=0, name='offset_day'), Argument(type='long', derefcnt=0, name='offset_sec')]),
 'ASN1_GENERALIZEDTIME_check': Function(type='int', derefcnt=0, name='ASN1_GENERALIZEDTIME_check', args=[Argument(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='a')]),
 'ASN1_GENERALIZEDTIME_free': Function(type='void', derefcnt=0, name='ASN1_GENERALIZEDTIME_free', args=[Argument(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='a')]),
 'ASN1_GENERALIZEDTIME_new': Function(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='ASN1_GENERALIZEDTIME_new', args=[]),
 'ASN1_GENERALIZEDTIME_print': Function(type='int', derefcnt=0, name='ASN1_GENERALIZEDTIME_print', args=[Argument(type='BIO', derefcnt=1, name='fp'), Argument(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='a')]),
 'ASN1_GENERALIZEDTIME_set': Function(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='ASN1_GENERALIZEDTIME_set', args=[Argument(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=0, name='t')]),
 'ASN1_GENERALIZEDTIME_set_string': Function(type='int', derefcnt=0, name='ASN1_GENERALIZEDTIME_set_string', args=[Argument(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='str')]),
 'ASN1_GENERALSTRING_free': Function(type='void', derefcnt=0, name='ASN1_GENERALSTRING_free', args=[Argument(type='ASN1_GENERALSTRING', derefcnt=1, name='a')]),
 'ASN1_GENERALSTRING_new': Function(type='ASN1_GENERALSTRING', derefcnt=1, name='ASN1_GENERALSTRING_new', args=[]),
 'ASN1_IA5STRING_free': Function(type='void', derefcnt=0, name='ASN1_IA5STRING_free', args=[Argument(type='ASN1_IA5STRING', derefcnt=1, name='a')]),
 'ASN1_IA5STRING_new': Function(type='ASN1_IA5STRING', derefcnt=1, name='ASN1_IA5STRING_new', args=[]),
 'ASN1_INTEGER_cmp': Function(type='int', derefcnt=0, name='ASN1_INTEGER_cmp', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='x'), Argument(type='ASN1_INTEGER', derefcnt=1, name='y')]),
 'ASN1_INTEGER_dup': Function(type='ASN1_INTEGER', derefcnt=1, name='ASN1_INTEGER_dup', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='x')]),
 'ASN1_INTEGER_free': Function(type='void', derefcnt=0, name='ASN1_INTEGER_free', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='a')]),
 'ASN1_INTEGER_get': Function(type='long', derefcnt=0, name='ASN1_INTEGER_get', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='a')]),
 'ASN1_INTEGER_new': Function(type='ASN1_INTEGER', derefcnt=1, name='ASN1_INTEGER_new', args=[]),
 'ASN1_INTEGER_set': Function(type='int', derefcnt=0, name='ASN1_INTEGER_set', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='a'), Argument(type='long', derefcnt=0, name='v')]),
 'ASN1_INTEGER_to_BN': Function(type='BIGNUM', derefcnt=1, name='ASN1_INTEGER_to_BN', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='ai'), Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'ASN1_NULL_free': Function(type='void', derefcnt=0, name='ASN1_NULL_free', args=[Argument(type='ASN1_NULL', derefcnt=1, name='a')]),
 'ASN1_NULL_new': Function(type='ASN1_NULL', derefcnt=1, name='ASN1_NULL_new', args=[]),
 'ASN1_OBJECT_create': Function(type='ASN1_OBJECT', derefcnt=1, name='ASN1_OBJECT_create', args=[Argument(type='int', derefcnt=0, name='nid'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len'), Argument(type='char', derefcnt=1, name='sn'), Argument(type='char', derefcnt=1, name='ln')]),
 'ASN1_OBJECT_free': Function(type='void', derefcnt=0, name='ASN1_OBJECT_free', args=[Argument(type='ASN1_OBJECT', derefcnt=1, name='a')]),
 'ASN1_OBJECT_new': Function(type='ASN1_OBJECT', derefcnt=1, name='ASN1_OBJECT_new', args=[]),
 'ASN1_OCTET_STRING_cmp': Function(type='int', derefcnt=0, name='ASN1_OCTET_STRING_cmp', args=[Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='a'), Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='b')]),
 'ASN1_OCTET_STRING_dup': Function(type='ASN1_OCTET_STRING', derefcnt=1, name='ASN1_OCTET_STRING_dup', args=[Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='a')]),
 'ASN1_OCTET_STRING_free': Function(type='void', derefcnt=0, name='ASN1_OCTET_STRING_free', args=[Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='a')]),
 'ASN1_OCTET_STRING_new': Function(type='ASN1_OCTET_STRING', derefcnt=1, name='ASN1_OCTET_STRING_new', args=[]),
 'ASN1_OCTET_STRING_set': Function(type='int', derefcnt=0, name='ASN1_OCTET_STRING_set', args=[Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='str'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'ASN1_PCTX_free': Function(type='void', derefcnt=0, name='ASN1_PCTX_free', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p')]),
 'ASN1_PCTX_get_cert_flags': Function(type='unsigned', derefcnt=0, name='ASN1_PCTX_get_cert_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p')]),
 'ASN1_PCTX_get_flags': Function(type='unsigned', derefcnt=0, name='ASN1_PCTX_get_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p')]),
 'ASN1_PCTX_get_nm_flags': Function(type='unsigned', derefcnt=0, name='ASN1_PCTX_get_nm_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p')]),
 'ASN1_PCTX_get_oid_flags': Function(type='unsigned', derefcnt=0, name='ASN1_PCTX_get_oid_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p')]),
 'ASN1_PCTX_get_str_flags': Function(type='unsigned', derefcnt=0, name='ASN1_PCTX_get_str_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p')]),
 'ASN1_PCTX_new': Function(type='ASN1_PCTX', derefcnt=1, name='ASN1_PCTX_new', args=[]),
 'ASN1_PCTX_set_cert_flags': Function(type='void', derefcnt=0, name='ASN1_PCTX_set_cert_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'ASN1_PCTX_set_flags': Function(type='void', derefcnt=0, name='ASN1_PCTX_set_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'ASN1_PCTX_set_nm_flags': Function(type='void', derefcnt=0, name='ASN1_PCTX_set_nm_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'ASN1_PCTX_set_oid_flags': Function(type='void', derefcnt=0, name='ASN1_PCTX_set_oid_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'ASN1_PCTX_set_str_flags': Function(type='void', derefcnt=0, name='ASN1_PCTX_set_str_flags', args=[Argument(type='ASN1_PCTX', derefcnt=1, name='p'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'ASN1_PRINTABLESTRING_free': Function(type='void', derefcnt=0, name='ASN1_PRINTABLESTRING_free', args=[Argument(type='ASN1_PRINTABLESTRING', derefcnt=1, name='a')]),
 'ASN1_PRINTABLESTRING_new': Function(type='ASN1_PRINTABLESTRING', derefcnt=1, name='ASN1_PRINTABLESTRING_new', args=[]),
 'ASN1_PRINTABLE_free': Function(type='void', derefcnt=0, name='ASN1_PRINTABLE_free', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a')]),
 'ASN1_PRINTABLE_new': Function(type='ASN1_STRING', derefcnt=1, name='ASN1_PRINTABLE_new', args=[]),
 'ASN1_PRINTABLE_type': Function(type='int', derefcnt=0, name='ASN1_PRINTABLE_type', args=[Argument(type='unsigned', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='max')]),
 'ASN1_STRING_TABLE_add': Function(type='int', derefcnt=0, name='ASN1_STRING_TABLE_add', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='long', derefcnt=0, name='arg1'), Argument(type='long', derefcnt=0, name='arg2'), Argument(type='unsigned', derefcnt=0, name='arg3'), Argument(type='unsigned', derefcnt=0, name='arg4')]),
 'ASN1_STRING_TABLE_cleanup': Function(type='void', derefcnt=0, name='ASN1_STRING_TABLE_cleanup', args=[]),
 'ASN1_STRING_TABLE_get': Function(type='ASN1_STRING_TABLE', derefcnt=1, name='ASN1_STRING_TABLE_get', args=[Argument(type='int', derefcnt=0, name='nid')]),
 'ASN1_STRING_cmp': Function(type='int', derefcnt=0, name='ASN1_STRING_cmp', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a'), Argument(type='ASN1_STRING', derefcnt=1, name='b')]),
 'ASN1_STRING_copy': Function(type='int', derefcnt=0, name='ASN1_STRING_copy', args=[Argument(type='ASN1_STRING', derefcnt=1, name='dst'), Argument(type='ASN1_STRING', derefcnt=1, name='str')]),
 'ASN1_STRING_data': Function(type='unsigned', derefcnt=1, name='ASN1_STRING_data', args=[Argument(type='ASN1_STRING', derefcnt=1, name='x')]),
 'ASN1_STRING_dup': Function(type='ASN1_STRING', derefcnt=1, name='ASN1_STRING_dup', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a')]),
 'ASN1_STRING_free': Function(type='void', derefcnt=0, name='ASN1_STRING_free', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a')]),
 'ASN1_STRING_get_default_mask': Function(type='unsigned', derefcnt=0, name='ASN1_STRING_get_default_mask', args=[]),
 'ASN1_STRING_length': Function(type='int', derefcnt=0, name='ASN1_STRING_length', args=[Argument(type='ASN1_STRING', derefcnt=1, name='x')]),
 'ASN1_STRING_length_set': Function(type='void', derefcnt=0, name='ASN1_STRING_length_set', args=[Argument(type='ASN1_STRING', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='n')]),
 'ASN1_STRING_new': Function(type='ASN1_STRING', derefcnt=1, name='ASN1_STRING_new', args=[]),
 'ASN1_STRING_print': Function(type='int', derefcnt=0, name='ASN1_STRING_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_STRING', derefcnt=1, name='v')]),
 'ASN1_STRING_print_ex': Function(type='int', derefcnt=0, name='ASN1_STRING_print_ex', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='ASN1_STRING', derefcnt=1, name='str'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'ASN1_STRING_print_ex_fp': Function(type='int', derefcnt=0, name='ASN1_STRING_print_ex_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='ASN1_STRING', derefcnt=1, name='str'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'ASN1_STRING_set': Function(type='int', derefcnt=0, name='ASN1_STRING_set', args=[Argument(type='ASN1_STRING', derefcnt=1, name='str'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'ASN1_STRING_set0': Function(type='void', derefcnt=0, name='ASN1_STRING_set0', args=[Argument(type='ASN1_STRING', derefcnt=1, name='str'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'ASN1_STRING_set_by_NID': Function(type='ASN1_STRING', derefcnt=1, name='ASN1_STRING_set_by_NID', args=[Argument(type='ASN1_STRING', derefcnt=2, name='out'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='inlen'), Argument(type='int', derefcnt=0, name='inform'), Argument(type='int', derefcnt=0, name='nid')]),
 'ASN1_STRING_set_default_mask': Function(type='void', derefcnt=0, name='ASN1_STRING_set_default_mask', args=[Argument(type='unsigned', derefcnt=0, name='mask')]),
 'ASN1_STRING_set_default_mask_asc': Function(type='int', derefcnt=0, name='ASN1_STRING_set_default_mask_asc', args=[Argument(type='char', derefcnt=1, name='p')]),
 'ASN1_STRING_to_UTF8': Function(type='int', derefcnt=0, name='ASN1_STRING_to_UTF8', args=[Argument(type='unsigned', derefcnt=2, name='out'), Argument(type='ASN1_STRING', derefcnt=1, name='in')]),
 'ASN1_STRING_type': Function(type='int', derefcnt=0, name='ASN1_STRING_type', args=[Argument(type='ASN1_STRING', derefcnt=1, name='x')]),
 'ASN1_STRING_type_new': Function(type='ASN1_STRING', derefcnt=1, name='ASN1_STRING_type_new', args=[Argument(type='int', derefcnt=0, name='type')]),
 'ASN1_T61STRING_free': Function(type='void', derefcnt=0, name='ASN1_T61STRING_free', args=[Argument(type='ASN1_T61STRING', derefcnt=1, name='a')]),
 'ASN1_T61STRING_new': Function(type='ASN1_T61STRING', derefcnt=1, name='ASN1_T61STRING_new', args=[]),
 'ASN1_TIME_adj': Function(type='ASN1_TIME', derefcnt=1, name='ASN1_TIME_adj', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=0, name='t'), Argument(type='int', derefcnt=0, name='offset_day'), Argument(type='long', derefcnt=0, name='offset_sec')]),
 'ASN1_TIME_check': Function(type='int', derefcnt=0, name='ASN1_TIME_check', args=[Argument(type='ASN1_TIME', derefcnt=1, name='t')]),
 'ASN1_TIME_free': Function(type='void', derefcnt=0, name='ASN1_TIME_free', args=[Argument(type='ASN1_TIME', derefcnt=1, name='a')]),
 'ASN1_TIME_new': Function(type='ASN1_TIME', derefcnt=1, name='ASN1_TIME_new', args=[]),
 'ASN1_TIME_print': Function(type='int', derefcnt=0, name='ASN1_TIME_print', args=[Argument(type='BIO', derefcnt=1, name='fp'), Argument(type='ASN1_TIME', derefcnt=1, name='a')]),
 'ASN1_TIME_set': Function(type='ASN1_TIME', derefcnt=1, name='ASN1_TIME_set', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=0, name='t')]),
 'ASN1_TIME_set_string': Function(type='int', derefcnt=0, name='ASN1_TIME_set_string', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='str')]),
 'ASN1_TIME_to_generalizedtime': Function(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='ASN1_TIME_to_generalizedtime', args=[Argument(type='ASN1_TIME', derefcnt=1, name='t'), Argument(type='ASN1_GENERALIZEDTIME', derefcnt=2, name='out')]),
 'ASN1_TYPE_cmp': Function(type='int', derefcnt=0, name='ASN1_TYPE_cmp', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='ASN1_TYPE', derefcnt=1, name='b')]),
 'ASN1_TYPE_free': Function(type='void', derefcnt=0, name='ASN1_TYPE_free', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a')]),
 'ASN1_TYPE_get': Function(type='int', derefcnt=0, name='ASN1_TYPE_get', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a')]),
 'ASN1_TYPE_get_int_octetstring': Function(type='int', derefcnt=0, name='ASN1_TYPE_get_int_octetstring', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='long', derefcnt=1, name='num'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='max_len')]),
 'ASN1_TYPE_get_octetstring': Function(type='int', derefcnt=0, name='ASN1_TYPE_get_octetstring', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='max_len')]),
 'ASN1_TYPE_new': Function(type='ASN1_TYPE', derefcnt=1, name='ASN1_TYPE_new', args=[]),
 'ASN1_TYPE_set': Function(type='void', derefcnt=0, name='ASN1_TYPE_set', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='type'), Argument(type='void', derefcnt=1, name='value')]),
 'ASN1_TYPE_set1': Function(type='int', derefcnt=0, name='ASN1_TYPE_set1', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='type'), Argument(type='void', derefcnt=1, name='value')]),
 'ASN1_TYPE_set_int_octetstring': Function(type='int', derefcnt=0, name='ASN1_TYPE_set_int_octetstring', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='long', derefcnt=0, name='num'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'ASN1_TYPE_set_octetstring': Function(type='int', derefcnt=0, name='ASN1_TYPE_set_octetstring', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'ASN1_UNIVERSALSTRING_free': Function(type='void', derefcnt=0, name='ASN1_UNIVERSALSTRING_free', args=[Argument(type='ASN1_UNIVERSALSTRING', derefcnt=1, name='a')]),
 'ASN1_UNIVERSALSTRING_new': Function(type='ASN1_UNIVERSALSTRING', derefcnt=1, name='ASN1_UNIVERSALSTRING_new', args=[]),
 'ASN1_UNIVERSALSTRING_to_string': Function(type='int', derefcnt=0, name='ASN1_UNIVERSALSTRING_to_string', args=[Argument(type='ASN1_UNIVERSALSTRING', derefcnt=1, name='s')]),
 'ASN1_UTCTIME_adj': Function(type='ASN1_UTCTIME', derefcnt=1, name='ASN1_UTCTIME_adj', args=[Argument(type='ASN1_UTCTIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=0, name='t'), Argument(type='int', derefcnt=0, name='offset_day'), Argument(type='long', derefcnt=0, name='offset_sec')]),
 'ASN1_UTCTIME_check': Function(type='int', derefcnt=0, name='ASN1_UTCTIME_check', args=[Argument(type='ASN1_UTCTIME', derefcnt=1, name='a')]),
 'ASN1_UTCTIME_cmp_time_t': Function(type='int', derefcnt=0, name='ASN1_UTCTIME_cmp_time_t', args=[Argument(type='ASN1_UTCTIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=0, name='t')]),
 'ASN1_UTCTIME_free': Function(type='void', derefcnt=0, name='ASN1_UTCTIME_free', args=[Argument(type='ASN1_UTCTIME', derefcnt=1, name='a')]),
 'ASN1_UTCTIME_new': Function(type='ASN1_UTCTIME', derefcnt=1, name='ASN1_UTCTIME_new', args=[]),
 'ASN1_UTCTIME_print': Function(type='int', derefcnt=0, name='ASN1_UTCTIME_print', args=[Argument(type='BIO', derefcnt=1, name='fp'), Argument(type='ASN1_UTCTIME', derefcnt=1, name='a')]),
 'ASN1_UTCTIME_set': Function(type='ASN1_UTCTIME', derefcnt=1, name='ASN1_UTCTIME_set', args=[Argument(type='ASN1_UTCTIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=0, name='t')]),
 'ASN1_UTCTIME_set_string': Function(type='int', derefcnt=0, name='ASN1_UTCTIME_set_string', args=[Argument(type='ASN1_UTCTIME', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='str')]),
 'ASN1_UTF8STRING_free': Function(type='void', derefcnt=0, name='ASN1_UTF8STRING_free', args=[Argument(type='ASN1_UTF8STRING', derefcnt=1, name='a')]),
 'ASN1_UTF8STRING_new': Function(type='ASN1_UTF8STRING', derefcnt=1, name='ASN1_UTF8STRING_new', args=[]),
 'ASN1_VISIBLESTRING_free': Function(type='void', derefcnt=0, name='ASN1_VISIBLESTRING_free', args=[Argument(type='ASN1_VISIBLESTRING', derefcnt=1, name='a')]),
 'ASN1_VISIBLESTRING_new': Function(type='ASN1_VISIBLESTRING', derefcnt=1, name='ASN1_VISIBLESTRING_new', args=[]),
 'ASN1_add_oid_module': Function(type='void', derefcnt=0, name='ASN1_add_oid_module', args=[]),
 'ASN1_bn_print': Function(type='int', derefcnt=0, name='ASN1_bn_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='char', derefcnt=1, name='number'), Argument(type='BIGNUM', derefcnt=1, name='num'), Argument(type='unsigned', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='off')]),
 'ASN1_check_infinite_end': Function(type='int', derefcnt=0, name='ASN1_check_infinite_end', args=[Argument(type='unsigned', derefcnt=2, name='p'), Argument(type='long', derefcnt=0, name='len')]),
 'ASN1_const_check_infinite_end': Function(type='int', derefcnt=0, name='ASN1_const_check_infinite_end', args=[Argument(type='unsigned', derefcnt=2, name='p'), Argument(type='long', derefcnt=0, name='len')]),
 'ASN1_d2i_bio': Function(type='void', derefcnt=1, name='ASN1_d2i_bio', args=[Argument(type='void', derefcnt=1, name='xnew'), Argument(type='d2i_of_void', derefcnt=1, name='d2i'), Argument(type='BIO', derefcnt=1, name='in'), Argument(type='void', derefcnt=2, name='x')]),
 'ASN1_d2i_fp': Function(type='void', derefcnt=1, name='ASN1_d2i_fp', args=[Argument(type='void', derefcnt=1, name='xnew'), Argument(type='d2i_of_void', derefcnt=1, name='d2i'), Argument(type='FILE', derefcnt=1, name='in'), Argument(type='void', derefcnt=2, name='x')]),
 'ASN1_digest': Function(type='int', derefcnt=0, name='ASN1_digest', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='char', derefcnt=1, name='data'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'ASN1_dup': Function(type='void', derefcnt=1, name='ASN1_dup', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='d2i_of_void', derefcnt=1, name='d2i'), Argument(type='void', derefcnt=1, name='x')]),
 'ASN1_generate_nconf': Function(type='ASN1_TYPE', derefcnt=1, name='ASN1_generate_nconf', args=[Argument(type='char', derefcnt=1, name='str'), Argument(type='CONF', derefcnt=1, name='nconf')]),
 'ASN1_generate_v3': Function(type='ASN1_TYPE', derefcnt=1, name='ASN1_generate_v3', args=[Argument(type='char', derefcnt=1, name='str'), Argument(type='X509V3_CTX', derefcnt=1, name='cnf')]),
 'ASN1_get_object': Function(type='int', derefcnt=0, name='ASN1_get_object', args=[Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=1, name='plength'), Argument(type='int', derefcnt=1, name='ptag'), Argument(type='int', derefcnt=1, name='pclass'), Argument(type='long', derefcnt=0, name='omax')]),
 'ASN1_i2d_bio': Function(type='int', derefcnt=0, name='ASN1_i2d_bio', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='BIO', derefcnt=1, name='out'), Argument(type='unsigned', derefcnt=1, name='x')]),
 'ASN1_i2d_fp': Function(type='int', derefcnt=0, name='ASN1_i2d_fp', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='FILE', derefcnt=1, name='out'), Argument(type='void', derefcnt=1, name='x')]),
 'ASN1_item_d2i': Function(type='ASN1_VALUE', derefcnt=1, name='ASN1_item_d2i', args=[Argument(type='ASN1_VALUE', derefcnt=2, name='val'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'ASN1_item_d2i_bio': Function(type='void', derefcnt=1, name='ASN1_item_d2i_bio', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='BIO', derefcnt=1, name='in'), Argument(type='void', derefcnt=1, name='x')]),
 'ASN1_item_d2i_fp': Function(type='void', derefcnt=1, name='ASN1_item_d2i_fp', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='FILE', derefcnt=1, name='in'), Argument(type='void', derefcnt=1, name='x')]),
 'ASN1_item_digest': Function(type='int', derefcnt=0, name='ASN1_item_digest', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='void', derefcnt=1, name='data'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'ASN1_item_dup': Function(type='void', derefcnt=1, name='ASN1_item_dup', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='void', derefcnt=1, name='x')]),
 'ASN1_item_free': Function(type='void', derefcnt=0, name='ASN1_item_free', args=[Argument(type='ASN1_VALUE', derefcnt=1, name='val'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'ASN1_item_i2d': Function(type='int', derefcnt=0, name='ASN1_item_i2d', args=[Argument(type='ASN1_VALUE', derefcnt=1, name='val'), Argument(type='unsigned', derefcnt=2, name='out'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'ASN1_item_i2d_bio': Function(type='int', derefcnt=0, name='ASN1_item_i2d_bio', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='BIO', derefcnt=1, name='out'), Argument(type='void', derefcnt=1, name='x')]),
 'ASN1_item_i2d_fp': Function(type='int', derefcnt=0, name='ASN1_item_i2d_fp', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='FILE', derefcnt=1, name='out'), Argument(type='void', derefcnt=1, name='x')]),
 'ASN1_item_ndef_i2d': Function(type='int', derefcnt=0, name='ASN1_item_ndef_i2d', args=[Argument(type='ASN1_VALUE', derefcnt=1, name='val'), Argument(type='unsigned', derefcnt=2, name='out'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'ASN1_item_new': Function(type='ASN1_VALUE', derefcnt=1, name='ASN1_item_new', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'ASN1_item_pack': Function(type='ASN1_STRING', derefcnt=1, name='ASN1_item_pack', args=[Argument(type='void', derefcnt=1, name='obj'), Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='ASN1_OCTET_STRING', derefcnt=2, name='oct')]),
 'ASN1_item_print': Function(type='int', derefcnt=0, name='ASN1_item_print', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='ASN1_VALUE', derefcnt=1, name='ifld'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='ASN1_PCTX', derefcnt=1, name='pctx')]),
 'ASN1_item_sign': Function(type='int', derefcnt=0, name='ASN1_item_sign', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='X509_ALGOR', derefcnt=1, name='algor1'), Argument(type='X509_ALGOR', derefcnt=1, name='algor2'), Argument(type='ASN1_BIT_STRING', derefcnt=1, name='signature'), Argument(type='void', derefcnt=1, name='data'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='type')]),
 'ASN1_item_sign_ctx': Function(type='int', derefcnt=0, name='ASN1_item_sign_ctx', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='X509_ALGOR', derefcnt=1, name='algor1'), Argument(type='X509_ALGOR', derefcnt=1, name='algor2'), Argument(type='ASN1_BIT_STRING', derefcnt=1, name='signature'), Argument(type='void', derefcnt=1, name='asn'), Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'ASN1_item_unpack': Function(type='void', derefcnt=1, name='ASN1_item_unpack', args=[Argument(type='ASN1_STRING', derefcnt=1, name='oct'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'ASN1_item_verify': Function(type='int', derefcnt=0, name='ASN1_item_verify', args=[Argument(type='ASN1_ITEM', derefcnt=1, name='it'), Argument(type='X509_ALGOR', derefcnt=1, name='algor1'), Argument(type='ASN1_BIT_STRING', derefcnt=1, name='signature'), Argument(type='void', derefcnt=1, name='data'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'ASN1_mbstring_copy': Function(type='int', derefcnt=0, name='ASN1_mbstring_copy', args=[Argument(type='ASN1_STRING', derefcnt=2, name='out'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='inform'), Argument(type='unsigned', derefcnt=0, name='mask')]),
 'ASN1_mbstring_ncopy': Function(type='int', derefcnt=0, name='ASN1_mbstring_ncopy', args=[Argument(type='ASN1_STRING', derefcnt=2, name='out'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='inform'), Argument(type='unsigned', derefcnt=0, name='mask'), Argument(type='long', derefcnt=0, name='minsize'), Argument(type='long', derefcnt=0, name='maxsize')]),
 'ASN1_object_size': Function(type='int', derefcnt=0, name='ASN1_object_size', args=[Argument(type='int', derefcnt=0, name='constructed'), Argument(type='int', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='tag')]),
 'ASN1_pack_string': Function(type='ASN1_STRING', derefcnt=1, name='ASN1_pack_string', args=[Argument(type='void', derefcnt=1, name='obj'), Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='ASN1_OCTET_STRING', derefcnt=2, name='oct')]),
 'ASN1_parse': Function(type='int', derefcnt=0, name='ASN1_parse', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='unsigned', derefcnt=1, name='pp'), Argument(type='long', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='indent')]),
 'ASN1_parse_dump': Function(type='int', derefcnt=0, name='ASN1_parse_dump', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='unsigned', derefcnt=1, name='pp'), Argument(type='long', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='int', derefcnt=0, name='dump')]),
 'ASN1_put_eoc': Function(type='int', derefcnt=0, name='ASN1_put_eoc', args=[Argument(type='unsigned', derefcnt=2, name='pp')]),
 'ASN1_put_object': Function(type='void', derefcnt=0, name='ASN1_put_object', args=[Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='int', derefcnt=0, name='constructed'), Argument(type='int', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='tag'), Argument(type='int', derefcnt=0, name='xclass')]),
 'ASN1_seq_pack': Function(type='unsigned', derefcnt=1, name='ASN1_seq_pack', args=[Argument(type='stack_st_OPENSSL_BLOCK', derefcnt=1, name='safes'), Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='unsigned', derefcnt=2, name='buf'), Argument(type='int', derefcnt=1, name='len')]),
 'ASN1_seq_unpack': Function(type='stack_st_OPENSSL_BLOCK', derefcnt=1, name='ASN1_seq_unpack', args=[Argument(type='unsigned', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len'), Argument(type='d2i_of_void', derefcnt=1, name='d2i'), Argument(type='void', derefcnt=0, name='free_func')]),
 'ASN1_sign': Function(type='int', derefcnt=0, name='ASN1_sign', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='X509_ALGOR', derefcnt=1, name='algor1'), Argument(type='X509_ALGOR', derefcnt=1, name='algor2'), Argument(type='ASN1_BIT_STRING', derefcnt=1, name='signature'), Argument(type='char', derefcnt=1, name='data'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='type')]),
 'ASN1_tag2bit': Function(type='unsigned', derefcnt=0, name='ASN1_tag2bit', args=[Argument(type='int', derefcnt=0, name='tag')]),
 'ASN1_tag2str': Function(type='char', derefcnt=1, name='ASN1_tag2str', args=[Argument(type='int', derefcnt=0, name='tag')]),
 'ASN1_unpack_string': Function(type='void', derefcnt=1, name='ASN1_unpack_string', args=[Argument(type='ASN1_STRING', derefcnt=1, name='oct'), Argument(type='d2i_of_void', derefcnt=1, name='d2i')]),
 'ASN1_verify': Function(type='int', derefcnt=0, name='ASN1_verify', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='X509_ALGOR', derefcnt=1, name='algor1'), Argument(type='ASN1_BIT_STRING', derefcnt=1, name='signature'), Argument(type='char', derefcnt=1, name='data'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'BIO_accept': Function(type='int', derefcnt=0, name='BIO_accept', args=[Argument(type='int', derefcnt=0, name='sock'), Argument(type='char', derefcnt=2, name='ip_port')]),
 'BIO_asn1_get_prefix': Function(type='int', derefcnt=0, name='BIO_asn1_get_prefix', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='asn1_ps_func', derefcnt=2, name='pprefix'), Argument(type='asn1_ps_func', derefcnt=2, name='pprefix_free')]),
 'BIO_asn1_get_suffix': Function(type='int', derefcnt=0, name='BIO_asn1_get_suffix', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='asn1_ps_func', derefcnt=2, name='psuffix'), Argument(type='asn1_ps_func', derefcnt=2, name='psuffix_free')]),
 'BIO_asn1_set_prefix': Function(type='int', derefcnt=0, name='BIO_asn1_set_prefix', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='asn1_ps_func', derefcnt=1, name='prefix'), Argument(type='asn1_ps_func', derefcnt=1, name='prefix_free')]),
 'BIO_asn1_set_suffix': Function(type='int', derefcnt=0, name='BIO_asn1_set_suffix', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='asn1_ps_func', derefcnt=1, name='suffix'), Argument(type='asn1_ps_func', derefcnt=1, name='suffix_free')]),
 'BIO_callback_ctrl': Function(type='long', derefcnt=0, name='BIO_callback_ctrl', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='void', derefcnt=0, name='fp')]),
 'BIO_clear_flags': Function(type='void', derefcnt=0, name='BIO_clear_flags', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='flags')]),
 'BIO_copy_next_retry': Function(type='void', derefcnt=0, name='BIO_copy_next_retry', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_ctrl': Function(type='long', derefcnt=0, name='BIO_ctrl', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg'), Argument(type='void', derefcnt=1, name='parg')]),
 'BIO_ctrl_get_read_request': Function(type='size_t', derefcnt=0, name='BIO_ctrl_get_read_request', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_ctrl_get_write_guarantee': Function(type='size_t', derefcnt=0, name='BIO_ctrl_get_write_guarantee', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_ctrl_pending': Function(type='size_t', derefcnt=0, name='BIO_ctrl_pending', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_ctrl_reset_read_request': Function(type='int', derefcnt=0, name='BIO_ctrl_reset_read_request', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_ctrl_wpending': Function(type='size_t', derefcnt=0, name='BIO_ctrl_wpending', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_debug_callback': Function(type='long', derefcnt=0, name='BIO_debug_callback', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='char', derefcnt=1, name='argp'), Argument(type='int', derefcnt=0, name='argi'), Argument(type='long', derefcnt=0, name='argl'), Argument(type='long', derefcnt=0, name='ret')]),
 'BIO_dgram_non_fatal_error': Function(type='int', derefcnt=0, name='BIO_dgram_non_fatal_error', args=[Argument(type='int', derefcnt=0, name='error')]),
 'BIO_dump': Function(type='int', derefcnt=0, name='BIO_dump', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='char', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'BIO_dump_cb': Function(type='int', derefcnt=0, name='BIO_dump_cb', args=[Argument(type='int', derefcnt=0, name='cb'), Argument(type='void', derefcnt=1, name='u'), Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='len')]),
 'BIO_dump_fp': Function(type='int', derefcnt=0, name='BIO_dump_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='len')]),
 'BIO_dump_indent': Function(type='int', derefcnt=0, name='BIO_dump_indent', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='char', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='indent')]),
 'BIO_dump_indent_cb': Function(type='int', derefcnt=0, name='BIO_dump_indent_cb', args=[Argument(type='int', derefcnt=0, name='cb'), Argument(type='void', derefcnt=1, name='u'), Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='indent')]),
 'BIO_dump_indent_fp': Function(type='int', derefcnt=0, name='BIO_dump_indent_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='indent')]),
 'BIO_dup_chain': Function(type='BIO', derefcnt=1, name='BIO_dup_chain', args=[Argument(type='BIO', derefcnt=1, name='in')]),
 'BIO_f_asn1': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_asn1', args=[]),
 'BIO_f_base64': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_base64', args=[]),
 'BIO_f_buffer': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_buffer', args=[]),
 'BIO_f_cipher': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_cipher', args=[]),
 'BIO_f_md': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_md', args=[]),
 'BIO_f_nbio_test': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_nbio_test', args=[]),
 'BIO_f_null': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_null', args=[]),
 'BIO_f_reliable': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_reliable', args=[]),
 'BIO_f_ssl': Function(type='BIO_METHOD', derefcnt=1, name='BIO_f_ssl', args=[]),
 'BIO_fd_non_fatal_error': Function(type='int', derefcnt=0, name='BIO_fd_non_fatal_error', args=[Argument(type='int', derefcnt=0, name='error')]),
 'BIO_fd_should_retry': Function(type='int', derefcnt=0, name='BIO_fd_should_retry', args=[Argument(type='int', derefcnt=0, name='i')]),
 'BIO_find_type': Function(type='BIO', derefcnt=1, name='BIO_find_type', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='bio_type')]),
 'BIO_free': Function(type='int', derefcnt=0, name='BIO_free', args=[Argument(type='BIO', derefcnt=1, name='a')]),
 'BIO_free_all': Function(type='void', derefcnt=0, name='BIO_free_all', args=[Argument(type='BIO', derefcnt=1, name='a')]),
 'BIO_get_accept_socket': Function(type='int', derefcnt=0, name='BIO_get_accept_socket', args=[Argument(type='char', derefcnt=1, name='host_port'), Argument(type='int', derefcnt=0, name='mode')]),
 'BIO_get_callback': Function(type='long', derefcnt=0, name='BIO_get_callback', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_get_callback_arg': Function(type='char', derefcnt=1, name='BIO_get_callback_arg', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_get_ex_data': Function(type='void', derefcnt=1, name='BIO_get_ex_data', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='int', derefcnt=0, name='idx')]),
 'BIO_get_ex_new_index': Function(type='int', derefcnt=0, name='BIO_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'BIO_get_host_ip': Function(type='int', derefcnt=0, name='BIO_get_host_ip', args=[Argument(type='char', derefcnt=1, name='str'), Argument(type='unsigned', derefcnt=1, name='ip')]),
 'BIO_get_port': Function(type='int', derefcnt=0, name='BIO_get_port', args=[Argument(type='char', derefcnt=1, name='str'), Argument(type='unsigned', derefcnt=1, name='port_ptr')]),
 'BIO_get_retry_BIO': Function(type='BIO', derefcnt=1, name='BIO_get_retry_BIO', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='int', derefcnt=1, name='reason')]),
 'BIO_get_retry_reason': Function(type='int', derefcnt=0, name='BIO_get_retry_reason', args=[Argument(type='BIO', derefcnt=1, name='bio')]),
 'BIO_gethostbyname': Function(type='hostent', derefcnt=1, name='BIO_gethostbyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'BIO_gets': Function(type='int', derefcnt=0, name='BIO_gets', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='size')]),
 'BIO_indent': Function(type='int', derefcnt=0, name='BIO_indent', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='int', derefcnt=0, name='max')]),
 'BIO_int_ctrl': Function(type='long', derefcnt=0, name='BIO_int_ctrl', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg'), Argument(type='int', derefcnt=0, name='iarg')]),
 'BIO_method_name': Function(type='char', derefcnt=1, name='BIO_method_name', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_method_type': Function(type='int', derefcnt=0, name='BIO_method_type', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_new': Function(type='BIO', derefcnt=1, name='BIO_new', args=[Argument(type='BIO_METHOD', derefcnt=1, name='type')]),
 'BIO_new_NDEF': Function(type='BIO', derefcnt=1, name='BIO_new_NDEF', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='ASN1_VALUE', derefcnt=1, name='val'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'BIO_new_PKCS7': Function(type='BIO', derefcnt=1, name='BIO_new_PKCS7', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='PKCS7', derefcnt=1, name='p7')]),
 'BIO_new_accept': Function(type='BIO', derefcnt=1, name='BIO_new_accept', args=[Argument(type='char', derefcnt=1, name='host_port')]),
 'BIO_new_bio_pair': Function(type='int', derefcnt=0, name='BIO_new_bio_pair', args=[Argument(type='BIO', derefcnt=2, name='bio1'), Argument(type='size_t', derefcnt=0, name='writebuf1'), Argument(type='BIO', derefcnt=2, name='bio2'), Argument(type='size_t', derefcnt=0, name='writebuf2')]),
 'BIO_new_buffer_ssl_connect': Function(type='BIO', derefcnt=1, name='BIO_new_buffer_ssl_connect', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'BIO_new_connect': Function(type='BIO', derefcnt=1, name='BIO_new_connect', args=[Argument(type='char', derefcnt=1, name='host_port')]),
 'BIO_new_dgram': Function(type='BIO', derefcnt=1, name='BIO_new_dgram', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='close_flag')]),
 'BIO_new_fd': Function(type='BIO', derefcnt=1, name='BIO_new_fd', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='close_flag')]),
 'BIO_new_file': Function(type='BIO', derefcnt=1, name='BIO_new_file', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='char', derefcnt=1, name='mode')]),
 'BIO_new_fp': Function(type='BIO', derefcnt=1, name='BIO_new_fp', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='int', derefcnt=0, name='close_flag')]),
 'BIO_new_mem_buf': Function(type='BIO', derefcnt=1, name='BIO_new_mem_buf', args=[Argument(type='void', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'BIO_new_socket': Function(type='BIO', derefcnt=1, name='BIO_new_socket', args=[Argument(type='int', derefcnt=0, name='sock'), Argument(type='int', derefcnt=0, name='close_flag')]),
 'BIO_new_ssl': Function(type='BIO', derefcnt=1, name='BIO_new_ssl', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='client')]),
 'BIO_new_ssl_connect': Function(type='BIO', derefcnt=1, name='BIO_new_ssl_connect', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'BIO_next': Function(type='BIO', derefcnt=1, name='BIO_next', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_nread': Function(type='int', derefcnt=0, name='BIO_nread', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='char', derefcnt=2, name='buf'), Argument(type='int', derefcnt=0, name='num')]),
 'BIO_nread0': Function(type='int', derefcnt=0, name='BIO_nread0', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='char', derefcnt=2, name='buf')]),
 'BIO_number_read': Function(type='unsigned', derefcnt=0, name='BIO_number_read', args=[Argument(type='BIO', derefcnt=1, name='bio')]),
 'BIO_number_written': Function(type='unsigned', derefcnt=0, name='BIO_number_written', args=[Argument(type='BIO', derefcnt=1, name='bio')]),
 'BIO_nwrite': Function(type='int', derefcnt=0, name='BIO_nwrite', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='char', derefcnt=2, name='buf'), Argument(type='int', derefcnt=0, name='num')]),
 'BIO_nwrite0': Function(type='int', derefcnt=0, name='BIO_nwrite0', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='char', derefcnt=2, name='buf')]),
 'BIO_pop': Function(type='BIO', derefcnt=1, name='BIO_pop', args=[Argument(type='BIO', derefcnt=1, name='b')]),
 'BIO_printf': Function(type='int', derefcnt=0, name='BIO_printf', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'BIO_ptr_ctrl': Function(type='char', derefcnt=1, name='BIO_ptr_ctrl', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg')]),
 'BIO_push': Function(type='BIO', derefcnt=1, name='BIO_push', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='BIO', derefcnt=1, name='append')]),
 'BIO_puts': Function(type='int', derefcnt=0, name='BIO_puts', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='char', derefcnt=1, name='buf')]),
 'BIO_read': Function(type='int', derefcnt=0, name='BIO_read', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'BIO_s_accept': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_accept', args=[]),
 'BIO_s_bio': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_bio', args=[]),
 'BIO_s_connect': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_connect', args=[]),
 'BIO_s_datagram': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_datagram', args=[]),
 'BIO_s_fd': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_fd', args=[]),
 'BIO_s_file': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_file', args=[]),
 'BIO_s_log': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_log', args=[]),
 'BIO_s_mem': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_mem', args=[]),
 'BIO_s_null': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_null', args=[]),
 'BIO_s_socket': Function(type='BIO_METHOD', derefcnt=1, name='BIO_s_socket', args=[]),
 'BIO_set': Function(type='int', derefcnt=0, name='BIO_set', args=[Argument(type='BIO', derefcnt=1, name='a'), Argument(type='BIO_METHOD', derefcnt=1, name='type')]),
 'BIO_set_callback': Function(type='void', derefcnt=0, name='BIO_set_callback', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='long', derefcnt=0, name='callback')]),
 'BIO_set_callback_arg': Function(type='void', derefcnt=0, name='BIO_set_callback_arg', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='char', derefcnt=1, name='arg')]),
 'BIO_set_cipher': Function(type='void', derefcnt=0, name='BIO_set_cipher', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='EVP_CIPHER', derefcnt=1, name='c'), Argument(type='unsigned', derefcnt=1, name='k'), Argument(type='unsigned', derefcnt=1, name='i'), Argument(type='int', derefcnt=0, name='enc')]),
 'BIO_set_ex_data': Function(type='int', derefcnt=0, name='BIO_set_ex_data', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='data')]),
 'BIO_set_flags': Function(type='void', derefcnt=0, name='BIO_set_flags', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='flags')]),
 'BIO_set_tcp_ndelay': Function(type='int', derefcnt=0, name='BIO_set_tcp_ndelay', args=[Argument(type='int', derefcnt=0, name='sock'), Argument(type='int', derefcnt=0, name='turn_on')]),
 'BIO_snprintf': Function(type='int', derefcnt=0, name='BIO_snprintf', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'BIO_sock_cleanup': Function(type='void', derefcnt=0, name='BIO_sock_cleanup', args=[]),
 'BIO_sock_error': Function(type='int', derefcnt=0, name='BIO_sock_error', args=[Argument(type='int', derefcnt=0, name='sock')]),
 'BIO_sock_init': Function(type='int', derefcnt=0, name='BIO_sock_init', args=[]),
 'BIO_sock_non_fatal_error': Function(type='int', derefcnt=0, name='BIO_sock_non_fatal_error', args=[Argument(type='int', derefcnt=0, name='error')]),
 'BIO_sock_should_retry': Function(type='int', derefcnt=0, name='BIO_sock_should_retry', args=[Argument(type='int', derefcnt=0, name='i')]),
 'BIO_socket_ioctl': Function(type='int', derefcnt=0, name='BIO_socket_ioctl', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='long', derefcnt=0, name='type'), Argument(type='void', derefcnt=1, name='arg')]),
 'BIO_socket_nbio': Function(type='int', derefcnt=0, name='BIO_socket_nbio', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='mode')]),
 'BIO_ssl_copy_session_id': Function(type='int', derefcnt=0, name='BIO_ssl_copy_session_id', args=[Argument(type='BIO', derefcnt=1, name='to'), Argument(type='BIO', derefcnt=1, name='from')]),
 'BIO_ssl_shutdown': Function(type='void', derefcnt=0, name='BIO_ssl_shutdown', args=[Argument(type='BIO', derefcnt=1, name='ssl_bio')]),
 'BIO_test_flags': Function(type='int', derefcnt=0, name='BIO_test_flags', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='flags')]),
 'BIO_vfree': Function(type='void', derefcnt=0, name='BIO_vfree', args=[Argument(type='BIO', derefcnt=1, name='a')]),
 'BIO_vprintf': Function(type='int', derefcnt=0, name='BIO_vprintf', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='char', derefcnt=1, name='format'), Argument(type='va_list', derefcnt=0, name='args')]),
 'BIO_vsnprintf': Function(type='int', derefcnt=0, name='BIO_vsnprintf', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='char', derefcnt=1, name='format'), Argument(type='va_list', derefcnt=0, name='args')]),
 'BIO_write': Function(type='int', derefcnt=0, name='BIO_write', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'BN_BLINDING_convert': Function(type='int', derefcnt=0, name='BN_BLINDING_convert', args=[Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='BN_BLINDING', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_BLINDING_convert_ex': Function(type='int', derefcnt=0, name='BN_BLINDING_convert_ex', args=[Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BN_BLINDING', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='arg3')]),
 'BN_BLINDING_create_param': Function(type='BN_BLINDING', derefcnt=1, name='BN_BLINDING_create_param', args=[Argument(type='BN_BLINDING', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='e'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='bn_mod_exp'), Argument(type='BN_MONT_CTX', derefcnt=1, name='m_ctx')]),
 'BN_BLINDING_free': Function(type='void', derefcnt=0, name='BN_BLINDING_free', args=[Argument(type='BN_BLINDING', derefcnt=1, name='b')]),
 'BN_BLINDING_get_flags': Function(type='unsigned', derefcnt=0, name='BN_BLINDING_get_flags', args=[Argument(type='BN_BLINDING', derefcnt=1, name='arg0')]),
 'BN_BLINDING_get_thread_id': Function(type='unsigned', derefcnt=0, name='BN_BLINDING_get_thread_id', args=[Argument(type='BN_BLINDING', derefcnt=1, name='arg0')]),
 'BN_BLINDING_invert': Function(type='int', derefcnt=0, name='BN_BLINDING_invert', args=[Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='BN_BLINDING', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_BLINDING_invert_ex': Function(type='int', derefcnt=0, name='BN_BLINDING_invert_ex', args=[Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BN_BLINDING', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='arg3')]),
 'BN_BLINDING_new': Function(type='BN_BLINDING', derefcnt=1, name='BN_BLINDING_new', args=[Argument(type='BIGNUM', derefcnt=1, name='A'), Argument(type='BIGNUM', derefcnt=1, name='Ai'), Argument(type='BIGNUM', derefcnt=1, name='mod')]),
 'BN_BLINDING_set_flags': Function(type='void', derefcnt=0, name='BN_BLINDING_set_flags', args=[Argument(type='BN_BLINDING', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=0, name='arg1')]),
 'BN_BLINDING_set_thread_id': Function(type='void', derefcnt=0, name='BN_BLINDING_set_thread_id', args=[Argument(type='BN_BLINDING', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=0, name='arg1')]),
 'BN_BLINDING_thread_id': Function(type='CRYPTO_THREADID', derefcnt=1, name='BN_BLINDING_thread_id', args=[Argument(type='BN_BLINDING', derefcnt=1, name='arg0')]),
 'BN_BLINDING_update': Function(type='int', derefcnt=0, name='BN_BLINDING_update', args=[Argument(type='BN_BLINDING', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_CTX_end': Function(type='void', derefcnt=0, name='BN_CTX_end', args=[Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_CTX_free': Function(type='void', derefcnt=0, name='BN_CTX_free', args=[Argument(type='BN_CTX', derefcnt=1, name='c')]),
 'BN_CTX_get': Function(type='BIGNUM', derefcnt=1, name='BN_CTX_get', args=[Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_CTX_init': Function(type='void', derefcnt=0, name='BN_CTX_init', args=[Argument(type='BN_CTX', derefcnt=1, name='c')]),
 'BN_CTX_new': Function(type='BN_CTX', derefcnt=1, name='BN_CTX_new', args=[]),
 'BN_CTX_start': Function(type='void', derefcnt=0, name='BN_CTX_start', args=[Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GENCB_call': Function(type='int', derefcnt=0, name='BN_GENCB_call', args=[Argument(type='BN_GENCB', derefcnt=1, name='cb'), Argument(type='int', derefcnt=0, name='a'), Argument(type='int', derefcnt=0, name='b')]),
 'BN_GF2m_add': Function(type='int', derefcnt=0, name='BN_GF2m_add', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_GF2m_arr2poly': Function(type='int', derefcnt=0, name='BN_GF2m_arr2poly', args=[Argument(type='int', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_GF2m_mod': Function(type='int', derefcnt=0, name='BN_GF2m_mod', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p')]),
 'BN_GF2m_mod_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=1, name='p')]),
 'BN_GF2m_mod_div': Function(type='int', derefcnt=0, name='BN_GF2m_mod_div', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_div_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_div_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='int', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_exp': Function(type='int', derefcnt=0, name='BN_GF2m_mod_exp', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_exp_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_exp_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='int', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_inv': Function(type='int', derefcnt=0, name='BN_GF2m_mod_inv', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_inv_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_inv_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='int', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_mul': Function(type='int', derefcnt=0, name='BN_GF2m_mod_mul', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_mul_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_mul_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='int', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_solve_quad': Function(type='int', derefcnt=0, name='BN_GF2m_mod_solve_quad', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_solve_quad_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_solve_quad_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_sqr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_sqr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_sqr_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_sqr_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_sqrt': Function(type='int', derefcnt=0, name='BN_GF2m_mod_sqrt', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_mod_sqrt_arr': Function(type='int', derefcnt=0, name='BN_GF2m_mod_sqrt_arr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_GF2m_poly2arr': Function(type='int', derefcnt=0, name='BN_GF2m_poly2arr', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=1, name='p'), Argument(type='int', derefcnt=0, name='max')]),
 'BN_MONT_CTX_copy': Function(type='BN_MONT_CTX', derefcnt=1, name='BN_MONT_CTX_copy', args=[Argument(type='BN_MONT_CTX', derefcnt=1, name='to'), Argument(type='BN_MONT_CTX', derefcnt=1, name='from')]),
 'BN_MONT_CTX_free': Function(type='void', derefcnt=0, name='BN_MONT_CTX_free', args=[Argument(type='BN_MONT_CTX', derefcnt=1, name='mont')]),
 'BN_MONT_CTX_init': Function(type='void', derefcnt=0, name='BN_MONT_CTX_init', args=[Argument(type='BN_MONT_CTX', derefcnt=1, name='ctx')]),
 'BN_MONT_CTX_new': Function(type='BN_MONT_CTX', derefcnt=1, name='BN_MONT_CTX_new', args=[]),
 'BN_MONT_CTX_set': Function(type='int', derefcnt=0, name='BN_MONT_CTX_set', args=[Argument(type='BN_MONT_CTX', derefcnt=1, name='mont'), Argument(type='BIGNUM', derefcnt=1, name='mod'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_MONT_CTX_set_locked': Function(type='BN_MONT_CTX', derefcnt=1, name='BN_MONT_CTX_set_locked', args=[Argument(type='BN_MONT_CTX', derefcnt=2, name='pmont'), Argument(type='int', derefcnt=0, name='lock'), Argument(type='BIGNUM', derefcnt=1, name='mod'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_RECP_CTX_free': Function(type='void', derefcnt=0, name='BN_RECP_CTX_free', args=[Argument(type='BN_RECP_CTX', derefcnt=1, name='recp')]),
 'BN_RECP_CTX_init': Function(type='void', derefcnt=0, name='BN_RECP_CTX_init', args=[Argument(type='BN_RECP_CTX', derefcnt=1, name='recp')]),
 'BN_RECP_CTX_new': Function(type='BN_RECP_CTX', derefcnt=1, name='BN_RECP_CTX_new', args=[]),
 'BN_RECP_CTX_set': Function(type='int', derefcnt=0, name='BN_RECP_CTX_set', args=[Argument(type='BN_RECP_CTX', derefcnt=1, name='recp'), Argument(type='BIGNUM', derefcnt=1, name='rdiv'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_X931_derive_prime_ex': Function(type='int', derefcnt=0, name='BN_X931_derive_prime_ex', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='p1'), Argument(type='BIGNUM', derefcnt=1, name='p2'), Argument(type='BIGNUM', derefcnt=1, name='Xp'), Argument(type='BIGNUM', derefcnt=1, name='Xp1'), Argument(type='BIGNUM', derefcnt=1, name='Xp2'), Argument(type='BIGNUM', derefcnt=1, name='e'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'BN_X931_generate_Xpq': Function(type='int', derefcnt=0, name='BN_X931_generate_Xpq', args=[Argument(type='BIGNUM', derefcnt=1, name='Xp'), Argument(type='BIGNUM', derefcnt=1, name='Xq'), Argument(type='int', derefcnt=0, name='nbits'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_X931_generate_prime_ex': Function(type='int', derefcnt=0, name='BN_X931_generate_prime_ex', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='p1'), Argument(type='BIGNUM', derefcnt=1, name='p2'), Argument(type='BIGNUM', derefcnt=1, name='Xp1'), Argument(type='BIGNUM', derefcnt=1, name='Xp2'), Argument(type='BIGNUM', derefcnt=1, name='Xp'), Argument(type='BIGNUM', derefcnt=1, name='e'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'BN_add': Function(type='int', derefcnt=0, name='BN_add', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_add_word': Function(type='int', derefcnt=0, name='BN_add_word', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'BN_asc2bn': Function(type='int', derefcnt=0, name='BN_asc2bn', args=[Argument(type='BIGNUM', derefcnt=2, name='a'), Argument(type='char', derefcnt=1, name='str')]),
 'BN_bin2bn': Function(type='BIGNUM', derefcnt=1, name='BN_bin2bn', args=[Argument(type='unsigned', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='len'), Argument(type='BIGNUM', derefcnt=1, name='ret')]),
 'BN_bn2bin': Function(type='int', derefcnt=0, name='BN_bn2bin', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=1, name='to')]),
 'BN_bn2dec': Function(type='char', derefcnt=1, name='BN_bn2dec', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_bn2hex': Function(type='char', derefcnt=1, name='BN_bn2hex', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_bn2mpi': Function(type='int', derefcnt=0, name='BN_bn2mpi', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=1, name='to')]),
 'BN_bntest_rand': Function(type='int', derefcnt=0, name='BN_bntest_rand', args=[Argument(type='BIGNUM', derefcnt=1, name='rnd'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='int', derefcnt=0, name='top'), Argument(type='int', derefcnt=0, name='bottom')]),
 'BN_clear': Function(type='void', derefcnt=0, name='BN_clear', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_clear_bit': Function(type='int', derefcnt=0, name='BN_clear_bit', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n')]),
 'BN_clear_free': Function(type='void', derefcnt=0, name='BN_clear_free', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_cmp': Function(type='int', derefcnt=0, name='BN_cmp', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_consttime_swap': Function(type='void', derefcnt=0, name='BN_consttime_swap', args=[Argument(type='unsigned', derefcnt=0, name='swap'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='nwords')]),
 'BN_copy': Function(type='BIGNUM', derefcnt=1, name='BN_copy', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_dec2bn': Function(type='int', derefcnt=0, name='BN_dec2bn', args=[Argument(type='BIGNUM', derefcnt=2, name='a'), Argument(type='char', derefcnt=1, name='str')]),
 'BN_div': Function(type='int', derefcnt=0, name='BN_div', args=[Argument(type='BIGNUM', derefcnt=1, name='dv'), Argument(type='BIGNUM', derefcnt=1, name='rem'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BIGNUM', derefcnt=1, name='d'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_div_recp': Function(type='int', derefcnt=0, name='BN_div_recp', args=[Argument(type='BIGNUM', derefcnt=1, name='dv'), Argument(type='BIGNUM', derefcnt=1, name='rem'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_RECP_CTX', derefcnt=1, name='recp'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_div_word': Function(type='unsigned', derefcnt=0, name='BN_div_word', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'BN_dup': Function(type='BIGNUM', derefcnt=1, name='BN_dup', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_exp': Function(type='int', derefcnt=0, name='BN_exp', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_free': Function(type='void', derefcnt=0, name='BN_free', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_from_montgomery': Function(type='int', derefcnt=0, name='BN_from_montgomery', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BN_MONT_CTX', derefcnt=1, name='mont'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_gcd': Function(type='int', derefcnt=0, name='BN_gcd', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_generate_prime': Function(type='BIGNUM', derefcnt=1, name='BN_generate_prime', args=[Argument(type='BIGNUM', derefcnt=1, name='ret'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='int', derefcnt=0, name='safe'), Argument(type='BIGNUM', derefcnt=1, name='add'), Argument(type='BIGNUM', derefcnt=1, name='rem'), Argument(type='void', derefcnt=0, name='callback'), Argument(type='void', derefcnt=1, name='cb_arg')]),
 'BN_generate_prime_ex': Function(type='int', derefcnt=0, name='BN_generate_prime_ex', args=[Argument(type='BIGNUM', derefcnt=1, name='ret'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='int', derefcnt=0, name='safe'), Argument(type='BIGNUM', derefcnt=1, name='add'), Argument(type='BIGNUM', derefcnt=1, name='rem'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'BN_get0_nist_prime_192': Function(type='BIGNUM', derefcnt=1, name='BN_get0_nist_prime_192', args=[]),
 'BN_get0_nist_prime_224': Function(type='BIGNUM', derefcnt=1, name='BN_get0_nist_prime_224', args=[]),
 'BN_get0_nist_prime_256': Function(type='BIGNUM', derefcnt=1, name='BN_get0_nist_prime_256', args=[]),
 'BN_get0_nist_prime_384': Function(type='BIGNUM', derefcnt=1, name='BN_get0_nist_prime_384', args=[]),
 'BN_get0_nist_prime_521': Function(type='BIGNUM', derefcnt=1, name='BN_get0_nist_prime_521', args=[]),
 'BN_get_params': Function(type='int', derefcnt=0, name='BN_get_params', args=[Argument(type='int', derefcnt=0, name='which')]),
 'BN_get_word': Function(type='unsigned', derefcnt=0, name='BN_get_word', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_hex2bn': Function(type='int', derefcnt=0, name='BN_hex2bn', args=[Argument(type='BIGNUM', derefcnt=2, name='a'), Argument(type='char', derefcnt=1, name='str')]),
 'BN_init': Function(type='void', derefcnt=0, name='BN_init', args=[Argument(type='BIGNUM', derefcnt=1, name='arg0')]),
 'BN_is_bit_set': Function(type='int', derefcnt=0, name='BN_is_bit_set', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n')]),
 'BN_is_prime': Function(type='int', derefcnt=0, name='BN_is_prime', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='int', derefcnt=0, name='nchecks'), Argument(type='void', derefcnt=0, name='callback'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='cb_arg')]),
 'BN_is_prime_ex': Function(type='int', derefcnt=0, name='BN_is_prime_ex', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='int', derefcnt=0, name='nchecks'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'BN_is_prime_fasttest': Function(type='int', derefcnt=0, name='BN_is_prime_fasttest', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='int', derefcnt=0, name='nchecks'), Argument(type='void', derefcnt=0, name='callback'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='cb_arg'), Argument(type='int', derefcnt=0, name='do_trial_division')]),
 'BN_is_prime_fasttest_ex': Function(type='int', derefcnt=0, name='BN_is_prime_fasttest_ex', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='int', derefcnt=0, name='nchecks'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='do_trial_division'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'BN_kronecker': Function(type='int', derefcnt=0, name='BN_kronecker', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_lshift': Function(type='int', derefcnt=0, name='BN_lshift', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n')]),
 'BN_lshift1': Function(type='int', derefcnt=0, name='BN_lshift1', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_mask_bits': Function(type='int', derefcnt=0, name='BN_mask_bits', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n')]),
 'BN_mod_add': Function(type='int', derefcnt=0, name='BN_mod_add', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_add_quick': Function(type='int', derefcnt=0, name='BN_mod_add_quick', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='m')]),
 'BN_mod_exp': Function(type='int', derefcnt=0, name='BN_mod_exp', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_exp2_mont': Function(type='int', derefcnt=0, name='BN_mod_exp2_mont', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a1'), Argument(type='BIGNUM', derefcnt=1, name='p1'), Argument(type='BIGNUM', derefcnt=1, name='a2'), Argument(type='BIGNUM', derefcnt=1, name='p2'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_MONT_CTX', derefcnt=1, name='m_ctx')]),
 'BN_mod_exp_mont': Function(type='int', derefcnt=0, name='BN_mod_exp_mont', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_MONT_CTX', derefcnt=1, name='m_ctx')]),
 'BN_mod_exp_mont_consttime': Function(type='int', derefcnt=0, name='BN_mod_exp_mont_consttime', args=[Argument(type='BIGNUM', derefcnt=1, name='rr'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_MONT_CTX', derefcnt=1, name='in_mont')]),
 'BN_mod_exp_mont_word': Function(type='int', derefcnt=0, name='BN_mod_exp_mont_word', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='unsigned', derefcnt=0, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_MONT_CTX', derefcnt=1, name='m_ctx')]),
 'BN_mod_exp_recp': Function(type='int', derefcnt=0, name='BN_mod_exp_recp', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_exp_simple': Function(type='int', derefcnt=0, name='BN_mod_exp_simple', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_inverse': Function(type='BIGNUM', derefcnt=1, name='BN_mod_inverse', args=[Argument(type='BIGNUM', derefcnt=1, name='ret'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_lshift': Function(type='int', derefcnt=0, name='BN_mod_lshift', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_lshift1': Function(type='int', derefcnt=0, name='BN_mod_lshift1', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_lshift1_quick': Function(type='int', derefcnt=0, name='BN_mod_lshift1_quick', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='m')]),
 'BN_mod_lshift_quick': Function(type='int', derefcnt=0, name='BN_mod_lshift_quick', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n'), Argument(type='BIGNUM', derefcnt=1, name='m')]),
 'BN_mod_mul': Function(type='int', derefcnt=0, name='BN_mod_mul', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_mul_montgomery': Function(type='int', derefcnt=0, name='BN_mod_mul_montgomery', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_MONT_CTX', derefcnt=1, name='mont'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_mul_reciprocal': Function(type='int', derefcnt=0, name='BN_mod_mul_reciprocal', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y'), Argument(type='BN_RECP_CTX', derefcnt=1, name='recp'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_sqr': Function(type='int', derefcnt=0, name='BN_mod_sqr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_sqrt': Function(type='BIGNUM', derefcnt=1, name='BN_mod_sqrt', args=[Argument(type='BIGNUM', derefcnt=1, name='ret'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_sub': Function(type='int', derefcnt=0, name='BN_mod_sub', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mod_sub_quick': Function(type='int', derefcnt=0, name='BN_mod_sub_quick', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BIGNUM', derefcnt=1, name='m')]),
 'BN_mod_word': Function(type='unsigned', derefcnt=0, name='BN_mod_word', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'BN_mpi2bn': Function(type='BIGNUM', derefcnt=1, name='BN_mpi2bn', args=[Argument(type='unsigned', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='len'), Argument(type='BIGNUM', derefcnt=1, name='ret')]),
 'BN_mul': Function(type='int', derefcnt=0, name='BN_mul', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_mul_word': Function(type='int', derefcnt=0, name='BN_mul_word', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'BN_new': Function(type='BIGNUM', derefcnt=1, name='BN_new', args=[]),
 'BN_nist_mod_192': Function(type='int', derefcnt=0, name='BN_nist_mod_192', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_nist_mod_224': Function(type='int', derefcnt=0, name='BN_nist_mod_224', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_nist_mod_256': Function(type='int', derefcnt=0, name='BN_nist_mod_256', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_nist_mod_384': Function(type='int', derefcnt=0, name='BN_nist_mod_384', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_nist_mod_521': Function(type='int', derefcnt=0, name='BN_nist_mod_521', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_nnmod': Function(type='int', derefcnt=0, name='BN_nnmod', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BIGNUM', derefcnt=1, name='d'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_num_bits': Function(type='int', derefcnt=0, name='BN_num_bits', args=[Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_num_bits_word': Function(type='int', derefcnt=0, name='BN_num_bits_word', args=[Argument(type='unsigned', derefcnt=0, name='arg0')]),
 'BN_options': Function(type='char', derefcnt=1, name='BN_options', args=[]),
 'BN_print': Function(type='int', derefcnt=0, name='BN_print', args=[Argument(type='BIO', derefcnt=1, name='fp'), Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_print_fp': Function(type='int', derefcnt=0, name='BN_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_pseudo_rand': Function(type='int', derefcnt=0, name='BN_pseudo_rand', args=[Argument(type='BIGNUM', derefcnt=1, name='rnd'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='int', derefcnt=0, name='top'), Argument(type='int', derefcnt=0, name='bottom')]),
 'BN_pseudo_rand_range': Function(type='int', derefcnt=0, name='BN_pseudo_rand_range', args=[Argument(type='BIGNUM', derefcnt=1, name='rnd'), Argument(type='BIGNUM', derefcnt=1, name='range')]),
 'BN_rand': Function(type='int', derefcnt=0, name='BN_rand', args=[Argument(type='BIGNUM', derefcnt=1, name='rnd'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='int', derefcnt=0, name='top'), Argument(type='int', derefcnt=0, name='bottom')]),
 'BN_rand_range': Function(type='int', derefcnt=0, name='BN_rand_range', args=[Argument(type='BIGNUM', derefcnt=1, name='rnd'), Argument(type='BIGNUM', derefcnt=1, name='range')]),
 'BN_reciprocal': Function(type='int', derefcnt=0, name='BN_reciprocal', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='int', derefcnt=0, name='len'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_rshift': Function(type='int', derefcnt=0, name='BN_rshift', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n')]),
 'BN_rshift1': Function(type='int', derefcnt=0, name='BN_rshift1', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a')]),
 'BN_set_bit': Function(type='int', derefcnt=0, name='BN_set_bit', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='n')]),
 'BN_set_negative': Function(type='void', derefcnt=0, name='BN_set_negative', args=[Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='int', derefcnt=0, name='n')]),
 'BN_set_params': Function(type='void', derefcnt=0, name='BN_set_params', args=[Argument(type='int', derefcnt=0, name='mul'), Argument(type='int', derefcnt=0, name='high'), Argument(type='int', derefcnt=0, name='low'), Argument(type='int', derefcnt=0, name='mont')]),
 'BN_set_word': Function(type='int', derefcnt=0, name='BN_set_word', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'BN_sqr': Function(type='int', derefcnt=0, name='BN_sqr', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'BN_sub': Function(type='int', derefcnt=0, name='BN_sub', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_sub_word': Function(type='int', derefcnt=0, name='BN_sub_word', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'BN_swap': Function(type='void', derefcnt=0, name='BN_swap', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_to_ASN1_ENUMERATED': Function(type='ASN1_ENUMERATED', derefcnt=1, name='BN_to_ASN1_ENUMERATED', args=[Argument(type='BIGNUM', derefcnt=1, name='bn'), Argument(type='ASN1_ENUMERATED', derefcnt=1, name='ai')]),
 'BN_to_ASN1_INTEGER': Function(type='ASN1_INTEGER', derefcnt=1, name='BN_to_ASN1_INTEGER', args=[Argument(type='BIGNUM', derefcnt=1, name='bn'), Argument(type='ASN1_INTEGER', derefcnt=1, name='ai')]),
 'BN_uadd': Function(type='int', derefcnt=0, name='BN_uadd', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_ucmp': Function(type='int', derefcnt=0, name='BN_ucmp', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_usub': Function(type='int', derefcnt=0, name='BN_usub', args=[Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b')]),
 'BN_value_one': Function(type='BIGNUM', derefcnt=1, name='BN_value_one', args=[]),
 'BUF_MEM_free': Function(type='void', derefcnt=0, name='BUF_MEM_free', args=[Argument(type='BUF_MEM', derefcnt=1, name='a')]),
 'BUF_MEM_grow': Function(type='int', derefcnt=0, name='BUF_MEM_grow', args=[Argument(type='BUF_MEM', derefcnt=1, name='str'), Argument(type='size_t', derefcnt=0, name='len')]),
 'BUF_MEM_grow_clean': Function(type='int', derefcnt=0, name='BUF_MEM_grow_clean', args=[Argument(type='BUF_MEM', derefcnt=1, name='str'), Argument(type='size_t', derefcnt=0, name='len')]),
 'BUF_MEM_new': Function(type='BUF_MEM', derefcnt=1, name='BUF_MEM_new', args=[]),
 'BUF_memdup': Function(type='void', derefcnt=1, name='BUF_memdup', args=[Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='siz')]),
 'BUF_reverse': Function(type='void', derefcnt=0, name='BUF_reverse', args=[Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='siz')]),
 'BUF_strdup': Function(type='char', derefcnt=1, name='BUF_strdup', args=[Argument(type='char', derefcnt=1, name='str')]),
 'BUF_strlcat': Function(type='size_t', derefcnt=0, name='BUF_strlcat', args=[Argument(type='char', derefcnt=1, name='dst'), Argument(type='char', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='siz')]),
 'BUF_strlcpy': Function(type='size_t', derefcnt=0, name='BUF_strlcpy', args=[Argument(type='char', derefcnt=1, name='dst'), Argument(type='char', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='siz')]),
 'BUF_strndup': Function(type='char', derefcnt=1, name='BUF_strndup', args=[Argument(type='char', derefcnt=1, name='str'), Argument(type='size_t', derefcnt=0, name='siz')]),
 'COMP_CTX_free': Function(type='void', derefcnt=0, name='COMP_CTX_free', args=[Argument(type='COMP_CTX', derefcnt=1, name='ctx')]),
 'COMP_CTX_new': Function(type='COMP_CTX', derefcnt=1, name='COMP_CTX_new', args=[Argument(type='COMP_METHOD', derefcnt=1, name='meth')]),
 'COMP_compress_block': Function(type='int', derefcnt=0, name='COMP_compress_block', args=[Argument(type='COMP_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=0, name='olen'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='ilen')]),
 'COMP_expand_block': Function(type='int', derefcnt=0, name='COMP_expand_block', args=[Argument(type='COMP_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=0, name='olen'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='ilen')]),
 'COMP_rle': Function(type='COMP_METHOD', derefcnt=1, name='COMP_rle', args=[]),
 'COMP_zlib': Function(type='COMP_METHOD', derefcnt=1, name='COMP_zlib', args=[]),
 'COMP_zlib_cleanup': Function(type='void', derefcnt=0, name='COMP_zlib_cleanup', args=[]),
 'CRYPTO_EX_dup': Function(type='int', derefcnt=0, name='CRYPTO_EX_dup', args=[Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='to'), Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='from'), Argument(type='void', derefcnt=1, name='from_d'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp')]),
 'CRYPTO_EX_free': Function(type='void', derefcnt=0, name='CRYPTO_EX_free', args=[Argument(type='void', derefcnt=1, name='parent'), Argument(type='void', derefcnt=1, name='ptr'), Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='ad'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp')]),
 'CRYPTO_EX_new': Function(type='int', derefcnt=0, name='CRYPTO_EX_new', args=[Argument(type='void', derefcnt=1, name='parent'), Argument(type='void', derefcnt=1, name='ptr'), Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='ad'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp')]),
 'CRYPTO_MEM_LEAK_CB': Function(type='void', derefcnt=1, name='CRYPTO_MEM_LEAK_CB', args=[Argument(type='unsigned', derefcnt=0, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='void', derefcnt=1, name='arg4')]),
 'CRYPTO_THREADID_cmp': Function(type='int', derefcnt=0, name='CRYPTO_THREADID_cmp', args=[Argument(type='CRYPTO_THREADID', derefcnt=1, name='a'), Argument(type='CRYPTO_THREADID', derefcnt=1, name='b')]),
 'CRYPTO_THREADID_cpy': Function(type='void', derefcnt=0, name='CRYPTO_THREADID_cpy', args=[Argument(type='CRYPTO_THREADID', derefcnt=1, name='dest'), Argument(type='CRYPTO_THREADID', derefcnt=1, name='src')]),
 'CRYPTO_THREADID_current': Function(type='void', derefcnt=0, name='CRYPTO_THREADID_current', args=[Argument(type='CRYPTO_THREADID', derefcnt=1, name='id')]),
 'CRYPTO_THREADID_get_callback': Function(type='void', derefcnt=0, name='CRYPTO_THREADID_get_callback', args=[]),
 'CRYPTO_THREADID_hash': Function(type='unsigned', derefcnt=0, name='CRYPTO_THREADID_hash', args=[Argument(type='CRYPTO_THREADID', derefcnt=1, name='id')]),
 'CRYPTO_THREADID_set_callback': Function(type='int', derefcnt=0, name='CRYPTO_THREADID_set_callback', args=[Argument(type='void', derefcnt=0, name='threadid_func')]),
 'CRYPTO_THREADID_set_numeric': Function(type='void', derefcnt=0, name='CRYPTO_THREADID_set_numeric', args=[Argument(type='CRYPTO_THREADID', derefcnt=1, name='id'), Argument(type='unsigned', derefcnt=0, name='val')]),
 'CRYPTO_THREADID_set_pointer': Function(type='void', derefcnt=0, name='CRYPTO_THREADID_set_pointer', args=[Argument(type='CRYPTO_THREADID', derefcnt=1, name='id'), Argument(type='void', derefcnt=1, name='ptr')]),
 'CRYPTO_add_lock': Function(type='int', derefcnt=0, name='CRYPTO_add_lock', args=[Argument(type='int', derefcnt=1, name='pointer'), Argument(type='int', derefcnt=0, name='amount'), Argument(type='int', derefcnt=0, name='type'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_cleanup_all_ex_data': Function(type='void', derefcnt=0, name='CRYPTO_cleanup_all_ex_data', args=[]),
 'CRYPTO_dbg_free': Function(type='void', derefcnt=0, name='CRYPTO_dbg_free', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='int', derefcnt=0, name='before_p')]),
 'CRYPTO_dbg_get_options': Function(type='long', derefcnt=0, name='CRYPTO_dbg_get_options', args=[]),
 'CRYPTO_dbg_malloc': Function(type='void', derefcnt=0, name='CRYPTO_dbg_malloc', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='int', derefcnt=0, name='num'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line'), Argument(type='int', derefcnt=0, name='before_p')]),
 'CRYPTO_dbg_realloc': Function(type='void', derefcnt=0, name='CRYPTO_dbg_realloc', args=[Argument(type='void', derefcnt=1, name='addr1'), Argument(type='void', derefcnt=1, name='addr2'), Argument(type='int', derefcnt=0, name='num'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line'), Argument(type='int', derefcnt=0, name='before_p')]),
 'CRYPTO_dbg_set_options': Function(type='void', derefcnt=0, name='CRYPTO_dbg_set_options', args=[Argument(type='long', derefcnt=0, name='bits')]),
 'CRYPTO_destroy_dynlockid': Function(type='void', derefcnt=0, name='CRYPTO_destroy_dynlockid', args=[Argument(type='int', derefcnt=0, name='i')]),
 'CRYPTO_dup_ex_data': Function(type='int', derefcnt=0, name='CRYPTO_dup_ex_data', args=[Argument(type='int', derefcnt=0, name='class_index'), Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='to'), Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='from')]),
 'CRYPTO_ex_data_new_class': Function(type='int', derefcnt=0, name='CRYPTO_ex_data_new_class', args=[]),
 'CRYPTO_free': Function(type='void', derefcnt=0, name='CRYPTO_free', args=[Argument(type='void', derefcnt=1, name='ptr')]),
 'CRYPTO_free_ex_data': Function(type='void', derefcnt=0, name='CRYPTO_free_ex_data', args=[Argument(type='int', derefcnt=0, name='class_index'), Argument(type='void', derefcnt=1, name='obj'), Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='ad')]),
 'CRYPTO_free_locked': Function(type='void', derefcnt=0, name='CRYPTO_free_locked', args=[Argument(type='void', derefcnt=1, name='ptr')]),
 'CRYPTO_get_add_lock_callback': Function(type='int', derefcnt=0, name='CRYPTO_get_add_lock_callback', args=[]),
 'CRYPTO_get_dynlock_create_callback': Function(type='CRYPTO_dynlock_value', derefcnt=1, name='CRYPTO_get_dynlock_create_callback', args=[]),
 'CRYPTO_get_dynlock_destroy_callback': Function(type='void', derefcnt=0, name='CRYPTO_get_dynlock_destroy_callback', args=[]),
 'CRYPTO_get_dynlock_lock_callback': Function(type='void', derefcnt=0, name='CRYPTO_get_dynlock_lock_callback', args=[]),
 'CRYPTO_get_dynlock_value': Function(type='CRYPTO_dynlock_value', derefcnt=1, name='CRYPTO_get_dynlock_value', args=[Argument(type='int', derefcnt=0, name='i')]),
 'CRYPTO_get_ex_data': Function(type='void', derefcnt=1, name='CRYPTO_get_ex_data', args=[Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='ad'), Argument(type='int', derefcnt=0, name='idx')]),
 'CRYPTO_get_ex_data_implementation': Function(type='CRYPTO_EX_DATA_IMPL', derefcnt=1, name='CRYPTO_get_ex_data_implementation', args=[]),
 'CRYPTO_get_ex_new_index': Function(type='int', derefcnt=0, name='CRYPTO_get_ex_new_index', args=[Argument(type='int', derefcnt=0, name='class_index'), Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'CRYPTO_get_id_callback': Function(type='unsigned', derefcnt=0, name='CRYPTO_get_id_callback', args=[]),
 'CRYPTO_get_lock_name': Function(type='char', derefcnt=1, name='CRYPTO_get_lock_name', args=[Argument(type='int', derefcnt=0, name='type')]),
 'CRYPTO_get_locked_mem_ex_functions': Function(type='void', derefcnt=0, name='CRYPTO_get_locked_mem_ex_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=0, name='f')]),
 'CRYPTO_get_locked_mem_functions': Function(type='void', derefcnt=0, name='CRYPTO_get_locked_mem_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=0, name='f')]),
 'CRYPTO_get_locking_callback': Function(type='void', derefcnt=0, name='CRYPTO_get_locking_callback', args=[]),
 'CRYPTO_get_mem_debug_functions': Function(type='void', derefcnt=0, name='CRYPTO_get_mem_debug_functions', args=[Argument(type='void', derefcnt=0, name='m'), Argument(type='void', derefcnt=0, name='r'), Argument(type='void', derefcnt=0, name='f'), Argument(type='void', derefcnt=0, name='so'), Argument(type='long', derefcnt=0, name='go')]),
 'CRYPTO_get_mem_debug_options': Function(type='long', derefcnt=0, name='CRYPTO_get_mem_debug_options', args=[]),
 'CRYPTO_get_mem_ex_functions': Function(type='void', derefcnt=0, name='CRYPTO_get_mem_ex_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=1, name='r'), Argument(type='void', derefcnt=0, name='f')]),
 'CRYPTO_get_mem_functions': Function(type='void', derefcnt=0, name='CRYPTO_get_mem_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=1, name='r'), Argument(type='void', derefcnt=0, name='f')]),
 'CRYPTO_get_new_dynlockid': Function(type='int', derefcnt=0, name='CRYPTO_get_new_dynlockid', args=[]),
 'CRYPTO_get_new_lockid': Function(type='int', derefcnt=0, name='CRYPTO_get_new_lockid', args=[Argument(type='char', derefcnt=1, name='name')]),
 'CRYPTO_is_mem_check_on': Function(type='int', derefcnt=0, name='CRYPTO_is_mem_check_on', args=[]),
 'CRYPTO_lock': Function(type='void', derefcnt=0, name='CRYPTO_lock', args=[Argument(type='int', derefcnt=0, name='mode'), Argument(type='int', derefcnt=0, name='type'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_malloc': Function(type='void', derefcnt=1, name='CRYPTO_malloc', args=[Argument(type='int', derefcnt=0, name='num'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_malloc_locked': Function(type='void', derefcnt=1, name='CRYPTO_malloc_locked', args=[Argument(type='int', derefcnt=0, name='num'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_mem_ctrl': Function(type='int', derefcnt=0, name='CRYPTO_mem_ctrl', args=[Argument(type='int', derefcnt=0, name='mode')]),
 'CRYPTO_mem_leaks': Function(type='void', derefcnt=0, name='CRYPTO_mem_leaks', args=[Argument(type='bio_st', derefcnt=1, name='bio')]),
 'CRYPTO_mem_leaks_cb': Function(type='void', derefcnt=0, name='CRYPTO_mem_leaks_cb', args=[Argument(type='CRYPTO_MEM_LEAK_CB', derefcnt=1, name='cb')]),
 'CRYPTO_mem_leaks_fp': Function(type='void', derefcnt=0, name='CRYPTO_mem_leaks_fp', args=[Argument(type='FILE', derefcnt=1, name='arg0')]),
 'CRYPTO_memcmp': Function(type='int', derefcnt=0, name='CRYPTO_memcmp', args=[Argument(type='void', derefcnt=1, name='a'), Argument(type='void', derefcnt=1, name='b'), Argument(type='size_t', derefcnt=0, name='len')]),
 'CRYPTO_new_ex_data': Function(type='int', derefcnt=0, name='CRYPTO_new_ex_data', args=[Argument(type='int', derefcnt=0, name='class_index'), Argument(type='void', derefcnt=1, name='obj'), Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='ad')]),
 'CRYPTO_num_locks': Function(type='int', derefcnt=0, name='CRYPTO_num_locks', args=[]),
 'CRYPTO_pop_info': Function(type='int', derefcnt=0, name='CRYPTO_pop_info', args=[]),
 'CRYPTO_push_info_': Function(type='int', derefcnt=0, name='CRYPTO_push_info_', args=[Argument(type='char', derefcnt=1, name='info'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_realloc': Function(type='void', derefcnt=1, name='CRYPTO_realloc', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='int', derefcnt=0, name='num'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_realloc_clean': Function(type='void', derefcnt=1, name='CRYPTO_realloc_clean', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='int', derefcnt=0, name='old_num'), Argument(type='int', derefcnt=0, name='num'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_remalloc': Function(type='void', derefcnt=1, name='CRYPTO_remalloc', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='int', derefcnt=0, name='num'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_remove_all_info': Function(type='int', derefcnt=0, name='CRYPTO_remove_all_info', args=[]),
 'CRYPTO_set_add_lock_callback': Function(type='void', derefcnt=0, name='CRYPTO_set_add_lock_callback', args=[Argument(type='int', derefcnt=0, name='func')]),
 'CRYPTO_set_dynlock_create_callback': Function(type='void', derefcnt=0, name='CRYPTO_set_dynlock_create_callback', args=[Argument(type='CRYPTO_dynlock_value', derefcnt=1, name='dyn_create_function')]),
 'CRYPTO_set_dynlock_destroy_callback': Function(type='void', derefcnt=0, name='CRYPTO_set_dynlock_destroy_callback', args=[Argument(type='void', derefcnt=0, name='dyn_destroy_function')]),
 'CRYPTO_set_dynlock_lock_callback': Function(type='void', derefcnt=0, name='CRYPTO_set_dynlock_lock_callback', args=[Argument(type='void', derefcnt=0, name='dyn_lock_function')]),
 'CRYPTO_set_ex_data': Function(type='int', derefcnt=0, name='CRYPTO_set_ex_data', args=[Argument(type='CRYPTO_EX_DATA', derefcnt=1, name='ad'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='val')]),
 'CRYPTO_set_ex_data_implementation': Function(type='int', derefcnt=0, name='CRYPTO_set_ex_data_implementation', args=[Argument(type='CRYPTO_EX_DATA_IMPL', derefcnt=1, name='i')]),
 'CRYPTO_set_id_callback': Function(type='void', derefcnt=0, name='CRYPTO_set_id_callback', args=[Argument(type='unsigned', derefcnt=0, name='func')]),
 'CRYPTO_set_locked_mem_ex_functions': Function(type='int', derefcnt=0, name='CRYPTO_set_locked_mem_ex_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=0, name='free_func')]),
 'CRYPTO_set_locked_mem_functions': Function(type='int', derefcnt=0, name='CRYPTO_set_locked_mem_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=0, name='free_func')]),
 'CRYPTO_set_locking_callback': Function(type='void', derefcnt=0, name='CRYPTO_set_locking_callback', args=[Argument(type='void', derefcnt=0, name='func')]),
 'CRYPTO_set_mem_debug_functions': Function(type='int', derefcnt=0, name='CRYPTO_set_mem_debug_functions', args=[Argument(type='void', derefcnt=0, name='m'), Argument(type='void', derefcnt=0, name='r'), Argument(type='void', derefcnt=0, name='f'), Argument(type='void', derefcnt=0, name='so'), Argument(type='long', derefcnt=0, name='go')]),
 'CRYPTO_set_mem_debug_options': Function(type='void', derefcnt=0, name='CRYPTO_set_mem_debug_options', args=[Argument(type='long', derefcnt=0, name='bits')]),
 'CRYPTO_set_mem_ex_functions': Function(type='int', derefcnt=0, name='CRYPTO_set_mem_ex_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=1, name='r'), Argument(type='void', derefcnt=0, name='f')]),
 'CRYPTO_set_mem_functions': Function(type='int', derefcnt=0, name='CRYPTO_set_mem_functions', args=[Argument(type='void', derefcnt=1, name='m'), Argument(type='void', derefcnt=1, name='r'), Argument(type='void', derefcnt=0, name='f')]),
 'CRYPTO_strdup': Function(type='char', derefcnt=1, name='CRYPTO_strdup', args=[Argument(type='char', derefcnt=1, name='str'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'CRYPTO_thread_id': Function(type='unsigned', derefcnt=0, name='CRYPTO_thread_id', args=[]),
 'DH_OpenSSL': Function(type='DH_METHOD', derefcnt=1, name='DH_OpenSSL', args=[]),
 'DH_check': Function(type='int', derefcnt=0, name='DH_check', args=[Argument(type='DH', derefcnt=1, name='dh'), Argument(type='int', derefcnt=1, name='codes')]),
 'DH_check_pub_key': Function(type='int', derefcnt=0, name='DH_check_pub_key', args=[Argument(type='DH', derefcnt=1, name='dh'), Argument(type='BIGNUM', derefcnt=1, name='pub_key'), Argument(type='int', derefcnt=1, name='codes')]),
 'DH_compute_key': Function(type='int', derefcnt=0, name='DH_compute_key', args=[Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='BIGNUM', derefcnt=1, name='pub_key'), Argument(type='DH', derefcnt=1, name='dh')]),
 'DH_free': Function(type='void', derefcnt=0, name='DH_free', args=[Argument(type='DH', derefcnt=1, name='dh')]),
 'DH_generate_key': Function(type='int', derefcnt=0, name='DH_generate_key', args=[Argument(type='DH', derefcnt=1, name='dh')]),
 'DH_generate_parameters': Function(type='DH', derefcnt=1, name='DH_generate_parameters', args=[Argument(type='int', derefcnt=0, name='prime_len'), Argument(type='int', derefcnt=0, name='generator'), Argument(type='void', derefcnt=0, name='callback'), Argument(type='void', derefcnt=1, name='cb_arg')]),
 'DH_generate_parameters_ex': Function(type='int', derefcnt=0, name='DH_generate_parameters_ex', args=[Argument(type='DH', derefcnt=1, name='dh'), Argument(type='int', derefcnt=0, name='prime_len'), Argument(type='int', derefcnt=0, name='generator'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'DH_get_default_method': Function(type='DH_METHOD', derefcnt=1, name='DH_get_default_method', args=[]),
 'DH_get_ex_data': Function(type='void', derefcnt=1, name='DH_get_ex_data', args=[Argument(type='DH', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx')]),
 'DH_get_ex_new_index': Function(type='int', derefcnt=0, name='DH_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'DH_new': Function(type='DH', derefcnt=1, name='DH_new', args=[]),
 'DH_new_method': Function(type='DH', derefcnt=1, name='DH_new_method', args=[Argument(type='ENGINE', derefcnt=1, name='engine')]),
 'DH_set_default_method': Function(type='void', derefcnt=0, name='DH_set_default_method', args=[Argument(type='DH_METHOD', derefcnt=1, name='meth')]),
 'DH_set_ex_data': Function(type='int', derefcnt=0, name='DH_set_ex_data', args=[Argument(type='DH', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='arg')]),
 'DH_set_method': Function(type='int', derefcnt=0, name='DH_set_method', args=[Argument(type='DH', derefcnt=1, name='dh'), Argument(type='DH_METHOD', derefcnt=1, name='meth')]),
 'DH_size': Function(type='int', derefcnt=0, name='DH_size', args=[Argument(type='DH', derefcnt=1, name='dh')]),
 'DH_up_ref': Function(type='int', derefcnt=0, name='DH_up_ref', args=[Argument(type='DH', derefcnt=1, name='dh')]),
 'DHparams_dup': Function(type='DH', derefcnt=1, name='DHparams_dup', args=[Argument(type='DH', derefcnt=1, name='arg0')]),
 'DHparams_print': Function(type='int', derefcnt=0, name='DHparams_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DH', derefcnt=1, name='x')]),
 'DHparams_print_fp': Function(type='int', derefcnt=0, name='DHparams_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DH', derefcnt=1, name='x')]),
 'DIRECTORYSTRING_free': Function(type='void', derefcnt=0, name='DIRECTORYSTRING_free', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a')]),
 'DIRECTORYSTRING_new': Function(type='ASN1_STRING', derefcnt=1, name='DIRECTORYSTRING_new', args=[]),
 'DISPLAYTEXT_free': Function(type='void', derefcnt=0, name='DISPLAYTEXT_free', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a')]),
 'DISPLAYTEXT_new': Function(type='ASN1_STRING', derefcnt=1, name='DISPLAYTEXT_new', args=[]),
 'DSA_OpenSSL': Function(type='DSA_METHOD', derefcnt=1, name='DSA_OpenSSL', args=[]),
 'DSA_SIG_free': Function(type='void', derefcnt=0, name='DSA_SIG_free', args=[Argument(type='DSA_SIG', derefcnt=1, name='a')]),
 'DSA_SIG_new': Function(type='DSA_SIG', derefcnt=1, name='DSA_SIG_new', args=[]),
 'DSA_do_sign': Function(type='DSA_SIG', derefcnt=1, name='DSA_do_sign', args=[Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dlen'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'DSA_do_verify': Function(type='int', derefcnt=0, name='DSA_do_verify', args=[Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgst_len'), Argument(type='DSA_SIG', derefcnt=1, name='sig'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'DSA_dup_DH': Function(type='DH', derefcnt=1, name='DSA_dup_DH', args=[Argument(type='DSA', derefcnt=1, name='r')]),
 'DSA_free': Function(type='void', derefcnt=0, name='DSA_free', args=[Argument(type='DSA', derefcnt=1, name='r')]),
 'DSA_generate_key': Function(type='int', derefcnt=0, name='DSA_generate_key', args=[Argument(type='DSA', derefcnt=1, name='a')]),
 'DSA_generate_parameters': Function(type='DSA', derefcnt=1, name='DSA_generate_parameters', args=[Argument(type='int', derefcnt=0, name='bits'), Argument(type='unsigned', derefcnt=1, name='seed'), Argument(type='int', derefcnt=0, name='seed_len'), Argument(type='int', derefcnt=1, name='counter_ret'), Argument(type='unsigned', derefcnt=1, name='h_ret'), Argument(type='void', derefcnt=0, name='callback'), Argument(type='void', derefcnt=1, name='cb_arg')]),
 'DSA_generate_parameters_ex': Function(type='int', derefcnt=0, name='DSA_generate_parameters_ex', args=[Argument(type='DSA', derefcnt=1, name='dsa'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='unsigned', derefcnt=1, name='seed'), Argument(type='int', derefcnt=0, name='seed_len'), Argument(type='int', derefcnt=1, name='counter_ret'), Argument(type='unsigned', derefcnt=1, name='h_ret'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'DSA_get_default_method': Function(type='DSA_METHOD', derefcnt=1, name='DSA_get_default_method', args=[]),
 'DSA_get_ex_data': Function(type='void', derefcnt=1, name='DSA_get_ex_data', args=[Argument(type='DSA', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx')]),
 'DSA_get_ex_new_index': Function(type='int', derefcnt=0, name='DSA_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'DSA_new': Function(type='DSA', derefcnt=1, name='DSA_new', args=[]),
 'DSA_new_method': Function(type='DSA', derefcnt=1, name='DSA_new_method', args=[Argument(type='ENGINE', derefcnt=1, name='engine')]),
 'DSA_print': Function(type='int', derefcnt=0, name='DSA_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='off')]),
 'DSA_print_fp': Function(type='int', derefcnt=0, name='DSA_print_fp', args=[Argument(type='FILE', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='off')]),
 'DSA_set_default_method': Function(type='void', derefcnt=0, name='DSA_set_default_method', args=[Argument(type='DSA_METHOD', derefcnt=1, name='arg0')]),
 'DSA_set_ex_data': Function(type='int', derefcnt=0, name='DSA_set_ex_data', args=[Argument(type='DSA', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='arg')]),
 'DSA_set_method': Function(type='int', derefcnt=0, name='DSA_set_method', args=[Argument(type='DSA', derefcnt=1, name='dsa'), Argument(type='DSA_METHOD', derefcnt=1, name='arg1')]),
 'DSA_sign': Function(type='int', derefcnt=0, name='DSA_sign', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dlen'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'DSA_sign_setup': Function(type='int', derefcnt=0, name='DSA_sign_setup', args=[Argument(type='DSA', derefcnt=1, name='dsa'), Argument(type='BN_CTX', derefcnt=1, name='ctx_in'), Argument(type='BIGNUM', derefcnt=2, name='kinvp'), Argument(type='BIGNUM', derefcnt=2, name='rp')]),
 'DSA_size': Function(type='int', derefcnt=0, name='DSA_size', args=[Argument(type='DSA', derefcnt=1, name='arg0')]),
 'DSA_up_ref': Function(type='int', derefcnt=0, name='DSA_up_ref', args=[Argument(type='DSA', derefcnt=1, name='r')]),
 'DSA_verify': Function(type='int', derefcnt=0, name='DSA_verify', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgst_len'), Argument(type='unsigned', derefcnt=1, name='sigbuf'), Argument(type='int', derefcnt=0, name='siglen'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'DSAparams_dup': Function(type='DSA', derefcnt=1, name='DSAparams_dup', args=[Argument(type='DSA', derefcnt=1, name='x')]),
 'DSAparams_print': Function(type='int', derefcnt=0, name='DSAparams_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='x')]),
 'DSAparams_print_fp': Function(type='int', derefcnt=0, name='DSAparams_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=1, name='x')]),
 'DTLSv1_client_method': Function(type='SSL_METHOD', derefcnt=1, name='DTLSv1_client_method', args=[]),
 'DTLSv1_method': Function(type='SSL_METHOD', derefcnt=1, name='DTLSv1_method', args=[]),
 'DTLSv1_server_method': Function(type='SSL_METHOD', derefcnt=1, name='DTLSv1_server_method', args=[]),
 'ECDH_OpenSSL': Function(type='ECDH_METHOD', derefcnt=1, name='ECDH_OpenSSL', args=[]),
 'ECDH_compute_key': Function(type='int', derefcnt=0, name='ECDH_compute_key', args=[Argument(type='void', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=0, name='outlen'), Argument(type='EC_POINT', derefcnt=1, name='pub_key'), Argument(type='EC_KEY', derefcnt=1, name='ecdh'), Argument(type='void', derefcnt=1, name='KDF')]),
 'ECDH_get_default_method': Function(type='ECDH_METHOD', derefcnt=1, name='ECDH_get_default_method', args=[]),
 'ECDH_get_ex_data': Function(type='void', derefcnt=1, name='ECDH_get_ex_data', args=[Argument(type='EC_KEY', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx')]),
 'ECDH_get_ex_new_index': Function(type='int', derefcnt=0, name='ECDH_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'ECDH_set_default_method': Function(type='void', derefcnt=0, name='ECDH_set_default_method', args=[Argument(type='ECDH_METHOD', derefcnt=1, name='arg0')]),
 'ECDH_set_ex_data': Function(type='int', derefcnt=0, name='ECDH_set_ex_data', args=[Argument(type='EC_KEY', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='arg')]),
 'ECDH_set_method': Function(type='int', derefcnt=0, name='ECDH_set_method', args=[Argument(type='EC_KEY', derefcnt=1, name='arg0'), Argument(type='ECDH_METHOD', derefcnt=1, name='arg1')]),
 'ECDSA_OpenSSL': Function(type='ECDSA_METHOD', derefcnt=1, name='ECDSA_OpenSSL', args=[]),
 'ECDSA_SIG_free': Function(type='void', derefcnt=0, name='ECDSA_SIG_free', args=[Argument(type='ECDSA_SIG', derefcnt=1, name='sig')]),
 'ECDSA_SIG_new': Function(type='ECDSA_SIG', derefcnt=1, name='ECDSA_SIG_new', args=[]),
 'ECDSA_do_sign': Function(type='ECDSA_SIG', derefcnt=1, name='ECDSA_do_sign', args=[Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgst_len'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'ECDSA_do_sign_ex': Function(type='ECDSA_SIG', derefcnt=1, name='ECDSA_do_sign_ex', args=[Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgstlen'), Argument(type='BIGNUM', derefcnt=1, name='kinv'), Argument(type='BIGNUM', derefcnt=1, name='rp'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'ECDSA_do_verify': Function(type='int', derefcnt=0, name='ECDSA_do_verify', args=[Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgst_len'), Argument(type='ECDSA_SIG', derefcnt=1, name='sig'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'ECDSA_get_default_method': Function(type='ECDSA_METHOD', derefcnt=1, name='ECDSA_get_default_method', args=[]),
 'ECDSA_get_ex_data': Function(type='void', derefcnt=1, name='ECDSA_get_ex_data', args=[Argument(type='EC_KEY', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx')]),
 'ECDSA_get_ex_new_index': Function(type='int', derefcnt=0, name='ECDSA_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'ECDSA_set_default_method': Function(type='void', derefcnt=0, name='ECDSA_set_default_method', args=[Argument(type='ECDSA_METHOD', derefcnt=1, name='meth')]),
 'ECDSA_set_ex_data': Function(type='int', derefcnt=0, name='ECDSA_set_ex_data', args=[Argument(type='EC_KEY', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='arg')]),
 'ECDSA_set_method': Function(type='int', derefcnt=0, name='ECDSA_set_method', args=[Argument(type='EC_KEY', derefcnt=1, name='eckey'), Argument(type='ECDSA_METHOD', derefcnt=1, name='meth')]),
 'ECDSA_sign': Function(type='int', derefcnt=0, name='ECDSA_sign', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgstlen'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'ECDSA_sign_ex': Function(type='int', derefcnt=0, name='ECDSA_sign_ex', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgstlen'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='BIGNUM', derefcnt=1, name='kinv'), Argument(type='BIGNUM', derefcnt=1, name='rp'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'ECDSA_sign_setup': Function(type='int', derefcnt=0, name='ECDSA_sign_setup', args=[Argument(type='EC_KEY', derefcnt=1, name='eckey'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BIGNUM', derefcnt=2, name='kinv'), Argument(type='BIGNUM', derefcnt=2, name='rp')]),
 'ECDSA_size': Function(type='int', derefcnt=0, name='ECDSA_size', args=[Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'ECDSA_verify': Function(type='int', derefcnt=0, name='ECDSA_verify', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgstlen'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='int', derefcnt=0, name='siglen'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'ECPKParameters_print': Function(type='int', derefcnt=0, name='ECPKParameters_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_GROUP', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='off')]),
 'ECPKParameters_print_fp': Function(type='int', derefcnt=0, name='ECPKParameters_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_GROUP', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='off')]),
 'ECParameters_print': Function(type='int', derefcnt=0, name='ECParameters_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'ECParameters_print_fp': Function(type='int', derefcnt=0, name='ECParameters_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_GF2m_simple_method': Function(type='EC_METHOD', derefcnt=1, name='EC_GF2m_simple_method', args=[]),
 'EC_GFp_mont_method': Function(type='EC_METHOD', derefcnt=1, name='EC_GFp_mont_method', args=[]),
 'EC_GFp_nist_method': Function(type='EC_METHOD', derefcnt=1, name='EC_GFp_nist_method', args=[]),
 'EC_GFp_nistp224_method': Function(type='EC_METHOD', derefcnt=1, name='EC_GFp_nistp224_method', args=[]),
 'EC_GFp_nistp256_method': Function(type='EC_METHOD', derefcnt=1, name='EC_GFp_nistp256_method', args=[]),
 'EC_GFp_nistp521_method': Function(type='EC_METHOD', derefcnt=1, name='EC_GFp_nistp521_method', args=[]),
 'EC_GFp_simple_method': Function(type='EC_METHOD', derefcnt=1, name='EC_GFp_simple_method', args=[]),
 'EC_GROUP_check': Function(type='int', derefcnt=0, name='EC_GROUP_check', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_check_discriminant': Function(type='int', derefcnt=0, name='EC_GROUP_check_discriminant', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_clear_free': Function(type='void', derefcnt=0, name='EC_GROUP_clear_free', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_cmp': Function(type='int', derefcnt=0, name='EC_GROUP_cmp', args=[Argument(type='EC_GROUP', derefcnt=1, name='a'), Argument(type='EC_GROUP', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_copy': Function(type='int', derefcnt=0, name='EC_GROUP_copy', args=[Argument(type='EC_GROUP', derefcnt=1, name='dst'), Argument(type='EC_GROUP', derefcnt=1, name='src')]),
 'EC_GROUP_dup': Function(type='EC_GROUP', derefcnt=1, name='EC_GROUP_dup', args=[Argument(type='EC_GROUP', derefcnt=1, name='src')]),
 'EC_GROUP_free': Function(type='void', derefcnt=0, name='EC_GROUP_free', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_get0_generator': Function(type='EC_POINT', derefcnt=1, name='EC_GROUP_get0_generator', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_get0_seed': Function(type='unsigned', derefcnt=1, name='EC_GROUP_get0_seed', args=[Argument(type='EC_GROUP', derefcnt=1, name='x')]),
 'EC_GROUP_get_asn1_flag': Function(type='int', derefcnt=0, name='EC_GROUP_get_asn1_flag', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_get_basis_type': Function(type='int', derefcnt=0, name='EC_GROUP_get_basis_type', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0')]),
 'EC_GROUP_get_cofactor': Function(type='int', derefcnt=0, name='EC_GROUP_get_cofactor', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BIGNUM', derefcnt=1, name='cofactor'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_get_curve_GF2m': Function(type='int', derefcnt=0, name='EC_GROUP_get_curve_GF2m', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_get_curve_GFp': Function(type='int', derefcnt=0, name='EC_GROUP_get_curve_GFp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_get_curve_name': Function(type='int', derefcnt=0, name='EC_GROUP_get_curve_name', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_get_degree': Function(type='int', derefcnt=0, name='EC_GROUP_get_degree', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_get_order': Function(type='int', derefcnt=0, name='EC_GROUP_get_order', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BIGNUM', derefcnt=1, name='order'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_get_pentanomial_basis': Function(type='int', derefcnt=0, name='EC_GROUP_get_pentanomial_basis', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=1, name='k1'), Argument(type='unsigned', derefcnt=1, name='k2'), Argument(type='unsigned', derefcnt=1, name='k3')]),
 'EC_GROUP_get_point_conversion_form': Function(type='point_conversion_form_t', derefcnt=0, name='EC_GROUP_get_point_conversion_form', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0')]),
 'EC_GROUP_get_seed_len': Function(type='size_t', derefcnt=0, name='EC_GROUP_get_seed_len', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0')]),
 'EC_GROUP_get_trinomial_basis': Function(type='int', derefcnt=0, name='EC_GROUP_get_trinomial_basis', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=1, name='k')]),
 'EC_GROUP_have_precompute_mult': Function(type='int', derefcnt=0, name='EC_GROUP_have_precompute_mult', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_method_of': Function(type='EC_METHOD', derefcnt=1, name='EC_GROUP_method_of', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_GROUP_new': Function(type='EC_GROUP', derefcnt=1, name='EC_GROUP_new', args=[Argument(type='EC_METHOD', derefcnt=1, name='meth')]),
 'EC_GROUP_new_by_curve_name': Function(type='EC_GROUP', derefcnt=1, name='EC_GROUP_new_by_curve_name', args=[Argument(type='int', derefcnt=0, name='nid')]),
 'EC_GROUP_new_curve_GF2m': Function(type='EC_GROUP', derefcnt=1, name='EC_GROUP_new_curve_GF2m', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_new_curve_GFp': Function(type='EC_GROUP', derefcnt=1, name='EC_GROUP_new_curve_GFp', args=[Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_precompute_mult': Function(type='int', derefcnt=0, name='EC_GROUP_precompute_mult', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_set_asn1_flag': Function(type='void', derefcnt=0, name='EC_GROUP_set_asn1_flag', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='int', derefcnt=0, name='flag')]),
 'EC_GROUP_set_curve_GF2m': Function(type='int', derefcnt=0, name='EC_GROUP_set_curve_GF2m', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_set_curve_GFp': Function(type='int', derefcnt=0, name='EC_GROUP_set_curve_GFp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_GROUP_set_curve_name': Function(type='void', derefcnt=0, name='EC_GROUP_set_curve_name', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='int', derefcnt=0, name='nid')]),
 'EC_GROUP_set_generator': Function(type='int', derefcnt=0, name='EC_GROUP_set_generator', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='generator'), Argument(type='BIGNUM', derefcnt=1, name='order'), Argument(type='BIGNUM', derefcnt=1, name='cofactor')]),
 'EC_GROUP_set_point_conversion_form': Function(type='void', derefcnt=0, name='EC_GROUP_set_point_conversion_form', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='point_conversion_form_t', derefcnt=0, name='form')]),
 'EC_GROUP_set_seed': Function(type='size_t', derefcnt=0, name='EC_GROUP_set_seed', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='len')]),
 'EC_KEY_check_key': Function(type='int', derefcnt=0, name='EC_KEY_check_key', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_clear_flags': Function(type='void', derefcnt=0, name='EC_KEY_clear_flags', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='flags')]),
 'EC_KEY_copy': Function(type='EC_KEY', derefcnt=1, name='EC_KEY_copy', args=[Argument(type='EC_KEY', derefcnt=1, name='dst'), Argument(type='EC_KEY', derefcnt=1, name='src')]),
 'EC_KEY_dup': Function(type='EC_KEY', derefcnt=1, name='EC_KEY_dup', args=[Argument(type='EC_KEY', derefcnt=1, name='src')]),
 'EC_KEY_free': Function(type='void', derefcnt=0, name='EC_KEY_free', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_generate_key': Function(type='int', derefcnt=0, name='EC_KEY_generate_key', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_get0_group': Function(type='EC_GROUP', derefcnt=1, name='EC_KEY_get0_group', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_get0_private_key': Function(type='BIGNUM', derefcnt=1, name='EC_KEY_get0_private_key', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_get0_public_key': Function(type='EC_POINT', derefcnt=1, name='EC_KEY_get0_public_key', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_get_conv_form': Function(type='point_conversion_form_t', derefcnt=0, name='EC_KEY_get_conv_form', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_get_enc_flags': Function(type='unsigned', derefcnt=0, name='EC_KEY_get_enc_flags', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_get_flags': Function(type='int', derefcnt=0, name='EC_KEY_get_flags', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_KEY_get_key_method_data': Function(type='void', derefcnt=1, name='EC_KEY_get_key_method_data', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='void', derefcnt=1, name='dup_func'), Argument(type='void', derefcnt=0, name='free_func'), Argument(type='void', derefcnt=0, name='clear_free_func')]),
 'EC_KEY_insert_key_method_data': Function(type='void', derefcnt=1, name='EC_KEY_insert_key_method_data', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='void', derefcnt=1, name='data'), Argument(type='void', derefcnt=1, name='dup_func'), Argument(type='void', derefcnt=0, name='free_func'), Argument(type='void', derefcnt=0, name='clear_free_func')]),
 'EC_KEY_new': Function(type='EC_KEY', derefcnt=1, name='EC_KEY_new', args=[]),
 'EC_KEY_new_by_curve_name': Function(type='EC_KEY', derefcnt=1, name='EC_KEY_new_by_curve_name', args=[Argument(type='int', derefcnt=0, name='nid')]),
 'EC_KEY_precompute_mult': Function(type='int', derefcnt=0, name='EC_KEY_precompute_mult', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_KEY_print': Function(type='int', derefcnt=0, name='EC_KEY_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='off')]),
 'EC_KEY_print_fp': Function(type='int', derefcnt=0, name='EC_KEY_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='off')]),
 'EC_KEY_set_asn1_flag': Function(type='void', derefcnt=0, name='EC_KEY_set_asn1_flag', args=[Argument(type='EC_KEY', derefcnt=1, name='eckey'), Argument(type='int', derefcnt=0, name='asn1_flag')]),
 'EC_KEY_set_conv_form': Function(type='void', derefcnt=0, name='EC_KEY_set_conv_form', args=[Argument(type='EC_KEY', derefcnt=1, name='eckey'), Argument(type='point_conversion_form_t', derefcnt=0, name='cform')]),
 'EC_KEY_set_enc_flags': Function(type='void', derefcnt=0, name='EC_KEY_set_enc_flags', args=[Argument(type='EC_KEY', derefcnt=1, name='eckey'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'EC_KEY_set_flags': Function(type='void', derefcnt=0, name='EC_KEY_set_flags', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='flags')]),
 'EC_KEY_set_group': Function(type='int', derefcnt=0, name='EC_KEY_set_group', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_KEY_set_private_key': Function(type='int', derefcnt=0, name='EC_KEY_set_private_key', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='BIGNUM', derefcnt=1, name='prv')]),
 'EC_KEY_set_public_key': Function(type='int', derefcnt=0, name='EC_KEY_set_public_key', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='EC_POINT', derefcnt=1, name='pub')]),
 'EC_KEY_set_public_key_affine_coordinates': Function(type='int', derefcnt=0, name='EC_KEY_set_public_key_affine_coordinates', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y')]),
 'EC_KEY_up_ref': Function(type='int', derefcnt=0, name='EC_KEY_up_ref', args=[Argument(type='EC_KEY', derefcnt=1, name='key')]),
 'EC_METHOD_get_field_type': Function(type='int', derefcnt=0, name='EC_METHOD_get_field_type', args=[Argument(type='EC_METHOD', derefcnt=1, name='meth')]),
 'EC_POINT_add': Function(type='int', derefcnt=0, name='EC_POINT_add', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='r'), Argument(type='EC_POINT', derefcnt=1, name='a'), Argument(type='EC_POINT', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_bn2point': Function(type='EC_POINT', derefcnt=1, name='EC_POINT_bn2point', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='BIGNUM', derefcnt=1, name='arg1'), Argument(type='EC_POINT', derefcnt=1, name='arg2'), Argument(type='BN_CTX', derefcnt=1, name='arg3')]),
 'EC_POINT_clear_free': Function(type='void', derefcnt=0, name='EC_POINT_clear_free', args=[Argument(type='EC_POINT', derefcnt=1, name='point')]),
 'EC_POINT_cmp': Function(type='int', derefcnt=0, name='EC_POINT_cmp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='a'), Argument(type='EC_POINT', derefcnt=1, name='b'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_copy': Function(type='int', derefcnt=0, name='EC_POINT_copy', args=[Argument(type='EC_POINT', derefcnt=1, name='dst'), Argument(type='EC_POINT', derefcnt=1, name='src')]),
 'EC_POINT_dbl': Function(type='int', derefcnt=0, name='EC_POINT_dbl', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='r'), Argument(type='EC_POINT', derefcnt=1, name='a'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_dup': Function(type='EC_POINT', derefcnt=1, name='EC_POINT_dup', args=[Argument(type='EC_POINT', derefcnt=1, name='src'), Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_POINT_free': Function(type='void', derefcnt=0, name='EC_POINT_free', args=[Argument(type='EC_POINT', derefcnt=1, name='point')]),
 'EC_POINT_get_Jprojective_coordinates_GFp': Function(type='int', derefcnt=0, name='EC_POINT_get_Jprojective_coordinates_GFp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y'), Argument(type='BIGNUM', derefcnt=1, name='z'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_get_affine_coordinates_GF2m': Function(type='int', derefcnt=0, name='EC_POINT_get_affine_coordinates_GF2m', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_get_affine_coordinates_GFp': Function(type='int', derefcnt=0, name='EC_POINT_get_affine_coordinates_GFp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_hex2point': Function(type='EC_POINT', derefcnt=1, name='EC_POINT_hex2point', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='EC_POINT', derefcnt=1, name='arg2'), Argument(type='BN_CTX', derefcnt=1, name='arg3')]),
 'EC_POINT_invert': Function(type='int', derefcnt=0, name='EC_POINT_invert', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='a'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_is_at_infinity': Function(type='int', derefcnt=0, name='EC_POINT_is_at_infinity', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p')]),
 'EC_POINT_is_on_curve': Function(type='int', derefcnt=0, name='EC_POINT_is_on_curve', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='point'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_make_affine': Function(type='int', derefcnt=0, name='EC_POINT_make_affine', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='point'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_method_of': Function(type='EC_METHOD', derefcnt=1, name='EC_POINT_method_of', args=[Argument(type='EC_POINT', derefcnt=1, name='point')]),
 'EC_POINT_mul': Function(type='int', derefcnt=0, name='EC_POINT_mul', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='EC_POINT', derefcnt=1, name='q'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_new': Function(type='EC_POINT', derefcnt=1, name='EC_POINT_new', args=[Argument(type='EC_GROUP', derefcnt=1, name='group')]),
 'EC_POINT_oct2point': Function(type='int', derefcnt=0, name='EC_POINT_oct2point', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='unsigned', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_point2bn': Function(type='BIGNUM', derefcnt=1, name='EC_POINT_point2bn', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='EC_POINT', derefcnt=1, name='arg1'), Argument(type='point_conversion_form_t', derefcnt=0, name='form'), Argument(type='BIGNUM', derefcnt=1, name='arg3'), Argument(type='BN_CTX', derefcnt=1, name='arg4')]),
 'EC_POINT_point2hex': Function(type='char', derefcnt=1, name='EC_POINT_point2hex', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='EC_POINT', derefcnt=1, name='arg1'), Argument(type='point_conversion_form_t', derefcnt=0, name='form'), Argument(type='BN_CTX', derefcnt=1, name='arg3')]),
 'EC_POINT_point2oct': Function(type='size_t', derefcnt=0, name='EC_POINT_point2oct', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='point_conversion_form_t', derefcnt=0, name='form'), Argument(type='unsigned', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_set_Jprojective_coordinates_GFp': Function(type='int', derefcnt=0, name='EC_POINT_set_Jprojective_coordinates_GFp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y'), Argument(type='BIGNUM', derefcnt=1, name='z'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_set_affine_coordinates_GF2m': Function(type='int', derefcnt=0, name='EC_POINT_set_affine_coordinates_GF2m', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_set_affine_coordinates_GFp': Function(type='int', derefcnt=0, name='EC_POINT_set_affine_coordinates_GFp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='BIGNUM', derefcnt=1, name='y'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_set_compressed_coordinates_GF2m': Function(type='int', derefcnt=0, name='EC_POINT_set_compressed_coordinates_GF2m', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='y_bit'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_set_compressed_coordinates_GFp': Function(type='int', derefcnt=0, name='EC_POINT_set_compressed_coordinates_GFp', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='y_bit'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINT_set_to_infinity': Function(type='int', derefcnt=0, name='EC_POINT_set_to_infinity', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='point')]),
 'EC_POINTs_make_affine': Function(type='int', derefcnt=0, name='EC_POINTs_make_affine', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='size_t', derefcnt=0, name='num'), Argument(type='EC_POINT', derefcnt=2, name='points'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_POINTs_mul': Function(type='int', derefcnt=0, name='EC_POINTs_mul', args=[Argument(type='EC_GROUP', derefcnt=1, name='group'), Argument(type='EC_POINT', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='n'), Argument(type='size_t', derefcnt=0, name='num'), Argument(type='EC_POINT', derefcnt=2, name='p'), Argument(type='BIGNUM', derefcnt=2, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'EC_get_builtin_curves': Function(type='size_t', derefcnt=0, name='EC_get_builtin_curves', args=[Argument(type='EC_builtin_curve', derefcnt=1, name='r'), Argument(type='size_t', derefcnt=0, name='nitems')]),
 'ERR_load_ASN1_strings': Function(type='void', derefcnt=0, name='ERR_load_ASN1_strings', args=[]),
 'ERR_load_BIO_strings': Function(type='void', derefcnt=0, name='ERR_load_BIO_strings', args=[]),
 'ERR_load_BN_strings': Function(type='void', derefcnt=0, name='ERR_load_BN_strings', args=[]),
 'ERR_load_BUF_strings': Function(type='void', derefcnt=0, name='ERR_load_BUF_strings', args=[]),
 'ERR_load_COMP_strings': Function(type='void', derefcnt=0, name='ERR_load_COMP_strings', args=[]),
 'ERR_load_CRYPTO_strings': Function(type='void', derefcnt=0, name='ERR_load_CRYPTO_strings', args=[]),
 'ERR_load_DH_strings': Function(type='void', derefcnt=0, name='ERR_load_DH_strings', args=[]),
 'ERR_load_DSA_strings': Function(type='void', derefcnt=0, name='ERR_load_DSA_strings', args=[]),
 'ERR_load_ECDH_strings': Function(type='void', derefcnt=0, name='ERR_load_ECDH_strings', args=[]),
 'ERR_load_ECDSA_strings': Function(type='void', derefcnt=0, name='ERR_load_ECDSA_strings', args=[]),
 'ERR_load_EC_strings': Function(type='void', derefcnt=0, name='ERR_load_EC_strings', args=[]),
 'ERR_load_EVP_strings': Function(type='void', derefcnt=0, name='ERR_load_EVP_strings', args=[]),
 'ERR_load_OBJ_strings': Function(type='void', derefcnt=0, name='ERR_load_OBJ_strings', args=[]),
 'ERR_load_PEM_strings': Function(type='void', derefcnt=0, name='ERR_load_PEM_strings', args=[]),
 'ERR_load_PKCS7_strings': Function(type='void', derefcnt=0, name='ERR_load_PKCS7_strings', args=[]),
 'ERR_load_RSA_strings': Function(type='void', derefcnt=0, name='ERR_load_RSA_strings', args=[]),
 'ERR_load_SSL_strings': Function(type='void', derefcnt=0, name='ERR_load_SSL_strings', args=[]),
 'ERR_load_X509_strings': Function(type='void', derefcnt=0, name='ERR_load_X509_strings', args=[]),
 'EVP_BytesToKey': Function(type='int', derefcnt=0, name='EVP_BytesToKey', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='type'), Argument(type='EVP_MD', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='datal'), Argument(type='int', derefcnt=0, name='count'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=1, name='iv')]),
 'EVP_CIPHER_CTX_block_size': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_block_size', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx')]),
 'EVP_CIPHER_CTX_cipher': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_CIPHER_CTX_cipher', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx')]),
 'EVP_CIPHER_CTX_cleanup': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_cleanup', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='a')]),
 'EVP_CIPHER_CTX_clear_flags': Function(type='void', derefcnt=0, name='EVP_CIPHER_CTX_clear_flags', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='flags')]),
 'EVP_CIPHER_CTX_copy': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_copy', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='out'), Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='in')]),
 'EVP_CIPHER_CTX_ctrl': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_ctrl', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='arg'), Argument(type='void', derefcnt=1, name='ptr')]),
 'EVP_CIPHER_CTX_flags': Function(type='unsigned', derefcnt=0, name='EVP_CIPHER_CTX_flags', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx')]),
 'EVP_CIPHER_CTX_free': Function(type='void', derefcnt=0, name='EVP_CIPHER_CTX_free', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='a')]),
 'EVP_CIPHER_CTX_get_app_data': Function(type='void', derefcnt=1, name='EVP_CIPHER_CTX_get_app_data', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx')]),
 'EVP_CIPHER_CTX_init': Function(type='void', derefcnt=0, name='EVP_CIPHER_CTX_init', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='a')]),
 'EVP_CIPHER_CTX_iv_length': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_iv_length', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx')]),
 'EVP_CIPHER_CTX_key_length': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_key_length', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx')]),
 'EVP_CIPHER_CTX_new': Function(type='EVP_CIPHER_CTX', derefcnt=1, name='EVP_CIPHER_CTX_new', args=[]),
 'EVP_CIPHER_CTX_nid': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_nid', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx')]),
 'EVP_CIPHER_CTX_rand_key': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_rand_key', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='key')]),
 'EVP_CIPHER_CTX_set_app_data': Function(type='void', derefcnt=0, name='EVP_CIPHER_CTX_set_app_data', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='data')]),
 'EVP_CIPHER_CTX_set_flags': Function(type='void', derefcnt=0, name='EVP_CIPHER_CTX_set_flags', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='flags')]),
 'EVP_CIPHER_CTX_set_key_length': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_set_key_length', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='keylen')]),
 'EVP_CIPHER_CTX_set_padding': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_set_padding', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='c'), Argument(type='int', derefcnt=0, name='pad')]),
 'EVP_CIPHER_CTX_test_flags': Function(type='int', derefcnt=0, name='EVP_CIPHER_CTX_test_flags', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='flags')]),
 'EVP_CIPHER_asn1_to_param': Function(type='int', derefcnt=0, name='EVP_CIPHER_asn1_to_param', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='c'), Argument(type='ASN1_TYPE', derefcnt=1, name='type')]),
 'EVP_CIPHER_block_size': Function(type='int', derefcnt=0, name='EVP_CIPHER_block_size', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher')]),
 'EVP_CIPHER_do_all': Function(type='void', derefcnt=0, name='EVP_CIPHER_do_all', args=[Argument(type='void', derefcnt=0, name='fn'), Argument(type='void', derefcnt=1, name='arg')]),
 'EVP_CIPHER_do_all_sorted': Function(type='void', derefcnt=0, name='EVP_CIPHER_do_all_sorted', args=[Argument(type='void', derefcnt=0, name='fn'), Argument(type='void', derefcnt=1, name='arg')]),
 'EVP_CIPHER_flags': Function(type='unsigned', derefcnt=0, name='EVP_CIPHER_flags', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher')]),
 'EVP_CIPHER_get_asn1_iv': Function(type='int', derefcnt=0, name='EVP_CIPHER_get_asn1_iv', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='c'), Argument(type='ASN1_TYPE', derefcnt=1, name='type')]),
 'EVP_CIPHER_iv_length': Function(type='int', derefcnt=0, name='EVP_CIPHER_iv_length', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher')]),
 'EVP_CIPHER_key_length': Function(type='int', derefcnt=0, name='EVP_CIPHER_key_length', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher')]),
 'EVP_CIPHER_nid': Function(type='int', derefcnt=0, name='EVP_CIPHER_nid', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher')]),
 'EVP_CIPHER_param_to_asn1': Function(type='int', derefcnt=0, name='EVP_CIPHER_param_to_asn1', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='c'), Argument(type='ASN1_TYPE', derefcnt=1, name='type')]),
 'EVP_CIPHER_set_asn1_iv': Function(type='int', derefcnt=0, name='EVP_CIPHER_set_asn1_iv', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='c'), Argument(type='ASN1_TYPE', derefcnt=1, name='type')]),
 'EVP_CIPHER_type': Function(type='int', derefcnt=0, name='EVP_CIPHER_type', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='ctx')]),
 'EVP_Cipher': Function(type='int', derefcnt=0, name='EVP_Cipher', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='c'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='unsigned', derefcnt=0, name='inl')]),
 'EVP_CipherFinal': Function(type='int', derefcnt=0, name='EVP_CipherFinal', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='outm'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_CipherFinal_ex': Function(type='int', derefcnt=0, name='EVP_CipherFinal_ex', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='outm'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_CipherInit': Function(type='int', derefcnt=0, name='EVP_CipherInit', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=1, name='iv'), Argument(type='int', derefcnt=0, name='enc')]),
 'EVP_CipherInit_ex': Function(type='int', derefcnt=0, name='EVP_CipherInit_ex', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='ENGINE', derefcnt=1, name='impl'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=1, name='iv'), Argument(type='int', derefcnt=0, name='enc')]),
 'EVP_CipherUpdate': Function(type='int', derefcnt=0, name='EVP_CipherUpdate', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='inl')]),
 'EVP_DecodeBlock': Function(type='int', derefcnt=0, name='EVP_DecodeBlock', args=[Argument(type='unsigned', derefcnt=1, name='t'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='n')]),
 'EVP_DecodeFinal': Function(type='int', derefcnt=0, name='EVP_DecodeFinal', args=[Argument(type='EVP_ENCODE_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_DecodeInit': Function(type='void', derefcnt=0, name='EVP_DecodeInit', args=[Argument(type='EVP_ENCODE_CTX', derefcnt=1, name='ctx')]),
 'EVP_DecodeUpdate': Function(type='int', derefcnt=0, name='EVP_DecodeUpdate', args=[Argument(type='EVP_ENCODE_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='inl')]),
 'EVP_DecryptFinal': Function(type='int', derefcnt=0, name='EVP_DecryptFinal', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='outm'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_DecryptFinal_ex': Function(type='int', derefcnt=0, name='EVP_DecryptFinal_ex', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='outm'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_DecryptInit': Function(type='int', derefcnt=0, name='EVP_DecryptInit', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=1, name='iv')]),
 'EVP_DecryptInit_ex': Function(type='int', derefcnt=0, name='EVP_DecryptInit_ex', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='ENGINE', derefcnt=1, name='impl'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=1, name='iv')]),
 'EVP_DecryptUpdate': Function(type='int', derefcnt=0, name='EVP_DecryptUpdate', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='inl')]),
 'EVP_Digest': Function(type='int', derefcnt=0, name='EVP_Digest', args=[Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='count'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='size'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='ENGINE', derefcnt=1, name='impl')]),
 'EVP_DigestFinal': Function(type='int', derefcnt=0, name='EVP_DigestFinal', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='s')]),
 'EVP_DigestFinal_ex': Function(type='int', derefcnt=0, name='EVP_DigestFinal_ex', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='s')]),
 'EVP_DigestInit': Function(type='int', derefcnt=0, name='EVP_DigestInit', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_MD', derefcnt=1, name='type')]),
 'EVP_DigestInit_ex': Function(type='int', derefcnt=0, name='EVP_DigestInit_ex', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='ENGINE', derefcnt=1, name='impl')]),
 'EVP_DigestSignFinal': Function(type='int', derefcnt=0, name='EVP_DigestSignFinal', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sigret'), Argument(type='size_t', derefcnt=1, name='siglen')]),
 'EVP_DigestSignInit': Function(type='int', derefcnt=0, name='EVP_DigestSignInit', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_PKEY_CTX', derefcnt=2, name='pctx'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='ENGINE', derefcnt=1, name='e'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_DigestUpdate': Function(type='int', derefcnt=0, name='EVP_DigestUpdate', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='cnt')]),
 'EVP_DigestVerifyFinal': Function(type='int', derefcnt=0, name='EVP_DigestVerifyFinal', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='size_t', derefcnt=0, name='siglen')]),
 'EVP_DigestVerifyInit': Function(type='int', derefcnt=0, name='EVP_DigestVerifyInit', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_PKEY_CTX', derefcnt=2, name='pctx'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='ENGINE', derefcnt=1, name='e'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_EncodeBlock': Function(type='int', derefcnt=0, name='EVP_EncodeBlock', args=[Argument(type='unsigned', derefcnt=1, name='t'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='n')]),
 'EVP_EncodeFinal': Function(type='void', derefcnt=0, name='EVP_EncodeFinal', args=[Argument(type='EVP_ENCODE_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_EncodeInit': Function(type='void', derefcnt=0, name='EVP_EncodeInit', args=[Argument(type='EVP_ENCODE_CTX', derefcnt=1, name='ctx')]),
 'EVP_EncodeUpdate': Function(type='void', derefcnt=0, name='EVP_EncodeUpdate', args=[Argument(type='EVP_ENCODE_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='inl')]),
 'EVP_EncryptFinal': Function(type='int', derefcnt=0, name='EVP_EncryptFinal', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_EncryptFinal_ex': Function(type='int', derefcnt=0, name='EVP_EncryptFinal_ex', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_EncryptInit': Function(type='int', derefcnt=0, name='EVP_EncryptInit', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=1, name='iv')]),
 'EVP_EncryptInit_ex': Function(type='int', derefcnt=0, name='EVP_EncryptInit_ex', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='ENGINE', derefcnt=1, name='impl'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=1, name='iv')]),
 'EVP_EncryptUpdate': Function(type='int', derefcnt=0, name='EVP_EncryptUpdate', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='inl')]),
 'EVP_MD_CTX_cleanup': Function(type='int', derefcnt=0, name='EVP_MD_CTX_cleanup', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'EVP_MD_CTX_clear_flags': Function(type='void', derefcnt=0, name='EVP_MD_CTX_clear_flags', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='flags')]),
 'EVP_MD_CTX_copy': Function(type='int', derefcnt=0, name='EVP_MD_CTX_copy', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='out'), Argument(type='EVP_MD_CTX', derefcnt=1, name='in')]),
 'EVP_MD_CTX_copy_ex': Function(type='int', derefcnt=0, name='EVP_MD_CTX_copy_ex', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='out'), Argument(type='EVP_MD_CTX', derefcnt=1, name='in')]),
 'EVP_MD_CTX_create': Function(type='EVP_MD_CTX', derefcnt=1, name='EVP_MD_CTX_create', args=[]),
 'EVP_MD_CTX_destroy': Function(type='void', derefcnt=0, name='EVP_MD_CTX_destroy', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'EVP_MD_CTX_init': Function(type='void', derefcnt=0, name='EVP_MD_CTX_init', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'EVP_MD_CTX_md': Function(type='EVP_MD', derefcnt=1, name='EVP_MD_CTX_md', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'EVP_MD_CTX_set_flags': Function(type='void', derefcnt=0, name='EVP_MD_CTX_set_flags', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='flags')]),
 'EVP_MD_CTX_test_flags': Function(type='int', derefcnt=0, name='EVP_MD_CTX_test_flags', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='flags')]),
 'EVP_MD_block_size': Function(type='int', derefcnt=0, name='EVP_MD_block_size', args=[Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'EVP_MD_do_all': Function(type='void', derefcnt=0, name='EVP_MD_do_all', args=[Argument(type='void', derefcnt=0, name='fn'), Argument(type='void', derefcnt=1, name='arg')]),
 'EVP_MD_do_all_sorted': Function(type='void', derefcnt=0, name='EVP_MD_do_all_sorted', args=[Argument(type='void', derefcnt=0, name='fn'), Argument(type='void', derefcnt=1, name='arg')]),
 'EVP_MD_flags': Function(type='unsigned', derefcnt=0, name='EVP_MD_flags', args=[Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'EVP_MD_pkey_type': Function(type='int', derefcnt=0, name='EVP_MD_pkey_type', args=[Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'EVP_MD_size': Function(type='int', derefcnt=0, name='EVP_MD_size', args=[Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'EVP_MD_type': Function(type='int', derefcnt=0, name='EVP_MD_type', args=[Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'EVP_OpenFinal': Function(type='int', derefcnt=0, name='EVP_OpenFinal', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_OpenInit': Function(type='int', derefcnt=0, name='EVP_OpenInit', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=1, name='ek'), Argument(type='int', derefcnt=0, name='ekl'), Argument(type='unsigned', derefcnt=1, name='iv'), Argument(type='EVP_PKEY', derefcnt=1, name='priv')]),
 'EVP_PBE_CipherInit': Function(type='int', derefcnt=0, name='EVP_PBE_CipherInit', args=[Argument(type='ASN1_OBJECT', derefcnt=1, name='pbe_obj'), Argument(type='char', derefcnt=1, name='pass'), Argument(type='int', derefcnt=0, name='passlen'), Argument(type='ASN1_TYPE', derefcnt=1, name='param'), Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='en_de')]),
 'EVP_PBE_KEYGEN': Function(type='int', derefcnt=0, name='EVP_PBE_KEYGEN', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='pass'), Argument(type='int', derefcnt=0, name='passlen'), Argument(type='ASN1_TYPE', derefcnt=1, name='param'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='EVP_MD', derefcnt=1, name='md'), Argument(type='int', derefcnt=0, name='en_de')]),
 'EVP_PBE_alg_add': Function(type='int', derefcnt=0, name='EVP_PBE_alg_add', args=[Argument(type='int', derefcnt=0, name='nid'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='EVP_MD', derefcnt=1, name='md'), Argument(type='EVP_PBE_KEYGEN', derefcnt=1, name='keygen')]),
 'EVP_PBE_alg_add_type': Function(type='int', derefcnt=0, name='EVP_PBE_alg_add_type', args=[Argument(type='int', derefcnt=0, name='pbe_type'), Argument(type='int', derefcnt=0, name='pbe_nid'), Argument(type='int', derefcnt=0, name='cipher_nid'), Argument(type='int', derefcnt=0, name='md_nid'), Argument(type='EVP_PBE_KEYGEN', derefcnt=1, name='keygen')]),
 'EVP_PBE_cleanup': Function(type='void', derefcnt=0, name='EVP_PBE_cleanup', args=[]),
 'EVP_PBE_find': Function(type='int', derefcnt=0, name='EVP_PBE_find', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='pbe_nid'), Argument(type='int', derefcnt=1, name='pcnid'), Argument(type='int', derefcnt=1, name='pmnid'), Argument(type='EVP_PBE_KEYGEN', derefcnt=2, name='pkeygen')]),
 'EVP_PKCS82PKEY': Function(type='EVP_PKEY', derefcnt=1, name='EVP_PKCS82PKEY', args=[Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='p8')]),
 'EVP_PKEY2PKCS8': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='EVP_PKEY2PKCS8', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY2PKCS8_broken': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='EVP_PKEY2PKCS8_broken', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=0, name='broken')]),
 'EVP_PKEY_CTX_ctrl': Function(type='int', derefcnt=0, name='EVP_PKEY_CTX_ctrl', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='keytype'), Argument(type='int', derefcnt=0, name='optype'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='int', derefcnt=0, name='p1'), Argument(type='void', derefcnt=1, name='p2')]),
 'EVP_PKEY_CTX_ctrl_str': Function(type='int', derefcnt=0, name='EVP_PKEY_CTX_ctrl_str', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='type'), Argument(type='char', derefcnt=1, name='value')]),
 'EVP_PKEY_CTX_dup': Function(type='EVP_PKEY_CTX', derefcnt=1, name='EVP_PKEY_CTX_dup', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_free': Function(type='void', derefcnt=0, name='EVP_PKEY_CTX_free', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_get0_peerkey': Function(type='EVP_PKEY', derefcnt=1, name='EVP_PKEY_CTX_get0_peerkey', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_get0_pkey': Function(type='EVP_PKEY', derefcnt=1, name='EVP_PKEY_CTX_get0_pkey', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_get_app_data': Function(type='void', derefcnt=1, name='EVP_PKEY_CTX_get_app_data', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_get_cb': Function(type='EVP_PKEY_gen_cb', derefcnt=1, name='EVP_PKEY_CTX_get_cb', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_get_data': Function(type='void', derefcnt=1, name='EVP_PKEY_CTX_get_data', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_get_keygen_info': Function(type='int', derefcnt=0, name='EVP_PKEY_CTX_get_keygen_info', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='idx')]),
 'EVP_PKEY_CTX_get_operation': Function(type='int', derefcnt=0, name='EVP_PKEY_CTX_get_operation', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_CTX_new': Function(type='EVP_PKEY_CTX', derefcnt=1, name='EVP_PKEY_CTX_new', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='ENGINE', derefcnt=1, name='e')]),
 'EVP_PKEY_CTX_new_id': Function(type='EVP_PKEY_CTX', derefcnt=1, name='EVP_PKEY_CTX_new_id', args=[Argument(type='int', derefcnt=0, name='id'), Argument(type='ENGINE', derefcnt=1, name='e')]),
 'EVP_PKEY_CTX_set0_keygen_info': Function(type='void', derefcnt=0, name='EVP_PKEY_CTX_set0_keygen_info', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=1, name='dat'), Argument(type='int', derefcnt=0, name='datlen')]),
 'EVP_PKEY_CTX_set_app_data': Function(type='void', derefcnt=0, name='EVP_PKEY_CTX_set_app_data', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='data')]),
 'EVP_PKEY_CTX_set_cb': Function(type='void', derefcnt=0, name='EVP_PKEY_CTX_set_cb', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_PKEY_gen_cb', derefcnt=1, name='cb')]),
 'EVP_PKEY_CTX_set_data': Function(type='void', derefcnt=0, name='EVP_PKEY_CTX_set_data', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='data')]),
 'EVP_PKEY_add1_attr': Function(type='int', derefcnt=0, name='EVP_PKEY_add1_attr', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr')]),
 'EVP_PKEY_add1_attr_by_NID': Function(type='int', derefcnt=0, name='EVP_PKEY_add1_attr_by_NID', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'EVP_PKEY_add1_attr_by_OBJ': Function(type='int', derefcnt=0, name='EVP_PKEY_add1_attr_by_OBJ', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'EVP_PKEY_add1_attr_by_txt': Function(type='int', derefcnt=0, name='EVP_PKEY_add1_attr_by_txt', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='char', derefcnt=1, name='attrname'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'EVP_PKEY_asn1_add0': Function(type='int', derefcnt=0, name='EVP_PKEY_asn1_add0', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth')]),
 'EVP_PKEY_asn1_add_alias': Function(type='int', derefcnt=0, name='EVP_PKEY_asn1_add_alias', args=[Argument(type='int', derefcnt=0, name='to'), Argument(type='int', derefcnt=0, name='from')]),
 'EVP_PKEY_asn1_copy': Function(type='void', derefcnt=0, name='EVP_PKEY_asn1_copy', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='dst'), Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='src')]),
 'EVP_PKEY_asn1_find': Function(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='EVP_PKEY_asn1_find', args=[Argument(type='ENGINE', derefcnt=2, name='pe'), Argument(type='int', derefcnt=0, name='type')]),
 'EVP_PKEY_asn1_find_str': Function(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='EVP_PKEY_asn1_find_str', args=[Argument(type='ENGINE', derefcnt=2, name='pe'), Argument(type='char', derefcnt=1, name='str'), Argument(type='int', derefcnt=0, name='len')]),
 'EVP_PKEY_asn1_free': Function(type='void', derefcnt=0, name='EVP_PKEY_asn1_free', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth')]),
 'EVP_PKEY_asn1_get0': Function(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='EVP_PKEY_asn1_get0', args=[Argument(type='int', derefcnt=0, name='idx')]),
 'EVP_PKEY_asn1_get0_info': Function(type='int', derefcnt=0, name='EVP_PKEY_asn1_get0_info', args=[Argument(type='int', derefcnt=1, name='ppkey_id'), Argument(type='int', derefcnt=1, name='pkey_base_id'), Argument(type='int', derefcnt=1, name='ppkey_flags'), Argument(type='char', derefcnt=2, name='pinfo'), Argument(type='char', derefcnt=2, name='ppem_str'), Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth')]),
 'EVP_PKEY_asn1_get_count': Function(type='int', derefcnt=0, name='EVP_PKEY_asn1_get_count', args=[]),
 'EVP_PKEY_asn1_new': Function(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='EVP_PKEY_asn1_new', args=[Argument(type='int', derefcnt=0, name='id'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='char', derefcnt=1, name='pem_str'), Argument(type='char', derefcnt=1, name='info')]),
 'EVP_PKEY_asn1_set_ctrl': Function(type='void', derefcnt=0, name='EVP_PKEY_asn1_set_ctrl', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth'), Argument(type='int', derefcnt=0, name='pkey_ctrl')]),
 'EVP_PKEY_asn1_set_free': Function(type='void', derefcnt=0, name='EVP_PKEY_asn1_set_free', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth'), Argument(type='void', derefcnt=0, name='pkey_free')]),
 'EVP_PKEY_asn1_set_param': Function(type='void', derefcnt=0, name='EVP_PKEY_asn1_set_param', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth'), Argument(type='int', derefcnt=0, name='param_decode'), Argument(type='int', derefcnt=0, name='param_encode'), Argument(type='int', derefcnt=0, name='param_missing'), Argument(type='int', derefcnt=0, name='param_copy'), Argument(type='int', derefcnt=0, name='param_cmp'), Argument(type='int', derefcnt=0, name='param_print')]),
 'EVP_PKEY_asn1_set_private': Function(type='void', derefcnt=0, name='EVP_PKEY_asn1_set_private', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth'), Argument(type='int', derefcnt=0, name='priv_decode'), Argument(type='int', derefcnt=0, name='priv_encode'), Argument(type='int', derefcnt=0, name='priv_print')]),
 'EVP_PKEY_asn1_set_public': Function(type='void', derefcnt=0, name='EVP_PKEY_asn1_set_public', args=[Argument(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='ameth'), Argument(type='int', derefcnt=0, name='pub_decode'), Argument(type='int', derefcnt=0, name='pub_encode'), Argument(type='int', derefcnt=0, name='pub_cmp'), Argument(type='int', derefcnt=0, name='pub_print'), Argument(type='int', derefcnt=0, name='pkey_size'), Argument(type='int', derefcnt=0, name='pkey_bits')]),
 'EVP_PKEY_assign': Function(type='int', derefcnt=0, name='EVP_PKEY_assign', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=0, name='type'), Argument(type='void', derefcnt=1, name='key')]),
 'EVP_PKEY_base_id': Function(type='int', derefcnt=0, name='EVP_PKEY_base_id', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_bits': Function(type='int', derefcnt=0, name='EVP_PKEY_bits', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_cmp': Function(type='int', derefcnt=0, name='EVP_PKEY_cmp', args=[Argument(type='EVP_PKEY', derefcnt=1, name='a'), Argument(type='EVP_PKEY', derefcnt=1, name='b')]),
 'EVP_PKEY_cmp_parameters': Function(type='int', derefcnt=0, name='EVP_PKEY_cmp_parameters', args=[Argument(type='EVP_PKEY', derefcnt=1, name='a'), Argument(type='EVP_PKEY', derefcnt=1, name='b')]),
 'EVP_PKEY_copy_parameters': Function(type='int', derefcnt=0, name='EVP_PKEY_copy_parameters', args=[Argument(type='EVP_PKEY', derefcnt=1, name='to'), Argument(type='EVP_PKEY', derefcnt=1, name='from')]),
 'EVP_PKEY_decrypt': Function(type='int', derefcnt=0, name='EVP_PKEY_decrypt', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='outlen'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='inlen')]),
 'EVP_PKEY_decrypt_init': Function(type='int', derefcnt=0, name='EVP_PKEY_decrypt_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_decrypt_old': Function(type='int', derefcnt=0, name='EVP_PKEY_decrypt_old', args=[Argument(type='unsigned', derefcnt=1, name='dec_key'), Argument(type='unsigned', derefcnt=1, name='enc_key'), Argument(type='int', derefcnt=0, name='enc_key_len'), Argument(type='EVP_PKEY', derefcnt=1, name='private_key')]),
 'EVP_PKEY_delete_attr': Function(type='X509_ATTRIBUTE', derefcnt=1, name='EVP_PKEY_delete_attr', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='loc')]),
 'EVP_PKEY_derive': Function(type='int', derefcnt=0, name='EVP_PKEY_derive', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='size_t', derefcnt=1, name='keylen')]),
 'EVP_PKEY_derive_init': Function(type='int', derefcnt=0, name='EVP_PKEY_derive_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_derive_set_peer': Function(type='int', derefcnt=0, name='EVP_PKEY_derive_set_peer', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_PKEY', derefcnt=1, name='peer')]),
 'EVP_PKEY_encrypt': Function(type='int', derefcnt=0, name='EVP_PKEY_encrypt', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='outlen'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='inlen')]),
 'EVP_PKEY_encrypt_init': Function(type='int', derefcnt=0, name='EVP_PKEY_encrypt_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_encrypt_old': Function(type='int', derefcnt=0, name='EVP_PKEY_encrypt_old', args=[Argument(type='unsigned', derefcnt=1, name='enc_key'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='key_len'), Argument(type='EVP_PKEY', derefcnt=1, name='pub_key')]),
 'EVP_PKEY_free': Function(type='void', derefcnt=0, name='EVP_PKEY_free', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_gen_cb': Function(type='int', derefcnt=0, name='EVP_PKEY_gen_cb', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_get0': Function(type='void', derefcnt=1, name='EVP_PKEY_get0', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_get0_asn1': Function(type='EVP_PKEY_ASN1_METHOD', derefcnt=1, name='EVP_PKEY_get0_asn1', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_get1_DH': Function(type='dh_st', derefcnt=1, name='EVP_PKEY_get1_DH', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_get1_DSA': Function(type='dsa_st', derefcnt=1, name='EVP_PKEY_get1_DSA', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_get1_EC_KEY': Function(type='ec_key_st', derefcnt=1, name='EVP_PKEY_get1_EC_KEY', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_get1_RSA': Function(type='rsa_st', derefcnt=1, name='EVP_PKEY_get1_RSA', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_get_attr': Function(type='X509_ATTRIBUTE', derefcnt=1, name='EVP_PKEY_get_attr', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='loc')]),
 'EVP_PKEY_get_attr_by_NID': Function(type='int', derefcnt=0, name='EVP_PKEY_get_attr_by_NID', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'EVP_PKEY_get_attr_by_OBJ': Function(type='int', derefcnt=0, name='EVP_PKEY_get_attr_by_OBJ', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'EVP_PKEY_get_attr_count': Function(type='int', derefcnt=0, name='EVP_PKEY_get_attr_count', args=[Argument(type='EVP_PKEY', derefcnt=1, name='key')]),
 'EVP_PKEY_get_default_digest_nid': Function(type='int', derefcnt=0, name='EVP_PKEY_get_default_digest_nid', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=1, name='pnid')]),
 'EVP_PKEY_id': Function(type='int', derefcnt=0, name='EVP_PKEY_id', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_keygen': Function(type='int', derefcnt=0, name='EVP_PKEY_keygen', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_PKEY', derefcnt=2, name='ppkey')]),
 'EVP_PKEY_keygen_init': Function(type='int', derefcnt=0, name='EVP_PKEY_keygen_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_meth_add0': Function(type='int', derefcnt=0, name='EVP_PKEY_meth_add0', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth')]),
 'EVP_PKEY_meth_copy': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_copy', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='dst'), Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='src')]),
 'EVP_PKEY_meth_find': Function(type='EVP_PKEY_METHOD', derefcnt=1, name='EVP_PKEY_meth_find', args=[Argument(type='int', derefcnt=0, name='type')]),
 'EVP_PKEY_meth_free': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_free', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth')]),
 'EVP_PKEY_meth_get0_info': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_get0_info', args=[Argument(type='int', derefcnt=1, name='ppkey_id'), Argument(type='int', derefcnt=1, name='pflags'), Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='meth')]),
 'EVP_PKEY_meth_new': Function(type='EVP_PKEY_METHOD', derefcnt=1, name='EVP_PKEY_meth_new', args=[Argument(type='int', derefcnt=0, name='id'), Argument(type='int', derefcnt=0, name='flags')]),
 'EVP_PKEY_meth_set_cleanup': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_cleanup', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='void', derefcnt=0, name='cleanup')]),
 'EVP_PKEY_meth_set_copy': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_copy', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='copy')]),
 'EVP_PKEY_meth_set_ctrl': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_ctrl', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='ctrl'), Argument(type='int', derefcnt=0, name='ctrl_str')]),
 'EVP_PKEY_meth_set_decrypt': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_decrypt', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='decrypt_init'), Argument(type='int', derefcnt=0, name='decrypt')]),
 'EVP_PKEY_meth_set_derive': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_derive', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='derive_init'), Argument(type='int', derefcnt=0, name='derive')]),
 'EVP_PKEY_meth_set_encrypt': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_encrypt', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='encrypt_init'), Argument(type='int', derefcnt=0, name='encryptfn')]),
 'EVP_PKEY_meth_set_init': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_init', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='init')]),
 'EVP_PKEY_meth_set_keygen': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_keygen', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='keygen_init'), Argument(type='int', derefcnt=0, name='keygen')]),
 'EVP_PKEY_meth_set_paramgen': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_paramgen', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='paramgen_init'), Argument(type='int', derefcnt=0, name='paramgen')]),
 'EVP_PKEY_meth_set_sign': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_sign', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='sign_init'), Argument(type='int', derefcnt=0, name='sign')]),
 'EVP_PKEY_meth_set_signctx': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_signctx', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='signctx_init'), Argument(type='int', derefcnt=0, name='signctx')]),
 'EVP_PKEY_meth_set_verify': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_verify', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='verify_init'), Argument(type='int', derefcnt=0, name='verify')]),
 'EVP_PKEY_meth_set_verify_recover': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_verify_recover', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='verify_recover_init'), Argument(type='int', derefcnt=0, name='verify_recover')]),
 'EVP_PKEY_meth_set_verifyctx': Function(type='void', derefcnt=0, name='EVP_PKEY_meth_set_verifyctx', args=[Argument(type='EVP_PKEY_METHOD', derefcnt=1, name='pmeth'), Argument(type='int', derefcnt=0, name='verifyctx_init'), Argument(type='int', derefcnt=0, name='verifyctx')]),
 'EVP_PKEY_missing_parameters': Function(type='int', derefcnt=0, name='EVP_PKEY_missing_parameters', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_new': Function(type='EVP_PKEY', derefcnt=1, name='EVP_PKEY_new', args=[]),
 'EVP_PKEY_new_mac_key': Function(type='EVP_PKEY', derefcnt=1, name='EVP_PKEY_new_mac_key', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='ENGINE', derefcnt=1, name='e'), Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='keylen')]),
 'EVP_PKEY_paramgen': Function(type='int', derefcnt=0, name='EVP_PKEY_paramgen', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_PKEY', derefcnt=2, name='ppkey')]),
 'EVP_PKEY_paramgen_init': Function(type='int', derefcnt=0, name='EVP_PKEY_paramgen_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_print_params': Function(type='int', derefcnt=0, name='EVP_PKEY_print_params', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='ASN1_PCTX', derefcnt=1, name='pctx')]),
 'EVP_PKEY_print_private': Function(type='int', derefcnt=0, name='EVP_PKEY_print_private', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='ASN1_PCTX', derefcnt=1, name='pctx')]),
 'EVP_PKEY_print_public': Function(type='int', derefcnt=0, name='EVP_PKEY_print_public', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='ASN1_PCTX', derefcnt=1, name='pctx')]),
 'EVP_PKEY_save_parameters': Function(type='int', derefcnt=0, name='EVP_PKEY_save_parameters', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=0, name='mode')]),
 'EVP_PKEY_set1_DH': Function(type='int', derefcnt=0, name='EVP_PKEY_set1_DH', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='dh_st', derefcnt=1, name='key')]),
 'EVP_PKEY_set1_DSA': Function(type='int', derefcnt=0, name='EVP_PKEY_set1_DSA', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='dsa_st', derefcnt=1, name='key')]),
 'EVP_PKEY_set1_EC_KEY': Function(type='int', derefcnt=0, name='EVP_PKEY_set1_EC_KEY', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='ec_key_st', derefcnt=1, name='key')]),
 'EVP_PKEY_set1_RSA': Function(type='int', derefcnt=0, name='EVP_PKEY_set1_RSA', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='rsa_st', derefcnt=1, name='key')]),
 'EVP_PKEY_set_type': Function(type='int', derefcnt=0, name='EVP_PKEY_set_type', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='int', derefcnt=0, name='type')]),
 'EVP_PKEY_set_type_str': Function(type='int', derefcnt=0, name='EVP_PKEY_set_type_str', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='char', derefcnt=1, name='str'), Argument(type='int', derefcnt=0, name='len')]),
 'EVP_PKEY_sign': Function(type='int', derefcnt=0, name='EVP_PKEY_sign', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='size_t', derefcnt=1, name='siglen'), Argument(type='unsigned', derefcnt=1, name='tbs'), Argument(type='size_t', derefcnt=0, name='tbslen')]),
 'EVP_PKEY_sign_init': Function(type='int', derefcnt=0, name='EVP_PKEY_sign_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_size': Function(type='int', derefcnt=0, name='EVP_PKEY_size', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_PKEY_type': Function(type='int', derefcnt=0, name='EVP_PKEY_type', args=[Argument(type='int', derefcnt=0, name='type')]),
 'EVP_PKEY_verify': Function(type='int', derefcnt=0, name='EVP_PKEY_verify', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='size_t', derefcnt=0, name='siglen'), Argument(type='unsigned', derefcnt=1, name='tbs'), Argument(type='size_t', derefcnt=0, name='tbslen')]),
 'EVP_PKEY_verify_init': Function(type='int', derefcnt=0, name='EVP_PKEY_verify_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_PKEY_verify_recover': Function(type='int', derefcnt=0, name='EVP_PKEY_verify_recover', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='rout'), Argument(type='size_t', derefcnt=1, name='routlen'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='size_t', derefcnt=0, name='siglen')]),
 'EVP_PKEY_verify_recover_init': Function(type='int', derefcnt=0, name='EVP_PKEY_verify_recover_init', args=[Argument(type='EVP_PKEY_CTX', derefcnt=1, name='ctx')]),
 'EVP_SealFinal': Function(type='int', derefcnt=0, name='EVP_SealFinal', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl')]),
 'EVP_SealInit': Function(type='int', derefcnt=0, name='EVP_SealInit', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=2, name='ek'), Argument(type='int', derefcnt=1, name='ekl'), Argument(type='unsigned', derefcnt=1, name='iv'), Argument(type='EVP_PKEY', derefcnt=2, name='pubk'), Argument(type='int', derefcnt=0, name='npubk')]),
 'EVP_SignFinal': Function(type='int', derefcnt=0, name='EVP_SignFinal', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='s'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_VerifyFinal': Function(type='int', derefcnt=0, name='EVP_VerifyFinal', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sigbuf'), Argument(type='unsigned', derefcnt=0, name='siglen'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'EVP_add_alg_module': Function(type='void', derefcnt=0, name='EVP_add_alg_module', args=[]),
 'EVP_add_cipher': Function(type='int', derefcnt=0, name='EVP_add_cipher', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher')]),
 'EVP_add_digest': Function(type='int', derefcnt=0, name='EVP_add_digest', args=[Argument(type='EVP_MD', derefcnt=1, name='digest')]),
 'EVP_aes_128_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_cbc', args=[]),
 'EVP_aes_128_cbc_hmac_sha1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_cbc_hmac_sha1', args=[]),
 'EVP_aes_128_ccm': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_ccm', args=[]),
 'EVP_aes_128_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_cfb1', args=[]),
 'EVP_aes_128_cfb128': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_cfb128', args=[]),
 'EVP_aes_128_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_cfb8', args=[]),
 'EVP_aes_128_ctr': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_ctr', args=[]),
 'EVP_aes_128_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_ecb', args=[]),
 'EVP_aes_128_gcm': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_gcm', args=[]),
 'EVP_aes_128_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_ofb', args=[]),
 'EVP_aes_128_xts': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_128_xts', args=[]),
 'EVP_aes_192_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_cbc', args=[]),
 'EVP_aes_192_ccm': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_ccm', args=[]),
 'EVP_aes_192_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_cfb1', args=[]),
 'EVP_aes_192_cfb128': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_cfb128', args=[]),
 'EVP_aes_192_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_cfb8', args=[]),
 'EVP_aes_192_ctr': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_ctr', args=[]),
 'EVP_aes_192_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_ecb', args=[]),
 'EVP_aes_192_gcm': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_gcm', args=[]),
 'EVP_aes_192_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_192_ofb', args=[]),
 'EVP_aes_256_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_cbc', args=[]),
 'EVP_aes_256_cbc_hmac_sha1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_cbc_hmac_sha1', args=[]),
 'EVP_aes_256_ccm': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_ccm', args=[]),
 'EVP_aes_256_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_cfb1', args=[]),
 'EVP_aes_256_cfb128': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_cfb128', args=[]),
 'EVP_aes_256_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_cfb8', args=[]),
 'EVP_aes_256_ctr': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_ctr', args=[]),
 'EVP_aes_256_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_ecb', args=[]),
 'EVP_aes_256_gcm': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_gcm', args=[]),
 'EVP_aes_256_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_ofb', args=[]),
 'EVP_aes_256_xts': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_aes_256_xts', args=[]),
 'EVP_bf_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_bf_cbc', args=[]),
 'EVP_bf_cfb64': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_bf_cfb64', args=[]),
 'EVP_bf_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_bf_ecb', args=[]),
 'EVP_bf_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_bf_ofb', args=[]),
 'EVP_camellia_128_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_128_cbc', args=[]),
 'EVP_camellia_128_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_128_cfb1', args=[]),
 'EVP_camellia_128_cfb128': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_128_cfb128', args=[]),
 'EVP_camellia_128_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_128_cfb8', args=[]),
 'EVP_camellia_128_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_128_ecb', args=[]),
 'EVP_camellia_128_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_128_ofb', args=[]),
 'EVP_camellia_192_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_192_cbc', args=[]),
 'EVP_camellia_192_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_192_cfb1', args=[]),
 'EVP_camellia_192_cfb128': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_192_cfb128', args=[]),
 'EVP_camellia_192_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_192_cfb8', args=[]),
 'EVP_camellia_192_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_192_ecb', args=[]),
 'EVP_camellia_192_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_192_ofb', args=[]),
 'EVP_camellia_256_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_256_cbc', args=[]),
 'EVP_camellia_256_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_256_cfb1', args=[]),
 'EVP_camellia_256_cfb128': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_256_cfb128', args=[]),
 'EVP_camellia_256_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_256_cfb8', args=[]),
 'EVP_camellia_256_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_256_ecb', args=[]),
 'EVP_camellia_256_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_camellia_256_ofb', args=[]),
 'EVP_cast5_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_cast5_cbc', args=[]),
 'EVP_cast5_cfb64': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_cast5_cfb64', args=[]),
 'EVP_cast5_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_cast5_ecb', args=[]),
 'EVP_cast5_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_cast5_ofb', args=[]),
 'EVP_cleanup': Function(type='void', derefcnt=0, name='EVP_cleanup', args=[]),
 'EVP_des_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_cbc', args=[]),
 'EVP_des_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_cfb1', args=[]),
 'EVP_des_cfb64': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_cfb64', args=[]),
 'EVP_des_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_cfb8', args=[]),
 'EVP_des_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ecb', args=[]),
 'EVP_des_ede': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede', args=[]),
 'EVP_des_ede3': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede3', args=[]),
 'EVP_des_ede3_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede3_cbc', args=[]),
 'EVP_des_ede3_cfb1': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede3_cfb1', args=[]),
 'EVP_des_ede3_cfb64': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede3_cfb64', args=[]),
 'EVP_des_ede3_cfb8': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede3_cfb8', args=[]),
 'EVP_des_ede3_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede3_ecb', args=[]),
 'EVP_des_ede3_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede3_ofb', args=[]),
 'EVP_des_ede_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede_cbc', args=[]),
 'EVP_des_ede_cfb64': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede_cfb64', args=[]),
 'EVP_des_ede_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede_ecb', args=[]),
 'EVP_des_ede_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ede_ofb', args=[]),
 'EVP_des_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_des_ofb', args=[]),
 'EVP_desx_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_desx_cbc', args=[]),
 'EVP_dss': Function(type='EVP_MD', derefcnt=1, name='EVP_dss', args=[]),
 'EVP_dss1': Function(type='EVP_MD', derefcnt=1, name='EVP_dss1', args=[]),
 'EVP_ecdsa': Function(type='EVP_MD', derefcnt=1, name='EVP_ecdsa', args=[]),
 'EVP_enc_null': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_enc_null', args=[]),
 'EVP_get_cipherbyname': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_get_cipherbyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'EVP_get_digestbyname': Function(type='EVP_MD', derefcnt=1, name='EVP_get_digestbyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'EVP_get_pw_prompt': Function(type='char', derefcnt=1, name='EVP_get_pw_prompt', args=[]),
 'EVP_md4': Function(type='EVP_MD', derefcnt=1, name='EVP_md4', args=[]),
 'EVP_md5': Function(type='EVP_MD', derefcnt=1, name='EVP_md5', args=[]),
 'EVP_md_null': Function(type='EVP_MD', derefcnt=1, name='EVP_md_null', args=[]),
 'EVP_rc2_40_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc2_40_cbc', args=[]),
 'EVP_rc2_64_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc2_64_cbc', args=[]),
 'EVP_rc2_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc2_cbc', args=[]),
 'EVP_rc2_cfb64': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc2_cfb64', args=[]),
 'EVP_rc2_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc2_ecb', args=[]),
 'EVP_rc2_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc2_ofb', args=[]),
 'EVP_rc4': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc4', args=[]),
 'EVP_rc4_40': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc4_40', args=[]),
 'EVP_rc4_hmac_md5': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_rc4_hmac_md5', args=[]),
 'EVP_read_pw_string': Function(type='int', derefcnt=0, name='EVP_read_pw_string', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='length'), Argument(type='char', derefcnt=1, name='prompt'), Argument(type='int', derefcnt=0, name='verify')]),
 'EVP_read_pw_string_min': Function(type='int', derefcnt=0, name='EVP_read_pw_string_min', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='minlen'), Argument(type='int', derefcnt=0, name='maxlen'), Argument(type='char', derefcnt=1, name='prompt'), Argument(type='int', derefcnt=0, name='verify')]),
 'EVP_ripemd160': Function(type='EVP_MD', derefcnt=1, name='EVP_ripemd160', args=[]),
 'EVP_seed_cbc': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_seed_cbc', args=[]),
 'EVP_seed_cfb128': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_seed_cfb128', args=[]),
 'EVP_seed_ecb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_seed_ecb', args=[]),
 'EVP_seed_ofb': Function(type='EVP_CIPHER', derefcnt=1, name='EVP_seed_ofb', args=[]),
 'EVP_set_pw_prompt': Function(type='void', derefcnt=0, name='EVP_set_pw_prompt', args=[Argument(type='char', derefcnt=1, name='prompt')]),
 'EVP_sha': Function(type='EVP_MD', derefcnt=1, name='EVP_sha', args=[]),
 'EVP_sha1': Function(type='EVP_MD', derefcnt=1, name='EVP_sha1', args=[]),
 'EVP_sha224': Function(type='EVP_MD', derefcnt=1, name='EVP_sha224', args=[]),
 'EVP_sha256': Function(type='EVP_MD', derefcnt=1, name='EVP_sha256', args=[]),
 'EVP_sha384': Function(type='EVP_MD', derefcnt=1, name='EVP_sha384', args=[]),
 'EVP_sha512': Function(type='EVP_MD', derefcnt=1, name='EVP_sha512', args=[]),
 'EVP_whirlpool': Function(type='EVP_MD', derefcnt=1, name='EVP_whirlpool', args=[]),
 'Exit': Function(type='void', derefcnt=0, name='Exit', args=[Argument(type='int', derefcnt=0, name='status')]),
 'FIPS_mode': Function(type='int', derefcnt=0, name='FIPS_mode', args=[]),
 'FIPS_mode_set': Function(type='int', derefcnt=0, name='FIPS_mode_set', args=[Argument(type='int', derefcnt=0, name='r')]),
 'GEN_SESSION_CB': Function(type='int', derefcnt=0, name='GEN_SESSION_CB', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='id'), Argument(type='unsigned', derefcnt=1, name='id_len')]),
 'HMAC': Function(type='unsigned', derefcnt=1, name='HMAC', args=[Argument(type='EVP_MD', derefcnt=1, name='evp_md'), Argument(type='void', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='key_len'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='md_len')]),
 'HMAC_CTX_cleanup': Function(type='void', derefcnt=0, name='HMAC_CTX_cleanup', args=[Argument(type='HMAC_CTX', derefcnt=1, name='ctx')]),
 'HMAC_CTX_copy': Function(type='int', derefcnt=0, name='HMAC_CTX_copy', args=[Argument(type='HMAC_CTX', derefcnt=1, name='dctx'), Argument(type='HMAC_CTX', derefcnt=1, name='sctx')]),
 'HMAC_CTX_init': Function(type='void', derefcnt=0, name='HMAC_CTX_init', args=[Argument(type='HMAC_CTX', derefcnt=1, name='ctx')]),
 'HMAC_CTX_set_flags': Function(type='void', derefcnt=0, name='HMAC_CTX_set_flags', args=[Argument(type='HMAC_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'HMAC_Final': Function(type='int', derefcnt=0, name='HMAC_Final', args=[Argument(type='HMAC_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'HMAC_Init': Function(type='int', derefcnt=0, name='HMAC_Init', args=[Argument(type='HMAC_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='len'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'HMAC_Init_ex': Function(type='int', derefcnt=0, name='HMAC_Init_ex', args=[Argument(type='HMAC_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='key'), Argument(type='int', derefcnt=0, name='len'), Argument(type='EVP_MD', derefcnt=1, name='md'), Argument(type='ENGINE', derefcnt=1, name='impl')]),
 'HMAC_Update': Function(type='int', derefcnt=0, name='HMAC_Update', args=[Argument(type='HMAC_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='len')]),
 'IO_cookie_init': Function(type='void', derefcnt=0, name='IO_cookie_init', args=[Argument(type='IO_cookie_file', derefcnt=1, name='cfile'), Argument(type='int', derefcnt=0, name='read_write'), Argument(type='void', derefcnt=1, name='cookie'), Argument(type='IO_cookie_io_functions_t', derefcnt=0, name='fns')]),
 'IO_feof': Function(type='int', derefcnt=0, name='IO_feof', args=[Argument(type='IO_FILE', derefcnt=1, name='fp')]),
 'IO_ferror': Function(type='int', derefcnt=0, name='IO_ferror', args=[Argument(type='IO_FILE', derefcnt=1, name='fp')]),
 'IO_flockfile': Function(type='void', derefcnt=0, name='IO_flockfile', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0')]),
 'IO_free_backup_area': Function(type='void', derefcnt=0, name='IO_free_backup_area', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0')]),
 'IO_ftrylockfile': Function(type='int', derefcnt=0, name='IO_ftrylockfile', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0')]),
 'IO_funlockfile': Function(type='void', derefcnt=0, name='IO_funlockfile', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0')]),
 'IO_getc': Function(type='int', derefcnt=0, name='IO_getc', args=[Argument(type='IO_FILE', derefcnt=1, name='fp')]),
 'IO_padn': Function(type='ssize_t', derefcnt=0, name='IO_padn', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='ssize_t', derefcnt=0, name='arg2')]),
 'IO_peekc_locked': Function(type='int', derefcnt=0, name='IO_peekc_locked', args=[Argument(type='IO_FILE', derefcnt=1, name='fp')]),
 'IO_putc': Function(type='int', derefcnt=0, name='IO_putc', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='IO_FILE', derefcnt=1, name='fp')]),
 'IO_seekoff': Function(type='off64_t', derefcnt=0, name='IO_seekoff', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0'), Argument(type='off64_t', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3')]),
 'IO_seekpos': Function(type='off64_t', derefcnt=0, name='IO_seekpos', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0'), Argument(type='off64_t', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'IO_sgetn': Function(type='size_t', derefcnt=0, name='IO_sgetn', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2')]),
 'IO_vfprintf': Function(type='int', derefcnt=0, name='IO_vfprintf', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='gnuc_va_list', derefcnt=0, name='arg2')]),
 'IO_vfscanf': Function(type='int', derefcnt=0, name='IO_vfscanf', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='gnuc_va_list', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=1, name='arg3')]),
 'LHASH_COMP_FN_TYPE': Function(type='int', derefcnt=0, name='LHASH_COMP_FN_TYPE', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'LHASH_DOALL_ARG_FN_TYPE': Function(type='void', derefcnt=0, name='LHASH_DOALL_ARG_FN_TYPE', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'LHASH_DOALL_FN_TYPE': Function(type='void', derefcnt=0, name='LHASH_DOALL_FN_TYPE', args=[Argument(type='void', derefcnt=1, name='arg0')]),
 'LHASH_HASH_FN_TYPE': Function(type='unsigned', derefcnt=0, name='LHASH_HASH_FN_TYPE', args=[Argument(type='void', derefcnt=1, name='arg0')]),
 'NETSCAPE_CERT_SEQUENCE_free': Function(type='void', derefcnt=0, name='NETSCAPE_CERT_SEQUENCE_free', args=[Argument(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='a')]),
 'NETSCAPE_CERT_SEQUENCE_new': Function(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='NETSCAPE_CERT_SEQUENCE_new', args=[]),
 'NETSCAPE_SPKAC_free': Function(type='void', derefcnt=0, name='NETSCAPE_SPKAC_free', args=[Argument(type='NETSCAPE_SPKAC', derefcnt=1, name='a')]),
 'NETSCAPE_SPKAC_new': Function(type='NETSCAPE_SPKAC', derefcnt=1, name='NETSCAPE_SPKAC_new', args=[]),
 'NETSCAPE_SPKI_b64_decode': Function(type='NETSCAPE_SPKI', derefcnt=1, name='NETSCAPE_SPKI_b64_decode', args=[Argument(type='char', derefcnt=1, name='str'), Argument(type='int', derefcnt=0, name='len')]),
 'NETSCAPE_SPKI_b64_encode': Function(type='char', derefcnt=1, name='NETSCAPE_SPKI_b64_encode', args=[Argument(type='NETSCAPE_SPKI', derefcnt=1, name='x')]),
 'NETSCAPE_SPKI_free': Function(type='void', derefcnt=0, name='NETSCAPE_SPKI_free', args=[Argument(type='NETSCAPE_SPKI', derefcnt=1, name='a')]),
 'NETSCAPE_SPKI_get_pubkey': Function(type='EVP_PKEY', derefcnt=1, name='NETSCAPE_SPKI_get_pubkey', args=[Argument(type='NETSCAPE_SPKI', derefcnt=1, name='x')]),
 'NETSCAPE_SPKI_new': Function(type='NETSCAPE_SPKI', derefcnt=1, name='NETSCAPE_SPKI_new', args=[]),
 'NETSCAPE_SPKI_print': Function(type='int', derefcnt=0, name='NETSCAPE_SPKI_print', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='NETSCAPE_SPKI', derefcnt=1, name='spki')]),
 'NETSCAPE_SPKI_set_pubkey': Function(type='int', derefcnt=0, name='NETSCAPE_SPKI_set_pubkey', args=[Argument(type='NETSCAPE_SPKI', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'NETSCAPE_SPKI_sign': Function(type='int', derefcnt=0, name='NETSCAPE_SPKI_sign', args=[Argument(type='NETSCAPE_SPKI', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'NETSCAPE_SPKI_verify': Function(type='int', derefcnt=0, name='NETSCAPE_SPKI_verify', args=[Argument(type='NETSCAPE_SPKI', derefcnt=1, name='a'), Argument(type='EVP_PKEY', derefcnt=1, name='r')]),
 'NETSCAPE_X509_free': Function(type='void', derefcnt=0, name='NETSCAPE_X509_free', args=[Argument(type='NETSCAPE_X509', derefcnt=1, name='a')]),
 'NETSCAPE_X509_new': Function(type='NETSCAPE_X509', derefcnt=1, name='NETSCAPE_X509_new', args=[]),
 'OBJ_NAME_add': Function(type='int', derefcnt=0, name='OBJ_NAME_add', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='type'), Argument(type='char', derefcnt=1, name='data')]),
 'OBJ_NAME_cleanup': Function(type='void', derefcnt=0, name='OBJ_NAME_cleanup', args=[Argument(type='int', derefcnt=0, name='type')]),
 'OBJ_NAME_do_all': Function(type='void', derefcnt=0, name='OBJ_NAME_do_all', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='void', derefcnt=0, name='fn'), Argument(type='void', derefcnt=1, name='arg')]),
 'OBJ_NAME_do_all_sorted': Function(type='void', derefcnt=0, name='OBJ_NAME_do_all_sorted', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='void', derefcnt=0, name='fn'), Argument(type='void', derefcnt=1, name='arg')]),
 'OBJ_NAME_get': Function(type='char', derefcnt=1, name='OBJ_NAME_get', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='type')]),
 'OBJ_NAME_init': Function(type='int', derefcnt=0, name='OBJ_NAME_init', args=[]),
 'OBJ_NAME_new_index': Function(type='int', derefcnt=0, name='OBJ_NAME_new_index', args=[Argument(type='unsigned', derefcnt=0, name='hash_func'), Argument(type='int', derefcnt=0, name='cmp_func'), Argument(type='void', derefcnt=0, name='free_func')]),
 'OBJ_NAME_remove': Function(type='int', derefcnt=0, name='OBJ_NAME_remove', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='type')]),
 'OBJ_add_object': Function(type='int', derefcnt=0, name='OBJ_add_object', args=[Argument(type='ASN1_OBJECT', derefcnt=1, name='obj')]),
 'OBJ_add_sigid': Function(type='int', derefcnt=0, name='OBJ_add_sigid', args=[Argument(type='int', derefcnt=0, name='signid'), Argument(type='int', derefcnt=0, name='dig_id'), Argument(type='int', derefcnt=0, name='pkey_id')]),
 'OBJ_bsearch_': Function(type='void', derefcnt=1, name='OBJ_bsearch_', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=1, name='base'), Argument(type='int', derefcnt=0, name='num'), Argument(type='int', derefcnt=0, name='size'), Argument(type='int', derefcnt=0, name='cmp')]),
 'OBJ_bsearch_ex_': Function(type='void', derefcnt=1, name='OBJ_bsearch_ex_', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=1, name='base'), Argument(type='int', derefcnt=0, name='num'), Argument(type='int', derefcnt=0, name='size'), Argument(type='int', derefcnt=0, name='cmp'), Argument(type='int', derefcnt=0, name='flags')]),
 'OBJ_cleanup': Function(type='void', derefcnt=0, name='OBJ_cleanup', args=[]),
 'OBJ_cmp': Function(type='int', derefcnt=0, name='OBJ_cmp', args=[Argument(type='ASN1_OBJECT', derefcnt=1, name='a'), Argument(type='ASN1_OBJECT', derefcnt=1, name='b')]),
 'OBJ_create': Function(type='int', derefcnt=0, name='OBJ_create', args=[Argument(type='char', derefcnt=1, name='oid'), Argument(type='char', derefcnt=1, name='sn'), Argument(type='char', derefcnt=1, name='ln')]),
 'OBJ_create_objects': Function(type='int', derefcnt=0, name='OBJ_create_objects', args=[Argument(type='BIO', derefcnt=1, name='in')]),
 'OBJ_dup': Function(type='ASN1_OBJECT', derefcnt=1, name='OBJ_dup', args=[Argument(type='ASN1_OBJECT', derefcnt=1, name='o')]),
 'OBJ_find_sigid_algs': Function(type='int', derefcnt=0, name='OBJ_find_sigid_algs', args=[Argument(type='int', derefcnt=0, name='signid'), Argument(type='int', derefcnt=1, name='pdig_nid'), Argument(type='int', derefcnt=1, name='ppkey_nid')]),
 'OBJ_find_sigid_by_algs': Function(type='int', derefcnt=0, name='OBJ_find_sigid_by_algs', args=[Argument(type='int', derefcnt=1, name='psignid'), Argument(type='int', derefcnt=0, name='dig_nid'), Argument(type='int', derefcnt=0, name='pkey_nid')]),
 'OBJ_ln2nid': Function(type='int', derefcnt=0, name='OBJ_ln2nid', args=[Argument(type='char', derefcnt=1, name='s')]),
 'OBJ_new_nid': Function(type='int', derefcnt=0, name='OBJ_new_nid', args=[Argument(type='int', derefcnt=0, name='num')]),
 'OBJ_nid2ln': Function(type='char', derefcnt=1, name='OBJ_nid2ln', args=[Argument(type='int', derefcnt=0, name='n')]),
 'OBJ_nid2obj': Function(type='ASN1_OBJECT', derefcnt=1, name='OBJ_nid2obj', args=[Argument(type='int', derefcnt=0, name='n')]),
 'OBJ_nid2sn': Function(type='char', derefcnt=1, name='OBJ_nid2sn', args=[Argument(type='int', derefcnt=0, name='n')]),
 'OBJ_obj2nid': Function(type='int', derefcnt=0, name='OBJ_obj2nid', args=[Argument(type='ASN1_OBJECT', derefcnt=1, name='o')]),
 'OBJ_obj2txt': Function(type='int', derefcnt=0, name='OBJ_obj2txt', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='buf_len'), Argument(type='ASN1_OBJECT', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='no_name')]),
 'OBJ_sigid_free': Function(type='void', derefcnt=0, name='OBJ_sigid_free', args=[]),
 'OBJ_sn2nid': Function(type='int', derefcnt=0, name='OBJ_sn2nid', args=[Argument(type='char', derefcnt=1, name='s')]),
 'OBJ_txt2nid': Function(type='int', derefcnt=0, name='OBJ_txt2nid', args=[Argument(type='char', derefcnt=1, name='s')]),
 'OBJ_txt2obj': Function(type='ASN1_OBJECT', derefcnt=1, name='OBJ_txt2obj', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='no_name')]),
 'OPENSSL_add_all_algorithms_conf': Function(type='void', derefcnt=0, name='OPENSSL_add_all_algorithms_conf', args=[]),
 'OPENSSL_add_all_algorithms_noconf': Function(type='void', derefcnt=0, name='OPENSSL_add_all_algorithms_noconf', args=[]),
 'OPENSSL_cleanse': Function(type='void', derefcnt=0, name='OPENSSL_cleanse', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='len')]),
 'OPENSSL_ia32cap_loc': Function(type='unsigned', derefcnt=1, name='OPENSSL_ia32cap_loc', args=[]),
 'OPENSSL_init': Function(type='void', derefcnt=0, name='OPENSSL_init', args=[]),
 'OPENSSL_isservice': Function(type='int', derefcnt=0, name='OPENSSL_isservice', args=[]),
 'OPENSSL_issetugid': Function(type='int', derefcnt=0, name='OPENSSL_issetugid', args=[]),
 'OpenSSLDie': Function(type='void', derefcnt=0, name='OpenSSLDie', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line'), Argument(type='char', derefcnt=1, name='assertion')]),
 'OpenSSL_add_all_ciphers': Function(type='void', derefcnt=0, name='OpenSSL_add_all_ciphers', args=[]),
 'OpenSSL_add_all_digests': Function(type='void', derefcnt=0, name='OpenSSL_add_all_digests', args=[]),
 'PBE2PARAM_free': Function(type='void', derefcnt=0, name='PBE2PARAM_free', args=[Argument(type='PBE2PARAM', derefcnt=1, name='a')]),
 'PBE2PARAM_new': Function(type='PBE2PARAM', derefcnt=1, name='PBE2PARAM_new', args=[]),
 'PBEPARAM_free': Function(type='void', derefcnt=0, name='PBEPARAM_free', args=[Argument(type='PBEPARAM', derefcnt=1, name='a')]),
 'PBEPARAM_new': Function(type='PBEPARAM', derefcnt=1, name='PBEPARAM_new', args=[]),
 'PBKDF2PARAM_free': Function(type='void', derefcnt=0, name='PBKDF2PARAM_free', args=[Argument(type='PBKDF2PARAM', derefcnt=1, name='a')]),
 'PBKDF2PARAM_new': Function(type='PBKDF2PARAM', derefcnt=1, name='PBKDF2PARAM_new', args=[]),
 'PEM_ASN1_read': Function(type='void', derefcnt=1, name='PEM_ASN1_read', args=[Argument(type='d2i_of_void', derefcnt=1, name='d2i'), Argument(type='char', derefcnt=1, name='name'), Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='void', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_ASN1_read_bio': Function(type='void', derefcnt=1, name='PEM_ASN1_read_bio', args=[Argument(type='d2i_of_void', derefcnt=1, name='d2i'), Argument(type='char', derefcnt=1, name='name'), Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='void', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_ASN1_write': Function(type='int', derefcnt=0, name='PEM_ASN1_write', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='char', derefcnt=1, name='name'), Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='void', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='callback'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_ASN1_write_bio': Function(type='int', derefcnt=0, name='PEM_ASN1_write_bio', args=[Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='char', derefcnt=1, name='name'), Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='void', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_SealFinal': Function(type='int', derefcnt=0, name='PEM_SealFinal', args=[Argument(type='PEM_ENCODE_SEAL_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sig'), Argument(type='int', derefcnt=1, name='sigl'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl'), Argument(type='EVP_PKEY', derefcnt=1, name='priv')]),
 'PEM_SealInit': Function(type='int', derefcnt=0, name='PEM_SealInit', args=[Argument(type='PEM_ENCODE_SEAL_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_CIPHER', derefcnt=1, name='type'), Argument(type='EVP_MD', derefcnt=1, name='md_type'), Argument(type='unsigned', derefcnt=2, name='ek'), Argument(type='int', derefcnt=1, name='ekl'), Argument(type='unsigned', derefcnt=1, name='iv'), Argument(type='EVP_PKEY', derefcnt=2, name='pubk'), Argument(type='int', derefcnt=0, name='npubk')]),
 'PEM_SealUpdate': Function(type='void', derefcnt=0, name='PEM_SealUpdate', args=[Argument(type='PEM_ENCODE_SEAL_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=1, name='outl'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='inl')]),
 'PEM_SignFinal': Function(type='int', derefcnt=0, name='PEM_SignFinal', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sigret'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'PEM_SignInit': Function(type='void', derefcnt=0, name='PEM_SignInit', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_MD', derefcnt=1, name='type')]),
 'PEM_SignUpdate': Function(type='void', derefcnt=0, name='PEM_SignUpdate', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='unsigned', derefcnt=0, name='cnt')]),
 'PEM_X509_INFO_read': Function(type='stack_st_X509_INFO', derefcnt=1, name='PEM_X509_INFO_read', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='stack_st_X509_INFO', derefcnt=1, name='sk'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_X509_INFO_read_bio': Function(type='stack_st_X509_INFO', derefcnt=1, name='PEM_X509_INFO_read_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='stack_st_X509_INFO', derefcnt=1, name='sk'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_X509_INFO_write_bio': Function(type='int', derefcnt=0, name='PEM_X509_INFO_write_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_INFO', derefcnt=1, name='xi'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cd'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_bytes_read_bio': Function(type='int', derefcnt=0, name='PEM_bytes_read_bio', args=[Argument(type='unsigned', derefcnt=2, name='pdata'), Argument(type='long', derefcnt=1, name='plen'), Argument(type='char', derefcnt=2, name='pnm'), Argument(type='char', derefcnt=1, name='name'), Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_def_callback': Function(type='int', derefcnt=0, name='PEM_def_callback', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='num'), Argument(type='int', derefcnt=0, name='w'), Argument(type='void', derefcnt=1, name='key')]),
 'PEM_dek_info': Function(type='void', derefcnt=0, name='PEM_dek_info', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='char', derefcnt=1, name='type'), Argument(type='int', derefcnt=0, name='len'), Argument(type='char', derefcnt=1, name='str')]),
 'PEM_do_header': Function(type='int', derefcnt=0, name='PEM_do_header', args=[Argument(type='EVP_CIPHER_INFO', derefcnt=1, name='cipher'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='long', derefcnt=1, name='len'), Argument(type='pem_password_cb', derefcnt=1, name='callback'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_get_EVP_CIPHER_INFO': Function(type='int', derefcnt=0, name='PEM_get_EVP_CIPHER_INFO', args=[Argument(type='char', derefcnt=1, name='header'), Argument(type='EVP_CIPHER_INFO', derefcnt=1, name='cipher')]),
 'PEM_proc_type': Function(type='void', derefcnt=0, name='PEM_proc_type', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='type')]),
 'PEM_read': Function(type='int', derefcnt=0, name='PEM_read', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='char', derefcnt=2, name='name'), Argument(type='char', derefcnt=2, name='header'), Argument(type='unsigned', derefcnt=2, name='data'), Argument(type='long', derefcnt=1, name='len')]),
 'PEM_read_DHparams': Function(type='DH', derefcnt=1, name='PEM_read_DHparams', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DH', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_DSAPrivateKey': Function(type='DSA', derefcnt=1, name='PEM_read_DSAPrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_DSA_PUBKEY': Function(type='DSA', derefcnt=1, name='PEM_read_DSA_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_DSAparams': Function(type='DSA', derefcnt=1, name='PEM_read_DSAparams', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_ECPKParameters': Function(type='EC_GROUP', derefcnt=1, name='PEM_read_ECPKParameters', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_GROUP', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_ECPrivateKey': Function(type='EC_KEY', derefcnt=1, name='PEM_read_ECPrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_EC_PUBKEY': Function(type='EC_KEY', derefcnt=1, name='PEM_read_EC_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_NETSCAPE_CERT_SEQUENCE': Function(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='PEM_read_NETSCAPE_CERT_SEQUENCE', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='NETSCAPE_CERT_SEQUENCE', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_PKCS7': Function(type='PKCS7', derefcnt=1, name='PEM_read_PKCS7', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS7', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_PKCS8': Function(type='X509_SIG', derefcnt=1, name='PEM_read_PKCS8', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_SIG', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_PKCS8_PRIV_KEY_INFO': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='PEM_read_PKCS8_PRIV_KEY_INFO', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_PUBKEY': Function(type='EVP_PKEY', derefcnt=1, name='PEM_read_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_PrivateKey': Function(type='EVP_PKEY', derefcnt=1, name='PEM_read_PrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_RSAPrivateKey': Function(type='RSA', derefcnt=1, name='PEM_read_RSAPrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_RSAPublicKey': Function(type='RSA', derefcnt=1, name='PEM_read_RSAPublicKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_RSA_PUBKEY': Function(type='RSA', derefcnt=1, name='PEM_read_RSA_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_SSL_SESSION': Function(type='SSL_SESSION', derefcnt=1, name='PEM_read_SSL_SESSION', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='SSL_SESSION', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_X509': Function(type='X509', derefcnt=1, name='PEM_read_X509', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_X509_AUX': Function(type='X509', derefcnt=1, name='PEM_read_X509_AUX', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_X509_CERT_PAIR': Function(type='X509_CERT_PAIR', derefcnt=1, name='PEM_read_X509_CERT_PAIR', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_CERT_PAIR', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_X509_CRL': Function(type='X509_CRL', derefcnt=1, name='PEM_read_X509_CRL', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_CRL', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_X509_REQ': Function(type='X509_REQ', derefcnt=1, name='PEM_read_X509_REQ', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_REQ', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio': Function(type='int', derefcnt=0, name='PEM_read_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='char', derefcnt=2, name='name'), Argument(type='char', derefcnt=2, name='header'), Argument(type='unsigned', derefcnt=2, name='data'), Argument(type='long', derefcnt=1, name='len')]),
 'PEM_read_bio_DHparams': Function(type='DH', derefcnt=1, name='PEM_read_bio_DHparams', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DH', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_DSAPrivateKey': Function(type='DSA', derefcnt=1, name='PEM_read_bio_DSAPrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_DSA_PUBKEY': Function(type='DSA', derefcnt=1, name='PEM_read_bio_DSA_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_DSAparams': Function(type='DSA', derefcnt=1, name='PEM_read_bio_DSAparams', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_ECPKParameters': Function(type='EC_GROUP', derefcnt=1, name='PEM_read_bio_ECPKParameters', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_GROUP', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_ECPrivateKey': Function(type='EC_KEY', derefcnt=1, name='PEM_read_bio_ECPrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_EC_PUBKEY': Function(type='EC_KEY', derefcnt=1, name='PEM_read_bio_EC_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_NETSCAPE_CERT_SEQUENCE': Function(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='PEM_read_bio_NETSCAPE_CERT_SEQUENCE', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='NETSCAPE_CERT_SEQUENCE', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_PKCS7': Function(type='PKCS7', derefcnt=1, name='PEM_read_bio_PKCS7', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS7', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_PKCS8': Function(type='X509_SIG', derefcnt=1, name='PEM_read_bio_PKCS8', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_SIG', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_PKCS8_PRIV_KEY_INFO': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='PEM_read_bio_PKCS8_PRIV_KEY_INFO', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_PUBKEY': Function(type='EVP_PKEY', derefcnt=1, name='PEM_read_bio_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_Parameters': Function(type='EVP_PKEY', derefcnt=1, name='PEM_read_bio_Parameters', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=2, name='x')]),
 'PEM_read_bio_PrivateKey': Function(type='EVP_PKEY', derefcnt=1, name='PEM_read_bio_PrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_RSAPrivateKey': Function(type='RSA', derefcnt=1, name='PEM_read_bio_RSAPrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_RSAPublicKey': Function(type='RSA', derefcnt=1, name='PEM_read_bio_RSAPublicKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_RSA_PUBKEY': Function(type='RSA', derefcnt=1, name='PEM_read_bio_RSA_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_SSL_SESSION': Function(type='SSL_SESSION', derefcnt=1, name='PEM_read_bio_SSL_SESSION', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='SSL_SESSION', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_X509': Function(type='X509', derefcnt=1, name='PEM_read_bio_X509', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_X509_AUX': Function(type='X509', derefcnt=1, name='PEM_read_bio_X509_AUX', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_X509_CERT_PAIR': Function(type='X509_CERT_PAIR', derefcnt=1, name='PEM_read_bio_X509_CERT_PAIR', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CERT_PAIR', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_X509_CRL': Function(type='X509_CRL', derefcnt=1, name='PEM_read_bio_X509_CRL', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CRL', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_read_bio_X509_REQ': Function(type='X509_REQ', derefcnt=1, name='PEM_read_bio_X509_REQ', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write': Function(type='int', derefcnt=0, name='PEM_write', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='hdr'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='long', derefcnt=0, name='len')]),
 'PEM_write_DHparams': Function(type='int', derefcnt=0, name='PEM_write_DHparams', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DH', derefcnt=1, name='x')]),
 'PEM_write_DSAPrivateKey': Function(type='int', derefcnt=0, name='PEM_write_DSAPrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_DSA_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_DSA_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=1, name='x')]),
 'PEM_write_DSAparams': Function(type='int', derefcnt=0, name='PEM_write_DSAparams', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=1, name='x')]),
 'PEM_write_ECPKParameters': Function(type='int', derefcnt=0, name='PEM_write_ECPKParameters', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_GROUP', derefcnt=1, name='x')]),
 'PEM_write_ECPrivateKey': Function(type='int', derefcnt=0, name='PEM_write_ECPrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_EC_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_EC_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=1, name='x')]),
 'PEM_write_NETSCAPE_CERT_SEQUENCE': Function(type='int', derefcnt=0, name='PEM_write_NETSCAPE_CERT_SEQUENCE', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='x')]),
 'PEM_write_PKCS7': Function(type='int', derefcnt=0, name='PEM_write_PKCS7', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS7', derefcnt=1, name='x')]),
 'PEM_write_PKCS8': Function(type='int', derefcnt=0, name='PEM_write_PKCS8', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_SIG', derefcnt=1, name='x')]),
 'PEM_write_PKCS8PrivateKey': Function(type='int', derefcnt=0, name='PEM_write_PKCS8PrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='char', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cd'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_PKCS8PrivateKey_nid': Function(type='int', derefcnt=0, name='PEM_write_PKCS8PrivateKey_nid', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='char', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_PKCS8_PRIV_KEY_INFO': Function(type='int', derefcnt=0, name='PEM_write_PKCS8_PRIV_KEY_INFO', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='x')]),
 'PEM_write_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='x')]),
 'PEM_write_PrivateKey': Function(type='int', derefcnt=0, name='PEM_write_PrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_RSAPrivateKey': Function(type='int', derefcnt=0, name='PEM_write_RSAPrivateKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_RSAPublicKey': Function(type='int', derefcnt=0, name='PEM_write_RSAPublicKey', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=1, name='x')]),
 'PEM_write_RSA_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_RSA_PUBKEY', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=1, name='x')]),
 'PEM_write_SSL_SESSION': Function(type='int', derefcnt=0, name='PEM_write_SSL_SESSION', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='SSL_SESSION', derefcnt=1, name='x')]),
 'PEM_write_X509': Function(type='int', derefcnt=0, name='PEM_write_X509', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509', derefcnt=1, name='x')]),
 'PEM_write_X509_AUX': Function(type='int', derefcnt=0, name='PEM_write_X509_AUX', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509', derefcnt=1, name='x')]),
 'PEM_write_X509_CERT_PAIR': Function(type='int', derefcnt=0, name='PEM_write_X509_CERT_PAIR', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_CERT_PAIR', derefcnt=1, name='x')]),
 'PEM_write_X509_CRL': Function(type='int', derefcnt=0, name='PEM_write_X509_CRL', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_CRL', derefcnt=1, name='x')]),
 'PEM_write_X509_REQ': Function(type='int', derefcnt=0, name='PEM_write_X509_REQ', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_REQ', derefcnt=1, name='x')]),
 'PEM_write_X509_REQ_NEW': Function(type='int', derefcnt=0, name='PEM_write_X509_REQ_NEW', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_REQ', derefcnt=1, name='x')]),
 'PEM_write_bio': Function(type='int', derefcnt=0, name='PEM_write_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='hdr'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='long', derefcnt=0, name='len')]),
 'PEM_write_bio_ASN1_stream': Function(type='int', derefcnt=0, name='PEM_write_bio_ASN1_stream', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='ASN1_VALUE', derefcnt=1, name='val'), Argument(type='BIO', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='char', derefcnt=1, name='hdr'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'PEM_write_bio_DHparams': Function(type='int', derefcnt=0, name='PEM_write_bio_DHparams', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DH', derefcnt=1, name='x')]),
 'PEM_write_bio_DSAPrivateKey': Function(type='int', derefcnt=0, name='PEM_write_bio_DSAPrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_bio_DSA_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_bio_DSA_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='x')]),
 'PEM_write_bio_DSAparams': Function(type='int', derefcnt=0, name='PEM_write_bio_DSAparams', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='x')]),
 'PEM_write_bio_ECPKParameters': Function(type='int', derefcnt=0, name='PEM_write_bio_ECPKParameters', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_GROUP', derefcnt=1, name='x')]),
 'PEM_write_bio_ECPrivateKey': Function(type='int', derefcnt=0, name='PEM_write_bio_ECPrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_bio_EC_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_bio_EC_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=1, name='x')]),
 'PEM_write_bio_NETSCAPE_CERT_SEQUENCE': Function(type='int', derefcnt=0, name='PEM_write_bio_NETSCAPE_CERT_SEQUENCE', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='x')]),
 'PEM_write_bio_PKCS7': Function(type='int', derefcnt=0, name='PEM_write_bio_PKCS7', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS7', derefcnt=1, name='x')]),
 'PEM_write_bio_PKCS7_stream': Function(type='int', derefcnt=0, name='PEM_write_bio_PKCS7_stream', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='BIO', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='flags')]),
 'PEM_write_bio_PKCS8': Function(type='int', derefcnt=0, name='PEM_write_bio_PKCS8', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_SIG', derefcnt=1, name='x')]),
 'PEM_write_bio_PKCS8PrivateKey': Function(type='int', derefcnt=0, name='PEM_write_bio_PKCS8PrivateKey', args=[Argument(type='BIO', derefcnt=1, name='arg0'), Argument(type='EVP_PKEY', derefcnt=1, name='arg1'), Argument(type='EVP_CIPHER', derefcnt=1, name='arg2'), Argument(type='char', derefcnt=1, name='arg3'), Argument(type='int', derefcnt=0, name='arg4'), Argument(type='pem_password_cb', derefcnt=1, name='arg5'), Argument(type='void', derefcnt=1, name='arg6')]),
 'PEM_write_bio_PKCS8PrivateKey_nid': Function(type='int', derefcnt=0, name='PEM_write_bio_PKCS8PrivateKey_nid', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='char', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_bio_PKCS8_PRIV_KEY_INFO': Function(type='int', derefcnt=0, name='PEM_write_bio_PKCS8_PRIV_KEY_INFO', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='x')]),
 'PEM_write_bio_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_bio_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='x')]),
 'PEM_write_bio_Parameters': Function(type='int', derefcnt=0, name='PEM_write_bio_Parameters', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='x')]),
 'PEM_write_bio_PrivateKey': Function(type='int', derefcnt=0, name='PEM_write_bio_PrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_bio_RSAPrivateKey': Function(type='int', derefcnt=0, name='PEM_write_bio_RSAPrivateKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='unsigned', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'PEM_write_bio_RSAPublicKey': Function(type='int', derefcnt=0, name='PEM_write_bio_RSAPublicKey', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=1, name='x')]),
 'PEM_write_bio_RSA_PUBKEY': Function(type='int', derefcnt=0, name='PEM_write_bio_RSA_PUBKEY', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=1, name='x')]),
 'PEM_write_bio_SSL_SESSION': Function(type='int', derefcnt=0, name='PEM_write_bio_SSL_SESSION', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='SSL_SESSION', derefcnt=1, name='x')]),
 'PEM_write_bio_X509': Function(type='int', derefcnt=0, name='PEM_write_bio_X509', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x')]),
 'PEM_write_bio_X509_AUX': Function(type='int', derefcnt=0, name='PEM_write_bio_X509_AUX', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x')]),
 'PEM_write_bio_X509_CERT_PAIR': Function(type='int', derefcnt=0, name='PEM_write_bio_X509_CERT_PAIR', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CERT_PAIR', derefcnt=1, name='x')]),
 'PEM_write_bio_X509_CRL': Function(type='int', derefcnt=0, name='PEM_write_bio_X509_CRL', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CRL', derefcnt=1, name='x')]),
 'PEM_write_bio_X509_REQ': Function(type='int', derefcnt=0, name='PEM_write_bio_X509_REQ', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=1, name='x')]),
 'PEM_write_bio_X509_REQ_NEW': Function(type='int', derefcnt=0, name='PEM_write_bio_X509_REQ_NEW', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=1, name='x')]),
 'PKCS1_MGF1': Function(type='int', derefcnt=0, name='PKCS1_MGF1', args=[Argument(type='unsigned', derefcnt=1, name='mask'), Argument(type='long', derefcnt=0, name='len'), Argument(type='unsigned', derefcnt=1, name='seed'), Argument(type='long', derefcnt=0, name='seedlen'), Argument(type='EVP_MD', derefcnt=1, name='dgst')]),
 'PKCS5_PBE_add': Function(type='void', derefcnt=0, name='PKCS5_PBE_add', args=[]),
 'PKCS5_PBE_keyivgen': Function(type='int', derefcnt=0, name='PKCS5_PBE_keyivgen', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='pass'), Argument(type='int', derefcnt=0, name='passlen'), Argument(type='ASN1_TYPE', derefcnt=1, name='param'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='EVP_MD', derefcnt=1, name='md'), Argument(type='int', derefcnt=0, name='en_de')]),
 'PKCS5_PBKDF2_HMAC': Function(type='int', derefcnt=0, name='PKCS5_PBKDF2_HMAC', args=[Argument(type='char', derefcnt=1, name='pass'), Argument(type='int', derefcnt=0, name='passlen'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='int', derefcnt=0, name='saltlen'), Argument(type='int', derefcnt=0, name='iter'), Argument(type='EVP_MD', derefcnt=1, name='digest'), Argument(type='int', derefcnt=0, name='keylen'), Argument(type='unsigned', derefcnt=1, name='out')]),
 'PKCS5_PBKDF2_HMAC_SHA1': Function(type='int', derefcnt=0, name='PKCS5_PBKDF2_HMAC_SHA1', args=[Argument(type='char', derefcnt=1, name='pass'), Argument(type='int', derefcnt=0, name='passlen'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='int', derefcnt=0, name='saltlen'), Argument(type='int', derefcnt=0, name='iter'), Argument(type='int', derefcnt=0, name='keylen'), Argument(type='unsigned', derefcnt=1, name='out')]),
 'PKCS5_pbe2_set': Function(type='X509_ALGOR', derefcnt=1, name='PKCS5_pbe2_set', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='int', derefcnt=0, name='iter'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='int', derefcnt=0, name='saltlen')]),
 'PKCS5_pbe2_set_iv': Function(type='X509_ALGOR', derefcnt=1, name='PKCS5_pbe2_set_iv', args=[Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='int', derefcnt=0, name='iter'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='int', derefcnt=0, name='saltlen'), Argument(type='unsigned', derefcnt=1, name='aiv'), Argument(type='int', derefcnt=0, name='prf_nid')]),
 'PKCS5_pbe_set': Function(type='X509_ALGOR', derefcnt=1, name='PKCS5_pbe_set', args=[Argument(type='int', derefcnt=0, name='alg'), Argument(type='int', derefcnt=0, name='iter'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='int', derefcnt=0, name='saltlen')]),
 'PKCS5_pbe_set0_algor': Function(type='int', derefcnt=0, name='PKCS5_pbe_set0_algor', args=[Argument(type='X509_ALGOR', derefcnt=1, name='algor'), Argument(type='int', derefcnt=0, name='alg'), Argument(type='int', derefcnt=0, name='iter'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='int', derefcnt=0, name='saltlen')]),
 'PKCS5_pbkdf2_set': Function(type='X509_ALGOR', derefcnt=1, name='PKCS5_pbkdf2_set', args=[Argument(type='int', derefcnt=0, name='iter'), Argument(type='unsigned', derefcnt=1, name='salt'), Argument(type='int', derefcnt=0, name='saltlen'), Argument(type='int', derefcnt=0, name='prf_nid'), Argument(type='int', derefcnt=0, name='keylen')]),
 'PKCS5_v2_PBE_keyivgen': Function(type='int', derefcnt=0, name='PKCS5_v2_PBE_keyivgen', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='pass'), Argument(type='int', derefcnt=0, name='passlen'), Argument(type='ASN1_TYPE', derefcnt=1, name='param'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='EVP_MD', derefcnt=1, name='md'), Argument(type='int', derefcnt=0, name='en_de')]),
 'PKCS7_DIGEST_free': Function(type='void', derefcnt=0, name='PKCS7_DIGEST_free', args=[Argument(type='PKCS7_DIGEST', derefcnt=1, name='a')]),
 'PKCS7_DIGEST_new': Function(type='PKCS7_DIGEST', derefcnt=1, name='PKCS7_DIGEST_new', args=[]),
 'PKCS7_ENCRYPT_free': Function(type='void', derefcnt=0, name='PKCS7_ENCRYPT_free', args=[Argument(type='PKCS7_ENCRYPT', derefcnt=1, name='a')]),
 'PKCS7_ENCRYPT_new': Function(type='PKCS7_ENCRYPT', derefcnt=1, name='PKCS7_ENCRYPT_new', args=[]),
 'PKCS7_ENC_CONTENT_free': Function(type='void', derefcnt=0, name='PKCS7_ENC_CONTENT_free', args=[Argument(type='PKCS7_ENC_CONTENT', derefcnt=1, name='a')]),
 'PKCS7_ENC_CONTENT_new': Function(type='PKCS7_ENC_CONTENT', derefcnt=1, name='PKCS7_ENC_CONTENT_new', args=[]),
 'PKCS7_ENVELOPE_free': Function(type='void', derefcnt=0, name='PKCS7_ENVELOPE_free', args=[Argument(type='PKCS7_ENVELOPE', derefcnt=1, name='a')]),
 'PKCS7_ENVELOPE_new': Function(type='PKCS7_ENVELOPE', derefcnt=1, name='PKCS7_ENVELOPE_new', args=[]),
 'PKCS7_ISSUER_AND_SERIAL_digest': Function(type='int', derefcnt=0, name='PKCS7_ISSUER_AND_SERIAL_digest', args=[Argument(type='PKCS7_ISSUER_AND_SERIAL', derefcnt=1, name='data'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'PKCS7_ISSUER_AND_SERIAL_free': Function(type='void', derefcnt=0, name='PKCS7_ISSUER_AND_SERIAL_free', args=[Argument(type='PKCS7_ISSUER_AND_SERIAL', derefcnt=1, name='a')]),
 'PKCS7_ISSUER_AND_SERIAL_new': Function(type='PKCS7_ISSUER_AND_SERIAL', derefcnt=1, name='PKCS7_ISSUER_AND_SERIAL_new', args=[]),
 'PKCS7_RECIP_INFO_free': Function(type='void', derefcnt=0, name='PKCS7_RECIP_INFO_free', args=[Argument(type='PKCS7_RECIP_INFO', derefcnt=1, name='a')]),
 'PKCS7_RECIP_INFO_get0_alg': Function(type='void', derefcnt=0, name='PKCS7_RECIP_INFO_get0_alg', args=[Argument(type='PKCS7_RECIP_INFO', derefcnt=1, name='ri'), Argument(type='X509_ALGOR', derefcnt=2, name='penc')]),
 'PKCS7_RECIP_INFO_new': Function(type='PKCS7_RECIP_INFO', derefcnt=1, name='PKCS7_RECIP_INFO_new', args=[]),
 'PKCS7_RECIP_INFO_set': Function(type='int', derefcnt=0, name='PKCS7_RECIP_INFO_set', args=[Argument(type='PKCS7_RECIP_INFO', derefcnt=1, name='p7i'), Argument(type='X509', derefcnt=1, name='x509')]),
 'PKCS7_SIGNED_free': Function(type='void', derefcnt=0, name='PKCS7_SIGNED_free', args=[Argument(type='PKCS7_SIGNED', derefcnt=1, name='a')]),
 'PKCS7_SIGNED_new': Function(type='PKCS7_SIGNED', derefcnt=1, name='PKCS7_SIGNED_new', args=[]),
 'PKCS7_SIGNER_INFO_free': Function(type='void', derefcnt=0, name='PKCS7_SIGNER_INFO_free', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='a')]),
 'PKCS7_SIGNER_INFO_get0_algs': Function(type='void', derefcnt=0, name='PKCS7_SIGNER_INFO_get0_algs', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='EVP_PKEY', derefcnt=2, name='pk'), Argument(type='X509_ALGOR', derefcnt=2, name='pdig'), Argument(type='X509_ALGOR', derefcnt=2, name='psig')]),
 'PKCS7_SIGNER_INFO_new': Function(type='PKCS7_SIGNER_INFO', derefcnt=1, name='PKCS7_SIGNER_INFO_new', args=[]),
 'PKCS7_SIGNER_INFO_set': Function(type='int', derefcnt=0, name='PKCS7_SIGNER_INFO_set', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='p7i'), Argument(type='X509', derefcnt=1, name='x509'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='dgst')]),
 'PKCS7_SIGNER_INFO_sign': Function(type='int', derefcnt=0, name='PKCS7_SIGNER_INFO_sign', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si')]),
 'PKCS7_SIGN_ENVELOPE_free': Function(type='void', derefcnt=0, name='PKCS7_SIGN_ENVELOPE_free', args=[Argument(type='PKCS7_SIGN_ENVELOPE', derefcnt=1, name='a')]),
 'PKCS7_SIGN_ENVELOPE_new': Function(type='PKCS7_SIGN_ENVELOPE', derefcnt=1, name='PKCS7_SIGN_ENVELOPE_new', args=[]),
 'PKCS7_add0_attrib_signing_time': Function(type='int', derefcnt=0, name='PKCS7_add0_attrib_signing_time', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='ASN1_TIME', derefcnt=1, name='t')]),
 'PKCS7_add1_attrib_digest': Function(type='int', derefcnt=0, name='PKCS7_add1_attrib_digest', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='int', derefcnt=0, name='mdlen')]),
 'PKCS7_add_attrib_content_type': Function(type='int', derefcnt=0, name='PKCS7_add_attrib_content_type', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='ASN1_OBJECT', derefcnt=1, name='coid')]),
 'PKCS7_add_attrib_smimecap': Function(type='int', derefcnt=0, name='PKCS7_add_attrib_smimecap', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='stack_st_X509_ALGOR', derefcnt=1, name='cap')]),
 'PKCS7_add_attribute': Function(type='int', derefcnt=0, name='PKCS7_add_attribute', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='p7si'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='atrtype'), Argument(type='void', derefcnt=1, name='value')]),
 'PKCS7_add_certificate': Function(type='int', derefcnt=0, name='PKCS7_add_certificate', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='X509', derefcnt=1, name='x509')]),
 'PKCS7_add_crl': Function(type='int', derefcnt=0, name='PKCS7_add_crl', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='X509_CRL', derefcnt=1, name='x509')]),
 'PKCS7_add_recipient': Function(type='PKCS7_RECIP_INFO', derefcnt=1, name='PKCS7_add_recipient', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='X509', derefcnt=1, name='x509')]),
 'PKCS7_add_recipient_info': Function(type='int', derefcnt=0, name='PKCS7_add_recipient_info', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='PKCS7_RECIP_INFO', derefcnt=1, name='ri')]),
 'PKCS7_add_signature': Function(type='PKCS7_SIGNER_INFO', derefcnt=1, name='PKCS7_add_signature', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='X509', derefcnt=1, name='x509'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='dgst')]),
 'PKCS7_add_signed_attribute': Function(type='int', derefcnt=0, name='PKCS7_add_signed_attribute', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='p7si'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='type'), Argument(type='void', derefcnt=1, name='data')]),
 'PKCS7_add_signer': Function(type='int', derefcnt=0, name='PKCS7_add_signer', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='p7i')]),
 'PKCS7_cert_from_signer_info': Function(type='X509', derefcnt=1, name='PKCS7_cert_from_signer_info', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si')]),
 'PKCS7_content_new': Function(type='int', derefcnt=0, name='PKCS7_content_new', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='int', derefcnt=0, name='nid')]),
 'PKCS7_ctrl': Function(type='long', derefcnt=0, name='PKCS7_ctrl', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg'), Argument(type='char', derefcnt=1, name='parg')]),
 'PKCS7_dataDecode': Function(type='BIO', derefcnt=1, name='PKCS7_dataDecode', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='BIO', derefcnt=1, name='in_bio'), Argument(type='X509', derefcnt=1, name='pcert')]),
 'PKCS7_dataFinal': Function(type='int', derefcnt=0, name='PKCS7_dataFinal', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='BIO', derefcnt=1, name='bio')]),
 'PKCS7_dataInit': Function(type='BIO', derefcnt=1, name='PKCS7_dataInit', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='BIO', derefcnt=1, name='bio')]),
 'PKCS7_dataVerify': Function(type='int', derefcnt=0, name='PKCS7_dataVerify', args=[Argument(type='X509_STORE', derefcnt=1, name='cert_store'), Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si')]),
 'PKCS7_decrypt': Function(type='int', derefcnt=0, name='PKCS7_decrypt', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='X509', derefcnt=1, name='cert'), Argument(type='BIO', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='flags')]),
 'PKCS7_digest_from_attributes': Function(type='ASN1_OCTET_STRING', derefcnt=1, name='PKCS7_digest_from_attributes', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='sk')]),
 'PKCS7_dup': Function(type='PKCS7', derefcnt=1, name='PKCS7_dup', args=[Argument(type='PKCS7', derefcnt=1, name='p7')]),
 'PKCS7_encrypt': Function(type='PKCS7', derefcnt=1, name='PKCS7_encrypt', args=[Argument(type='stack_st_X509', derefcnt=1, name='certs'), Argument(type='BIO', derefcnt=1, name='in'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher'), Argument(type='int', derefcnt=0, name='flags')]),
 'PKCS7_final': Function(type='int', derefcnt=0, name='PKCS7_final', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='BIO', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='flags')]),
 'PKCS7_free': Function(type='void', derefcnt=0, name='PKCS7_free', args=[Argument(type='PKCS7', derefcnt=1, name='a')]),
 'PKCS7_get0_signers': Function(type='stack_st_X509', derefcnt=1, name='PKCS7_get0_signers', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='stack_st_X509', derefcnt=1, name='certs'), Argument(type='int', derefcnt=0, name='flags')]),
 'PKCS7_get_attribute': Function(type='ASN1_TYPE', derefcnt=1, name='PKCS7_get_attribute', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='int', derefcnt=0, name='nid')]),
 'PKCS7_get_issuer_and_serial': Function(type='PKCS7_ISSUER_AND_SERIAL', derefcnt=1, name='PKCS7_get_issuer_and_serial', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='int', derefcnt=0, name='idx')]),
 'PKCS7_get_signed_attribute': Function(type='ASN1_TYPE', derefcnt=1, name='PKCS7_get_signed_attribute', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='int', derefcnt=0, name='nid')]),
 'PKCS7_get_signer_info': Function(type='stack_st_PKCS7_SIGNER_INFO', derefcnt=1, name='PKCS7_get_signer_info', args=[Argument(type='PKCS7', derefcnt=1, name='p7')]),
 'PKCS7_get_smimecap': Function(type='stack_st_X509_ALGOR', derefcnt=1, name='PKCS7_get_smimecap', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si')]),
 'PKCS7_new': Function(type='PKCS7', derefcnt=1, name='PKCS7_new', args=[]),
 'PKCS7_print_ctx': Function(type='int', derefcnt=0, name='PKCS7_print_ctx', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='PKCS7', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='ASN1_PCTX', derefcnt=1, name='pctx')]),
 'PKCS7_set0_type_other': Function(type='int', derefcnt=0, name='PKCS7_set0_type_other', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='int', derefcnt=0, name='type'), Argument(type='ASN1_TYPE', derefcnt=1, name='other')]),
 'PKCS7_set_attributes': Function(type='int', derefcnt=0, name='PKCS7_set_attributes', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='p7si'), Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='sk')]),
 'PKCS7_set_cipher': Function(type='int', derefcnt=0, name='PKCS7_set_cipher', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='EVP_CIPHER', derefcnt=1, name='cipher')]),
 'PKCS7_set_content': Function(type='int', derefcnt=0, name='PKCS7_set_content', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='PKCS7', derefcnt=1, name='p7_data')]),
 'PKCS7_set_digest': Function(type='int', derefcnt=0, name='PKCS7_set_digest', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'PKCS7_set_signed_attributes': Function(type='int', derefcnt=0, name='PKCS7_set_signed_attributes', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='p7si'), Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='sk')]),
 'PKCS7_set_type': Function(type='int', derefcnt=0, name='PKCS7_set_type', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='int', derefcnt=0, name='type')]),
 'PKCS7_sign': Function(type='PKCS7', derefcnt=1, name='PKCS7_sign', args=[Argument(type='X509', derefcnt=1, name='signcert'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='stack_st_X509', derefcnt=1, name='certs'), Argument(type='BIO', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='flags')]),
 'PKCS7_sign_add_signer': Function(type='PKCS7_SIGNER_INFO', derefcnt=1, name='PKCS7_sign_add_signer', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='X509', derefcnt=1, name='signcert'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='md'), Argument(type='int', derefcnt=0, name='flags')]),
 'PKCS7_signatureVerify': Function(type='int', derefcnt=0, name='PKCS7_signatureVerify', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='si'), Argument(type='X509', derefcnt=1, name='x509')]),
 'PKCS7_simple_smimecap': Function(type='int', derefcnt=0, name='PKCS7_simple_smimecap', args=[Argument(type='stack_st_X509_ALGOR', derefcnt=1, name='sk'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='arg')]),
 'PKCS7_stream': Function(type='int', derefcnt=0, name='PKCS7_stream', args=[Argument(type='unsigned', derefcnt=3, name='boundary'), Argument(type='PKCS7', derefcnt=1, name='p7')]),
 'PKCS7_verify': Function(type='int', derefcnt=0, name='PKCS7_verify', args=[Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='stack_st_X509', derefcnt=1, name='certs'), Argument(type='X509_STORE', derefcnt=1, name='store'), Argument(type='BIO', derefcnt=1, name='indata'), Argument(type='BIO', derefcnt=1, name='out'), Argument(type='int', derefcnt=0, name='flags')]),
 'PKCS8_PRIV_KEY_INFO_free': Function(type='void', derefcnt=0, name='PKCS8_PRIV_KEY_INFO_free', args=[Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='a')]),
 'PKCS8_PRIV_KEY_INFO_new': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='PKCS8_PRIV_KEY_INFO_new', args=[]),
 'PKCS8_pkey_get0': Function(type='int', derefcnt=0, name='PKCS8_pkey_get0', args=[Argument(type='ASN1_OBJECT', derefcnt=2, name='ppkalg'), Argument(type='unsigned', derefcnt=2, name='pk'), Argument(type='int', derefcnt=1, name='ppklen'), Argument(type='X509_ALGOR', derefcnt=2, name='pa'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='p8')]),
 'PKCS8_pkey_set0': Function(type='int', derefcnt=0, name='PKCS8_pkey_set0', args=[Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='priv'), Argument(type='ASN1_OBJECT', derefcnt=1, name='aobj'), Argument(type='int', derefcnt=0, name='version'), Argument(type='int', derefcnt=0, name='ptype'), Argument(type='void', derefcnt=1, name='pval'), Argument(type='unsigned', derefcnt=1, name='penc'), Argument(type='int', derefcnt=0, name='penclen')]),
 'PKCS8_set_broken': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='PKCS8_set_broken', args=[Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='p8'), Argument(type='int', derefcnt=0, name='broken')]),
 'RSAPrivateKey_dup': Function(type='RSA', derefcnt=1, name='RSAPrivateKey_dup', args=[Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSAPublicKey_dup': Function(type='RSA', derefcnt=1, name='RSAPublicKey_dup', args=[Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_PKCS1_SSLeay': Function(type='RSA_METHOD', derefcnt=1, name='RSA_PKCS1_SSLeay', args=[]),
 'RSA_PSS_PARAMS_free': Function(type='void', derefcnt=0, name='RSA_PSS_PARAMS_free', args=[Argument(type='RSA_PSS_PARAMS', derefcnt=1, name='a')]),
 'RSA_PSS_PARAMS_new': Function(type='RSA_PSS_PARAMS', derefcnt=1, name='RSA_PSS_PARAMS_new', args=[]),
 'RSA_X931_hash_id': Function(type='int', derefcnt=0, name='RSA_X931_hash_id', args=[Argument(type='int', derefcnt=0, name='nid')]),
 'RSA_blinding_off': Function(type='void', derefcnt=0, name='RSA_blinding_off', args=[Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_blinding_on': Function(type='int', derefcnt=0, name='RSA_blinding_on', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'RSA_check_key': Function(type='int', derefcnt=0, name='RSA_check_key', args=[Argument(type='RSA', derefcnt=1, name='arg0')]),
 'RSA_flags': Function(type='int', derefcnt=0, name='RSA_flags', args=[Argument(type='RSA', derefcnt=1, name='r')]),
 'RSA_free': Function(type='void', derefcnt=0, name='RSA_free', args=[Argument(type='RSA', derefcnt=1, name='r')]),
 'RSA_generate_key': Function(type='RSA', derefcnt=1, name='RSA_generate_key', args=[Argument(type='int', derefcnt=0, name='bits'), Argument(type='unsigned', derefcnt=0, name='e'), Argument(type='void', derefcnt=0, name='callback'), Argument(type='void', derefcnt=1, name='cb_arg')]),
 'RSA_generate_key_ex': Function(type='int', derefcnt=0, name='RSA_generate_key_ex', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='BIGNUM', derefcnt=1, name='e'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'RSA_get_default_method': Function(type='RSA_METHOD', derefcnt=1, name='RSA_get_default_method', args=[]),
 'RSA_get_ex_data': Function(type='void', derefcnt=1, name='RSA_get_ex_data', args=[Argument(type='RSA', derefcnt=1, name='r'), Argument(type='int', derefcnt=0, name='idx')]),
 'RSA_get_ex_new_index': Function(type='int', derefcnt=0, name='RSA_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'RSA_get_method': Function(type='RSA_METHOD', derefcnt=1, name='RSA_get_method', args=[Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_memory_lock': Function(type='int', derefcnt=0, name='RSA_memory_lock', args=[Argument(type='RSA', derefcnt=1, name='r')]),
 'RSA_new': Function(type='RSA', derefcnt=1, name='RSA_new', args=[]),
 'RSA_new_method': Function(type='RSA', derefcnt=1, name='RSA_new_method', args=[Argument(type='ENGINE', derefcnt=1, name='engine')]),
 'RSA_null_method': Function(type='RSA_METHOD', derefcnt=1, name='RSA_null_method', args=[]),
 'RSA_padding_add_PKCS1_OAEP': Function(type='int', derefcnt=0, name='RSA_padding_add_PKCS1_OAEP', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl'), Argument(type='unsigned', derefcnt=1, name='p'), Argument(type='int', derefcnt=0, name='pl')]),
 'RSA_padding_add_PKCS1_PSS': Function(type='int', derefcnt=0, name='RSA_padding_add_PKCS1_PSS', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='unsigned', derefcnt=1, name='EM'), Argument(type='unsigned', derefcnt=1, name='mHash'), Argument(type='EVP_MD', derefcnt=1, name='Hash'), Argument(type='int', derefcnt=0, name='sLen')]),
 'RSA_padding_add_PKCS1_PSS_mgf1': Function(type='int', derefcnt=0, name='RSA_padding_add_PKCS1_PSS_mgf1', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='unsigned', derefcnt=1, name='EM'), Argument(type='unsigned', derefcnt=1, name='mHash'), Argument(type='EVP_MD', derefcnt=1, name='Hash'), Argument(type='EVP_MD', derefcnt=1, name='mgf1Hash'), Argument(type='int', derefcnt=0, name='sLen')]),
 'RSA_padding_add_PKCS1_type_1': Function(type='int', derefcnt=0, name='RSA_padding_add_PKCS1_type_1', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl')]),
 'RSA_padding_add_PKCS1_type_2': Function(type='int', derefcnt=0, name='RSA_padding_add_PKCS1_type_2', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl')]),
 'RSA_padding_add_SSLv23': Function(type='int', derefcnt=0, name='RSA_padding_add_SSLv23', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl')]),
 'RSA_padding_add_X931': Function(type='int', derefcnt=0, name='RSA_padding_add_X931', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl')]),
 'RSA_padding_add_none': Function(type='int', derefcnt=0, name='RSA_padding_add_none', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl')]),
 'RSA_padding_check_PKCS1_OAEP': Function(type='int', derefcnt=0, name='RSA_padding_check_PKCS1_OAEP', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl'), Argument(type='int', derefcnt=0, name='rsa_len'), Argument(type='unsigned', derefcnt=1, name='p'), Argument(type='int', derefcnt=0, name='pl')]),
 'RSA_padding_check_PKCS1_type_1': Function(type='int', derefcnt=0, name='RSA_padding_check_PKCS1_type_1', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl'), Argument(type='int', derefcnt=0, name='rsa_len')]),
 'RSA_padding_check_PKCS1_type_2': Function(type='int', derefcnt=0, name='RSA_padding_check_PKCS1_type_2', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl'), Argument(type='int', derefcnt=0, name='rsa_len')]),
 'RSA_padding_check_SSLv23': Function(type='int', derefcnt=0, name='RSA_padding_check_SSLv23', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl'), Argument(type='int', derefcnt=0, name='rsa_len')]),
 'RSA_padding_check_X931': Function(type='int', derefcnt=0, name='RSA_padding_check_X931', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl'), Argument(type='int', derefcnt=0, name='rsa_len')]),
 'RSA_padding_check_none': Function(type='int', derefcnt=0, name='RSA_padding_check_none', args=[Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='tlen'), Argument(type='unsigned', derefcnt=1, name='f'), Argument(type='int', derefcnt=0, name='fl'), Argument(type='int', derefcnt=0, name='rsa_len')]),
 'RSA_print': Function(type='int', derefcnt=0, name='RSA_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=1, name='r'), Argument(type='int', derefcnt=0, name='offset')]),
 'RSA_print_fp': Function(type='int', derefcnt=0, name='RSA_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=1, name='r'), Argument(type='int', derefcnt=0, name='offset')]),
 'RSA_private_decrypt': Function(type='int', derefcnt=0, name='RSA_private_decrypt', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'RSA_private_encrypt': Function(type='int', derefcnt=0, name='RSA_private_encrypt', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'RSA_public_decrypt': Function(type='int', derefcnt=0, name='RSA_public_decrypt', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'RSA_public_encrypt': Function(type='int', derefcnt=0, name='RSA_public_encrypt', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'RSA_set_default_method': Function(type='void', derefcnt=0, name='RSA_set_default_method', args=[Argument(type='RSA_METHOD', derefcnt=1, name='meth')]),
 'RSA_set_ex_data': Function(type='int', derefcnt=0, name='RSA_set_ex_data', args=[Argument(type='RSA', derefcnt=1, name='r'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='arg')]),
 'RSA_set_method': Function(type='int', derefcnt=0, name='RSA_set_method', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='RSA_METHOD', derefcnt=1, name='meth')]),
 'RSA_setup_blinding': Function(type='BN_BLINDING', derefcnt=1, name='RSA_setup_blinding', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'RSA_sign': Function(type='int', derefcnt=0, name='RSA_sign', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigret'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_sign_ASN1_OCTET_STRING': Function(type='int', derefcnt=0, name='RSA_sign_ASN1_OCTET_STRING', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigret'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_size': Function(type='int', derefcnt=0, name='RSA_size', args=[Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_up_ref': Function(type='int', derefcnt=0, name='RSA_up_ref', args=[Argument(type='RSA', derefcnt=1, name='r')]),
 'RSA_verify': Function(type='int', derefcnt=0, name='RSA_verify', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigbuf'), Argument(type='unsigned', derefcnt=0, name='siglen'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_verify_ASN1_OCTET_STRING': Function(type='int', derefcnt=0, name='RSA_verify_ASN1_OCTET_STRING', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigbuf'), Argument(type='unsigned', derefcnt=0, name='siglen'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'RSA_verify_PKCS1_PSS': Function(type='int', derefcnt=0, name='RSA_verify_PKCS1_PSS', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='unsigned', derefcnt=1, name='mHash'), Argument(type='EVP_MD', derefcnt=1, name='Hash'), Argument(type='unsigned', derefcnt=1, name='EM'), Argument(type='int', derefcnt=0, name='sLen')]),
 'RSA_verify_PKCS1_PSS_mgf1': Function(type='int', derefcnt=0, name='RSA_verify_PKCS1_PSS_mgf1', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='unsigned', derefcnt=1, name='mHash'), Argument(type='EVP_MD', derefcnt=1, name='Hash'), Argument(type='EVP_MD', derefcnt=1, name='mgf1Hash'), Argument(type='unsigned', derefcnt=1, name='EM'), Argument(type='int', derefcnt=0, name='sLen')]),
 'SHA': Function(type='unsigned', derefcnt=1, name='SHA', args=[Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='unsigned', derefcnt=1, name='md')]),
 'SHA1': Function(type='unsigned', derefcnt=1, name='SHA1', args=[Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='unsigned', derefcnt=1, name='md')]),
 'SHA1_Final': Function(type='int', derefcnt=0, name='SHA1_Final', args=[Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='SHA_CTX', derefcnt=1, name='c')]),
 'SHA1_Init': Function(type='int', derefcnt=0, name='SHA1_Init', args=[Argument(type='SHA_CTX', derefcnt=1, name='c')]),
 'SHA1_Transform': Function(type='void', derefcnt=0, name='SHA1_Transform', args=[Argument(type='SHA_CTX', derefcnt=1, name='c'), Argument(type='unsigned', derefcnt=1, name='data')]),
 'SHA1_Update': Function(type='int', derefcnt=0, name='SHA1_Update', args=[Argument(type='SHA_CTX', derefcnt=1, name='c'), Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='len')]),
 'SHA224': Function(type='unsigned', derefcnt=1, name='SHA224', args=[Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='unsigned', derefcnt=1, name='md')]),
 'SHA224_Final': Function(type='int', derefcnt=0, name='SHA224_Final', args=[Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='SHA256_CTX', derefcnt=1, name='c')]),
 'SHA224_Init': Function(type='int', derefcnt=0, name='SHA224_Init', args=[Argument(type='SHA256_CTX', derefcnt=1, name='c')]),
 'SHA224_Update': Function(type='int', derefcnt=0, name='SHA224_Update', args=[Argument(type='SHA256_CTX', derefcnt=1, name='c'), Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='len')]),
 'SHA256': Function(type='unsigned', derefcnt=1, name='SHA256', args=[Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='unsigned', derefcnt=1, name='md')]),
 'SHA256_Final': Function(type='int', derefcnt=0, name='SHA256_Final', args=[Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='SHA256_CTX', derefcnt=1, name='c')]),
 'SHA256_Init': Function(type='int', derefcnt=0, name='SHA256_Init', args=[Argument(type='SHA256_CTX', derefcnt=1, name='c')]),
 'SHA256_Transform': Function(type='void', derefcnt=0, name='SHA256_Transform', args=[Argument(type='SHA256_CTX', derefcnt=1, name='c'), Argument(type='unsigned', derefcnt=1, name='data')]),
 'SHA256_Update': Function(type='int', derefcnt=0, name='SHA256_Update', args=[Argument(type='SHA256_CTX', derefcnt=1, name='c'), Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='len')]),
 'SHA384': Function(type='unsigned', derefcnt=1, name='SHA384', args=[Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='unsigned', derefcnt=1, name='md')]),
 'SHA384_Final': Function(type='int', derefcnt=0, name='SHA384_Final', args=[Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='SHA512_CTX', derefcnt=1, name='c')]),
 'SHA384_Init': Function(type='int', derefcnt=0, name='SHA384_Init', args=[Argument(type='SHA512_CTX', derefcnt=1, name='c')]),
 'SHA384_Update': Function(type='int', derefcnt=0, name='SHA384_Update', args=[Argument(type='SHA512_CTX', derefcnt=1, name='c'), Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='len')]),
 'SHA512': Function(type='unsigned', derefcnt=1, name='SHA512', args=[Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='unsigned', derefcnt=1, name='md')]),
 'SHA512_Final': Function(type='int', derefcnt=0, name='SHA512_Final', args=[Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='SHA512_CTX', derefcnt=1, name='c')]),
 'SHA512_Init': Function(type='int', derefcnt=0, name='SHA512_Init', args=[Argument(type='SHA512_CTX', derefcnt=1, name='c')]),
 'SHA512_Transform': Function(type='void', derefcnt=0, name='SHA512_Transform', args=[Argument(type='SHA512_CTX', derefcnt=1, name='c'), Argument(type='unsigned', derefcnt=1, name='data')]),
 'SHA512_Update': Function(type='int', derefcnt=0, name='SHA512_Update', args=[Argument(type='SHA512_CTX', derefcnt=1, name='c'), Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='len')]),
 'SHA_Final': Function(type='int', derefcnt=0, name='SHA_Final', args=[Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='SHA_CTX', derefcnt=1, name='c')]),
 'SHA_Init': Function(type='int', derefcnt=0, name='SHA_Init', args=[Argument(type='SHA_CTX', derefcnt=1, name='c')]),
 'SHA_Transform': Function(type='void', derefcnt=0, name='SHA_Transform', args=[Argument(type='SHA_CTX', derefcnt=1, name='c'), Argument(type='unsigned', derefcnt=1, name='data')]),
 'SHA_Update': Function(type='int', derefcnt=0, name='SHA_Update', args=[Argument(type='SHA_CTX', derefcnt=1, name='c'), Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='len')]),
 'SMIME_crlf_copy': Function(type='int', derefcnt=0, name='SMIME_crlf_copy', args=[Argument(type='BIO', derefcnt=1, name='in'), Argument(type='BIO', derefcnt=1, name='out'), Argument(type='int', derefcnt=0, name='flags')]),
 'SMIME_read_ASN1': Function(type='ASN1_VALUE', derefcnt=1, name='SMIME_read_ASN1', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='BIO', derefcnt=2, name='bcont'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'SMIME_read_PKCS7': Function(type='PKCS7', derefcnt=1, name='SMIME_read_PKCS7', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='BIO', derefcnt=2, name='bcont')]),
 'SMIME_text': Function(type='int', derefcnt=0, name='SMIME_text', args=[Argument(type='BIO', derefcnt=1, name='in'), Argument(type='BIO', derefcnt=1, name='out')]),
 'SMIME_write_ASN1': Function(type='int', derefcnt=0, name='SMIME_write_ASN1', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='ASN1_VALUE', derefcnt=1, name='val'), Argument(type='BIO', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='ctype_nid'), Argument(type='int', derefcnt=0, name='econt_nid'), Argument(type='stack_st_X509_ALGOR', derefcnt=1, name='mdalgs'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'SMIME_write_PKCS7': Function(type='int', derefcnt=0, name='SMIME_write_PKCS7', args=[Argument(type='BIO', derefcnt=1, name='bio'), Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='BIO', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='flags')]),
 'SRP_Calc_A_param': Function(type='int', derefcnt=0, name='SRP_Calc_A_param', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SRP_generate_client_master_secret': Function(type='int', derefcnt=0, name='SRP_generate_client_master_secret', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=1, name='master_key')]),
 'SRP_generate_server_master_secret': Function(type='int', derefcnt=0, name='SRP_generate_server_master_secret', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=1, name='master_key')]),
 'SRP_give_srp_client_pwd_callback': Function(type='char', derefcnt=1, name='SRP_give_srp_client_pwd_callback', args=[Argument(type='SSL', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'SRP_verify_param_callback': Function(type='int', derefcnt=0, name='SRP_verify_param_callback', args=[Argument(type='SSL', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'SSL_CIPHER_description': Function(type='char', derefcnt=1, name='SSL_CIPHER_description', args=[Argument(type='SSL_CIPHER', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='size')]),
 'SSL_CIPHER_get_bits': Function(type='int', derefcnt=0, name='SSL_CIPHER_get_bits', args=[Argument(type='SSL_CIPHER', derefcnt=1, name='c'), Argument(type='int', derefcnt=1, name='alg_bits')]),
 'SSL_CIPHER_get_id': Function(type='unsigned', derefcnt=0, name='SSL_CIPHER_get_id', args=[Argument(type='SSL_CIPHER', derefcnt=1, name='c')]),
 'SSL_CIPHER_get_name': Function(type='char', derefcnt=1, name='SSL_CIPHER_get_name', args=[Argument(type='SSL_CIPHER', derefcnt=1, name='c')]),
 'SSL_CIPHER_get_version': Function(type='char', derefcnt=1, name='SSL_CIPHER_get_version', args=[Argument(type='SSL_CIPHER', derefcnt=1, name='c')]),
 'SSL_COMP_add_compression_method': Function(type='int', derefcnt=0, name='SSL_COMP_add_compression_method', args=[Argument(type='int', derefcnt=0, name='id'), Argument(type='COMP_METHOD', derefcnt=1, name='cm')]),
 'SSL_COMP_get_compression_methods': Function(type='stack_st_SSL_COMP', derefcnt=1, name='SSL_COMP_get_compression_methods', args=[]),
 'SSL_COMP_get_name': Function(type='char', derefcnt=1, name='SSL_COMP_get_name', args=[Argument(type='COMP_METHOD', derefcnt=1, name='comp')]),
 'SSL_CTX_SRP_CTX_free': Function(type='int', derefcnt=0, name='SSL_CTX_SRP_CTX_free', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_SRP_CTX_init': Function(type='int', derefcnt=0, name='SSL_CTX_SRP_CTX_init', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_add_client_CA': Function(type='int', derefcnt=0, name='SSL_CTX_add_client_CA', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='X509', derefcnt=1, name='x')]),
 'SSL_CTX_add_session': Function(type='int', derefcnt=0, name='SSL_CTX_add_session', args=[Argument(type='SSL_CTX', derefcnt=1, name='s'), Argument(type='SSL_SESSION', derefcnt=1, name='c')]),
 'SSL_CTX_callback_ctrl': Function(type='long', derefcnt=0, name='SSL_CTX_callback_ctrl', args=[Argument(type='SSL_CTX', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'SSL_CTX_check_private_key': Function(type='int', derefcnt=0, name='SSL_CTX_check_private_key', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_ctrl': Function(type='long', derefcnt=0, name='SSL_CTX_ctrl', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg'), Argument(type='void', derefcnt=1, name='parg')]),
 'SSL_CTX_flush_sessions': Function(type='void', derefcnt=0, name='SSL_CTX_flush_sessions', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='long', derefcnt=0, name='tm')]),
 'SSL_CTX_free': Function(type='void', derefcnt=0, name='SSL_CTX_free', args=[Argument(type='SSL_CTX', derefcnt=1, name='arg0')]),
 'SSL_CTX_get_cert_store': Function(type='X509_STORE', derefcnt=1, name='SSL_CTX_get_cert_store', args=[Argument(type='SSL_CTX', derefcnt=1, name='arg0')]),
 'SSL_CTX_get_client_CA_list': Function(type='stack_st_X509_NAME', derefcnt=1, name='SSL_CTX_get_client_CA_list', args=[Argument(type='SSL_CTX', derefcnt=1, name='s')]),
 'SSL_CTX_get_client_cert_cb': Function(type='int', derefcnt=0, name='SSL_CTX_get_client_cert_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_get_ex_data': Function(type='void', derefcnt=1, name='SSL_CTX_get_ex_data', args=[Argument(type='SSL_CTX', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='idx')]),
 'SSL_CTX_get_ex_new_index': Function(type='int', derefcnt=0, name='SSL_CTX_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'SSL_CTX_get_info_callback': Function(type='void', derefcnt=0, name='SSL_CTX_get_info_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_get_quiet_shutdown': Function(type='int', derefcnt=0, name='SSL_CTX_get_quiet_shutdown', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_get_timeout': Function(type='long', derefcnt=0, name='SSL_CTX_get_timeout', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_get_verify_callback': Function(type='int', derefcnt=0, name='SSL_CTX_get_verify_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_get_verify_depth': Function(type='int', derefcnt=0, name='SSL_CTX_get_verify_depth', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_get_verify_mode': Function(type='int', derefcnt=0, name='SSL_CTX_get_verify_mode', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_load_verify_locations': Function(type='int', derefcnt=0, name='SSL_CTX_load_verify_locations', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='CAfile'), Argument(type='char', derefcnt=1, name='CApath')]),
 'SSL_CTX_new': Function(type='SSL_CTX', derefcnt=1, name='SSL_CTX_new', args=[Argument(type='SSL_METHOD', derefcnt=1, name='meth')]),
 'SSL_CTX_remove_session': Function(type='int', derefcnt=0, name='SSL_CTX_remove_session', args=[Argument(type='SSL_CTX', derefcnt=1, name='arg0'), Argument(type='SSL_SESSION', derefcnt=1, name='c')]),
 'SSL_CTX_sess_get_get_cb': Function(type='SSL_SESSION', derefcnt=1, name='SSL_CTX_sess_get_get_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_sess_get_new_cb': Function(type='int', derefcnt=0, name='SSL_CTX_sess_get_new_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_sess_get_remove_cb': Function(type='void', derefcnt=0, name='SSL_CTX_sess_get_remove_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_sess_set_get_cb': Function(type='void', derefcnt=0, name='SSL_CTX_sess_set_get_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='SSL_SESSION', derefcnt=1, name='get_session_cb')]),
 'SSL_CTX_sess_set_new_cb': Function(type='void', derefcnt=0, name='SSL_CTX_sess_set_new_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='new_session_cb')]),
 'SSL_CTX_sess_set_remove_cb': Function(type='void', derefcnt=0, name='SSL_CTX_sess_set_remove_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=0, name='remove_session_cb')]),
 'SSL_CTX_sessions': Function(type='lhash_st_SSL_SESSION', derefcnt=1, name='SSL_CTX_sessions', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_set1_param': Function(type='int', derefcnt=0, name='SSL_CTX_set1_param', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='vpm')]),
 'SSL_CTX_set_cert_store': Function(type='void', derefcnt=0, name='SSL_CTX_set_cert_store', args=[Argument(type='SSL_CTX', derefcnt=1, name='arg0'), Argument(type='X509_STORE', derefcnt=1, name='arg1')]),
 'SSL_CTX_set_cert_verify_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_cert_verify_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cb'), Argument(type='void', derefcnt=1, name='arg')]),
 'SSL_CTX_set_cipher_list': Function(type='int', derefcnt=0, name='SSL_CTX_set_cipher_list', args=[Argument(type='SSL_CTX', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='str')]),
 'SSL_CTX_set_client_CA_list': Function(type='void', derefcnt=0, name='SSL_CTX_set_client_CA_list', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='stack_st_X509_NAME', derefcnt=1, name='name_list')]),
 'SSL_CTX_set_client_cert_cb': Function(type='void', derefcnt=0, name='SSL_CTX_set_client_cert_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='client_cert_cb')]),
 'SSL_CTX_set_client_cert_engine': Function(type='int', derefcnt=0, name='SSL_CTX_set_client_cert_engine', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='ENGINE', derefcnt=1, name='e')]),
 'SSL_CTX_set_cookie_generate_cb': Function(type='void', derefcnt=0, name='SSL_CTX_set_cookie_generate_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='app_gen_cookie_cb')]),
 'SSL_CTX_set_cookie_verify_cb': Function(type='void', derefcnt=0, name='SSL_CTX_set_cookie_verify_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='app_verify_cookie_cb')]),
 'SSL_CTX_set_default_passwd_cb': Function(type='void', derefcnt=0, name='SSL_CTX_set_default_passwd_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='pem_password_cb', derefcnt=1, name='cb')]),
 'SSL_CTX_set_default_passwd_cb_userdata': Function(type='void', derefcnt=0, name='SSL_CTX_set_default_passwd_cb_userdata', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='u')]),
 'SSL_CTX_set_default_verify_paths': Function(type='int', derefcnt=0, name='SSL_CTX_set_default_verify_paths', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_CTX_set_ex_data': Function(type='int', derefcnt=0, name='SSL_CTX_set_ex_data', args=[Argument(type='SSL_CTX', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='data')]),
 'SSL_CTX_set_generate_session_id': Function(type='int', derefcnt=0, name='SSL_CTX_set_generate_session_id', args=[Argument(type='SSL_CTX', derefcnt=1, name='arg0'), Argument(type='GEN_SESSION_CB', derefcnt=0, name='arg1')]),
 'SSL_CTX_set_info_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_info_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=0, name='cb')]),
 'SSL_CTX_set_msg_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_msg_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=0, name='cb')]),
 'SSL_CTX_set_next_proto_select_cb': Function(type='void', derefcnt=0, name='SSL_CTX_set_next_proto_select_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='cb'), Argument(type='void', derefcnt=1, name='arg')]),
 'SSL_CTX_set_next_protos_advertised_cb': Function(type='void', derefcnt=0, name='SSL_CTX_set_next_protos_advertised_cb', args=[Argument(type='SSL_CTX', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='cb'), Argument(type='void', derefcnt=1, name='arg')]),
 'SSL_CTX_set_psk_client_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_psk_client_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=0, name='psk_client_callback')]),
 'SSL_CTX_set_psk_server_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_psk_server_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=0, name='psk_server_callback')]),
 'SSL_CTX_set_purpose': Function(type='int', derefcnt=0, name='SSL_CTX_set_purpose', args=[Argument(type='SSL_CTX', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='purpose')]),
 'SSL_CTX_set_quiet_shutdown': Function(type='void', derefcnt=0, name='SSL_CTX_set_quiet_shutdown', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='mode')]),
 'SSL_CTX_set_session_id_context': Function(type='int', derefcnt=0, name='SSL_CTX_set_session_id_context', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='sid_ctx'), Argument(type='unsigned', derefcnt=0, name='sid_ctx_len')]),
 'SSL_CTX_set_srp_cb_arg': Function(type='int', derefcnt=0, name='SSL_CTX_set_srp_cb_arg', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='arg')]),
 'SSL_CTX_set_srp_client_pwd_callback': Function(type='int', derefcnt=0, name='SSL_CTX_set_srp_client_pwd_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='cb')]),
 'SSL_CTX_set_srp_password': Function(type='int', derefcnt=0, name='SSL_CTX_set_srp_password', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='password')]),
 'SSL_CTX_set_srp_strength': Function(type='int', derefcnt=0, name='SSL_CTX_set_srp_strength', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='strength')]),
 'SSL_CTX_set_srp_username': Function(type='int', derefcnt=0, name='SSL_CTX_set_srp_username', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='name')]),
 'SSL_CTX_set_srp_username_callback': Function(type='int', derefcnt=0, name='SSL_CTX_set_srp_username_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cb')]),
 'SSL_CTX_set_srp_verify_param_callback': Function(type='int', derefcnt=0, name='SSL_CTX_set_srp_verify_param_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cb')]),
 'SSL_CTX_set_ssl_version': Function(type='int', derefcnt=0, name='SSL_CTX_set_ssl_version', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='SSL_METHOD', derefcnt=1, name='meth')]),
 'SSL_CTX_set_timeout': Function(type='long', derefcnt=0, name='SSL_CTX_set_timeout', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='long', derefcnt=0, name='t')]),
 'SSL_CTX_set_tlsext_use_srtp': Function(type='int', derefcnt=0, name='SSL_CTX_set_tlsext_use_srtp', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='profiles')]),
 'SSL_CTX_set_tmp_dh_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_tmp_dh_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='DH', derefcnt=1, name='dh')]),
 'SSL_CTX_set_tmp_ecdh_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_tmp_ecdh_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='EC_KEY', derefcnt=1, name='ecdh')]),
 'SSL_CTX_set_tmp_rsa_callback': Function(type='void', derefcnt=0, name='SSL_CTX_set_tmp_rsa_callback', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='RSA', derefcnt=1, name='cb')]),
 'SSL_CTX_set_trust': Function(type='int', derefcnt=0, name='SSL_CTX_set_trust', args=[Argument(type='SSL_CTX', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='trust')]),
 'SSL_CTX_set_verify': Function(type='void', derefcnt=0, name='SSL_CTX_set_verify', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='mode'), Argument(type='int', derefcnt=0, name='callback')]),
 'SSL_CTX_set_verify_depth': Function(type='void', derefcnt=0, name='SSL_CTX_set_verify_depth', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='depth')]),
 'SSL_CTX_use_PrivateKey': Function(type='int', derefcnt=0, name='SSL_CTX_use_PrivateKey', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'SSL_CTX_use_PrivateKey_ASN1': Function(type='int', derefcnt=0, name='SSL_CTX_use_PrivateKey_ASN1', args=[Argument(type='int', derefcnt=0, name='pk'), Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='long', derefcnt=0, name='len')]),
 'SSL_CTX_use_PrivateKey_file': Function(type='int', derefcnt=0, name='SSL_CTX_use_PrivateKey_file', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'SSL_CTX_use_RSAPrivateKey': Function(type='int', derefcnt=0, name='SSL_CTX_use_RSAPrivateKey', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'SSL_CTX_use_RSAPrivateKey_ASN1': Function(type='int', derefcnt=0, name='SSL_CTX_use_RSAPrivateKey_ASN1', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='long', derefcnt=0, name='len')]),
 'SSL_CTX_use_RSAPrivateKey_file': Function(type='int', derefcnt=0, name='SSL_CTX_use_RSAPrivateKey_file', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'SSL_CTX_use_certificate': Function(type='int', derefcnt=0, name='SSL_CTX_use_certificate', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='X509', derefcnt=1, name='x')]),
 'SSL_CTX_use_certificate_ASN1': Function(type='int', derefcnt=0, name='SSL_CTX_use_certificate_ASN1', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='len'), Argument(type='unsigned', derefcnt=1, name='d')]),
 'SSL_CTX_use_certificate_chain_file': Function(type='int', derefcnt=0, name='SSL_CTX_use_certificate_chain_file', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file')]),
 'SSL_CTX_use_certificate_file': Function(type='int', derefcnt=0, name='SSL_CTX_use_certificate_file', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'SSL_CTX_use_psk_identity_hint': Function(type='int', derefcnt=0, name='SSL_CTX_use_psk_identity_hint', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='identity_hint')]),
 'SSL_SESSION_free': Function(type='void', derefcnt=0, name='SSL_SESSION_free', args=[Argument(type='SSL_SESSION', derefcnt=1, name='ses')]),
 'SSL_SESSION_get0_peer': Function(type='X509', derefcnt=1, name='SSL_SESSION_get0_peer', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s')]),
 'SSL_SESSION_get_compress_id': Function(type='unsigned', derefcnt=0, name='SSL_SESSION_get_compress_id', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s')]),
 'SSL_SESSION_get_ex_data': Function(type='void', derefcnt=1, name='SSL_SESSION_get_ex_data', args=[Argument(type='SSL_SESSION', derefcnt=1, name='ss'), Argument(type='int', derefcnt=0, name='idx')]),
 'SSL_SESSION_get_ex_new_index': Function(type='int', derefcnt=0, name='SSL_SESSION_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'SSL_SESSION_get_id': Function(type='unsigned', derefcnt=1, name='SSL_SESSION_get_id', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'SSL_SESSION_get_time': Function(type='long', derefcnt=0, name='SSL_SESSION_get_time', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s')]),
 'SSL_SESSION_get_timeout': Function(type='long', derefcnt=0, name='SSL_SESSION_get_timeout', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s')]),
 'SSL_SESSION_new': Function(type='SSL_SESSION', derefcnt=1, name='SSL_SESSION_new', args=[]),
 'SSL_SESSION_print': Function(type='int', derefcnt=0, name='SSL_SESSION_print', args=[Argument(type='BIO', derefcnt=1, name='fp'), Argument(type='SSL_SESSION', derefcnt=1, name='ses')]),
 'SSL_SESSION_print_fp': Function(type='int', derefcnt=0, name='SSL_SESSION_print_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='SSL_SESSION', derefcnt=1, name='ses')]),
 'SSL_SESSION_set1_id_context': Function(type='int', derefcnt=0, name='SSL_SESSION_set1_id_context', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=1, name='sid_ctx'), Argument(type='unsigned', derefcnt=0, name='sid_ctx_len')]),
 'SSL_SESSION_set_ex_data': Function(type='int', derefcnt=0, name='SSL_SESSION_set_ex_data', args=[Argument(type='SSL_SESSION', derefcnt=1, name='ss'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='data')]),
 'SSL_SESSION_set_time': Function(type='long', derefcnt=0, name='SSL_SESSION_set_time', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s'), Argument(type='long', derefcnt=0, name='t')]),
 'SSL_SESSION_set_timeout': Function(type='long', derefcnt=0, name='SSL_SESSION_set_timeout', args=[Argument(type='SSL_SESSION', derefcnt=1, name='s'), Argument(type='long', derefcnt=0, name='t')]),
 'SSL_SRP_CTX_free': Function(type='int', derefcnt=0, name='SSL_SRP_CTX_free', args=[Argument(type='SSL', derefcnt=1, name='ctx')]),
 'SSL_SRP_CTX_init': Function(type='int', derefcnt=0, name='SSL_SRP_CTX_init', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_accept': Function(type='int', derefcnt=0, name='SSL_accept', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_add_client_CA': Function(type='int', derefcnt=0, name='SSL_add_client_CA', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='X509', derefcnt=1, name='x')]),
 'SSL_add_dir_cert_subjects_to_stack': Function(type='int', derefcnt=0, name='SSL_add_dir_cert_subjects_to_stack', args=[Argument(type='stack_st_X509_NAME', derefcnt=1, name='stackCAs'), Argument(type='char', derefcnt=1, name='dir')]),
 'SSL_add_file_cert_subjects_to_stack': Function(type='int', derefcnt=0, name='SSL_add_file_cert_subjects_to_stack', args=[Argument(type='stack_st_X509_NAME', derefcnt=1, name='stackCAs'), Argument(type='char', derefcnt=1, name='file')]),
 'SSL_alert_desc_string': Function(type='char', derefcnt=1, name='SSL_alert_desc_string', args=[Argument(type='int', derefcnt=0, name='value')]),
 'SSL_alert_desc_string_long': Function(type='char', derefcnt=1, name='SSL_alert_desc_string_long', args=[Argument(type='int', derefcnt=0, name='value')]),
 'SSL_alert_type_string': Function(type='char', derefcnt=1, name='SSL_alert_type_string', args=[Argument(type='int', derefcnt=0, name='value')]),
 'SSL_alert_type_string_long': Function(type='char', derefcnt=1, name='SSL_alert_type_string_long', args=[Argument(type='int', derefcnt=0, name='value')]),
 'SSL_cache_hit': Function(type='int', derefcnt=0, name='SSL_cache_hit', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_callback_ctrl': Function(type='long', derefcnt=0, name='SSL_callback_ctrl', args=[Argument(type='SSL', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'SSL_check_private_key': Function(type='int', derefcnt=0, name='SSL_check_private_key', args=[Argument(type='SSL', derefcnt=1, name='ctx')]),
 'SSL_clear': Function(type='int', derefcnt=0, name='SSL_clear', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_connect': Function(type='int', derefcnt=0, name='SSL_connect', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_copy_session_id': Function(type='void', derefcnt=0, name='SSL_copy_session_id', args=[Argument(type='SSL', derefcnt=1, name='to'), Argument(type='SSL', derefcnt=1, name='from')]),
 'SSL_ctrl': Function(type='long', derefcnt=0, name='SSL_ctrl', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg'), Argument(type='void', derefcnt=1, name='parg')]),
 'SSL_do_handshake': Function(type='int', derefcnt=0, name='SSL_do_handshake', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_dup': Function(type='SSL', derefcnt=1, name='SSL_dup', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_dup_CA_list': Function(type='stack_st_X509_NAME', derefcnt=1, name='SSL_dup_CA_list', args=[Argument(type='stack_st_X509_NAME', derefcnt=1, name='sk')]),
 'SSL_export_keying_material': Function(type='int', derefcnt=0, name='SSL_export_keying_material', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=0, name='olen'), Argument(type='char', derefcnt=1, name='label'), Argument(type='size_t', derefcnt=0, name='llen'), Argument(type='unsigned', derefcnt=1, name='p'), Argument(type='size_t', derefcnt=0, name='plen'), Argument(type='int', derefcnt=0, name='use_context')]),
 'SSL_free': Function(type='void', derefcnt=0, name='SSL_free', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get0_next_proto_negotiated': Function(type='void', derefcnt=0, name='SSL_get0_next_proto_negotiated', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=2, name='data'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'SSL_get1_session': Function(type='SSL_SESSION', derefcnt=1, name='SSL_get1_session', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_SSL_CTX': Function(type='SSL_CTX', derefcnt=1, name='SSL_get_SSL_CTX', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_certificate': Function(type='X509', derefcnt=1, name='SSL_get_certificate', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_cipher_list': Function(type='char', derefcnt=1, name='SSL_get_cipher_list', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='n')]),
 'SSL_get_ciphers': Function(type='stack_st_SSL_CIPHER', derefcnt=1, name='SSL_get_ciphers', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_client_CA_list': Function(type='stack_st_X509_NAME', derefcnt=1, name='SSL_get_client_CA_list', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_current_cipher': Function(type='SSL_CIPHER', derefcnt=1, name='SSL_get_current_cipher', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_current_compression': Function(type='COMP_METHOD', derefcnt=1, name='SSL_get_current_compression', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_current_expansion': Function(type='COMP_METHOD', derefcnt=1, name='SSL_get_current_expansion', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_default_timeout': Function(type='long', derefcnt=0, name='SSL_get_default_timeout', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_error': Function(type='int', derefcnt=0, name='SSL_get_error', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='ret_code')]),
 'SSL_get_ex_data': Function(type='void', derefcnt=1, name='SSL_get_ex_data', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='idx')]),
 'SSL_get_ex_data_X509_STORE_CTX_idx': Function(type='int', derefcnt=0, name='SSL_get_ex_data_X509_STORE_CTX_idx', args=[]),
 'SSL_get_ex_new_index': Function(type='int', derefcnt=0, name='SSL_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'SSL_get_fd': Function(type='int', derefcnt=0, name='SSL_get_fd', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_finished': Function(type='size_t', derefcnt=0, name='SSL_get_finished', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='count')]),
 'SSL_get_info_callback': Function(type='void', derefcnt=0, name='SSL_get_info_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_peer_cert_chain': Function(type='stack_st_X509', derefcnt=1, name='SSL_get_peer_cert_chain', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_peer_certificate': Function(type='X509', derefcnt=1, name='SSL_get_peer_certificate', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_peer_finished': Function(type='size_t', derefcnt=0, name='SSL_get_peer_finished', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='count')]),
 'SSL_get_privatekey': Function(type='evp_pkey_st', derefcnt=1, name='SSL_get_privatekey', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_psk_identity': Function(type='char', derefcnt=1, name='SSL_get_psk_identity', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_psk_identity_hint': Function(type='char', derefcnt=1, name='SSL_get_psk_identity_hint', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_quiet_shutdown': Function(type='int', derefcnt=0, name='SSL_get_quiet_shutdown', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_rbio': Function(type='BIO', derefcnt=1, name='SSL_get_rbio', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_read_ahead': Function(type='int', derefcnt=0, name='SSL_get_read_ahead', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_rfd': Function(type='int', derefcnt=0, name='SSL_get_rfd', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_selected_srtp_profile': Function(type='SRTP_PROTECTION_PROFILE', derefcnt=1, name='SSL_get_selected_srtp_profile', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_servername': Function(type='char', derefcnt=1, name='SSL_get_servername', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='type')]),
 'SSL_get_servername_type': Function(type='int', derefcnt=0, name='SSL_get_servername_type', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_session': Function(type='SSL_SESSION', derefcnt=1, name='SSL_get_session', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_shared_ciphers': Function(type='char', derefcnt=1, name='SSL_get_shared_ciphers', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'SSL_get_shutdown': Function(type='int', derefcnt=0, name='SSL_get_shutdown', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_srp_N': Function(type='BIGNUM', derefcnt=1, name='SSL_get_srp_N', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_srp_g': Function(type='BIGNUM', derefcnt=1, name='SSL_get_srp_g', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_srp_userinfo': Function(type='char', derefcnt=1, name='SSL_get_srp_userinfo', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_srp_username': Function(type='char', derefcnt=1, name='SSL_get_srp_username', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_srtp_profiles': Function(type='stack_st_SRTP_PROTECTION_PROFILE', derefcnt=1, name='SSL_get_srtp_profiles', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_ssl_method': Function(type='SSL_METHOD', derefcnt=1, name='SSL_get_ssl_method', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_verify_callback': Function(type='int', derefcnt=0, name='SSL_get_verify_callback', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_verify_depth': Function(type='int', derefcnt=0, name='SSL_get_verify_depth', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_verify_mode': Function(type='int', derefcnt=0, name='SSL_get_verify_mode', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_verify_result': Function(type='long', derefcnt=0, name='SSL_get_verify_result', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_get_version': Function(type='char', derefcnt=1, name='SSL_get_version', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_wbio': Function(type='BIO', derefcnt=1, name='SSL_get_wbio', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_get_wfd': Function(type='int', derefcnt=0, name='SSL_get_wfd', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_has_matching_session_id': Function(type='int', derefcnt=0, name='SSL_has_matching_session_id', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='id'), Argument(type='unsigned', derefcnt=0, name='id_len')]),
 'SSL_library_init': Function(type='int', derefcnt=0, name='SSL_library_init', args=[]),
 'SSL_load_client_CA_file': Function(type='stack_st_X509_NAME', derefcnt=1, name='SSL_load_client_CA_file', args=[Argument(type='char', derefcnt=1, name='file')]),
 'SSL_load_error_strings': Function(type='void', derefcnt=0, name='SSL_load_error_strings', args=[]),
 'SSL_new': Function(type='SSL', derefcnt=1, name='SSL_new', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_peek': Function(type='int', derefcnt=0, name='SSL_peek', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='num')]),
 'SSL_pending': Function(type='int', derefcnt=0, name='SSL_pending', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_read': Function(type='int', derefcnt=0, name='SSL_read', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='num')]),
 'SSL_renegotiate': Function(type='int', derefcnt=0, name='SSL_renegotiate', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_renegotiate_abbreviated': Function(type='int', derefcnt=0, name='SSL_renegotiate_abbreviated', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_renegotiate_pending': Function(type='int', derefcnt=0, name='SSL_renegotiate_pending', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_rstate_string': Function(type='char', derefcnt=1, name='SSL_rstate_string', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_rstate_string_long': Function(type='char', derefcnt=1, name='SSL_rstate_string_long', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_select_next_proto': Function(type='int', derefcnt=0, name='SSL_select_next_proto', args=[Argument(type='unsigned', derefcnt=2, name='out'), Argument(type='unsigned', derefcnt=1, name='outlen'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='unsigned', derefcnt=0, name='inlen'), Argument(type='unsigned', derefcnt=1, name='client'), Argument(type='unsigned', derefcnt=0, name='client_len')]),
 'SSL_set1_param': Function(type='int', derefcnt=0, name='SSL_set1_param', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='vpm')]),
 'SSL_set_SSL_CTX': Function(type='SSL_CTX', derefcnt=1, name='SSL_set_SSL_CTX', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='SSL_CTX', derefcnt=1, name='ctx')]),
 'SSL_set_accept_state': Function(type='void', derefcnt=0, name='SSL_set_accept_state', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_set_bio': Function(type='void', derefcnt=0, name='SSL_set_bio', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='BIO', derefcnt=1, name='rbio'), Argument(type='BIO', derefcnt=1, name='wbio')]),
 'SSL_set_cipher_list': Function(type='int', derefcnt=0, name='SSL_set_cipher_list', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='str')]),
 'SSL_set_client_CA_list': Function(type='void', derefcnt=0, name='SSL_set_client_CA_list', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='stack_st_X509_NAME', derefcnt=1, name='name_list')]),
 'SSL_set_connect_state': Function(type='void', derefcnt=0, name='SSL_set_connect_state', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_set_debug': Function(type='void', derefcnt=0, name='SSL_set_debug', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='debug')]),
 'SSL_set_ex_data': Function(type='int', derefcnt=0, name='SSL_set_ex_data', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='data')]),
 'SSL_set_fd': Function(type='int', derefcnt=0, name='SSL_set_fd', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='fd')]),
 'SSL_set_generate_session_id': Function(type='int', derefcnt=0, name='SSL_set_generate_session_id', args=[Argument(type='SSL', derefcnt=1, name='arg0'), Argument(type='GEN_SESSION_CB', derefcnt=0, name='arg1')]),
 'SSL_set_info_callback': Function(type='void', derefcnt=0, name='SSL_set_info_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='void', derefcnt=0, name='cb')]),
 'SSL_set_msg_callback': Function(type='void', derefcnt=0, name='SSL_set_msg_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='void', derefcnt=0, name='cb')]),
 'SSL_set_psk_client_callback': Function(type='void', derefcnt=0, name='SSL_set_psk_client_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=0, name='psk_client_callback')]),
 'SSL_set_psk_server_callback': Function(type='void', derefcnt=0, name='SSL_set_psk_server_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=0, name='psk_server_callback')]),
 'SSL_set_purpose': Function(type='int', derefcnt=0, name='SSL_set_purpose', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='purpose')]),
 'SSL_set_quiet_shutdown': Function(type='void', derefcnt=0, name='SSL_set_quiet_shutdown', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='mode')]),
 'SSL_set_read_ahead': Function(type='void', derefcnt=0, name='SSL_set_read_ahead', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='yes')]),
 'SSL_set_rfd': Function(type='int', derefcnt=0, name='SSL_set_rfd', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='fd')]),
 'SSL_set_session': Function(type='int', derefcnt=0, name='SSL_set_session', args=[Argument(type='SSL', derefcnt=1, name='to'), Argument(type='SSL_SESSION', derefcnt=1, name='session')]),
 'SSL_set_session_id_context': Function(type='int', derefcnt=0, name='SSL_set_session_id_context', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='sid_ctx'), Argument(type='unsigned', derefcnt=0, name='sid_ctx_len')]),
 'SSL_set_session_secret_cb': Function(type='int', derefcnt=0, name='SSL_set_session_secret_cb', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='tls_session_secret_cb_fn', derefcnt=0, name='tls_session_secret_cb'), Argument(type='void', derefcnt=1, name='arg')]),
 'SSL_set_session_ticket_ext': Function(type='int', derefcnt=0, name='SSL_set_session_ticket_ext', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='void', derefcnt=1, name='ext_data'), Argument(type='int', derefcnt=0, name='ext_len')]),
 'SSL_set_session_ticket_ext_cb': Function(type='int', derefcnt=0, name='SSL_set_session_ticket_ext_cb', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='tls_session_ticket_ext_cb_fn', derefcnt=0, name='cb'), Argument(type='void', derefcnt=1, name='arg')]),
 'SSL_set_shutdown': Function(type='void', derefcnt=0, name='SSL_set_shutdown', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='mode')]),
 'SSL_set_srp_server_param': Function(type='int', derefcnt=0, name='SSL_set_srp_server_param', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='BIGNUM', derefcnt=1, name='N'), Argument(type='BIGNUM', derefcnt=1, name='g'), Argument(type='BIGNUM', derefcnt=1, name='sa'), Argument(type='BIGNUM', derefcnt=1, name='v'), Argument(type='char', derefcnt=1, name='info')]),
 'SSL_set_srp_server_param_pw': Function(type='int', derefcnt=0, name='SSL_set_srp_server_param_pw', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='user'), Argument(type='char', derefcnt=1, name='pass'), Argument(type='char', derefcnt=1, name='grp')]),
 'SSL_set_ssl_method': Function(type='int', derefcnt=0, name='SSL_set_ssl_method', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='SSL_METHOD', derefcnt=1, name='method')]),
 'SSL_set_state': Function(type='void', derefcnt=0, name='SSL_set_state', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='state')]),
 'SSL_set_tlsext_use_srtp': Function(type='int', derefcnt=0, name='SSL_set_tlsext_use_srtp', args=[Argument(type='SSL', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='profiles')]),
 'SSL_set_tmp_dh_callback': Function(type='void', derefcnt=0, name='SSL_set_tmp_dh_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='DH', derefcnt=1, name='dh')]),
 'SSL_set_tmp_ecdh_callback': Function(type='void', derefcnt=0, name='SSL_set_tmp_ecdh_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='EC_KEY', derefcnt=1, name='ecdh')]),
 'SSL_set_tmp_rsa_callback': Function(type='void', derefcnt=0, name='SSL_set_tmp_rsa_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='RSA', derefcnt=1, name='cb')]),
 'SSL_set_trust': Function(type='int', derefcnt=0, name='SSL_set_trust', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='trust')]),
 'SSL_set_verify': Function(type='void', derefcnt=0, name='SSL_set_verify', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='mode'), Argument(type='int', derefcnt=0, name='callback')]),
 'SSL_set_verify_depth': Function(type='void', derefcnt=0, name='SSL_set_verify_depth', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='depth')]),
 'SSL_set_verify_result': Function(type='void', derefcnt=0, name='SSL_set_verify_result', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='long', derefcnt=0, name='v')]),
 'SSL_set_wfd': Function(type='int', derefcnt=0, name='SSL_set_wfd', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='fd')]),
 'SSL_shutdown': Function(type='int', derefcnt=0, name='SSL_shutdown', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_srp_server_param_with_username': Function(type='int', derefcnt=0, name='SSL_srp_server_param_with_username', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=1, name='ad')]),
 'SSL_state': Function(type='int', derefcnt=0, name='SSL_state', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_state_string': Function(type='char', derefcnt=1, name='SSL_state_string', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_state_string_long': Function(type='char', derefcnt=1, name='SSL_state_string_long', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_use_PrivateKey': Function(type='int', derefcnt=0, name='SSL_use_PrivateKey', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'SSL_use_PrivateKey_ASN1': Function(type='int', derefcnt=0, name='SSL_use_PrivateKey_ASN1', args=[Argument(type='int', derefcnt=0, name='pk'), Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='long', derefcnt=0, name='len')]),
 'SSL_use_PrivateKey_file': Function(type='int', derefcnt=0, name='SSL_use_PrivateKey_file', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'SSL_use_RSAPrivateKey': Function(type='int', derefcnt=0, name='SSL_use_RSAPrivateKey', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'SSL_use_RSAPrivateKey_ASN1': Function(type='int', derefcnt=0, name='SSL_use_RSAPrivateKey_ASN1', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='long', derefcnt=0, name='len')]),
 'SSL_use_RSAPrivateKey_file': Function(type='int', derefcnt=0, name='SSL_use_RSAPrivateKey_file', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'SSL_use_certificate': Function(type='int', derefcnt=0, name='SSL_use_certificate', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='X509', derefcnt=1, name='x')]),
 'SSL_use_certificate_ASN1': Function(type='int', derefcnt=0, name='SSL_use_certificate_ASN1', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='d'), Argument(type='int', derefcnt=0, name='len')]),
 'SSL_use_certificate_file': Function(type='int', derefcnt=0, name='SSL_use_certificate_file', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'SSL_use_psk_identity_hint': Function(type='int', derefcnt=0, name='SSL_use_psk_identity_hint', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='identity_hint')]),
 'SSL_version': Function(type='int', derefcnt=0, name='SSL_version', args=[Argument(type='SSL', derefcnt=1, name='ssl')]),
 'SSL_want': Function(type='int', derefcnt=0, name='SSL_want', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'SSL_write': Function(type='int', derefcnt=0, name='SSL_write', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='num')]),
 'SSLeay': Function(type='unsigned', derefcnt=0, name='SSLeay', args=[]),
 'SSLeay_version': Function(type='char', derefcnt=1, name='SSLeay_version', args=[Argument(type='int', derefcnt=0, name='type')]),
 'SSLv23_client_method': Function(type='SSL_METHOD', derefcnt=1, name='SSLv23_client_method', args=[]),
 'SSLv23_method': Function(type='SSL_METHOD', derefcnt=1, name='SSLv23_method', args=[]),
 'SSLv23_server_method': Function(type='SSL_METHOD', derefcnt=1, name='SSLv23_server_method', args=[]),
 'SSLv3_client_method': Function(type='SSL_METHOD', derefcnt=1, name='SSLv3_client_method', args=[]),
 'SSLv3_method': Function(type='SSL_METHOD', derefcnt=1, name='SSLv3_method', args=[]),
 'SSLv3_server_method': Function(type='SSL_METHOD', derefcnt=1, name='SSLv3_server_method', args=[]),
 'TLS_ext_srp_username_callback': Function(type='int', derefcnt=0, name='TLS_ext_srp_username_callback', args=[Argument(type='SSL', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='void', derefcnt=1, name='arg2')]),
 'TLSv1_1_client_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_1_client_method', args=[]),
 'TLSv1_1_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_1_method', args=[]),
 'TLSv1_1_server_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_1_server_method', args=[]),
 'TLSv1_2_client_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_2_client_method', args=[]),
 'TLSv1_2_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_2_method', args=[]),
 'TLSv1_2_server_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_2_server_method', args=[]),
 'TLSv1_client_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_client_method', args=[]),
 'TLSv1_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_method', args=[]),
 'TLSv1_server_method': Function(type='SSL_METHOD', derefcnt=1, name='TLSv1_server_method', args=[]),
 'UTF8_getc': Function(type='int', derefcnt=0, name='UTF8_getc', args=[Argument(type='unsigned', derefcnt=1, name='str'), Argument(type='int', derefcnt=0, name='len'), Argument(type='unsigned', derefcnt=1, name='val')]),
 'UTF8_putc': Function(type='int', derefcnt=0, name='UTF8_putc', args=[Argument(type='unsigned', derefcnt=1, name='str'), Argument(type='int', derefcnt=0, name='len'), Argument(type='unsigned', derefcnt=0, name='value')]),
 'X509_ALGOR_cmp': Function(type='int', derefcnt=0, name='X509_ALGOR_cmp', args=[Argument(type='X509_ALGOR', derefcnt=1, name='a'), Argument(type='X509_ALGOR', derefcnt=1, name='b')]),
 'X509_ALGOR_dup': Function(type='X509_ALGOR', derefcnt=1, name='X509_ALGOR_dup', args=[Argument(type='X509_ALGOR', derefcnt=1, name='xn')]),
 'X509_ALGOR_free': Function(type='void', derefcnt=0, name='X509_ALGOR_free', args=[Argument(type='X509_ALGOR', derefcnt=1, name='a')]),
 'X509_ALGOR_get0': Function(type='void', derefcnt=0, name='X509_ALGOR_get0', args=[Argument(type='ASN1_OBJECT', derefcnt=2, name='paobj'), Argument(type='int', derefcnt=1, name='pptype'), Argument(type='void', derefcnt=2, name='ppval'), Argument(type='X509_ALGOR', derefcnt=1, name='algor')]),
 'X509_ALGOR_new': Function(type='X509_ALGOR', derefcnt=1, name='X509_ALGOR_new', args=[]),
 'X509_ALGOR_set0': Function(type='int', derefcnt=0, name='X509_ALGOR_set0', args=[Argument(type='X509_ALGOR', derefcnt=1, name='alg'), Argument(type='ASN1_OBJECT', derefcnt=1, name='aobj'), Argument(type='int', derefcnt=0, name='ptype'), Argument(type='void', derefcnt=1, name='pval')]),
 'X509_ALGOR_set_md': Function(type='void', derefcnt=0, name='X509_ALGOR_set_md', args=[Argument(type='X509_ALGOR', derefcnt=1, name='alg'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'X509_ATTRIBUTE_count': Function(type='int', derefcnt=0, name='X509_ATTRIBUTE_count', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr')]),
 'X509_ATTRIBUTE_create': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_ATTRIBUTE_create', args=[Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='atrtype'), Argument(type='void', derefcnt=1, name='value')]),
 'X509_ATTRIBUTE_create_by_NID': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_ATTRIBUTE_create_by_NID', args=[Argument(type='X509_ATTRIBUTE', derefcnt=2, name='attr'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='atrtype'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_ATTRIBUTE_create_by_OBJ': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_ATTRIBUTE_create_by_OBJ', args=[Argument(type='X509_ATTRIBUTE', derefcnt=2, name='attr'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='atrtype'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_ATTRIBUTE_create_by_txt': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_ATTRIBUTE_create_by_txt', args=[Argument(type='X509_ATTRIBUTE', derefcnt=2, name='attr'), Argument(type='char', derefcnt=1, name='atrname'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_ATTRIBUTE_dup': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_ATTRIBUTE_dup', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='xa')]),
 'X509_ATTRIBUTE_free': Function(type='void', derefcnt=0, name='X509_ATTRIBUTE_free', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='a')]),
 'X509_ATTRIBUTE_get0_data': Function(type='void', derefcnt=1, name='X509_ATTRIBUTE_get0_data', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='int', derefcnt=0, name='atrtype'), Argument(type='void', derefcnt=1, name='data')]),
 'X509_ATTRIBUTE_get0_object': Function(type='ASN1_OBJECT', derefcnt=1, name='X509_ATTRIBUTE_get0_object', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr')]),
 'X509_ATTRIBUTE_get0_type': Function(type='ASN1_TYPE', derefcnt=1, name='X509_ATTRIBUTE_get0_type', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='idx')]),
 'X509_ATTRIBUTE_new': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_ATTRIBUTE_new', args=[]),
 'X509_ATTRIBUTE_set1_data': Function(type='int', derefcnt=0, name='X509_ATTRIBUTE_set1_data', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='attrtype'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_ATTRIBUTE_set1_object': Function(type='int', derefcnt=0, name='X509_ATTRIBUTE_set1_object', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj')]),
 'X509_CERT_AUX_free': Function(type='void', derefcnt=0, name='X509_CERT_AUX_free', args=[Argument(type='X509_CERT_AUX', derefcnt=1, name='a')]),
 'X509_CERT_AUX_new': Function(type='X509_CERT_AUX', derefcnt=1, name='X509_CERT_AUX_new', args=[]),
 'X509_CERT_AUX_print': Function(type='int', derefcnt=0, name='X509_CERT_AUX_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CERT_AUX', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='indent')]),
 'X509_CERT_PAIR_free': Function(type='void', derefcnt=0, name='X509_CERT_PAIR_free', args=[Argument(type='X509_CERT_PAIR', derefcnt=1, name='a')]),
 'X509_CERT_PAIR_new': Function(type='X509_CERT_PAIR', derefcnt=1, name='X509_CERT_PAIR_new', args=[]),
 'X509_CINF_free': Function(type='void', derefcnt=0, name='X509_CINF_free', args=[Argument(type='X509_CINF', derefcnt=1, name='a')]),
 'X509_CINF_new': Function(type='X509_CINF', derefcnt=1, name='X509_CINF_new', args=[]),
 'X509_CRL_INFO_free': Function(type='void', derefcnt=0, name='X509_CRL_INFO_free', args=[Argument(type='X509_CRL_INFO', derefcnt=1, name='a')]),
 'X509_CRL_INFO_new': Function(type='X509_CRL_INFO', derefcnt=1, name='X509_CRL_INFO_new', args=[]),
 'X509_CRL_METHOD_free': Function(type='void', derefcnt=0, name='X509_CRL_METHOD_free', args=[Argument(type='X509_CRL_METHOD', derefcnt=1, name='m')]),
 'X509_CRL_METHOD_new': Function(type='X509_CRL_METHOD', derefcnt=1, name='X509_CRL_METHOD_new', args=[Argument(type='int', derefcnt=0, name='crl_init'), Argument(type='int', derefcnt=0, name='crl_free'), Argument(type='int', derefcnt=0, name='crl_lookup'), Argument(type='int', derefcnt=0, name='crl_verify')]),
 'X509_CRL_add0_revoked': Function(type='int', derefcnt=0, name='X509_CRL_add0_revoked', args=[Argument(type='X509_CRL', derefcnt=1, name='crl'), Argument(type='X509_REVOKED', derefcnt=1, name='rev')]),
 'X509_CRL_add1_ext_i2d': Function(type='int', derefcnt=0, name='X509_CRL_add1_ext_i2d', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='void', derefcnt=1, name='value'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_CRL_add_ext': Function(type='int', derefcnt=0, name='X509_CRL_add_ext', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='X509_EXTENSION', derefcnt=1, name='ex'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_CRL_cmp': Function(type='int', derefcnt=0, name='X509_CRL_cmp', args=[Argument(type='X509_CRL', derefcnt=1, name='a'), Argument(type='X509_CRL', derefcnt=1, name='b')]),
 'X509_CRL_delete_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509_CRL_delete_ext', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_CRL_digest': Function(type='int', derefcnt=0, name='X509_CRL_digest', args=[Argument(type='X509_CRL', derefcnt=1, name='data'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'X509_CRL_dup': Function(type='X509_CRL', derefcnt=1, name='X509_CRL_dup', args=[Argument(type='X509_CRL', derefcnt=1, name='crl')]),
 'X509_CRL_free': Function(type='void', derefcnt=0, name='X509_CRL_free', args=[Argument(type='X509_CRL', derefcnt=1, name='a')]),
 'X509_CRL_get0_by_cert': Function(type='int', derefcnt=0, name='X509_CRL_get0_by_cert', args=[Argument(type='X509_CRL', derefcnt=1, name='crl'), Argument(type='X509_REVOKED', derefcnt=2, name='ret'), Argument(type='X509', derefcnt=1, name='x')]),
 'X509_CRL_get0_by_serial': Function(type='int', derefcnt=0, name='X509_CRL_get0_by_serial', args=[Argument(type='X509_CRL', derefcnt=1, name='crl'), Argument(type='X509_REVOKED', derefcnt=2, name='ret'), Argument(type='ASN1_INTEGER', derefcnt=1, name='serial')]),
 'X509_CRL_get_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509_CRL_get_ext', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_CRL_get_ext_by_NID': Function(type='int', derefcnt=0, name='X509_CRL_get_ext_by_NID', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_CRL_get_ext_by_OBJ': Function(type='int', derefcnt=0, name='X509_CRL_get_ext_by_OBJ', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_CRL_get_ext_by_critical': Function(type='int', derefcnt=0, name='X509_CRL_get_ext_by_critical', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_CRL_get_ext_count': Function(type='int', derefcnt=0, name='X509_CRL_get_ext_count', args=[Argument(type='X509_CRL', derefcnt=1, name='x')]),
 'X509_CRL_get_ext_d2i': Function(type='void', derefcnt=1, name='X509_CRL_get_ext_d2i', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=1, name='crit'), Argument(type='int', derefcnt=1, name='idx')]),
 'X509_CRL_get_meth_data': Function(type='void', derefcnt=1, name='X509_CRL_get_meth_data', args=[Argument(type='X509_CRL', derefcnt=1, name='crl')]),
 'X509_CRL_match': Function(type='int', derefcnt=0, name='X509_CRL_match', args=[Argument(type='X509_CRL', derefcnt=1, name='a'), Argument(type='X509_CRL', derefcnt=1, name='b')]),
 'X509_CRL_new': Function(type='X509_CRL', derefcnt=1, name='X509_CRL_new', args=[]),
 'X509_CRL_print': Function(type='int', derefcnt=0, name='X509_CRL_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CRL', derefcnt=1, name='x')]),
 'X509_CRL_print_fp': Function(type='int', derefcnt=0, name='X509_CRL_print_fp', args=[Argument(type='FILE', derefcnt=1, name='bp'), Argument(type='X509_CRL', derefcnt=1, name='x')]),
 'X509_CRL_set_default_method': Function(type='void', derefcnt=0, name='X509_CRL_set_default_method', args=[Argument(type='X509_CRL_METHOD', derefcnt=1, name='meth')]),
 'X509_CRL_set_issuer_name': Function(type='int', derefcnt=0, name='X509_CRL_set_issuer_name', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_CRL_set_lastUpdate': Function(type='int', derefcnt=0, name='X509_CRL_set_lastUpdate', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='ASN1_TIME', derefcnt=1, name='tm')]),
 'X509_CRL_set_meth_data': Function(type='void', derefcnt=0, name='X509_CRL_set_meth_data', args=[Argument(type='X509_CRL', derefcnt=1, name='crl'), Argument(type='void', derefcnt=1, name='dat')]),
 'X509_CRL_set_nextUpdate': Function(type='int', derefcnt=0, name='X509_CRL_set_nextUpdate', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='ASN1_TIME', derefcnt=1, name='tm')]),
 'X509_CRL_set_version': Function(type='int', derefcnt=0, name='X509_CRL_set_version', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='long', derefcnt=0, name='version')]),
 'X509_CRL_sign': Function(type='int', derefcnt=0, name='X509_CRL_sign', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'X509_CRL_sign_ctx': Function(type='int', derefcnt=0, name='X509_CRL_sign_ctx', args=[Argument(type='X509_CRL', derefcnt=1, name='x'), Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'X509_CRL_sort': Function(type='int', derefcnt=0, name='X509_CRL_sort', args=[Argument(type='X509_CRL', derefcnt=1, name='crl')]),
 'X509_CRL_verify': Function(type='int', derefcnt=0, name='X509_CRL_verify', args=[Argument(type='X509_CRL', derefcnt=1, name='a'), Argument(type='EVP_PKEY', derefcnt=1, name='r')]),
 'X509_EXTENSION_create_by_NID': Function(type='X509_EXTENSION', derefcnt=1, name='X509_EXTENSION_create_by_NID', args=[Argument(type='X509_EXTENSION', derefcnt=2, name='ex'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='data')]),
 'X509_EXTENSION_create_by_OBJ': Function(type='X509_EXTENSION', derefcnt=1, name='X509_EXTENSION_create_by_OBJ', args=[Argument(type='X509_EXTENSION', derefcnt=2, name='ex'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='data')]),
 'X509_EXTENSION_dup': Function(type='X509_EXTENSION', derefcnt=1, name='X509_EXTENSION_dup', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='ex')]),
 'X509_EXTENSION_free': Function(type='void', derefcnt=0, name='X509_EXTENSION_free', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='a')]),
 'X509_EXTENSION_get_critical': Function(type='int', derefcnt=0, name='X509_EXTENSION_get_critical', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='ex')]),
 'X509_EXTENSION_get_data': Function(type='ASN1_OCTET_STRING', derefcnt=1, name='X509_EXTENSION_get_data', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='ne')]),
 'X509_EXTENSION_get_object': Function(type='ASN1_OBJECT', derefcnt=1, name='X509_EXTENSION_get_object', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='ex')]),
 'X509_EXTENSION_new': Function(type='X509_EXTENSION', derefcnt=1, name='X509_EXTENSION_new', args=[]),
 'X509_EXTENSION_set_critical': Function(type='int', derefcnt=0, name='X509_EXTENSION_set_critical', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='ex'), Argument(type='int', derefcnt=0, name='crit')]),
 'X509_EXTENSION_set_data': Function(type='int', derefcnt=0, name='X509_EXTENSION_set_data', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='ex'), Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='data')]),
 'X509_EXTENSION_set_object': Function(type='int', derefcnt=0, name='X509_EXTENSION_set_object', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='ex'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj')]),
 'X509_INFO_free': Function(type='void', derefcnt=0, name='X509_INFO_free', args=[Argument(type='X509_INFO', derefcnt=1, name='a')]),
 'X509_INFO_new': Function(type='X509_INFO', derefcnt=1, name='X509_INFO_new', args=[]),
 'X509_LOOKUP_by_alias': Function(type='int', derefcnt=0, name='X509_LOOKUP_by_alias', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='char', derefcnt=1, name='str'), Argument(type='int', derefcnt=0, name='len'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'X509_LOOKUP_by_fingerprint': Function(type='int', derefcnt=0, name='X509_LOOKUP_by_fingerprint', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'X509_LOOKUP_by_issuer_serial': Function(type='int', derefcnt=0, name='X509_LOOKUP_by_issuer_serial', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='ASN1_INTEGER', derefcnt=1, name='serial'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'X509_LOOKUP_by_subject': Function(type='int', derefcnt=0, name='X509_LOOKUP_by_subject', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'X509_LOOKUP_ctrl': Function(type='int', derefcnt=0, name='X509_LOOKUP_ctrl', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='char', derefcnt=1, name='argc'), Argument(type='long', derefcnt=0, name='argl'), Argument(type='char', derefcnt=2, name='ret')]),
 'X509_LOOKUP_file': Function(type='X509_LOOKUP_METHOD', derefcnt=1, name='X509_LOOKUP_file', args=[]),
 'X509_LOOKUP_free': Function(type='void', derefcnt=0, name='X509_LOOKUP_free', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx')]),
 'X509_LOOKUP_hash_dir': Function(type='X509_LOOKUP_METHOD', derefcnt=1, name='X509_LOOKUP_hash_dir', args=[]),
 'X509_LOOKUP_init': Function(type='int', derefcnt=0, name='X509_LOOKUP_init', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx')]),
 'X509_LOOKUP_new': Function(type='X509_LOOKUP', derefcnt=1, name='X509_LOOKUP_new', args=[Argument(type='X509_LOOKUP_METHOD', derefcnt=1, name='method')]),
 'X509_LOOKUP_shutdown': Function(type='int', derefcnt=0, name='X509_LOOKUP_shutdown', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx')]),
 'X509_NAME_ENTRY_create_by_NID': Function(type='X509_NAME_ENTRY', derefcnt=1, name='X509_NAME_ENTRY_create_by_NID', args=[Argument(type='X509_NAME_ENTRY', derefcnt=2, name='ne'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_NAME_ENTRY_create_by_OBJ': Function(type='X509_NAME_ENTRY', derefcnt=1, name='X509_NAME_ENTRY_create_by_OBJ', args=[Argument(type='X509_NAME_ENTRY', derefcnt=2, name='ne'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_NAME_ENTRY_create_by_txt': Function(type='X509_NAME_ENTRY', derefcnt=1, name='X509_NAME_ENTRY_create_by_txt', args=[Argument(type='X509_NAME_ENTRY', derefcnt=2, name='ne'), Argument(type='char', derefcnt=1, name='field'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_NAME_ENTRY_dup': Function(type='X509_NAME_ENTRY', derefcnt=1, name='X509_NAME_ENTRY_dup', args=[Argument(type='X509_NAME_ENTRY', derefcnt=1, name='ne')]),
 'X509_NAME_ENTRY_free': Function(type='void', derefcnt=0, name='X509_NAME_ENTRY_free', args=[Argument(type='X509_NAME_ENTRY', derefcnt=1, name='a')]),
 'X509_NAME_ENTRY_get_data': Function(type='ASN1_STRING', derefcnt=1, name='X509_NAME_ENTRY_get_data', args=[Argument(type='X509_NAME_ENTRY', derefcnt=1, name='ne')]),
 'X509_NAME_ENTRY_get_object': Function(type='ASN1_OBJECT', derefcnt=1, name='X509_NAME_ENTRY_get_object', args=[Argument(type='X509_NAME_ENTRY', derefcnt=1, name='ne')]),
 'X509_NAME_ENTRY_new': Function(type='X509_NAME_ENTRY', derefcnt=1, name='X509_NAME_ENTRY_new', args=[]),
 'X509_NAME_ENTRY_set_data': Function(type='int', derefcnt=0, name='X509_NAME_ENTRY_set_data', args=[Argument(type='X509_NAME_ENTRY', derefcnt=1, name='ne'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_NAME_ENTRY_set_object': Function(type='int', derefcnt=0, name='X509_NAME_ENTRY_set_object', args=[Argument(type='X509_NAME_ENTRY', derefcnt=1, name='ne'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj')]),
 'X509_NAME_add_entry': Function(type='int', derefcnt=0, name='X509_NAME_add_entry', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='X509_NAME_ENTRY', derefcnt=1, name='ne'), Argument(type='int', derefcnt=0, name='loc'), Argument(type='int', derefcnt=0, name='set')]),
 'X509_NAME_add_entry_by_NID': Function(type='int', derefcnt=0, name='X509_NAME_add_entry_by_NID', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='loc'), Argument(type='int', derefcnt=0, name='set')]),
 'X509_NAME_add_entry_by_OBJ': Function(type='int', derefcnt=0, name='X509_NAME_add_entry_by_OBJ', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='loc'), Argument(type='int', derefcnt=0, name='set')]),
 'X509_NAME_add_entry_by_txt': Function(type='int', derefcnt=0, name='X509_NAME_add_entry_by_txt', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='field'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='loc'), Argument(type='int', derefcnt=0, name='set')]),
 'X509_NAME_cmp': Function(type='int', derefcnt=0, name='X509_NAME_cmp', args=[Argument(type='X509_NAME', derefcnt=1, name='a'), Argument(type='X509_NAME', derefcnt=1, name='b')]),
 'X509_NAME_delete_entry': Function(type='X509_NAME_ENTRY', derefcnt=1, name='X509_NAME_delete_entry', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_NAME_digest': Function(type='int', derefcnt=0, name='X509_NAME_digest', args=[Argument(type='X509_NAME', derefcnt=1, name='data'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'X509_NAME_dup': Function(type='X509_NAME', derefcnt=1, name='X509_NAME_dup', args=[Argument(type='X509_NAME', derefcnt=1, name='xn')]),
 'X509_NAME_entry_count': Function(type='int', derefcnt=0, name='X509_NAME_entry_count', args=[Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_NAME_free': Function(type='void', derefcnt=0, name='X509_NAME_free', args=[Argument(type='X509_NAME', derefcnt=1, name='a')]),
 'X509_NAME_get_entry': Function(type='X509_NAME_ENTRY', derefcnt=1, name='X509_NAME_get_entry', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_NAME_get_index_by_NID': Function(type='int', derefcnt=0, name='X509_NAME_get_index_by_NID', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_NAME_get_index_by_OBJ': Function(type='int', derefcnt=0, name='X509_NAME_get_index_by_OBJ', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_NAME_get_text_by_NID': Function(type='int', derefcnt=0, name='X509_NAME_get_text_by_NID', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_NAME_get_text_by_OBJ': Function(type='int', derefcnt=0, name='X509_NAME_get_text_by_OBJ', args=[Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_NAME_hash': Function(type='unsigned', derefcnt=0, name='X509_NAME_hash', args=[Argument(type='X509_NAME', derefcnt=1, name='x')]),
 'X509_NAME_hash_old': Function(type='unsigned', derefcnt=0, name='X509_NAME_hash_old', args=[Argument(type='X509_NAME', derefcnt=1, name='x')]),
 'X509_NAME_new': Function(type='X509_NAME', derefcnt=1, name='X509_NAME_new', args=[]),
 'X509_NAME_oneline': Function(type='char', derefcnt=1, name='X509_NAME_oneline', args=[Argument(type='X509_NAME', derefcnt=1, name='a'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='size')]),
 'X509_NAME_print': Function(type='int', derefcnt=0, name='X509_NAME_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='obase')]),
 'X509_NAME_print_ex': Function(type='int', derefcnt=0, name='X509_NAME_print_ex', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='X509_NAME', derefcnt=1, name='nm'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_NAME_print_ex_fp': Function(type='int', derefcnt=0, name='X509_NAME_print_ex_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_NAME', derefcnt=1, name='nm'), Argument(type='int', derefcnt=0, name='indent'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_NAME_set': Function(type='int', derefcnt=0, name='X509_NAME_set', args=[Argument(type='X509_NAME', derefcnt=2, name='xn'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_OBJECT_free_contents': Function(type='void', derefcnt=0, name='X509_OBJECT_free_contents', args=[Argument(type='X509_OBJECT', derefcnt=1, name='a')]),
 'X509_OBJECT_idx_by_subject': Function(type='int', derefcnt=0, name='X509_OBJECT_idx_by_subject', args=[Argument(type='stack_st_X509_OBJECT', derefcnt=1, name='h'), Argument(type='int', derefcnt=0, name='type'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_OBJECT_retrieve_by_subject': Function(type='X509_OBJECT', derefcnt=1, name='X509_OBJECT_retrieve_by_subject', args=[Argument(type='stack_st_X509_OBJECT', derefcnt=1, name='h'), Argument(type='int', derefcnt=0, name='type'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_OBJECT_retrieve_match': Function(type='X509_OBJECT', derefcnt=1, name='X509_OBJECT_retrieve_match', args=[Argument(type='stack_st_X509_OBJECT', derefcnt=1, name='h'), Argument(type='X509_OBJECT', derefcnt=1, name='x')]),
 'X509_OBJECT_up_ref_count': Function(type='void', derefcnt=0, name='X509_OBJECT_up_ref_count', args=[Argument(type='X509_OBJECT', derefcnt=1, name='a')]),
 'X509_PKEY_free': Function(type='void', derefcnt=0, name='X509_PKEY_free', args=[Argument(type='X509_PKEY', derefcnt=1, name='a')]),
 'X509_PKEY_new': Function(type='X509_PKEY', derefcnt=1, name='X509_PKEY_new', args=[]),
 'X509_PUBKEY_free': Function(type='void', derefcnt=0, name='X509_PUBKEY_free', args=[Argument(type='X509_PUBKEY', derefcnt=1, name='a')]),
 'X509_PUBKEY_get': Function(type='EVP_PKEY', derefcnt=1, name='X509_PUBKEY_get', args=[Argument(type='X509_PUBKEY', derefcnt=1, name='key')]),
 'X509_PUBKEY_get0_param': Function(type='int', derefcnt=0, name='X509_PUBKEY_get0_param', args=[Argument(type='ASN1_OBJECT', derefcnt=2, name='ppkalg'), Argument(type='unsigned', derefcnt=2, name='pk'), Argument(type='int', derefcnt=1, name='ppklen'), Argument(type='X509_ALGOR', derefcnt=2, name='pa'), Argument(type='X509_PUBKEY', derefcnt=1, name='pub')]),
 'X509_PUBKEY_new': Function(type='X509_PUBKEY', derefcnt=1, name='X509_PUBKEY_new', args=[]),
 'X509_PUBKEY_set': Function(type='int', derefcnt=0, name='X509_PUBKEY_set', args=[Argument(type='X509_PUBKEY', derefcnt=2, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'X509_PUBKEY_set0_param': Function(type='int', derefcnt=0, name='X509_PUBKEY_set0_param', args=[Argument(type='X509_PUBKEY', derefcnt=1, name='pub'), Argument(type='ASN1_OBJECT', derefcnt=1, name='aobj'), Argument(type='int', derefcnt=0, name='ptype'), Argument(type='void', derefcnt=1, name='pval'), Argument(type='unsigned', derefcnt=1, name='penc'), Argument(type='int', derefcnt=0, name='penclen')]),
 'X509_REQ_INFO_free': Function(type='void', derefcnt=0, name='X509_REQ_INFO_free', args=[Argument(type='X509_REQ_INFO', derefcnt=1, name='a')]),
 'X509_REQ_INFO_new': Function(type='X509_REQ_INFO', derefcnt=1, name='X509_REQ_INFO_new', args=[]),
 'X509_REQ_add1_attr': Function(type='int', derefcnt=0, name='X509_REQ_add1_attr', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr')]),
 'X509_REQ_add1_attr_by_NID': Function(type='int', derefcnt=0, name='X509_REQ_add1_attr_by_NID', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_REQ_add1_attr_by_OBJ': Function(type='int', derefcnt=0, name='X509_REQ_add1_attr_by_OBJ', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_REQ_add1_attr_by_txt': Function(type='int', derefcnt=0, name='X509_REQ_add1_attr_by_txt', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='char', derefcnt=1, name='attrname'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_REQ_add_extensions': Function(type='int', derefcnt=0, name='X509_REQ_add_extensions', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='exts')]),
 'X509_REQ_add_extensions_nid': Function(type='int', derefcnt=0, name='X509_REQ_add_extensions_nid', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='exts'), Argument(type='int', derefcnt=0, name='nid')]),
 'X509_REQ_check_private_key': Function(type='int', derefcnt=0, name='X509_REQ_check_private_key', args=[Argument(type='X509_REQ', derefcnt=1, name='x509'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'X509_REQ_delete_attr': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_REQ_delete_attr', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_REQ_digest': Function(type='int', derefcnt=0, name='X509_REQ_digest', args=[Argument(type='X509_REQ', derefcnt=1, name='data'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'X509_REQ_dup': Function(type='X509_REQ', derefcnt=1, name='X509_REQ_dup', args=[Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'X509_REQ_extension_nid': Function(type='int', derefcnt=0, name='X509_REQ_extension_nid', args=[Argument(type='int', derefcnt=0, name='nid')]),
 'X509_REQ_free': Function(type='void', derefcnt=0, name='X509_REQ_free', args=[Argument(type='X509_REQ', derefcnt=1, name='a')]),
 'X509_REQ_get_attr': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509_REQ_get_attr', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_REQ_get_attr_by_NID': Function(type='int', derefcnt=0, name='X509_REQ_get_attr_by_NID', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_REQ_get_attr_by_OBJ': Function(type='int', derefcnt=0, name='X509_REQ_get_attr_by_OBJ', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_REQ_get_attr_count': Function(type='int', derefcnt=0, name='X509_REQ_get_attr_count', args=[Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'X509_REQ_get_extension_nids': Function(type='int', derefcnt=1, name='X509_REQ_get_extension_nids', args=[]),
 'X509_REQ_get_extensions': Function(type='stack_st_X509_EXTENSION', derefcnt=1, name='X509_REQ_get_extensions', args=[Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'X509_REQ_get_pubkey': Function(type='EVP_PKEY', derefcnt=1, name='X509_REQ_get_pubkey', args=[Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'X509_REQ_new': Function(type='X509_REQ', derefcnt=1, name='X509_REQ_new', args=[]),
 'X509_REQ_print': Function(type='int', derefcnt=0, name='X509_REQ_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'X509_REQ_print_ex': Function(type='int', derefcnt=0, name='X509_REQ_print_ex', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=1, name='x'), Argument(type='unsigned', derefcnt=0, name='nmflag'), Argument(type='unsigned', derefcnt=0, name='cflag')]),
 'X509_REQ_print_fp': Function(type='int', derefcnt=0, name='X509_REQ_print_fp', args=[Argument(type='FILE', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'X509_REQ_set_extension_nids': Function(type='void', derefcnt=0, name='X509_REQ_set_extension_nids', args=[Argument(type='int', derefcnt=1, name='nids')]),
 'X509_REQ_set_pubkey': Function(type='int', derefcnt=0, name='X509_REQ_set_pubkey', args=[Argument(type='X509_REQ', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'X509_REQ_set_subject_name': Function(type='int', derefcnt=0, name='X509_REQ_set_subject_name', args=[Argument(type='X509_REQ', derefcnt=1, name='req'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_REQ_set_version': Function(type='int', derefcnt=0, name='X509_REQ_set_version', args=[Argument(type='X509_REQ', derefcnt=1, name='x'), Argument(type='long', derefcnt=0, name='version')]),
 'X509_REQ_sign': Function(type='int', derefcnt=0, name='X509_REQ_sign', args=[Argument(type='X509_REQ', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'X509_REQ_sign_ctx': Function(type='int', derefcnt=0, name='X509_REQ_sign_ctx', args=[Argument(type='X509_REQ', derefcnt=1, name='x'), Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'X509_REQ_to_X509': Function(type='X509', derefcnt=1, name='X509_REQ_to_X509', args=[Argument(type='X509_REQ', derefcnt=1, name='r'), Argument(type='int', derefcnt=0, name='days'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'X509_REQ_verify': Function(type='int', derefcnt=0, name='X509_REQ_verify', args=[Argument(type='X509_REQ', derefcnt=1, name='a'), Argument(type='EVP_PKEY', derefcnt=1, name='r')]),
 'X509_REVOKED_add1_ext_i2d': Function(type='int', derefcnt=0, name='X509_REVOKED_add1_ext_i2d', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='void', derefcnt=1, name='value'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_REVOKED_add_ext': Function(type='int', derefcnt=0, name='X509_REVOKED_add_ext', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='X509_EXTENSION', derefcnt=1, name='ex'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_REVOKED_delete_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509_REVOKED_delete_ext', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_REVOKED_free': Function(type='void', derefcnt=0, name='X509_REVOKED_free', args=[Argument(type='X509_REVOKED', derefcnt=1, name='a')]),
 'X509_REVOKED_get_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509_REVOKED_get_ext', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_REVOKED_get_ext_by_NID': Function(type='int', derefcnt=0, name='X509_REVOKED_get_ext_by_NID', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_REVOKED_get_ext_by_OBJ': Function(type='int', derefcnt=0, name='X509_REVOKED_get_ext_by_OBJ', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_REVOKED_get_ext_by_critical': Function(type='int', derefcnt=0, name='X509_REVOKED_get_ext_by_critical', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_REVOKED_get_ext_count': Function(type='int', derefcnt=0, name='X509_REVOKED_get_ext_count', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x')]),
 'X509_REVOKED_get_ext_d2i': Function(type='void', derefcnt=1, name='X509_REVOKED_get_ext_d2i', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=1, name='crit'), Argument(type='int', derefcnt=1, name='idx')]),
 'X509_REVOKED_new': Function(type='X509_REVOKED', derefcnt=1, name='X509_REVOKED_new', args=[]),
 'X509_REVOKED_set_revocationDate': Function(type='int', derefcnt=0, name='X509_REVOKED_set_revocationDate', args=[Argument(type='X509_REVOKED', derefcnt=1, name='r'), Argument(type='ASN1_TIME', derefcnt=1, name='tm')]),
 'X509_REVOKED_set_serialNumber': Function(type='int', derefcnt=0, name='X509_REVOKED_set_serialNumber', args=[Argument(type='X509_REVOKED', derefcnt=1, name='x'), Argument(type='ASN1_INTEGER', derefcnt=1, name='serial')]),
 'X509_SIG_free': Function(type='void', derefcnt=0, name='X509_SIG_free', args=[Argument(type='X509_SIG', derefcnt=1, name='a')]),
 'X509_SIG_new': Function(type='X509_SIG', derefcnt=1, name='X509_SIG_new', args=[]),
 'X509_STORE_CTX_cleanup': Function(type='void', derefcnt=0, name='X509_STORE_CTX_cleanup', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_free': Function(type='void', derefcnt=0, name='X509_STORE_CTX_free', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get0_current_crl': Function(type='X509_CRL', derefcnt=1, name='X509_STORE_CTX_get0_current_crl', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get0_current_issuer': Function(type='X509', derefcnt=1, name='X509_STORE_CTX_get0_current_issuer', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get0_param': Function(type='X509_VERIFY_PARAM', derefcnt=1, name='X509_STORE_CTX_get0_param', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get0_parent_ctx': Function(type='X509_STORE_CTX', derefcnt=1, name='X509_STORE_CTX_get0_parent_ctx', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get0_policy_tree': Function(type='X509_POLICY_TREE', derefcnt=1, name='X509_STORE_CTX_get0_policy_tree', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get1_chain': Function(type='stack_st_X509', derefcnt=1, name='X509_STORE_CTX_get1_chain', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get1_issuer': Function(type='int', derefcnt=0, name='X509_STORE_CTX_get1_issuer', args=[Argument(type='X509', derefcnt=2, name='issuer'), Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509', derefcnt=1, name='x')]),
 'X509_STORE_CTX_get_chain': Function(type='stack_st_X509', derefcnt=1, name='X509_STORE_CTX_get_chain', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get_current_cert': Function(type='X509', derefcnt=1, name='X509_STORE_CTX_get_current_cert', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get_error': Function(type='int', derefcnt=0, name='X509_STORE_CTX_get_error', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get_error_depth': Function(type='int', derefcnt=0, name='X509_STORE_CTX_get_error_depth', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_get_ex_data': Function(type='void', derefcnt=1, name='X509_STORE_CTX_get_ex_data', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='idx')]),
 'X509_STORE_CTX_get_ex_new_index': Function(type='int', derefcnt=0, name='X509_STORE_CTX_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'X509_STORE_CTX_get_explicit_policy': Function(type='int', derefcnt=0, name='X509_STORE_CTX_get_explicit_policy', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_STORE_CTX_init': Function(type='int', derefcnt=0, name='X509_STORE_CTX_init', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509_STORE', derefcnt=1, name='store'), Argument(type='X509', derefcnt=1, name='x509'), Argument(type='stack_st_X509', derefcnt=1, name='chain')]),
 'X509_STORE_CTX_new': Function(type='X509_STORE_CTX', derefcnt=1, name='X509_STORE_CTX_new', args=[]),
 'X509_STORE_CTX_purpose_inherit': Function(type='int', derefcnt=0, name='X509_STORE_CTX_purpose_inherit', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='def_purpose'), Argument(type='int', derefcnt=0, name='purpose'), Argument(type='int', derefcnt=0, name='trust')]),
 'X509_STORE_CTX_set0_crls': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set0_crls', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='c'), Argument(type='stack_st_X509_CRL', derefcnt=1, name='sk')]),
 'X509_STORE_CTX_set0_param': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set0_param', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param')]),
 'X509_STORE_CTX_set_cert': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set_cert', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='c'), Argument(type='X509', derefcnt=1, name='x')]),
 'X509_STORE_CTX_set_chain': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set_chain', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='c'), Argument(type='stack_st_X509', derefcnt=1, name='sk')]),
 'X509_STORE_CTX_set_default': Function(type='int', derefcnt=0, name='X509_STORE_CTX_set_default', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='name')]),
 'X509_STORE_CTX_set_depth': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set_depth', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='depth')]),
 'X509_STORE_CTX_set_error': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set_error', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='s')]),
 'X509_STORE_CTX_set_ex_data': Function(type='int', derefcnt=0, name='X509_STORE_CTX_set_ex_data', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='data')]),
 'X509_STORE_CTX_set_flags': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set_flags', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_STORE_CTX_set_purpose': Function(type='int', derefcnt=0, name='X509_STORE_CTX_set_purpose', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='purpose')]),
 'X509_STORE_CTX_set_time': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set_time', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=0, name='flags'), Argument(type='time_t', derefcnt=0, name='t')]),
 'X509_STORE_CTX_set_trust': Function(type='int', derefcnt=0, name='X509_STORE_CTX_set_trust', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='trust')]),
 'X509_STORE_CTX_set_verify_cb': Function(type='void', derefcnt=0, name='X509_STORE_CTX_set_verify_cb', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='verify_cb')]),
 'X509_STORE_CTX_trusted_stack': Function(type='void', derefcnt=0, name='X509_STORE_CTX_trusted_stack', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='stack_st_X509', derefcnt=1, name='sk')]),
 'X509_STORE_add_cert': Function(type='int', derefcnt=0, name='X509_STORE_add_cert', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='X509', derefcnt=1, name='x')]),
 'X509_STORE_add_crl': Function(type='int', derefcnt=0, name='X509_STORE_add_crl', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='X509_CRL', derefcnt=1, name='x')]),
 'X509_STORE_add_lookup': Function(type='X509_LOOKUP', derefcnt=1, name='X509_STORE_add_lookup', args=[Argument(type='X509_STORE', derefcnt=1, name='v'), Argument(type='X509_LOOKUP_METHOD', derefcnt=1, name='m')]),
 'X509_STORE_free': Function(type='void', derefcnt=0, name='X509_STORE_free', args=[Argument(type='X509_STORE', derefcnt=1, name='v')]),
 'X509_STORE_get1_certs': Function(type='stack_st_X509', derefcnt=1, name='X509_STORE_get1_certs', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='st'), Argument(type='X509_NAME', derefcnt=1, name='nm')]),
 'X509_STORE_get1_crls': Function(type='stack_st_X509_CRL', derefcnt=1, name='X509_STORE_get1_crls', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='st'), Argument(type='X509_NAME', derefcnt=1, name='nm')]),
 'X509_STORE_get_by_subject': Function(type='int', derefcnt=0, name='X509_STORE_get_by_subject', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='vs'), Argument(type='int', derefcnt=0, name='type'), Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'X509_STORE_load_locations': Function(type='int', derefcnt=0, name='X509_STORE_load_locations', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file'), Argument(type='char', derefcnt=1, name='dir')]),
 'X509_STORE_new': Function(type='X509_STORE', derefcnt=1, name='X509_STORE_new', args=[]),
 'X509_STORE_set1_param': Function(type='int', derefcnt=0, name='X509_STORE_set1_param', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='pm')]),
 'X509_STORE_set_default_paths': Function(type='int', derefcnt=0, name='X509_STORE_set_default_paths', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx')]),
 'X509_STORE_set_depth': Function(type='int', derefcnt=0, name='X509_STORE_set_depth', args=[Argument(type='X509_STORE', derefcnt=1, name='store'), Argument(type='int', derefcnt=0, name='depth')]),
 'X509_STORE_set_flags': Function(type='int', derefcnt=0, name='X509_STORE_set_flags', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_STORE_set_purpose': Function(type='int', derefcnt=0, name='X509_STORE_set_purpose', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='purpose')]),
 'X509_STORE_set_trust': Function(type='int', derefcnt=0, name='X509_STORE_set_trust', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='trust')]),
 'X509_STORE_set_verify_cb': Function(type='void', derefcnt=0, name='X509_STORE_set_verify_cb', args=[Argument(type='X509_STORE', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='verify_cb')]),
 'X509_TRUST_add': Function(type='int', derefcnt=0, name='X509_TRUST_add', args=[Argument(type='int', derefcnt=0, name='id'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='ck'), Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='void', derefcnt=1, name='arg2')]),
 'X509_TRUST_cleanup': Function(type='void', derefcnt=0, name='X509_TRUST_cleanup', args=[]),
 'X509_TRUST_get0': Function(type='X509_TRUST', derefcnt=1, name='X509_TRUST_get0', args=[Argument(type='int', derefcnt=0, name='idx')]),
 'X509_TRUST_get0_name': Function(type='char', derefcnt=1, name='X509_TRUST_get0_name', args=[Argument(type='X509_TRUST', derefcnt=1, name='xp')]),
 'X509_TRUST_get_by_id': Function(type='int', derefcnt=0, name='X509_TRUST_get_by_id', args=[Argument(type='int', derefcnt=0, name='id')]),
 'X509_TRUST_get_count': Function(type='int', derefcnt=0, name='X509_TRUST_get_count', args=[]),
 'X509_TRUST_get_flags': Function(type='int', derefcnt=0, name='X509_TRUST_get_flags', args=[Argument(type='X509_TRUST', derefcnt=1, name='xp')]),
 'X509_TRUST_get_trust': Function(type='int', derefcnt=0, name='X509_TRUST_get_trust', args=[Argument(type='X509_TRUST', derefcnt=1, name='xp')]),
 'X509_TRUST_set': Function(type='int', derefcnt=0, name='X509_TRUST_set', args=[Argument(type='int', derefcnt=1, name='t'), Argument(type='int', derefcnt=0, name='trust')]),
 'X509_TRUST_set_default': Function(type='int', derefcnt=0, name='X509_TRUST_set_default', args=[Argument(type='int', derefcnt=0, name='trust')]),
 'X509_VAL_free': Function(type='void', derefcnt=0, name='X509_VAL_free', args=[Argument(type='X509_VAL', derefcnt=1, name='a')]),
 'X509_VAL_new': Function(type='X509_VAL', derefcnt=1, name='X509_VAL_new', args=[]),
 'X509_VERIFY_PARAM_add0_policy': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_add0_policy', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='ASN1_OBJECT', derefcnt=1, name='policy')]),
 'X509_VERIFY_PARAM_add0_table': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_add0_table', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param')]),
 'X509_VERIFY_PARAM_clear_flags': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_clear_flags', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_VERIFY_PARAM_free': Function(type='void', derefcnt=0, name='X509_VERIFY_PARAM_free', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param')]),
 'X509_VERIFY_PARAM_get_depth': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_get_depth', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param')]),
 'X509_VERIFY_PARAM_get_flags': Function(type='unsigned', derefcnt=0, name='X509_VERIFY_PARAM_get_flags', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param')]),
 'X509_VERIFY_PARAM_inherit': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_inherit', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='to'), Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='from')]),
 'X509_VERIFY_PARAM_lookup': Function(type='X509_VERIFY_PARAM', derefcnt=1, name='X509_VERIFY_PARAM_lookup', args=[Argument(type='char', derefcnt=1, name='name')]),
 'X509_VERIFY_PARAM_new': Function(type='X509_VERIFY_PARAM', derefcnt=1, name='X509_VERIFY_PARAM_new', args=[]),
 'X509_VERIFY_PARAM_set1': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_set1', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='to'), Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='from')]),
 'X509_VERIFY_PARAM_set1_name': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_set1_name', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='char', derefcnt=1, name='name')]),
 'X509_VERIFY_PARAM_set1_policies': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_set1_policies', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='stack_st_ASN1_OBJECT', derefcnt=1, name='policies')]),
 'X509_VERIFY_PARAM_set_depth': Function(type='void', derefcnt=0, name='X509_VERIFY_PARAM_set_depth', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='int', derefcnt=0, name='depth')]),
 'X509_VERIFY_PARAM_set_flags': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_set_flags', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_VERIFY_PARAM_set_purpose': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_set_purpose', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='int', derefcnt=0, name='purpose')]),
 'X509_VERIFY_PARAM_set_time': Function(type='void', derefcnt=0, name='X509_VERIFY_PARAM_set_time', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='time_t', derefcnt=0, name='t')]),
 'X509_VERIFY_PARAM_set_trust': Function(type='int', derefcnt=0, name='X509_VERIFY_PARAM_set_trust', args=[Argument(type='X509_VERIFY_PARAM', derefcnt=1, name='param'), Argument(type='int', derefcnt=0, name='trust')]),
 'X509_VERIFY_PARAM_table_cleanup': Function(type='void', derefcnt=0, name='X509_VERIFY_PARAM_table_cleanup', args=[]),
 'X509_add1_ext_i2d': Function(type='int', derefcnt=0, name='X509_add1_ext_i2d', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='void', derefcnt=1, name='value'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_add1_reject_object': Function(type='int', derefcnt=0, name='X509_add1_reject_object', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj')]),
 'X509_add1_trust_object': Function(type='int', derefcnt=0, name='X509_add1_trust_object', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj')]),
 'X509_add_ext': Function(type='int', derefcnt=0, name='X509_add_ext', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='X509_EXTENSION', derefcnt=1, name='ex'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_alias_get0': Function(type='unsigned', derefcnt=1, name='X509_alias_get0', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=1, name='len')]),
 'X509_alias_set1': Function(type='int', derefcnt=0, name='X509_alias_set1', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='unsigned', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_certificate_type': Function(type='int', derefcnt=0, name='X509_certificate_type', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pubkey')]),
 'X509_check_private_key': Function(type='int', derefcnt=0, name='X509_check_private_key', args=[Argument(type='X509', derefcnt=1, name='x509'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'X509_check_trust': Function(type='int', derefcnt=0, name='X509_check_trust', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='id'), Argument(type='int', derefcnt=0, name='flags')]),
 'X509_cmp': Function(type='int', derefcnt=0, name='X509_cmp', args=[Argument(type='X509', derefcnt=1, name='a'), Argument(type='X509', derefcnt=1, name='b')]),
 'X509_cmp_current_time': Function(type='int', derefcnt=0, name='X509_cmp_current_time', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s')]),
 'X509_cmp_time': Function(type='int', derefcnt=0, name='X509_cmp_time', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s'), Argument(type='time_t', derefcnt=1, name='t')]),
 'X509_delete_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509_delete_ext', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_digest': Function(type='int', derefcnt=0, name='X509_digest', args=[Argument(type='X509', derefcnt=1, name='data'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'X509_dup': Function(type='X509', derefcnt=1, name='X509_dup', args=[Argument(type='X509', derefcnt=1, name='x509')]),
 'X509_find_by_issuer_and_serial': Function(type='X509', derefcnt=1, name='X509_find_by_issuer_and_serial', args=[Argument(type='stack_st_X509', derefcnt=1, name='sk'), Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='ASN1_INTEGER', derefcnt=1, name='serial')]),
 'X509_find_by_subject': Function(type='X509', derefcnt=1, name='X509_find_by_subject', args=[Argument(type='stack_st_X509', derefcnt=1, name='sk'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_free': Function(type='void', derefcnt=0, name='X509_free', args=[Argument(type='X509', derefcnt=1, name='a')]),
 'X509_get0_pubkey_bitstr': Function(type='ASN1_BIT_STRING', derefcnt=1, name='X509_get0_pubkey_bitstr', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_get_default_cert_area': Function(type='char', derefcnt=1, name='X509_get_default_cert_area', args=[]),
 'X509_get_default_cert_dir': Function(type='char', derefcnt=1, name='X509_get_default_cert_dir', args=[]),
 'X509_get_default_cert_dir_env': Function(type='char', derefcnt=1, name='X509_get_default_cert_dir_env', args=[]),
 'X509_get_default_cert_file': Function(type='char', derefcnt=1, name='X509_get_default_cert_file', args=[]),
 'X509_get_default_cert_file_env': Function(type='char', derefcnt=1, name='X509_get_default_cert_file_env', args=[]),
 'X509_get_default_private_dir': Function(type='char', derefcnt=1, name='X509_get_default_private_dir', args=[]),
 'X509_get_ex_data': Function(type='void', derefcnt=1, name='X509_get_ex_data', args=[Argument(type='X509', derefcnt=1, name='r'), Argument(type='int', derefcnt=0, name='idx')]),
 'X509_get_ex_new_index': Function(type='int', derefcnt=0, name='X509_get_ex_new_index', args=[Argument(type='long', derefcnt=0, name='argl'), Argument(type='void', derefcnt=1, name='argp'), Argument(type='CRYPTO_EX_new', derefcnt=1, name='new_func'), Argument(type='CRYPTO_EX_dup', derefcnt=1, name='dup_func'), Argument(type='CRYPTO_EX_free', derefcnt=1, name='free_func')]),
 'X509_get_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509_get_ext', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509_get_ext_by_NID': Function(type='int', derefcnt=0, name='X509_get_ext_by_NID', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_get_ext_by_OBJ': Function(type='int', derefcnt=0, name='X509_get_ext_by_OBJ', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_get_ext_by_critical': Function(type='int', derefcnt=0, name='X509_get_ext_by_critical', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509_get_ext_count': Function(type='int', derefcnt=0, name='X509_get_ext_count', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_get_ext_d2i': Function(type='void', derefcnt=1, name='X509_get_ext_d2i', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=1, name='crit'), Argument(type='int', derefcnt=1, name='idx')]),
 'X509_get_issuer_name': Function(type='X509_NAME', derefcnt=1, name='X509_get_issuer_name', args=[Argument(type='X509', derefcnt=1, name='a')]),
 'X509_get_pubkey': Function(type='EVP_PKEY', derefcnt=1, name='X509_get_pubkey', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_get_pubkey_parameters': Function(type='int', derefcnt=0, name='X509_get_pubkey_parameters', args=[Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='stack_st_X509', derefcnt=1, name='chain')]),
 'X509_get_serialNumber': Function(type='ASN1_INTEGER', derefcnt=1, name='X509_get_serialNumber', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_get_subject_name': Function(type='X509_NAME', derefcnt=1, name='X509_get_subject_name', args=[Argument(type='X509', derefcnt=1, name='a')]),
 'X509_gmtime_adj': Function(type='ASN1_TIME', derefcnt=1, name='X509_gmtime_adj', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s'), Argument(type='long', derefcnt=0, name='adj')]),
 'X509_issuer_and_serial_cmp': Function(type='int', derefcnt=0, name='X509_issuer_and_serial_cmp', args=[Argument(type='X509', derefcnt=1, name='a'), Argument(type='X509', derefcnt=1, name='b')]),
 'X509_issuer_and_serial_hash': Function(type='unsigned', derefcnt=0, name='X509_issuer_and_serial_hash', args=[Argument(type='X509', derefcnt=1, name='a')]),
 'X509_issuer_name_cmp': Function(type='int', derefcnt=0, name='X509_issuer_name_cmp', args=[Argument(type='X509', derefcnt=1, name='a'), Argument(type='X509', derefcnt=1, name='b')]),
 'X509_issuer_name_hash': Function(type='unsigned', derefcnt=0, name='X509_issuer_name_hash', args=[Argument(type='X509', derefcnt=1, name='a')]),
 'X509_issuer_name_hash_old': Function(type='unsigned', derefcnt=0, name='X509_issuer_name_hash_old', args=[Argument(type='X509', derefcnt=1, name='a')]),
 'X509_keyid_get0': Function(type='unsigned', derefcnt=1, name='X509_keyid_get0', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='int', derefcnt=1, name='len')]),
 'X509_keyid_set1': Function(type='int', derefcnt=0, name='X509_keyid_set1', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='unsigned', derefcnt=1, name='id'), Argument(type='int', derefcnt=0, name='len')]),
 'X509_load_cert_crl_file': Function(type='int', derefcnt=0, name='X509_load_cert_crl_file', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'X509_load_cert_file': Function(type='int', derefcnt=0, name='X509_load_cert_file', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'X509_load_crl_file': Function(type='int', derefcnt=0, name='X509_load_crl_file', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type')]),
 'X509_new': Function(type='X509', derefcnt=1, name='X509_new', args=[]),
 'X509_ocspid_print': Function(type='int', derefcnt=0, name='X509_ocspid_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x')]),
 'X509_policy_check': Function(type='int', derefcnt=0, name='X509_policy_check', args=[Argument(type='X509_POLICY_TREE', derefcnt=2, name='ptree'), Argument(type='int', derefcnt=1, name='pexplicit_policy'), Argument(type='stack_st_X509', derefcnt=1, name='certs'), Argument(type='stack_st_ASN1_OBJECT', derefcnt=1, name='policy_oids'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'X509_policy_level_get0_node': Function(type='X509_POLICY_NODE', derefcnt=1, name='X509_policy_level_get0_node', args=[Argument(type='X509_POLICY_LEVEL', derefcnt=1, name='level'), Argument(type='int', derefcnt=0, name='i')]),
 'X509_policy_level_node_count': Function(type='int', derefcnt=0, name='X509_policy_level_node_count', args=[Argument(type='X509_POLICY_LEVEL', derefcnt=1, name='level')]),
 'X509_policy_node_get0_parent': Function(type='X509_POLICY_NODE', derefcnt=1, name='X509_policy_node_get0_parent', args=[Argument(type='X509_POLICY_NODE', derefcnt=1, name='node')]),
 'X509_policy_node_get0_policy': Function(type='ASN1_OBJECT', derefcnt=1, name='X509_policy_node_get0_policy', args=[Argument(type='X509_POLICY_NODE', derefcnt=1, name='node')]),
 'X509_policy_node_get0_qualifiers': Function(type='stack_st_POLICYQUALINFO', derefcnt=1, name='X509_policy_node_get0_qualifiers', args=[Argument(type='X509_POLICY_NODE', derefcnt=1, name='node')]),
 'X509_policy_tree_free': Function(type='void', derefcnt=0, name='X509_policy_tree_free', args=[Argument(type='X509_POLICY_TREE', derefcnt=1, name='tree')]),
 'X509_policy_tree_get0_level': Function(type='X509_POLICY_LEVEL', derefcnt=1, name='X509_policy_tree_get0_level', args=[Argument(type='X509_POLICY_TREE', derefcnt=1, name='tree'), Argument(type='int', derefcnt=0, name='i')]),
 'X509_policy_tree_get0_policies': Function(type='stack_st_X509_POLICY_NODE', derefcnt=1, name='X509_policy_tree_get0_policies', args=[Argument(type='X509_POLICY_TREE', derefcnt=1, name='tree')]),
 'X509_policy_tree_get0_user_policies': Function(type='stack_st_X509_POLICY_NODE', derefcnt=1, name='X509_policy_tree_get0_user_policies', args=[Argument(type='X509_POLICY_TREE', derefcnt=1, name='tree')]),
 'X509_policy_tree_level_count': Function(type='int', derefcnt=0, name='X509_policy_tree_level_count', args=[Argument(type='X509_POLICY_TREE', derefcnt=1, name='tree')]),
 'X509_print': Function(type='int', derefcnt=0, name='X509_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x')]),
 'X509_print_ex': Function(type='int', derefcnt=0, name='X509_print_ex', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x'), Argument(type='unsigned', derefcnt=0, name='nmflag'), Argument(type='unsigned', derefcnt=0, name='cflag')]),
 'X509_print_ex_fp': Function(type='int', derefcnt=0, name='X509_print_ex_fp', args=[Argument(type='FILE', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x'), Argument(type='unsigned', derefcnt=0, name='nmflag'), Argument(type='unsigned', derefcnt=0, name='cflag')]),
 'X509_print_fp': Function(type='int', derefcnt=0, name='X509_print_fp', args=[Argument(type='FILE', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x')]),
 'X509_pubkey_digest': Function(type='int', derefcnt=0, name='X509_pubkey_digest', args=[Argument(type='X509', derefcnt=1, name='data'), Argument(type='EVP_MD', derefcnt=1, name='type'), Argument(type='unsigned', derefcnt=1, name='md'), Argument(type='unsigned', derefcnt=1, name='len')]),
 'X509_reject_clear': Function(type='void', derefcnt=0, name='X509_reject_clear', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_set_ex_data': Function(type='int', derefcnt=0, name='X509_set_ex_data', args=[Argument(type='X509', derefcnt=1, name='r'), Argument(type='int', derefcnt=0, name='idx'), Argument(type='void', derefcnt=1, name='arg')]),
 'X509_set_issuer_name': Function(type='int', derefcnt=0, name='X509_set_issuer_name', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_set_notAfter': Function(type='int', derefcnt=0, name='X509_set_notAfter', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='ASN1_TIME', derefcnt=1, name='tm')]),
 'X509_set_notBefore': Function(type='int', derefcnt=0, name='X509_set_notBefore', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='ASN1_TIME', derefcnt=1, name='tm')]),
 'X509_set_pubkey': Function(type='int', derefcnt=0, name='X509_set_pubkey', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'X509_set_serialNumber': Function(type='int', derefcnt=0, name='X509_set_serialNumber', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='ASN1_INTEGER', derefcnt=1, name='serial')]),
 'X509_set_subject_name': Function(type='int', derefcnt=0, name='X509_set_subject_name', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='X509_NAME', derefcnt=1, name='name')]),
 'X509_set_version': Function(type='int', derefcnt=0, name='X509_set_version', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='long', derefcnt=0, name='version')]),
 'X509_sign': Function(type='int', derefcnt=0, name='X509_sign', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'X509_sign_ctx': Function(type='int', derefcnt=0, name='X509_sign_ctx', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx')]),
 'X509_signature_dump': Function(type='int', derefcnt=0, name='X509_signature_dump', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_STRING', derefcnt=1, name='sig'), Argument(type='int', derefcnt=0, name='indent')]),
 'X509_signature_print': Function(type='int', derefcnt=0, name='X509_signature_print', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_ALGOR', derefcnt=1, name='alg'), Argument(type='ASN1_STRING', derefcnt=1, name='sig')]),
 'X509_subject_name_cmp': Function(type='int', derefcnt=0, name='X509_subject_name_cmp', args=[Argument(type='X509', derefcnt=1, name='a'), Argument(type='X509', derefcnt=1, name='b')]),
 'X509_subject_name_hash': Function(type='unsigned', derefcnt=0, name='X509_subject_name_hash', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_subject_name_hash_old': Function(type='unsigned', derefcnt=0, name='X509_subject_name_hash_old', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_time_adj': Function(type='ASN1_TIME', derefcnt=1, name='X509_time_adj', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s'), Argument(type='long', derefcnt=0, name='adj'), Argument(type='time_t', derefcnt=1, name='t')]),
 'X509_time_adj_ex': Function(type='ASN1_TIME', derefcnt=1, name='X509_time_adj_ex', args=[Argument(type='ASN1_TIME', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='offset_day'), Argument(type='long', derefcnt=0, name='offset_sec'), Argument(type='time_t', derefcnt=1, name='t')]),
 'X509_to_X509_REQ': Function(type='X509_REQ', derefcnt=1, name='X509_to_X509_REQ', args=[Argument(type='X509', derefcnt=1, name='x'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey'), Argument(type='EVP_MD', derefcnt=1, name='md')]),
 'X509_trust_clear': Function(type='void', derefcnt=0, name='X509_trust_clear', args=[Argument(type='X509', derefcnt=1, name='x')]),
 'X509_verify': Function(type='int', derefcnt=0, name='X509_verify', args=[Argument(type='X509', derefcnt=1, name='a'), Argument(type='EVP_PKEY', derefcnt=1, name='r')]),
 'X509_verify_cert': Function(type='int', derefcnt=0, name='X509_verify_cert', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'X509_verify_cert_error_string': Function(type='char', derefcnt=1, name='X509_verify_cert_error_string', args=[Argument(type='long', derefcnt=0, name='n')]),
 'X509at_add1_attr': Function(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='X509at_add1_attr', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=2, name='x'), Argument(type='X509_ATTRIBUTE', derefcnt=1, name='attr')]),
 'X509at_add1_attr_by_NID': Function(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='X509at_add1_attr_by_NID', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=2, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509at_add1_attr_by_OBJ': Function(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='X509at_add1_attr_by_OBJ', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=2, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509at_add1_attr_by_txt': Function(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='X509at_add1_attr_by_txt', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=2, name='x'), Argument(type='char', derefcnt=1, name='attrname'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len')]),
 'X509at_delete_attr': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509at_delete_attr', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509at_get0_data_by_OBJ': Function(type='void', derefcnt=1, name='X509at_get0_data_by_OBJ', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos'), Argument(type='int', derefcnt=0, name='type')]),
 'X509at_get_attr': Function(type='X509_ATTRIBUTE', derefcnt=1, name='X509at_get_attr', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509at_get_attr_by_NID': Function(type='int', derefcnt=0, name='X509at_get_attr_by_NID', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509at_get_attr_by_OBJ': Function(type='int', derefcnt=0, name='X509at_get_attr_by_OBJ', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='sk'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509at_get_attr_count': Function(type='int', derefcnt=0, name='X509at_get_attr_count', args=[Argument(type='stack_st_X509_ATTRIBUTE', derefcnt=1, name='x')]),
 'X509v3_add_ext': Function(type='stack_st_X509_EXTENSION', derefcnt=1, name='X509v3_add_ext', args=[Argument(type='stack_st_X509_EXTENSION', derefcnt=2, name='x'), Argument(type='X509_EXTENSION', derefcnt=1, name='ex'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509v3_delete_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509v3_delete_ext', args=[Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509v3_get_ext': Function(type='X509_EXTENSION', derefcnt=1, name='X509v3_get_ext', args=[Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='loc')]),
 'X509v3_get_ext_by_NID': Function(type='int', derefcnt=0, name='X509v3_get_ext_by_NID', args=[Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509v3_get_ext_by_OBJ': Function(type='int', derefcnt=0, name='X509v3_get_ext_by_OBJ', args=[Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='x'), Argument(type='ASN1_OBJECT', derefcnt=1, name='obj'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509v3_get_ext_by_critical': Function(type='int', derefcnt=0, name='X509v3_get_ext_by_critical', args=[Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='crit'), Argument(type='int', derefcnt=0, name='lastpos')]),
 'X509v3_get_ext_count': Function(type='int', derefcnt=0, name='X509v3_get_ext_count', args=[Argument(type='stack_st_X509_EXTENSION', derefcnt=1, name='x')]),
 'a2d_ASN1_OBJECT': Function(type='int', derefcnt=0, name='a2d_ASN1_OBJECT', args=[Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='int', derefcnt=0, name='olen'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='num')]),
 'a2i': Function(type='int', derefcnt=0, name='a2i', args=[]),
 'a2i_ASN1_ENUMERATED': Function(type='int', derefcnt=0, name='a2i_ASN1_ENUMERATED', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_ENUMERATED', derefcnt=1, name='bs'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='size')]),
 'a2i_ASN1_INTEGER': Function(type='int', derefcnt=0, name='a2i_ASN1_INTEGER', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_INTEGER', derefcnt=1, name='bs'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='size')]),
 'a2i_ASN1_STRING': Function(type='int', derefcnt=0, name='a2i_ASN1_STRING', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_STRING', derefcnt=1, name='bs'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='size')]),
 'a64l': Function(type='long', derefcnt=0, name='a64l', args=[Argument(type='char', derefcnt=1, name='s')]),
 'abort': Function(type='void', derefcnt=0, name='abort', args=[]),
 'abs': Function(type='int', derefcnt=0, name='abs', args=[Argument(type='int', derefcnt=0, name='x')]),
 'accept': Function(type='int', derefcnt=0, name='accept', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=1, name='addr_len')]),
 'accept4': Function(type='int', derefcnt=0, name='accept4', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=1, name='addr_len'), Argument(type='int', derefcnt=0, name='flags')]),
 'access': Function(type='int', derefcnt=0, name='access', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='type')]),
 'acct': Function(type='int', derefcnt=0, name='acct', args=[Argument(type='char', derefcnt=1, name='name')]),
 'acos': Function(type='double', derefcnt=0, name='acos', args=[Argument(type='double', derefcnt=0, name='x')]),
 'acosf': Function(type='float', derefcnt=0, name='acosf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'acosh': Function(type='double', derefcnt=0, name='acosh', args=[Argument(type='double', derefcnt=0, name='x')]),
 'acoshf': Function(type='float', derefcnt=0, name='acoshf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'acoshl': Function(type='long', derefcnt=0, name='acoshl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'acosl': Function(type='long', derefcnt=0, name='acosl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'action_fn_t': Function(type='void', derefcnt=0, name='action_fn_t', args=[Argument(type='void', derefcnt=1, name='nodep'), Argument(type='VISIT', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='level')]),
 'addmntent': Function(type='int', derefcnt=0, name='addmntent', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='mntent', derefcnt=1, name='mnt')]),
 'addseverity': Function(type='int', derefcnt=0, name='addseverity', args=[Argument(type='int', derefcnt=0, name='severity'), Argument(type='char', derefcnt=1, name='string')]),
 'adjtime': Function(type='int', derefcnt=0, name='adjtime', args=[Argument(type='timeval', derefcnt=1, name='delta'), Argument(type='timeval', derefcnt=1, name='olddelta')]),
 'adler32': Function(type='uLong', derefcnt=0, name='adler32', args=[Argument(type='uLong', derefcnt=0, name='adler'), Argument(type='Bytef', derefcnt=1, name='buf'), Argument(type='uInt', derefcnt=0, name='len')]),
 'adler32_combine': Function(type='uLong', derefcnt=0, name='adler32_combine', args=[Argument(type='uLong', derefcnt=0, name='arg0'), Argument(type='uLong', derefcnt=0, name='arg1'), Argument(type='off_t', derefcnt=0, name='arg2')]),
 'adler32_combine64': Function(type='uLong', derefcnt=0, name='adler32_combine64', args=[Argument(type='uLong', derefcnt=0, name='arg0'), Argument(type='uLong', derefcnt=0, name='arg1'), Argument(type='off64_t', derefcnt=0, name='arg2')]),
 'advance': Function(type='int', derefcnt=0, name='advance', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='char', derefcnt=1, name='expbuf')]),
 'after_morecore_hook': Function(type='void', derefcnt=0, name='after_morecore_hook', args=[]),
 'aio_cancel': Function(type='int', derefcnt=0, name='aio_cancel', args=[Argument(type='int', derefcnt=0, name='fildes'), Argument(type='aiocb', derefcnt=1, name='aiocbp')]),
 'aio_cancel64': Function(type='int', derefcnt=0, name='aio_cancel64', args=[Argument(type='int', derefcnt=0, name='fildes'), Argument(type='aiocb64', derefcnt=1, name='aiocbp')]),
 'aio_error': Function(type='int', derefcnt=0, name='aio_error', args=[Argument(type='aiocb', derefcnt=1, name='aiocbp')]),
 'aio_error64': Function(type='int', derefcnt=0, name='aio_error64', args=[Argument(type='aiocb64', derefcnt=1, name='aiocbp')]),
 'aio_fsync': Function(type='int', derefcnt=0, name='aio_fsync', args=[Argument(type='int', derefcnt=0, name='operation'), Argument(type='aiocb', derefcnt=1, name='aiocbp')]),
 'aio_fsync64': Function(type='int', derefcnt=0, name='aio_fsync64', args=[Argument(type='int', derefcnt=0, name='operation'), Argument(type='aiocb64', derefcnt=1, name='aiocbp')]),
 'aio_init': Function(type='void', derefcnt=0, name='aio_init', args=[Argument(type='aioinit', derefcnt=1, name='init')]),
 'aio_read': Function(type='int', derefcnt=0, name='aio_read', args=[Argument(type='aiocb', derefcnt=1, name='aiocbp')]),
 'aio_read64': Function(type='int', derefcnt=0, name='aio_read64', args=[Argument(type='aiocb64', derefcnt=1, name='aiocbp')]),
 'aio_return': Function(type='ssize_t', derefcnt=0, name='aio_return', args=[Argument(type='aiocb', derefcnt=1, name='aiocbp')]),
 'aio_return64': Function(type='ssize_t', derefcnt=0, name='aio_return64', args=[Argument(type='aiocb64', derefcnt=1, name='aiocbp')]),
 'aio_suspend': Function(type='int', derefcnt=0, name='aio_suspend', args=[Argument(type='aiocb', derefcnt=2, name='list'), Argument(type='int', derefcnt=0, name='nent'), Argument(type='timespec', derefcnt=1, name='timeout')]),
 'aio_suspend64': Function(type='int', derefcnt=0, name='aio_suspend64', args=[Argument(type='aiocb64', derefcnt=2, name='list'), Argument(type='int', derefcnt=0, name='nent'), Argument(type='timespec', derefcnt=1, name='timeout')]),
 'aio_write': Function(type='int', derefcnt=0, name='aio_write', args=[Argument(type='aiocb', derefcnt=1, name='aiocbp')]),
 'aio_write64': Function(type='int', derefcnt=0, name='aio_write64', args=[Argument(type='aiocb64', derefcnt=1, name='aiocbp')]),
 'alarm': Function(type='unsigned', derefcnt=0, name='alarm', args=[Argument(type='unsigned', derefcnt=0, name='seconds')]),
 'aligned_alloc': Function(type='void', derefcnt=1, name='aligned_alloc', args=[Argument(type='size_t', derefcnt=0, name='alignment'), Argument(type='size_t', derefcnt=0, name='size')]),
 'alloc': Function(type='void', derefcnt=1, name='alloc', args=[Argument(type='void', derefcnt=1, name='opaque'), Argument(type='size_t', derefcnt=0, name='nmemb'), Argument(type='size_t', derefcnt=0, name='size')]),
 'alloc_func': Function(type='voidpf', derefcnt=0, name='alloc_func', args=[Argument(type='voidpf', derefcnt=0, name='opaque'), Argument(type='uInt', derefcnt=0, name='items'), Argument(type='uInt', derefcnt=0, name='size')]),
 'alloca': Function(type='void', derefcnt=1, name='alloca', args=[Argument(type='size_t', derefcnt=0, name='size')]),
 'alphasort': Function(type='int', derefcnt=0, name='alphasort', args=[Argument(type='dirent', derefcnt=2, name='e1'), Argument(type='dirent', derefcnt=2, name='e2')]),
 'alphasort64': Function(type='int', derefcnt=0, name='alphasort64', args=[Argument(type='dirent64', derefcnt=2, name='e1'), Argument(type='dirent64', derefcnt=2, name='e2')]),
 'app_gen_cookie_cb': Function(type='int', derefcnt=0, name='app_gen_cookie_cb', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='cookie'), Argument(type='unsigned', derefcnt=1, name='cookie_len')]),
 'app_verify_callback': Function(type='int', derefcnt=0, name='app_verify_callback', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'app_verify_cookie_cb': Function(type='int', derefcnt=0, name='app_verify_cookie_cb', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='cookie'), Argument(type='unsigned', derefcnt=0, name='cookie_len')]),
 'argp_error': Function(type='void', derefcnt=0, name='argp_error', args=[Argument(type='argp_state', derefcnt=1, name='state'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='int', derefcnt=0, name='vararg')]),
 'argp_failure': Function(type='void', derefcnt=0, name='argp_failure', args=[Argument(type='argp_state', derefcnt=1, name='state'), Argument(type='int', derefcnt=0, name='status'), Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='int', derefcnt=0, name='vararg')]),
 'argp_help': Function(type='void', derefcnt=0, name='argp_help', args=[Argument(type='argp', derefcnt=1, name='argp'), Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='unsigned', derefcnt=0, name='flags'), Argument(type='char', derefcnt=1, name='name')]),
 'argp_input': Function(type='void', derefcnt=1, name='argp_input', args=[Argument(type='argp', derefcnt=1, name='argp'), Argument(type='argp_state', derefcnt=1, name='state')]),
 'argp_parse': Function(type='error_t', derefcnt=0, name='argp_parse', args=[Argument(type='argp', derefcnt=1, name='argp'), Argument(type='int', derefcnt=0, name='argc'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='unsigned', derefcnt=0, name='flags'), Argument(type='int', derefcnt=1, name='arg_index'), Argument(type='void', derefcnt=1, name='input')]),
 'argp_parser_t': Function(type='error_t', derefcnt=0, name='argp_parser_t', args=[Argument(type='int', derefcnt=0, name='key'), Argument(type='char', derefcnt=1, name='arg'), Argument(type='argp_state', derefcnt=1, name='state')]),
 'argp_program_version_hook': Function(type='void', derefcnt=0, name='argp_program_version_hook', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='argp_state', derefcnt=1, name='state')]),
 'argp_state_help': Function(type='void', derefcnt=0, name='argp_state_help', args=[Argument(type='argp_state', derefcnt=1, name='state'), Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'argp_usage': Function(type='void', derefcnt=0, name='argp_usage', args=[Argument(type='argp_state', derefcnt=1, name='state')]),
 'argz_add': Function(type='error_t', derefcnt=0, name='argz_add', args=[Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='argz_len'), Argument(type='char', derefcnt=1, name='str')]),
 'argz_add_sep': Function(type='error_t', derefcnt=0, name='argz_add_sep', args=[Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='argz_len'), Argument(type='char', derefcnt=1, name='string'), Argument(type='int', derefcnt=0, name='delim')]),
 'argz_append': Function(type='error_t', derefcnt=0, name='argz_append', args=[Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='argz_len'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buf_len')]),
 'argz_count': Function(type='size_t', derefcnt=0, name='argz_count', args=[Argument(type='char', derefcnt=1, name='argz'), Argument(type='size_t', derefcnt=0, name='len')]),
 'argz_create': Function(type='error_t', derefcnt=0, name='argz_create', args=[Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='len')]),
 'argz_create_sep': Function(type='error_t', derefcnt=0, name='argz_create_sep', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='int', derefcnt=0, name='sep'), Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='len')]),
 'argz_delete': Function(type='void', derefcnt=0, name='argz_delete', args=[Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='argz_len'), Argument(type='char', derefcnt=1, name='entry')]),
 'argz_extract': Function(type='void', derefcnt=0, name='argz_extract', args=[Argument(type='char', derefcnt=1, name='argz'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='char', derefcnt=2, name='argv')]),
 'argz_insert': Function(type='error_t', derefcnt=0, name='argz_insert', args=[Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='argz_len'), Argument(type='char', derefcnt=1, name='before'), Argument(type='char', derefcnt=1, name='entry')]),
 'argz_next': Function(type='char', derefcnt=1, name='argz_next', args=[Argument(type='char', derefcnt=1, name='argz'), Argument(type='size_t', derefcnt=0, name='argz_len'), Argument(type='char', derefcnt=1, name='entry')]),
 'argz_replace': Function(type='error_t', derefcnt=0, name='argz_replace', args=[Argument(type='char', derefcnt=2, name='argz'), Argument(type='size_t', derefcnt=1, name='argz_len'), Argument(type='char', derefcnt=1, name='str'), Argument(type='char', derefcnt=1, name='with'), Argument(type='unsigned', derefcnt=1, name='replace_count')]),
 'argz_stringify': Function(type='void', derefcnt=0, name='argz_stringify', args=[Argument(type='char', derefcnt=1, name='argz'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='sep')]),
 'asctime': Function(type='char', derefcnt=1, name='asctime', args=[Argument(type='tm', derefcnt=1, name='tp')]),
 'asctime_r': Function(type='char', derefcnt=1, name='asctime_r', args=[Argument(type='tm', derefcnt=1, name='tp'), Argument(type='char', derefcnt=1, name='buf')]),
 'asin': Function(type='double', derefcnt=0, name='asin', args=[Argument(type='double', derefcnt=0, name='x')]),
 'asinf': Function(type='float', derefcnt=0, name='asinf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'asinh': Function(type='double', derefcnt=0, name='asinh', args=[Argument(type='double', derefcnt=0, name='x')]),
 'asinhf': Function(type='float', derefcnt=0, name='asinhf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'asinhl': Function(type='long', derefcnt=0, name='asinhl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'asinl': Function(type='long', derefcnt=0, name='asinl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'asn1_Finish': Function(type='int', derefcnt=0, name='asn1_Finish', args=[Argument(type='ASN1_CTX', derefcnt=1, name='c')]),
 'asn1_const_Finish': Function(type='int', derefcnt=0, name='asn1_const_Finish', args=[Argument(type='ASN1_const_CTX', derefcnt=1, name='c')]),
 'asn1_ps_func': Function(type='int', derefcnt=0, name='asn1_ps_func', args=[Argument(type='BIO', derefcnt=1, name='b'), Argument(type='unsigned', derefcnt=2, name='pbuf'), Argument(type='int', derefcnt=1, name='plen'), Argument(type='void', derefcnt=1, name='parg')]),
 'asprintf': Function(type='int', derefcnt=0, name='asprintf', args=[Argument(type='char', derefcnt=2, name='ptr'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='int', derefcnt=0, name='vararg')]),
 'assert': Function(type='void', derefcnt=0, name='assert', args=[Argument(type='char', derefcnt=1, name='assertion'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='line')]),
 'assert_fail': Function(type='void', derefcnt=0, name='assert_fail', args=[Argument(type='char', derefcnt=1, name='assertion'), Argument(type='char', derefcnt=1, name='file'), Argument(type='unsigned', derefcnt=0, name='line'), Argument(type='char', derefcnt=1, name='function')]),
 'assert_perror_fail': Function(type='void', derefcnt=0, name='assert_perror_fail', args=[Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='file'), Argument(type='unsigned', derefcnt=0, name='line'), Argument(type='char', derefcnt=1, name='function')]),
 'at_quick_exit': Function(type='int', derefcnt=0, name='at_quick_exit', args=[Argument(type='void', derefcnt=0, name='func')]),
 'atan': Function(type='double', derefcnt=0, name='atan', args=[Argument(type='double', derefcnt=0, name='x')]),
 'atan2': Function(type='double', derefcnt=0, name='atan2', args=[Argument(type='double', derefcnt=0, name='y'), Argument(type='double', derefcnt=0, name='x')]),
 'atan2f': Function(type='float', derefcnt=0, name='atan2f', args=[Argument(type='float', derefcnt=0, name='y'), Argument(type='float', derefcnt=0, name='x')]),
 'atan2l': Function(type='long', derefcnt=0, name='atan2l', args=[Argument(type='long', derefcnt=0, name='y'), Argument(type='long', derefcnt=0, name='x')]),
 'atanf': Function(type='float', derefcnt=0, name='atanf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'atanh': Function(type='double', derefcnt=0, name='atanh', args=[Argument(type='double', derefcnt=0, name='x')]),
 'atanhf': Function(type='float', derefcnt=0, name='atanhf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'atanhl': Function(type='long', derefcnt=0, name='atanhl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'atanl': Function(type='long', derefcnt=0, name='atanl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'atexit': Function(type='int', derefcnt=0, name='atexit', args=[Argument(type='void', derefcnt=0, name='func')]),
 'atof': Function(type='double', derefcnt=0, name='atof', args=[Argument(type='char', derefcnt=1, name='nptr')]),
 'atoi': Function(type='int', derefcnt=0, name='atoi', args=[Argument(type='char', derefcnt=1, name='nptr')]),
 'atol': Function(type='long', derefcnt=0, name='atol', args=[Argument(type='char', derefcnt=1, name='nptr')]),
 'atoll': Function(type='long', derefcnt=0, name='atoll', args=[Argument(type='char', derefcnt=1, name='nptr')]),
 'b2i_PVK_bio': Function(type='EVP_PKEY', derefcnt=1, name='b2i_PVK_bio', args=[Argument(type='BIO', derefcnt=1, name='in'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'b2i_PrivateKey': Function(type='EVP_PKEY', derefcnt=1, name='b2i_PrivateKey', args=[Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='length')]),
 'b2i_PrivateKey_bio': Function(type='EVP_PKEY', derefcnt=1, name='b2i_PrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='in')]),
 'b2i_PublicKey': Function(type='EVP_PKEY', derefcnt=1, name='b2i_PublicKey', args=[Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='length')]),
 'b2i_PublicKey_bio': Function(type='EVP_PKEY', derefcnt=1, name='b2i_PublicKey_bio', args=[Argument(type='BIO', derefcnt=1, name='in')]),
 'b64_ntop': Function(type='int', derefcnt=0, name='b64_ntop', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='size_t', derefcnt=0, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='size_t', derefcnt=0, name='arg3')]),
 'b64_pton': Function(type='int', derefcnt=0, name='b64_pton', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2')]),
 'backtrace': Function(type='int', derefcnt=0, name='backtrace', args=[Argument(type='void', derefcnt=2, name='array'), Argument(type='int', derefcnt=0, name='size')]),
 'backtrace_symbols': Function(type='char', derefcnt=2, name='backtrace_symbols', args=[Argument(type='void', derefcnt=2, name='array'), Argument(type='int', derefcnt=0, name='size')]),
 'backtrace_symbols_fd': Function(type='void', derefcnt=0, name='backtrace_symbols_fd', args=[Argument(type='void', derefcnt=2, name='array'), Argument(type='int', derefcnt=0, name='size'), Argument(type='int', derefcnt=0, name='fd')]),
 'basename': Function(type='char', derefcnt=1, name='basename', args=[Argument(type='char', derefcnt=1, name='filename')]),
 'bcmp': Function(type='int', derefcnt=0, name='bcmp', args=[Argument(type='void', derefcnt=1, name='s1'), Argument(type='void', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'bcopy': Function(type='void', derefcnt=0, name='bcopy', args=[Argument(type='void', derefcnt=1, name='src'), Argument(type='void', derefcnt=1, name='dest'), Argument(type='size_t', derefcnt=0, name='n')]),
 'bgets': Function(type='int', derefcnt=0, name='bgets', args=[Argument(type='BIO', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'bind': Function(type='int', derefcnt=0, name='bind', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='CONST_SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=0, name='len')]),
 'bind_textdomain_codeset': Function(type='char', derefcnt=1, name='bind_textdomain_codeset', args=[Argument(type='char', derefcnt=1, name='domainname'), Argument(type='char', derefcnt=1, name='codeset')]),
 'bindresvport': Function(type='int', derefcnt=0, name='bindresvport', args=[Argument(type='int', derefcnt=0, name='sockfd'), Argument(type='sockaddr_in', derefcnt=1, name='sock_in')]),
 'bindresvport6': Function(type='int', derefcnt=0, name='bindresvport6', args=[Argument(type='int', derefcnt=0, name='sockfd'), Argument(type='sockaddr_in6', derefcnt=1, name='sock_in')]),
 'bindtextdomain': Function(type='char', derefcnt=1, name='bindtextdomain', args=[Argument(type='char', derefcnt=1, name='domainname'), Argument(type='char', derefcnt=1, name='dirname')]),
 'bio_info_cb': Function(type='void', derefcnt=0, name='bio_info_cb', args=[Argument(type='bio_st', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='long', derefcnt=0, name='arg4'), Argument(type='long', derefcnt=0, name='arg5')]),
 'bn_add_words': Function(type='unsigned', derefcnt=0, name='bn_add_words', args=[Argument(type='unsigned', derefcnt=1, name='rp'), Argument(type='unsigned', derefcnt=1, name='ap'), Argument(type='unsigned', derefcnt=1, name='bp'), Argument(type='int', derefcnt=0, name='num')]),
 'bn_div_words': Function(type='unsigned', derefcnt=0, name='bn_div_words', args=[Argument(type='unsigned', derefcnt=0, name='h'), Argument(type='unsigned', derefcnt=0, name='l'), Argument(type='unsigned', derefcnt=0, name='d')]),
 'bn_dup_expand': Function(type='BIGNUM', derefcnt=1, name='bn_dup_expand', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='words')]),
 'bn_expand2': Function(type='BIGNUM', derefcnt=1, name='bn_expand2', args=[Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='words')]),
 'bn_mod_exp': Function(type='int', derefcnt=0, name='bn_mod_exp', args=[Argument(type='DSA', derefcnt=1, name='dsa'), Argument(type='BIGNUM', derefcnt=1, name='r'), Argument(type='BIGNUM', derefcnt=1, name='a'), Argument(type='BIGNUM', derefcnt=1, name='p'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_MONT_CTX', derefcnt=1, name='m_ctx')]),
 'bn_mul_add_words': Function(type='unsigned', derefcnt=0, name='bn_mul_add_words', args=[Argument(type='unsigned', derefcnt=1, name='rp'), Argument(type='unsigned', derefcnt=1, name='ap'), Argument(type='int', derefcnt=0, name='num'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'bn_mul_words': Function(type='unsigned', derefcnt=0, name='bn_mul_words', args=[Argument(type='unsigned', derefcnt=1, name='rp'), Argument(type='unsigned', derefcnt=1, name='ap'), Argument(type='int', derefcnt=0, name='num'), Argument(type='unsigned', derefcnt=0, name='w')]),
 'bn_sqr_words': Function(type='void', derefcnt=0, name='bn_sqr_words', args=[Argument(type='unsigned', derefcnt=1, name='rp'), Argument(type='unsigned', derefcnt=1, name='ap'), Argument(type='int', derefcnt=0, name='num')]),
 'bn_sub_words': Function(type='unsigned', derefcnt=0, name='bn_sub_words', args=[Argument(type='unsigned', derefcnt=1, name='rp'), Argument(type='unsigned', derefcnt=1, name='ap'), Argument(type='unsigned', derefcnt=1, name='bp'), Argument(type='int', derefcnt=0, name='num')]),
 'bputs': Function(type='int', derefcnt=0, name='bputs', args=[Argument(type='BIO', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1')]),
 'bread': Function(type='int', derefcnt=0, name='bread', args=[Argument(type='BIO', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'brk': Function(type='int', derefcnt=0, name='brk', args=[Argument(type='void', derefcnt=1, name='addr')]),
 'bsd_signal': Function(type='sighandler_t', derefcnt=0, name='bsd_signal', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='sighandler_t', derefcnt=0, name='handler')]),
 'bsearch': Function(type='void', derefcnt=1, name='bsearch', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=1, name='base'), Argument(type='size_t', derefcnt=0, name='nmemb'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='compar_fn_t', derefcnt=0, name='compar')]),
 'bswap_32': Function(type='unsigned', derefcnt=0, name='bswap_32', args=[Argument(type='unsigned', derefcnt=0, name='bsx')]),
 'bswap_64': Function(type='uint64_t', derefcnt=0, name='bswap_64', args=[Argument(type='uint64_t', derefcnt=0, name='bsx')]),
 'btowc': Function(type='wint_t', derefcnt=0, name='btowc', args=[Argument(type='int', derefcnt=0, name='c')]),
 'bwrite': Function(type='int', derefcnt=0, name='bwrite', args=[Argument(type='BIO', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'bzero': Function(type='void', derefcnt=0, name='bzero', args=[Argument(type='void', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n')]),
 'c2i_ASN1_BIT_STRING': Function(type='ASN1_BIT_STRING', derefcnt=1, name='c2i_ASN1_BIT_STRING', args=[Argument(type='ASN1_BIT_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'c2i_ASN1_INTEGER': Function(type='ASN1_INTEGER', derefcnt=1, name='c2i_ASN1_INTEGER', args=[Argument(type='ASN1_INTEGER', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'c2i_ASN1_OBJECT': Function(type='ASN1_OBJECT', derefcnt=1, name='c2i_ASN1_OBJECT', args=[Argument(type='ASN1_OBJECT', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'cabs': Function(type='double', derefcnt=0, name='cabs', args=[Argument(type='double', derefcnt=0, name='z')]),
 'cabsf': Function(type='float', derefcnt=0, name='cabsf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'cabsl': Function(type='long', derefcnt=0, name='cabsl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'cacos': Function(type='double', derefcnt=0, name='cacos', args=[Argument(type='double', derefcnt=0, name='z')]),
 'cacosf': Function(type='float', derefcnt=0, name='cacosf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'cacosh': Function(type='double', derefcnt=0, name='cacosh', args=[Argument(type='double', derefcnt=0, name='z')]),
 'cacoshf': Function(type='float', derefcnt=0, name='cacoshf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'cacoshl': Function(type='long', derefcnt=0, name='cacoshl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'cacosl': Function(type='long', derefcnt=0, name='cacosl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'callback': Function(type='long', derefcnt=0, name='callback', args=[Argument(type='bio_st', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='long', derefcnt=0, name='arg4'), Argument(type='long', derefcnt=0, name='arg5')]),
 'callback_ctrl': Function(type='long', derefcnt=0, name='callback_ctrl', args=[Argument(type='BIO', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='bio_info_cb', derefcnt=1, name='arg2')]),
 'calloc': Function(type='void', derefcnt=1, name='calloc', args=[Argument(type='size_t', derefcnt=0, name='nmemb'), Argument(type='size_t', derefcnt=0, name='size')]),
 'cancel_routine': Function(type='void', derefcnt=0, name='cancel_routine', args=[Argument(type='void', derefcnt=1, name='arg0')]),
 'canonicalize_file_name': Function(type='char', derefcnt=1, name='canonicalize_file_name', args=[Argument(type='char', derefcnt=1, name='name')]),
 'carg': Function(type='double', derefcnt=0, name='carg', args=[Argument(type='double', derefcnt=0, name='z')]),
 'cargf': Function(type='float', derefcnt=0, name='cargf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'cargl': Function(type='long', derefcnt=0, name='cargl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'casin': Function(type='double', derefcnt=0, name='casin', args=[Argument(type='double', derefcnt=0, name='z')]),
 'casinf': Function(type='float', derefcnt=0, name='casinf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'casinh': Function(type='double', derefcnt=0, name='casinh', args=[Argument(type='double', derefcnt=0, name='z')]),
 'casinhf': Function(type='float', derefcnt=0, name='casinhf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'casinhl': Function(type='long', derefcnt=0, name='casinhl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'casinl': Function(type='long', derefcnt=0, name='casinl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'catan': Function(type='double', derefcnt=0, name='catan', args=[Argument(type='double', derefcnt=0, name='z')]),
 'catanf': Function(type='float', derefcnt=0, name='catanf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'catanh': Function(type='double', derefcnt=0, name='catanh', args=[Argument(type='double', derefcnt=0, name='z')]),
 'catanhf': Function(type='float', derefcnt=0, name='catanhf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'catanhl': Function(type='long', derefcnt=0, name='catanhl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'catanl': Function(type='long', derefcnt=0, name='catanl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'catclose': Function(type='int', derefcnt=0, name='catclose', args=[Argument(type='nl_catd', derefcnt=0, name='catalog')]),
 'catgets': Function(type='char', derefcnt=1, name='catgets', args=[Argument(type='nl_catd', derefcnt=0, name='catalog'), Argument(type='int', derefcnt=0, name='set'), Argument(type='int', derefcnt=0, name='number'), Argument(type='char', derefcnt=1, name='string')]),
 'catopen': Function(type='nl_catd', derefcnt=0, name='catopen', args=[Argument(type='char', derefcnt=1, name='cat_name'), Argument(type='int', derefcnt=0, name='flag')]),
 'cb_1': Function(type='void', derefcnt=0, name='cb_1', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='void', derefcnt=1, name='arg2')]),
 'cb_2': Function(type='int', derefcnt=0, name='cb_2', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='BN_GENCB', derefcnt=1, name='arg2')]),
 'cbrt': Function(type='double', derefcnt=0, name='cbrt', args=[Argument(type='double', derefcnt=0, name='x')]),
 'cbrtf': Function(type='float', derefcnt=0, name='cbrtf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'cbrtl': Function(type='long', derefcnt=0, name='cbrtl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'ccos': Function(type='double', derefcnt=0, name='ccos', args=[Argument(type='double', derefcnt=0, name='z')]),
 'ccosf': Function(type='float', derefcnt=0, name='ccosf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'ccosh': Function(type='double', derefcnt=0, name='ccosh', args=[Argument(type='double', derefcnt=0, name='z')]),
 'ccoshf': Function(type='float', derefcnt=0, name='ccoshf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'ccoshl': Function(type='long', derefcnt=0, name='ccoshl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'ccosl': Function(type='long', derefcnt=0, name='ccosl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'ceil': Function(type='double', derefcnt=0, name='ceil', args=[Argument(type='double', derefcnt=0, name='x')]),
 'ceilf': Function(type='float', derefcnt=0, name='ceilf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'ceill': Function(type='long', derefcnt=0, name='ceill', args=[Argument(type='long', derefcnt=0, name='x')]),
 'cert_crl': Function(type='int', derefcnt=0, name='cert_crl', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509_CRL', derefcnt=1, name='crl'), Argument(type='X509', derefcnt=1, name='x')]),
 'cexp': Function(type='double', derefcnt=0, name='cexp', args=[Argument(type='double', derefcnt=0, name='z')]),
 'cexpf': Function(type='float', derefcnt=0, name='cexpf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'cexpl': Function(type='long', derefcnt=0, name='cexpl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'cfgetispeed': Function(type='speed_t', derefcnt=0, name='cfgetispeed', args=[Argument(type='termios', derefcnt=1, name='termios_p')]),
 'cfgetospeed': Function(type='speed_t', derefcnt=0, name='cfgetospeed', args=[Argument(type='termios', derefcnt=1, name='termios_p')]),
 'cfmakeraw': Function(type='void', derefcnt=0, name='cfmakeraw', args=[Argument(type='termios', derefcnt=1, name='termios_p')]),
 'cfree': Function(type='void', derefcnt=0, name='cfree', args=[Argument(type='void', derefcnt=1, name='ptr')]),
 'cfsetispeed': Function(type='int', derefcnt=0, name='cfsetispeed', args=[Argument(type='termios', derefcnt=1, name='termios_p'), Argument(type='speed_t', derefcnt=0, name='speed')]),
 'cfsetospeed': Function(type='int', derefcnt=0, name='cfsetospeed', args=[Argument(type='termios', derefcnt=1, name='termios_p'), Argument(type='speed_t', derefcnt=0, name='speed')]),
 'cfsetspeed': Function(type='int', derefcnt=0, name='cfsetspeed', args=[Argument(type='termios', derefcnt=1, name='termios_p'), Argument(type='speed_t', derefcnt=0, name='speed')]),
 'chdir': Function(type='int', derefcnt=0, name='chdir', args=[Argument(type='char', derefcnt=1, name='path')]),
 'check_crl': Function(type='int', derefcnt=0, name='check_crl', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509_CRL', derefcnt=1, name='crl')]),
 'check_defer': Function(type='void', derefcnt=0, name='check_defer', args=[Argument(type='int', derefcnt=0, name='nid')]),
 'check_issued': Function(type='int', derefcnt=0, name='check_issued', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509', derefcnt=1, name='x'), Argument(type='X509', derefcnt=1, name='issuer')]),
 'check_policy': Function(type='int', derefcnt=0, name='check_policy', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'check_revocation': Function(type='int', derefcnt=0, name='check_revocation', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'check_trust': Function(type='int', derefcnt=0, name='check_trust', args=[Argument(type='x509_trust_st', derefcnt=1, name='arg0'), Argument(type='X509', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'chmod': Function(type='int', derefcnt=0, name='chmod', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'chown': Function(type='int', derefcnt=0, name='chown', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='uid_t', derefcnt=0, name='owner'), Argument(type='gid_t', derefcnt=0, name='group')]),
 'chroot': Function(type='int', derefcnt=0, name='chroot', args=[Argument(type='char', derefcnt=1, name='path')]),
 'chunkfun': Function(type='obstack_chunk', derefcnt=1, name='chunkfun', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='long', derefcnt=0, name='arg1')]),
 'cimag': Function(type='double', derefcnt=0, name='cimag', args=[Argument(type='double', derefcnt=0, name='z')]),
 'cimagf': Function(type='float', derefcnt=0, name='cimagf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'cimagl': Function(type='long', derefcnt=0, name='cimagl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'cleanup': Function(type='int', derefcnt=0, name='cleanup', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'clearenv': Function(type='int', derefcnt=0, name='clearenv', args=[]),
 'clearerr': Function(type='void', derefcnt=0, name='clearerr', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'clearerr_unlocked': Function(type='void', derefcnt=0, name='clearerr_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'client_cert_cb': Function(type='int', derefcnt=0, name='client_cert_cb', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='X509', derefcnt=2, name='x509'), Argument(type='EVP_PKEY', derefcnt=2, name='pkey')]),
 'clock': Function(type='clock_t', derefcnt=0, name='clock', args=[]),
 'clock_adjtime': Function(type='int', derefcnt=0, name='clock_adjtime', args=[Argument(type='clockid_t', derefcnt=0, name='clock_id'), Argument(type='timex', derefcnt=1, name='utx')]),
 'clock_getcpuclockid': Function(type='int', derefcnt=0, name='clock_getcpuclockid', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='clockid_t', derefcnt=1, name='clock_id')]),
 'clock_getres': Function(type='int', derefcnt=0, name='clock_getres', args=[Argument(type='clockid_t', derefcnt=0, name='clock_id'), Argument(type='timespec', derefcnt=1, name='res')]),
 'clock_gettime': Function(type='int', derefcnt=0, name='clock_gettime', args=[Argument(type='clockid_t', derefcnt=0, name='clock_id'), Argument(type='timespec', derefcnt=1, name='tp')]),
 'clock_nanosleep': Function(type='int', derefcnt=0, name='clock_nanosleep', args=[Argument(type='clockid_t', derefcnt=0, name='clock_id'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='timespec', derefcnt=1, name='req'), Argument(type='timespec', derefcnt=1, name='rem')]),
 'clock_settime': Function(type='int', derefcnt=0, name='clock_settime', args=[Argument(type='clockid_t', derefcnt=0, name='clock_id'), Argument(type='timespec', derefcnt=1, name='tp')]),
 'clog': Function(type='double', derefcnt=0, name='clog', args=[Argument(type='double', derefcnt=0, name='z')]),
 'clog10': Function(type='double', derefcnt=0, name='clog10', args=[Argument(type='double', derefcnt=0, name='z')]),
 'clog10f': Function(type='float', derefcnt=0, name='clog10f', args=[Argument(type='float', derefcnt=0, name='z')]),
 'clog10l': Function(type='long', derefcnt=0, name='clog10l', args=[Argument(type='long', derefcnt=0, name='z')]),
 'clogf': Function(type='float', derefcnt=0, name='clogf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'clogl': Function(type='long', derefcnt=0, name='clogl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'clone': Function(type='int', derefcnt=0, name='clone', args=[Argument(type='int', derefcnt=0, name='fn'), Argument(type='void', derefcnt=1, name='child_stack'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='void', derefcnt=1, name='arg'), Argument(type='int', derefcnt=0, name='vararg')]),
 'close': Function(type='int', derefcnt=0, name='close', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'closedir': Function(type='int', derefcnt=0, name='closedir', args=[Argument(type='DIR', derefcnt=1, name='dirp')]),
 'closelog': Function(type='void', derefcnt=0, name='closelog', args=[]),
 'cmsg_nxthdr': Function(type='cmsghdr', derefcnt=1, name='cmsg_nxthdr', args=[Argument(type='msghdr', derefcnt=1, name='mhdr'), Argument(type='cmsghdr', derefcnt=1, name='cmsg')]),
 'comp': Function(type='int', derefcnt=0, name='comp', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'compar_d_fn_t': Function(type='int', derefcnt=0, name='compar_d_fn_t', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1'), Argument(type='void', derefcnt=1, name='arg2')]),
 'compar_fn_t': Function(type='int', derefcnt=0, name='compar_fn_t', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'compile': Function(type='char', derefcnt=1, name='compile', args=[Argument(type='char', derefcnt=1, name='instring'), Argument(type='char', derefcnt=1, name='expbuf'), Argument(type='char', derefcnt=1, name='endbuf'), Argument(type='int', derefcnt=0, name='eof')]),
 'compress': Function(type='int', derefcnt=0, name='compress', args=[Argument(type='Bytef', derefcnt=1, name='dest'), Argument(type='uLongf', derefcnt=1, name='destLen'), Argument(type='Bytef', derefcnt=1, name='source'), Argument(type='uLong', derefcnt=0, name='sourceLen')]),
 'compress2': Function(type='int', derefcnt=0, name='compress2', args=[Argument(type='Bytef', derefcnt=1, name='dest'), Argument(type='uLongf', derefcnt=1, name='destLen'), Argument(type='Bytef', derefcnt=1, name='source'), Argument(type='uLong', derefcnt=0, name='sourceLen'), Argument(type='int', derefcnt=0, name='level')]),
 'compressBound': Function(type='uLong', derefcnt=0, name='compressBound', args=[Argument(type='uLong', derefcnt=0, name='sourceLen')]),
 'compute_key': Function(type='int', derefcnt=0, name='compute_key', args=[Argument(type='unsigned', derefcnt=1, name='key'), Argument(type='BIGNUM', derefcnt=1, name='pub_key'), Argument(type='DH', derefcnt=1, name='dh')]),
 'confstr': Function(type='size_t', derefcnt=0, name='confstr', args=[Argument(type='int', derefcnt=0, name='name'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len')]),
 'conj': Function(type='double', derefcnt=0, name='conj', args=[Argument(type='double', derefcnt=0, name='z')]),
 'conjf': Function(type='float', derefcnt=0, name='conjf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'conjl': Function(type='long', derefcnt=0, name='conjl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'connect': Function(type='int', derefcnt=0, name='connect', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='CONST_SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=0, name='len')]),
 'copy': Function(type='int', derefcnt=0, name='copy', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='to'), Argument(type='EVP_MD_CTX', derefcnt=1, name='from')]),
 'copysign': Function(type='double', derefcnt=0, name='copysign', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'copysignf': Function(type='float', derefcnt=0, name='copysignf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'copysignl': Function(type='long', derefcnt=0, name='copysignl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'cos': Function(type='double', derefcnt=0, name='cos', args=[Argument(type='double', derefcnt=0, name='x')]),
 'cosf': Function(type='float', derefcnt=0, name='cosf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'cosh': Function(type='double', derefcnt=0, name='cosh', args=[Argument(type='double', derefcnt=0, name='x')]),
 'coshf': Function(type='float', derefcnt=0, name='coshf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'coshl': Function(type='long', derefcnt=0, name='coshl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'cosl': Function(type='long', derefcnt=0, name='cosl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'cpow': Function(type='double', derefcnt=0, name='cpow', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'cpowf': Function(type='float', derefcnt=0, name='cpowf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'cpowl': Function(type='long', derefcnt=0, name='cpowl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'cproj': Function(type='double', derefcnt=0, name='cproj', args=[Argument(type='double', derefcnt=0, name='z')]),
 'cprojf': Function(type='float', derefcnt=0, name='cprojf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'cprojl': Function(type='long', derefcnt=0, name='cprojl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'crc32': Function(type='uLong', derefcnt=0, name='crc32', args=[Argument(type='uLong', derefcnt=0, name='crc'), Argument(type='Bytef', derefcnt=1, name='buf'), Argument(type='uInt', derefcnt=0, name='len')]),
 'crc32_combine': Function(type='uLong', derefcnt=0, name='crc32_combine', args=[Argument(type='uLong', derefcnt=0, name='arg0'), Argument(type='uLong', derefcnt=0, name='arg1'), Argument(type='off_t', derefcnt=0, name='arg2')]),
 'crc32_combine64': Function(type='uLong', derefcnt=0, name='crc32_combine64', args=[Argument(type='uLong', derefcnt=0, name='arg0'), Argument(type='uLong', derefcnt=0, name='arg1'), Argument(type='off64_t', derefcnt=0, name='arg2')]),
 'creal': Function(type='double', derefcnt=0, name='creal', args=[Argument(type='double', derefcnt=0, name='z')]),
 'crealf': Function(type='float', derefcnt=0, name='crealf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'creall': Function(type='long', derefcnt=0, name='creall', args=[Argument(type='long', derefcnt=0, name='z')]),
 'creat': Function(type='int', derefcnt=0, name='creat', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'creat64': Function(type='int', derefcnt=0, name='creat64', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'create': Function(type='int', derefcnt=0, name='create', args=[Argument(type='BIO', derefcnt=1, name='arg0')]),
 'crypt': Function(type='char', derefcnt=1, name='crypt', args=[Argument(type='char', derefcnt=1, name='key'), Argument(type='char', derefcnt=1, name='salt')]),
 'crypt_r': Function(type='char', derefcnt=1, name='crypt_r', args=[Argument(type='char', derefcnt=1, name='key'), Argument(type='char', derefcnt=1, name='salt'), Argument(type='crypt_data', derefcnt=1, name='data')]),
 'csin': Function(type='double', derefcnt=0, name='csin', args=[Argument(type='double', derefcnt=0, name='z')]),
 'csinf': Function(type='float', derefcnt=0, name='csinf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'csinh': Function(type='double', derefcnt=0, name='csinh', args=[Argument(type='double', derefcnt=0, name='z')]),
 'csinhf': Function(type='float', derefcnt=0, name='csinhf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'csinhl': Function(type='long', derefcnt=0, name='csinhl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'csinl': Function(type='long', derefcnt=0, name='csinl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'csqrt': Function(type='double', derefcnt=0, name='csqrt', args=[Argument(type='double', derefcnt=0, name='z')]),
 'csqrtf': Function(type='float', derefcnt=0, name='csqrtf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'csqrtl': Function(type='long', derefcnt=0, name='csqrtl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'ctan': Function(type='double', derefcnt=0, name='ctan', args=[Argument(type='double', derefcnt=0, name='z')]),
 'ctanf': Function(type='float', derefcnt=0, name='ctanf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'ctanh': Function(type='double', derefcnt=0, name='ctanh', args=[Argument(type='double', derefcnt=0, name='z')]),
 'ctanhf': Function(type='float', derefcnt=0, name='ctanhf', args=[Argument(type='float', derefcnt=0, name='z')]),
 'ctanhl': Function(type='long', derefcnt=0, name='ctanhl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'ctanl': Function(type='long', derefcnt=0, name='ctanl', args=[Argument(type='long', derefcnt=0, name='z')]),
 'ctermid': Function(type='char', derefcnt=1, name='ctermid', args=[Argument(type='char', derefcnt=1, name='s')]),
 'ctime': Function(type='char', derefcnt=1, name='ctime', args=[Argument(type='time_t', derefcnt=1, name='timer')]),
 'ctime_r': Function(type='char', derefcnt=1, name='ctime_r', args=[Argument(type='time_t', derefcnt=1, name='timer'), Argument(type='char', derefcnt=1, name='buf')]),
 'ctrl': Function(type='int', derefcnt=0, name='ctrl', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='char', derefcnt=1, name='argc'), Argument(type='long', derefcnt=0, name='argl'), Argument(type='char', derefcnt=2, name='ret')]),
 'ctype_b_loc': Function(type='unsigned', derefcnt=2, name='ctype_b_loc', args=[]),
 'ctype_get_mb_cur_max': Function(type='size_t', derefcnt=0, name='ctype_get_mb_cur_max', args=[]),
 'ctype_tolower_loc': Function(type='int32_t', derefcnt=2, name='ctype_tolower_loc', args=[]),
 'ctype_toupper_loc': Function(type='int32_t', derefcnt=2, name='ctype_toupper_loc', args=[]),
 'cuserid': Function(type='char', derefcnt=1, name='cuserid', args=[Argument(type='char', derefcnt=1, name='s')]),
 'd2i_ASN1_BIT_STRING': Function(type='ASN1_BIT_STRING', derefcnt=1, name='d2i_ASN1_BIT_STRING', args=[Argument(type='ASN1_BIT_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_BMPSTRING': Function(type='ASN1_BMPSTRING', derefcnt=1, name='d2i_ASN1_BMPSTRING', args=[Argument(type='ASN1_BMPSTRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_BOOLEAN': Function(type='int', derefcnt=0, name='d2i_ASN1_BOOLEAN', args=[Argument(type='int', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_ASN1_ENUMERATED': Function(type='ASN1_ENUMERATED', derefcnt=1, name='d2i_ASN1_ENUMERATED', args=[Argument(type='ASN1_ENUMERATED', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_GENERALIZEDTIME': Function(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='d2i_ASN1_GENERALIZEDTIME', args=[Argument(type='ASN1_GENERALIZEDTIME', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_GENERALSTRING': Function(type='ASN1_GENERALSTRING', derefcnt=1, name='d2i_ASN1_GENERALSTRING', args=[Argument(type='ASN1_GENERALSTRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_IA5STRING': Function(type='ASN1_IA5STRING', derefcnt=1, name='d2i_ASN1_IA5STRING', args=[Argument(type='ASN1_IA5STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_INTEGER': Function(type='ASN1_INTEGER', derefcnt=1, name='d2i_ASN1_INTEGER', args=[Argument(type='ASN1_INTEGER', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_NULL': Function(type='ASN1_NULL', derefcnt=1, name='d2i_ASN1_NULL', args=[Argument(type='ASN1_NULL', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_OBJECT': Function(type='ASN1_OBJECT', derefcnt=1, name='d2i_ASN1_OBJECT', args=[Argument(type='ASN1_OBJECT', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_ASN1_OCTET_STRING': Function(type='ASN1_OCTET_STRING', derefcnt=1, name='d2i_ASN1_OCTET_STRING', args=[Argument(type='ASN1_OCTET_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_PRINTABLE': Function(type='ASN1_STRING', derefcnt=1, name='d2i_ASN1_PRINTABLE', args=[Argument(type='ASN1_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_PRINTABLESTRING': Function(type='ASN1_PRINTABLESTRING', derefcnt=1, name='d2i_ASN1_PRINTABLESTRING', args=[Argument(type='ASN1_PRINTABLESTRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_SEQUENCE_ANY': Function(type='ASN1_SEQUENCE_ANY', derefcnt=1, name='d2i_ASN1_SEQUENCE_ANY', args=[Argument(type='ASN1_SEQUENCE_ANY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_SET': Function(type='stack_st_OPENSSL_BLOCK', derefcnt=1, name='d2i_ASN1_SET', args=[Argument(type='stack_st_OPENSSL_BLOCK', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length'), Argument(type='d2i_of_void', derefcnt=1, name='d2i'), Argument(type='void', derefcnt=0, name='free_func'), Argument(type='int', derefcnt=0, name='ex_tag'), Argument(type='int', derefcnt=0, name='ex_class')]),
 'd2i_ASN1_SET_ANY': Function(type='ASN1_SEQUENCE_ANY', derefcnt=1, name='d2i_ASN1_SET_ANY', args=[Argument(type='ASN1_SEQUENCE_ANY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_T61STRING': Function(type='ASN1_T61STRING', derefcnt=1, name='d2i_ASN1_T61STRING', args=[Argument(type='ASN1_T61STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_TIME': Function(type='ASN1_TIME', derefcnt=1, name='d2i_ASN1_TIME', args=[Argument(type='ASN1_TIME', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_TYPE': Function(type='ASN1_TYPE', derefcnt=1, name='d2i_ASN1_TYPE', args=[Argument(type='ASN1_TYPE', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_UINTEGER': Function(type='ASN1_INTEGER', derefcnt=1, name='d2i_ASN1_UINTEGER', args=[Argument(type='ASN1_INTEGER', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_ASN1_UNIVERSALSTRING': Function(type='ASN1_UNIVERSALSTRING', derefcnt=1, name='d2i_ASN1_UNIVERSALSTRING', args=[Argument(type='ASN1_UNIVERSALSTRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_UTCTIME': Function(type='ASN1_UTCTIME', derefcnt=1, name='d2i_ASN1_UTCTIME', args=[Argument(type='ASN1_UTCTIME', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_UTF8STRING': Function(type='ASN1_UTF8STRING', derefcnt=1, name='d2i_ASN1_UTF8STRING', args=[Argument(type='ASN1_UTF8STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_VISIBLESTRING': Function(type='ASN1_VISIBLESTRING', derefcnt=1, name='d2i_ASN1_VISIBLESTRING', args=[Argument(type='ASN1_VISIBLESTRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ASN1_bytes': Function(type='ASN1_STRING', derefcnt=1, name='d2i_ASN1_bytes', args=[Argument(type='ASN1_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='Ptag'), Argument(type='int', derefcnt=0, name='Pclass')]),
 'd2i_ASN1_type_bytes': Function(type='ASN1_STRING', derefcnt=1, name='d2i_ASN1_type_bytes', args=[Argument(type='ASN1_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='type')]),
 'd2i_AutoPrivateKey': Function(type='EVP_PKEY', derefcnt=1, name='d2i_AutoPrivateKey', args=[Argument(type='EVP_PKEY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_DHparams': Function(type='DH', derefcnt=1, name='d2i_DHparams', args=[Argument(type='DH', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_DIRECTORYSTRING': Function(type='ASN1_STRING', derefcnt=1, name='d2i_DIRECTORYSTRING', args=[Argument(type='ASN1_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_DISPLAYTEXT': Function(type='ASN1_STRING', derefcnt=1, name='d2i_DISPLAYTEXT', args=[Argument(type='ASN1_STRING', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_DSAPrivateKey': Function(type='DSA', derefcnt=1, name='d2i_DSAPrivateKey', args=[Argument(type='DSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_DSAPrivateKey_bio': Function(type='DSA', derefcnt=1, name='d2i_DSAPrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=2, name='dsa')]),
 'd2i_DSAPrivateKey_fp': Function(type='DSA', derefcnt=1, name='d2i_DSAPrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=2, name='dsa')]),
 'd2i_DSAPublicKey': Function(type='DSA', derefcnt=1, name='d2i_DSAPublicKey', args=[Argument(type='DSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_DSA_PUBKEY': Function(type='DSA', derefcnt=1, name='d2i_DSA_PUBKEY', args=[Argument(type='DSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_DSA_PUBKEY_bio': Function(type='DSA', derefcnt=1, name='d2i_DSA_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=2, name='dsa')]),
 'd2i_DSA_PUBKEY_fp': Function(type='DSA', derefcnt=1, name='d2i_DSA_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=2, name='dsa')]),
 'd2i_DSA_SIG': Function(type='DSA_SIG', derefcnt=1, name='d2i_DSA_SIG', args=[Argument(type='DSA_SIG', derefcnt=2, name='v'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_DSAparams': Function(type='DSA', derefcnt=1, name='d2i_DSAparams', args=[Argument(type='DSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_ECDSA_SIG': Function(type='ECDSA_SIG', derefcnt=1, name='d2i_ECDSA_SIG', args=[Argument(type='ECDSA_SIG', derefcnt=2, name='sig'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ECPKParameters': Function(type='EC_GROUP', derefcnt=1, name='d2i_ECPKParameters', args=[Argument(type='EC_GROUP', derefcnt=2, name='arg0'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ECParameters': Function(type='EC_KEY', derefcnt=1, name='d2i_ECParameters', args=[Argument(type='EC_KEY', derefcnt=2, name='key'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ECPrivateKey': Function(type='EC_KEY', derefcnt=1, name='d2i_ECPrivateKey', args=[Argument(type='EC_KEY', derefcnt=2, name='key'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_ECPrivateKey_bio': Function(type='EC_KEY', derefcnt=1, name='d2i_ECPrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=2, name='eckey')]),
 'd2i_ECPrivateKey_fp': Function(type='EC_KEY', derefcnt=1, name='d2i_ECPrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=2, name='eckey')]),
 'd2i_EC_PUBKEY': Function(type='EC_KEY', derefcnt=1, name='d2i_EC_PUBKEY', args=[Argument(type='EC_KEY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_EC_PUBKEY_bio': Function(type='EC_KEY', derefcnt=1, name='d2i_EC_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=2, name='eckey')]),
 'd2i_EC_PUBKEY_fp': Function(type='EC_KEY', derefcnt=1, name='d2i_EC_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=2, name='eckey')]),
 'd2i_NETSCAPE_CERT_SEQUENCE': Function(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='d2i_NETSCAPE_CERT_SEQUENCE', args=[Argument(type='NETSCAPE_CERT_SEQUENCE', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_NETSCAPE_SPKAC': Function(type='NETSCAPE_SPKAC', derefcnt=1, name='d2i_NETSCAPE_SPKAC', args=[Argument(type='NETSCAPE_SPKAC', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_NETSCAPE_SPKI': Function(type='NETSCAPE_SPKI', derefcnt=1, name='d2i_NETSCAPE_SPKI', args=[Argument(type='NETSCAPE_SPKI', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_NETSCAPE_X509': Function(type='NETSCAPE_X509', derefcnt=1, name='d2i_NETSCAPE_X509', args=[Argument(type='NETSCAPE_X509', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_Netscape_RSA': Function(type='RSA', derefcnt=1, name='d2i_Netscape_RSA', args=[Argument(type='RSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='cb')]),
 'd2i_PBE2PARAM': Function(type='PBE2PARAM', derefcnt=1, name='d2i_PBE2PARAM', args=[Argument(type='PBE2PARAM', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PBEPARAM': Function(type='PBEPARAM', derefcnt=1, name='d2i_PBEPARAM', args=[Argument(type='PBEPARAM', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PBKDF2PARAM': Function(type='PBKDF2PARAM', derefcnt=1, name='d2i_PBKDF2PARAM', args=[Argument(type='PBKDF2PARAM', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7': Function(type='PKCS7', derefcnt=1, name='d2i_PKCS7', args=[Argument(type='PKCS7', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_DIGEST': Function(type='PKCS7_DIGEST', derefcnt=1, name='d2i_PKCS7_DIGEST', args=[Argument(type='PKCS7_DIGEST', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_ENCRYPT': Function(type='PKCS7_ENCRYPT', derefcnt=1, name='d2i_PKCS7_ENCRYPT', args=[Argument(type='PKCS7_ENCRYPT', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_ENC_CONTENT': Function(type='PKCS7_ENC_CONTENT', derefcnt=1, name='d2i_PKCS7_ENC_CONTENT', args=[Argument(type='PKCS7_ENC_CONTENT', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_ENVELOPE': Function(type='PKCS7_ENVELOPE', derefcnt=1, name='d2i_PKCS7_ENVELOPE', args=[Argument(type='PKCS7_ENVELOPE', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_ISSUER_AND_SERIAL': Function(type='PKCS7_ISSUER_AND_SERIAL', derefcnt=1, name='d2i_PKCS7_ISSUER_AND_SERIAL', args=[Argument(type='PKCS7_ISSUER_AND_SERIAL', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_RECIP_INFO': Function(type='PKCS7_RECIP_INFO', derefcnt=1, name='d2i_PKCS7_RECIP_INFO', args=[Argument(type='PKCS7_RECIP_INFO', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_SIGNED': Function(type='PKCS7_SIGNED', derefcnt=1, name='d2i_PKCS7_SIGNED', args=[Argument(type='PKCS7_SIGNED', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_SIGNER_INFO': Function(type='PKCS7_SIGNER_INFO', derefcnt=1, name='d2i_PKCS7_SIGNER_INFO', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_SIGN_ENVELOPE': Function(type='PKCS7_SIGN_ENVELOPE', derefcnt=1, name='d2i_PKCS7_SIGN_ENVELOPE', args=[Argument(type='PKCS7_SIGN_ENVELOPE', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS7_bio': Function(type='PKCS7', derefcnt=1, name='d2i_PKCS7_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS7', derefcnt=2, name='p7')]),
 'd2i_PKCS7_fp': Function(type='PKCS7', derefcnt=1, name='d2i_PKCS7_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS7', derefcnt=2, name='p7')]),
 'd2i_PKCS8PrivateKey_bio': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PKCS8PrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'd2i_PKCS8PrivateKey_fp': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PKCS8PrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=2, name='x'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'd2i_PKCS8_PRIV_KEY_INFO': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='d2i_PKCS8_PRIV_KEY_INFO', args=[Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_PKCS8_PRIV_KEY_INFO_bio': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='d2i_PKCS8_PRIV_KEY_INFO_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=2, name='p8inf')]),
 'd2i_PKCS8_PRIV_KEY_INFO_fp': Function(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='d2i_PKCS8_PRIV_KEY_INFO_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=2, name='p8inf')]),
 'd2i_PKCS8_bio': Function(type='X509_SIG', derefcnt=1, name='d2i_PKCS8_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_SIG', derefcnt=2, name='p8')]),
 'd2i_PKCS8_fp': Function(type='X509_SIG', derefcnt=1, name='d2i_PKCS8_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_SIG', derefcnt=2, name='p8')]),
 'd2i_PUBKEY': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PUBKEY', args=[Argument(type='EVP_PKEY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_PUBKEY_bio': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=2, name='a')]),
 'd2i_PUBKEY_fp': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=2, name='a')]),
 'd2i_PrivateKey': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PrivateKey', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='EVP_PKEY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_PrivateKey_bio': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=2, name='a')]),
 'd2i_PrivateKey_fp': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=2, name='a')]),
 'd2i_PublicKey': Function(type='EVP_PKEY', derefcnt=1, name='d2i_PublicKey', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='EVP_PKEY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_RSAPrivateKey': Function(type='RSA', derefcnt=1, name='d2i_RSAPrivateKey', args=[Argument(type='RSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_RSAPrivateKey_bio': Function(type='RSA', derefcnt=1, name='d2i_RSAPrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=2, name='rsa')]),
 'd2i_RSAPrivateKey_fp': Function(type='RSA', derefcnt=1, name='d2i_RSAPrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=2, name='rsa')]),
 'd2i_RSAPublicKey': Function(type='RSA', derefcnt=1, name='d2i_RSAPublicKey', args=[Argument(type='RSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_RSAPublicKey_bio': Function(type='RSA', derefcnt=1, name='d2i_RSAPublicKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=2, name='rsa')]),
 'd2i_RSAPublicKey_fp': Function(type='RSA', derefcnt=1, name='d2i_RSAPublicKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=2, name='rsa')]),
 'd2i_RSA_NET': Function(type='RSA', derefcnt=1, name='d2i_RSA_NET', args=[Argument(type='RSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='cb'), Argument(type='int', derefcnt=0, name='sgckey')]),
 'd2i_RSA_PSS_PARAMS': Function(type='RSA_PSS_PARAMS', derefcnt=1, name='d2i_RSA_PSS_PARAMS', args=[Argument(type='RSA_PSS_PARAMS', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_RSA_PUBKEY': Function(type='RSA', derefcnt=1, name='d2i_RSA_PUBKEY', args=[Argument(type='RSA', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_RSA_PUBKEY_bio': Function(type='RSA', derefcnt=1, name='d2i_RSA_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=2, name='rsa')]),
 'd2i_RSA_PUBKEY_fp': Function(type='RSA', derefcnt=1, name='d2i_RSA_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=2, name='rsa')]),
 'd2i_SSL_SESSION': Function(type='SSL_SESSION', derefcnt=1, name='d2i_SSL_SESSION', args=[Argument(type='SSL_SESSION', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_X509': Function(type='X509', derefcnt=1, name='d2i_X509', args=[Argument(type='X509', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_ALGOR': Function(type='X509_ALGOR', derefcnt=1, name='d2i_X509_ALGOR', args=[Argument(type='X509_ALGOR', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_ALGORS': Function(type='X509_ALGORS', derefcnt=1, name='d2i_X509_ALGORS', args=[Argument(type='X509_ALGORS', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_ATTRIBUTE': Function(type='X509_ATTRIBUTE', derefcnt=1, name='d2i_X509_ATTRIBUTE', args=[Argument(type='X509_ATTRIBUTE', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_AUX': Function(type='X509', derefcnt=1, name='d2i_X509_AUX', args=[Argument(type='X509', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_X509_CERT_AUX': Function(type='X509_CERT_AUX', derefcnt=1, name='d2i_X509_CERT_AUX', args=[Argument(type='X509_CERT_AUX', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_CERT_PAIR': Function(type='X509_CERT_PAIR', derefcnt=1, name='d2i_X509_CERT_PAIR', args=[Argument(type='X509_CERT_PAIR', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_CINF': Function(type='X509_CINF', derefcnt=1, name='d2i_X509_CINF', args=[Argument(type='X509_CINF', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_CRL': Function(type='X509_CRL', derefcnt=1, name='d2i_X509_CRL', args=[Argument(type='X509_CRL', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_CRL_INFO': Function(type='X509_CRL_INFO', derefcnt=1, name='d2i_X509_CRL_INFO', args=[Argument(type='X509_CRL_INFO', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_CRL_bio': Function(type='X509_CRL', derefcnt=1, name='d2i_X509_CRL_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CRL', derefcnt=2, name='crl')]),
 'd2i_X509_CRL_fp': Function(type='X509_CRL', derefcnt=1, name='d2i_X509_CRL_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_CRL', derefcnt=2, name='crl')]),
 'd2i_X509_EXTENSION': Function(type='X509_EXTENSION', derefcnt=1, name='d2i_X509_EXTENSION', args=[Argument(type='X509_EXTENSION', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_EXTENSIONS': Function(type='X509_EXTENSIONS', derefcnt=1, name='d2i_X509_EXTENSIONS', args=[Argument(type='X509_EXTENSIONS', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_NAME': Function(type='X509_NAME', derefcnt=1, name='d2i_X509_NAME', args=[Argument(type='X509_NAME', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_NAME_ENTRY': Function(type='X509_NAME_ENTRY', derefcnt=1, name='d2i_X509_NAME_ENTRY', args=[Argument(type='X509_NAME_ENTRY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_PKEY': Function(type='X509_PKEY', derefcnt=1, name='d2i_X509_PKEY', args=[Argument(type='X509_PKEY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='long', derefcnt=0, name='length')]),
 'd2i_X509_PUBKEY': Function(type='X509_PUBKEY', derefcnt=1, name='d2i_X509_PUBKEY', args=[Argument(type='X509_PUBKEY', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_REQ': Function(type='X509_REQ', derefcnt=1, name='d2i_X509_REQ', args=[Argument(type='X509_REQ', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_REQ_INFO': Function(type='X509_REQ_INFO', derefcnt=1, name='d2i_X509_REQ_INFO', args=[Argument(type='X509_REQ_INFO', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_REQ_bio': Function(type='X509_REQ', derefcnt=1, name='d2i_X509_REQ_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=2, name='req')]),
 'd2i_X509_REQ_fp': Function(type='X509_REQ', derefcnt=1, name='d2i_X509_REQ_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_REQ', derefcnt=2, name='req')]),
 'd2i_X509_REVOKED': Function(type='X509_REVOKED', derefcnt=1, name='d2i_X509_REVOKED', args=[Argument(type='X509_REVOKED', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_SIG': Function(type='X509_SIG', derefcnt=1, name='d2i_X509_SIG', args=[Argument(type='X509_SIG', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_VAL': Function(type='X509_VAL', derefcnt=1, name='d2i_X509_VAL', args=[Argument(type='X509_VAL', derefcnt=2, name='a'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'd2i_X509_bio': Function(type='X509', derefcnt=1, name='d2i_X509_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=2, name='x509')]),
 'd2i_X509_fp': Function(type='X509', derefcnt=1, name='d2i_X509_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509', derefcnt=2, name='x509')]),
 'd2i_of_void': Function(type='void', derefcnt=1, name='d2i_of_void', args=[Argument(type='void', derefcnt=2, name='arg0'), Argument(type='unsigned', derefcnt=2, name='arg1'), Argument(type='long', derefcnt=0, name='arg2')]),
 'daemon': Function(type='int', derefcnt=0, name='daemon', args=[Argument(type='int', derefcnt=0, name='nochdir'), Argument(type='int', derefcnt=0, name='noclose')]),
 'dcgettext': Function(type='char', derefcnt=1, name='dcgettext', args=[Argument(type='char', derefcnt=1, name='domainname'), Argument(type='char', derefcnt=1, name='msgid'), Argument(type='int', derefcnt=0, name='category')]),
 'dcngettext': Function(type='char', derefcnt=1, name='dcngettext', args=[Argument(type='char', derefcnt=1, name='domainname'), Argument(type='char', derefcnt=1, name='msgid1'), Argument(type='char', derefcnt=1, name='msgid2'), Argument(type='unsigned', derefcnt=0, name='n'), Argument(type='int', derefcnt=0, name='category')]),
 'default_morecore': Function(type='void', derefcnt=1, name='default_morecore', args=[Argument(type='ptrdiff_t', derefcnt=0, name='size')]),
 'default_verify_callback': Function(type='int', derefcnt=0, name='default_verify_callback', args=[Argument(type='int', derefcnt=0, name='ok'), Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'deflate': Function(type='int', derefcnt=0, name='deflate', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='flush')]),
 'deflateBound': Function(type='uLong', derefcnt=0, name='deflateBound', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='uLong', derefcnt=0, name='sourceLen')]),
 'deflateCopy': Function(type='int', derefcnt=0, name='deflateCopy', args=[Argument(type='z_streamp', derefcnt=0, name='dest'), Argument(type='z_streamp', derefcnt=0, name='source')]),
 'deflateEnd': Function(type='int', derefcnt=0, name='deflateEnd', args=[Argument(type='z_streamp', derefcnt=0, name='strm')]),
 'deflateInit2_': Function(type='int', derefcnt=0, name='deflateInit2_', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='level'), Argument(type='int', derefcnt=0, name='method'), Argument(type='int', derefcnt=0, name='windowBits'), Argument(type='int', derefcnt=0, name='memLevel'), Argument(type='int', derefcnt=0, name='strategy'), Argument(type='char', derefcnt=1, name='version'), Argument(type='int', derefcnt=0, name='stream_size')]),
 'deflateInit_': Function(type='int', derefcnt=0, name='deflateInit_', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='level'), Argument(type='char', derefcnt=1, name='version'), Argument(type='int', derefcnt=0, name='stream_size')]),
 'deflateParams': Function(type='int', derefcnt=0, name='deflateParams', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='level'), Argument(type='int', derefcnt=0, name='strategy')]),
 'deflatePending': Function(type='int', derefcnt=0, name='deflatePending', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='unsigned', derefcnt=1, name='pending'), Argument(type='int', derefcnt=1, name='bits')]),
 'deflatePrime': Function(type='int', derefcnt=0, name='deflatePrime', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='int', derefcnt=0, name='value')]),
 'deflateReset': Function(type='int', derefcnt=0, name='deflateReset', args=[Argument(type='z_streamp', derefcnt=0, name='strm')]),
 'deflateResetKeep': Function(type='int', derefcnt=0, name='deflateResetKeep', args=[Argument(type='z_streamp', derefcnt=0, name='arg0')]),
 'deflateSetDictionary': Function(type='int', derefcnt=0, name='deflateSetDictionary', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='Bytef', derefcnt=1, name='dictionary'), Argument(type='uInt', derefcnt=0, name='dictLength')]),
 'deflateSetHeader': Function(type='int', derefcnt=0, name='deflateSetHeader', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='gz_headerp', derefcnt=0, name='head')]),
 'deflateTune': Function(type='int', derefcnt=0, name='deflateTune', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='good_length'), Argument(type='int', derefcnt=0, name='max_lazy'), Argument(type='int', derefcnt=0, name='nice_length'), Argument(type='int', derefcnt=0, name='max_chain')]),
 'destroy': Function(type='int', derefcnt=0, name='destroy', args=[Argument(type='BIO', derefcnt=1, name='arg0')]),
 'dgettext': Function(type='char', derefcnt=1, name='dgettext', args=[Argument(type='char', derefcnt=1, name='domainname'), Argument(type='char', derefcnt=1, name='msgid')]),
 'difftime': Function(type='double', derefcnt=0, name='difftime', args=[Argument(type='time_t', derefcnt=0, name='time1'), Argument(type='time_t', derefcnt=0, name='time0')]),
 'dirfd': Function(type='int', derefcnt=0, name='dirfd', args=[Argument(type='DIR', derefcnt=1, name='dirp')]),
 'dirname': Function(type='char', derefcnt=1, name='dirname', args=[Argument(type='char', derefcnt=1, name='path')]),
 'div': Function(type='div_t', derefcnt=0, name='div', args=[Argument(type='int', derefcnt=0, name='numer'), Argument(type='int', derefcnt=0, name='denom')]),
 'dl_iterate_phdr': Function(type='int', derefcnt=0, name='dl_iterate_phdr', args=[Argument(type='int', derefcnt=0, name='callback'), Argument(type='void', derefcnt=1, name='data')]),
 'dl_mcount_wrapper_check': Function(type='void', derefcnt=0, name='dl_mcount_wrapper_check', args=[Argument(type='void', derefcnt=1, name='selfpc')]),
 'dladdr': Function(type='int', derefcnt=0, name='dladdr', args=[Argument(type='void', derefcnt=1, name='address'), Argument(type='Dl_info', derefcnt=1, name='info')]),
 'dladdr1': Function(type='int', derefcnt=0, name='dladdr1', args=[Argument(type='void', derefcnt=1, name='address'), Argument(type='Dl_info', derefcnt=1, name='info'), Argument(type='void', derefcnt=2, name='extra_info'), Argument(type='int', derefcnt=0, name='flags')]),
 'dlclose': Function(type='int', derefcnt=0, name='dlclose', args=[Argument(type='void', derefcnt=1, name='handle')]),
 'dlerror': Function(type='char', derefcnt=1, name='dlerror', args=[]),
 'dlinfo': Function(type='int', derefcnt=0, name='dlinfo', args=[Argument(type='void', derefcnt=1, name='handle'), Argument(type='int', derefcnt=0, name='request'), Argument(type='void', derefcnt=1, name='arg')]),
 'dlmopen': Function(type='void', derefcnt=1, name='dlmopen', args=[Argument(type='Lmid_t', derefcnt=0, name='nsid'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='mode')]),
 'dlopen': Function(type='void', derefcnt=1, name='dlopen', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='mode')]),
 'dlsym': Function(type='void', derefcnt=1, name='dlsym', args=[Argument(type='void', derefcnt=1, name='handle'), Argument(type='char', derefcnt=1, name='name')]),
 'dlvsym': Function(type='void', derefcnt=1, name='dlvsym', args=[Argument(type='void', derefcnt=1, name='handle'), Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='version')]),
 'dn_comp': Function(type='int', derefcnt=0, name='dn_comp', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='u_char', derefcnt=2, name='arg3'), Argument(type='u_char', derefcnt=2, name='arg4')]),
 'dn_count_labels': Function(type='int', derefcnt=0, name='dn_count_labels', args=[Argument(type='char', derefcnt=1, name='arg0')]),
 'dn_expand': Function(type='int', derefcnt=0, name='dn_expand', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='u_char', derefcnt=1, name='arg2'), Argument(type='char', derefcnt=1, name='arg3'), Argument(type='int', derefcnt=0, name='arg4')]),
 'dn_skipname': Function(type='int', derefcnt=0, name='dn_skipname', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1')]),
 'dngettext': Function(type='char', derefcnt=1, name='dngettext', args=[Argument(type='char', derefcnt=1, name='domainname'), Argument(type='char', derefcnt=1, name='msgid1'), Argument(type='char', derefcnt=1, name='msgid2'), Argument(type='unsigned', derefcnt=0, name='n')]),
 'do_cipher': Function(type='int', derefcnt=0, name='do_cipher', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='inl')]),
 'dprintf': Function(type='int', derefcnt=0, name='dprintf', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='int', derefcnt=0, name='vararg')]),
 'drand48': Function(type='double', derefcnt=0, name='drand48', args=[]),
 'drand48_r': Function(type='int', derefcnt=0, name='drand48_r', args=[Argument(type='drand48_data', derefcnt=1, name='buffer'), Argument(type='double', derefcnt=1, name='result')]),
 'drem': Function(type='double', derefcnt=0, name='drem', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'dremf': Function(type='float', derefcnt=0, name='dremf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'dreml': Function(type='long', derefcnt=0, name='dreml', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'dsa_do_sign': Function(type='DSA_SIG', derefcnt=1, name='dsa_do_sign', args=[Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dlen'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'dsa_do_verify': Function(type='int', derefcnt=0, name='dsa_do_verify', args=[Argument(type='unsigned', derefcnt=1, name='dgst'), Argument(type='int', derefcnt=0, name='dgst_len'), Argument(type='DSA_SIG', derefcnt=1, name='sig'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'dsa_keygen': Function(type='int', derefcnt=0, name='dsa_keygen', args=[Argument(type='DSA', derefcnt=1, name='dsa')]),
 'dsa_mod_exp': Function(type='int', derefcnt=0, name='dsa_mod_exp', args=[Argument(type='DSA', derefcnt=1, name='dsa'), Argument(type='BIGNUM', derefcnt=1, name='rr'), Argument(type='BIGNUM', derefcnt=1, name='a1'), Argument(type='BIGNUM', derefcnt=1, name='p1'), Argument(type='BIGNUM', derefcnt=1, name='a2'), Argument(type='BIGNUM', derefcnt=1, name='p2'), Argument(type='BIGNUM', derefcnt=1, name='m'), Argument(type='BN_CTX', derefcnt=1, name='ctx'), Argument(type='BN_MONT_CTX', derefcnt=1, name='in_mont')]),
 'dsa_paramgen': Function(type='int', derefcnt=0, name='dsa_paramgen', args=[Argument(type='DSA', derefcnt=1, name='dsa'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='unsigned', derefcnt=1, name='seed'), Argument(type='int', derefcnt=0, name='seed_len'), Argument(type='int', derefcnt=1, name='counter_ret'), Argument(type='unsigned', derefcnt=1, name='h_ret'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'dsa_sign_setup': Function(type='int', derefcnt=0, name='dsa_sign_setup', args=[Argument(type='DSA', derefcnt=1, name='dsa'), Argument(type='BN_CTX', derefcnt=1, name='ctx_in'), Argument(type='BIGNUM', derefcnt=2, name='kinvp'), Argument(type='BIGNUM', derefcnt=2, name='rp')]),
 'dup': Function(type='int', derefcnt=0, name='dup', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'dup2': Function(type='int', derefcnt=0, name='dup2', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='fd2')]),
 'dup3': Function(type='int', derefcnt=0, name='dup3', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='fd2'), Argument(type='int', derefcnt=0, name='flags')]),
 'duplocale': Function(type='locale_t', derefcnt=0, name='duplocale', args=[Argument(type='locale_t', derefcnt=0, name='dataset')]),
 'dysize': Function(type='int', derefcnt=0, name='dysize', args=[Argument(type='int', derefcnt=0, name='year')]),
 'eaccess': Function(type='int', derefcnt=0, name='eaccess', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='type')]),
 'ecvt': Function(type='char', derefcnt=1, name='ecvt', args=[Argument(type='double', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign')]),
 'ecvt_r': Function(type='int', derefcnt=0, name='ecvt_r', args=[Argument(type='double', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len')]),
 'encrypt': Function(type='void', derefcnt=0, name='encrypt', args=[Argument(type='char', derefcnt=1, name='glibc_block'), Argument(type='int', derefcnt=0, name='edflag')]),
 'encrypt_r': Function(type='void', derefcnt=0, name='encrypt_r', args=[Argument(type='char', derefcnt=1, name='glibc_block'), Argument(type='int', derefcnt=0, name='edflag'), Argument(type='crypt_data', derefcnt=1, name='data')]),
 'endaliasent': Function(type='void', derefcnt=0, name='endaliasent', args=[]),
 'endfsent': Function(type='void', derefcnt=0, name='endfsent', args=[]),
 'endgrent': Function(type='void', derefcnt=0, name='endgrent', args=[]),
 'endhostent': Function(type='void', derefcnt=0, name='endhostent', args=[]),
 'endmntent': Function(type='int', derefcnt=0, name='endmntent', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'endnetent': Function(type='void', derefcnt=0, name='endnetent', args=[]),
 'endnetgrent': Function(type='void', derefcnt=0, name='endnetgrent', args=[]),
 'endprotoent': Function(type='void', derefcnt=0, name='endprotoent', args=[]),
 'endpwent': Function(type='void', derefcnt=0, name='endpwent', args=[]),
 'endrpcent': Function(type='void', derefcnt=0, name='endrpcent', args=[]),
 'endservent': Function(type='void', derefcnt=0, name='endservent', args=[]),
 'endsgent': Function(type='void', derefcnt=0, name='endsgent', args=[]),
 'endspent': Function(type='void', derefcnt=0, name='endspent', args=[]),
 'endttyent': Function(type='int', derefcnt=0, name='endttyent', args=[]),
 'endusershell': Function(type='void', derefcnt=0, name='endusershell', args=[]),
 'endutent': Function(type='void', derefcnt=0, name='endutent', args=[]),
 'endutxent': Function(type='void', derefcnt=0, name='endutxent', args=[]),
 'envz_add': Function(type='error_t', derefcnt=0, name='envz_add', args=[Argument(type='char', derefcnt=2, name='envz'), Argument(type='size_t', derefcnt=1, name='envz_len'), Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='value')]),
 'envz_entry': Function(type='char', derefcnt=1, name='envz_entry', args=[Argument(type='char', derefcnt=1, name='envz'), Argument(type='size_t', derefcnt=0, name='envz_len'), Argument(type='char', derefcnt=1, name='name')]),
 'envz_get': Function(type='char', derefcnt=1, name='envz_get', args=[Argument(type='char', derefcnt=1, name='envz'), Argument(type='size_t', derefcnt=0, name='envz_len'), Argument(type='char', derefcnt=1, name='name')]),
 'envz_merge': Function(type='error_t', derefcnt=0, name='envz_merge', args=[Argument(type='char', derefcnt=2, name='envz'), Argument(type='size_t', derefcnt=1, name='envz_len'), Argument(type='char', derefcnt=1, name='envz2'), Argument(type='size_t', derefcnt=0, name='envz2_len'), Argument(type='int', derefcnt=0, name='override')]),
 'envz_remove': Function(type='void', derefcnt=0, name='envz_remove', args=[Argument(type='char', derefcnt=2, name='envz'), Argument(type='size_t', derefcnt=1, name='envz_len'), Argument(type='char', derefcnt=1, name='name')]),
 'envz_strip': Function(type='void', derefcnt=0, name='envz_strip', args=[Argument(type='char', derefcnt=2, name='envz'), Argument(type='size_t', derefcnt=1, name='envz_len')]),
 'epoll_create': Function(type='int', derefcnt=0, name='epoll_create', args=[Argument(type='int', derefcnt=0, name='size')]),
 'epoll_create1': Function(type='int', derefcnt=0, name='epoll_create1', args=[Argument(type='int', derefcnt=0, name='flags')]),
 'epoll_ctl': Function(type='int', derefcnt=0, name='epoll_ctl', args=[Argument(type='int', derefcnt=0, name='epfd'), Argument(type='int', derefcnt=0, name='op'), Argument(type='int', derefcnt=0, name='fd'), Argument(type='epoll_event', derefcnt=1, name='event')]),
 'epoll_pwait': Function(type='int', derefcnt=0, name='epoll_pwait', args=[Argument(type='int', derefcnt=0, name='epfd'), Argument(type='epoll_event', derefcnt=1, name='events'), Argument(type='int', derefcnt=0, name='maxevents'), Argument(type='int', derefcnt=0, name='timeout'), Argument(type='sigset_t', derefcnt=1, name='ss')]),
 'epoll_wait': Function(type='int', derefcnt=0, name='epoll_wait', args=[Argument(type='int', derefcnt=0, name='epfd'), Argument(type='epoll_event', derefcnt=1, name='events'), Argument(type='int', derefcnt=0, name='maxevents'), Argument(type='int', derefcnt=0, name='timeout')]),
 'erand48': Function(type='double', derefcnt=0, name='erand48', args=[Argument(type='unsigned', derefcnt=1, name='xsubi')]),
 'erand48_r': Function(type='int', derefcnt=0, name='erand48_r', args=[Argument(type='unsigned', derefcnt=1, name='xsubi'), Argument(type='drand48_data', derefcnt=1, name='buffer'), Argument(type='double', derefcnt=1, name='result')]),
 'erf': Function(type='double', derefcnt=0, name='erf', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'erfc': Function(type='double', derefcnt=0, name='erfc', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'erfcf': Function(type='float', derefcnt=0, name='erfcf', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'erfcl': Function(type='long', derefcnt=0, name='erfcl', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'erff': Function(type='float', derefcnt=0, name='erff', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'erfl': Function(type='long', derefcnt=0, name='erfl', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'err': Function(type='void', derefcnt=0, name='err', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'errno_location': Function(type='int', derefcnt=1, name='errno_location', args=[]),
 'error': Function(type='void', derefcnt=0, name='error', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'error_alias': Function(type='void', derefcnt=0, name='error_alias', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'error_at_line': Function(type='void', derefcnt=0, name='error_at_line', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='fname'), Argument(type='unsigned', derefcnt=0, name='line'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'error_at_line_alias': Function(type='void', derefcnt=0, name='error_at_line_alias', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='fname'), Argument(type='unsigned', derefcnt=0, name='line'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'error_at_line_noreturn': Function(type='void', derefcnt=0, name='error_at_line_noreturn', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='fname'), Argument(type='unsigned', derefcnt=0, name='line'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'error_noreturn': Function(type='void', derefcnt=0, name='error_noreturn', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'error_print_progname': Function(type='void', derefcnt=0, name='error_print_progname', args=[]),
 'errx': Function(type='void', derefcnt=0, name='errx', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'euidaccess': Function(type='int', derefcnt=0, name='euidaccess', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='type')]),
 'evp_sign_method': Function(type='int', derefcnt=0, name='evp_sign_method', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigret'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='void', derefcnt=1, name='key')]),
 'evp_verify_method': Function(type='int', derefcnt=0, name='evp_verify_method', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigbuf'), Argument(type='unsigned', derefcnt=0, name='siglen'), Argument(type='void', derefcnt=1, name='key')]),
 'execl': Function(type='int', derefcnt=0, name='execl', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='char', derefcnt=1, name='arg'), Argument(type='int', derefcnt=0, name='vararg')]),
 'execle': Function(type='int', derefcnt=0, name='execle', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='char', derefcnt=1, name='arg'), Argument(type='int', derefcnt=0, name='vararg')]),
 'execlp': Function(type='int', derefcnt=0, name='execlp', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='char', derefcnt=1, name='arg'), Argument(type='int', derefcnt=0, name='vararg')]),
 'execv': Function(type='int', derefcnt=0, name='execv', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='char', derefcnt=2, name='argv')]),
 'execve': Function(type='int', derefcnt=0, name='execve', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=2, name='envp')]),
 'execvp': Function(type='int', derefcnt=0, name='execvp', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='char', derefcnt=2, name='argv')]),
 'execvpe': Function(type='int', derefcnt=0, name='execvpe', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=2, name='envp')]),
 'exit': Function(type='void', derefcnt=0, name='exit', args=[Argument(type='int', derefcnt=0, name='status')]),
 'exp': Function(type='double', derefcnt=0, name='exp', args=[Argument(type='double', derefcnt=0, name='x')]),
 'exp10': Function(type='double', derefcnt=0, name='exp10', args=[Argument(type='double', derefcnt=0, name='x')]),
 'exp10f': Function(type='float', derefcnt=0, name='exp10f', args=[Argument(type='float', derefcnt=0, name='x')]),
 'exp10l': Function(type='long', derefcnt=0, name='exp10l', args=[Argument(type='long', derefcnt=0, name='x')]),
 'exp2': Function(type='double', derefcnt=0, name='exp2', args=[Argument(type='double', derefcnt=0, name='x')]),
 'exp2f': Function(type='float', derefcnt=0, name='exp2f', args=[Argument(type='float', derefcnt=0, name='x')]),
 'exp2l': Function(type='long', derefcnt=0, name='exp2l', args=[Argument(type='long', derefcnt=0, name='x')]),
 'expand': Function(type='int', derefcnt=0, name='expand', args=[Argument(type='COMP_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='out'), Argument(type='unsigned', derefcnt=0, name='olen'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='unsigned', derefcnt=0, name='ilen')]),
 'expf': Function(type='float', derefcnt=0, name='expf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'expl': Function(type='long', derefcnt=0, name='expl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'expm1': Function(type='double', derefcnt=0, name='expm1', args=[Argument(type='double', derefcnt=0, name='x')]),
 'expm1f': Function(type='float', derefcnt=0, name='expm1f', args=[Argument(type='float', derefcnt=0, name='x')]),
 'expm1l': Function(type='long', derefcnt=0, name='expm1l', args=[Argument(type='long', derefcnt=0, name='x')]),
 'fabs': Function(type='double', derefcnt=0, name='fabs', args=[Argument(type='double', derefcnt=0, name='x')]),
 'fabsf': Function(type='float', derefcnt=0, name='fabsf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'fabsl': Function(type='long', derefcnt=0, name='fabsl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'faccessat': Function(type='int', derefcnt=0, name='faccessat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='flag')]),
 'fallocate': Function(type='int', derefcnt=0, name='fallocate', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='mode'), Argument(type='off_t', derefcnt=0, name='offset'), Argument(type='off_t', derefcnt=0, name='len')]),
 'fallocate64': Function(type='int', derefcnt=0, name='fallocate64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='mode'), Argument(type='off64_t', derefcnt=0, name='offset'), Argument(type='off64_t', derefcnt=0, name='len')]),
 'fattach': Function(type='int', derefcnt=0, name='fattach', args=[Argument(type='int', derefcnt=0, name='fildes'), Argument(type='char', derefcnt=1, name='path')]),
 'fbufsize': Function(type='size_t', derefcnt=0, name='fbufsize', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'fchdir': Function(type='int', derefcnt=0, name='fchdir', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'fchmod': Function(type='int', derefcnt=0, name='fchmod', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'fchmodat': Function(type='int', derefcnt=0, name='fchmodat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='mode_t', derefcnt=0, name='mode'), Argument(type='int', derefcnt=0, name='flag')]),
 'fchown': Function(type='int', derefcnt=0, name='fchown', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='uid_t', derefcnt=0, name='owner'), Argument(type='gid_t', derefcnt=0, name='group')]),
 'fchownat': Function(type='int', derefcnt=0, name='fchownat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='uid_t', derefcnt=0, name='owner'), Argument(type='gid_t', derefcnt=0, name='group'), Argument(type='int', derefcnt=0, name='flag')]),
 'fclose': Function(type='int', derefcnt=0, name='fclose', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fcloseall': Function(type='int', derefcnt=0, name='fcloseall', args=[]),
 'fcntl': Function(type='int', derefcnt=0, name='fcntl', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='int', derefcnt=0, name='vararg')]),
 'fcvt': Function(type='char', derefcnt=1, name='fcvt', args=[Argument(type='double', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign')]),
 'fcvt_r': Function(type='int', derefcnt=0, name='fcvt_r', args=[Argument(type='double', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len')]),
 'fdatasync': Function(type='int', derefcnt=0, name='fdatasync', args=[Argument(type='int', derefcnt=0, name='fildes')]),
 'fdetach': Function(type='int', derefcnt=0, name='fdetach', args=[Argument(type='char', derefcnt=1, name='path')]),
 'fdim': Function(type='double', derefcnt=0, name='fdim', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'fdimf': Function(type='float', derefcnt=0, name='fdimf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'fdiml': Function(type='long', derefcnt=0, name='fdiml', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'fdopen': Function(type='FILE', derefcnt=1, name='fdopen', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='modes')]),
 'fdopendir': Function(type='DIR', derefcnt=1, name='fdopendir', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'feclearexcept': Function(type='int', derefcnt=0, name='feclearexcept', args=[Argument(type='int', derefcnt=0, name='excepts')]),
 'fedisableexcept': Function(type='int', derefcnt=0, name='fedisableexcept', args=[Argument(type='int', derefcnt=0, name='excepts')]),
 'feenableexcept': Function(type='int', derefcnt=0, name='feenableexcept', args=[Argument(type='int', derefcnt=0, name='excepts')]),
 'fegetenv': Function(type='int', derefcnt=0, name='fegetenv', args=[Argument(type='fenv_t', derefcnt=1, name='envp')]),
 'fegetexcept': Function(type='int', derefcnt=0, name='fegetexcept', args=[]),
 'fegetexceptflag': Function(type='int', derefcnt=0, name='fegetexceptflag', args=[Argument(type='fexcept_t', derefcnt=1, name='flagp'), Argument(type='int', derefcnt=0, name='excepts')]),
 'fegetround': Function(type='int', derefcnt=0, name='fegetround', args=[]),
 'feholdexcept': Function(type='int', derefcnt=0, name='feholdexcept', args=[Argument(type='fenv_t', derefcnt=1, name='envp')]),
 'feof': Function(type='int', derefcnt=0, name='feof', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'feof_unlocked': Function(type='int', derefcnt=0, name='feof_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'feraiseexcept': Function(type='int', derefcnt=0, name='feraiseexcept', args=[Argument(type='int', derefcnt=0, name='excepts')]),
 'ferror': Function(type='int', derefcnt=0, name='ferror', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'ferror_unlocked': Function(type='int', derefcnt=0, name='ferror_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fesetenv': Function(type='int', derefcnt=0, name='fesetenv', args=[Argument(type='fenv_t', derefcnt=1, name='envp')]),
 'fesetexceptflag': Function(type='int', derefcnt=0, name='fesetexceptflag', args=[Argument(type='fexcept_t', derefcnt=1, name='flagp'), Argument(type='int', derefcnt=0, name='excepts')]),
 'fesetround': Function(type='int', derefcnt=0, name='fesetround', args=[Argument(type='int', derefcnt=0, name='rounding_direction')]),
 'fetestexcept': Function(type='int', derefcnt=0, name='fetestexcept', args=[Argument(type='int', derefcnt=0, name='excepts')]),
 'feupdateenv': Function(type='int', derefcnt=0, name='feupdateenv', args=[Argument(type='fenv_t', derefcnt=1, name='envp')]),
 'fexecve': Function(type='int', derefcnt=0, name='fexecve', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=2, name='envp')]),
 'fflush': Function(type='int', derefcnt=0, name='fflush', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fflush_unlocked': Function(type='int', derefcnt=0, name='fflush_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'ffs': Function(type='int', derefcnt=0, name='ffs', args=[Argument(type='int', derefcnt=0, name='i')]),
 'ffsl': Function(type='int', derefcnt=0, name='ffsl', args=[Argument(type='long', derefcnt=0, name='l')]),
 'ffsll': Function(type='int', derefcnt=0, name='ffsll', args=[Argument(type='long', derefcnt=0, name='ll')]),
 'fgetc': Function(type='int', derefcnt=0, name='fgetc', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetc_unlocked': Function(type='int', derefcnt=0, name='fgetc_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetgrent': Function(type='group', derefcnt=1, name='fgetgrent', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetgrent_r': Function(type='int', derefcnt=0, name='fgetgrent_r', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='group', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='group', derefcnt=2, name='result')]),
 'fgetpos': Function(type='int', derefcnt=0, name='fgetpos', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='fpos_t', derefcnt=1, name='pos')]),
 'fgetpos64': Function(type='int', derefcnt=0, name='fgetpos64', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='fpos64_t', derefcnt=1, name='pos')]),
 'fgetpwent': Function(type='passwd', derefcnt=1, name='fgetpwent', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetpwent_r': Function(type='int', derefcnt=0, name='fgetpwent_r', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='passwd', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='passwd', derefcnt=2, name='result')]),
 'fgets': Function(type='char', derefcnt=1, name='fgets', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgets_unlocked': Function(type='char', derefcnt=1, name='fgets_unlocked', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetsgent': Function(type='sgrp', derefcnt=1, name='fgetsgent', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetsgent_r': Function(type='int', derefcnt=0, name='fgetsgent_r', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='sgrp', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='sgrp', derefcnt=2, name='result')]),
 'fgetspent': Function(type='spwd', derefcnt=1, name='fgetspent', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetspent_r': Function(type='int', derefcnt=0, name='fgetspent_r', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='spwd', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='spwd', derefcnt=2, name='result')]),
 'fgetwc': Function(type='wint_t', derefcnt=0, name='fgetwc', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetwc_unlocked': Function(type='wint_t', derefcnt=0, name='fgetwc_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetws': Function(type='wchar_t', derefcnt=1, name='fgetws', args=[Argument(type='wchar_t', derefcnt=1, name='ws'), Argument(type='int', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fgetws_unlocked': Function(type='wchar_t', derefcnt=1, name='fgetws_unlocked', args=[Argument(type='wchar_t', derefcnt=1, name='ws'), Argument(type='int', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fileno': Function(type='int', derefcnt=0, name='fileno', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fileno_unlocked': Function(type='int', derefcnt=0, name='fileno_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'final': Function(type='int', derefcnt=0, name='final', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='unsigned', derefcnt=1, name='md')]),
 'finish': Function(type='int', derefcnt=0, name='finish', args=[Argument(type='DSA', derefcnt=1, name='dsa')]),
 'finite': Function(type='int', derefcnt=0, name='finite', args=[Argument(type='double', derefcnt=0, name='value')]),
 'finitef': Function(type='int', derefcnt=0, name='finitef', args=[Argument(type='float', derefcnt=0, name='value')]),
 'finitel': Function(type='int', derefcnt=0, name='finitel', args=[Argument(type='long', derefcnt=0, name='value')]),
 'flbf': Function(type='int', derefcnt=0, name='flbf', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'flock': Function(type='int', derefcnt=0, name='flock', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='operation')]),
 'flockfile': Function(type='void', derefcnt=0, name='flockfile', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'floor': Function(type='double', derefcnt=0, name='floor', args=[Argument(type='double', derefcnt=0, name='x')]),
 'floorf': Function(type='float', derefcnt=0, name='floorf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'floorl': Function(type='long', derefcnt=0, name='floorl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'flushlbf': Function(type='void', derefcnt=0, name='flushlbf', args=[]),
 'fma': Function(type='double', derefcnt=0, name='fma', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y'), Argument(type='double', derefcnt=0, name='z')]),
 'fmaf': Function(type='float', derefcnt=0, name='fmaf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y'), Argument(type='float', derefcnt=0, name='z')]),
 'fmal': Function(type='long', derefcnt=0, name='fmal', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y'), Argument(type='long', derefcnt=0, name='z')]),
 'fmax': Function(type='double', derefcnt=0, name='fmax', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'fmaxf': Function(type='float', derefcnt=0, name='fmaxf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'fmaxl': Function(type='long', derefcnt=0, name='fmaxl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'fmemopen': Function(type='FILE', derefcnt=1, name='fmemopen', args=[Argument(type='void', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='char', derefcnt=1, name='modes')]),
 'fmin': Function(type='double', derefcnt=0, name='fmin', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'fminf': Function(type='float', derefcnt=0, name='fminf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'fminl': Function(type='long', derefcnt=0, name='fminl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'fmod': Function(type='double', derefcnt=0, name='fmod', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'fmodf': Function(type='float', derefcnt=0, name='fmodf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'fmodl': Function(type='long', derefcnt=0, name='fmodl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'fmtmsg': Function(type='int', derefcnt=0, name='fmtmsg', args=[Argument(type='long', derefcnt=0, name='classification'), Argument(type='char', derefcnt=1, name='label'), Argument(type='int', derefcnt=0, name='severity'), Argument(type='char', derefcnt=1, name='text'), Argument(type='char', derefcnt=1, name='action'), Argument(type='char', derefcnt=1, name='tag')]),
 'fnmatch': Function(type='int', derefcnt=0, name='fnmatch', args=[Argument(type='char', derefcnt=1, name='pattern'), Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='flags')]),
 'fopen': Function(type='FILE', derefcnt=1, name='fopen', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='char', derefcnt=1, name='modes')]),
 'fopen64': Function(type='FILE', derefcnt=1, name='fopen64', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='char', derefcnt=1, name='modes')]),
 'fopencookie': Function(type='FILE', derefcnt=1, name='fopencookie', args=[Argument(type='void', derefcnt=1, name='magic_cookie'), Argument(type='char', derefcnt=1, name='modes'), Argument(type='IO_cookie_io_functions_t', derefcnt=0, name='io_funcs')]),
 'fork': Function(type='pid_t', derefcnt=0, name='fork', args=[]),
 'forkpty': Function(type='int', derefcnt=0, name='forkpty', args=[Argument(type='int', derefcnt=1, name='amaster'), Argument(type='char', derefcnt=1, name='name'), Argument(type='termios', derefcnt=1, name='termp'), Argument(type='winsize', derefcnt=1, name='winp')]),
 'fp_nquery': Function(type='void', derefcnt=0, name='fp_nquery', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='FILE', derefcnt=1, name='arg2')]),
 'fp_query': Function(type='void', derefcnt=0, name='fp_query', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='FILE', derefcnt=1, name='arg1')]),
 'fp_resstat': Function(type='void', derefcnt=0, name='fp_resstat', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='FILE', derefcnt=1, name='arg1')]),
 'fpathconf': Function(type='long', derefcnt=0, name='fpathconf', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='name')]),
 'fpclassify': Function(type='int', derefcnt=0, name='fpclassify', args=[Argument(type='double', derefcnt=0, name='value')]),
 'fpclassifyf': Function(type='int', derefcnt=0, name='fpclassifyf', args=[Argument(type='float', derefcnt=0, name='value')]),
 'fpclassifyl': Function(type='int', derefcnt=0, name='fpclassifyl', args=[Argument(type='long', derefcnt=0, name='value')]),
 'fpending': Function(type='size_t', derefcnt=0, name='fpending', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'fprintf': Function(type='int', derefcnt=0, name='fprintf', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'fpurge': Function(type='void', derefcnt=0, name='fpurge', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'fputc': Function(type='int', derefcnt=0, name='fputc', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fputc_unlocked': Function(type='int', derefcnt=0, name='fputc_unlocked', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fputs': Function(type='int', derefcnt=0, name='fputs', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fputs_unlocked': Function(type='int', derefcnt=0, name='fputs_unlocked', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fputwc': Function(type='wint_t', derefcnt=0, name='fputwc', args=[Argument(type='wchar_t', derefcnt=0, name='wc'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fputwc_unlocked': Function(type='wint_t', derefcnt=0, name='fputwc_unlocked', args=[Argument(type='wchar_t', derefcnt=0, name='wc'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fputws': Function(type='int', derefcnt=0, name='fputws', args=[Argument(type='wchar_t', derefcnt=1, name='ws'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fputws_unlocked': Function(type='int', derefcnt=0, name='fputws_unlocked', args=[Argument(type='wchar_t', derefcnt=1, name='ws'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fread': Function(type='size_t', derefcnt=0, name='fread', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 '__fread_chk': Function(type='size_t', derefcnt=0, name='__fread_chk', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='ptrlen'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fread_unlocked': Function(type='size_t', derefcnt=0, name='fread_unlocked', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'freadable': Function(type='int', derefcnt=0, name='freadable', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'freading': Function(type='int', derefcnt=0, name='freading', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'free': Function(type='void', derefcnt=0, name='free', args=[Argument(type='void', derefcnt=1, name='ptr')]),
 'free_fn_t': Function(type='void', derefcnt=0, name='free_fn_t', args=[Argument(type='void', derefcnt=1, name='nodep')]),
 'free_func': Function(type='void', derefcnt=0, name='free_func', args=[Argument(type='voidpf', derefcnt=0, name='opaque'), Argument(type='voidpf', derefcnt=0, name='address')]),
 'free_hook': Function(type='void', derefcnt=0, name='free_hook', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='void', derefcnt=1, name='arg1')]),
 'freeaddrinfo': Function(type='void', derefcnt=0, name='freeaddrinfo', args=[Argument(type='addrinfo', derefcnt=1, name='ai')]),
 'freefun': Function(type='void', derefcnt=0, name='freefun', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='obstack_chunk', derefcnt=1, name='arg1')]),
 'freeifaddrs': Function(type='void', derefcnt=0, name='freeifaddrs', args=[Argument(type='ifaddrs', derefcnt=1, name='ifa')]),
 'freelocale': Function(type='void', derefcnt=0, name='freelocale', args=[Argument(type='locale_t', derefcnt=0, name='dataset')]),
 'freopen': Function(type='FILE', derefcnt=1, name='freopen', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='char', derefcnt=1, name='modes'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'freopen64': Function(type='FILE', derefcnt=1, name='freopen64', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='char', derefcnt=1, name='modes'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'frexp': Function(type='double', derefcnt=0, name='frexp', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='int', derefcnt=1, name='exponent')]),
 'frexpf': Function(type='float', derefcnt=0, name='frexpf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='int', derefcnt=1, name='exponent')]),
 'frexpl': Function(type='long', derefcnt=0, name='frexpl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='int', derefcnt=1, name='exponent')]),
 'fscanf': Function(type='int', derefcnt=0, name='fscanf', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'fseek': Function(type='int', derefcnt=0, name='fseek', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='long', derefcnt=0, name='off'), Argument(type='int', derefcnt=0, name='whence')]),
 'fseeko': Function(type='int', derefcnt=0, name='fseeko', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='off_t', derefcnt=0, name='off'), Argument(type='int', derefcnt=0, name='whence')]),
 'fseeko64': Function(type='int', derefcnt=0, name='fseeko64', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='off64_t', derefcnt=0, name='off'), Argument(type='int', derefcnt=0, name='whence')]),
 'fsetlocking': Function(type='int', derefcnt=0, name='fsetlocking', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='int', derefcnt=0, name='type')]),
 'fsetpos': Function(type='int', derefcnt=0, name='fsetpos', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='fpos_t', derefcnt=1, name='pos')]),
 'fsetpos64': Function(type='int', derefcnt=0, name='fsetpos64', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='fpos64_t', derefcnt=1, name='pos')]),
 'fstat': Function(type='int', derefcnt=0, name='fstat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='stat', derefcnt=1, name='buf')]),
 'fstat64': Function(type='int', derefcnt=0, name='fstat64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='stat64', derefcnt=1, name='buf')]),
 'fstatat': Function(type='int', derefcnt=0, name='fstatat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='stat', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='flag')]),
 'fstatat64': Function(type='int', derefcnt=0, name='fstatat64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='stat64', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='flag')]),
 'fsync': Function(type='int', derefcnt=0, name='fsync', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'ftell': Function(type='long', derefcnt=0, name='ftell', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'ftello': Function(type='off_t', derefcnt=0, name='ftello', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'ftello64': Function(type='off64_t', derefcnt=0, name='ftello64', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'ftok': Function(type='key_t', derefcnt=0, name='ftok', args=[Argument(type='char', derefcnt=1, name='pathname'), Argument(type='int', derefcnt=0, name='proj_id')]),
 'ftruncate': Function(type='int', derefcnt=0, name='ftruncate', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off_t', derefcnt=0, name='length')]),
 'ftruncate64': Function(type='int', derefcnt=0, name='ftruncate64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off64_t', derefcnt=0, name='length')]),
 'ftrylockfile': Function(type='int', derefcnt=0, name='ftrylockfile', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'fts_children': Function(type='FTSENT', derefcnt=1, name='fts_children', args=[Argument(type='FTS', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'fts_close': Function(type='int', derefcnt=0, name='fts_close', args=[Argument(type='FTS', derefcnt=1, name='arg0')]),
 'fts_compar': Function(type='int', derefcnt=0, name='fts_compar', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'fts_open': Function(type='FTS', derefcnt=1, name='fts_open', args=[Argument(type='char', derefcnt=2, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='')]),
 'fts_read': Function(type='FTSENT', derefcnt=1, name='fts_read', args=[Argument(type='FTS', derefcnt=1, name='arg0')]),
 'fts_set': Function(type='int', derefcnt=0, name='fts_set', args=[Argument(type='FTS', derefcnt=1, name='arg0'), Argument(type='FTSENT', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'ftw': Function(type='int', derefcnt=0, name='ftw', args=[Argument(type='char', derefcnt=1, name='dir'), Argument(type='ftw_func_t', derefcnt=0, name='func'), Argument(type='int', derefcnt=0, name='descriptors')]),
 'ftw64': Function(type='int', derefcnt=0, name='ftw64', args=[Argument(type='char', derefcnt=1, name='dir'), Argument(type='ftw64_func_t', derefcnt=0, name='func'), Argument(type='int', derefcnt=0, name='descriptors')]),
 'ftw64_func_t': Function(type='int', derefcnt=0, name='ftw64_func_t', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat64', derefcnt=1, name='status'), Argument(type='int', derefcnt=0, name='flag')]),
 'ftw_func_t': Function(type='int', derefcnt=0, name='ftw_func_t', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat', derefcnt=1, name='status'), Argument(type='int', derefcnt=0, name='flag')]),
 'function': Function(type='void', derefcnt=0, name='function', args=[Argument(type='sigval_t', derefcnt=0, name='arg0')]),
 'funlockfile': Function(type='void', derefcnt=0, name='funlockfile', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'futimens': Function(type='int', derefcnt=0, name='futimens', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='timespec', derefcnt=1, name='times')]),
 'futimes': Function(type='int', derefcnt=0, name='futimes', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='timeval', derefcnt=1, name='tvp')]),
 'futimesat': Function(type='int', derefcnt=0, name='futimesat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='timeval', derefcnt=1, name='tvp')]),
 'fwide': Function(type='int', derefcnt=0, name='fwide', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='int', derefcnt=0, name='mode')]),
 'fwprintf': Function(type='int', derefcnt=0, name='fwprintf', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'fwritable': Function(type='int', derefcnt=0, name='fwritable', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'fwrite': Function(type='size_t', derefcnt=0, name='fwrite', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='s')]),
 'fwrite_unlocked': Function(type='size_t', derefcnt=0, name='fwrite_unlocked', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'fwriting': Function(type='int', derefcnt=0, name='fwriting', args=[Argument(type='FILE', derefcnt=1, name='fp')]),
 'fwscanf': Function(type='int', derefcnt=0, name='fwscanf', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'fxstat': Function(type='int', derefcnt=0, name='fxstat', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='int', derefcnt=0, name='fildes'), Argument(type='stat', derefcnt=1, name='stat_buf')]),
 'fxstat64': Function(type='int', derefcnt=0, name='fxstat64', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='int', derefcnt=0, name='fildes'), Argument(type='stat64', derefcnt=1, name='stat_buf')]),
 'fxstatat': Function(type='int', derefcnt=0, name='fxstatat', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='int', derefcnt=0, name='fildes'), Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat', derefcnt=1, name='stat_buf'), Argument(type='int', derefcnt=0, name='flag')]),
 'fxstatat64': Function(type='int', derefcnt=0, name='fxstatat64', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='int', derefcnt=0, name='fildes'), Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat64', derefcnt=1, name='stat_buf'), Argument(type='int', derefcnt=0, name='flag')]),
 'gai_cancel': Function(type='int', derefcnt=0, name='gai_cancel', args=[Argument(type='gaicb', derefcnt=1, name='gaicbp')]),
 'gai_error': Function(type='int', derefcnt=0, name='gai_error', args=[Argument(type='gaicb', derefcnt=1, name='req')]),
 'gai_strerror': Function(type='char', derefcnt=1, name='gai_strerror', args=[Argument(type='int', derefcnt=0, name='ecode')]),
 'gai_suspend': Function(type='int', derefcnt=0, name='gai_suspend', args=[Argument(type='gaicb', derefcnt=2, name='list'), Argument(type='int', derefcnt=0, name='ent'), Argument(type='timespec', derefcnt=1, name='timeout')]),
 'gamma': Function(type='double', derefcnt=0, name='gamma', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'gammaf': Function(type='float', derefcnt=0, name='gammaf', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'gammal': Function(type='long', derefcnt=0, name='gammal', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'gconv_btowc_fct': Function(type='wint_t', derefcnt=0, name='gconv_btowc_fct', args=[Argument(type='gconv_step', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=0, name='arg1')]),
 'gconv_end_fct': Function(type='void', derefcnt=0, name='gconv_end_fct', args=[Argument(type='gconv_step', derefcnt=1, name='arg0')]),
 'gconv_fct': Function(type='int', derefcnt=0, name='gconv_fct', args=[Argument(type='gconv_step', derefcnt=1, name='arg0'), Argument(type='gconv_step_data', derefcnt=1, name='arg1'), Argument(type='unsigned', derefcnt=2, name='arg2'), Argument(type='unsigned', derefcnt=1, name='arg3'), Argument(type='unsigned', derefcnt=2, name='arg4'), Argument(type='size_t', derefcnt=1, name='arg5'), Argument(type='int', derefcnt=0, name='arg6'), Argument(type='int', derefcnt=0, name='arg7')]),
 'gconv_init_fct': Function(type='int', derefcnt=0, name='gconv_init_fct', args=[Argument(type='gconv_step', derefcnt=1, name='arg0')]),
 'gconv_trans_context_fct': Function(type='int', derefcnt=0, name='gconv_trans_context_fct', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=1, name='arg1'), Argument(type='unsigned', derefcnt=1, name='arg2'), Argument(type='unsigned', derefcnt=1, name='arg3'), Argument(type='unsigned', derefcnt=1, name='arg4')]),
 'gconv_trans_end_fct': Function(type='void', derefcnt=0, name='gconv_trans_end_fct', args=[Argument(type='void', derefcnt=1, name='arg0')]),
 'gconv_trans_fct': Function(type='int', derefcnt=0, name='gconv_trans_fct', args=[Argument(type='gconv_step', derefcnt=1, name='arg0'), Argument(type='gconv_step_data', derefcnt=1, name='arg1'), Argument(type='void', derefcnt=1, name='arg2'), Argument(type='unsigned', derefcnt=1, name='arg3'), Argument(type='unsigned', derefcnt=2, name='arg4'), Argument(type='unsigned', derefcnt=1, name='arg5'), Argument(type='unsigned', derefcnt=2, name='arg6'), Argument(type='size_t', derefcnt=1, name='arg7')]),
 'gconv_trans_init_fct': Function(type='int', derefcnt=0, name='gconv_trans_init_fct', args=[Argument(type='void', derefcnt=2, name='arg0'), Argument(type='char', derefcnt=1, name='arg1')]),
 'gconv_trans_query_fct': Function(type='int', derefcnt=0, name='gconv_trans_query_fct', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=3, name='arg1'), Argument(type='size_t', derefcnt=1, name='arg2')]),
 'gcvt': Function(type='char', derefcnt=1, name='gcvt', args=[Argument(type='double', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='char', derefcnt=1, name='buf')]),
 'generate_key': Function(type='int', derefcnt=0, name='generate_key', args=[Argument(type='DH', derefcnt=1, name='dh')]),
 'generate_params': Function(type='int', derefcnt=0, name='generate_params', args=[Argument(type='DH', derefcnt=1, name='dh'), Argument(type='int', derefcnt=0, name='prime_len'), Argument(type='int', derefcnt=0, name='generator'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'get_asn1_parameters': Function(type='int', derefcnt=0, name='get_asn1_parameters', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='arg0'), Argument(type='ASN1_TYPE', derefcnt=1, name='arg1')]),
 'get_by_alias': Function(type='int', derefcnt=0, name='get_by_alias', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='char', derefcnt=1, name='str'), Argument(type='int', derefcnt=0, name='len'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'get_by_fingerprint': Function(type='int', derefcnt=0, name='get_by_fingerprint', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='bytes'), Argument(type='int', derefcnt=0, name='len'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'get_by_issuer_serial': Function(type='int', derefcnt=0, name='get_by_issuer_serial', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='ASN1_INTEGER', derefcnt=1, name='serial'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'get_by_subject': Function(type='int', derefcnt=0, name='get_by_subject', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='type'), Argument(type='X509_NAME', derefcnt=1, name='name'), Argument(type='X509_OBJECT', derefcnt=1, name='ret')]),
 'get_cipher': Function(type='SSL_CIPHER', derefcnt=1, name='get_cipher', args=[Argument(type='unsigned', derefcnt=0, name='ncipher')]),
 'get_cipher_by_char': Function(type='SSL_CIPHER', derefcnt=1, name='get_cipher_by_char', args=[Argument(type='unsigned', derefcnt=1, name='ptr')]),
 'get_crc_table': Function(type='z_crc_t', derefcnt=1, name='get_crc_table', args=[]),
 'get_crl': Function(type='int', derefcnt=0, name='get_crl', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509_CRL', derefcnt=2, name='crl'), Argument(type='X509', derefcnt=1, name='x')]),
 'get_current_dir_name': Function(type='char', derefcnt=1, name='get_current_dir_name', args=[]),
 'get_issuer': Function(type='int', derefcnt=0, name='get_issuer', args=[Argument(type='X509', derefcnt=2, name='issuer'), Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509', derefcnt=1, name='x')]),
 'get_rfc2409_prime_1024': Function(type='BIGNUM', derefcnt=1, name='get_rfc2409_prime_1024', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_rfc2409_prime_768': Function(type='BIGNUM', derefcnt=1, name='get_rfc2409_prime_768', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_rfc3526_prime_1536': Function(type='BIGNUM', derefcnt=1, name='get_rfc3526_prime_1536', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_rfc3526_prime_2048': Function(type='BIGNUM', derefcnt=1, name='get_rfc3526_prime_2048', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_rfc3526_prime_3072': Function(type='BIGNUM', derefcnt=1, name='get_rfc3526_prime_3072', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_rfc3526_prime_4096': Function(type='BIGNUM', derefcnt=1, name='get_rfc3526_prime_4096', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_rfc3526_prime_6144': Function(type='BIGNUM', derefcnt=1, name='get_rfc3526_prime_6144', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_rfc3526_prime_8192': Function(type='BIGNUM', derefcnt=1, name='get_rfc3526_prime_8192', args=[Argument(type='BIGNUM', derefcnt=1, name='bn')]),
 'get_session_cb': Function(type='SSL_SESSION', derefcnt=1, name='get_session_cb', args=[Argument(type='ssl_st', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=1, name='copy')]),
 'get_ssl_method': Function(type='ssl_method_st', derefcnt=1, name='get_ssl_method', args=[Argument(type='int', derefcnt=0, name='version')]),
 'get_timeout': Function(type='long', derefcnt=0, name='get_timeout', args=[]),
 'getaddrinfo': Function(type='int', derefcnt=0, name='getaddrinfo', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='service'), Argument(type='addrinfo', derefcnt=1, name='req'), Argument(type='addrinfo', derefcnt=2, name='pai')]),
 'getaddrinfo_a': Function(type='int', derefcnt=0, name='getaddrinfo_a', args=[Argument(type='int', derefcnt=0, name='mode'), Argument(type='gaicb', derefcnt=2, name='list'), Argument(type='int', derefcnt=0, name='ent'), Argument(type='sigevent', derefcnt=1, name='sig')]),
 'getaliasbyname': Function(type='aliasent', derefcnt=1, name='getaliasbyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getaliasbyname_r': Function(type='int', derefcnt=0, name='getaliasbyname_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='aliasent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='aliasent', derefcnt=2, name='result')]),
 'getaliasent': Function(type='aliasent', derefcnt=1, name='getaliasent', args=[]),
 'getaliasent_r': Function(type='int', derefcnt=0, name='getaliasent_r', args=[Argument(type='aliasent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='aliasent', derefcnt=2, name='result')]),
 'getc': Function(type='int', derefcnt=0, name='getc', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'getc_unlocked': Function(type='int', derefcnt=0, name='getc_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'getchar': Function(type='int', derefcnt=0, name='getchar', args=[]),
 'getchar_unlocked': Function(type='int', derefcnt=0, name='getchar_unlocked', args=[]),
 'getcontext': Function(type='int', derefcnt=0, name='getcontext', args=[Argument(type='ucontext_t', derefcnt=1, name='ucp')]),
 'getcwd': Function(type='char', derefcnt=1, name='getcwd', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='size')]),
 'getdate': Function(type='tm', derefcnt=1, name='getdate', args=[Argument(type='char', derefcnt=1, name='string')]),
 'getdate_r': Function(type='int', derefcnt=0, name='getdate_r', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='tm', derefcnt=1, name='resbufp')]),
 'getdelim': Function(type='ssize_t', derefcnt=0, name='getdelim', args=[Argument(type='char', derefcnt=2, name='lineptr'), Argument(type='size_t', derefcnt=1, name='n'), Argument(type='int', derefcnt=0, name='delimiter'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'getdirentries': Function(type='ssize_t', derefcnt=0, name='getdirentries', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes'), Argument(type='off_t', derefcnt=1, name='basep')]),
 'getdirentries64': Function(type='ssize_t', derefcnt=0, name='getdirentries64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes'), Argument(type='off64_t', derefcnt=1, name='basep')]),
 'getdomainname': Function(type='int', derefcnt=0, name='getdomainname', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='size_t', derefcnt=0, name='len')]),
 'getdtablesize': Function(type='int', derefcnt=0, name='getdtablesize', args=[]),
 'getegid': Function(type='gid_t', derefcnt=0, name='getegid', args=[]),
 'getenv': Function(type='char', derefcnt=1, name='getenv', args=[Argument(type='char', derefcnt=1, name='name')]),
 'geteuid': Function(type='uid_t', derefcnt=0, name='geteuid', args=[]),
 'getfsent': Function(type='fstab', derefcnt=1, name='getfsent', args=[]),
 'getfsfile': Function(type='fstab', derefcnt=1, name='getfsfile', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getfsspec': Function(type='fstab', derefcnt=1, name='getfsspec', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getgid': Function(type='gid_t', derefcnt=0, name='getgid', args=[]),
 'getgrent': Function(type='group', derefcnt=1, name='getgrent', args=[]),
 'getgrent_r': Function(type='int', derefcnt=0, name='getgrent_r', args=[Argument(type='group', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='group', derefcnt=2, name='result')]),
 'getgrgid': Function(type='group', derefcnt=1, name='getgrgid', args=[Argument(type='gid_t', derefcnt=0, name='gid')]),
 'getgrgid_r': Function(type='int', derefcnt=0, name='getgrgid_r', args=[Argument(type='gid_t', derefcnt=0, name='gid'), Argument(type='group', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='group', derefcnt=2, name='result')]),
 'getgrnam': Function(type='group', derefcnt=1, name='getgrnam', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getgrnam_r': Function(type='int', derefcnt=0, name='getgrnam_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='group', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='group', derefcnt=2, name='result')]),
 'getgrouplist': Function(type='int', derefcnt=0, name='getgrouplist', args=[Argument(type='char', derefcnt=1, name='user'), Argument(type='gid_t', derefcnt=0, name='group'), Argument(type='gid_t', derefcnt=1, name='groups'), Argument(type='int', derefcnt=1, name='ngroups')]),
 'getgroups': Function(type='int', derefcnt=0, name='getgroups', args=[Argument(type='int', derefcnt=0, name='size'), Argument(type='gid_t', derefcnt=1, name='list')]),
 'gethostbyaddr': Function(type='hostent', derefcnt=1, name='gethostbyaddr', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='socklen_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='type')]),
 'gethostbyaddr_r': Function(type='int', derefcnt=0, name='gethostbyaddr_r', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='socklen_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='type'), Argument(type='hostent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='hostent', derefcnt=2, name='result'), Argument(type='int', derefcnt=1, name='h_errnop')]),
 'gethostbyname': Function(type='hostent', derefcnt=1, name='gethostbyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'gethostbyname2': Function(type='hostent', derefcnt=1, name='gethostbyname2', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='af')]),
 'gethostbyname2_r': Function(type='int', derefcnt=0, name='gethostbyname2_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='af'), Argument(type='hostent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='hostent', derefcnt=2, name='result'), Argument(type='int', derefcnt=1, name='h_errnop')]),
 'gethostbyname_r': Function(type='int', derefcnt=0, name='gethostbyname_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='hostent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='hostent', derefcnt=2, name='result'), Argument(type='int', derefcnt=1, name='h_errnop')]),
 'gethostent': Function(type='hostent', derefcnt=1, name='gethostent', args=[]),
 'gethostent_r': Function(type='int', derefcnt=0, name='gethostent_r', args=[Argument(type='hostent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='hostent', derefcnt=2, name='result'), Argument(type='int', derefcnt=1, name='h_errnop')]),
 'gethostid': Function(type='long', derefcnt=0, name='gethostid', args=[]),
 'gethostname': Function(type='int', derefcnt=0, name='gethostname', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='size_t', derefcnt=0, name='len')]),
 'getifaddrs': Function(type='int', derefcnt=0, name='getifaddrs', args=[Argument(type='ifaddrs', derefcnt=2, name='ifap')]),
 'getipv4sourcefilter': Function(type='int', derefcnt=0, name='getipv4sourcefilter', args=[Argument(type='int', derefcnt=0, name='s'), Argument(type='in_addr', derefcnt=0, name='interface_addr'), Argument(type='in_addr', derefcnt=0, name='group'), Argument(type='uint32_t', derefcnt=1, name='fmode'), Argument(type='uint32_t', derefcnt=1, name='numsrc'), Argument(type='in_addr', derefcnt=1, name='slist')]),
 'getitimer': Function(type='int', derefcnt=0, name='getitimer', args=[Argument(type='itimer_which_t', derefcnt=0, name='which'), Argument(type='itimerval', derefcnt=1, name='value')]),
 'getline': Function(type='ssize_t', derefcnt=0, name='getline', args=[Argument(type='char', derefcnt=2, name='lineptr'), Argument(type='size_t', derefcnt=1, name='n'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'getloadavg': Function(type='int', derefcnt=0, name='getloadavg', args=[Argument(type='double', derefcnt=1, name='loadavg'), Argument(type='int', derefcnt=0, name='nelem')]),
 'getlogin': Function(type='char', derefcnt=1, name='getlogin', args=[]),
 'getlogin_r': Function(type='int', derefcnt=0, name='getlogin_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='size_t', derefcnt=0, name='name_len')]),
 'getmntent': Function(type='mntent', derefcnt=1, name='getmntent', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'getmntent_r': Function(type='mntent', derefcnt=1, name='getmntent_r', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='mntent', derefcnt=1, name='result'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='int', derefcnt=0, name='bufsize')]),
 'getmsg': Function(type='int', derefcnt=0, name='getmsg', args=[Argument(type='int', derefcnt=0, name='fildes'), Argument(type='strbuf', derefcnt=1, name='ctlptr'), Argument(type='strbuf', derefcnt=1, name='dataptr'), Argument(type='int', derefcnt=1, name='flagsp')]),
 'getnameinfo': Function(type='int', derefcnt=0, name='getnameinfo', args=[Argument(type='sockaddr', derefcnt=1, name='sa'), Argument(type='socklen_t', derefcnt=0, name='salen'), Argument(type='char', derefcnt=1, name='host'), Argument(type='socklen_t', derefcnt=0, name='hostlen'), Argument(type='char', derefcnt=1, name='serv'), Argument(type='socklen_t', derefcnt=0, name='servlen'), Argument(type='int', derefcnt=0, name='flags')]),
 'getnetbyaddr': Function(type='netent', derefcnt=1, name='getnetbyaddr', args=[Argument(type='uint32_t', derefcnt=0, name='net'), Argument(type='int', derefcnt=0, name='type')]),
 'getnetbyaddr_r': Function(type='int', derefcnt=0, name='getnetbyaddr_r', args=[Argument(type='uint32_t', derefcnt=0, name='net'), Argument(type='int', derefcnt=0, name='type'), Argument(type='netent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='netent', derefcnt=2, name='result'), Argument(type='int', derefcnt=1, name='h_errnop')]),
 'getnetbyname': Function(type='netent', derefcnt=1, name='getnetbyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getnetbyname_r': Function(type='int', derefcnt=0, name='getnetbyname_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='netent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='netent', derefcnt=2, name='result'), Argument(type='int', derefcnt=1, name='h_errnop')]),
 'getnetent': Function(type='netent', derefcnt=1, name='getnetent', args=[]),
 'getnetent_r': Function(type='int', derefcnt=0, name='getnetent_r', args=[Argument(type='netent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='netent', derefcnt=2, name='result'), Argument(type='int', derefcnt=1, name='h_errnop')]),
 'getnetgrent': Function(type='int', derefcnt=0, name='getnetgrent', args=[Argument(type='char', derefcnt=2, name='hostp'), Argument(type='char', derefcnt=2, name='userp'), Argument(type='char', derefcnt=2, name='domainp')]),
 'getnetgrent_r': Function(type='int', derefcnt=0, name='getnetgrent_r', args=[Argument(type='char', derefcnt=2, name='hostp'), Argument(type='char', derefcnt=2, name='userp'), Argument(type='char', derefcnt=2, name='domainp'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen')]),
 'getopt': Function(type='int', derefcnt=0, name='getopt', args=[Argument(type='int', derefcnt=0, name='argc'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=1, name='shortopts')]),
 'getopt_long': Function(type='int', derefcnt=0, name='getopt_long', args=[Argument(type='int', derefcnt=0, name='argc'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=1, name='shortopts'), Argument(type='option', derefcnt=1, name='longopts'), Argument(type='int', derefcnt=1, name='longind')]),
 'getopt_long_only': Function(type='int', derefcnt=0, name='getopt_long_only', args=[Argument(type='int', derefcnt=0, name='argc'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=1, name='shortopts'), Argument(type='option', derefcnt=1, name='longopts'), Argument(type='int', derefcnt=1, name='longind')]),
 'getpagesize': Function(type='int', derefcnt=0, name='getpagesize', args=[]),
 'getpass': Function(type='char', derefcnt=1, name='getpass', args=[Argument(type='char', derefcnt=1, name='prompt')]),
 'getpeername': Function(type='int', derefcnt=0, name='getpeername', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=1, name='len')]),
 'getpgid': Function(type='pid_t', derefcnt=0, name='getpgid', args=[Argument(type='pid_t', derefcnt=0, name='pid')]),
 'getpgrp': Function(type='pid_t', derefcnt=0, name='getpgrp', args=[]),
 'getpid': Function(type='pid_t', derefcnt=0, name='getpid', args=[]),
 'getpmsg': Function(type='int', derefcnt=0, name='getpmsg', args=[Argument(type='int', derefcnt=0, name='fildes'), Argument(type='strbuf', derefcnt=1, name='ctlptr'), Argument(type='strbuf', derefcnt=1, name='dataptr'), Argument(type='int', derefcnt=1, name='bandp'), Argument(type='int', derefcnt=1, name='flagsp')]),
 'getppid': Function(type='pid_t', derefcnt=0, name='getppid', args=[]),
 'getpriority': Function(type='int', derefcnt=0, name='getpriority', args=[Argument(type='priority_which_t', derefcnt=0, name='which'), Argument(type='id_t', derefcnt=0, name='who')]),
 'getprotobyname': Function(type='protoent', derefcnt=1, name='getprotobyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getprotobyname_r': Function(type='int', derefcnt=0, name='getprotobyname_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='protoent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='protoent', derefcnt=2, name='result')]),
 'getprotobynumber': Function(type='protoent', derefcnt=1, name='getprotobynumber', args=[Argument(type='int', derefcnt=0, name='proto')]),
 'getprotobynumber_r': Function(type='int', derefcnt=0, name='getprotobynumber_r', args=[Argument(type='int', derefcnt=0, name='proto'), Argument(type='protoent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='protoent', derefcnt=2, name='result')]),
 'getprotoent': Function(type='protoent', derefcnt=1, name='getprotoent', args=[]),
 'getprotoent_r': Function(type='int', derefcnt=0, name='getprotoent_r', args=[Argument(type='protoent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='protoent', derefcnt=2, name='result')]),
 'getpt': Function(type='int', derefcnt=0, name='getpt', args=[]),
 'getpw': Function(type='int', derefcnt=0, name='getpw', args=[Argument(type='uid_t', derefcnt=0, name='uid'), Argument(type='char', derefcnt=1, name='buffer')]),
 'getpwent': Function(type='passwd', derefcnt=1, name='getpwent', args=[]),
 'getpwent_r': Function(type='int', derefcnt=0, name='getpwent_r', args=[Argument(type='passwd', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='passwd', derefcnt=2, name='result')]),
 'getpwnam': Function(type='passwd', derefcnt=1, name='getpwnam', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getpwnam_r': Function(type='int', derefcnt=0, name='getpwnam_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='passwd', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='passwd', derefcnt=2, name='result')]),
 'getpwuid': Function(type='passwd', derefcnt=1, name='getpwuid', args=[Argument(type='uid_t', derefcnt=0, name='uid')]),
 'getpwuid_r': Function(type='int', derefcnt=0, name='getpwuid_r', args=[Argument(type='uid_t', derefcnt=0, name='uid'), Argument(type='passwd', derefcnt=1, name='resultbuf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='passwd', derefcnt=2, name='result')]),
 'getresgid': Function(type='int', derefcnt=0, name='getresgid', args=[Argument(type='gid_t', derefcnt=1, name='rgid'), Argument(type='gid_t', derefcnt=1, name='egid'), Argument(type='gid_t', derefcnt=1, name='sgid')]),
 'getresuid': Function(type='int', derefcnt=0, name='getresuid', args=[Argument(type='uid_t', derefcnt=1, name='ruid'), Argument(type='uid_t', derefcnt=1, name='euid'), Argument(type='uid_t', derefcnt=1, name='suid')]),
 'getrlimit': Function(type='int', derefcnt=0, name='getrlimit', args=[Argument(type='rlimit_resource_t', derefcnt=0, name='resource'), Argument(type='rlimit', derefcnt=1, name='rlimits')]),
 'getrlimit64': Function(type='int', derefcnt=0, name='getrlimit64', args=[Argument(type='rlimit_resource_t', derefcnt=0, name='resource'), Argument(type='rlimit64', derefcnt=1, name='rlimits')]),
 'getrpcbyname': Function(type='rpcent', derefcnt=1, name='getrpcbyname', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getrpcbyname_r': Function(type='int', derefcnt=0, name='getrpcbyname_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='rpcent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='rpcent', derefcnt=2, name='result')]),
 'getrpcbynumber': Function(type='rpcent', derefcnt=1, name='getrpcbynumber', args=[Argument(type='int', derefcnt=0, name='number')]),
 'getrpcbynumber_r': Function(type='int', derefcnt=0, name='getrpcbynumber_r', args=[Argument(type='int', derefcnt=0, name='number'), Argument(type='rpcent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='rpcent', derefcnt=2, name='result')]),
 'getrpcent': Function(type='rpcent', derefcnt=1, name='getrpcent', args=[]),
 'getrpcent_r': Function(type='int', derefcnt=0, name='getrpcent_r', args=[Argument(type='rpcent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='rpcent', derefcnt=2, name='result')]),
 'getrusage': Function(type='int', derefcnt=0, name='getrusage', args=[Argument(type='rusage_who_t', derefcnt=0, name='who'), Argument(type='rusage', derefcnt=1, name='usage')]),
 'getservbyname': Function(type='servent', derefcnt=1, name='getservbyname', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='proto')]),
 'getservbyname_r': Function(type='int', derefcnt=0, name='getservbyname_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='proto'), Argument(type='servent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='servent', derefcnt=2, name='result')]),
 'getservbyport': Function(type='servent', derefcnt=1, name='getservbyport', args=[Argument(type='int', derefcnt=0, name='port'), Argument(type='char', derefcnt=1, name='proto')]),
 'getservbyport_r': Function(type='int', derefcnt=0, name='getservbyport_r', args=[Argument(type='int', derefcnt=0, name='port'), Argument(type='char', derefcnt=1, name='proto'), Argument(type='servent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='servent', derefcnt=2, name='result')]),
 'getservent': Function(type='servent', derefcnt=1, name='getservent', args=[]),
 'getservent_r': Function(type='int', derefcnt=0, name='getservent_r', args=[Argument(type='servent', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='servent', derefcnt=2, name='result')]),
 'getsgent': Function(type='sgrp', derefcnt=1, name='getsgent', args=[]),
 'getsgent_r': Function(type='int', derefcnt=0, name='getsgent_r', args=[Argument(type='sgrp', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='sgrp', derefcnt=2, name='result')]),
 'getsgnam': Function(type='sgrp', derefcnt=1, name='getsgnam', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getsgnam_r': Function(type='int', derefcnt=0, name='getsgnam_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='sgrp', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='sgrp', derefcnt=2, name='result')]),
 'getsid': Function(type='pid_t', derefcnt=0, name='getsid', args=[Argument(type='pid_t', derefcnt=0, name='pid')]),
 'getsockname': Function(type='int', derefcnt=0, name='getsockname', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=1, name='len')]),
 'getsockopt': Function(type='int', derefcnt=0, name='getsockopt', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='level'), Argument(type='int', derefcnt=0, name='optname'), Argument(type='void', derefcnt=1, name='optval'), Argument(type='socklen_t', derefcnt=1, name='optlen')]),
 'getsourcefilter': Function(type='int', derefcnt=0, name='getsourcefilter', args=[Argument(type='int', derefcnt=0, name='s'), Argument(type='uint32_t', derefcnt=0, name='interface_addr'), Argument(type='sockaddr', derefcnt=1, name='group'), Argument(type='socklen_t', derefcnt=0, name='grouplen'), Argument(type='uint32_t', derefcnt=1, name='fmode'), Argument(type='uint32_t', derefcnt=1, name='numsrc'), Argument(type='sockaddr_storage', derefcnt=1, name='slist')]),
 'getspent': Function(type='spwd', derefcnt=1, name='getspent', args=[]),
 'getspent_r': Function(type='int', derefcnt=0, name='getspent_r', args=[Argument(type='spwd', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='spwd', derefcnt=2, name='result')]),
 'getspnam': Function(type='spwd', derefcnt=1, name='getspnam', args=[Argument(type='char', derefcnt=1, name='name')]),
 'getspnam_r': Function(type='int', derefcnt=0, name='getspnam_r', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='spwd', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='spwd', derefcnt=2, name='result')]),
 'getsubopt': Function(type='int', derefcnt=0, name='getsubopt', args=[Argument(type='char', derefcnt=2, name='optionp'), Argument(type='char', derefcnt=2, name='tokens'), Argument(type='char', derefcnt=2, name='valuep')]),
 'gettext': Function(type='char', derefcnt=1, name='gettext', args=[Argument(type='char', derefcnt=1, name='msgid')]),
 'gettimeofday': Function(type='int', derefcnt=0, name='gettimeofday', args=[Argument(type='timeval', derefcnt=1, name='tv'), Argument(type='timezone_ptr_t', derefcnt=0, name='tz')]),
 'getttyent': Function(type='ttyent', derefcnt=1, name='getttyent', args=[]),
 'getttynam': Function(type='ttyent', derefcnt=1, name='getttynam', args=[Argument(type='char', derefcnt=1, name='tty')]),
 'getuid': Function(type='uid_t', derefcnt=0, name='getuid', args=[]),
 'getumask': Function(type='mode_t', derefcnt=0, name='getumask', args=[]),
 'getusershell': Function(type='char', derefcnt=1, name='getusershell', args=[]),
 'getutent': Function(type='utmp', derefcnt=1, name='getutent', args=[]),
 'getutent_r': Function(type='int', derefcnt=0, name='getutent_r', args=[Argument(type='utmp', derefcnt=1, name='buffer'), Argument(type='utmp', derefcnt=2, name='result')]),
 'getutid': Function(type='utmp', derefcnt=1, name='getutid', args=[Argument(type='utmp', derefcnt=1, name='id')]),
 'getutid_r': Function(type='int', derefcnt=0, name='getutid_r', args=[Argument(type='utmp', derefcnt=1, name='id'), Argument(type='utmp', derefcnt=1, name='buffer'), Argument(type='utmp', derefcnt=2, name='result')]),
 'getutline': Function(type='utmp', derefcnt=1, name='getutline', args=[Argument(type='utmp', derefcnt=1, name='line')]),
 'getutline_r': Function(type='int', derefcnt=0, name='getutline_r', args=[Argument(type='utmp', derefcnt=1, name='line'), Argument(type='utmp', derefcnt=1, name='buffer'), Argument(type='utmp', derefcnt=2, name='result')]),
 'getutmp': Function(type='void', derefcnt=0, name='getutmp', args=[Argument(type='utmpx', derefcnt=1, name='utmpx'), Argument(type='utmp', derefcnt=1, name='utmp')]),
 'getutmpx': Function(type='void', derefcnt=0, name='getutmpx', args=[Argument(type='utmp', derefcnt=1, name='utmp'), Argument(type='utmpx', derefcnt=1, name='utmpx')]),
 'getutxent': Function(type='utmpx', derefcnt=1, name='getutxent', args=[]),
 'getutxid': Function(type='utmpx', derefcnt=1, name='getutxid', args=[Argument(type='utmpx', derefcnt=1, name='id')]),
 'getutxline': Function(type='utmpx', derefcnt=1, name='getutxline', args=[Argument(type='utmpx', derefcnt=1, name='line')]),
 'getw': Function(type='int', derefcnt=0, name='getw', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'getwc': Function(type='wint_t', derefcnt=0, name='getwc', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'getwc_unlocked': Function(type='wint_t', derefcnt=0, name='getwc_unlocked', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'getwchar': Function(type='wint_t', derefcnt=0, name='getwchar', args=[]),
 'getwchar_unlocked': Function(type='wint_t', derefcnt=0, name='getwchar_unlocked', args=[]),
 'getwd': Function(type='char', derefcnt=1, name='getwd', args=[Argument(type='char', derefcnt=1, name='buf')]),
 'gl_closedir': Function(type='void', derefcnt=0, name='gl_closedir', args=[Argument(type='void', derefcnt=1, name='arg0')]),
 'gl_lstat': Function(type='int', derefcnt=0, name='gl_lstat', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='stat64', derefcnt=1, name='arg1')]),
 'gl_opendir': Function(type='void', derefcnt=1, name='gl_opendir', args=[Argument(type='char', derefcnt=1, name='arg0')]),
 'gl_readdir': Function(type='dirent64', derefcnt=1, name='gl_readdir', args=[Argument(type='void', derefcnt=1, name='arg0')]),
 'gl_stat': Function(type='int', derefcnt=0, name='gl_stat', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='stat64', derefcnt=1, name='arg1')]),
 'glob': Function(type='int', derefcnt=0, name='glob', args=[Argument(type='char', derefcnt=1, name='pattern'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='errfunc'), Argument(type='glob_t', derefcnt=1, name='pglob')]),
 'glob64': Function(type='int', derefcnt=0, name='glob64', args=[Argument(type='char', derefcnt=1, name='pattern'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='errfunc'), Argument(type='glob64_t', derefcnt=1, name='pglob')]),
 'glob_pattern_p': Function(type='int', derefcnt=0, name='glob_pattern_p', args=[Argument(type='char', derefcnt=1, name='pattern'), Argument(type='int', derefcnt=0, name='quote')]),
 'globfree': Function(type='void', derefcnt=0, name='globfree', args=[Argument(type='glob_t', derefcnt=1, name='pglob')]),
 'globfree64': Function(type='void', derefcnt=0, name='globfree64', args=[Argument(type='glob64_t', derefcnt=1, name='pglob')]),
 'gmtime': Function(type='tm', derefcnt=1, name='gmtime', args=[Argument(type='time_t', derefcnt=1, name='timer')]),
 'gmtime_r': Function(type='tm', derefcnt=1, name='gmtime_r', args=[Argument(type='time_t', derefcnt=1, name='timer'), Argument(type='tm', derefcnt=1, name='tp')]),
 'gnu_dev_major': Function(type='unsigned', derefcnt=0, name='gnu_dev_major', args=[Argument(type='unsigned', derefcnt=0, name='dev')]),
 'gnu_dev_makedev': Function(type='unsigned', derefcnt=0, name='gnu_dev_makedev', args=[Argument(type='unsigned', derefcnt=0, name='major'), Argument(type='unsigned', derefcnt=0, name='minor')]),
 'gnu_dev_minor': Function(type='unsigned', derefcnt=0, name='gnu_dev_minor', args=[Argument(type='unsigned', derefcnt=0, name='dev')]),
 'grantpt': Function(type='int', derefcnt=0, name='grantpt', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'group_member': Function(type='int', derefcnt=0, name='group_member', args=[Argument(type='gid_t', derefcnt=0, name='gid')]),
 'gsignal': Function(type='int', derefcnt=0, name='gsignal', args=[Argument(type='int', derefcnt=0, name='sig')]),
 'gtty': Function(type='int', derefcnt=0, name='gtty', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='sgttyb', derefcnt=1, name='params')]),
 'gzbuffer': Function(type='int', derefcnt=0, name='gzbuffer', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='unsigned', derefcnt=0, name='size')]),
 'gzclearerr': Function(type='void', derefcnt=0, name='gzclearerr', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzclose': Function(type='int', derefcnt=0, name='gzclose', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzclose_r': Function(type='int', derefcnt=0, name='gzclose_r', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzclose_w': Function(type='int', derefcnt=0, name='gzclose_w', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzdirect': Function(type='int', derefcnt=0, name='gzdirect', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzdopen': Function(type='gzFile', derefcnt=0, name='gzdopen', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='mode')]),
 'gzeof': Function(type='int', derefcnt=0, name='gzeof', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzerror': Function(type='char', derefcnt=1, name='gzerror', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='int', derefcnt=1, name='errnum')]),
 'gzflush': Function(type='int', derefcnt=0, name='gzflush', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='int', derefcnt=0, name='flush')]),
 'gzgetc': Function(type='int', derefcnt=0, name='gzgetc', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzgetc_': Function(type='int', derefcnt=0, name='gzgetc_', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzgets': Function(type='char', derefcnt=1, name='gzgets', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'gzoffset': Function(type='off_t', derefcnt=0, name='gzoffset', args=[Argument(type='gzFile', derefcnt=0, name='arg0')]),
 'gzoffset64': Function(type='off64_t', derefcnt=0, name='gzoffset64', args=[Argument(type='gzFile', derefcnt=0, name='arg0')]),
 'gzopen': Function(type='gzFile', derefcnt=0, name='gzopen', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1')]),
 'gzopen64': Function(type='gzFile', derefcnt=0, name='gzopen64', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1')]),
 'gzprintf': Function(type='int', derefcnt=0, name='gzprintf', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'gzputc': Function(type='int', derefcnt=0, name='gzputc', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='int', derefcnt=0, name='c')]),
 'gzputs': Function(type='int', derefcnt=0, name='gzputs', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='char', derefcnt=1, name='s')]),
 'gzread': Function(type='int', derefcnt=0, name='gzread', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='voidp', derefcnt=0, name='buf'), Argument(type='unsigned', derefcnt=0, name='len')]),
 'gzrewind': Function(type='int', derefcnt=0, name='gzrewind', args=[Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzseek': Function(type='off_t', derefcnt=0, name='gzseek', args=[Argument(type='gzFile', derefcnt=0, name='arg0'), Argument(type='off_t', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'gzseek64': Function(type='off64_t', derefcnt=0, name='gzseek64', args=[Argument(type='gzFile', derefcnt=0, name='arg0'), Argument(type='off64_t', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2')]),
 'gzsetparams': Function(type='int', derefcnt=0, name='gzsetparams', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='int', derefcnt=0, name='level'), Argument(type='int', derefcnt=0, name='strategy')]),
 'gztell': Function(type='off_t', derefcnt=0, name='gztell', args=[Argument(type='gzFile', derefcnt=0, name='arg0')]),
 'gztell64': Function(type='off64_t', derefcnt=0, name='gztell64', args=[Argument(type='gzFile', derefcnt=0, name='arg0')]),
 'gzungetc': Function(type='int', derefcnt=0, name='gzungetc', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='gzFile', derefcnt=0, name='file')]),
 'gzvprintf': Function(type='int', derefcnt=0, name='gzvprintf', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='char', derefcnt=1, name='format'), Argument(type='va_list', derefcnt=0, name='va')]),
 'gzwrite': Function(type='int', derefcnt=0, name='gzwrite', args=[Argument(type='gzFile', derefcnt=0, name='file'), Argument(type='voidpc', derefcnt=0, name='buf'), Argument(type='unsigned', derefcnt=0, name='len')]),
 'h_errno_location': Function(type='int', derefcnt=1, name='h_errno_location', args=[]),
 'handshake_func': Function(type='int', derefcnt=0, name='handshake_func', args=[Argument(type='SSL', derefcnt=1, name='arg0')]),
 'hasmntopt': Function(type='char', derefcnt=1, name='hasmntopt', args=[Argument(type='mntent', derefcnt=1, name='mnt'), Argument(type='char', derefcnt=1, name='opt')]),
 'hcreate': Function(type='int', derefcnt=0, name='hcreate', args=[Argument(type='size_t', derefcnt=0, name='nel')]),
 'hcreate_r': Function(type='int', derefcnt=0, name='hcreate_r', args=[Argument(type='size_t', derefcnt=0, name='nel'), Argument(type='hsearch_data', derefcnt=1, name='htab')]),
 'hdestroy': Function(type='void', derefcnt=0, name='hdestroy', args=[]),
 'hdestroy_r': Function(type='void', derefcnt=0, name='hdestroy_r', args=[Argument(type='hsearch_data', derefcnt=1, name='htab')]),
 'help_filter': Function(type='char', derefcnt=1, name='help_filter', args=[Argument(type='int', derefcnt=0, name='key'), Argument(type='char', derefcnt=1, name='text'), Argument(type='void', derefcnt=1, name='input')]),
 'herror': Function(type='void', derefcnt=0, name='herror', args=[Argument(type='char', derefcnt=1, name='str')]),
 'hostalias': Function(type='char', derefcnt=1, name='hostalias', args=[Argument(type='char', derefcnt=1, name='arg0')]),
 'hsearch': Function(type='ENTRY', derefcnt=1, name='hsearch', args=[Argument(type='ENTRY', derefcnt=0, name='item'), Argument(type='ACTION', derefcnt=0, name='action')]),
 'hsearch_r': Function(type='int', derefcnt=0, name='hsearch_r', args=[Argument(type='ENTRY', derefcnt=0, name='item'), Argument(type='ACTION', derefcnt=0, name='action'), Argument(type='ENTRY', derefcnt=2, name='retval'), Argument(type='hsearch_data', derefcnt=1, name='htab')]),
 'hstrerror': Function(type='char', derefcnt=1, name='hstrerror', args=[Argument(type='int', derefcnt=0, name='err_num')]),
 'htonl': Function(type='uint32_t', derefcnt=0, name='htonl', args=[Argument(type='uint32_t', derefcnt=0, name='hostlong')]),
 'htons': Function(type='uint16_t', derefcnt=0, name='htons', args=[Argument(type='uint16_t', derefcnt=0, name='hostshort')]),
 'hypot': Function(type='double', derefcnt=0, name='hypot', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'hypotf': Function(type='float', derefcnt=0, name='hypotf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'hypotl': Function(type='long', derefcnt=0, name='hypotl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'i2a': Function(type='int', derefcnt=0, name='i2a', args=[]),
 'i2a_ASN1_ENUMERATED': Function(type='int', derefcnt=0, name='i2a_ASN1_ENUMERATED', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_ENUMERATED', derefcnt=1, name='a')]),
 'i2a_ASN1_INTEGER': Function(type='int', derefcnt=0, name='i2a_ASN1_INTEGER', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_INTEGER', derefcnt=1, name='a')]),
 'i2a_ASN1_OBJECT': Function(type='int', derefcnt=0, name='i2a_ASN1_OBJECT', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_OBJECT', derefcnt=1, name='a')]),
 'i2a_ASN1_STRING': Function(type='int', derefcnt=0, name='i2a_ASN1_STRING', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='ASN1_STRING', derefcnt=1, name='a'), Argument(type='int', derefcnt=0, name='type')]),
 'i2b_PVK_bio': Function(type='int', derefcnt=0, name='i2b_PVK_bio', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='EVP_PKEY', derefcnt=1, name='pk'), Argument(type='int', derefcnt=0, name='enclevel'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'i2b_PrivateKey_bio': Function(type='int', derefcnt=0, name='i2b_PrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='EVP_PKEY', derefcnt=1, name='pk')]),
 'i2b_PublicKey_bio': Function(type='int', derefcnt=0, name='i2b_PublicKey_bio', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='EVP_PKEY', derefcnt=1, name='pk')]),
 'i2c_ASN1_BIT_STRING': Function(type='int', derefcnt=0, name='i2c_ASN1_BIT_STRING', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2c_ASN1_INTEGER': Function(type='int', derefcnt=0, name='i2c_ASN1_INTEGER', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_ASN1_BIT_STRING': Function(type='int', derefcnt=0, name='i2d_ASN1_BIT_STRING', args=[Argument(type='ASN1_BIT_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_BMPSTRING': Function(type='int', derefcnt=0, name='i2d_ASN1_BMPSTRING', args=[Argument(type='ASN1_BMPSTRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_BOOLEAN': Function(type='int', derefcnt=0, name='i2d_ASN1_BOOLEAN', args=[Argument(type='int', derefcnt=0, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_ASN1_ENUMERATED': Function(type='int', derefcnt=0, name='i2d_ASN1_ENUMERATED', args=[Argument(type='ASN1_ENUMERATED', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_GENERALIZEDTIME': Function(type='int', derefcnt=0, name='i2d_ASN1_GENERALIZEDTIME', args=[Argument(type='ASN1_GENERALIZEDTIME', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_GENERALSTRING': Function(type='int', derefcnt=0, name='i2d_ASN1_GENERALSTRING', args=[Argument(type='ASN1_GENERALSTRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_IA5STRING': Function(type='int', derefcnt=0, name='i2d_ASN1_IA5STRING', args=[Argument(type='ASN1_IA5STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_INTEGER': Function(type='int', derefcnt=0, name='i2d_ASN1_INTEGER', args=[Argument(type='ASN1_INTEGER', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_NULL': Function(type='int', derefcnt=0, name='i2d_ASN1_NULL', args=[Argument(type='ASN1_NULL', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_OBJECT': Function(type='int', derefcnt=0, name='i2d_ASN1_OBJECT', args=[Argument(type='ASN1_OBJECT', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_ASN1_OCTET_STRING': Function(type='int', derefcnt=0, name='i2d_ASN1_OCTET_STRING', args=[Argument(type='ASN1_OCTET_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_PRINTABLE': Function(type='int', derefcnt=0, name='i2d_ASN1_PRINTABLE', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_PRINTABLESTRING': Function(type='int', derefcnt=0, name='i2d_ASN1_PRINTABLESTRING', args=[Argument(type='ASN1_PRINTABLESTRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_SEQUENCE_ANY': Function(type='int', derefcnt=0, name='i2d_ASN1_SEQUENCE_ANY', args=[Argument(type='ASN1_SEQUENCE_ANY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_SET': Function(type='int', derefcnt=0, name='i2d_ASN1_SET', args=[Argument(type='stack_st_OPENSSL_BLOCK', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='i2d_of_void', derefcnt=1, name='i2d'), Argument(type='int', derefcnt=0, name='ex_tag'), Argument(type='int', derefcnt=0, name='ex_class'), Argument(type='int', derefcnt=0, name='is_set')]),
 'i2d_ASN1_SET_ANY': Function(type='int', derefcnt=0, name='i2d_ASN1_SET_ANY', args=[Argument(type='ASN1_SEQUENCE_ANY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_T61STRING': Function(type='int', derefcnt=0, name='i2d_ASN1_T61STRING', args=[Argument(type='ASN1_T61STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_TIME': Function(type='int', derefcnt=0, name='i2d_ASN1_TIME', args=[Argument(type='ASN1_TIME', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_TYPE': Function(type='int', derefcnt=0, name='i2d_ASN1_TYPE', args=[Argument(type='ASN1_TYPE', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_UNIVERSALSTRING': Function(type='int', derefcnt=0, name='i2d_ASN1_UNIVERSALSTRING', args=[Argument(type='ASN1_UNIVERSALSTRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_UTCTIME': Function(type='int', derefcnt=0, name='i2d_ASN1_UTCTIME', args=[Argument(type='ASN1_UTCTIME', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_UTF8STRING': Function(type='int', derefcnt=0, name='i2d_ASN1_UTF8STRING', args=[Argument(type='ASN1_UTF8STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_VISIBLESTRING': Function(type='int', derefcnt=0, name='i2d_ASN1_VISIBLESTRING', args=[Argument(type='ASN1_VISIBLESTRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ASN1_bio_stream': Function(type='int', derefcnt=0, name='i2d_ASN1_bio_stream', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='ASN1_VALUE', derefcnt=1, name='val'), Argument(type='BIO', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='ASN1_ITEM', derefcnt=1, name='it')]),
 'i2d_ASN1_bytes': Function(type='int', derefcnt=0, name='i2d_ASN1_bytes', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='int', derefcnt=0, name='tag'), Argument(type='int', derefcnt=0, name='xclass')]),
 'i2d_DHparams': Function(type='int', derefcnt=0, name='i2d_DHparams', args=[Argument(type='DH', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_DIRECTORYSTRING': Function(type='int', derefcnt=0, name='i2d_DIRECTORYSTRING', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_DISPLAYTEXT': Function(type='int', derefcnt=0, name='i2d_DISPLAYTEXT', args=[Argument(type='ASN1_STRING', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_DSAPrivateKey': Function(type='int', derefcnt=0, name='i2d_DSAPrivateKey', args=[Argument(type='DSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_DSAPrivateKey_bio': Function(type='int', derefcnt=0, name='i2d_DSAPrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'i2d_DSAPrivateKey_fp': Function(type='int', derefcnt=0, name='i2d_DSAPrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'i2d_DSAPublicKey': Function(type='int', derefcnt=0, name='i2d_DSAPublicKey', args=[Argument(type='DSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_DSA_PUBKEY': Function(type='int', derefcnt=0, name='i2d_DSA_PUBKEY', args=[Argument(type='DSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_DSA_PUBKEY_bio': Function(type='int', derefcnt=0, name='i2d_DSA_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'i2d_DSA_PUBKEY_fp': Function(type='int', derefcnt=0, name='i2d_DSA_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='DSA', derefcnt=1, name='dsa')]),
 'i2d_DSA_SIG': Function(type='int', derefcnt=0, name='i2d_DSA_SIG', args=[Argument(type='DSA_SIG', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_DSAparams': Function(type='int', derefcnt=0, name='i2d_DSAparams', args=[Argument(type='DSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_ECDSA_SIG': Function(type='int', derefcnt=0, name='i2d_ECDSA_SIG', args=[Argument(type='ECDSA_SIG', derefcnt=1, name='sig'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_ECPKParameters': Function(type='int', derefcnt=0, name='i2d_ECPKParameters', args=[Argument(type='EC_GROUP', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ECParameters': Function(type='int', derefcnt=0, name='i2d_ECParameters', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ECPrivateKey': Function(type='int', derefcnt=0, name='i2d_ECPrivateKey', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_ECPrivateKey_bio': Function(type='int', derefcnt=0, name='i2d_ECPrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'i2d_ECPrivateKey_fp': Function(type='int', derefcnt=0, name='i2d_ECPrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'i2d_EC_PUBKEY': Function(type='int', derefcnt=0, name='i2d_EC_PUBKEY', args=[Argument(type='EC_KEY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_EC_PUBKEY_bio': Function(type='int', derefcnt=0, name='i2d_EC_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'i2d_EC_PUBKEY_fp': Function(type='int', derefcnt=0, name='i2d_EC_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EC_KEY', derefcnt=1, name='eckey')]),
 'i2d_NETSCAPE_CERT_SEQUENCE': Function(type='int', derefcnt=0, name='i2d_NETSCAPE_CERT_SEQUENCE', args=[Argument(type='NETSCAPE_CERT_SEQUENCE', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_NETSCAPE_SPKAC': Function(type='int', derefcnt=0, name='i2d_NETSCAPE_SPKAC', args=[Argument(type='NETSCAPE_SPKAC', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_NETSCAPE_SPKI': Function(type='int', derefcnt=0, name='i2d_NETSCAPE_SPKI', args=[Argument(type='NETSCAPE_SPKI', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_NETSCAPE_X509': Function(type='int', derefcnt=0, name='i2d_NETSCAPE_X509', args=[Argument(type='NETSCAPE_X509', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_Netscape_RSA': Function(type='int', derefcnt=0, name='i2d_Netscape_RSA', args=[Argument(type='RSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='int', derefcnt=0, name='cb')]),
 'i2d_PBE2PARAM': Function(type='int', derefcnt=0, name='i2d_PBE2PARAM', args=[Argument(type='PBE2PARAM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PBEPARAM': Function(type='int', derefcnt=0, name='i2d_PBEPARAM', args=[Argument(type='PBEPARAM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PBKDF2PARAM': Function(type='int', derefcnt=0, name='i2d_PBKDF2PARAM', args=[Argument(type='PBKDF2PARAM', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7': Function(type='int', derefcnt=0, name='i2d_PKCS7', args=[Argument(type='PKCS7', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_DIGEST': Function(type='int', derefcnt=0, name='i2d_PKCS7_DIGEST', args=[Argument(type='PKCS7_DIGEST', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_ENCRYPT': Function(type='int', derefcnt=0, name='i2d_PKCS7_ENCRYPT', args=[Argument(type='PKCS7_ENCRYPT', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_ENC_CONTENT': Function(type='int', derefcnt=0, name='i2d_PKCS7_ENC_CONTENT', args=[Argument(type='PKCS7_ENC_CONTENT', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_ENVELOPE': Function(type='int', derefcnt=0, name='i2d_PKCS7_ENVELOPE', args=[Argument(type='PKCS7_ENVELOPE', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_ISSUER_AND_SERIAL': Function(type='int', derefcnt=0, name='i2d_PKCS7_ISSUER_AND_SERIAL', args=[Argument(type='PKCS7_ISSUER_AND_SERIAL', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_NDEF': Function(type='int', derefcnt=0, name='i2d_PKCS7_NDEF', args=[Argument(type='PKCS7', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_RECIP_INFO': Function(type='int', derefcnt=0, name='i2d_PKCS7_RECIP_INFO', args=[Argument(type='PKCS7_RECIP_INFO', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_SIGNED': Function(type='int', derefcnt=0, name='i2d_PKCS7_SIGNED', args=[Argument(type='PKCS7_SIGNED', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_SIGNER_INFO': Function(type='int', derefcnt=0, name='i2d_PKCS7_SIGNER_INFO', args=[Argument(type='PKCS7_SIGNER_INFO', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_SIGN_ENVELOPE': Function(type='int', derefcnt=0, name='i2d_PKCS7_SIGN_ENVELOPE', args=[Argument(type='PKCS7_SIGN_ENVELOPE', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS7_bio': Function(type='int', derefcnt=0, name='i2d_PKCS7_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS7', derefcnt=1, name='p7')]),
 'i2d_PKCS7_bio_stream': Function(type='int', derefcnt=0, name='i2d_PKCS7_bio_stream', args=[Argument(type='BIO', derefcnt=1, name='out'), Argument(type='PKCS7', derefcnt=1, name='p7'), Argument(type='BIO', derefcnt=1, name='in'), Argument(type='int', derefcnt=0, name='flags')]),
 'i2d_PKCS7_fp': Function(type='int', derefcnt=0, name='i2d_PKCS7_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS7', derefcnt=1, name='p7')]),
 'i2d_PKCS8PrivateKeyInfo_bio': Function(type='int', derefcnt=0, name='i2d_PKCS8PrivateKeyInfo_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='key')]),
 'i2d_PKCS8PrivateKeyInfo_fp': Function(type='int', derefcnt=0, name='i2d_PKCS8PrivateKeyInfo_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='key')]),
 'i2d_PKCS8PrivateKey_bio': Function(type='int', derefcnt=0, name='i2d_PKCS8PrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='char', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'i2d_PKCS8PrivateKey_fp': Function(type='int', derefcnt=0, name='i2d_PKCS8PrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='EVP_CIPHER', derefcnt=1, name='enc'), Argument(type='char', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'i2d_PKCS8PrivateKey_nid_bio': Function(type='int', derefcnt=0, name='i2d_PKCS8PrivateKey_nid_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='char', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'i2d_PKCS8PrivateKey_nid_fp': Function(type='int', derefcnt=0, name='i2d_PKCS8PrivateKey_nid_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='x'), Argument(type='int', derefcnt=0, name='nid'), Argument(type='char', derefcnt=1, name='kstr'), Argument(type='int', derefcnt=0, name='klen'), Argument(type='pem_password_cb', derefcnt=1, name='cb'), Argument(type='void', derefcnt=1, name='u')]),
 'i2d_PKCS8_PRIV_KEY_INFO': Function(type='int', derefcnt=0, name='i2d_PKCS8_PRIV_KEY_INFO', args=[Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_PKCS8_PRIV_KEY_INFO_bio': Function(type='int', derefcnt=0, name='i2d_PKCS8_PRIV_KEY_INFO_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='p8inf')]),
 'i2d_PKCS8_PRIV_KEY_INFO_fp': Function(type='int', derefcnt=0, name='i2d_PKCS8_PRIV_KEY_INFO_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='PKCS8_PRIV_KEY_INFO', derefcnt=1, name='p8inf')]),
 'i2d_PKCS8_bio': Function(type='int', derefcnt=0, name='i2d_PKCS8_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_SIG', derefcnt=1, name='p8')]),
 'i2d_PKCS8_fp': Function(type='int', derefcnt=0, name='i2d_PKCS8_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_SIG', derefcnt=1, name='p8')]),
 'i2d_PUBKEY': Function(type='int', derefcnt=0, name='i2d_PUBKEY', args=[Argument(type='EVP_PKEY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_PUBKEY_bio': Function(type='int', derefcnt=0, name='i2d_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'i2d_PUBKEY_fp': Function(type='int', derefcnt=0, name='i2d_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'i2d_PrivateKey': Function(type='int', derefcnt=0, name='i2d_PrivateKey', args=[Argument(type='EVP_PKEY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_PrivateKey_bio': Function(type='int', derefcnt=0, name='i2d_PrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'i2d_PrivateKey_fp': Function(type='int', derefcnt=0, name='i2d_PrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='EVP_PKEY', derefcnt=1, name='pkey')]),
 'i2d_PublicKey': Function(type='int', derefcnt=0, name='i2d_PublicKey', args=[Argument(type='EVP_PKEY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_RSAPrivateKey': Function(type='int', derefcnt=0, name='i2d_RSAPrivateKey', args=[Argument(type='RSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_RSAPrivateKey_bio': Function(type='int', derefcnt=0, name='i2d_RSAPrivateKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'i2d_RSAPrivateKey_fp': Function(type='int', derefcnt=0, name='i2d_RSAPrivateKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'i2d_RSAPublicKey': Function(type='int', derefcnt=0, name='i2d_RSAPublicKey', args=[Argument(type='RSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_RSAPublicKey_bio': Function(type='int', derefcnt=0, name='i2d_RSAPublicKey_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'i2d_RSAPublicKey_fp': Function(type='int', derefcnt=0, name='i2d_RSAPublicKey_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'i2d_RSA_NET': Function(type='int', derefcnt=0, name='i2d_RSA_NET', args=[Argument(type='RSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp'), Argument(type='int', derefcnt=0, name='cb'), Argument(type='int', derefcnt=0, name='sgckey')]),
 'i2d_RSA_PSS_PARAMS': Function(type='int', derefcnt=0, name='i2d_RSA_PSS_PARAMS', args=[Argument(type='RSA_PSS_PARAMS', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_RSA_PUBKEY': Function(type='int', derefcnt=0, name='i2d_RSA_PUBKEY', args=[Argument(type='RSA', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_RSA_PUBKEY_bio': Function(type='int', derefcnt=0, name='i2d_RSA_PUBKEY_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'i2d_RSA_PUBKEY_fp': Function(type='int', derefcnt=0, name='i2d_RSA_PUBKEY_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'i2d_SSL_SESSION': Function(type='int', derefcnt=0, name='i2d_SSL_SESSION', args=[Argument(type='SSL_SESSION', derefcnt=1, name='in'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_X509': Function(type='int', derefcnt=0, name='i2d_X509', args=[Argument(type='X509', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_ALGOR': Function(type='int', derefcnt=0, name='i2d_X509_ALGOR', args=[Argument(type='X509_ALGOR', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_ALGORS': Function(type='int', derefcnt=0, name='i2d_X509_ALGORS', args=[Argument(type='X509_ALGORS', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_ATTRIBUTE': Function(type='int', derefcnt=0, name='i2d_X509_ATTRIBUTE', args=[Argument(type='X509_ATTRIBUTE', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_AUX': Function(type='int', derefcnt=0, name='i2d_X509_AUX', args=[Argument(type='X509', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_X509_CERT_AUX': Function(type='int', derefcnt=0, name='i2d_X509_CERT_AUX', args=[Argument(type='X509_CERT_AUX', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_CERT_PAIR': Function(type='int', derefcnt=0, name='i2d_X509_CERT_PAIR', args=[Argument(type='X509_CERT_PAIR', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_CINF': Function(type='int', derefcnt=0, name='i2d_X509_CINF', args=[Argument(type='X509_CINF', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_CRL': Function(type='int', derefcnt=0, name='i2d_X509_CRL', args=[Argument(type='X509_CRL', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_CRL_INFO': Function(type='int', derefcnt=0, name='i2d_X509_CRL_INFO', args=[Argument(type='X509_CRL_INFO', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_CRL_bio': Function(type='int', derefcnt=0, name='i2d_X509_CRL_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_CRL', derefcnt=1, name='crl')]),
 'i2d_X509_CRL_fp': Function(type='int', derefcnt=0, name='i2d_X509_CRL_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_CRL', derefcnt=1, name='crl')]),
 'i2d_X509_EXTENSION': Function(type='int', derefcnt=0, name='i2d_X509_EXTENSION', args=[Argument(type='X509_EXTENSION', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_EXTENSIONS': Function(type='int', derefcnt=0, name='i2d_X509_EXTENSIONS', args=[Argument(type='X509_EXTENSIONS', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_NAME': Function(type='int', derefcnt=0, name='i2d_X509_NAME', args=[Argument(type='X509_NAME', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_NAME_ENTRY': Function(type='int', derefcnt=0, name='i2d_X509_NAME_ENTRY', args=[Argument(type='X509_NAME_ENTRY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_PKEY': Function(type='int', derefcnt=0, name='i2d_X509_PKEY', args=[Argument(type='X509_PKEY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='pp')]),
 'i2d_X509_PUBKEY': Function(type='int', derefcnt=0, name='i2d_X509_PUBKEY', args=[Argument(type='X509_PUBKEY', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_REQ': Function(type='int', derefcnt=0, name='i2d_X509_REQ', args=[Argument(type='X509_REQ', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_REQ_INFO': Function(type='int', derefcnt=0, name='i2d_X509_REQ_INFO', args=[Argument(type='X509_REQ_INFO', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_REQ_bio': Function(type='int', derefcnt=0, name='i2d_X509_REQ_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'i2d_X509_REQ_fp': Function(type='int', derefcnt=0, name='i2d_X509_REQ_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509_REQ', derefcnt=1, name='req')]),
 'i2d_X509_REVOKED': Function(type='int', derefcnt=0, name='i2d_X509_REVOKED', args=[Argument(type='X509_REVOKED', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_SIG': Function(type='int', derefcnt=0, name='i2d_X509_SIG', args=[Argument(type='X509_SIG', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_VAL': Function(type='int', derefcnt=0, name='i2d_X509_VAL', args=[Argument(type='X509_VAL', derefcnt=1, name='a'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2d_X509_bio': Function(type='int', derefcnt=0, name='i2d_X509_bio', args=[Argument(type='BIO', derefcnt=1, name='bp'), Argument(type='X509', derefcnt=1, name='x509')]),
 'i2d_X509_fp': Function(type='int', derefcnt=0, name='i2d_X509_fp', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='X509', derefcnt=1, name='x509')]),
 'i2d_of_void': Function(type='int', derefcnt=0, name='i2d_of_void', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=2, name='arg1')]),
 'i2o_ECPublicKey': Function(type='int', derefcnt=0, name='i2o_ECPublicKey', args=[Argument(type='EC_KEY', derefcnt=1, name='key'), Argument(type='unsigned', derefcnt=2, name='out')]),
 'i2t_ASN1_OBJECT': Function(type='int', derefcnt=0, name='i2t_ASN1_OBJECT', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='buf_len'), Argument(type='ASN1_OBJECT', derefcnt=1, name='a')]),
 'iconv': Function(type='size_t', derefcnt=0, name='iconv', args=[Argument(type='iconv_t', derefcnt=0, name='cd'), Argument(type='char', derefcnt=2, name='inbuf'), Argument(type='size_t', derefcnt=1, name='inbytesleft'), Argument(type='char', derefcnt=2, name='outbuf'), Argument(type='size_t', derefcnt=1, name='outbytesleft')]),
 'iconv_close': Function(type='int', derefcnt=0, name='iconv_close', args=[Argument(type='iconv_t', derefcnt=0, name='cd')]),
 'iconv_open': Function(type='iconv_t', derefcnt=0, name='iconv_open', args=[Argument(type='char', derefcnt=1, name='tocode'), Argument(type='char', derefcnt=1, name='fromcode')]),
 'ilogb': Function(type='int', derefcnt=0, name='ilogb', args=[Argument(type='double', derefcnt=0, name='x')]),
 'ilogbf': Function(type='int', derefcnt=0, name='ilogbf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'ilogbl': Function(type='int', derefcnt=0, name='ilogbl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'imaxabs': Function(type='intmax_t', derefcnt=0, name='imaxabs', args=[Argument(type='intmax_t', derefcnt=0, name='n')]),
 'imaxdiv': Function(type='imaxdiv_t', derefcnt=0, name='imaxdiv', args=[Argument(type='intmax_t', derefcnt=0, name='numer'), Argument(type='intmax_t', derefcnt=0, name='denom')]),
 'in_func': Function(type='unsigned', derefcnt=0, name='in_func', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=2, name='arg1')]),
 'inb': Function(type='unsigned', derefcnt=0, name='inb', args=[Argument(type='unsigned', derefcnt=0, name='port')]),
 'inb_p': Function(type='unsigned', derefcnt=0, name='inb_p', args=[Argument(type='unsigned', derefcnt=0, name='port')]),
 'index': Function(type='char', derefcnt=1, name='index', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c')]),
 'inet6_opt_append': Function(type='int', derefcnt=0, name='inet6_opt_append', args=[Argument(type='void', derefcnt=1, name='extbuf'), Argument(type='socklen_t', derefcnt=0, name='extlen'), Argument(type='int', derefcnt=0, name='offset'), Argument(type='uint8_t', derefcnt=0, name='type'), Argument(type='socklen_t', derefcnt=0, name='len'), Argument(type='uint8_t', derefcnt=0, name='align'), Argument(type='void', derefcnt=2, name='databufp')]),
 'inet6_opt_find': Function(type='int', derefcnt=0, name='inet6_opt_find', args=[Argument(type='void', derefcnt=1, name='extbuf'), Argument(type='socklen_t', derefcnt=0, name='extlen'), Argument(type='int', derefcnt=0, name='offset'), Argument(type='uint8_t', derefcnt=0, name='type'), Argument(type='socklen_t', derefcnt=1, name='lenp'), Argument(type='void', derefcnt=2, name='databufp')]),
 'inet6_opt_finish': Function(type='int', derefcnt=0, name='inet6_opt_finish', args=[Argument(type='void', derefcnt=1, name='extbuf'), Argument(type='socklen_t', derefcnt=0, name='extlen'), Argument(type='int', derefcnt=0, name='offset')]),
 'inet6_opt_get_val': Function(type='int', derefcnt=0, name='inet6_opt_get_val', args=[Argument(type='void', derefcnt=1, name='databuf'), Argument(type='int', derefcnt=0, name='offset'), Argument(type='void', derefcnt=1, name='val'), Argument(type='socklen_t', derefcnt=0, name='vallen')]),
 'inet6_opt_init': Function(type='int', derefcnt=0, name='inet6_opt_init', args=[Argument(type='void', derefcnt=1, name='extbuf'), Argument(type='socklen_t', derefcnt=0, name='extlen')]),
 'inet6_opt_next': Function(type='int', derefcnt=0, name='inet6_opt_next', args=[Argument(type='void', derefcnt=1, name='extbuf'), Argument(type='socklen_t', derefcnt=0, name='extlen'), Argument(type='int', derefcnt=0, name='offset'), Argument(type='uint8_t', derefcnt=1, name='typep'), Argument(type='socklen_t', derefcnt=1, name='lenp'), Argument(type='void', derefcnt=2, name='databufp')]),
 'inet6_opt_set_val': Function(type='int', derefcnt=0, name='inet6_opt_set_val', args=[Argument(type='void', derefcnt=1, name='databuf'), Argument(type='int', derefcnt=0, name='offset'), Argument(type='void', derefcnt=1, name='val'), Argument(type='socklen_t', derefcnt=0, name='vallen')]),
 'inet6_option_alloc': Function(type='uint8_t', derefcnt=1, name='inet6_option_alloc', args=[Argument(type='cmsghdr', derefcnt=1, name='cmsg'), Argument(type='int', derefcnt=0, name='datalen'), Argument(type='int', derefcnt=0, name='multx'), Argument(type='int', derefcnt=0, name='plusy')]),
 'inet6_option_append': Function(type='int', derefcnt=0, name='inet6_option_append', args=[Argument(type='cmsghdr', derefcnt=1, name='cmsg'), Argument(type='uint8_t', derefcnt=1, name='typep'), Argument(type='int', derefcnt=0, name='multx'), Argument(type='int', derefcnt=0, name='plusy')]),
 'inet6_option_find': Function(type='int', derefcnt=0, name='inet6_option_find', args=[Argument(type='cmsghdr', derefcnt=1, name='cmsg'), Argument(type='uint8_t', derefcnt=2, name='tptrp'), Argument(type='int', derefcnt=0, name='type')]),
 'inet6_option_init': Function(type='int', derefcnt=0, name='inet6_option_init', args=[Argument(type='void', derefcnt=1, name='bp'), Argument(type='cmsghdr', derefcnt=2, name='cmsgp'), Argument(type='int', derefcnt=0, name='type')]),
 'inet6_option_next': Function(type='int', derefcnt=0, name='inet6_option_next', args=[Argument(type='cmsghdr', derefcnt=1, name='cmsg'), Argument(type='uint8_t', derefcnt=2, name='tptrp')]),
 'inet6_option_space': Function(type='int', derefcnt=0, name='inet6_option_space', args=[Argument(type='int', derefcnt=0, name='nbytes')]),
 'inet6_rth_add': Function(type='int', derefcnt=0, name='inet6_rth_add', args=[Argument(type='void', derefcnt=1, name='bp'), Argument(type='in6_addr', derefcnt=1, name='addr')]),
 'inet6_rth_getaddr': Function(type='in6_addr', derefcnt=1, name='inet6_rth_getaddr', args=[Argument(type='void', derefcnt=1, name='bp'), Argument(type='int', derefcnt=0, name='index')]),
 'inet6_rth_init': Function(type='void', derefcnt=1, name='inet6_rth_init', args=[Argument(type='void', derefcnt=1, name='bp'), Argument(type='socklen_t', derefcnt=0, name='bp_len'), Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='segments')]),
 'inet6_rth_reverse': Function(type='int', derefcnt=0, name='inet6_rth_reverse', args=[Argument(type='void', derefcnt=1, name='in'), Argument(type='void', derefcnt=1, name='out')]),
 'inet6_rth_segments': Function(type='int', derefcnt=0, name='inet6_rth_segments', args=[Argument(type='void', derefcnt=1, name='bp')]),
 'inet6_rth_space': Function(type='socklen_t', derefcnt=0, name='inet6_rth_space', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='segments')]),
 'inflate': Function(type='int', derefcnt=0, name='inflate', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='flush')]),
 'inflateBack': Function(type='int', derefcnt=0, name='inflateBack', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='in_func', derefcnt=0, name='in'), Argument(type='void', derefcnt=1, name='in_desc'), Argument(type='out_func', derefcnt=0, name='out'), Argument(type='void', derefcnt=1, name='out_desc')]),
 'inflateBackEnd': Function(type='int', derefcnt=0, name='inflateBackEnd', args=[Argument(type='z_streamp', derefcnt=0, name='strm')]),
 'inflateBackInit_': Function(type='int', derefcnt=0, name='inflateBackInit_', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='windowBits'), Argument(type='unsigned', derefcnt=1, name='window'), Argument(type='char', derefcnt=1, name='version'), Argument(type='int', derefcnt=0, name='stream_size')]),
 'inflateCopy': Function(type='int', derefcnt=0, name='inflateCopy', args=[Argument(type='z_streamp', derefcnt=0, name='dest'), Argument(type='z_streamp', derefcnt=0, name='source')]),
 'inflateEnd': Function(type='int', derefcnt=0, name='inflateEnd', args=[Argument(type='z_streamp', derefcnt=0, name='strm')]),
 'inflateGetDictionary': Function(type='int', derefcnt=0, name='inflateGetDictionary', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='Bytef', derefcnt=1, name='dictionary'), Argument(type='uInt', derefcnt=1, name='dictLength')]),
 'inflateGetHeader': Function(type='int', derefcnt=0, name='inflateGetHeader', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='gz_headerp', derefcnt=0, name='head')]),
 'inflateInit2_': Function(type='int', derefcnt=0, name='inflateInit2_', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='windowBits'), Argument(type='char', derefcnt=1, name='version'), Argument(type='int', derefcnt=0, name='stream_size')]),
 'inflateInit_': Function(type='int', derefcnt=0, name='inflateInit_', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='char', derefcnt=1, name='version'), Argument(type='int', derefcnt=0, name='stream_size')]),
 'inflateMark': Function(type='long', derefcnt=0, name='inflateMark', args=[Argument(type='z_streamp', derefcnt=0, name='strm')]),
 'inflatePrime': Function(type='int', derefcnt=0, name='inflatePrime', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='int', derefcnt=0, name='value')]),
 'inflateReset': Function(type='int', derefcnt=0, name='inflateReset', args=[Argument(type='z_streamp', derefcnt=0, name='strm')]),
 'inflateReset2': Function(type='int', derefcnt=0, name='inflateReset2', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='int', derefcnt=0, name='windowBits')]),
 'inflateResetKeep': Function(type='int', derefcnt=0, name='inflateResetKeep', args=[Argument(type='z_streamp', derefcnt=0, name='arg0')]),
 'inflateSetDictionary': Function(type='int', derefcnt=0, name='inflateSetDictionary', args=[Argument(type='z_streamp', derefcnt=0, name='strm'), Argument(type='Bytef', derefcnt=1, name='dictionary'), Argument(type='uInt', derefcnt=0, name='dictLength')]),
 'inflateSync': Function(type='int', derefcnt=0, name='inflateSync', args=[Argument(type='z_streamp', derefcnt=0, name='strm')]),
 'inflateSyncPoint': Function(type='int', derefcnt=0, name='inflateSyncPoint', args=[Argument(type='z_streamp', derefcnt=0, name='arg0')]),
 'inflateUndermine': Function(type='int', derefcnt=0, name='inflateUndermine', args=[Argument(type='z_streamp', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'info_callback': Function(type='void', derefcnt=0, name='info_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='val')]),
 'init': Function(type='int', derefcnt=0, name='init', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx')]),
 'initgroups': Function(type='int', derefcnt=0, name='initgroups', args=[Argument(type='char', derefcnt=1, name='user'), Argument(type='gid_t', derefcnt=0, name='group')]),
 'initstate': Function(type='char', derefcnt=1, name='initstate', args=[Argument(type='unsigned', derefcnt=0, name='seed'), Argument(type='char', derefcnt=1, name='statebuf'), Argument(type='size_t', derefcnt=0, name='statelen')]),
 'initstate_r': Function(type='int', derefcnt=0, name='initstate_r', args=[Argument(type='unsigned', derefcnt=0, name='seed'), Argument(type='char', derefcnt=1, name='statebuf'), Argument(type='size_t', derefcnt=0, name='statelen'), Argument(type='random_data', derefcnt=1, name='buf')]),
 'inl': Function(type='unsigned', derefcnt=0, name='inl', args=[Argument(type='unsigned', derefcnt=0, name='port')]),
 'inl_p': Function(type='unsigned', derefcnt=0, name='inl_p', args=[Argument(type='unsigned', derefcnt=0, name='port')]),
 'innetgr': Function(type='int', derefcnt=0, name='innetgr', args=[Argument(type='char', derefcnt=1, name='netgroup'), Argument(type='char', derefcnt=1, name='host'), Argument(type='char', derefcnt=1, name='user'), Argument(type='char', derefcnt=1, name='domain')]),
 'insb': Function(type='void', derefcnt=0, name='insb', args=[Argument(type='unsigned', derefcnt=0, name='port'), Argument(type='void', derefcnt=1, name='addr'), Argument(type='unsigned', derefcnt=0, name='count')]),
 'insl': Function(type='void', derefcnt=0, name='insl', args=[Argument(type='unsigned', derefcnt=0, name='port'), Argument(type='void', derefcnt=1, name='addr'), Argument(type='unsigned', derefcnt=0, name='count')]),
 'insque': Function(type='void', derefcnt=0, name='insque', args=[Argument(type='void', derefcnt=1, name='elem'), Argument(type='void', derefcnt=1, name='prev')]),
 'insw': Function(type='void', derefcnt=0, name='insw', args=[Argument(type='unsigned', derefcnt=0, name='port'), Argument(type='void', derefcnt=1, name='addr'), Argument(type='unsigned', derefcnt=0, name='count')]),
 'inw': Function(type='unsigned', derefcnt=0, name='inw', args=[Argument(type='unsigned', derefcnt=0, name='port')]),
 'inw_p': Function(type='unsigned', derefcnt=0, name='inw_p', args=[Argument(type='unsigned', derefcnt=0, name='port')]),
 'io_close_fn': Function(type='int', derefcnt=0, name='io_close_fn', args=[Argument(type='void', derefcnt=1, name='cookie')]),
 'io_read_fn': Function(type='ssize_t', derefcnt=0, name='io_read_fn', args=[Argument(type='void', derefcnt=1, name='cookie'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes')]),
 'io_seek_fn': Function(type='int', derefcnt=0, name='io_seek_fn', args=[Argument(type='void', derefcnt=1, name='cookie'), Argument(type='off64_t', derefcnt=1, name='pos'), Argument(type='int', derefcnt=0, name='w')]),
 'io_write_fn': Function(type='ssize_t', derefcnt=0, name='io_write_fn', args=[Argument(type='void', derefcnt=1, name='cookie'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n')]),
 'ioctl': Function(type='int', derefcnt=0, name='ioctl', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='unsigned', derefcnt=0, name='request'), Argument(type='int', derefcnt=0, name='vararg')]),
 'ioperm': Function(type='int', derefcnt=0, name='ioperm', args=[Argument(type='unsigned', derefcnt=0, name='from'), Argument(type='unsigned', derefcnt=0, name='num'), Argument(type='int', derefcnt=0, name='turn_on')]),
 'iopl': Function(type='int', derefcnt=0, name='iopl', args=[Argument(type='int', derefcnt=0, name='level')]),
 'iruserok': Function(type='int', derefcnt=0, name='iruserok', args=[Argument(type='uint32_t', derefcnt=0, name='raddr'), Argument(type='int', derefcnt=0, name='suser'), Argument(type='char', derefcnt=1, name='remuser'), Argument(type='char', derefcnt=1, name='locuser')]),
 'iruserok_af': Function(type='int', derefcnt=0, name='iruserok_af', args=[Argument(type='void', derefcnt=1, name='raddr'), Argument(type='int', derefcnt=0, name='suser'), Argument(type='char', derefcnt=1, name='remuser'), Argument(type='char', derefcnt=1, name='locuser'), Argument(type='sa_family_t', derefcnt=0, name='af')]),
 'isalnum': Function(type='int', derefcnt=0, name='isalnum', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isalnum_l': Function(type='int', derefcnt=0, name='isalnum_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'isalpha': Function(type='int', derefcnt=0, name='isalpha', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isalpha_l': Function(type='int', derefcnt=0, name='isalpha_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'isascii': Function(type='int', derefcnt=0, name='isascii', args=[Argument(type='int', derefcnt=0, name='c')]),
 'isastream': Function(type='int', derefcnt=0, name='isastream', args=[Argument(type='int', derefcnt=0, name='fildes')]),
 'isatty': Function(type='int', derefcnt=0, name='isatty', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'isblank': Function(type='int', derefcnt=0, name='isblank', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isblank_l': Function(type='int', derefcnt=0, name='isblank_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'iscntrl': Function(type='int', derefcnt=0, name='iscntrl', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'iscntrl_l': Function(type='int', derefcnt=0, name='iscntrl_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'isctype': Function(type='int', derefcnt=0, name='isctype', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='int', derefcnt=0, name='mask')]),
 'isdigit': Function(type='int', derefcnt=0, name='isdigit', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isdigit_l': Function(type='int', derefcnt=0, name='isdigit_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'isfdtype': Function(type='int', derefcnt=0, name='isfdtype', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='fdtype')]),
 'isgraph': Function(type='int', derefcnt=0, name='isgraph', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isgraph_l': Function(type='int', derefcnt=0, name='isgraph_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'isinf': Function(type='int', derefcnt=0, name='isinf', args=[Argument(type='double', derefcnt=0, name='value')]),
 'isinff': Function(type='int', derefcnt=0, name='isinff', args=[Argument(type='float', derefcnt=0, name='value')]),
 'isinfl': Function(type='int', derefcnt=0, name='isinfl', args=[Argument(type='long', derefcnt=0, name='value')]),
 'islower': Function(type='int', derefcnt=0, name='islower', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'islower_l': Function(type='int', derefcnt=0, name='islower_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'isnan': Function(type='int', derefcnt=0, name='isnan', args=[Argument(type='double', derefcnt=0, name='value')]),
 'isnanf': Function(type='int', derefcnt=0, name='isnanf', args=[Argument(type='float', derefcnt=0, name='value')]),
 'isnanl': Function(type='int', derefcnt=0, name='isnanl', args=[Argument(type='long', derefcnt=0, name='value')]),
 'isprint': Function(type='int', derefcnt=0, name='isprint', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isprint_l': Function(type='int', derefcnt=0, name='isprint_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'ispunct': Function(type='int', derefcnt=0, name='ispunct', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'ispunct_l': Function(type='int', derefcnt=0, name='ispunct_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'issignaling': Function(type='int', derefcnt=0, name='issignaling', args=[Argument(type='double', derefcnt=0, name='value')]),
 'issignalingf': Function(type='int', derefcnt=0, name='issignalingf', args=[Argument(type='float', derefcnt=0, name='value')]),
 'issignalingl': Function(type='int', derefcnt=0, name='issignalingl', args=[Argument(type='long', derefcnt=0, name='value')]),
 'isspace': Function(type='int', derefcnt=0, name='isspace', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isspace_l': Function(type='int', derefcnt=0, name='isspace_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'isupper': Function(type='int', derefcnt=0, name='isupper', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isupper_l': Function(type='int', derefcnt=0, name='isupper_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'iswalnum': Function(type='int', derefcnt=0, name='iswalnum', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswalnum_l': Function(type='int', derefcnt=0, name='iswalnum_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswalpha': Function(type='int', derefcnt=0, name='iswalpha', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswalpha_l': Function(type='int', derefcnt=0, name='iswalpha_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswblank': Function(type='int', derefcnt=0, name='iswblank', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswblank_l': Function(type='int', derefcnt=0, name='iswblank_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswcntrl': Function(type='int', derefcnt=0, name='iswcntrl', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswcntrl_l': Function(type='int', derefcnt=0, name='iswcntrl_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswctype': Function(type='int', derefcnt=0, name='iswctype', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='wctype_t', derefcnt=0, name='desc')]),
 'iswctype_l': Function(type='int', derefcnt=0, name='iswctype_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='wctype_t', derefcnt=0, name='desc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswdigit': Function(type='int', derefcnt=0, name='iswdigit', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswdigit_l': Function(type='int', derefcnt=0, name='iswdigit_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswgraph': Function(type='int', derefcnt=0, name='iswgraph', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswgraph_l': Function(type='int', derefcnt=0, name='iswgraph_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswlower': Function(type='int', derefcnt=0, name='iswlower', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswlower_l': Function(type='int', derefcnt=0, name='iswlower_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswprint': Function(type='int', derefcnt=0, name='iswprint', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswprint_l': Function(type='int', derefcnt=0, name='iswprint_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswpunct': Function(type='int', derefcnt=0, name='iswpunct', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswpunct_l': Function(type='int', derefcnt=0, name='iswpunct_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswspace': Function(type='int', derefcnt=0, name='iswspace', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswspace_l': Function(type='int', derefcnt=0, name='iswspace_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswupper': Function(type='int', derefcnt=0, name='iswupper', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswupper_l': Function(type='int', derefcnt=0, name='iswupper_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'iswxdigit': Function(type='int', derefcnt=0, name='iswxdigit', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'iswxdigit_l': Function(type='int', derefcnt=0, name='iswxdigit_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'isxdigit': Function(type='int', derefcnt=0, name='isxdigit', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'isxdigit_l': Function(type='int', derefcnt=0, name='isxdigit_l', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='locale_t', derefcnt=0, name='arg1')]),
 'j0': Function(type='double', derefcnt=0, name='j0', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'j0f': Function(type='float', derefcnt=0, name='j0f', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'j0l': Function(type='long', derefcnt=0, name='j0l', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'j1': Function(type='double', derefcnt=0, name='j1', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'j1f': Function(type='float', derefcnt=0, name='j1f', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'j1l': Function(type='long', derefcnt=0, name='j1l', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'jn': Function(type='double', derefcnt=0, name='jn', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='double', derefcnt=0, name='arg1')]),
 'jnf': Function(type='float', derefcnt=0, name='jnf', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='float', derefcnt=0, name='arg1')]),
 'jnl': Function(type='long', derefcnt=0, name='jnl', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='long', derefcnt=0, name='arg1')]),
 'jrand48': Function(type='long', derefcnt=0, name='jrand48', args=[Argument(type='unsigned', derefcnt=1, name='xsubi')]),
 'jrand48_r': Function(type='int', derefcnt=0, name='jrand48_r', args=[Argument(type='unsigned', derefcnt=1, name='xsubi'), Argument(type='drand48_data', derefcnt=1, name='buffer'), Argument(type='long', derefcnt=1, name='result')]),
 'kill': Function(type='int', derefcnt=0, name='kill', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='int', derefcnt=0, name='sig')]),
 'killpg': Function(type='int', derefcnt=0, name='killpg', args=[Argument(type='pid_t', derefcnt=0, name='pgrp'), Argument(type='int', derefcnt=0, name='sig')]),
 'l64a': Function(type='char', derefcnt=1, name='l64a', args=[Argument(type='long', derefcnt=0, name='n')]),
 'la_activity': Function(type='void', derefcnt=0, name='la_activity', args=[Argument(type='uintptr_t', derefcnt=1, name='cookie'), Argument(type='unsigned', derefcnt=0, name='flag')]),
 'la_objclose': Function(type='unsigned', derefcnt=0, name='la_objclose', args=[Argument(type='uintptr_t', derefcnt=1, name='cookie')]),
 'la_objopen': Function(type='unsigned', derefcnt=0, name='la_objopen', args=[Argument(type='link_map', derefcnt=1, name='map'), Argument(type='Lmid_t', derefcnt=0, name='lmid'), Argument(type='uintptr_t', derefcnt=1, name='cookie')]),
 'la_objsearch': Function(type='char', derefcnt=1, name='la_objsearch', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='uintptr_t', derefcnt=1, name='cookie'), Argument(type='unsigned', derefcnt=0, name='flag')]),
 'la_preinit': Function(type='void', derefcnt=0, name='la_preinit', args=[Argument(type='uintptr_t', derefcnt=1, name='cookie')]),
 'la_symbind32': Function(type='uintptr_t', derefcnt=0, name='la_symbind32', args=[Argument(type='Elf32_Sym', derefcnt=1, name='sym'), Argument(type='unsigned', derefcnt=0, name='ndx'), Argument(type='uintptr_t', derefcnt=1, name='refcook'), Argument(type='uintptr_t', derefcnt=1, name='defcook'), Argument(type='unsigned', derefcnt=1, name='flags'), Argument(type='char', derefcnt=1, name='symname')]),
 'la_symbind64': Function(type='uintptr_t', derefcnt=0, name='la_symbind64', args=[Argument(type='Elf64_Sym', derefcnt=1, name='sym'), Argument(type='unsigned', derefcnt=0, name='ndx'), Argument(type='uintptr_t', derefcnt=1, name='refcook'), Argument(type='uintptr_t', derefcnt=1, name='defcook'), Argument(type='unsigned', derefcnt=1, name='flags'), Argument(type='char', derefcnt=1, name='symname')]),
 'la_version': Function(type='unsigned', derefcnt=0, name='la_version', args=[Argument(type='unsigned', derefcnt=0, name='version')]),
 'la_x32_gnu_pltenter': Function(type='Elf32_Addr', derefcnt=0, name='la_x32_gnu_pltenter', args=[Argument(type='Elf32_Sym', derefcnt=1, name='sym'), Argument(type='unsigned', derefcnt=0, name='ndx'), Argument(type='uintptr_t', derefcnt=1, name='refcook'), Argument(type='uintptr_t', derefcnt=1, name='defcook'), Argument(type='La_x86_64_regs', derefcnt=1, name='regs'), Argument(type='unsigned', derefcnt=1, name='flags'), Argument(type='char', derefcnt=1, name='symname'), Argument(type='long', derefcnt=1, name='framesizep')]),
 'la_x32_gnu_pltexit': Function(type='unsigned', derefcnt=0, name='la_x32_gnu_pltexit', args=[Argument(type='Elf32_Sym', derefcnt=1, name='sym'), Argument(type='unsigned', derefcnt=0, name='ndx'), Argument(type='uintptr_t', derefcnt=1, name='refcook'), Argument(type='uintptr_t', derefcnt=1, name='defcook'), Argument(type='La_x86_64_regs', derefcnt=1, name='inregs'), Argument(type='La_x86_64_retval', derefcnt=1, name='outregs'), Argument(type='char', derefcnt=1, name='symname')]),
 'la_x86_64_gnu_pltenter': Function(type='Elf64_Addr', derefcnt=0, name='la_x86_64_gnu_pltenter', args=[Argument(type='Elf64_Sym', derefcnt=1, name='sym'), Argument(type='unsigned', derefcnt=0, name='ndx'), Argument(type='uintptr_t', derefcnt=1, name='refcook'), Argument(type='uintptr_t', derefcnt=1, name='defcook'), Argument(type='La_x86_64_regs', derefcnt=1, name='regs'), Argument(type='unsigned', derefcnt=1, name='flags'), Argument(type='char', derefcnt=1, name='symname'), Argument(type='long', derefcnt=1, name='framesizep')]),
 'la_x86_64_gnu_pltexit': Function(type='unsigned', derefcnt=0, name='la_x86_64_gnu_pltexit', args=[Argument(type='Elf64_Sym', derefcnt=1, name='sym'), Argument(type='unsigned', derefcnt=0, name='ndx'), Argument(type='uintptr_t', derefcnt=1, name='refcook'), Argument(type='uintptr_t', derefcnt=1, name='defcook'), Argument(type='La_x86_64_regs', derefcnt=1, name='inregs'), Argument(type='La_x86_64_retval', derefcnt=1, name='outregs'), Argument(type='char', derefcnt=1, name='symname')]),
 'labs': Function(type='long', derefcnt=0, name='labs', args=[Argument(type='long', derefcnt=0, name='x')]),
 'lchmod': Function(type='int', derefcnt=0, name='lchmod', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'lchown': Function(type='int', derefcnt=0, name='lchown', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='uid_t', derefcnt=0, name='owner'), Argument(type='gid_t', derefcnt=0, name='group')]),
 'lckpwdf': Function(type='int', derefcnt=0, name='lckpwdf', args=[]),
 'lcong48': Function(type='void', derefcnt=0, name='lcong48', args=[Argument(type='unsigned', derefcnt=1, name='param')]),
 'lcong48_r': Function(type='int', derefcnt=0, name='lcong48_r', args=[Argument(type='unsigned', derefcnt=1, name='param'), Argument(type='drand48_data', derefcnt=1, name='buffer')]),
 'ldexp': Function(type='double', derefcnt=0, name='ldexp', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='int', derefcnt=0, name='exponent')]),
 'ldexpf': Function(type='float', derefcnt=0, name='ldexpf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='int', derefcnt=0, name='exponent')]),
 'ldexpl': Function(type='long', derefcnt=0, name='ldexpl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='int', derefcnt=0, name='exponent')]),
 'ldiv': Function(type='ldiv_t', derefcnt=0, name='ldiv', args=[Argument(type='long', derefcnt=0, name='numer'), Argument(type='long', derefcnt=0, name='denom')]),
 'lfind': Function(type='void', derefcnt=1, name='lfind', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=1, name='base'), Argument(type='size_t', derefcnt=1, name='nmemb'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='compar_fn_t', derefcnt=0, name='compar')]),
 'lgamma': Function(type='double', derefcnt=0, name='lgamma', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'lgamma_r': Function(type='double', derefcnt=0, name='lgamma_r', args=[Argument(type='double', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=1, name='signgamp')]),
 'lgammaf': Function(type='float', derefcnt=0, name='lgammaf', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'lgammaf_r': Function(type='float', derefcnt=0, name='lgammaf_r', args=[Argument(type='float', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=1, name='signgamp')]),
 'lgammal': Function(type='long', derefcnt=0, name='lgammal', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'lgammal_r': Function(type='long', derefcnt=0, name='lgammal_r', args=[Argument(type='long', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=1, name='signgamp')]),
 'lh_delete': Function(type='void', derefcnt=1, name='lh_delete', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='void', derefcnt=1, name='data')]),
 'lh_doall': Function(type='void', derefcnt=0, name='lh_doall', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='LHASH_DOALL_FN_TYPE', derefcnt=0, name='func')]),
 'lh_doall_arg': Function(type='void', derefcnt=0, name='lh_doall_arg', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='LHASH_DOALL_ARG_FN_TYPE', derefcnt=0, name='func'), Argument(type='void', derefcnt=1, name='arg')]),
 'lh_free': Function(type='void', derefcnt=0, name='lh_free', args=[Argument(type='LHASH', derefcnt=1, name='lh')]),
 'lh_insert': Function(type='void', derefcnt=1, name='lh_insert', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='void', derefcnt=1, name='data')]),
 'lh_new': Function(type='LHASH', derefcnt=1, name='lh_new', args=[Argument(type='LHASH_HASH_FN_TYPE', derefcnt=0, name='h'), Argument(type='LHASH_COMP_FN_TYPE', derefcnt=0, name='c')]),
 'lh_node_stats': Function(type='void', derefcnt=0, name='lh_node_stats', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='FILE', derefcnt=1, name='out')]),
 'lh_node_stats_bio': Function(type='void', derefcnt=0, name='lh_node_stats_bio', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='BIO', derefcnt=1, name='out')]),
 'lh_node_usage_stats': Function(type='void', derefcnt=0, name='lh_node_usage_stats', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='FILE', derefcnt=1, name='out')]),
 'lh_node_usage_stats_bio': Function(type='void', derefcnt=0, name='lh_node_usage_stats_bio', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='BIO', derefcnt=1, name='out')]),
 'lh_num_items': Function(type='unsigned', derefcnt=0, name='lh_num_items', args=[Argument(type='LHASH', derefcnt=1, name='lh')]),
 'lh_retrieve': Function(type='void', derefcnt=1, name='lh_retrieve', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='void', derefcnt=1, name='data')]),
 'lh_stats': Function(type='void', derefcnt=0, name='lh_stats', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='FILE', derefcnt=1, name='out')]),
 'lh_stats_bio': Function(type='void', derefcnt=0, name='lh_stats_bio', args=[Argument(type='LHASH', derefcnt=1, name='lh'), Argument(type='BIO', derefcnt=1, name='out')]),
 'lh_strhash': Function(type='unsigned', derefcnt=0, name='lh_strhash', args=[Argument(type='char', derefcnt=1, name='c')]),
 'libc_current_sigrtmax': Function(type='int', derefcnt=0, name='libc_current_sigrtmax', args=[]),
 'libc_current_sigrtmin': Function(type='int', derefcnt=0, name='libc_current_sigrtmin', args=[]),
 'link': Function(type='int', derefcnt=0, name='link', args=[Argument(type='char', derefcnt=1, name='from'), Argument(type='char', derefcnt=1, name='to')]),
 'linkat': Function(type='int', derefcnt=0, name='linkat', args=[Argument(type='int', derefcnt=0, name='fromfd'), Argument(type='char', derefcnt=1, name='from'), Argument(type='int', derefcnt=0, name='tofd'), Argument(type='char', derefcnt=1, name='to'), Argument(type='int', derefcnt=0, name='flags')]),
 'lio_listio': Function(type='int', derefcnt=0, name='lio_listio', args=[Argument(type='int', derefcnt=0, name='mode'), Argument(type='aiocb', derefcnt=2, name='list'), Argument(type='int', derefcnt=0, name='nent'), Argument(type='sigevent', derefcnt=1, name='sig')]),
 'lio_listio64': Function(type='int', derefcnt=0, name='lio_listio64', args=[Argument(type='int', derefcnt=0, name='mode'), Argument(type='aiocb64', derefcnt=2, name='list'), Argument(type='int', derefcnt=0, name='nent'), Argument(type='sigevent', derefcnt=1, name='sig')]),
 'listen': Function(type='int', derefcnt=0, name='listen', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='n')]),
 'llabs': Function(type='long', derefcnt=0, name='llabs', args=[Argument(type='long', derefcnt=0, name='x')]),
 'lldiv': Function(type='lldiv_t', derefcnt=0, name='lldiv', args=[Argument(type='long', derefcnt=0, name='numer'), Argument(type='long', derefcnt=0, name='denom')]),
 'llrint': Function(type='long', derefcnt=0, name='llrint', args=[Argument(type='double', derefcnt=0, name='x')]),
 'llrintf': Function(type='long', derefcnt=0, name='llrintf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'llrintl': Function(type='long', derefcnt=0, name='llrintl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'llround': Function(type='long', derefcnt=0, name='llround', args=[Argument(type='double', derefcnt=0, name='x')]),
 'llroundf': Function(type='long', derefcnt=0, name='llroundf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'llroundl': Function(type='long', derefcnt=0, name='llroundl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'loc_aton': Function(type='int', derefcnt=0, name='loc_aton', args=[Argument(type='char', derefcnt=1, name='ascii'), Argument(type='u_char', derefcnt=1, name='binary')]),
 'loc_ntoa': Function(type='char', derefcnt=1, name='loc_ntoa', args=[Argument(type='u_char', derefcnt=1, name='binary'), Argument(type='char', derefcnt=1, name='ascii')]),
 'localeconv': Function(type='lconv', derefcnt=1, name='localeconv', args=[]),
 'localtime': Function(type='tm', derefcnt=1, name='localtime', args=[Argument(type='time_t', derefcnt=1, name='timer')]),
 'localtime_r': Function(type='tm', derefcnt=1, name='localtime_r', args=[Argument(type='time_t', derefcnt=1, name='timer'), Argument(type='tm', derefcnt=1, name='tp')]),
 'lockf': Function(type='int', derefcnt=0, name='lockf', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='off_t', derefcnt=0, name='len')]),
 'lockf64': Function(type='int', derefcnt=0, name='lockf64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='off64_t', derefcnt=0, name='len')]),
 'log': Function(type='double', derefcnt=0, name='log', args=[Argument(type='double', derefcnt=0, name='x')]),
 'log10': Function(type='double', derefcnt=0, name='log10', args=[Argument(type='double', derefcnt=0, name='x')]),
 'log10f': Function(type='float', derefcnt=0, name='log10f', args=[Argument(type='float', derefcnt=0, name='x')]),
 'log10l': Function(type='long', derefcnt=0, name='log10l', args=[Argument(type='long', derefcnt=0, name='x')]),
 'log1p': Function(type='double', derefcnt=0, name='log1p', args=[Argument(type='double', derefcnt=0, name='x')]),
 'log1pf': Function(type='float', derefcnt=0, name='log1pf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'log1pl': Function(type='long', derefcnt=0, name='log1pl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'log2': Function(type='double', derefcnt=0, name='log2', args=[Argument(type='double', derefcnt=0, name='x')]),
 'log2f': Function(type='float', derefcnt=0, name='log2f', args=[Argument(type='float', derefcnt=0, name='x')]),
 'log2l': Function(type='long', derefcnt=0, name='log2l', args=[Argument(type='long', derefcnt=0, name='x')]),
 'logb': Function(type='double', derefcnt=0, name='logb', args=[Argument(type='double', derefcnt=0, name='x')]),
 'logbf': Function(type='float', derefcnt=0, name='logbf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'logbl': Function(type='long', derefcnt=0, name='logbl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'logf': Function(type='float', derefcnt=0, name='logf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'login': Function(type='void', derefcnt=0, name='login', args=[Argument(type='utmp', derefcnt=1, name='entry')]),
 'login_tty': Function(type='int', derefcnt=0, name='login_tty', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'logl': Function(type='long', derefcnt=0, name='logl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'logout': Function(type='int', derefcnt=0, name='logout', args=[Argument(type='char', derefcnt=1, name='ut_line')]),
 'logwtmp': Function(type='void', derefcnt=0, name='logwtmp', args=[Argument(type='char', derefcnt=1, name='ut_line'), Argument(type='char', derefcnt=1, name='ut_name'), Argument(type='char', derefcnt=1, name='ut_host')]),
 'longjmp': Function(type='void', derefcnt=0, name='longjmp', args=[Argument(type='jmp_buf_tag', derefcnt=1, name='env'), Argument(type='int', derefcnt=0, name='val')]),
 'lookup_certs': Function(type='stack_st_X509', derefcnt=1, name='lookup_certs', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509_NAME', derefcnt=1, name='nm')]),
 'lookup_crls': Function(type='stack_st_X509_CRL', derefcnt=1, name='lookup_crls', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx'), Argument(type='X509_NAME', derefcnt=1, name='nm')]),
 'lrand48': Function(type='long', derefcnt=0, name='lrand48', args=[]),
 'lrand48_r': Function(type='int', derefcnt=0, name='lrand48_r', args=[Argument(type='drand48_data', derefcnt=1, name='buffer'), Argument(type='long', derefcnt=1, name='result')]),
 'lrint': Function(type='long', derefcnt=0, name='lrint', args=[Argument(type='double', derefcnt=0, name='x')]),
 'lrintf': Function(type='long', derefcnt=0, name='lrintf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'lrintl': Function(type='long', derefcnt=0, name='lrintl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'lround': Function(type='long', derefcnt=0, name='lround', args=[Argument(type='double', derefcnt=0, name='x')]),
 'lroundf': Function(type='long', derefcnt=0, name='lroundf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'lroundl': Function(type='long', derefcnt=0, name='lroundl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'lsearch': Function(type='void', derefcnt=1, name='lsearch', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=1, name='base'), Argument(type='size_t', derefcnt=1, name='nmemb'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='compar_fn_t', derefcnt=0, name='compar')]),
 'lseek': Function(type='off_t', derefcnt=0, name='lseek', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off_t', derefcnt=0, name='offset'), Argument(type='int', derefcnt=0, name='whence')]),
 'lseek64': Function(type='off64_t', derefcnt=0, name='lseek64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off64_t', derefcnt=0, name='offset'), Argument(type='int', derefcnt=0, name='whence')]),
 'lstat': Function(type='int', derefcnt=0, name='lstat', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='stat', derefcnt=1, name='buf')]),
 'lstat64': Function(type='int', derefcnt=0, name='lstat64', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='stat64', derefcnt=1, name='buf')]),
 'lutimes': Function(type='int', derefcnt=0, name='lutimes', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='timeval', derefcnt=1, name='tvp')]),
 'lxstat': Function(type='int', derefcnt=0, name='lxstat', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat', derefcnt=1, name='stat_buf')]),
 'lxstat64': Function(type='int', derefcnt=0, name='lxstat64', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat64', derefcnt=1, name='stat_buf')]),
 'lzma_alone_decoder': Function(type='lzma_ret', derefcnt=0, name='lzma_alone_decoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='uint64_t', derefcnt=0, name='memlimit')]),
 'lzma_alone_encoder': Function(type='lzma_ret', derefcnt=0, name='lzma_alone_encoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_options_lzma', derefcnt=1, name='options')]),
 'lzma_auto_decoder': Function(type='lzma_ret', derefcnt=0, name='lzma_auto_decoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='uint64_t', derefcnt=0, name='memlimit'), Argument(type='uint32_t', derefcnt=0, name='flags')]),
 'lzma_block_buffer_bound': Function(type='size_t', derefcnt=0, name='lzma_block_buffer_bound', args=[Argument(type='size_t', derefcnt=0, name='uncompressed_size')]),
 'lzma_block_buffer_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_block_buffer_decode', args=[Argument(type='lzma_block', derefcnt=1, name='block'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=1, name='in_pos'), Argument(type='size_t', derefcnt=0, name='in_size'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_block_buffer_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_block_buffer_encode', args=[Argument(type='lzma_block', derefcnt=1, name='block'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='in_size'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_block_compressed_size': Function(type='lzma_ret', derefcnt=0, name='lzma_block_compressed_size', args=[Argument(type='lzma_block', derefcnt=1, name='block'), Argument(type='lzma_vli', derefcnt=0, name='unpadded_size')]),
 'lzma_block_decoder': Function(type='lzma_ret', derefcnt=0, name='lzma_block_decoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_block', derefcnt=1, name='block')]),
 'lzma_block_encoder': Function(type='lzma_ret', derefcnt=0, name='lzma_block_encoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_block', derefcnt=1, name='block')]),
 'lzma_block_header_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_block_header_decode', args=[Argument(type='lzma_block', derefcnt=1, name='block'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in')]),
 'lzma_block_header_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_block_header_encode', args=[Argument(type='lzma_block', derefcnt=1, name='block'), Argument(type='uint8_t', derefcnt=1, name='out')]),
 'lzma_block_header_size': Function(type='lzma_ret', derefcnt=0, name='lzma_block_header_size', args=[Argument(type='lzma_block', derefcnt=1, name='block')]),
 'lzma_block_total_size': Function(type='lzma_vli', derefcnt=0, name='lzma_block_total_size', args=[Argument(type='lzma_block', derefcnt=1, name='block')]),
 'lzma_block_unpadded_size': Function(type='lzma_vli', derefcnt=0, name='lzma_block_unpadded_size', args=[Argument(type='lzma_block', derefcnt=1, name='block')]),
 'lzma_check_is_supported': Function(type='lzma_bool', derefcnt=0, name='lzma_check_is_supported', args=[Argument(type='lzma_check', derefcnt=0, name='check')]),
 'lzma_check_size': Function(type='uint32_t', derefcnt=0, name='lzma_check_size', args=[Argument(type='lzma_check', derefcnt=0, name='check')]),
 'lzma_code': Function(type='lzma_ret', derefcnt=0, name='lzma_code', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_action', derefcnt=0, name='action')]),
 'lzma_crc32': Function(type='uint32_t', derefcnt=0, name='lzma_crc32', args=[Argument(type='uint8_t', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='uint32_t', derefcnt=0, name='crc')]),
 'lzma_crc64': Function(type='uint64_t', derefcnt=0, name='lzma_crc64', args=[Argument(type='uint8_t', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='uint64_t', derefcnt=0, name='crc')]),
 'lzma_easy_buffer_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_easy_buffer_encode', args=[Argument(type='uint32_t', derefcnt=0, name='preset'), Argument(type='lzma_check', derefcnt=0, name='check'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='in_size'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_easy_decoder_memusage': Function(type='uint64_t', derefcnt=0, name='lzma_easy_decoder_memusage', args=[Argument(type='uint32_t', derefcnt=0, name='preset')]),
 'lzma_easy_encoder': Function(type='lzma_ret', derefcnt=0, name='lzma_easy_encoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='uint32_t', derefcnt=0, name='preset'), Argument(type='lzma_check', derefcnt=0, name='check')]),
 'lzma_easy_encoder_memusage': Function(type='uint64_t', derefcnt=0, name='lzma_easy_encoder_memusage', args=[Argument(type='uint32_t', derefcnt=0, name='preset')]),
 'lzma_end': Function(type='void', derefcnt=0, name='lzma_end', args=[Argument(type='lzma_stream', derefcnt=1, name='strm')]),
 'lzma_filter_decoder_is_supported': Function(type='lzma_bool', derefcnt=0, name='lzma_filter_decoder_is_supported', args=[Argument(type='lzma_vli', derefcnt=0, name='id')]),
 'lzma_filter_encoder_is_supported': Function(type='lzma_bool', derefcnt=0, name='lzma_filter_encoder_is_supported', args=[Argument(type='lzma_vli', derefcnt=0, name='id')]),
 'lzma_filter_flags_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_filter_flags_decode', args=[Argument(type='lzma_filter', derefcnt=1, name='filter'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=1, name='in_pos'), Argument(type='size_t', derefcnt=0, name='in_size')]),
 'lzma_filter_flags_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_filter_flags_encode', args=[Argument(type='lzma_filter', derefcnt=1, name='filter'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_filter_flags_size': Function(type='lzma_ret', derefcnt=0, name='lzma_filter_flags_size', args=[Argument(type='uint32_t', derefcnt=1, name='size'), Argument(type='lzma_filter', derefcnt=1, name='filter')]),
 'lzma_filters_copy': Function(type='lzma_ret', derefcnt=0, name='lzma_filters_copy', args=[Argument(type='lzma_filter', derefcnt=1, name='src'), Argument(type='lzma_filter', derefcnt=1, name='dest'), Argument(type='lzma_allocator', derefcnt=1, name='allocator')]),
 'lzma_filters_update': Function(type='lzma_ret', derefcnt=0, name='lzma_filters_update', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_filter', derefcnt=1, name='filters')]),
 'lzma_get_check': Function(type='lzma_check', derefcnt=0, name='lzma_get_check', args=[Argument(type='lzma_stream', derefcnt=1, name='strm')]),
 'lzma_index_append': Function(type='lzma_ret', derefcnt=0, name='lzma_index_append', args=[Argument(type='lzma_index', derefcnt=1, name='i'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='lzma_vli', derefcnt=0, name='unpadded_size'), Argument(type='lzma_vli', derefcnt=0, name='uncompressed_size')]),
 'lzma_index_block_count': Function(type='lzma_vli', derefcnt=0, name='lzma_index_block_count', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_buffer_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_index_buffer_decode', args=[Argument(type='lzma_index', derefcnt=2, name='i'), Argument(type='uint64_t', derefcnt=1, name='memlimit'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=1, name='in_pos'), Argument(type='size_t', derefcnt=0, name='in_size')]),
 'lzma_index_buffer_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_index_buffer_encode', args=[Argument(type='lzma_index', derefcnt=1, name='i'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_index_cat': Function(type='lzma_ret', derefcnt=0, name='lzma_index_cat', args=[Argument(type='lzma_index', derefcnt=1, name='dest'), Argument(type='lzma_index', derefcnt=1, name='src'), Argument(type='lzma_allocator', derefcnt=1, name='allocator')]),
 'lzma_index_checks': Function(type='uint32_t', derefcnt=0, name='lzma_index_checks', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_decoder': Function(type='lzma_ret', derefcnt=0, name='lzma_index_decoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_index', derefcnt=2, name='i'), Argument(type='uint64_t', derefcnt=0, name='memlimit')]),
 'lzma_index_dup': Function(type='lzma_index', derefcnt=1, name='lzma_index_dup', args=[Argument(type='lzma_index', derefcnt=1, name='i'), Argument(type='lzma_allocator', derefcnt=1, name='allocator')]),
 'lzma_index_encoder': Function(type='lzma_ret', derefcnt=0, name='lzma_index_encoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_end': Function(type='void', derefcnt=0, name='lzma_index_end', args=[Argument(type='lzma_index', derefcnt=1, name='i'), Argument(type='lzma_allocator', derefcnt=1, name='allocator')]),
 'lzma_index_file_size': Function(type='lzma_vli', derefcnt=0, name='lzma_index_file_size', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_hash_append': Function(type='lzma_ret', derefcnt=0, name='lzma_index_hash_append', args=[Argument(type='lzma_index_hash', derefcnt=1, name='index_hash'), Argument(type='lzma_vli', derefcnt=0, name='unpadded_size'), Argument(type='lzma_vli', derefcnt=0, name='uncompressed_size')]),
 'lzma_index_hash_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_index_hash_decode', args=[Argument(type='lzma_index_hash', derefcnt=1, name='index_hash'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=1, name='in_pos'), Argument(type='size_t', derefcnt=0, name='in_size')]),
 'lzma_index_hash_end': Function(type='void', derefcnt=0, name='lzma_index_hash_end', args=[Argument(type='lzma_index_hash', derefcnt=1, name='index_hash'), Argument(type='lzma_allocator', derefcnt=1, name='allocator')]),
 'lzma_index_hash_init': Function(type='lzma_index_hash', derefcnt=1, name='lzma_index_hash_init', args=[Argument(type='lzma_index_hash', derefcnt=1, name='index_hash'), Argument(type='lzma_allocator', derefcnt=1, name='allocator')]),
 'lzma_index_hash_size': Function(type='lzma_vli', derefcnt=0, name='lzma_index_hash_size', args=[Argument(type='lzma_index_hash', derefcnt=1, name='index_hash')]),
 'lzma_index_init': Function(type='lzma_index', derefcnt=1, name='lzma_index_init', args=[Argument(type='lzma_allocator', derefcnt=1, name='allocator')]),
 'lzma_index_iter_init': Function(type='void', derefcnt=0, name='lzma_index_iter_init', args=[Argument(type='lzma_index_iter', derefcnt=1, name='iter'), Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_iter_locate': Function(type='lzma_bool', derefcnt=0, name='lzma_index_iter_locate', args=[Argument(type='lzma_index_iter', derefcnt=1, name='iter'), Argument(type='lzma_vli', derefcnt=0, name='target')]),
 'lzma_index_iter_next': Function(type='lzma_bool', derefcnt=0, name='lzma_index_iter_next', args=[Argument(type='lzma_index_iter', derefcnt=1, name='iter'), Argument(type='lzma_index_iter_mode', derefcnt=0, name='mode')]),
 'lzma_index_iter_rewind': Function(type='void', derefcnt=0, name='lzma_index_iter_rewind', args=[Argument(type='lzma_index_iter', derefcnt=1, name='iter')]),
 'lzma_index_memusage': Function(type='uint64_t', derefcnt=0, name='lzma_index_memusage', args=[Argument(type='lzma_vli', derefcnt=0, name='streams'), Argument(type='lzma_vli', derefcnt=0, name='blocks')]),
 'lzma_index_memused': Function(type='uint64_t', derefcnt=0, name='lzma_index_memused', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_size': Function(type='lzma_vli', derefcnt=0, name='lzma_index_size', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_stream_count': Function(type='lzma_vli', derefcnt=0, name='lzma_index_stream_count', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_stream_flags': Function(type='lzma_ret', derefcnt=0, name='lzma_index_stream_flags', args=[Argument(type='lzma_index', derefcnt=1, name='i'), Argument(type='lzma_stream_flags', derefcnt=1, name='stream_flags')]),
 'lzma_index_stream_padding': Function(type='lzma_ret', derefcnt=0, name='lzma_index_stream_padding', args=[Argument(type='lzma_index', derefcnt=1, name='i'), Argument(type='lzma_vli', derefcnt=0, name='stream_padding')]),
 'lzma_index_stream_size': Function(type='lzma_vli', derefcnt=0, name='lzma_index_stream_size', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_total_size': Function(type='lzma_vli', derefcnt=0, name='lzma_index_total_size', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_index_uncompressed_size': Function(type='lzma_vli', derefcnt=0, name='lzma_index_uncompressed_size', args=[Argument(type='lzma_index', derefcnt=1, name='i')]),
 'lzma_lzma_preset': Function(type='lzma_bool', derefcnt=0, name='lzma_lzma_preset', args=[Argument(type='lzma_options_lzma', derefcnt=1, name='options'), Argument(type='uint32_t', derefcnt=0, name='preset')]),
 'lzma_memlimit_get': Function(type='uint64_t', derefcnt=0, name='lzma_memlimit_get', args=[Argument(type='lzma_stream', derefcnt=1, name='strm')]),
 'lzma_memlimit_set': Function(type='lzma_ret', derefcnt=0, name='lzma_memlimit_set', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='uint64_t', derefcnt=0, name='memlimit')]),
 'lzma_memusage': Function(type='uint64_t', derefcnt=0, name='lzma_memusage', args=[Argument(type='lzma_stream', derefcnt=1, name='strm')]),
 'lzma_mf_is_supported': Function(type='lzma_bool', derefcnt=0, name='lzma_mf_is_supported', args=[Argument(type='lzma_match_finder', derefcnt=0, name='match_finder')]),
 'lzma_mode_is_supported': Function(type='lzma_bool', derefcnt=0, name='lzma_mode_is_supported', args=[Argument(type='lzma_mode', derefcnt=0, name='mode')]),
 'lzma_physmem': Function(type='uint64_t', derefcnt=0, name='lzma_physmem', args=[]),
 'lzma_properties_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_properties_decode', args=[Argument(type='lzma_filter', derefcnt=1, name='filter'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='props'), Argument(type='size_t', derefcnt=0, name='props_size')]),
 'lzma_properties_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_properties_encode', args=[Argument(type='lzma_filter', derefcnt=1, name='filter'), Argument(type='uint8_t', derefcnt=1, name='props')]),
 'lzma_properties_size': Function(type='lzma_ret', derefcnt=0, name='lzma_properties_size', args=[Argument(type='uint32_t', derefcnt=1, name='size'), Argument(type='lzma_filter', derefcnt=1, name='filter')]),
 'lzma_raw_buffer_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_raw_buffer_decode', args=[Argument(type='lzma_filter', derefcnt=1, name='filters'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=1, name='in_pos'), Argument(type='size_t', derefcnt=0, name='in_size'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_raw_buffer_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_raw_buffer_encode', args=[Argument(type='lzma_filter', derefcnt=1, name='filters'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='in_size'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_raw_decoder': Function(type='lzma_ret', derefcnt=0, name='lzma_raw_decoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_filter', derefcnt=1, name='filters')]),
 'lzma_raw_decoder_memusage': Function(type='uint64_t', derefcnt=0, name='lzma_raw_decoder_memusage', args=[Argument(type='lzma_filter', derefcnt=1, name='filters')]),
 'lzma_raw_encoder': Function(type='lzma_ret', derefcnt=0, name='lzma_raw_encoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_filter', derefcnt=1, name='filters')]),
 'lzma_raw_encoder_memusage': Function(type='uint64_t', derefcnt=0, name='lzma_raw_encoder_memusage', args=[Argument(type='lzma_filter', derefcnt=1, name='filters')]),
 'lzma_stream_buffer_bound': Function(type='size_t', derefcnt=0, name='lzma_stream_buffer_bound', args=[Argument(type='size_t', derefcnt=0, name='uncompressed_size')]),
 'lzma_stream_buffer_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_buffer_decode', args=[Argument(type='uint64_t', derefcnt=1, name='memlimit'), Argument(type='uint32_t', derefcnt=0, name='flags'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=1, name='in_pos'), Argument(type='size_t', derefcnt=0, name='in_size'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_stream_buffer_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_buffer_encode', args=[Argument(type='lzma_filter', derefcnt=1, name='filters'), Argument(type='lzma_check', derefcnt=0, name='check'), Argument(type='lzma_allocator', derefcnt=1, name='allocator'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=0, name='in_size'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_stream_decoder': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_decoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='uint64_t', derefcnt=0, name='memlimit'), Argument(type='uint32_t', derefcnt=0, name='flags')]),
 'lzma_stream_encoder': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_encoder', args=[Argument(type='lzma_stream', derefcnt=1, name='strm'), Argument(type='lzma_filter', derefcnt=1, name='filters'), Argument(type='lzma_check', derefcnt=0, name='check')]),
 'lzma_stream_flags_compare': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_flags_compare', args=[Argument(type='lzma_stream_flags', derefcnt=1, name='a'), Argument(type='lzma_stream_flags', derefcnt=1, name='b')]),
 'lzma_stream_footer_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_footer_decode', args=[Argument(type='lzma_stream_flags', derefcnt=1, name='options'), Argument(type='uint8_t', derefcnt=1, name='in')]),
 'lzma_stream_footer_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_footer_encode', args=[Argument(type='lzma_stream_flags', derefcnt=1, name='options'), Argument(type='uint8_t', derefcnt=1, name='out')]),
 'lzma_stream_header_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_header_decode', args=[Argument(type='lzma_stream_flags', derefcnt=1, name='options'), Argument(type='uint8_t', derefcnt=1, name='in')]),
 'lzma_stream_header_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_stream_header_encode', args=[Argument(type='lzma_stream_flags', derefcnt=1, name='options'), Argument(type='uint8_t', derefcnt=1, name='out')]),
 'lzma_version_number': Function(type='uint32_t', derefcnt=0, name='lzma_version_number', args=[]),
 'lzma_version_string': Function(type='char', derefcnt=1, name='lzma_version_string', args=[]),
 'lzma_vli_decode': Function(type='lzma_ret', derefcnt=0, name='lzma_vli_decode', args=[Argument(type='lzma_vli', derefcnt=1, name='vli'), Argument(type='size_t', derefcnt=1, name='vli_pos'), Argument(type='uint8_t', derefcnt=1, name='in'), Argument(type='size_t', derefcnt=1, name='in_pos'), Argument(type='size_t', derefcnt=0, name='in_size')]),
 'lzma_vli_encode': Function(type='lzma_ret', derefcnt=0, name='lzma_vli_encode', args=[Argument(type='lzma_vli', derefcnt=0, name='vli'), Argument(type='size_t', derefcnt=1, name='vli_pos'), Argument(type='uint8_t', derefcnt=1, name='out'), Argument(type='size_t', derefcnt=1, name='out_pos'), Argument(type='size_t', derefcnt=0, name='out_size')]),
 'lzma_vli_size': Function(type='uint32_t', derefcnt=0, name='lzma_vli_size', args=[Argument(type='lzma_vli', derefcnt=0, name='vli')]),
 'madvise': Function(type='int', derefcnt=0, name='madvise', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='advice')]),
 'makecontext': Function(type='void', derefcnt=0, name='makecontext', args=[Argument(type='ucontext_t', derefcnt=1, name='ucp'), Argument(type='void', derefcnt=0, name='func'), Argument(type='int', derefcnt=0, name='argc'), Argument(type='int', derefcnt=0, name='vararg')]),
 'mallinfo': Function(type='mallinfo', derefcnt=0, name='mallinfo', args=[]),
 'malloc': Function(type='void', derefcnt=1, name='malloc', args=[Argument(type='size_t', derefcnt=0, name='size')]),
 'malloc_check_init': Function(type='void', derefcnt=0, name='malloc_check_init', args=[]),
 'malloc_get_state': Function(type='void', derefcnt=1, name='malloc_get_state', args=[]),
 'malloc_hook': Function(type='void', derefcnt=1, name='malloc_hook', args=[Argument(type='size_t', derefcnt=0, name='size'), Argument(type='void', derefcnt=1, name='arg1')]),
 'malloc_info': Function(type='int', derefcnt=0, name='malloc_info', args=[Argument(type='int', derefcnt=0, name='options'), Argument(type='FILE', derefcnt=1, name='fp')]),
 'malloc_initialize_hook': Function(type='void', derefcnt=0, name='malloc_initialize_hook', args=[]),
 'malloc_set_state': Function(type='int', derefcnt=0, name='malloc_set_state', args=[Argument(type='void', derefcnt=1, name='ptr')]),
 'malloc_stats': Function(type='void', derefcnt=0, name='malloc_stats', args=[]),
 'malloc_trim': Function(type='int', derefcnt=0, name='malloc_trim', args=[Argument(type='size_t', derefcnt=0, name='pad')]),
 'malloc_usable_size': Function(type='size_t', derefcnt=0, name='malloc_usable_size', args=[Argument(type='void', derefcnt=1, name='ptr')]),
 'mallopt': Function(type='int', derefcnt=0, name='mallopt', args=[Argument(type='int', derefcnt=0, name='param'), Argument(type='int', derefcnt=0, name='val')]),
 'matherr': Function(type='int', derefcnt=0, name='matherr', args=[Argument(type='exception', derefcnt=1, name='exc')]),
 'mblen': Function(type='int', derefcnt=0, name='mblen', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n')]),
 'mbrlen': Function(type='size_t', derefcnt=0, name='mbrlen', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='mbstate_t', derefcnt=1, name='ps')]),
 'mbrtowc': Function(type='size_t', derefcnt=0, name='mbrtowc', args=[Argument(type='wchar_t', derefcnt=1, name='pwc'), Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='mbstate_t', derefcnt=1, name='p')]),
 'mbsinit': Function(type='int', derefcnt=0, name='mbsinit', args=[Argument(type='mbstate_t', derefcnt=1, name='ps')]),
 'mbsnrtowcs': Function(type='size_t', derefcnt=0, name='mbsnrtowcs', args=[Argument(type='wchar_t', derefcnt=1, name='dst'), Argument(type='char', derefcnt=2, name='src'), Argument(type='size_t', derefcnt=0, name='nmc'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='mbstate_t', derefcnt=1, name='ps')]),
 'mbsrtowcs': Function(type='size_t', derefcnt=0, name='mbsrtowcs', args=[Argument(type='wchar_t', derefcnt=1, name='dst'), Argument(type='char', derefcnt=2, name='src'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='mbstate_t', derefcnt=1, name='ps')]),
 'mbstowcs': Function(type='size_t', derefcnt=0, name='mbstowcs', args=[Argument(type='wchar_t', derefcnt=1, name='pwcs'), Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n')]),
 'mbtowc': Function(type='int', derefcnt=0, name='mbtowc', args=[Argument(type='wchar_t', derefcnt=1, name='pwc'), Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n')]),
 'mcheck': Function(type='int', derefcnt=0, name='mcheck', args=[Argument(type='void', derefcnt=0, name='abortfunc')]),
 'mcheck_check_all': Function(type='void', derefcnt=0, name='mcheck_check_all', args=[]),
 'mcheck_pedantic': Function(type='int', derefcnt=0, name='mcheck_pedantic', args=[Argument(type='void', derefcnt=0, name='abortfunc')]),
 'md_ctrl': Function(type='int', derefcnt=0, name='md_ctrl', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='int', derefcnt=0, name='p1'), Argument(type='void', derefcnt=1, name='p2')]),
 'memalign': Function(type='void', derefcnt=1, name='memalign', args=[Argument(type='size_t', derefcnt=0, name='alignment'), Argument(type='size_t', derefcnt=0, name='size')]),
 'memalign_hook': Function(type='void', derefcnt=1, name='memalign_hook', args=[Argument(type='size_t', derefcnt=0, name='alignment'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='void', derefcnt=1, name='arg2')]),
 'memccpy': Function(type='void', derefcnt=1, name='memccpy', args=[Argument(type='void', derefcnt=1, name='dest'), Argument(type='void', derefcnt=1, name='src'), Argument(type='int', derefcnt=0, name='c'), Argument(type='size_t', derefcnt=0, name='n')]),
 'memchr': Function(type='void', derefcnt=1, name='memchr', args=[Argument(type='void', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c'), Argument(type='size_t', derefcnt=0, name='n')]),
 'memcmp': Function(type='int', derefcnt=0, name='memcmp', args=[Argument(type='void', derefcnt=1, name='s1'), Argument(type='void', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'memcpy': Function(type='void', derefcnt=1, name='memcpy', args=[Argument(type='void', derefcnt=1, name='dest'), Argument(type='void', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'memfrob': Function(type='void', derefcnt=1, name='memfrob', args=[Argument(type='void', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n')]),
 'memmem': Function(type='void', derefcnt=1, name='memmem', args=[Argument(type='void', derefcnt=1, name='haystack'), Argument(type='size_t', derefcnt=0, name='haystacklen'), Argument(type='void', derefcnt=1, name='needle'), Argument(type='size_t', derefcnt=0, name='needlelen')]),
 'memmove': Function(type='void', derefcnt=1, name='memmove', args=[Argument(type='void', derefcnt=1, name='dest'), Argument(type='void', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'mempcpy': Function(type='void', derefcnt=1, name='mempcpy', args=[Argument(type='void', derefcnt=1, name='dest'), Argument(type='void', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'memrchr': Function(type='void', derefcnt=1, name='memrchr', args=[Argument(type='void', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c'), Argument(type='size_t', derefcnt=0, name='n')]),
 'memset': Function(type='void', derefcnt=1, name='memset', args=[Argument(type='void', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c'), Argument(type='size_t', derefcnt=0, name='n')]),
 'mincore': Function(type='int', derefcnt=0, name='mincore', args=[Argument(type='void', derefcnt=1, name='start'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='unsigned', derefcnt=1, name='vec')]),
 'mkdir': Function(type='int', derefcnt=0, name='mkdir', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'mkdirat': Function(type='int', derefcnt=0, name='mkdirat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'mkdtemp': Function(type='char', derefcnt=1, name='mkdtemp', args=[Argument(type='char', derefcnt=1, name='template')]),
 'mkfifo': Function(type='int', derefcnt=0, name='mkfifo', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'mkfifoat': Function(type='int', derefcnt=0, name='mkfifoat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'mknod': Function(type='int', derefcnt=0, name='mknod', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode'), Argument(type='dev_t', derefcnt=0, name='dev')]),
 'mknodat': Function(type='int', derefcnt=0, name='mknodat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode'), Argument(type='dev_t', derefcnt=0, name='dev')]),
 'mkostemp': Function(type='int', derefcnt=0, name='mkostemp', args=[Argument(type='char', derefcnt=1, name='template'), Argument(type='int', derefcnt=0, name='flags')]),
 'mkostemp64': Function(type='int', derefcnt=0, name='mkostemp64', args=[Argument(type='char', derefcnt=1, name='template'), Argument(type='int', derefcnt=0, name='flags')]),
 'mkostemps': Function(type='int', derefcnt=0, name='mkostemps', args=[Argument(type='char', derefcnt=1, name='template'), Argument(type='int', derefcnt=0, name='suffixlen'), Argument(type='int', derefcnt=0, name='flags')]),
 'mkostemps64': Function(type='int', derefcnt=0, name='mkostemps64', args=[Argument(type='char', derefcnt=1, name='template'), Argument(type='int', derefcnt=0, name='suffixlen'), Argument(type='int', derefcnt=0, name='flags')]),
 'mkstemp': Function(type='int', derefcnt=0, name='mkstemp', args=[Argument(type='char', derefcnt=1, name='template')]),
 'mkstemp64': Function(type='int', derefcnt=0, name='mkstemp64', args=[Argument(type='char', derefcnt=1, name='template')]),
 'mkstemps': Function(type='int', derefcnt=0, name='mkstemps', args=[Argument(type='char', derefcnt=1, name='template'), Argument(type='int', derefcnt=0, name='suffixlen')]),
 'mkstemps64': Function(type='int', derefcnt=0, name='mkstemps64', args=[Argument(type='char', derefcnt=1, name='template'), Argument(type='int', derefcnt=0, name='suffixlen')]),
 'mktemp': Function(type='char', derefcnt=1, name='mktemp', args=[Argument(type='char', derefcnt=1, name='template')]),
 'mktime': Function(type='time_t', derefcnt=0, name='mktime', args=[Argument(type='tm', derefcnt=1, name='tp')]),
 'mlock': Function(type='int', derefcnt=0, name='mlock', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len')]),
 'mlockall': Function(type='int', derefcnt=0, name='mlockall', args=[Argument(type='int', derefcnt=0, name='flags')]),
 'mmap': Function(type='void', derefcnt=1, name='mmap', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='prot'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='fd'), Argument(type='off_t', derefcnt=0, name='offset')]),
 'mmap2': Function(type='void', derefcnt=1, name='mmap', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='prot'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='fd'), Argument(type='off_t', derefcnt=0, name='offset')]),
 'mmap64': Function(type='void', derefcnt=1, name='mmap64', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='prot'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='fd'), Argument(type='off64_t', derefcnt=0, name='offset')]),
 'modf': Function(type='double', derefcnt=0, name='modf', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=1, name='iptr')]),
 'modff': Function(type='float', derefcnt=0, name='modff', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=1, name='iptr')]),
 'modfl': Function(type='long', derefcnt=0, name='modfl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=1, name='iptr')]),
 'morecore': Function(type='void', derefcnt=1, name='morecore', args=[Argument(type='ptrdiff_t', derefcnt=0, name='size')]),
 'mprobe': Function(type='mcheck_status', derefcnt=0, name='mprobe', args=[Argument(type='void', derefcnt=1, name='ptr')]),
 'mprotect': Function(type='int', derefcnt=0, name='mprotect', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='prot')]),
 'mq_close': Function(type='int', derefcnt=0, name='mq_close', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes')]),
 'mq_getattr': Function(type='int', derefcnt=0, name='mq_getattr', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes'), Argument(type='mq_attr', derefcnt=1, name='mqstat')]),
 'mq_notify': Function(type='int', derefcnt=0, name='mq_notify', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes'), Argument(type='sigevent', derefcnt=1, name='notification')]),
 'mq_open': Function(type='mqd_t', derefcnt=0, name='mq_open', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='int', derefcnt=0, name='vararg')]),
 'mq_receive': Function(type='ssize_t', derefcnt=0, name='mq_receive', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes'), Argument(type='char', derefcnt=1, name='msg_ptr'), Argument(type='size_t', derefcnt=0, name='msg_len'), Argument(type='unsigned', derefcnt=1, name='msg_prio')]),
 'mq_send': Function(type='int', derefcnt=0, name='mq_send', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes'), Argument(type='char', derefcnt=1, name='msg_ptr'), Argument(type='size_t', derefcnt=0, name='msg_len'), Argument(type='unsigned', derefcnt=0, name='msg_prio')]),
 'mq_setattr': Function(type='int', derefcnt=0, name='mq_setattr', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes'), Argument(type='mq_attr', derefcnt=1, name='mqstat'), Argument(type='mq_attr', derefcnt=1, name='omqstat')]),
 'mq_timedreceive': Function(type='ssize_t', derefcnt=0, name='mq_timedreceive', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes'), Argument(type='char', derefcnt=1, name='msg_ptr'), Argument(type='size_t', derefcnt=0, name='msg_len'), Argument(type='unsigned', derefcnt=1, name='msg_prio'), Argument(type='timespec', derefcnt=1, name='abs_timeout')]),
 'mq_timedsend': Function(type='int', derefcnt=0, name='mq_timedsend', args=[Argument(type='mqd_t', derefcnt=0, name='mqdes'), Argument(type='char', derefcnt=1, name='msg_ptr'), Argument(type='size_t', derefcnt=0, name='msg_len'), Argument(type='unsigned', derefcnt=0, name='msg_prio'), Argument(type='timespec', derefcnt=1, name='abs_timeout')]),
 'mq_unlink': Function(type='int', derefcnt=0, name='mq_unlink', args=[Argument(type='char', derefcnt=1, name='name')]),
 'mrand48': Function(type='long', derefcnt=0, name='mrand48', args=[]),
 'mrand48_r': Function(type='int', derefcnt=0, name='mrand48_r', args=[Argument(type='drand48_data', derefcnt=1, name='buffer'), Argument(type='long', derefcnt=1, name='result')]),
 'mremap': Function(type='void', derefcnt=1, name='mremap', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='old_len'), Argument(type='size_t', derefcnt=0, name='new_len'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='int', derefcnt=0, name='vararg')]),
 'msg_callback': Function(type='void', derefcnt=0, name='msg_callback', args=[Argument(type='int', derefcnt=0, name='write_p'), Argument(type='int', derefcnt=0, name='version'), Argument(type='int', derefcnt=0, name='content_type'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='void', derefcnt=1, name='arg')]),
 'msgctl': Function(type='int', derefcnt=0, name='msgctl', args=[Argument(type='int', derefcnt=0, name='msqid'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='msqid_ds', derefcnt=1, name='buf')]),
 'msgget': Function(type='int', derefcnt=0, name='msgget', args=[Argument(type='key_t', derefcnt=0, name='key'), Argument(type='int', derefcnt=0, name='msgflg')]),
 'msgrcv': Function(type='ssize_t', derefcnt=0, name='msgrcv', args=[Argument(type='int', derefcnt=0, name='msqid'), Argument(type='void', derefcnt=1, name='msgp'), Argument(type='size_t', derefcnt=0, name='msgsz'), Argument(type='long', derefcnt=0, name='msgtyp'), Argument(type='int', derefcnt=0, name='msgflg')]),
 'msgsnd': Function(type='int', derefcnt=0, name='msgsnd', args=[Argument(type='int', derefcnt=0, name='msqid'), Argument(type='void', derefcnt=1, name='msgp'), Argument(type='size_t', derefcnt=0, name='msgsz'), Argument(type='int', derefcnt=0, name='msgflg')]),
 'msync': Function(type='int', derefcnt=0, name='msync', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='flags')]),
 'mtrace': Function(type='void', derefcnt=0, name='mtrace', args=[]),
 'munlock': Function(type='int', derefcnt=0, name='munlock', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len')]),
 'munlockall': Function(type='int', derefcnt=0, name='munlockall', args=[]),
 'munmap': Function(type='int', derefcnt=0, name='munmap', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len')]),
 'muntrace': Function(type='void', derefcnt=0, name='muntrace', args=[]),
 'name_to_handle_at': Function(type='int', derefcnt=0, name='name_to_handle_at', args=[Argument(type='int', derefcnt=0, name='dfd'), Argument(type='char', derefcnt=1, name='name'), Argument(type='file_handle', derefcnt=1, name='handle'), Argument(type='int', derefcnt=1, name='mnt_id'), Argument(type='int', derefcnt=0, name='flags')]),
 'nan': Function(type='double', derefcnt=0, name='nan', args=[Argument(type='char', derefcnt=1, name='tagb')]),
 'nanf': Function(type='float', derefcnt=0, name='nanf', args=[Argument(type='char', derefcnt=1, name='tagb')]),
 'nanl': Function(type='long', derefcnt=0, name='nanl', args=[Argument(type='char', derefcnt=1, name='tagb')]),
 'nanosleep': Function(type='int', derefcnt=0, name='nanosleep', args=[Argument(type='timespec', derefcnt=1, name='requested_time'), Argument(type='timespec', derefcnt=1, name='remaining')]),
 'nearbyint': Function(type='double', derefcnt=0, name='nearbyint', args=[Argument(type='double', derefcnt=0, name='x')]),
 'nearbyintf': Function(type='float', derefcnt=0, name='nearbyintf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'nearbyintl': Function(type='long', derefcnt=0, name='nearbyintl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'new_item': Function(type='int', derefcnt=0, name='new_item', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx')]),
 'new_session_cb': Function(type='int', derefcnt=0, name='new_session_cb', args=[Argument(type='ssl_st', derefcnt=1, name='ssl'), Argument(type='SSL_SESSION', derefcnt=1, name='sess')]),
 'newlocale': Function(type='locale_t', derefcnt=0, name='newlocale', args=[Argument(type='int', derefcnt=0, name='category_mask'), Argument(type='char', derefcnt=1, name='locale'), Argument(type='locale_t', derefcnt=0, name='base')]),
 'next_proto_select_cb': Function(type='int', derefcnt=0, name='next_proto_select_cb', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=2, name='out'), Argument(type='unsigned', derefcnt=1, name='outlen'), Argument(type='unsigned', derefcnt=1, name='in'), Argument(type='unsigned', derefcnt=0, name='inlen'), Argument(type='void', derefcnt=1, name='arg')]),
 'next_protos_advertised_cb': Function(type='int', derefcnt=0, name='next_protos_advertised_cb', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=2, name='buf'), Argument(type='unsigned', derefcnt=1, name='len'), Argument(type='void', derefcnt=1, name='arg')]),
 'nextafter': Function(type='double', derefcnt=0, name='nextafter', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'nextafterf': Function(type='float', derefcnt=0, name='nextafterf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'nextafterl': Function(type='long', derefcnt=0, name='nextafterl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'nexttoward': Function(type='double', derefcnt=0, name='nexttoward', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'nexttowardf': Function(type='float', derefcnt=0, name='nexttowardf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'nexttowardl': Function(type='long', derefcnt=0, name='nexttowardl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'nftw': Function(type='int', derefcnt=0, name='nftw', args=[Argument(type='char', derefcnt=1, name='dir'), Argument(type='nftw_func_t', derefcnt=0, name='func'), Argument(type='int', derefcnt=0, name='descriptors'), Argument(type='int', derefcnt=0, name='flag')]),
 'nftw64': Function(type='int', derefcnt=0, name='nftw64', args=[Argument(type='char', derefcnt=1, name='dir'), Argument(type='nftw64_func_t', derefcnt=0, name='func'), Argument(type='int', derefcnt=0, name='descriptors'), Argument(type='int', derefcnt=0, name='flag')]),
 'nftw64_func_t': Function(type='int', derefcnt=0, name='nftw64_func_t', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat64', derefcnt=1, name='status'), Argument(type='int', derefcnt=0, name='flag'), Argument(type='FTW', derefcnt=1, name='info')]),
 'nftw_func_t': Function(type='int', derefcnt=0, name='nftw_func_t', args=[Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat', derefcnt=1, name='status'), Argument(type='int', derefcnt=0, name='flag'), Argument(type='FTW', derefcnt=1, name='info')]),
 'ngettext': Function(type='char', derefcnt=1, name='ngettext', args=[Argument(type='char', derefcnt=1, name='msgid1'), Argument(type='char', derefcnt=1, name='msgid2'), Argument(type='unsigned', derefcnt=0, name='n')]),
 'nice': Function(type='int', derefcnt=0, name='nice', args=[Argument(type='int', derefcnt=0, name='inc')]),
 'nl_langinfo': Function(type='char', derefcnt=1, name='nl_langinfo', args=[Argument(type='nl_item', derefcnt=0, name='item')]),
 'nl_langinfo_l': Function(type='char', derefcnt=1, name='nl_langinfo_l', args=[Argument(type='nl_item', derefcnt=0, name='item'), Argument(type='locale_t', derefcnt=0, name='l')]),
 'nrand48': Function(type='long', derefcnt=0, name='nrand48', args=[Argument(type='unsigned', derefcnt=1, name='xsubi')]),
 'nrand48_r': Function(type='int', derefcnt=0, name='nrand48_r', args=[Argument(type='unsigned', derefcnt=1, name='xsubi'), Argument(type='drand48_data', derefcnt=1, name='buffer'), Argument(type='long', derefcnt=1, name='result')]),
 'ns_datetosecs': Function(type='u_int32_t', derefcnt=0, name='ns_datetosecs', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1')]),
 'ns_find_tsig': Function(type='u_char', derefcnt=1, name='ns_find_tsig', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1')]),
 'ns_format_ttl': Function(type='int', derefcnt=0, name='ns_format_ttl', args=[Argument(type='u_long', derefcnt=0, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2')]),
 'ns_get16': Function(type='u_int', derefcnt=0, name='ns_get16', args=[Argument(type='u_char', derefcnt=1, name='arg0')]),
 'ns_get32': Function(type='u_long', derefcnt=0, name='ns_get32', args=[Argument(type='u_char', derefcnt=1, name='arg0')]),
 'ns_initparse': Function(type='int', derefcnt=0, name='ns_initparse', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='ns_msg', derefcnt=1, name='arg2')]),
 'ns_makecanon': Function(type='int', derefcnt=0, name='ns_makecanon', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2')]),
 'ns_msg_getflag': Function(type='int', derefcnt=0, name='ns_msg_getflag', args=[Argument(type='ns_msg', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'ns_name_compress': Function(type='int', derefcnt=0, name='ns_name_compress', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2'), Argument(type='u_char', derefcnt=2, name='arg3'), Argument(type='u_char', derefcnt=2, name='arg4')]),
 'ns_name_ntol': Function(type='int', derefcnt=0, name='ns_name_ntol', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2')]),
 'ns_name_ntop': Function(type='int', derefcnt=0, name='ns_name_ntop', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2')]),
 'ns_name_pack': Function(type='int', derefcnt=0, name='ns_name_pack', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='u_char', derefcnt=2, name='arg3'), Argument(type='u_char', derefcnt=2, name='arg4')]),
 'ns_name_pton': Function(type='int', derefcnt=0, name='ns_name_pton', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='size_t', derefcnt=0, name='arg2')]),
 'ns_name_rollback': Function(type='void', derefcnt=0, name='ns_name_rollback', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=2, name='arg1'), Argument(type='u_char', derefcnt=2, name='arg2')]),
 'ns_name_skip': Function(type='int', derefcnt=0, name='ns_name_skip', args=[Argument(type='u_char', derefcnt=2, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1')]),
 'ns_name_uncompress': Function(type='int', derefcnt=0, name='ns_name_uncompress', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='u_char', derefcnt=1, name='arg2'), Argument(type='char', derefcnt=1, name='arg3'), Argument(type='size_t', derefcnt=0, name='arg4')]),
 'ns_name_unpack': Function(type='int', derefcnt=0, name='ns_name_unpack', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='u_char', derefcnt=1, name='arg2'), Argument(type='u_char', derefcnt=1, name='arg3'), Argument(type='size_t', derefcnt=0, name='arg4')]),
 'ns_parse_ttl': Function(type='int', derefcnt=0, name='ns_parse_ttl', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='u_long', derefcnt=1, name='arg1')]),
 'ns_parserr': Function(type='int', derefcnt=0, name='ns_parserr', args=[Argument(type='ns_msg', derefcnt=1, name='arg0'), Argument(type='ns_sect', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='ns_rr', derefcnt=1, name='arg3')]),
 'ns_put16': Function(type='void', derefcnt=0, name='ns_put16', args=[Argument(type='u_int', derefcnt=0, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1')]),
 'ns_put32': Function(type='void', derefcnt=0, name='ns_put32', args=[Argument(type='u_long', derefcnt=0, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1')]),
 'ns_samedomain': Function(type='int', derefcnt=0, name='ns_samedomain', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1')]),
 'ns_samename': Function(type='int', derefcnt=0, name='ns_samename', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1')]),
 'ns_sign': Function(type='int', derefcnt=0, name='ns_sign', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='void', derefcnt=1, name='arg4'), Argument(type='u_char', derefcnt=1, name='arg5'), Argument(type='int', derefcnt=0, name='arg6'), Argument(type='u_char', derefcnt=1, name='arg7'), Argument(type='int', derefcnt=1, name='arg8'), Argument(type='time_t', derefcnt=0, name='arg9')]),
 'ns_sign2': Function(type='int', derefcnt=0, name='ns_sign2', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='void', derefcnt=1, name='arg4'), Argument(type='u_char', derefcnt=1, name='arg5'), Argument(type='int', derefcnt=0, name='arg6'), Argument(type='u_char', derefcnt=1, name='arg7'), Argument(type='int', derefcnt=1, name='arg8'), Argument(type='time_t', derefcnt=0, name='arg9'), Argument(type='u_char', derefcnt=2, name='arg10'), Argument(type='u_char', derefcnt=2, name='arg11')]),
 'ns_sign_tcp': Function(type='int', derefcnt=0, name='ns_sign_tcp', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='ns_tcp_tsig_state', derefcnt=1, name='arg4'), Argument(type='int', derefcnt=0, name='arg5')]),
 'ns_sign_tcp2': Function(type='int', derefcnt=0, name='ns_sign_tcp2', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='ns_tcp_tsig_state', derefcnt=1, name='arg4'), Argument(type='int', derefcnt=0, name='arg5'), Argument(type='u_char', derefcnt=2, name='arg6'), Argument(type='u_char', derefcnt=2, name='arg7')]),
 'ns_sign_tcp_init': Function(type='int', derefcnt=0, name='ns_sign_tcp_init', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='ns_tcp_tsig_state', derefcnt=1, name='arg3')]),
 'ns_skiprr': Function(type='int', derefcnt=0, name='ns_skiprr', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='ns_sect', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3')]),
 'ns_sprintrr': Function(type='int', derefcnt=0, name='ns_sprintrr', args=[Argument(type='ns_msg', derefcnt=1, name='arg0'), Argument(type='ns_rr', derefcnt=1, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='char', derefcnt=1, name='arg3'), Argument(type='char', derefcnt=1, name='arg4'), Argument(type='size_t', derefcnt=0, name='arg5')]),
 'ns_sprintrrf': Function(type='int', derefcnt=0, name='ns_sprintrrf', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='size_t', derefcnt=0, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='ns_class', derefcnt=0, name='arg3'), Argument(type='ns_type', derefcnt=0, name='arg4'), Argument(type='u_long', derefcnt=0, name='arg5'), Argument(type='u_char', derefcnt=1, name='arg6'), Argument(type='size_t', derefcnt=0, name='arg7'), Argument(type='char', derefcnt=1, name='arg8'), Argument(type='char', derefcnt=1, name='arg9'), Argument(type='char', derefcnt=1, name='arg10'), Argument(type='size_t', derefcnt=0, name='arg11')]),
 'ns_subdomain': Function(type='int', derefcnt=0, name='ns_subdomain', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1')]),
 'ns_verify': Function(type='int', derefcnt=0, name='ns_verify', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='void', derefcnt=1, name='arg2'), Argument(type='u_char', derefcnt=1, name='arg3'), Argument(type='int', derefcnt=0, name='arg4'), Argument(type='u_char', derefcnt=1, name='arg5'), Argument(type='int', derefcnt=1, name='arg6'), Argument(type='time_t', derefcnt=1, name='arg7'), Argument(type='int', derefcnt=0, name='arg8')]),
 'ns_verify_tcp': Function(type='int', derefcnt=0, name='ns_verify_tcp', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='ns_tcp_tsig_state', derefcnt=1, name='arg2'), Argument(type='int', derefcnt=0, name='arg3')]),
 'ns_verify_tcp_init': Function(type='int', derefcnt=0, name='ns_verify_tcp_init', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='ns_tcp_tsig_state', derefcnt=1, name='arg3')]),
 'nss_configure_lookup': Function(type='int', derefcnt=0, name='nss_configure_lookup', args=[Argument(type='char', derefcnt=1, name='dbname'), Argument(type='char', derefcnt=1, name='string')]),
 'ntohl': Function(type='uint32_t', derefcnt=0, name='ntohl', args=[Argument(type='uint32_t', derefcnt=0, name='netlong')]),
 'ntohs': Function(type='uint16_t', derefcnt=0, name='ntohs', args=[Argument(type='uint16_t', derefcnt=0, name='netshort')]),
 'num_ciphers': Function(type='int', derefcnt=0, name='num_ciphers', args=[]),
 'o2i_ECPublicKey': Function(type='EC_KEY', derefcnt=1, name='o2i_ECPublicKey', args=[Argument(type='EC_KEY', derefcnt=2, name='key'), Argument(type='unsigned', derefcnt=2, name='in'), Argument(type='long', derefcnt=0, name='len')]),
 'obstack_alloc_failed_handler': Function(type='void', derefcnt=0, name='obstack_alloc_failed_handler', args=[]),
 'obstack_begin': Function(type='int', derefcnt=0, name='obstack_begin', args=[Argument(type='obstack', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='void', derefcnt=1, name='')]),
 'obstack_begin_1': Function(type='int', derefcnt=0, name='obstack_begin_1', args=[Argument(type='obstack', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='void', derefcnt=1, name=''), Argument(type='void', derefcnt=1, name='arg5')]),
 'obstack_free': Function(type='void', derefcnt=0, name='obstack_free', args=[Argument(type='obstack', derefcnt=1, name='obstack'), Argument(type='void', derefcnt=1, name='glibc_block')]),
 'obstack_memory_used': Function(type='int', derefcnt=0, name='obstack_memory_used', args=[Argument(type='obstack', derefcnt=1, name='arg0')]),
 'obstack_newchunk': Function(type='void', derefcnt=0, name='obstack_newchunk', args=[Argument(type='obstack', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'obstack_printf': Function(type='int', derefcnt=0, name='obstack_printf', args=[Argument(type='obstack', derefcnt=1, name='obstack'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'obstack_vprintf': Function(type='int', derefcnt=0, name='obstack_vprintf', args=[Argument(type='obstack', derefcnt=1, name='obstack'), Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='args')]),
 'on_exit': Function(type='int', derefcnt=0, name='on_exit', args=[Argument(type='void', derefcnt=0, name='func'), Argument(type='void', derefcnt=1, name='arg')]),
 'open': Function(type='int', derefcnt=0, name='open', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='int', derefcnt=0, name='vararg')]),
 'open64': Function(type='int', derefcnt=0, name='open64', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='int', derefcnt=0, name='vararg')]),
 'open_by_handle_at': Function(type='int', derefcnt=0, name='open_by_handle_at', args=[Argument(type='int', derefcnt=0, name='mountdirfd'), Argument(type='file_handle', derefcnt=1, name='handle'), Argument(type='int', derefcnt=0, name='flags')]),
 'open_memstream': Function(type='FILE', derefcnt=1, name='open_memstream', args=[Argument(type='char', derefcnt=2, name='bufloc'), Argument(type='size_t', derefcnt=1, name='sizeloc')]),
 'open_wmemstream': Function(type='FILE', derefcnt=1, name='open_wmemstream', args=[Argument(type='wchar_t', derefcnt=2, name='bufloc'), Argument(type='size_t', derefcnt=1, name='sizeloc')]),
 'openat': Function(type='int', derefcnt=0, name='openat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='int', derefcnt=0, name='vararg')]),
 'openat64': Function(type='int', derefcnt=0, name='openat64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='file'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='int', derefcnt=0, name='vararg')]),
 'opendir': Function(type='DIR', derefcnt=1, name='opendir', args=[Argument(type='char', derefcnt=1, name='name')]),
 'openlog': Function(type='void', derefcnt=0, name='openlog', args=[Argument(type='char', derefcnt=1, name='ident'), Argument(type='int', derefcnt=0, name='option'), Argument(type='int', derefcnt=0, name='facility')]),
 'openpty': Function(type='int', derefcnt=0, name='openpty', args=[Argument(type='int', derefcnt=1, name='amaster'), Argument(type='int', derefcnt=1, name='aslave'), Argument(type='char', derefcnt=1, name='name'), Argument(type='termios', derefcnt=1, name='termp'), Argument(type='winsize', derefcnt=1, name='winp')]),
 'option_is_end': Function(type='int', derefcnt=0, name='option_is_end', args=[Argument(type='argp_option', derefcnt=1, name='opt')]),
 'option_is_short': Function(type='int', derefcnt=0, name='option_is_short', args=[Argument(type='argp_option', derefcnt=1, name='opt')]),
 'out_func': Function(type='int', derefcnt=0, name='out_func', args=[Argument(type='void', derefcnt=1, name='arg0'), Argument(type='unsigned', derefcnt=1, name='arg1'), Argument(type='unsigned', derefcnt=0, name='arg2')]),
 'outb': Function(type='void', derefcnt=0, name='outb', args=[Argument(type='unsigned', derefcnt=0, name='value'), Argument(type='unsigned', derefcnt=0, name='port')]),
 'outb_p': Function(type='void', derefcnt=0, name='outb_p', args=[Argument(type='unsigned', derefcnt=0, name='value'), Argument(type='unsigned', derefcnt=0, name='port')]),
 'outl': Function(type='void', derefcnt=0, name='outl', args=[Argument(type='unsigned', derefcnt=0, name='value'), Argument(type='unsigned', derefcnt=0, name='port')]),
 'outl_p': Function(type='void', derefcnt=0, name='outl_p', args=[Argument(type='unsigned', derefcnt=0, name='value'), Argument(type='unsigned', derefcnt=0, name='port')]),
 'outsb': Function(type='void', derefcnt=0, name='outsb', args=[Argument(type='unsigned', derefcnt=0, name='port'), Argument(type='void', derefcnt=1, name='addr'), Argument(type='unsigned', derefcnt=0, name='count')]),
 'outsl': Function(type='void', derefcnt=0, name='outsl', args=[Argument(type='unsigned', derefcnt=0, name='port'), Argument(type='void', derefcnt=1, name='addr'), Argument(type='unsigned', derefcnt=0, name='count')]),
 'outsw': Function(type='void', derefcnt=0, name='outsw', args=[Argument(type='unsigned', derefcnt=0, name='port'), Argument(type='void', derefcnt=1, name='addr'), Argument(type='unsigned', derefcnt=0, name='count')]),
 'outw': Function(type='void', derefcnt=0, name='outw', args=[Argument(type='unsigned', derefcnt=0, name='value'), Argument(type='unsigned', derefcnt=0, name='port')]),
 'outw_p': Function(type='void', derefcnt=0, name='outw_p', args=[Argument(type='unsigned', derefcnt=0, name='value'), Argument(type='unsigned', derefcnt=0, name='port')]),
 'overflow': Function(type='int', derefcnt=0, name='overflow', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'p_cdname': Function(type='u_char', derefcnt=1, name='p_cdname', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='FILE', derefcnt=1, name='arg2')]),
 'p_cdnname': Function(type='u_char', derefcnt=1, name='p_cdnname', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='FILE', derefcnt=1, name='arg3')]),
 'p_class': Function(type='char', derefcnt=1, name='p_class', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'p_fqname': Function(type='u_char', derefcnt=1, name='p_fqname', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='FILE', derefcnt=1, name='arg2')]),
 'p_fqnname': Function(type='u_char', derefcnt=1, name='p_fqnname', args=[Argument(type='u_char', derefcnt=1, name='cp'), Argument(type='u_char', derefcnt=1, name='msg'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='char', derefcnt=1, name='arg3'), Argument(type='int', derefcnt=0, name='arg4')]),
 'p_option': Function(type='char', derefcnt=1, name='p_option', args=[Argument(type='u_long', derefcnt=0, name='option')]),
 'p_query': Function(type='void', derefcnt=0, name='p_query', args=[Argument(type='u_char', derefcnt=1, name='arg0')]),
 'p_rcode': Function(type='char', derefcnt=1, name='p_rcode', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'p_secstodate': Function(type='char', derefcnt=1, name='p_secstodate', args=[Argument(type='u_long', derefcnt=0, name='arg0')]),
 'p_section': Function(type='char', derefcnt=1, name='p_section', args=[Argument(type='int', derefcnt=0, name='section'), Argument(type='int', derefcnt=0, name='opcode')]),
 'p_time': Function(type='char', derefcnt=1, name='p_time', args=[Argument(type='u_int32_t', derefcnt=0, name='arg0')]),
 'p_type': Function(type='char', derefcnt=1, name='p_type', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'parse_printf_format': Function(type='size_t', derefcnt=0, name='parse_printf_format', args=[Argument(type='char', derefcnt=1, name='fmt'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=1, name='argtypes')]),
 'pathconf': Function(type='long', derefcnt=0, name='pathconf', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='int', derefcnt=0, name='name')]),
 'pause': Function(type='int', derefcnt=0, name='pause', args=[]),
 'pclose': Function(type='int', derefcnt=0, name='pclose', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'pem_password_cb': Function(type='int', derefcnt=0, name='pem_password_cb', args=[Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='size'), Argument(type='int', derefcnt=0, name='rwflag'), Argument(type='void', derefcnt=1, name='userdata')]),
 'perror': Function(type='void', derefcnt=0, name='perror', args=[Argument(type='char', derefcnt=1, name='s')]),
 'pipe': Function(type='int', derefcnt=0, name='pipe', args=[Argument(type='int', derefcnt=1, name='pipedes')]),
 'pipe2': Function(type='int', derefcnt=0, name='pipe2', args=[Argument(type='int', derefcnt=1, name='pipedes'), Argument(type='int', derefcnt=0, name='flags')]),
 'pitem_free': Function(type='void', derefcnt=0, name='pitem_free', args=[Argument(type='pitem', derefcnt=1, name='item')]),
 'pitem_new': Function(type='pitem', derefcnt=1, name='pitem_new', args=[Argument(type='unsigned', derefcnt=1, name='prio64be'), Argument(type='void', derefcnt=1, name='data')]),
 'poll': Function(type='int', derefcnt=0, name='poll', args=[Argument(type='pollfd', derefcnt=1, name='fds'), Argument(type='nfds_t', derefcnt=0, name='nfds'), Argument(type='int', derefcnt=0, name='timeout')]),
 'popen': Function(type='FILE', derefcnt=1, name='popen', args=[Argument(type='char', derefcnt=1, name='command'), Argument(type='char', derefcnt=1, name='modes')]),
 'posix_fadvise': Function(type='int', derefcnt=0, name='posix_fadvise', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off_t', derefcnt=0, name='offset'), Argument(type='off_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='advise')]),
 'posix_fadvise64': Function(type='int', derefcnt=0, name='posix_fadvise64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off64_t', derefcnt=0, name='offset'), Argument(type='off64_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='advise')]),
 'posix_fallocate': Function(type='int', derefcnt=0, name='posix_fallocate', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off_t', derefcnt=0, name='offset'), Argument(type='off_t', derefcnt=0, name='len')]),
 'posix_fallocate64': Function(type='int', derefcnt=0, name='posix_fallocate64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off64_t', derefcnt=0, name='offset'), Argument(type='off64_t', derefcnt=0, name='len')]),
 'posix_madvise': Function(type='int', derefcnt=0, name='posix_madvise', args=[Argument(type='void', derefcnt=1, name='addr'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='advice')]),
 'posix_memalign': Function(type='int', derefcnt=0, name='posix_memalign', args=[Argument(type='void', derefcnt=2, name='memptr'), Argument(type='size_t', derefcnt=0, name='alignment'), Argument(type='size_t', derefcnt=0, name='size')]),
 'posix_openpt': Function(type='int', derefcnt=0, name='posix_openpt', args=[Argument(type='int', derefcnt=0, name='oflag')]),
 'posix_spawn': Function(type='int', derefcnt=0, name='posix_spawn', args=[Argument(type='pid_t', derefcnt=1, name='pid'), Argument(type='char', derefcnt=1, name='path'), Argument(type='posix_spawn_file_actions_t', derefcnt=1, name='file_actions'), Argument(type='posix_spawnattr_t', derefcnt=1, name='attrp'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=2, name='envp')]),
 'posix_spawn_file_actions_addclose': Function(type='int', derefcnt=0, name='posix_spawn_file_actions_addclose', args=[Argument(type='posix_spawn_file_actions_t', derefcnt=1, name='file_actions'), Argument(type='int', derefcnt=0, name='fd')]),
 'posix_spawn_file_actions_adddup2': Function(type='int', derefcnt=0, name='posix_spawn_file_actions_adddup2', args=[Argument(type='posix_spawn_file_actions_t', derefcnt=1, name='file_actions'), Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='newfd')]),
 'posix_spawn_file_actions_addopen': Function(type='int', derefcnt=0, name='posix_spawn_file_actions_addopen', args=[Argument(type='posix_spawn_file_actions_t', derefcnt=1, name='file_actions'), Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='path'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'posix_spawn_file_actions_destroy': Function(type='int', derefcnt=0, name='posix_spawn_file_actions_destroy', args=[Argument(type='posix_spawn_file_actions_t', derefcnt=1, name='file_actions')]),
 'posix_spawn_file_actions_init': Function(type='int', derefcnt=0, name='posix_spawn_file_actions_init', args=[Argument(type='posix_spawn_file_actions_t', derefcnt=1, name='file_actions')]),
 'posix_spawnattr_destroy': Function(type='int', derefcnt=0, name='posix_spawnattr_destroy', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr')]),
 'posix_spawnattr_getflags': Function(type='int', derefcnt=0, name='posix_spawnattr_getflags', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='short', derefcnt=1, name='flags')]),
 'posix_spawnattr_getpgroup': Function(type='int', derefcnt=0, name='posix_spawnattr_getpgroup', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='pid_t', derefcnt=1, name='pgroup')]),
 'posix_spawnattr_getschedparam': Function(type='int', derefcnt=0, name='posix_spawnattr_getschedparam', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='sched_param', derefcnt=1, name='schedparam')]),
 'posix_spawnattr_getschedpolicy': Function(type='int', derefcnt=0, name='posix_spawnattr_getschedpolicy', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='schedpolicy')]),
 'posix_spawnattr_getsigdefault': Function(type='int', derefcnt=0, name='posix_spawnattr_getsigdefault', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='sigset_t', derefcnt=1, name='sigdefault')]),
 'posix_spawnattr_getsigmask': Function(type='int', derefcnt=0, name='posix_spawnattr_getsigmask', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='sigset_t', derefcnt=1, name='sigmask')]),
 'posix_spawnattr_init': Function(type='int', derefcnt=0, name='posix_spawnattr_init', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr')]),
 'posix_spawnattr_setflags': Function(type='int', derefcnt=0, name='posix_spawnattr_setflags', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='short', derefcnt=0, name='flags')]),
 'posix_spawnattr_setpgroup': Function(type='int', derefcnt=0, name='posix_spawnattr_setpgroup', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='pid_t', derefcnt=0, name='pgroup')]),
 'posix_spawnattr_setschedparam': Function(type='int', derefcnt=0, name='posix_spawnattr_setschedparam', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='sched_param', derefcnt=1, name='schedparam')]),
 'posix_spawnattr_setschedpolicy': Function(type='int', derefcnt=0, name='posix_spawnattr_setschedpolicy', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='schedpolicy')]),
 'posix_spawnattr_setsigdefault': Function(type='int', derefcnt=0, name='posix_spawnattr_setsigdefault', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='sigset_t', derefcnt=1, name='sigdefault')]),
 'posix_spawnattr_setsigmask': Function(type='int', derefcnt=0, name='posix_spawnattr_setsigmask', args=[Argument(type='posix_spawnattr_t', derefcnt=1, name='attr'), Argument(type='sigset_t', derefcnt=1, name='sigmask')]),
 'posix_spawnp': Function(type='int', derefcnt=0, name='posix_spawnp', args=[Argument(type='pid_t', derefcnt=1, name='pid'), Argument(type='char', derefcnt=1, name='file'), Argument(type='posix_spawn_file_actions_t', derefcnt=1, name='file_actions'), Argument(type='posix_spawnattr_t', derefcnt=1, name='attrp'), Argument(type='char', derefcnt=2, name='argv'), Argument(type='char', derefcnt=2, name='envp')]),
 'pow': Function(type='double', derefcnt=0, name='pow', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'pow10': Function(type='double', derefcnt=0, name='pow10', args=[Argument(type='double', derefcnt=0, name='x')]),
 'pow10f': Function(type='float', derefcnt=0, name='pow10f', args=[Argument(type='float', derefcnt=0, name='x')]),
 'pow10l': Function(type='long', derefcnt=0, name='pow10l', args=[Argument(type='long', derefcnt=0, name='x')]),
 'powf': Function(type='float', derefcnt=0, name='powf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'powl': Function(type='long', derefcnt=0, name='powl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'ppoll': Function(type='int', derefcnt=0, name='ppoll', args=[Argument(type='pollfd', derefcnt=1, name='fds'), Argument(type='nfds_t', derefcnt=0, name='nfds'), Argument(type='timespec', derefcnt=1, name='timeout'), Argument(type='sigset_t', derefcnt=1, name='ss')]),
 'pqueue_find': Function(type='pitem', derefcnt=1, name='pqueue_find', args=[Argument(type='pqueue', derefcnt=0, name='pq'), Argument(type='unsigned', derefcnt=1, name='prio64be')]),
 'pqueue_free': Function(type='void', derefcnt=0, name='pqueue_free', args=[Argument(type='pqueue', derefcnt=0, name='pq')]),
 'pqueue_insert': Function(type='pitem', derefcnt=1, name='pqueue_insert', args=[Argument(type='pqueue', derefcnt=0, name='pq'), Argument(type='pitem', derefcnt=1, name='item')]),
 'pqueue_iterator': Function(type='pitem', derefcnt=1, name='pqueue_iterator', args=[Argument(type='pqueue', derefcnt=0, name='pq')]),
 'pqueue_new': Function(type='pqueue', derefcnt=0, name='pqueue_new', args=[]),
 'pqueue_next': Function(type='pitem', derefcnt=1, name='pqueue_next', args=[Argument(type='piterator', derefcnt=1, name='iter')]),
 'pqueue_peek': Function(type='pitem', derefcnt=1, name='pqueue_peek', args=[Argument(type='pqueue', derefcnt=0, name='pq')]),
 'pqueue_pop': Function(type='pitem', derefcnt=1, name='pqueue_pop', args=[Argument(type='pqueue', derefcnt=0, name='pq')]),
 'pqueue_print': Function(type='void', derefcnt=0, name='pqueue_print', args=[Argument(type='pqueue', derefcnt=0, name='pq')]),
 'pqueue_size': Function(type='int', derefcnt=0, name='pqueue_size', args=[Argument(type='pqueue', derefcnt=0, name='pq')]),
 'prctl': Function(type='int', derefcnt=0, name='prctl', args=[Argument(type='int', derefcnt=0, name='option'), Argument(type='int', derefcnt=0, name='vararg')]),
 'pread': Function(type='ssize_t', derefcnt=0, name='pread', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes'), Argument(type='off_t', derefcnt=0, name='offset')]),
 '__pread_chk': Function(type='ssize_t', derefcnt=0, name='__pread_chk', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes'), Argument(type='off_t', derefcnt=0, name='offset'), Argument(type='size_t', derefcnt=0, name='buflen')]),
 'pread64': Function(type='ssize_t', derefcnt=0, name='pread64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes'), Argument(type='off64_t', derefcnt=0, name='offset')]),
 'preadv': Function(type='ssize_t', derefcnt=0, name='preadv', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='iovec', derefcnt=1, name='iovec'), Argument(type='int', derefcnt=0, name='count'), Argument(type='off_t', derefcnt=0, name='offset')]),
 'preadv64': Function(type='ssize_t', derefcnt=0, name='preadv64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='iovec', derefcnt=1, name='iovec'), Argument(type='int', derefcnt=0, name='count'), Argument(type='off64_t', derefcnt=0, name='offset')]),
 'printf': Function(type='int', derefcnt=0, name='printf', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 '__printf_chk': Function(type='int', derefcnt=0, name='__printf_chk', args=[Argument(type='int', derefcnt=0, name='flag'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'printf_arginfo_function': Function(type='int', derefcnt=0, name='printf_arginfo_function', args=[Argument(type='printf_info', derefcnt=1, name='info'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=1, name='argtypes')]),
 'printf_arginfo_size_function': Function(type='int', derefcnt=0, name='printf_arginfo_size_function', args=[Argument(type='printf_info', derefcnt=1, name='info'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=1, name='argtypes'), Argument(type='int', derefcnt=1, name='size')]),
 'printf_function': Function(type='int', derefcnt=0, name='printf_function', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='printf_info', derefcnt=1, name='info'), Argument(type='void', derefcnt=2, name='args')]),
 'printf_size': Function(type='int', derefcnt=0, name='printf_size', args=[Argument(type='FILE', derefcnt=1, name='fp'), Argument(type='printf_info', derefcnt=1, name='info'), Argument(type='void', derefcnt=2, name='args')]),
 'printf_size_info': Function(type='int', derefcnt=0, name='printf_size_info', args=[Argument(type='printf_info', derefcnt=1, name='info'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=1, name='argtypes')]),
 'printf_va_arg_function': Function(type='void', derefcnt=0, name='printf_va_arg_function', args=[Argument(type='void', derefcnt=1, name='mem'), Argument(type='va_list', derefcnt=1, name='ap')]),
 'prlimit': Function(type='int', derefcnt=0, name='prlimit', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='rlimit_resource', derefcnt=0, name='resource'), Argument(type='rlimit', derefcnt=1, name='new_limit'), Argument(type='rlimit', derefcnt=1, name='old_limit')]),
 'prlimit64': Function(type='int', derefcnt=0, name='prlimit64', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='rlimit_resource', derefcnt=0, name='resource'), Argument(type='rlimit64', derefcnt=1, name='new_limit'), Argument(type='rlimit64', derefcnt=1, name='old_limit')]),
 'process_vm_readv': Function(type='ssize_t', derefcnt=0, name='process_vm_readv', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='iovec', derefcnt=1, name='lvec'), Argument(type='unsigned', derefcnt=0, name='liovcnt'), Argument(type='iovec', derefcnt=1, name='rvec'), Argument(type='unsigned', derefcnt=0, name='riovcnt'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'process_vm_writev': Function(type='ssize_t', derefcnt=0, name='process_vm_writev', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='iovec', derefcnt=1, name='lvec'), Argument(type='unsigned', derefcnt=0, name='liovcnt'), Argument(type='iovec', derefcnt=1, name='rvec'), Argument(type='unsigned', derefcnt=0, name='riovcnt'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'profil': Function(type='int', derefcnt=0, name='profil', args=[Argument(type='unsigned', derefcnt=1, name='sample_buffer'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='size_t', derefcnt=0, name='offset'), Argument(type='unsigned', derefcnt=0, name='scale')]),
 'pselect': Function(type='int', derefcnt=0, name='pselect', args=[Argument(type='int', derefcnt=0, name='nfds'), Argument(type='fd_set', derefcnt=1, name='readfds'), Argument(type='fd_set', derefcnt=1, name='writefds'), Argument(type='fd_set', derefcnt=1, name='exceptfds'), Argument(type='timespec', derefcnt=1, name='timeout'), Argument(type='sigset_t', derefcnt=1, name='sigmask')]),
 'psiginfo': Function(type='void', derefcnt=0, name='psiginfo', args=[Argument(type='siginfo_t', derefcnt=1, name='pinfo'), Argument(type='char', derefcnt=1, name='s')]),
 'psignal': Function(type='void', derefcnt=0, name='psignal', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='char', derefcnt=1, name='s')]),
 'psk_client_callback': Function(type='unsigned', derefcnt=0, name='psk_client_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='char', derefcnt=1, name='hint'), Argument(type='char', derefcnt=1, name='identity'), Argument(type='unsigned', derefcnt=0, name='max_identity_len'), Argument(type='unsigned', derefcnt=1, name='psk'), Argument(type='unsigned', derefcnt=0, name='max_psk_len')]),
 'psk_server_callback': Function(type='unsigned', derefcnt=0, name='psk_server_callback', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='char', derefcnt=1, name='identity'), Argument(type='unsigned', derefcnt=1, name='psk'), Argument(type='unsigned', derefcnt=0, name='max_psk_len')]),
 'pthread_atfork': Function(type='int', derefcnt=0, name='pthread_atfork', args=[Argument(type='void', derefcnt=0, name='prepare'), Argument(type='void', derefcnt=0, name='parent'), Argument(type='void', derefcnt=0, name='child')]),
 'pthread_attr_destroy': Function(type='int', derefcnt=0, name='pthread_attr_destroy', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr')]),
 'pthread_attr_getaffinity_np': Function(type='int', derefcnt=0, name='pthread_attr_getaffinity_np', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='size_t', derefcnt=0, name='cpusetsize'), Argument(type='cpu_set_t', derefcnt=1, name='cpuset')]),
 'pthread_attr_getdetachstate': Function(type='int', derefcnt=0, name='pthread_attr_getdetachstate', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='detachstate')]),
 'pthread_attr_getguardsize': Function(type='int', derefcnt=0, name='pthread_attr_getguardsize', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='size_t', derefcnt=1, name='guardsize')]),
 'pthread_attr_getinheritsched': Function(type='int', derefcnt=0, name='pthread_attr_getinheritsched', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='inherit')]),
 'pthread_attr_getschedparam': Function(type='int', derefcnt=0, name='pthread_attr_getschedparam', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='sched_param', derefcnt=1, name='param')]),
 'pthread_attr_getschedpolicy': Function(type='int', derefcnt=0, name='pthread_attr_getschedpolicy', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='policy')]),
 'pthread_attr_getscope': Function(type='int', derefcnt=0, name='pthread_attr_getscope', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='scope')]),
 'pthread_attr_getstack': Function(type='int', derefcnt=0, name='pthread_attr_getstack', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='void', derefcnt=2, name='stackaddr'), Argument(type='size_t', derefcnt=1, name='stacksize')]),
 'pthread_attr_getstackaddr': Function(type='int', derefcnt=0, name='pthread_attr_getstackaddr', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='void', derefcnt=2, name='stackaddr')]),
 'pthread_attr_getstacksize': Function(type='int', derefcnt=0, name='pthread_attr_getstacksize', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='size_t', derefcnt=1, name='stacksize')]),
 'pthread_attr_init': Function(type='int', derefcnt=0, name='pthread_attr_init', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr')]),
 'pthread_attr_setaffinity_np': Function(type='int', derefcnt=0, name='pthread_attr_setaffinity_np', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='size_t', derefcnt=0, name='cpusetsize'), Argument(type='cpu_set_t', derefcnt=1, name='cpuset')]),
 'pthread_attr_setdetachstate': Function(type='int', derefcnt=0, name='pthread_attr_setdetachstate', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='detachstate')]),
 'pthread_attr_setguardsize': Function(type='int', derefcnt=0, name='pthread_attr_setguardsize', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='size_t', derefcnt=0, name='guardsize')]),
 'pthread_attr_setinheritsched': Function(type='int', derefcnt=0, name='pthread_attr_setinheritsched', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='inherit')]),
 'pthread_attr_setschedparam': Function(type='int', derefcnt=0, name='pthread_attr_setschedparam', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='sched_param', derefcnt=1, name='param')]),
 'pthread_attr_setschedpolicy': Function(type='int', derefcnt=0, name='pthread_attr_setschedpolicy', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='policy')]),
 'pthread_attr_setscope': Function(type='int', derefcnt=0, name='pthread_attr_setscope', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='scope')]),
 'pthread_attr_setstack': Function(type='int', derefcnt=0, name='pthread_attr_setstack', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='void', derefcnt=1, name='stackaddr'), Argument(type='size_t', derefcnt=0, name='stacksize')]),
 'pthread_attr_setstackaddr': Function(type='int', derefcnt=0, name='pthread_attr_setstackaddr', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='void', derefcnt=1, name='stackaddr')]),
 'pthread_attr_setstacksize': Function(type='int', derefcnt=0, name='pthread_attr_setstacksize', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='size_t', derefcnt=0, name='stacksize')]),
 'pthread_barrier_destroy': Function(type='int', derefcnt=0, name='pthread_barrier_destroy', args=[Argument(type='pthread_barrier_t', derefcnt=1, name='barrier')]),
 'pthread_barrier_init': Function(type='int', derefcnt=0, name='pthread_barrier_init', args=[Argument(type='pthread_barrier_t', derefcnt=1, name='barrier'), Argument(type='pthread_barrierattr_t', derefcnt=1, name='attr'), Argument(type='unsigned', derefcnt=0, name='count')]),
 'pthread_barrier_wait': Function(type='int', derefcnt=0, name='pthread_barrier_wait', args=[Argument(type='pthread_barrier_t', derefcnt=1, name='barrier')]),
 'pthread_barrierattr_destroy': Function(type='int', derefcnt=0, name='pthread_barrierattr_destroy', args=[Argument(type='pthread_barrierattr_t', derefcnt=1, name='attr')]),
 'pthread_barrierattr_getpshared': Function(type='int', derefcnt=0, name='pthread_barrierattr_getpshared', args=[Argument(type='pthread_barrierattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='pshared')]),
 'pthread_barrierattr_init': Function(type='int', derefcnt=0, name='pthread_barrierattr_init', args=[Argument(type='pthread_barrierattr_t', derefcnt=1, name='attr')]),
 'pthread_barrierattr_setpshared': Function(type='int', derefcnt=0, name='pthread_barrierattr_setpshared', args=[Argument(type='pthread_barrierattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='pshared')]),
 'pthread_cancel': Function(type='int', derefcnt=0, name='pthread_cancel', args=[Argument(type='pthread_t', derefcnt=0, name='th')]),
 'pthread_cond_broadcast': Function(type='int', derefcnt=0, name='pthread_cond_broadcast', args=[Argument(type='pthread_cond_t', derefcnt=1, name='cond')]),
 'pthread_cond_destroy': Function(type='int', derefcnt=0, name='pthread_cond_destroy', args=[Argument(type='pthread_cond_t', derefcnt=1, name='cond')]),
 'pthread_cond_init': Function(type='int', derefcnt=0, name='pthread_cond_init', args=[Argument(type='pthread_cond_t', derefcnt=1, name='cond'), Argument(type='pthread_condattr_t', derefcnt=1, name='cond_attr')]),
 'pthread_cond_signal': Function(type='int', derefcnt=0, name='pthread_cond_signal', args=[Argument(type='pthread_cond_t', derefcnt=1, name='cond')]),
 'pthread_cond_timedwait': Function(type='int', derefcnt=0, name='pthread_cond_timedwait', args=[Argument(type='pthread_cond_t', derefcnt=1, name='cond'), Argument(type='pthread_mutex_t', derefcnt=1, name='mutex'), Argument(type='timespec', derefcnt=1, name='abstime')]),
 'pthread_cond_wait': Function(type='int', derefcnt=0, name='pthread_cond_wait', args=[Argument(type='pthread_cond_t', derefcnt=1, name='cond'), Argument(type='pthread_mutex_t', derefcnt=1, name='mutex')]),
 'pthread_condattr_destroy': Function(type='int', derefcnt=0, name='pthread_condattr_destroy', args=[Argument(type='pthread_condattr_t', derefcnt=1, name='attr')]),
 'pthread_condattr_getclock': Function(type='int', derefcnt=0, name='pthread_condattr_getclock', args=[Argument(type='pthread_condattr_t', derefcnt=1, name='attr'), Argument(type='clockid_t', derefcnt=1, name='clock_id')]),
 'pthread_condattr_getpshared': Function(type='int', derefcnt=0, name='pthread_condattr_getpshared', args=[Argument(type='pthread_condattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='pshared')]),
 'pthread_condattr_init': Function(type='int', derefcnt=0, name='pthread_condattr_init', args=[Argument(type='pthread_condattr_t', derefcnt=1, name='attr')]),
 'pthread_condattr_setclock': Function(type='int', derefcnt=0, name='pthread_condattr_setclock', args=[Argument(type='pthread_condattr_t', derefcnt=1, name='attr'), Argument(type='clockid_t', derefcnt=0, name='clock_id')]),
 'pthread_condattr_setpshared': Function(type='int', derefcnt=0, name='pthread_condattr_setpshared', args=[Argument(type='pthread_condattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='pshared')]),
 'pthread_create': Function(type='int', derefcnt=0, name='pthread_create', args=[Argument(type='pthread_t', derefcnt=1, name='newthread'), Argument(type='pthread_attr_t', derefcnt=1, name='attr'), Argument(type='void', derefcnt=1, name='start_routine'), Argument(type='void', derefcnt=1, name='arg')]),
 'pthread_detach': Function(type='int', derefcnt=0, name='pthread_detach', args=[Argument(type='pthread_t', derefcnt=0, name='th')]),
 'pthread_equal': Function(type='int', derefcnt=0, name='pthread_equal', args=[Argument(type='pthread_t', derefcnt=0, name='thread1'), Argument(type='pthread_t', derefcnt=0, name='thread2')]),
 'pthread_exit': Function(type='void', derefcnt=0, name='pthread_exit', args=[Argument(type='void', derefcnt=1, name='retval')]),
 'pthread_getaffinity_np': Function(type='int', derefcnt=0, name='pthread_getaffinity_np', args=[Argument(type='pthread_t', derefcnt=0, name='th'), Argument(type='size_t', derefcnt=0, name='cpusetsize'), Argument(type='cpu_set_t', derefcnt=1, name='cpuset')]),
 'pthread_getattr_default_np': Function(type='int', derefcnt=0, name='pthread_getattr_default_np', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr')]),
 'pthread_getattr_np': Function(type='int', derefcnt=0, name='pthread_getattr_np', args=[Argument(type='pthread_t', derefcnt=0, name='th'), Argument(type='pthread_attr_t', derefcnt=1, name='attr')]),
 'pthread_getconcurrency': Function(type='int', derefcnt=0, name='pthread_getconcurrency', args=[]),
 'pthread_getcpuclockid': Function(type='int', derefcnt=0, name='pthread_getcpuclockid', args=[Argument(type='pthread_t', derefcnt=0, name='thread_id'), Argument(type='clockid_t', derefcnt=1, name='clock_id')]),
 'pthread_getname_np': Function(type='int', derefcnt=0, name='pthread_getname_np', args=[Argument(type='pthread_t', derefcnt=0, name='target_thread'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen')]),
 'pthread_getschedparam': Function(type='int', derefcnt=0, name='pthread_getschedparam', args=[Argument(type='pthread_t', derefcnt=0, name='target_thread'), Argument(type='int', derefcnt=1, name='policy'), Argument(type='sched_param', derefcnt=1, name='param')]),
 'pthread_getspecific': Function(type='void', derefcnt=1, name='pthread_getspecific', args=[Argument(type='pthread_key_t', derefcnt=0, name='key')]),
 'pthread_join': Function(type='int', derefcnt=0, name='pthread_join', args=[Argument(type='pthread_t', derefcnt=0, name='th'), Argument(type='void', derefcnt=2, name='thread_return')]),
 'pthread_key_create': Function(type='int', derefcnt=0, name='pthread_key_create', args=[Argument(type='pthread_key_t', derefcnt=1, name='key'), Argument(type='void', derefcnt=0, name='destr_function')]),
 'pthread_key_delete': Function(type='int', derefcnt=0, name='pthread_key_delete', args=[Argument(type='pthread_key_t', derefcnt=0, name='key')]),
 'pthread_kill': Function(type='int', derefcnt=0, name='pthread_kill', args=[Argument(type='pthread_t', derefcnt=0, name='threadid'), Argument(type='int', derefcnt=0, name='signo')]),
 'pthread_mutex_consistent': Function(type='int', derefcnt=0, name='pthread_mutex_consistent', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex')]),
 'pthread_mutex_consistent_np': Function(type='int', derefcnt=0, name='pthread_mutex_consistent_np', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex')]),
 'pthread_mutex_destroy': Function(type='int', derefcnt=0, name='pthread_mutex_destroy', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex')]),
 'pthread_mutex_getprioceiling': Function(type='int', derefcnt=0, name='pthread_mutex_getprioceiling', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex'), Argument(type='int', derefcnt=1, name='prioceiling')]),
 'pthread_mutex_init': Function(type='int', derefcnt=0, name='pthread_mutex_init', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex'), Argument(type='pthread_mutexattr_t', derefcnt=1, name='mutexattr')]),
 'pthread_mutex_lock': Function(type='int', derefcnt=0, name='pthread_mutex_lock', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex')]),
 'pthread_mutex_setprioceiling': Function(type='int', derefcnt=0, name='pthread_mutex_setprioceiling', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex'), Argument(type='int', derefcnt=0, name='prioceiling'), Argument(type='int', derefcnt=1, name='old_ceiling')]),
 'pthread_mutex_timedlock': Function(type='int', derefcnt=0, name='pthread_mutex_timedlock', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex'), Argument(type='timespec', derefcnt=1, name='abstime')]),
 'pthread_mutex_trylock': Function(type='int', derefcnt=0, name='pthread_mutex_trylock', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex')]),
 'pthread_mutex_unlock': Function(type='int', derefcnt=0, name='pthread_mutex_unlock', args=[Argument(type='pthread_mutex_t', derefcnt=1, name='mutex')]),
 'pthread_mutexattr_destroy': Function(type='int', derefcnt=0, name='pthread_mutexattr_destroy', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr')]),
 'pthread_mutexattr_getprioceiling': Function(type='int', derefcnt=0, name='pthread_mutexattr_getprioceiling', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='prioceiling')]),
 'pthread_mutexattr_getprotocol': Function(type='int', derefcnt=0, name='pthread_mutexattr_getprotocol', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='protocol')]),
 'pthread_mutexattr_getpshared': Function(type='int', derefcnt=0, name='pthread_mutexattr_getpshared', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='pshared')]),
 'pthread_mutexattr_getrobust': Function(type='int', derefcnt=0, name='pthread_mutexattr_getrobust', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='robustness')]),
 'pthread_mutexattr_getrobust_np': Function(type='int', derefcnt=0, name='pthread_mutexattr_getrobust_np', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='robustness')]),
 'pthread_mutexattr_gettype': Function(type='int', derefcnt=0, name='pthread_mutexattr_gettype', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='kind')]),
 'pthread_mutexattr_init': Function(type='int', derefcnt=0, name='pthread_mutexattr_init', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr')]),
 'pthread_mutexattr_setprioceiling': Function(type='int', derefcnt=0, name='pthread_mutexattr_setprioceiling', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='prioceiling')]),
 'pthread_mutexattr_setprotocol': Function(type='int', derefcnt=0, name='pthread_mutexattr_setprotocol', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='protocol')]),
 'pthread_mutexattr_setpshared': Function(type='int', derefcnt=0, name='pthread_mutexattr_setpshared', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='pshared')]),
 'pthread_mutexattr_setrobust': Function(type='int', derefcnt=0, name='pthread_mutexattr_setrobust', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='robustness')]),
 'pthread_mutexattr_setrobust_np': Function(type='int', derefcnt=0, name='pthread_mutexattr_setrobust_np', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='robustness')]),
 'pthread_mutexattr_settype': Function(type='int', derefcnt=0, name='pthread_mutexattr_settype', args=[Argument(type='pthread_mutexattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='kind')]),
 'pthread_once': Function(type='int', derefcnt=0, name='pthread_once', args=[Argument(type='pthread_once_t', derefcnt=1, name='once_control'), Argument(type='void', derefcnt=0, name='init_routine')]),
 'pthread_register_cancel': Function(type='void', derefcnt=0, name='pthread_register_cancel', args=[Argument(type='pthread_unwind_buf_t', derefcnt=1, name='buf')]),
 'pthread_register_cancel_defer': Function(type='void', derefcnt=0, name='pthread_register_cancel_defer', args=[Argument(type='pthread_unwind_buf_t', derefcnt=1, name='buf')]),
 'pthread_rwlock_destroy': Function(type='int', derefcnt=0, name='pthread_rwlock_destroy', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock')]),
 'pthread_rwlock_init': Function(type='int', derefcnt=0, name='pthread_rwlock_init', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock'), Argument(type='pthread_rwlockattr_t', derefcnt=1, name='attr')]),
 'pthread_rwlock_rdlock': Function(type='int', derefcnt=0, name='pthread_rwlock_rdlock', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock')]),
 'pthread_rwlock_timedrdlock': Function(type='int', derefcnt=0, name='pthread_rwlock_timedrdlock', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock'), Argument(type='timespec', derefcnt=1, name='abstime')]),
 'pthread_rwlock_timedwrlock': Function(type='int', derefcnt=0, name='pthread_rwlock_timedwrlock', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock'), Argument(type='timespec', derefcnt=1, name='abstime')]),
 'pthread_rwlock_tryrdlock': Function(type='int', derefcnt=0, name='pthread_rwlock_tryrdlock', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock')]),
 'pthread_rwlock_trywrlock': Function(type='int', derefcnt=0, name='pthread_rwlock_trywrlock', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock')]),
 'pthread_rwlock_unlock': Function(type='int', derefcnt=0, name='pthread_rwlock_unlock', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock')]),
 'pthread_rwlock_wrlock': Function(type='int', derefcnt=0, name='pthread_rwlock_wrlock', args=[Argument(type='pthread_rwlock_t', derefcnt=1, name='rwlock')]),
 'pthread_rwlockattr_destroy': Function(type='int', derefcnt=0, name='pthread_rwlockattr_destroy', args=[Argument(type='pthread_rwlockattr_t', derefcnt=1, name='attr')]),
 'pthread_rwlockattr_getkind_np': Function(type='int', derefcnt=0, name='pthread_rwlockattr_getkind_np', args=[Argument(type='pthread_rwlockattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='pref')]),
 'pthread_rwlockattr_getpshared': Function(type='int', derefcnt=0, name='pthread_rwlockattr_getpshared', args=[Argument(type='pthread_rwlockattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=1, name='pshared')]),
 'pthread_rwlockattr_init': Function(type='int', derefcnt=0, name='pthread_rwlockattr_init', args=[Argument(type='pthread_rwlockattr_t', derefcnt=1, name='attr')]),
 'pthread_rwlockattr_setkind_np': Function(type='int', derefcnt=0, name='pthread_rwlockattr_setkind_np', args=[Argument(type='pthread_rwlockattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='pref')]),
 'pthread_rwlockattr_setpshared': Function(type='int', derefcnt=0, name='pthread_rwlockattr_setpshared', args=[Argument(type='pthread_rwlockattr_t', derefcnt=1, name='attr'), Argument(type='int', derefcnt=0, name='pshared')]),
 'pthread_self': Function(type='pthread_t', derefcnt=0, name='pthread_self', args=[]),
 'pthread_setaffinity_np': Function(type='int', derefcnt=0, name='pthread_setaffinity_np', args=[Argument(type='pthread_t', derefcnt=0, name='th'), Argument(type='size_t', derefcnt=0, name='cpusetsize'), Argument(type='cpu_set_t', derefcnt=1, name='cpuset')]),
 'pthread_setattr_default_np': Function(type='int', derefcnt=0, name='pthread_setattr_default_np', args=[Argument(type='pthread_attr_t', derefcnt=1, name='attr')]),
 'pthread_setcancelstate': Function(type='int', derefcnt=0, name='pthread_setcancelstate', args=[Argument(type='int', derefcnt=0, name='state'), Argument(type='int', derefcnt=1, name='oldstate')]),
 'pthread_setcanceltype': Function(type='int', derefcnt=0, name='pthread_setcanceltype', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=1, name='oldtype')]),
 'pthread_setconcurrency': Function(type='int', derefcnt=0, name='pthread_setconcurrency', args=[Argument(type='int', derefcnt=0, name='level')]),
 'pthread_setname_np': Function(type='int', derefcnt=0, name='pthread_setname_np', args=[Argument(type='pthread_t', derefcnt=0, name='target_thread'), Argument(type='char', derefcnt=1, name='name')]),
 'pthread_setschedparam': Function(type='int', derefcnt=0, name='pthread_setschedparam', args=[Argument(type='pthread_t', derefcnt=0, name='target_thread'), Argument(type='int', derefcnt=0, name='policy'), Argument(type='sched_param', derefcnt=1, name='param')]),
 'pthread_setschedprio': Function(type='int', derefcnt=0, name='pthread_setschedprio', args=[Argument(type='pthread_t', derefcnt=0, name='target_thread'), Argument(type='int', derefcnt=0, name='prio')]),
 'pthread_setspecific': Function(type='int', derefcnt=0, name='pthread_setspecific', args=[Argument(type='pthread_key_t', derefcnt=0, name='key'), Argument(type='void', derefcnt=1, name='pointer')]),
 'pthread_sigmask': Function(type='int', derefcnt=0, name='pthread_sigmask', args=[Argument(type='int', derefcnt=0, name='how'), Argument(type='sigset_t', derefcnt=1, name='newmask'), Argument(type='sigset_t', derefcnt=1, name='oldmask')]),
 'pthread_sigqueue': Function(type='int', derefcnt=0, name='pthread_sigqueue', args=[Argument(type='pthread_t', derefcnt=0, name='threadid'), Argument(type='int', derefcnt=0, name='signo'), Argument(type='sigval', derefcnt=0, name='value')]),
 'pthread_spin_destroy': Function(type='int', derefcnt=0, name='pthread_spin_destroy', args=[Argument(type='pthread_spinlock_t', derefcnt=1, name='lock')]),
 'pthread_spin_init': Function(type='int', derefcnt=0, name='pthread_spin_init', args=[Argument(type='pthread_spinlock_t', derefcnt=1, name='lock'), Argument(type='int', derefcnt=0, name='pshared')]),
 'pthread_spin_lock': Function(type='int', derefcnt=0, name='pthread_spin_lock', args=[Argument(type='pthread_spinlock_t', derefcnt=1, name='lock')]),
 'pthread_spin_trylock': Function(type='int', derefcnt=0, name='pthread_spin_trylock', args=[Argument(type='pthread_spinlock_t', derefcnt=1, name='lock')]),
 'pthread_spin_unlock': Function(type='int', derefcnt=0, name='pthread_spin_unlock', args=[Argument(type='pthread_spinlock_t', derefcnt=1, name='lock')]),
 'pthread_testcancel': Function(type='void', derefcnt=0, name='pthread_testcancel', args=[]),
 'pthread_timedjoin_np': Function(type='int', derefcnt=0, name='pthread_timedjoin_np', args=[Argument(type='pthread_t', derefcnt=0, name='th'), Argument(type='void', derefcnt=2, name='thread_return'), Argument(type='timespec', derefcnt=1, name='abstime')]),
 'pthread_tryjoin_np': Function(type='int', derefcnt=0, name='pthread_tryjoin_np', args=[Argument(type='pthread_t', derefcnt=0, name='th'), Argument(type='void', derefcnt=2, name='thread_return')]),
 'pthread_unregister_cancel': Function(type='void', derefcnt=0, name='pthread_unregister_cancel', args=[Argument(type='pthread_unwind_buf_t', derefcnt=1, name='buf')]),
 'pthread_unregister_cancel_restore': Function(type='void', derefcnt=0, name='pthread_unregister_cancel_restore', args=[Argument(type='pthread_unwind_buf_t', derefcnt=1, name='buf')]),
 'pthread_unwind_next': Function(type='void', derefcnt=0, name='pthread_unwind_next', args=[Argument(type='pthread_unwind_buf_t', derefcnt=1, name='buf')]),
 'pthread_yield': Function(type='int', derefcnt=0, name='pthread_yield', args=[]),
 'ptrace': Function(type='long', derefcnt=0, name='ptrace', args=[Argument(type='ptrace_request', derefcnt=0, name='request'), Argument(type='int', derefcnt=0, name='vararg')]),
 'ptsname': Function(type='char', derefcnt=1, name='ptsname', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'ptsname_r': Function(type='int', derefcnt=0, name='ptsname_r', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen')]),
 'put_cipher_by_char': Function(type='int', derefcnt=0, name='put_cipher_by_char', args=[Argument(type='SSL_CIPHER', derefcnt=1, name='cipher'), Argument(type='unsigned', derefcnt=1, name='ptr')]),
 'putc': Function(type='int', derefcnt=0, name='putc', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'putc_unlocked': Function(type='int', derefcnt=0, name='putc_unlocked', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'putchar': Function(type='int', derefcnt=0, name='putchar', args=[Argument(type='int', derefcnt=0, name='c')]),
 'putchar_unlocked': Function(type='int', derefcnt=0, name='putchar_unlocked', args=[Argument(type='int', derefcnt=0, name='c')]),
 'putenv': Function(type='int', derefcnt=0, name='putenv', args=[Argument(type='char', derefcnt=1, name='string')]),
 'putgrent': Function(type='int', derefcnt=0, name='putgrent', args=[Argument(type='group', derefcnt=1, name='p'), Argument(type='FILE', derefcnt=1, name='f')]),
 'putlong': Function(type='void', derefcnt=0, name='putlong', args=[Argument(type='u_int32_t', derefcnt=0, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1')]),
 'putmsg': Function(type='int', derefcnt=0, name='putmsg', args=[Argument(type='int', derefcnt=0, name='fildes'), Argument(type='strbuf', derefcnt=1, name='ctlptr'), Argument(type='strbuf', derefcnt=1, name='dataptr'), Argument(type='int', derefcnt=0, name='flags')]),
 'putpmsg': Function(type='int', derefcnt=0, name='putpmsg', args=[Argument(type='int', derefcnt=0, name='fildes'), Argument(type='strbuf', derefcnt=1, name='ctlptr'), Argument(type='strbuf', derefcnt=1, name='dataptr'), Argument(type='int', derefcnt=0, name='band'), Argument(type='int', derefcnt=0, name='flags')]),
 'putpwent': Function(type='int', derefcnt=0, name='putpwent', args=[Argument(type='passwd', derefcnt=1, name='p'), Argument(type='FILE', derefcnt=1, name='f')]),
 'puts': Function(type='int', derefcnt=0, name='puts', args=[Argument(type='char', derefcnt=1, name='s')]),
 'putsgent': Function(type='int', derefcnt=0, name='putsgent', args=[Argument(type='sgrp', derefcnt=1, name='g'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'putshort': Function(type='void', derefcnt=0, name='putshort', args=[Argument(type='u_int16_t', derefcnt=0, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1')]),
 'putspent': Function(type='int', derefcnt=0, name='putspent', args=[Argument(type='spwd', derefcnt=1, name='p'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'pututline': Function(type='utmp', derefcnt=1, name='pututline', args=[Argument(type='utmp', derefcnt=1, name='utmp_ptr')]),
 'pututxline': Function(type='utmpx', derefcnt=1, name='pututxline', args=[Argument(type='utmpx', derefcnt=1, name='utmpx')]),
 'putw': Function(type='int', derefcnt=0, name='putw', args=[Argument(type='int', derefcnt=0, name='w'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'putwc': Function(type='wint_t', derefcnt=0, name='putwc', args=[Argument(type='wchar_t', derefcnt=0, name='wc'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'putwc_unlocked': Function(type='wint_t', derefcnt=0, name='putwc_unlocked', args=[Argument(type='wchar_t', derefcnt=0, name='wc'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'putwchar': Function(type='wint_t', derefcnt=0, name='putwchar', args=[Argument(type='wchar_t', derefcnt=0, name='wc')]),
 'putwchar_unlocked': Function(type='wint_t', derefcnt=0, name='putwchar_unlocked', args=[Argument(type='wchar_t', derefcnt=0, name='wc')]),
 'pvalloc': Function(type='void', derefcnt=1, name='pvalloc', args=[Argument(type='size_t', derefcnt=0, name='size')]),
 'pwrite': Function(type='ssize_t', derefcnt=0, name='pwrite', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='off_t', derefcnt=0, name='offset')]),
 'pwrite64': Function(type='ssize_t', derefcnt=0, name='pwrite64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='off64_t', derefcnt=0, name='offset')]),
 'pwritev': Function(type='ssize_t', derefcnt=0, name='pwritev', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='iovec', derefcnt=1, name='iovec'), Argument(type='int', derefcnt=0, name='count'), Argument(type='off_t', derefcnt=0, name='offset')]),
 'pwritev64': Function(type='ssize_t', derefcnt=0, name='pwritev64', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='iovec', derefcnt=1, name='iovec'), Argument(type='int', derefcnt=0, name='count'), Argument(type='off64_t', derefcnt=0, name='offset')]),
 'qecvt': Function(type='char', derefcnt=1, name='qecvt', args=[Argument(type='long', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign')]),
 'qecvt_r': Function(type='int', derefcnt=0, name='qecvt_r', args=[Argument(type='long', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len')]),
 'qfcvt': Function(type='char', derefcnt=1, name='qfcvt', args=[Argument(type='long', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign')]),
 'qfcvt_r': Function(type='int', derefcnt=0, name='qfcvt_r', args=[Argument(type='long', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='int', derefcnt=1, name='decpt'), Argument(type='int', derefcnt=1, name='sign'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len')]),
 'qgcvt': Function(type='char', derefcnt=1, name='qgcvt', args=[Argument(type='long', derefcnt=0, name='value'), Argument(type='int', derefcnt=0, name='ndigit'), Argument(type='char', derefcnt=1, name='buf')]),
 'qsort': Function(type='void', derefcnt=0, name='qsort', args=[Argument(type='void', derefcnt=1, name='base'), Argument(type='size_t', derefcnt=0, name='nmemb'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='compar_fn_t', derefcnt=0, name='compar')]),
 'qsort_r': Function(type='void', derefcnt=0, name='qsort_r', args=[Argument(type='void', derefcnt=1, name='base'), Argument(type='size_t', derefcnt=0, name='nmemb'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='compar_d_fn_t', derefcnt=0, name='compar'), Argument(type='void', derefcnt=1, name='arg')]),
 'quick_exit': Function(type='void', derefcnt=0, name='quick_exit', args=[Argument(type='int', derefcnt=0, name='status')]),
 'raise': Function(type='int', derefcnt=0, name='raise', args=[Argument(type='int', derefcnt=0, name='sig')]),
 'rand': Function(type='int', derefcnt=0, name='rand', args=[]),
 'rand_r': Function(type='int', derefcnt=0, name='rand_r', args=[Argument(type='unsigned', derefcnt=1, name='seed')]),
 'random': Function(type='long', derefcnt=0, name='random', args=[]),
 'random_r': Function(type='int', derefcnt=0, name='random_r', args=[Argument(type='random_data', derefcnt=1, name='buf'), Argument(type='int32_t', derefcnt=1, name='result')]),
 'rawmemchr': Function(type='void', derefcnt=1, name='rawmemchr', args=[Argument(type='void', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c')]),
 'rcmd': Function(type='int', derefcnt=0, name='rcmd', args=[Argument(type='char', derefcnt=2, name='ahost'), Argument(type='unsigned', derefcnt=0, name='rport'), Argument(type='char', derefcnt=1, name='locuser'), Argument(type='char', derefcnt=1, name='remuser'), Argument(type='char', derefcnt=1, name='cmd'), Argument(type='int', derefcnt=1, name='fd2p')]),
 'rcmd_af': Function(type='int', derefcnt=0, name='rcmd_af', args=[Argument(type='char', derefcnt=2, name='ahost'), Argument(type='unsigned', derefcnt=0, name='rport'), Argument(type='char', derefcnt=1, name='locuser'), Argument(type='char', derefcnt=1, name='remuser'), Argument(type='char', derefcnt=1, name='cmd'), Argument(type='int', derefcnt=1, name='fd2p'), Argument(type='sa_family_t', derefcnt=0, name='af')]),
 're_compile_fastmap': Function(type='int', derefcnt=0, name='re_compile_fastmap', args=[Argument(type='re_pattern_buffer', derefcnt=1, name='buffer')]),
 're_compile_pattern': Function(type='char', derefcnt=1, name='re_compile_pattern', args=[Argument(type='char', derefcnt=1, name='pattern'), Argument(type='size_t', derefcnt=0, name='length'), Argument(type='re_pattern_buffer', derefcnt=1, name='buffer')]),
 're_match': Function(type='int', derefcnt=0, name='re_match', args=[Argument(type='re_pattern_buffer', derefcnt=1, name='buffer'), Argument(type='char', derefcnt=1, name='string'), Argument(type='int', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='start'), Argument(type='re_registers', derefcnt=1, name='regs')]),
 're_match_2': Function(type='int', derefcnt=0, name='re_match_2', args=[Argument(type='re_pattern_buffer', derefcnt=1, name='buffer'), Argument(type='char', derefcnt=1, name='string1'), Argument(type='int', derefcnt=0, name='length1'), Argument(type='char', derefcnt=1, name='string2'), Argument(type='int', derefcnt=0, name='length2'), Argument(type='int', derefcnt=0, name='start'), Argument(type='re_registers', derefcnt=1, name='regs'), Argument(type='int', derefcnt=0, name='stop')]),
 're_search': Function(type='int', derefcnt=0, name='re_search', args=[Argument(type='re_pattern_buffer', derefcnt=1, name='buffer'), Argument(type='char', derefcnt=1, name='string'), Argument(type='int', derefcnt=0, name='length'), Argument(type='int', derefcnt=0, name='start'), Argument(type='int', derefcnt=0, name='range'), Argument(type='re_registers', derefcnt=1, name='regs')]),
 're_search_2': Function(type='int', derefcnt=0, name='re_search_2', args=[Argument(type='re_pattern_buffer', derefcnt=1, name='buffer'), Argument(type='char', derefcnt=1, name='string1'), Argument(type='int', derefcnt=0, name='length1'), Argument(type='char', derefcnt=1, name='string2'), Argument(type='int', derefcnt=0, name='length2'), Argument(type='int', derefcnt=0, name='start'), Argument(type='int', derefcnt=0, name='range'), Argument(type='re_registers', derefcnt=1, name='regs'), Argument(type='int', derefcnt=0, name='stop')]),
 're_set_registers': Function(type='void', derefcnt=0, name='re_set_registers', args=[Argument(type='re_pattern_buffer', derefcnt=1, name='buffer'), Argument(type='re_registers', derefcnt=1, name='regs'), Argument(type='unsigned', derefcnt=0, name='num_regs'), Argument(type='regoff_t', derefcnt=1, name='starts'), Argument(type='regoff_t', derefcnt=1, name='ends')]),
 're_set_syntax': Function(type='reg_syntax_t', derefcnt=0, name='re_set_syntax', args=[Argument(type='reg_syntax_t', derefcnt=0, name='syntax')]),
 'read': Function(type='ssize_t', derefcnt=0, name='read', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes')]),
 '__read_chk': Function(type='ssize_t', derefcnt=0, name='__read_chk', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='nbytes'), Argument(type='size_t', derefcnt=0, name='buflen')]),
 'readahead': Function(type='ssize_t', derefcnt=0, name='readahead', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off64_t', derefcnt=0, name='offset'), Argument(type='size_t', derefcnt=0, name='count')]),
 'readdir': Function(type='dirent', derefcnt=1, name='readdir', args=[Argument(type='DIR', derefcnt=1, name='dirp')]),
 'readdir64': Function(type='dirent64', derefcnt=1, name='readdir64', args=[Argument(type='DIR', derefcnt=1, name='dirp')]),
 'readdir64_r': Function(type='int', derefcnt=0, name='readdir64_r', args=[Argument(type='DIR', derefcnt=1, name='dirp'), Argument(type='dirent64', derefcnt=1, name='entry'), Argument(type='dirent64', derefcnt=2, name='result')]),
 'readdir_r': Function(type='int', derefcnt=0, name='readdir_r', args=[Argument(type='DIR', derefcnt=1, name='dirp'), Argument(type='dirent', derefcnt=1, name='entry'), Argument(type='dirent', derefcnt=2, name='result')]),
 'readlink': Function(type='ssize_t', derefcnt=0, name='readlink', args=[Argument(type='char', derefcnt=1, name='path'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len')]),
 'readlinkat': Function(type='ssize_t', derefcnt=0, name='readlinkat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='path'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='len')]),
 'readv': Function(type='ssize_t', derefcnt=0, name='readv', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='iovec', derefcnt=1, name='iovec'), Argument(type='int', derefcnt=0, name='count')]),
 'realloc': Function(type='void', derefcnt=1, name='realloc', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='size')]),
 'realloc_hook': Function(type='void', derefcnt=1, name='realloc_hook', args=[Argument(type='void', derefcnt=1, name='ptr'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='void', derefcnt=1, name='arg2')]),
 'realpath': Function(type='char', derefcnt=1, name='realpath', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='resolved')]),
 'recv': Function(type='ssize_t', derefcnt=0, name='recv', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=0, name='flags')]),
 'recvfrom': Function(type='ssize_t', derefcnt=0, name='recvfrom', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=1, name='addr_len')]),
 'recvmmsg': Function(type='int', derefcnt=0, name='recvmmsg', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='mmsghdr', derefcnt=1, name='vmessages'), Argument(type='unsigned', derefcnt=0, name='vlen'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='timespec', derefcnt=1, name='tmo')]),
 'recvmsg': Function(type='ssize_t', derefcnt=0, name='recvmsg', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='msghdr', derefcnt=1, name='message'), Argument(type='int', derefcnt=0, name='flags')]),
 'regcomp': Function(type='int', derefcnt=0, name='regcomp', args=[Argument(type='regex_t', derefcnt=1, name='preg'), Argument(type='char', derefcnt=1, name='pattern'), Argument(type='int', derefcnt=0, name='cflags')]),
 'regerror': Function(type='size_t', derefcnt=0, name='regerror', args=[Argument(type='int', derefcnt=0, name='errcode'), Argument(type='regex_t', derefcnt=1, name='preg'), Argument(type='char', derefcnt=1, name='errbuf'), Argument(type='size_t', derefcnt=0, name='errbuf_size')]),
 'regexec': Function(type='int', derefcnt=0, name='regexec', args=[Argument(type='regex_t', derefcnt=1, name='preg'), Argument(type='char', derefcnt=1, name='string'), Argument(type='size_t', derefcnt=0, name='nmatch'), Argument(type='regmatch_t', derefcnt=1, name='pmatch'), Argument(type='int', derefcnt=0, name='eflags')]),
 'regfree': Function(type='void', derefcnt=0, name='regfree', args=[Argument(type='regex_t', derefcnt=1, name='preg')]),
 'register_printf_function': Function(type='int', derefcnt=0, name='register_printf_function', args=[Argument(type='int', derefcnt=0, name='spec'), Argument(type='printf_function', derefcnt=0, name='func'), Argument(type='printf_arginfo_function', derefcnt=0, name='arginfo')]),
 'register_printf_modifier': Function(type='int', derefcnt=0, name='register_printf_modifier', args=[Argument(type='wchar_t', derefcnt=1, name='str')]),
 'register_printf_specifier': Function(type='int', derefcnt=0, name='register_printf_specifier', args=[Argument(type='int', derefcnt=0, name='spec'), Argument(type='printf_function', derefcnt=0, name='func'), Argument(type='printf_arginfo_size_function', derefcnt=0, name='arginfo')]),
 'register_printf_type': Function(type='int', derefcnt=0, name='register_printf_type', args=[Argument(type='printf_va_arg_function', derefcnt=0, name='fct')]),
 'remainder': Function(type='double', derefcnt=0, name='remainder', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y')]),
 'remainderf': Function(type='float', derefcnt=0, name='remainderf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y')]),
 'remainderl': Function(type='long', derefcnt=0, name='remainderl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y')]),
 'remap_file_pages': Function(type='int', derefcnt=0, name='remap_file_pages', args=[Argument(type='void', derefcnt=1, name='start'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='int', derefcnt=0, name='prot'), Argument(type='size_t', derefcnt=0, name='pgoff'), Argument(type='int', derefcnt=0, name='flags')]),
 'remove': Function(type='int', derefcnt=0, name='remove', args=[Argument(type='char', derefcnt=1, name='filename')]),
 'remove_session_cb': Function(type='void', derefcnt=0, name='remove_session_cb', args=[Argument(type='ssl_ctx_st', derefcnt=1, name='ctx'), Argument(type='SSL_SESSION', derefcnt=1, name='sess')]),
 'remque': Function(type='void', derefcnt=0, name='remque', args=[Argument(type='void', derefcnt=1, name='elem')]),
 'remquo': Function(type='double', derefcnt=0, name='remquo', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='y'), Argument(type='int', derefcnt=1, name='quo')]),
 'remquof': Function(type='float', derefcnt=0, name='remquof', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='y'), Argument(type='int', derefcnt=1, name='quo')]),
 'remquol': Function(type='long', derefcnt=0, name='remquol', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='y'), Argument(type='int', derefcnt=1, name='quo')]),
 'rename': Function(type='int', derefcnt=0, name='rename', args=[Argument(type='char', derefcnt=1, name='old'), Argument(type='char', derefcnt=1, name='new')]),
 'renameat': Function(type='int', derefcnt=0, name='renameat', args=[Argument(type='int', derefcnt=0, name='oldfd'), Argument(type='char', derefcnt=1, name='old'), Argument(type='int', derefcnt=0, name='newfd'), Argument(type='char', derefcnt=1, name='new')]),
 'res_close': Function(type='void', derefcnt=0, name='res_close', args=[]),
 'res_dnok': Function(type='int', derefcnt=0, name='res_dnok', args=[Argument(type='char', derefcnt=1, name='arg0')]),
 'res_hnok': Function(type='int', derefcnt=0, name='res_hnok', args=[Argument(type='char', derefcnt=1, name='arg0')]),
 'res_hostalias': Function(type='char', derefcnt=1, name='res_hostalias', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='size_t', derefcnt=0, name='arg3')]),
 'res_init': Function(type='int', derefcnt=0, name='res_init', args=[]),
 'res_isourserver': Function(type='int', derefcnt=0, name='res_isourserver', args=[Argument(type='sockaddr_in', derefcnt=1, name='arg0')]),
 'res_mailok': Function(type='int', derefcnt=0, name='res_mailok', args=[Argument(type='char', derefcnt=1, name='arg0')]),
 'res_mkquery': Function(type='int', derefcnt=0, name='res_mkquery', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='u_char', derefcnt=1, name='arg4'), Argument(type='int', derefcnt=0, name='arg5'), Argument(type='u_char', derefcnt=1, name='arg6'), Argument(type='u_char', derefcnt=1, name='arg7'), Argument(type='int', derefcnt=0, name='arg8')]),
 'res_nameinquery': Function(type='int', derefcnt=0, name='res_nameinquery', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='u_char', derefcnt=1, name='arg3'), Argument(type='u_char', derefcnt=1, name='arg4')]),
 'res_nclose': Function(type='void', derefcnt=0, name='res_nclose', args=[Argument(type='res_state', derefcnt=0, name='arg0')]),
 'res_ninit': Function(type='int', derefcnt=0, name='res_ninit', args=[Argument(type='res_state', derefcnt=0, name='arg0')]),
 'res_nisourserver': Function(type='int', derefcnt=0, name='res_nisourserver', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='sockaddr_in', derefcnt=1, name='arg1')]),
 'res_nmkquery': Function(type='int', derefcnt=0, name='res_nmkquery', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='int', derefcnt=0, name='arg4'), Argument(type='u_char', derefcnt=1, name='arg5'), Argument(type='int', derefcnt=0, name='arg6'), Argument(type='u_char', derefcnt=1, name='arg7'), Argument(type='u_char', derefcnt=1, name='arg8'), Argument(type='int', derefcnt=0, name='arg9')]),
 'res_npquery': Function(type='void', derefcnt=0, name='res_npquery', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='FILE', derefcnt=1, name='arg3')]),
 'res_nquery': Function(type='int', derefcnt=0, name='res_nquery', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='u_char', derefcnt=1, name='arg4'), Argument(type='int', derefcnt=0, name='arg5')]),
 'res_nquerydomain': Function(type='int', derefcnt=0, name='res_nquerydomain', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='char', derefcnt=1, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='int', derefcnt=0, name='arg4'), Argument(type='u_char', derefcnt=1, name='arg5'), Argument(type='int', derefcnt=0, name='arg6')]),
 'res_nsearch': Function(type='int', derefcnt=0, name='res_nsearch', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='u_char', derefcnt=1, name='arg4'), Argument(type='int', derefcnt=0, name='arg5')]),
 'res_nsend': Function(type='int', derefcnt=0, name='res_nsend', args=[Argument(type='res_state', derefcnt=0, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='u_char', derefcnt=1, name='arg3'), Argument(type='int', derefcnt=0, name='arg4')]),
 'res_ownok': Function(type='int', derefcnt=0, name='res_ownok', args=[Argument(type='char', derefcnt=1, name='arg0')]),
 'res_queriesmatch': Function(type='int', derefcnt=0, name='res_queriesmatch', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='u_char', derefcnt=1, name='arg1'), Argument(type='u_char', derefcnt=1, name='arg2'), Argument(type='u_char', derefcnt=1, name='arg3')]),
 'res_query': Function(type='int', derefcnt=0, name='res_query', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='u_char', derefcnt=1, name='arg3'), Argument(type='int', derefcnt=0, name='arg4')]),
 'res_querydomain': Function(type='int', derefcnt=0, name='res_querydomain', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='int', derefcnt=0, name='arg3'), Argument(type='u_char', derefcnt=1, name='arg4'), Argument(type='int', derefcnt=0, name='arg5')]),
 'res_randomid': Function(type='u_int', derefcnt=0, name='res_randomid', args=[]),
 'res_search': Function(type='int', derefcnt=0, name='res_search', args=[Argument(type='char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=0, name='arg2'), Argument(type='u_char', derefcnt=1, name='arg3'), Argument(type='int', derefcnt=0, name='arg4')]),
 'res_send': Function(type='int', derefcnt=0, name='res_send', args=[Argument(type='u_char', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='u_char', derefcnt=1, name='arg2'), Argument(type='int', derefcnt=0, name='arg3')]),
 'res_send_qhook': Function(type='res_sendhookact', derefcnt=0, name='res_send_qhook', args=[Argument(type='sockaddr_in', derefcnt=2, name='ns'), Argument(type='u_char', derefcnt=2, name='query'), Argument(type='int', derefcnt=1, name='querylen'), Argument(type='u_char', derefcnt=1, name='ans'), Argument(type='int', derefcnt=0, name='anssiz'), Argument(type='int', derefcnt=1, name='resplen')]),
 'res_send_rhook': Function(type='res_sendhookact', derefcnt=0, name='res_send_rhook', args=[Argument(type='sockaddr_in', derefcnt=1, name='ns'), Argument(type='u_char', derefcnt=1, name='query'), Argument(type='int', derefcnt=0, name='querylen'), Argument(type='u_char', derefcnt=1, name='ans'), Argument(type='int', derefcnt=0, name='anssiz'), Argument(type='int', derefcnt=1, name='resplen')]),
 'res_state': Function(type='res_state', derefcnt=1, name='res_state', args=[]),
 'revoke': Function(type='int', derefcnt=0, name='revoke', args=[Argument(type='char', derefcnt=1, name='file')]),
 'rewind': Function(type='void', derefcnt=0, name='rewind', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'rewinddir': Function(type='void', derefcnt=0, name='rewinddir', args=[Argument(type='DIR', derefcnt=1, name='dirp')]),
 'rexec': Function(type='int', derefcnt=0, name='rexec', args=[Argument(type='char', derefcnt=2, name='ahost'), Argument(type='int', derefcnt=0, name='rport'), Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='pass'), Argument(type='char', derefcnt=1, name='cmd'), Argument(type='int', derefcnt=1, name='fd2p')]),
 'rexec_af': Function(type='int', derefcnt=0, name='rexec_af', args=[Argument(type='char', derefcnt=2, name='ahost'), Argument(type='int', derefcnt=0, name='rport'), Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='pass'), Argument(type='char', derefcnt=1, name='cmd'), Argument(type='int', derefcnt=1, name='fd2p'), Argument(type='sa_family_t', derefcnt=0, name='af')]),
 'rindex': Function(type='char', derefcnt=1, name='rindex', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c')]),
 'rint': Function(type='double', derefcnt=0, name='rint', args=[Argument(type='double', derefcnt=0, name='x')]),
 'rintf': Function(type='float', derefcnt=0, name='rintf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'rintl': Function(type='long', derefcnt=0, name='rintl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'rmdir': Function(type='int', derefcnt=0, name='rmdir', args=[Argument(type='char', derefcnt=1, name='path')]),
 'round': Function(type='double', derefcnt=0, name='round', args=[Argument(type='double', derefcnt=0, name='x')]),
 'roundf': Function(type='float', derefcnt=0, name='roundf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'roundl': Function(type='long', derefcnt=0, name='roundl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'routine': Function(type='void', derefcnt=0, name='routine', args=[Argument(type='void', derefcnt=1, name='arg0')]),
 'rpmatch': Function(type='int', derefcnt=0, name='rpmatch', args=[Argument(type='char', derefcnt=1, name='response')]),
 'rresvport': Function(type='int', derefcnt=0, name='rresvport', args=[Argument(type='int', derefcnt=1, name='alport')]),
 'rresvport_af': Function(type='int', derefcnt=0, name='rresvport_af', args=[Argument(type='int', derefcnt=1, name='alport'), Argument(type='sa_family_t', derefcnt=0, name='af')]),
 'rsa_keygen': Function(type='int', derefcnt=0, name='rsa_keygen', args=[Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='bits'), Argument(type='BIGNUM', derefcnt=1, name='e'), Argument(type='BN_GENCB', derefcnt=1, name='cb')]),
 'rsa_mod_exp': Function(type='int', derefcnt=0, name='rsa_mod_exp', args=[Argument(type='BIGNUM', derefcnt=1, name='r0'), Argument(type='BIGNUM', derefcnt=1, name='I'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='BN_CTX', derefcnt=1, name='ctx')]),
 'rsa_priv_dec': Function(type='int', derefcnt=0, name='rsa_priv_dec', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'rsa_priv_enc': Function(type='int', derefcnt=0, name='rsa_priv_enc', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'rsa_pub_dec': Function(type='int', derefcnt=0, name='rsa_pub_dec', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'rsa_pub_enc': Function(type='int', derefcnt=0, name='rsa_pub_enc', args=[Argument(type='int', derefcnt=0, name='flen'), Argument(type='unsigned', derefcnt=1, name='from'), Argument(type='unsigned', derefcnt=1, name='to'), Argument(type='RSA', derefcnt=1, name='rsa'), Argument(type='int', derefcnt=0, name='padding')]),
 'rsa_sign': Function(type='int', derefcnt=0, name='rsa_sign', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigret'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'rsa_verify': Function(type='int', derefcnt=0, name='rsa_verify', args=[Argument(type='int', derefcnt=0, name='dtype'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigbuf'), Argument(type='unsigned', derefcnt=0, name='siglen'), Argument(type='RSA', derefcnt=1, name='rsa')]),
 'ruserok': Function(type='int', derefcnt=0, name='ruserok', args=[Argument(type='char', derefcnt=1, name='rhost'), Argument(type='int', derefcnt=0, name='suser'), Argument(type='char', derefcnt=1, name='remuser'), Argument(type='char', derefcnt=1, name='locuser')]),
 'ruserok_af': Function(type='int', derefcnt=0, name='ruserok_af', args=[Argument(type='char', derefcnt=1, name='rhost'), Argument(type='int', derefcnt=0, name='suser'), Argument(type='char', derefcnt=1, name='remuser'), Argument(type='char', derefcnt=1, name='locuser'), Argument(type='sa_family_t', derefcnt=0, name='af')]),
 'sa_restorer': Function(type='void', derefcnt=0, name='sa_restorer', args=[]),
 'sa_sigaction': Function(type='void', derefcnt=0, name='sa_sigaction', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='siginfo_t', derefcnt=1, name='arg1'), Argument(type='void', derefcnt=1, name='arg2')]),
 'sbrk': Function(type='void', derefcnt=1, name='sbrk', args=[Argument(type='intptr_t', derefcnt=0, name='delta')]),
 'scalb': Function(type='double', derefcnt=0, name='scalb', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=0, name='n')]),
 'scalbf': Function(type='float', derefcnt=0, name='scalbf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=0, name='n')]),
 'scalbl': Function(type='long', derefcnt=0, name='scalbl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='n')]),
 'scalbln': Function(type='double', derefcnt=0, name='scalbln', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='n')]),
 'scalblnf': Function(type='float', derefcnt=0, name='scalblnf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='n')]),
 'scalblnl': Function(type='long', derefcnt=0, name='scalblnl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=0, name='n')]),
 'scalbn': Function(type='double', derefcnt=0, name='scalbn', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='int', derefcnt=0, name='n')]),
 'scalbnf': Function(type='float', derefcnt=0, name='scalbnf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='int', derefcnt=0, name='n')]),
 'scalbnl': Function(type='long', derefcnt=0, name='scalbnl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='int', derefcnt=0, name='n')]),
 'scandir': Function(type='int', derefcnt=0, name='scandir', args=[Argument(type='char', derefcnt=1, name='dir'), Argument(type='dirent', derefcnt=3, name='namelist'), Argument(type='int', derefcnt=0, name='selector'), Argument(type='int', derefcnt=0, name='cmp')]),
 'scandir64': Function(type='int', derefcnt=0, name='scandir64', args=[Argument(type='char', derefcnt=1, name='dir'), Argument(type='dirent64', derefcnt=3, name='namelist'), Argument(type='int', derefcnt=0, name='selector'), Argument(type='int', derefcnt=0, name='cmp')]),
 'scandirat': Function(type='int', derefcnt=0, name='scandirat', args=[Argument(type='int', derefcnt=0, name='dfd'), Argument(type='char', derefcnt=1, name='dir'), Argument(type='dirent', derefcnt=3, name='namelist'), Argument(type='int', derefcnt=0, name='selector'), Argument(type='int', derefcnt=0, name='cmp')]),
 'scandirat64': Function(type='int', derefcnt=0, name='scandirat64', args=[Argument(type='int', derefcnt=0, name='dfd'), Argument(type='char', derefcnt=1, name='dir'), Argument(type='dirent64', derefcnt=3, name='namelist'), Argument(type='int', derefcnt=0, name='selector'), Argument(type='int', derefcnt=0, name='cmp')]),
 'scanf': Function(type='int', derefcnt=0, name='scanf', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'sched_cpualloc': Function(type='cpu_set_t', derefcnt=1, name='sched_cpualloc', args=[Argument(type='size_t', derefcnt=0, name='count')]),
 'sched_cpucount': Function(type='int', derefcnt=0, name='sched_cpucount', args=[Argument(type='size_t', derefcnt=0, name='setsize'), Argument(type='cpu_set_t', derefcnt=1, name='setp')]),
 'sched_cpufree': Function(type='void', derefcnt=0, name='sched_cpufree', args=[Argument(type='cpu_set_t', derefcnt=1, name='set')]),
 'sched_get_priority_max': Function(type='int', derefcnt=0, name='sched_get_priority_max', args=[Argument(type='int', derefcnt=0, name='algorithm')]),
 'sched_get_priority_min': Function(type='int', derefcnt=0, name='sched_get_priority_min', args=[Argument(type='int', derefcnt=0, name='algorithm')]),
 'sched_getaffinity': Function(type='int', derefcnt=0, name='sched_getaffinity', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='size_t', derefcnt=0, name='cpusetsize'), Argument(type='cpu_set_t', derefcnt=1, name='cpuset')]),
 'sched_getcpu': Function(type='int', derefcnt=0, name='sched_getcpu', args=[]),
 'sched_getparam': Function(type='int', derefcnt=0, name='sched_getparam', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='sched_param', derefcnt=1, name='param')]),
 'sched_getscheduler': Function(type='int', derefcnt=0, name='sched_getscheduler', args=[Argument(type='pid_t', derefcnt=0, name='pid')]),
 'sched_rr_get_interval': Function(type='int', derefcnt=0, name='sched_rr_get_interval', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='timespec', derefcnt=1, name='t')]),
 'sched_setaffinity': Function(type='int', derefcnt=0, name='sched_setaffinity', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='size_t', derefcnt=0, name='cpusetsize'), Argument(type='cpu_set_t', derefcnt=1, name='cpuset')]),
 'sched_setparam': Function(type='int', derefcnt=0, name='sched_setparam', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='sched_param', derefcnt=1, name='param')]),
 'sched_setscheduler': Function(type='int', derefcnt=0, name='sched_setscheduler', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='int', derefcnt=0, name='policy'), Argument(type='sched_param', derefcnt=1, name='param')]),
 'sched_yield': Function(type='int', derefcnt=0, name='sched_yield', args=[]),
 'secure_getenv': Function(type='char', derefcnt=1, name='secure_getenv', args=[Argument(type='char', derefcnt=1, name='name')]),
 'seed48': Function(type='unsigned', derefcnt=1, name='seed48', args=[Argument(type='unsigned', derefcnt=1, name='seed16v')]),
 'seed48_r': Function(type='int', derefcnt=0, name='seed48_r', args=[Argument(type='unsigned', derefcnt=1, name='seed16v'), Argument(type='drand48_data', derefcnt=1, name='buffer')]),
 'seekdir': Function(type='void', derefcnt=0, name='seekdir', args=[Argument(type='DIR', derefcnt=1, name='dirp'), Argument(type='long', derefcnt=0, name='pos')]),
 'select': Function(type='int', derefcnt=0, name='select', args=[Argument(type='int', derefcnt=0, name='nfds'), Argument(type='fd_set', derefcnt=1, name='readfds'), Argument(type='fd_set', derefcnt=1, name='writefds'), Argument(type='fd_set', derefcnt=1, name='exceptfds'), Argument(type='timeval', derefcnt=1, name='timeout')]),
 'sem_close': Function(type='int', derefcnt=0, name='sem_close', args=[Argument(type='sem_t', derefcnt=1, name='sem')]),
 'sem_destroy': Function(type='int', derefcnt=0, name='sem_destroy', args=[Argument(type='sem_t', derefcnt=1, name='sem')]),
 'sem_getvalue': Function(type='int', derefcnt=0, name='sem_getvalue', args=[Argument(type='sem_t', derefcnt=1, name='sem'), Argument(type='int', derefcnt=1, name='sval')]),
 'sem_init': Function(type='int', derefcnt=0, name='sem_init', args=[Argument(type='sem_t', derefcnt=1, name='sem'), Argument(type='int', derefcnt=0, name='pshared'), Argument(type='unsigned', derefcnt=0, name='value')]),
 'sem_open': Function(type='sem_t', derefcnt=1, name='sem_open', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='int', derefcnt=0, name='vararg')]),
 'sem_post': Function(type='int', derefcnt=0, name='sem_post', args=[Argument(type='sem_t', derefcnt=1, name='sem')]),
 'sem_timedwait': Function(type='int', derefcnt=0, name='sem_timedwait', args=[Argument(type='sem_t', derefcnt=1, name='sem'), Argument(type='timespec', derefcnt=1, name='abstime')]),
 'sem_trywait': Function(type='int', derefcnt=0, name='sem_trywait', args=[Argument(type='sem_t', derefcnt=1, name='sem')]),
 'sem_unlink': Function(type='int', derefcnt=0, name='sem_unlink', args=[Argument(type='char', derefcnt=1, name='name')]),
 'sem_wait': Function(type='int', derefcnt=0, name='sem_wait', args=[Argument(type='sem_t', derefcnt=1, name='sem')]),
 'semctl': Function(type='int', derefcnt=0, name='semctl', args=[Argument(type='int', derefcnt=0, name='semid'), Argument(type='int', derefcnt=0, name='semnum'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='int', derefcnt=0, name='vararg')]),
 'semget': Function(type='int', derefcnt=0, name='semget', args=[Argument(type='key_t', derefcnt=0, name='key'), Argument(type='int', derefcnt=0, name='nsems'), Argument(type='int', derefcnt=0, name='semflg')]),
 'semop': Function(type='int', derefcnt=0, name='semop', args=[Argument(type='int', derefcnt=0, name='semid'), Argument(type='sembuf', derefcnt=1, name='sops'), Argument(type='size_t', derefcnt=0, name='nsops')]),
 'semtimedop': Function(type='int', derefcnt=0, name='semtimedop', args=[Argument(type='int', derefcnt=0, name='semid'), Argument(type='sembuf', derefcnt=1, name='sops'), Argument(type='size_t', derefcnt=0, name='nsops'), Argument(type='timespec', derefcnt=1, name='timeout')]),
 'send': Function(type='ssize_t', derefcnt=0, name='send', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=0, name='flags')]),
 'sendfile': Function(type='ssize_t', derefcnt=0, name='sendfile', args=[Argument(type='int', derefcnt=0, name='out_fd'), Argument(type='int', derefcnt=0, name='in_fd'), Argument(type='off_t', derefcnt=1, name='offset'), Argument(type='size_t', derefcnt=0, name='count')]),
 'sendfile64': Function(type='ssize_t', derefcnt=0, name='sendfile64', args=[Argument(type='int', derefcnt=0, name='out_fd'), Argument(type='int', derefcnt=0, name='in_fd'), Argument(type='off64_t', derefcnt=1, name='offset'), Argument(type='size_t', derefcnt=0, name='count')]),
 'sendmmsg': Function(type='int', derefcnt=0, name='sendmmsg', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='mmsghdr', derefcnt=1, name='vmessages'), Argument(type='unsigned', derefcnt=0, name='vlen'), Argument(type='int', derefcnt=0, name='flags')]),
 'sendmsg': Function(type='ssize_t', derefcnt=0, name='sendmsg', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='msghdr', derefcnt=1, name='message'), Argument(type='int', derefcnt=0, name='flags')]),
 'sendto': Function(type='ssize_t', derefcnt=0, name='sendto', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='CONST_SOCKADDR_ARG', derefcnt=0, name='addr'), Argument(type='socklen_t', derefcnt=0, name='addr_len')]),
 'set_asn1_parameters': Function(type='int', derefcnt=0, name='set_asn1_parameters', args=[Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='arg0'), Argument(type='ASN1_TYPE', derefcnt=1, name='arg1')]),
 'setaliasent': Function(type='void', derefcnt=0, name='setaliasent', args=[]),
 'setbuf': Function(type='void', derefcnt=0, name='setbuf', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='char', derefcnt=1, name='buf')]),
 'setbuffer': Function(type='void', derefcnt=0, name='setbuffer', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='size')]),
 'setcontext': Function(type='int', derefcnt=0, name='setcontext', args=[Argument(type='ucontext_t', derefcnt=1, name='ucp')]),
 'setdomainname': Function(type='int', derefcnt=0, name='setdomainname', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='size_t', derefcnt=0, name='len')]),
 'setegid': Function(type='int', derefcnt=0, name='setegid', args=[Argument(type='gid_t', derefcnt=0, name='gid')]),
 'setenv': Function(type='int', derefcnt=0, name='setenv', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='char', derefcnt=1, name='value'), Argument(type='int', derefcnt=0, name='replace')]),
 'seteuid': Function(type='int', derefcnt=0, name='seteuid', args=[Argument(type='uid_t', derefcnt=0, name='uid')]),
 'setfsent': Function(type='int', derefcnt=0, name='setfsent', args=[]),
 'setgid': Function(type='int', derefcnt=0, name='setgid', args=[Argument(type='gid_t', derefcnt=0, name='gid')]),
 'setgrent': Function(type='void', derefcnt=0, name='setgrent', args=[]),
 'setgroups': Function(type='int', derefcnt=0, name='setgroups', args=[Argument(type='size_t', derefcnt=0, name='n'), Argument(type='gid_t', derefcnt=1, name='groups')]),
 'sethostent': Function(type='void', derefcnt=0, name='sethostent', args=[Argument(type='int', derefcnt=0, name='stay_open')]),
 'sethostid': Function(type='int', derefcnt=0, name='sethostid', args=[Argument(type='long', derefcnt=0, name='id')]),
 'sethostname': Function(type='int', derefcnt=0, name='sethostname', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='size_t', derefcnt=0, name='len')]),
 'setipv4sourcefilter': Function(type='int', derefcnt=0, name='setipv4sourcefilter', args=[Argument(type='int', derefcnt=0, name='s'), Argument(type='in_addr', derefcnt=0, name='interface_addr'), Argument(type='in_addr', derefcnt=0, name='group'), Argument(type='uint32_t', derefcnt=0, name='fmode'), Argument(type='uint32_t', derefcnt=0, name='numsrc'), Argument(type='in_addr', derefcnt=1, name='slist')]),
 'setitimer': Function(type='int', derefcnt=0, name='setitimer', args=[Argument(type='itimer_which_t', derefcnt=0, name='which'), Argument(type='itimerval', derefcnt=1, name='new'), Argument(type='itimerval', derefcnt=1, name='old')]),
 'setjmp': Function(type='int', derefcnt=0, name='setjmp', args=[Argument(type='jmp_buf_tag', derefcnt=1, name='env')]),
 'setkey': Function(type='void', derefcnt=0, name='setkey', args=[Argument(type='char', derefcnt=1, name='key')]),
 'setkey_r': Function(type='void', derefcnt=0, name='setkey_r', args=[Argument(type='char', derefcnt=1, name='key'), Argument(type='crypt_data', derefcnt=1, name='data')]),
 'setlinebuf': Function(type='void', derefcnt=0, name='setlinebuf', args=[Argument(type='FILE', derefcnt=1, name='stream')]),
 'setlocale': Function(type='char', derefcnt=1, name='setlocale', args=[Argument(type='int', derefcnt=0, name='category'), Argument(type='char', derefcnt=1, name='locale')]),
 'setlogin': Function(type='int', derefcnt=0, name='setlogin', args=[Argument(type='char', derefcnt=1, name='name')]),
 'setlogmask': Function(type='int', derefcnt=0, name='setlogmask', args=[Argument(type='int', derefcnt=0, name='mask')]),
 'setmntent': Function(type='FILE', derefcnt=1, name='setmntent', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='char', derefcnt=1, name='mode')]),
 'setnetent': Function(type='void', derefcnt=0, name='setnetent', args=[Argument(type='int', derefcnt=0, name='stay_open')]),
 'setnetgrent': Function(type='int', derefcnt=0, name='setnetgrent', args=[Argument(type='char', derefcnt=1, name='netgroup')]),
 'setns': Function(type='int', derefcnt=0, name='setns', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='nstype')]),
 'setpgid': Function(type='int', derefcnt=0, name='setpgid', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='pid_t', derefcnt=0, name='pgid')]),
 'setpgrp': Function(type='int', derefcnt=0, name='setpgrp', args=[]),
 'setpriority': Function(type='int', derefcnt=0, name='setpriority', args=[Argument(type='priority_which_t', derefcnt=0, name='which'), Argument(type='id_t', derefcnt=0, name='who'), Argument(type='int', derefcnt=0, name='prio')]),
 'setprotoent': Function(type='void', derefcnt=0, name='setprotoent', args=[Argument(type='int', derefcnt=0, name='stay_open')]),
 'setpwent': Function(type='void', derefcnt=0, name='setpwent', args=[]),
 'setregid': Function(type='int', derefcnt=0, name='setregid', args=[Argument(type='gid_t', derefcnt=0, name='rgid'), Argument(type='gid_t', derefcnt=0, name='egid')]),
 'setresgid': Function(type='int', derefcnt=0, name='setresgid', args=[Argument(type='gid_t', derefcnt=0, name='rgid'), Argument(type='gid_t', derefcnt=0, name='egid'), Argument(type='gid_t', derefcnt=0, name='sgid')]),
 'setresuid': Function(type='int', derefcnt=0, name='setresuid', args=[Argument(type='uid_t', derefcnt=0, name='ruid'), Argument(type='uid_t', derefcnt=0, name='euid'), Argument(type='uid_t', derefcnt=0, name='suid')]),
 'setreuid': Function(type='int', derefcnt=0, name='setreuid', args=[Argument(type='uid_t', derefcnt=0, name='ruid'), Argument(type='uid_t', derefcnt=0, name='euid')]),
 'setrlimit': Function(type='int', derefcnt=0, name='setrlimit', args=[Argument(type='rlimit_resource_t', derefcnt=0, name='resource'), Argument(type='rlimit', derefcnt=1, name='rlimits')]),
 'setrlimit64': Function(type='int', derefcnt=0, name='setrlimit64', args=[Argument(type='rlimit_resource_t', derefcnt=0, name='resource'), Argument(type='rlimit64', derefcnt=1, name='rlimits')]),
 'setrpcent': Function(type='void', derefcnt=0, name='setrpcent', args=[Argument(type='int', derefcnt=0, name='stayopen')]),
 'setservent': Function(type='void', derefcnt=0, name='setservent', args=[Argument(type='int', derefcnt=0, name='stay_open')]),
 'setsgent': Function(type='void', derefcnt=0, name='setsgent', args=[]),
 'setsid': Function(type='pid_t', derefcnt=0, name='setsid', args=[]),
 'setsockopt': Function(type='int', derefcnt=0, name='setsockopt', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='level'), Argument(type='int', derefcnt=0, name='optname'), Argument(type='void', derefcnt=1, name='optval'), Argument(type='socklen_t', derefcnt=0, name='optlen')]),
 'setsourcefilter': Function(type='int', derefcnt=0, name='setsourcefilter', args=[Argument(type='int', derefcnt=0, name='s'), Argument(type='uint32_t', derefcnt=0, name='interface_addr'), Argument(type='sockaddr', derefcnt=1, name='group'), Argument(type='socklen_t', derefcnt=0, name='grouplen'), Argument(type='uint32_t', derefcnt=0, name='fmode'), Argument(type='uint32_t', derefcnt=0, name='numsrc'), Argument(type='sockaddr_storage', derefcnt=1, name='slist')]),
 'setspent': Function(type='void', derefcnt=0, name='setspent', args=[]),
 'setstate': Function(type='char', derefcnt=1, name='setstate', args=[Argument(type='char', derefcnt=1, name='statebuf')]),
 'setstate_r': Function(type='int', derefcnt=0, name='setstate_r', args=[Argument(type='char', derefcnt=1, name='statebuf'), Argument(type='random_data', derefcnt=1, name='buf')]),
 'settimeofday': Function(type='int', derefcnt=0, name='settimeofday', args=[Argument(type='timeval', derefcnt=1, name='tv'), Argument(type='timezone', derefcnt=1, name='tz')]),
 'setttyent': Function(type='int', derefcnt=0, name='setttyent', args=[]),
 'setuid': Function(type='int', derefcnt=0, name='setuid', args=[Argument(type='uid_t', derefcnt=0, name='uid')]),
 'setusershell': Function(type='void', derefcnt=0, name='setusershell', args=[]),
 'setutent': Function(type='void', derefcnt=0, name='setutent', args=[]),
 'setutxent': Function(type='void', derefcnt=0, name='setutxent', args=[]),
 'setvbuf': Function(type='int', derefcnt=0, name='setvbuf', args=[Argument(type='FILE', derefcnt=1, name='stream'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='modes'), Argument(type='size_t', derefcnt=0, name='n')]),
 'sgetsgent': Function(type='sgrp', derefcnt=1, name='sgetsgent', args=[Argument(type='char', derefcnt=1, name='string')]),
 'sgetsgent_r': Function(type='int', derefcnt=0, name='sgetsgent_r', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='sgrp', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='sgrp', derefcnt=2, name='result')]),
 'sgetspent': Function(type='spwd', derefcnt=1, name='sgetspent', args=[Argument(type='char', derefcnt=1, name='string')]),
 'sgetspent_r': Function(type='int', derefcnt=0, name='sgetspent_r', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='spwd', derefcnt=1, name='result_buf'), Argument(type='char', derefcnt=1, name='buffer'), Argument(type='size_t', derefcnt=0, name='buflen'), Argument(type='spwd', derefcnt=2, name='result')]),
 'shm_open': Function(type='int', derefcnt=0, name='shm_open', args=[Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='oflag'), Argument(type='mode_t', derefcnt=0, name='mode')]),
 'shm_unlink': Function(type='int', derefcnt=0, name='shm_unlink', args=[Argument(type='char', derefcnt=1, name='name')]),
 'shmat': Function(type='void', derefcnt=1, name='shmat', args=[Argument(type='int', derefcnt=0, name='shmid'), Argument(type='void', derefcnt=1, name='shmaddr'), Argument(type='int', derefcnt=0, name='shmflg')]),
 'shmctl': Function(type='int', derefcnt=0, name='shmctl', args=[Argument(type='int', derefcnt=0, name='shmid'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='shmid_ds', derefcnt=1, name='buf')]),
 'shmdt': Function(type='int', derefcnt=0, name='shmdt', args=[Argument(type='void', derefcnt=1, name='shmaddr')]),
 'shmget': Function(type='int', derefcnt=0, name='shmget', args=[Argument(type='key_t', derefcnt=0, name='key'), Argument(type='size_t', derefcnt=0, name='size'), Argument(type='int', derefcnt=0, name='shmflg')]),
 'shutdown': Function(type='int', derefcnt=0, name='shutdown', args=[Argument(type='X509_LOOKUP', derefcnt=1, name='ctx')]),
 'sigaction': Function(type='int', derefcnt=0, name='sigaction', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='sigaction', derefcnt=1, name='act'), Argument(type='sigaction', derefcnt=1, name='oact')]),
 'sigaddset': Function(type='int', derefcnt=0, name='sigaddset', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='int', derefcnt=0, name='signo')]),
 'sigaltstack': Function(type='int', derefcnt=0, name='sigaltstack', args=[Argument(type='sigaltstack', derefcnt=1, name='ss'), Argument(type='sigaltstack', derefcnt=1, name='oss')]),
 'sigandset': Function(type='int', derefcnt=0, name='sigandset', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='sigset_t', derefcnt=1, name='left'), Argument(type='sigset_t', derefcnt=1, name='right')]),
 'sigblock': Function(type='int', derefcnt=0, name='sigblock', args=[Argument(type='int', derefcnt=0, name='mask')]),
 'sigdelset': Function(type='int', derefcnt=0, name='sigdelset', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='int', derefcnt=0, name='signo')]),
 'sigemptyset': Function(type='int', derefcnt=0, name='sigemptyset', args=[Argument(type='sigset_t', derefcnt=1, name='set')]),
 'sigfillset': Function(type='int', derefcnt=0, name='sigfillset', args=[Argument(type='sigset_t', derefcnt=1, name='set')]),
 'siggetmask': Function(type='int', derefcnt=0, name='siggetmask', args=[]),
 'sighandler_t': Function(type='void', derefcnt=0, name='sighandler_t', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'sighold': Function(type='int', derefcnt=0, name='sighold', args=[Argument(type='int', derefcnt=0, name='sig')]),
 'sigignore': Function(type='int', derefcnt=0, name='sigignore', args=[Argument(type='int', derefcnt=0, name='sig')]),
 'siginterrupt': Function(type='int', derefcnt=0, name='siginterrupt', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='int', derefcnt=0, name='interrupt')]),
 'sigisemptyset': Function(type='int', derefcnt=0, name='sigisemptyset', args=[Argument(type='sigset_t', derefcnt=1, name='set')]),
 'sigismember': Function(type='int', derefcnt=0, name='sigismember', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='int', derefcnt=0, name='signo')]),
 'siglongjmp': Function(type='void', derefcnt=0, name='siglongjmp', args=[Argument(type='sigjmp_buf', derefcnt=0, name='env'), Argument(type='int', derefcnt=0, name='val')]),
 'sign': Function(type='int', derefcnt=0, name='sign', args=[Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='m'), Argument(type='unsigned', derefcnt=0, name='m_length'), Argument(type='unsigned', derefcnt=1, name='sigret'), Argument(type='unsigned', derefcnt=1, name='siglen'), Argument(type='void', derefcnt=1, name='key')]),
 'signal': Function(type='sighandler_t', derefcnt=0, name='signal', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='sighandler_t', derefcnt=0, name='handler')]),
 'signbit': Function(type='int', derefcnt=0, name='signbit', args=[Argument(type='double', derefcnt=0, name='value')]),
 'signbitf': Function(type='int', derefcnt=0, name='signbitf', args=[Argument(type='float', derefcnt=0, name='value')]),
 'signbitl': Function(type='int', derefcnt=0, name='signbitl', args=[Argument(type='long', derefcnt=0, name='value')]),
 'significand': Function(type='double', derefcnt=0, name='significand', args=[Argument(type='double', derefcnt=0, name='x')]),
 'significandf': Function(type='float', derefcnt=0, name='significandf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'significandl': Function(type='long', derefcnt=0, name='significandl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'sigorset': Function(type='int', derefcnt=0, name='sigorset', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='sigset_t', derefcnt=1, name='left'), Argument(type='sigset_t', derefcnt=1, name='right')]),
 'sigpause': Function(type='int', derefcnt=0, name='sigpause', args=[Argument(type='int', derefcnt=0, name='sig')]),
 'sigpending': Function(type='int', derefcnt=0, name='sigpending', args=[Argument(type='sigset_t', derefcnt=1, name='set')]),
 'sigprocmask': Function(type='int', derefcnt=0, name='sigprocmask', args=[Argument(type='int', derefcnt=0, name='how'), Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='sigset_t', derefcnt=1, name='oset')]),
 'sigqueue': Function(type='int', derefcnt=0, name='sigqueue', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='int', derefcnt=0, name='sig'), Argument(type='sigval', derefcnt=0, name='val')]),
 'sigrelse': Function(type='int', derefcnt=0, name='sigrelse', args=[Argument(type='int', derefcnt=0, name='sig')]),
 'sigreturn': Function(type='int', derefcnt=0, name='sigreturn', args=[Argument(type='sigcontext', derefcnt=1, name='scp')]),
 'sigset': Function(type='sighandler_t', derefcnt=0, name='sigset', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='sighandler_t', derefcnt=0, name='disp')]),
 'sigsetjmp': Function(type='int', derefcnt=0, name='sigsetjmp', args=[Argument(type='jmp_buf_tag', derefcnt=1, name='env'), Argument(type='int', derefcnt=0, name='savemask')]),
 'sigsetmask': Function(type='int', derefcnt=0, name='sigsetmask', args=[Argument(type='int', derefcnt=0, name='mask')]),
 'sigstack': Function(type='int', derefcnt=0, name='sigstack', args=[Argument(type='sigstack', derefcnt=1, name='ss'), Argument(type='sigstack', derefcnt=1, name='oss')]),
 'sigsuspend': Function(type='int', derefcnt=0, name='sigsuspend', args=[Argument(type='sigset_t', derefcnt=1, name='set')]),
 'sigtimedwait': Function(type='int', derefcnt=0, name='sigtimedwait', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='siginfo_t', derefcnt=1, name='info'), Argument(type='timespec', derefcnt=1, name='timeout')]),
 'sigvec': Function(type='int', derefcnt=0, name='sigvec', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='sigvec', derefcnt=1, name='vec'), Argument(type='sigvec', derefcnt=1, name='ovec')]),
 'sigwait': Function(type='int', derefcnt=0, name='sigwait', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='int', derefcnt=1, name='sig')]),
 'sigwaitinfo': Function(type='int', derefcnt=0, name='sigwaitinfo', args=[Argument(type='sigset_t', derefcnt=1, name='set'), Argument(type='siginfo_t', derefcnt=1, name='info')]),
 'sin': Function(type='double', derefcnt=0, name='sin', args=[Argument(type='double', derefcnt=0, name='x')]),
 'sincos': Function(type='void', derefcnt=0, name='sincos', args=[Argument(type='double', derefcnt=0, name='x'), Argument(type='double', derefcnt=1, name='sinx'), Argument(type='double', derefcnt=1, name='cosx')]),
 'sincosf': Function(type='void', derefcnt=0, name='sincosf', args=[Argument(type='float', derefcnt=0, name='x'), Argument(type='float', derefcnt=1, name='sinx'), Argument(type='float', derefcnt=1, name='cosx')]),
 'sincosl': Function(type='void', derefcnt=0, name='sincosl', args=[Argument(type='long', derefcnt=0, name='x'), Argument(type='long', derefcnt=1, name='sinx'), Argument(type='long', derefcnt=1, name='cosx')]),
 'sinf': Function(type='float', derefcnt=0, name='sinf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'sinh': Function(type='double', derefcnt=0, name='sinh', args=[Argument(type='double', derefcnt=0, name='x')]),
 'sinhf': Function(type='float', derefcnt=0, name='sinhf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'sinhl': Function(type='long', derefcnt=0, name='sinhl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'sinl': Function(type='long', derefcnt=0, name='sinl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'sk_delete': Function(type='void', derefcnt=1, name='sk_delete', args=[Argument(type='STACK', derefcnt=1, name='st'), Argument(type='int', derefcnt=0, name='loc')]),
 'sk_delete_ptr': Function(type='void', derefcnt=1, name='sk_delete_ptr', args=[Argument(type='STACK', derefcnt=1, name='st'), Argument(type='void', derefcnt=1, name='p')]),
 'sk_dup': Function(type='STACK', derefcnt=1, name='sk_dup', args=[Argument(type='STACK', derefcnt=1, name='st')]),
 'sk_find': Function(type='int', derefcnt=0, name='sk_find', args=[Argument(type='STACK', derefcnt=1, name='st'), Argument(type='void', derefcnt=1, name='data')]),
 'sk_find_ex': Function(type='int', derefcnt=0, name='sk_find_ex', args=[Argument(type='STACK', derefcnt=1, name='st'), Argument(type='void', derefcnt=1, name='data')]),
 'sk_free': Function(type='void', derefcnt=0, name='sk_free', args=[Argument(type='STACK', derefcnt=1, name='arg0')]),
 'sk_insert': Function(type='int', derefcnt=0, name='sk_insert', args=[Argument(type='STACK', derefcnt=1, name='sk'), Argument(type='void', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='where')]),
 'sk_is_sorted': Function(type='int', derefcnt=0, name='sk_is_sorted', args=[Argument(type='STACK', derefcnt=1, name='st')]),
 'sk_new': Function(type='STACK', derefcnt=1, name='sk_new', args=[Argument(type='int', derefcnt=0, name='cmp')]),
 'sk_new_null': Function(type='STACK', derefcnt=1, name='sk_new_null', args=[]),
 'sk_num': Function(type='int', derefcnt=0, name='sk_num', args=[Argument(type='STACK', derefcnt=1, name='arg0')]),
 'sk_pop': Function(type='void', derefcnt=1, name='sk_pop', args=[Argument(type='STACK', derefcnt=1, name='st')]),
 'sk_pop_free': Function(type='void', derefcnt=0, name='sk_pop_free', args=[Argument(type='STACK', derefcnt=1, name='st'), Argument(type='void', derefcnt=0, name='func')]),
 'sk_push': Function(type='int', derefcnt=0, name='sk_push', args=[Argument(type='STACK', derefcnt=1, name='st'), Argument(type='void', derefcnt=1, name='data')]),
 'sk_set': Function(type='void', derefcnt=1, name='sk_set', args=[Argument(type='STACK', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='void', derefcnt=1, name='arg2')]),
 'sk_set_cmp_func': Function(type='int', derefcnt=0, name='sk_set_cmp_func', args=[Argument(type='STACK', derefcnt=1, name='sk'), Argument(type='int', derefcnt=0, name='c')]),
 'sk_shift': Function(type='void', derefcnt=1, name='sk_shift', args=[Argument(type='STACK', derefcnt=1, name='st')]),
 'sk_sort': Function(type='void', derefcnt=0, name='sk_sort', args=[Argument(type='STACK', derefcnt=1, name='st')]),
 'sk_unshift': Function(type='int', derefcnt=0, name='sk_unshift', args=[Argument(type='STACK', derefcnt=1, name='st'), Argument(type='void', derefcnt=1, name='data')]),
 'sk_value': Function(type='void', derefcnt=1, name='sk_value', args=[Argument(type='STACK', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1')]),
 'sk_zero': Function(type='void', derefcnt=0, name='sk_zero', args=[Argument(type='STACK', derefcnt=1, name='st')]),
 'sleep': Function(type='unsigned', derefcnt=0, name='sleep', args=[Argument(type='unsigned', derefcnt=0, name='seconds')]),
 'snprintf': Function(type='int', derefcnt=0, name='snprintf', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxlen'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'sockatmark': Function(type='int', derefcnt=0, name='sockatmark', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'socket': Function(type='int', derefcnt=0, name='socket', args=[Argument(type='int', derefcnt=0, name='domain'), Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='protocol')]),
 'socketpair': Function(type='int', derefcnt=0, name='socketpair', args=[Argument(type='int', derefcnt=0, name='domain'), Argument(type='int', derefcnt=0, name='type'), Argument(type='int', derefcnt=0, name='protocol'), Argument(type='int', derefcnt=1, name='fds')]),
 'splice': Function(type='ssize_t', derefcnt=0, name='splice', args=[Argument(type='int', derefcnt=0, name='fdin'), Argument(type='off64_t', derefcnt=1, name='offin'), Argument(type='int', derefcnt=0, name='fdout'), Argument(type='off64_t', derefcnt=1, name='offout'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'sprintf': Function(type='int', derefcnt=0, name='sprintf', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'sqrt': Function(type='double', derefcnt=0, name='sqrt', args=[Argument(type='double', derefcnt=0, name='x')]),
 'sqrtf': Function(type='float', derefcnt=0, name='sqrtf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'sqrtl': Function(type='long', derefcnt=0, name='sqrtl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'srand': Function(type='void', derefcnt=0, name='srand', args=[Argument(type='unsigned', derefcnt=0, name='seed')]),
 'srand48': Function(type='void', derefcnt=0, name='srand48', args=[Argument(type='long', derefcnt=0, name='seedval')]),
 'srand48_r': Function(type='int', derefcnt=0, name='srand48_r', args=[Argument(type='long', derefcnt=0, name='seedval'), Argument(type='drand48_data', derefcnt=1, name='buffer')]),
 'srandom': Function(type='void', derefcnt=0, name='srandom', args=[Argument(type='unsigned', derefcnt=0, name='seed')]),
 'srandom_r': Function(type='int', derefcnt=0, name='srandom_r', args=[Argument(type='unsigned', derefcnt=0, name='seed'), Argument(type='random_data', derefcnt=1, name='buf')]),
 'sscanf': Function(type='int', derefcnt=0, name='sscanf', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'ssignal': Function(type='sighandler_t', derefcnt=0, name='ssignal', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='sighandler_t', derefcnt=0, name='handler')]),
 'ssl_accept': Function(type='int', derefcnt=0, name='ssl_accept', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_callback_ctrl': Function(type='long', derefcnt=0, name='ssl_callback_ctrl', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='cb_id'), Argument(type='void', derefcnt=0, name='fp')]),
 'ssl_clear': Function(type='void', derefcnt=0, name='ssl_clear', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_connect': Function(type='int', derefcnt=0, name='ssl_connect', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_ctrl': Function(type='long', derefcnt=0, name='ssl_ctrl', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg'), Argument(type='void', derefcnt=1, name='parg')]),
 'ssl_ctx_callback_ctrl': Function(type='long', derefcnt=0, name='ssl_ctx_callback_ctrl', args=[Argument(type='SSL_CTX', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='cb_id'), Argument(type='void', derefcnt=0, name='fp')]),
 'ssl_ctx_ctrl': Function(type='long', derefcnt=0, name='ssl_ctx_ctrl', args=[Argument(type='SSL_CTX', derefcnt=1, name='ctx'), Argument(type='int', derefcnt=0, name='cmd'), Argument(type='long', derefcnt=0, name='larg'), Argument(type='void', derefcnt=1, name='parg')]),
 'ssl_dispatch_alert': Function(type='int', derefcnt=0, name='ssl_dispatch_alert', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_free': Function(type='void', derefcnt=0, name='ssl_free', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_get_message': Function(type='long', derefcnt=0, name='ssl_get_message', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='st1'), Argument(type='int', derefcnt=0, name='stn'), Argument(type='int', derefcnt=0, name='mt'), Argument(type='long', derefcnt=0, name='max'), Argument(type='int', derefcnt=1, name='ok')]),
 'ssl_new': Function(type='int', derefcnt=0, name='ssl_new', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_peek': Function(type='int', derefcnt=0, name='ssl_peek', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'ssl_pending': Function(type='int', derefcnt=0, name='ssl_pending', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_read': Function(type='int', derefcnt=0, name='ssl_read', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'ssl_read_bytes': Function(type='int', derefcnt=0, name='ssl_read_bytes', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len'), Argument(type='int', derefcnt=0, name='peek')]),
 'ssl_renegotiate': Function(type='int', derefcnt=0, name='ssl_renegotiate', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_renegotiate_check': Function(type='int', derefcnt=0, name='ssl_renegotiate_check', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_shutdown': Function(type='int', derefcnt=0, name='ssl_shutdown', args=[Argument(type='SSL', derefcnt=1, name='s')]),
 'ssl_version': Function(type='int', derefcnt=0, name='ssl_version', args=[]),
 'ssl_write': Function(type='int', derefcnt=0, name='ssl_write', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='int', derefcnt=0, name='len')]),
 'ssl_write_bytes': Function(type='int', derefcnt=0, name='ssl_write_bytes', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='type'), Argument(type='void', derefcnt=1, name='buf_'), Argument(type='int', derefcnt=0, name='len')]),
 'stat': Function(type='int', derefcnt=0, name='stat', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='stat', derefcnt=1, name='buf')]),
 'stat64': Function(type='int', derefcnt=0, name='stat64', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='stat64', derefcnt=1, name='buf')]),
 'step': Function(type='int', derefcnt=0, name='step', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='char', derefcnt=1, name='expbuf')]),
 'stime': Function(type='int', derefcnt=0, name='stime', args=[Argument(type='time_t', derefcnt=1, name='when')]),
 'stpcpy': Function(type='char', derefcnt=1, name='stpcpy', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src')]),
 'stpncpy': Function(type='char', derefcnt=1, name='stpncpy', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'strcasecmp': Function(type='int', derefcnt=0, name='strcasecmp', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2')]),
 'strcasecmp_l': Function(type='int', derefcnt=0, name='strcasecmp_l', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strcasestr': Function(type='char', derefcnt=1, name='strcasestr', args=[Argument(type='char', derefcnt=1, name='haystack'), Argument(type='char', derefcnt=1, name='needle')]),
 'strcat': Function(type='char', derefcnt=1, name='strcat', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src')]),
 'strchr': Function(type='char', derefcnt=1, name='strchr', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c')]),
 'strchrnul': Function(type='char', derefcnt=1, name='strchrnul', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c')]),
 'strcmp': Function(type='int', derefcnt=0, name='strcmp', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2')]),
 'strcoll': Function(type='int', derefcnt=0, name='strcoll', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2')]),
 'strcoll_l': Function(type='int', derefcnt=0, name='strcoll_l', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2'), Argument(type='locale_t', derefcnt=0, name='l')]),
 'strcpy': Function(type='char', derefcnt=1, name='strcpy', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src')]),
 'strcspn': Function(type='size_t', derefcnt=0, name='strcspn', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='reject')]),
 'strdup': Function(type='char', derefcnt=1, name='strdup', args=[Argument(type='char', derefcnt=1, name='s')]),
 'strerror': Function(type='char', derefcnt=1, name='strerror', args=[Argument(type='int', derefcnt=0, name='errnum')]),
 'strerror_l': Function(type='char', derefcnt=1, name='strerror_l', args=[Argument(type='int', derefcnt=0, name='errnum'), Argument(type='locale_t', derefcnt=0, name='l')]),
 'strerror_r': Function(type='char', derefcnt=1, name='strerror_r', args=[Argument(type='int', derefcnt=0, name='errnum'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen')]),
 'strfmon': Function(type='ssize_t', derefcnt=0, name='strfmon', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxsize'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'strfmon_l': Function(type='ssize_t', derefcnt=0, name='strfmon_l', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxsize'), Argument(type='locale_t', derefcnt=0, name='loc'), Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'strfry': Function(type='char', derefcnt=1, name='strfry', args=[Argument(type='char', derefcnt=1, name='string')]),
 'strftime': Function(type='size_t', derefcnt=0, name='strftime', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxsize'), Argument(type='char', derefcnt=1, name='format'), Argument(type='tm', derefcnt=1, name='tp')]),
 'strftime_l': Function(type='size_t', derefcnt=0, name='strftime_l', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxsize'), Argument(type='char', derefcnt=1, name='format'), Argument(type='tm', derefcnt=1, name='tp'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strlen': Function(type='size_t', derefcnt=0, name='strlen', args=[Argument(type='char', derefcnt=1, name='s')]),
 'strncasecmp': Function(type='int', derefcnt=0, name='strncasecmp', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'strncasecmp_l': Function(type='int', derefcnt=0, name='strncasecmp_l', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strncat': Function(type='char', derefcnt=1, name='strncat', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'strncmp': Function(type='int', derefcnt=0, name='strncmp', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'strncpy': Function(type='char', derefcnt=1, name='strncpy', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'strndup': Function(type='char', derefcnt=1, name='strndup', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='size_t', derefcnt=0, name='n')]),
 'strnlen': Function(type='size_t', derefcnt=0, name='strnlen', args=[Argument(type='char', derefcnt=1, name='string'), Argument(type='size_t', derefcnt=0, name='maxlen')]),
 'strpbrk': Function(type='char', derefcnt=1, name='strpbrk', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='accept')]),
 'strptime': Function(type='char', derefcnt=1, name='strptime', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='tm', derefcnt=1, name='tp')]),
 'strptime_l': Function(type='char', derefcnt=1, name='strptime_l', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='tm', derefcnt=1, name='tp'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strrchr': Function(type='char', derefcnt=1, name='strrchr', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='c')]),
 'strsep': Function(type='char', derefcnt=1, name='strsep', args=[Argument(type='char', derefcnt=2, name='stringp'), Argument(type='char', derefcnt=1, name='delim')]),
 'strsignal': Function(type='char', derefcnt=1, name='strsignal', args=[Argument(type='int', derefcnt=0, name='sig')]),
 'strspn': Function(type='size_t', derefcnt=0, name='strspn', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='accept')]),
 'strstr': Function(type='char', derefcnt=1, name='strstr', args=[Argument(type='char', derefcnt=1, name='haystack'), Argument(type='char', derefcnt=1, name='needle')]),
 'strtod': Function(type='double', derefcnt=0, name='strtod', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr')]),
 'strtod_l': Function(type='double', derefcnt=0, name='strtod_l', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strtof': Function(type='float', derefcnt=0, name='strtof', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr')]),
 'strtof_l': Function(type='float', derefcnt=0, name='strtof_l', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strtoimax': Function(type='intmax_t', derefcnt=0, name='strtoimax', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strtok': Function(type='char', derefcnt=1, name='strtok', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='delim')]),
 'strtok_r': Function(type='char', derefcnt=1, name='strtok_r', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='delim'), Argument(type='char', derefcnt=2, name='save_ptr')]),
 'strtol': Function(type='long', derefcnt=0, name='strtol', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strtol_l': Function(type='long', derefcnt=0, name='strtol_l', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strtold': Function(type='long', derefcnt=0, name='strtold', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr')]),
 'strtold_l': Function(type='long', derefcnt=0, name='strtold_l', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strtoll': Function(type='long', derefcnt=0, name='strtoll', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strtoll_l': Function(type='long', derefcnt=0, name='strtoll_l', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strtoq': Function(type='long', derefcnt=0, name='strtoq', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strtoul': Function(type='unsigned', derefcnt=0, name='strtoul', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strtoul_l': Function(type='unsigned', derefcnt=0, name='strtoul_l', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strtoull': Function(type='unsigned', derefcnt=0, name='strtoull', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strtoull_l': Function(type='unsigned', derefcnt=0, name='strtoull_l', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'strtoumax': Function(type='uintmax_t', derefcnt=0, name='strtoumax', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strtouq': Function(type='unsigned', derefcnt=0, name='strtouq', args=[Argument(type='char', derefcnt=1, name='nptr'), Argument(type='char', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'strverscmp': Function(type='int', derefcnt=0, name='strverscmp', args=[Argument(type='char', derefcnt=1, name='s1'), Argument(type='char', derefcnt=1, name='s2')]),
 'strxfrm': Function(type='size_t', derefcnt=0, name='strxfrm', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'strxfrm_l': Function(type='size_t', derefcnt=0, name='strxfrm_l', args=[Argument(type='char', derefcnt=1, name='dest'), Argument(type='char', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='locale_t', derefcnt=0, name='l')]),
 'stty': Function(type='int', derefcnt=0, name='stty', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='sgttyb', derefcnt=1, name='params')]),
 'swab': Function(type='void', derefcnt=0, name='swab', args=[Argument(type='void', derefcnt=1, name='from'), Argument(type='void', derefcnt=1, name='to'), Argument(type='ssize_t', derefcnt=0, name='n')]),
 'swapcontext': Function(type='int', derefcnt=0, name='swapcontext', args=[Argument(type='ucontext_t', derefcnt=1, name='oucp'), Argument(type='ucontext_t', derefcnt=1, name='ucp')]),
 'swprintf': Function(type='int', derefcnt=0, name='swprintf', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'swscanf': Function(type='int', derefcnt=0, name='swscanf', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'sym_ntop': Function(type='char', derefcnt=1, name='sym_ntop', args=[Argument(type='res_sym', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=1, name='arg2')]),
 'sym_ntos': Function(type='char', derefcnt=1, name='sym_ntos', args=[Argument(type='res_sym', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=0, name='arg1'), Argument(type='int', derefcnt=1, name='arg2')]),
 'sym_ston': Function(type='int', derefcnt=0, name='sym_ston', args=[Argument(type='res_sym', derefcnt=1, name='arg0'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='int', derefcnt=1, name='arg2')]),
 'symlink': Function(type='int', derefcnt=0, name='symlink', args=[Argument(type='char', derefcnt=1, name='from'), Argument(type='char', derefcnt=1, name='to')]),
 'symlinkat': Function(type='int', derefcnt=0, name='symlinkat', args=[Argument(type='char', derefcnt=1, name='from'), Argument(type='int', derefcnt=0, name='tofd'), Argument(type='char', derefcnt=1, name='to')]),
 'sync': Function(type='void', derefcnt=0, name='sync', args=[]),
 'sync_file_range': Function(type='int', derefcnt=0, name='sync_file_range', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='off64_t', derefcnt=0, name='offset'), Argument(type='off64_t', derefcnt=0, name='count'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'syncfs': Function(type='int', derefcnt=0, name='syncfs', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'syscall': Function(type='long', derefcnt=0, name='syscall', args=[Argument(type='long', derefcnt=0, name='sysno'), Argument(type='int', derefcnt=0, name='vararg')]),
 'sysconf': Function(type='long', derefcnt=0, name='sysconf', args=[Argument(type='int', derefcnt=0, name='name')]),
 'syslog': Function(type='void', derefcnt=0, name='syslog', args=[Argument(type='int', derefcnt=0, name='pri'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='int', derefcnt=0, name='vararg')]),
 'system': Function(type='int', derefcnt=0, name='system', args=[Argument(type='char', derefcnt=1, name='command')]),
 'sysv_signal': Function(type='sighandler_t', derefcnt=0, name='sysv_signal', args=[Argument(type='int', derefcnt=0, name='sig'), Argument(type='sighandler_t', derefcnt=0, name='handler')]),
 'tan': Function(type='double', derefcnt=0, name='tan', args=[Argument(type='double', derefcnt=0, name='x')]),
 'tanf': Function(type='float', derefcnt=0, name='tanf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'tanh': Function(type='double', derefcnt=0, name='tanh', args=[Argument(type='double', derefcnt=0, name='x')]),
 'tanhf': Function(type='float', derefcnt=0, name='tanhf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'tanhl': Function(type='long', derefcnt=0, name='tanhl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'tanl': Function(type='long', derefcnt=0, name='tanl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'tcdrain': Function(type='int', derefcnt=0, name='tcdrain', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'tcflow': Function(type='int', derefcnt=0, name='tcflow', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='action')]),
 'tcflush': Function(type='int', derefcnt=0, name='tcflush', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='queue_selector')]),
 'tcgetattr': Function(type='int', derefcnt=0, name='tcgetattr', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='termios', derefcnt=1, name='termios_p')]),
 'tcgetpgrp': Function(type='pid_t', derefcnt=0, name='tcgetpgrp', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'tcgetsid': Function(type='pid_t', derefcnt=0, name='tcgetsid', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'tcsendbreak': Function(type='int', derefcnt=0, name='tcsendbreak', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='duration')]),
 'tcsetattr': Function(type='int', derefcnt=0, name='tcsetattr', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='int', derefcnt=0, name='optional_actions'), Argument(type='termios', derefcnt=1, name='termios_p')]),
 'tcsetpgrp': Function(type='int', derefcnt=0, name='tcsetpgrp', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='pid_t', derefcnt=0, name='pgrp_id')]),
 'td_init': Function(type='td_err_e', derefcnt=0, name='td_init', args=[]),
 'td_key_iter_f': Function(type='int', derefcnt=0, name='td_key_iter_f', args=[Argument(type='thread_key_t', derefcnt=0, name='arg0'), Argument(type='void', derefcnt=1, name='arg2')]),
 'td_log': Function(type='td_err_e', derefcnt=0, name='td_log', args=[]),
 'td_symbol_list': Function(type='char', derefcnt=2, name='td_symbol_list', args=[]),
 'td_ta_clear_event': Function(type='td_err_e', derefcnt=0, name='td_ta_clear_event', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='td_thr_events_t', derefcnt=1, name='event')]),
 'td_ta_delete': Function(type='td_err_e', derefcnt=0, name='td_ta_delete', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta')]),
 'td_ta_enable_stats': Function(type='td_err_e', derefcnt=0, name='td_ta_enable_stats', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='int', derefcnt=0, name='enable')]),
 'td_ta_event_addr': Function(type='td_err_e', derefcnt=0, name='td_ta_event_addr', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='td_event_e', derefcnt=0, name='event'), Argument(type='td_notify_t', derefcnt=1, name='ptr')]),
 'td_ta_event_getmsg': Function(type='td_err_e', derefcnt=0, name='td_ta_event_getmsg', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='td_event_msg_t', derefcnt=1, name='msg')]),
 'td_ta_get_nthreads': Function(type='td_err_e', derefcnt=0, name='td_ta_get_nthreads', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='int', derefcnt=1, name='np')]),
 'td_ta_get_ph': Function(type='td_err_e', derefcnt=0, name='td_ta_get_ph', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='ps_prochandle', derefcnt=2, name='ph')]),
 'td_ta_get_stats': Function(type='td_err_e', derefcnt=0, name='td_ta_get_stats', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='td_ta_stats_t', derefcnt=1, name='statsp')]),
 'td_ta_map_id2thr': Function(type='td_err_e', derefcnt=0, name='td_ta_map_id2thr', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='pthread_t', derefcnt=0, name='pt'), Argument(type='td_thrhandle_t', derefcnt=1, name='th')]),
 'td_ta_map_lwp2thr': Function(type='td_err_e', derefcnt=0, name='td_ta_map_lwp2thr', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='lwpid_t', derefcnt=0, name='lwpid'), Argument(type='td_thrhandle_t', derefcnt=1, name='th')]),
 'td_ta_new': Function(type='td_err_e', derefcnt=0, name='td_ta_new', args=[Argument(type='ps_prochandle', derefcnt=1, name='ps'), Argument(type='td_thragent_t', derefcnt=2, name='ta')]),
 'td_ta_reset_stats': Function(type='td_err_e', derefcnt=0, name='td_ta_reset_stats', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta')]),
 'td_ta_set_event': Function(type='td_err_e', derefcnt=0, name='td_ta_set_event', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='td_thr_events_t', derefcnt=1, name='event')]),
 'td_ta_setconcurrency': Function(type='td_err_e', derefcnt=0, name='td_ta_setconcurrency', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='int', derefcnt=0, name='level')]),
 'td_ta_thr_iter': Function(type='td_err_e', derefcnt=0, name='td_ta_thr_iter', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='td_thr_iter_f', derefcnt=1, name='callback'), Argument(type='void', derefcnt=1, name='cbdata_p'), Argument(type='td_thr_state_e', derefcnt=0, name='state'), Argument(type='int', derefcnt=0, name='ti_pri'), Argument(type='sigset_t', derefcnt=1, name='ti_sigmask_p'), Argument(type='unsigned', derefcnt=0, name='ti_user_flags')]),
 'td_ta_tsd_iter': Function(type='td_err_e', derefcnt=0, name='td_ta_tsd_iter', args=[Argument(type='td_thragent_t', derefcnt=1, name='ta'), Argument(type='td_key_iter_f', derefcnt=1, name='ki'), Argument(type='void', derefcnt=1, name='p')]),
 'td_thr_clear_event': Function(type='td_err_e', derefcnt=0, name='td_thr_clear_event', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='td_thr_events_t', derefcnt=1, name='event')]),
 'td_thr_dbresume': Function(type='td_err_e', derefcnt=0, name='td_thr_dbresume', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th')]),
 'td_thr_dbsuspend': Function(type='td_err_e', derefcnt=0, name='td_thr_dbsuspend', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th')]),
 'td_thr_event_enable': Function(type='td_err_e', derefcnt=0, name='td_thr_event_enable', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='int', derefcnt=0, name='event')]),
 'td_thr_event_getmsg': Function(type='td_err_e', derefcnt=0, name='td_thr_event_getmsg', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='td_event_msg_t', derefcnt=1, name='msg')]),
 'td_thr_get_info': Function(type='td_err_e', derefcnt=0, name='td_thr_get_info', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='td_thrinfo_t', derefcnt=1, name='infop')]),
 'td_thr_getfpregs': Function(type='td_err_e', derefcnt=0, name='td_thr_getfpregs', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='prfpregset_t', derefcnt=1, name='regset')]),
 'td_thr_getgregs': Function(type='td_err_e', derefcnt=0, name='td_thr_getgregs', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='prgregset_t', derefcnt=0, name='gregs')]),
 'td_thr_getxregs': Function(type='td_err_e', derefcnt=0, name='td_thr_getxregs', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='void', derefcnt=1, name='xregs')]),
 'td_thr_getxregsize': Function(type='td_err_e', derefcnt=0, name='td_thr_getxregsize', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='int', derefcnt=1, name='sizep')]),
 'td_thr_iter_f': Function(type='int', derefcnt=0, name='td_thr_iter_f', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='arg1')]),
 'td_thr_set_event': Function(type='td_err_e', derefcnt=0, name='td_thr_set_event', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='td_thr_events_t', derefcnt=1, name='event')]),
 'td_thr_setfpregs': Function(type='td_err_e', derefcnt=0, name='td_thr_setfpregs', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='prfpregset_t', derefcnt=1, name='fpregs')]),
 'td_thr_setgregs': Function(type='td_err_e', derefcnt=0, name='td_thr_setgregs', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='prgregset_t', derefcnt=0, name='gregs')]),
 'td_thr_setprio': Function(type='td_err_e', derefcnt=0, name='td_thr_setprio', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='int', derefcnt=0, name='prio')]),
 'td_thr_setsigpending': Function(type='td_err_e', derefcnt=0, name='td_thr_setsigpending', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='unsigned', derefcnt=0, name='n'), Argument(type='sigset_t', derefcnt=1, name='ss')]),
 'td_thr_setxregs': Function(type='td_err_e', derefcnt=0, name='td_thr_setxregs', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='void', derefcnt=1, name='addr')]),
 'td_thr_sigsetmask': Function(type='td_err_e', derefcnt=0, name='td_thr_sigsetmask', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='sigset_t', derefcnt=1, name='ss')]),
 'td_thr_tls_get_addr': Function(type='td_err_e', derefcnt=0, name='td_thr_tls_get_addr', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='psaddr_t', derefcnt=0, name='map_address'), Argument(type='size_t', derefcnt=0, name='offset'), Argument(type='psaddr_t', derefcnt=1, name='address')]),
 'td_thr_tlsbase': Function(type='td_err_e', derefcnt=0, name='td_thr_tlsbase', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='unsigned', derefcnt=0, name='modid'), Argument(type='psaddr_t', derefcnt=1, name='base')]),
 'td_thr_tsd': Function(type='td_err_e', derefcnt=0, name='td_thr_tsd', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th'), Argument(type='thread_key_t', derefcnt=0, name='tk'), Argument(type='void', derefcnt=2, name='data')]),
 'td_thr_validate': Function(type='td_err_e', derefcnt=0, name='td_thr_validate', args=[Argument(type='td_thrhandle_t', derefcnt=1, name='th')]),
 'tdelete': Function(type='void', derefcnt=1, name='tdelete', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=2, name='rootp'), Argument(type='compar_fn_t', derefcnt=0, name='compar')]),
 'tdestroy': Function(type='void', derefcnt=0, name='tdestroy', args=[Argument(type='void', derefcnt=1, name='root'), Argument(type='free_fn_t', derefcnt=0, name='freefct')]),
 'tee': Function(type='ssize_t', derefcnt=0, name='tee', args=[Argument(type='int', derefcnt=0, name='fdin'), Argument(type='int', derefcnt=0, name='fdout'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'telldir': Function(type='long', derefcnt=0, name='telldir', args=[Argument(type='DIR', derefcnt=1, name='dirp')]),
 'tempnam': Function(type='char', derefcnt=1, name='tempnam', args=[Argument(type='char', derefcnt=1, name='dir'), Argument(type='char', derefcnt=1, name='pfx')]),
 'textdomain': Function(type='char', derefcnt=1, name='textdomain', args=[Argument(type='char', derefcnt=1, name='domainname')]),
 'tfind': Function(type='void', derefcnt=1, name='tfind', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=2, name='rootp'), Argument(type='compar_fn_t', derefcnt=0, name='compar')]),
 'tgamma': Function(type='double', derefcnt=0, name='tgamma', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'tgammaf': Function(type='float', derefcnt=0, name='tgammaf', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'tgammal': Function(type='long', derefcnt=0, name='tgammal', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'time': Function(type='time_t', derefcnt=0, name='time', args=[Argument(type='time_t', derefcnt=1, name='timer')]),
 'timegm': Function(type='time_t', derefcnt=0, name='timegm', args=[Argument(type='tm', derefcnt=1, name='tp')]),
 'timelocal': Function(type='time_t', derefcnt=0, name='timelocal', args=[Argument(type='tm', derefcnt=1, name='tp')]),
 'timer_create': Function(type='int', derefcnt=0, name='timer_create', args=[Argument(type='clockid_t', derefcnt=0, name='clock_id'), Argument(type='sigevent', derefcnt=1, name='evp'), Argument(type='timer_t', derefcnt=1, name='timerid')]),
 'timer_delete': Function(type='int', derefcnt=0, name='timer_delete', args=[Argument(type='timer_t', derefcnt=0, name='timerid')]),
 'timer_getoverrun': Function(type='int', derefcnt=0, name='timer_getoverrun', args=[Argument(type='timer_t', derefcnt=0, name='timerid')]),
 'timer_gettime': Function(type='int', derefcnt=0, name='timer_gettime', args=[Argument(type='timer_t', derefcnt=0, name='timerid'), Argument(type='itimerspec', derefcnt=1, name='value')]),
 'timer_settime': Function(type='int', derefcnt=0, name='timer_settime', args=[Argument(type='timer_t', derefcnt=0, name='timerid'), Argument(type='int', derefcnt=0, name='flags'), Argument(type='itimerspec', derefcnt=1, name='value'), Argument(type='itimerspec', derefcnt=1, name='ovalue')]),
 'timespec_get': Function(type='int', derefcnt=0, name='timespec_get', args=[Argument(type='timespec', derefcnt=1, name='ts'), Argument(type='int', derefcnt=0, name='base')]),
 'tls_session_secret_cb_fn': Function(type='int', derefcnt=0, name='tls_session_secret_cb_fn', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='void', derefcnt=1, name='secret'), Argument(type='int', derefcnt=1, name='secret_len'), Argument(type='stack_st_SSL_CIPHER', derefcnt=1, name='peer_ciphers'), Argument(type='SSL_CIPHER', derefcnt=2, name='cipher'), Argument(type='void', derefcnt=1, name='arg')]),
 'tls_session_ticket_ext_cb_fn': Function(type='int', derefcnt=0, name='tls_session_ticket_ext_cb_fn', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len'), Argument(type='void', derefcnt=1, name='arg')]),
 'tlsext_debug_cb': Function(type='void', derefcnt=0, name='tlsext_debug_cb', args=[Argument(type='SSL', derefcnt=1, name='s'), Argument(type='int', derefcnt=0, name='client_server'), Argument(type='int', derefcnt=0, name='type'), Argument(type='unsigned', derefcnt=1, name='data'), Argument(type='int', derefcnt=0, name='len'), Argument(type='void', derefcnt=1, name='arg')]),
 'tlsext_opaque_prf_input_callback': Function(type='int', derefcnt=0, name='tlsext_opaque_prf_input_callback', args=[Argument(type='SSL', derefcnt=1, name='arg0'), Argument(type='void', derefcnt=1, name='peerinput'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='void', derefcnt=1, name='arg')]),
 'tlsext_servername_callback': Function(type='int', derefcnt=0, name='tlsext_servername_callback', args=[Argument(type='SSL', derefcnt=1, name='arg0'), Argument(type='int', derefcnt=1, name='arg1'), Argument(type='void', derefcnt=1, name='arg2')]),
 'tlsext_status_cb': Function(type='int', derefcnt=0, name='tlsext_status_cb', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='void', derefcnt=1, name='arg')]),
 'tlsext_ticket_key_cb': Function(type='int', derefcnt=0, name='tlsext_ticket_key_cb', args=[Argument(type='SSL', derefcnt=1, name='ssl'), Argument(type='unsigned', derefcnt=1, name='name'), Argument(type='unsigned', derefcnt=1, name='iv'), Argument(type='EVP_CIPHER_CTX', derefcnt=1, name='ectx'), Argument(type='HMAC_CTX', derefcnt=1, name='hctx'), Argument(type='int', derefcnt=0, name='enc')]),
 'tmpfile': Function(type='FILE', derefcnt=1, name='tmpfile', args=[]),
 'tmpfile64': Function(type='FILE', derefcnt=1, name='tmpfile64', args=[]),
 'tmpnam': Function(type='char', derefcnt=1, name='tmpnam', args=[Argument(type='char', derefcnt=1, name='s')]),
 'tmpnam_r': Function(type='char', derefcnt=1, name='tmpnam_r', args=[Argument(type='char', derefcnt=1, name='s')]),
 'toascii': Function(type='int', derefcnt=0, name='toascii', args=[Argument(type='int', derefcnt=0, name='c')]),
 'tolower': Function(type='int', derefcnt=0, name='tolower', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'tolower_l': Function(type='int', derefcnt=0, name='tolower_l', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='locale_t', derefcnt=0, name='l')]),
 'toupper': Function(type='int', derefcnt=0, name='toupper', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'toupper_l': Function(type='int', derefcnt=0, name='toupper_l', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='locale_t', derefcnt=0, name='l')]),
 'towctrans': Function(type='wint_t', derefcnt=0, name='towctrans', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='wctrans_t', derefcnt=0, name='desc')]),
 'towctrans_l': Function(type='wint_t', derefcnt=0, name='towctrans_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='wctrans_t', derefcnt=0, name='desc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'towlower': Function(type='wint_t', derefcnt=0, name='towlower', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'towlower_l': Function(type='wint_t', derefcnt=0, name='towlower_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'towupper': Function(type='wint_t', derefcnt=0, name='towupper', args=[Argument(type='wint_t', derefcnt=0, name='wc')]),
 'towupper_l': Function(type='wint_t', derefcnt=0, name='towupper_l', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'trunc': Function(type='double', derefcnt=0, name='trunc', args=[Argument(type='double', derefcnt=0, name='x')]),
 'truncate': Function(type='int', derefcnt=0, name='truncate', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='off_t', derefcnt=0, name='length')]),
 'truncate64': Function(type='int', derefcnt=0, name='truncate64', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='off64_t', derefcnt=0, name='length')]),
 'truncf': Function(type='float', derefcnt=0, name='truncf', args=[Argument(type='float', derefcnt=0, name='x')]),
 'truncl': Function(type='long', derefcnt=0, name='truncl', args=[Argument(type='long', derefcnt=0, name='x')]),
 'tsearch': Function(type='void', derefcnt=1, name='tsearch', args=[Argument(type='void', derefcnt=1, name='key'), Argument(type='void', derefcnt=2, name='rootp'), Argument(type='compar_fn_t', derefcnt=0, name='compar')]),
 'ttyname': Function(type='char', derefcnt=1, name='ttyname', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'ttyname_r': Function(type='int', derefcnt=0, name='ttyname_r', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='buflen')]),
 'ttyslot': Function(type='int', derefcnt=0, name='ttyslot', args=[]),
 'twalk': Function(type='void', derefcnt=0, name='twalk', args=[Argument(type='void', derefcnt=1, name='root'), Argument(type='action_fn_t', derefcnt=0, name='action')]),
 'tzset': Function(type='void', derefcnt=0, name='tzset', args=[]),
 'ualarm': Function(type='useconds_t', derefcnt=0, name='ualarm', args=[Argument(type='useconds_t', derefcnt=0, name='value'), Argument(type='useconds_t', derefcnt=0, name='interval')]),
 'uflow': Function(type='int', derefcnt=0, name='uflow', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0')]),
 'ulckpwdf': Function(type='int', derefcnt=0, name='ulckpwdf', args=[]),
 'ulimit': Function(type='long', derefcnt=0, name='ulimit', args=[Argument(type='int', derefcnt=0, name='cmd'), Argument(type='int', derefcnt=0, name='vararg')]),
 'umask': Function(type='mode_t', derefcnt=0, name='umask', args=[Argument(type='mode_t', derefcnt=0, name='mask')]),
 'uname': Function(type='int', derefcnt=0, name='uname', args=[Argument(type='utsname', derefcnt=1, name='name')]),
 'uncompress': Function(type='int', derefcnt=0, name='uncompress', args=[Argument(type='Bytef', derefcnt=1, name='dest'), Argument(type='uLongf', derefcnt=1, name='destLen'), Argument(type='Bytef', derefcnt=1, name='source'), Argument(type='uLong', derefcnt=0, name='sourceLen')]),
 'underflow': Function(type='int', derefcnt=0, name='underflow', args=[Argument(type='IO_FILE', derefcnt=1, name='arg0')]),
 'ungetc': Function(type='int', derefcnt=0, name='ungetc', args=[Argument(type='int', derefcnt=0, name='c'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'ungetwc': Function(type='wint_t', derefcnt=0, name='ungetwc', args=[Argument(type='wint_t', derefcnt=0, name='wc'), Argument(type='FILE', derefcnt=1, name='stream')]),
 'unlink': Function(type='int', derefcnt=0, name='unlink', args=[Argument(type='char', derefcnt=1, name='name')]),
 'unlinkat': Function(type='int', derefcnt=0, name='unlinkat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='name'), Argument(type='int', derefcnt=0, name='flag')]),
 'unlockpt': Function(type='int', derefcnt=0, name='unlockpt', args=[Argument(type='int', derefcnt=0, name='fd')]),
 'unsetenv': Function(type='int', derefcnt=0, name='unsetenv', args=[Argument(type='char', derefcnt=1, name='name')]),
 'unshare': Function(type='int', derefcnt=0, name='unshare', args=[Argument(type='int', derefcnt=0, name='flags')]),
 'update': Function(type='int', derefcnt=0, name='update', args=[Argument(type='EVP_MD_CTX', derefcnt=1, name='ctx'), Argument(type='void', derefcnt=1, name='data'), Argument(type='size_t', derefcnt=0, name='count')]),
 'updwtmp': Function(type='void', derefcnt=0, name='updwtmp', args=[Argument(type='char', derefcnt=1, name='wtmp_file'), Argument(type='utmp', derefcnt=1, name='utmp')]),
 'updwtmpx': Function(type='void', derefcnt=0, name='updwtmpx', args=[Argument(type='char', derefcnt=1, name='wtmpx_file'), Argument(type='utmpx', derefcnt=1, name='utmpx')]),
 'uselocale': Function(type='locale_t', derefcnt=0, name='uselocale', args=[Argument(type='locale_t', derefcnt=0, name='dataset')]),
 'usleep': Function(type='int', derefcnt=0, name='usleep', args=[Argument(type='useconds_t', derefcnt=0, name='useconds')]),
 'ustat': Function(type='int', derefcnt=0, name='ustat', args=[Argument(type='dev_t', derefcnt=0, name='dev'), Argument(type='ustat', derefcnt=1, name='ubuf')]),
 'utime': Function(type='int', derefcnt=0, name='utime', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='utimbuf', derefcnt=1, name='file_times')]),
 'utimensat': Function(type='int', derefcnt=0, name='utimensat', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='path'), Argument(type='timespec', derefcnt=1, name='times'), Argument(type='int', derefcnt=0, name='flags')]),
 'utimes': Function(type='int', derefcnt=0, name='utimes', args=[Argument(type='char', derefcnt=1, name='file'), Argument(type='timeval', derefcnt=1, name='tvp')]),
 'utmpname': Function(type='int', derefcnt=0, name='utmpname', args=[Argument(type='char', derefcnt=1, name='file')]),
 'utmpxname': Function(type='int', derefcnt=0, name='utmpxname', args=[Argument(type='char', derefcnt=1, name='file')]),
 'valloc': Function(type='void', derefcnt=1, name='valloc', args=[Argument(type='size_t', derefcnt=0, name='size')]),
 'vasprintf': Function(type='int', derefcnt=0, name='vasprintf', args=[Argument(type='char', derefcnt=2, name='ptr'), Argument(type='char', derefcnt=1, name='f'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vdprintf': Function(type='int', derefcnt=0, name='vdprintf', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'verify': Function(type='int', derefcnt=0, name='verify', args=[Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'verify_callback': Function(type='int', derefcnt=0, name='verify_callback', args=[Argument(type='int', derefcnt=0, name='ok'), Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'verify_cb': Function(type='int', derefcnt=0, name='verify_cb', args=[Argument(type='int', derefcnt=0, name='ok'), Argument(type='X509_STORE_CTX', derefcnt=1, name='ctx')]),
 'verr': Function(type='void', derefcnt=0, name='verr', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg2')]),
 'verrx': Function(type='void', derefcnt=0, name='verrx', args=[Argument(type='int', derefcnt=0, name='status'), Argument(type='char', derefcnt=1, name='arg1'), Argument(type='gnuc_va_list', derefcnt=0, name='arg2')]),
 'versionsort': Function(type='int', derefcnt=0, name='versionsort', args=[Argument(type='dirent', derefcnt=2, name='e1'), Argument(type='dirent', derefcnt=2, name='e2')]),
 'versionsort64': Function(type='int', derefcnt=0, name='versionsort64', args=[Argument(type='dirent64', derefcnt=2, name='e1'), Argument(type='dirent64', derefcnt=2, name='e2')]),
 'vfork': Function(type='pid_t', derefcnt=0, name='vfork', args=[]),
 'vfprintf': Function(type='int', derefcnt=0, name='vfprintf', args=[Argument(type='FILE', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vfscanf': Function(type='int', derefcnt=0, name='vfscanf', args=[Argument(type='FILE', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vfwprintf': Function(type='int', derefcnt=0, name='vfwprintf', args=[Argument(type='FILE', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vfwscanf': Function(type='int', derefcnt=0, name='vfwscanf', args=[Argument(type='FILE', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vhangup': Function(type='int', derefcnt=0, name='vhangup', args=[]),
 'vmsplice': Function(type='ssize_t', derefcnt=0, name='vmsplice', args=[Argument(type='int', derefcnt=0, name='fdout'), Argument(type='iovec', derefcnt=1, name='iov'), Argument(type='size_t', derefcnt=0, name='count'), Argument(type='unsigned', derefcnt=0, name='flags')]),
 'vprintf': Function(type='int', derefcnt=0, name='vprintf', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vscanf': Function(type='int', derefcnt=0, name='vscanf', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vsnprintf': Function(type='int', derefcnt=0, name='vsnprintf', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxlen'), Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vsprintf': Function(type='int', derefcnt=0, name='vsprintf', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vsscanf': Function(type='int', derefcnt=0, name='vsscanf', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vswprintf': Function(type='int', derefcnt=0, name='vswprintf', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vswscanf': Function(type='int', derefcnt=0, name='vswscanf', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vsyslog': Function(type='void', derefcnt=0, name='vsyslog', args=[Argument(type='int', derefcnt=0, name='pri'), Argument(type='char', derefcnt=1, name='fmt'), Argument(type='gnuc_va_list', derefcnt=0, name='ap')]),
 'vwarn': Function(type='void', derefcnt=0, name='vwarn', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg1')]),
 'vwarnx': Function(type='void', derefcnt=0, name='vwarnx', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg1')]),
 'vwprintf': Function(type='int', derefcnt=0, name='vwprintf', args=[Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'vwscanf': Function(type='int', derefcnt=0, name='vwscanf', args=[Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='gnuc_va_list', derefcnt=0, name='arg')]),
 'wait': Function(type='pid_t', derefcnt=0, name='wait', args=[Argument(type='WAIT_STATUS', derefcnt=0, name='stat_loc')]),
 'wait3': Function(type='pid_t', derefcnt=0, name='wait3', args=[Argument(type='WAIT_STATUS', derefcnt=0, name='stat_loc'), Argument(type='int', derefcnt=0, name='options'), Argument(type='rusage', derefcnt=1, name='usage')]),
 'wait4': Function(type='pid_t', derefcnt=0, name='wait4', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='WAIT_STATUS', derefcnt=0, name='stat_loc'), Argument(type='int', derefcnt=0, name='options'), Argument(type='rusage', derefcnt=1, name='usage')]),
 'waitid': Function(type='int', derefcnt=0, name='waitid', args=[Argument(type='idtype_t', derefcnt=0, name='idtype'), Argument(type='id_t', derefcnt=0, name='id'), Argument(type='siginfo_t', derefcnt=1, name='infop'), Argument(type='int', derefcnt=0, name='options')]),
 'waitpid': Function(type='pid_t', derefcnt=0, name='waitpid', args=[Argument(type='pid_t', derefcnt=0, name='pid'), Argument(type='int', derefcnt=1, name='stat_loc'), Argument(type='int', derefcnt=0, name='options')]),
 'warn': Function(type='void', derefcnt=0, name='warn', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'warnx': Function(type='void', derefcnt=0, name='warnx', args=[Argument(type='char', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'wcpcpy': Function(type='wchar_t', derefcnt=1, name='wcpcpy', args=[Argument(type='wchar_t', derefcnt=1, name='dest'), Argument(type='wchar_t', derefcnt=1, name='src')]),
 'wcpncpy': Function(type='wchar_t', derefcnt=1, name='wcpncpy', args=[Argument(type='wchar_t', derefcnt=1, name='dest'), Argument(type='wchar_t', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcrtomb': Function(type='size_t', derefcnt=0, name='wcrtomb', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=0, name='wc'), Argument(type='mbstate_t', derefcnt=1, name='ps')]),
 'wcscasecmp': Function(type='int', derefcnt=0, name='wcscasecmp', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2')]),
 'wcscasecmp_l': Function(type='int', derefcnt=0, name='wcscasecmp_l', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcscat': Function(type='wchar_t', derefcnt=1, name='wcscat', args=[Argument(type='wchar_t', derefcnt=1, name='dest'), Argument(type='wchar_t', derefcnt=1, name='src')]),
 'wcschr': Function(type='wchar_t', derefcnt=1, name='wcschr', args=[Argument(type='wchar_t', derefcnt=1, name='wcs'), Argument(type='wchar_t', derefcnt=0, name='wc')]),
 'wcschrnul': Function(type='wchar_t', derefcnt=1, name='wcschrnul', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=0, name='wc')]),
 'wcscmp': Function(type='int', derefcnt=0, name='wcscmp', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2')]),
 'wcscoll': Function(type='int', derefcnt=0, name='wcscoll', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2')]),
 'wcscoll_l': Function(type='int', derefcnt=0, name='wcscoll_l', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcscpy': Function(type='wchar_t', derefcnt=1, name='wcscpy', args=[Argument(type='wchar_t', derefcnt=1, name='dest'), Argument(type='wchar_t', derefcnt=1, name='src')]),
 'wcscspn': Function(type='size_t', derefcnt=0, name='wcscspn', args=[Argument(type='wchar_t', derefcnt=1, name='wcs'), Argument(type='wchar_t', derefcnt=1, name='reject')]),
 'wcsdup': Function(type='wchar_t', derefcnt=1, name='wcsdup', args=[Argument(type='wchar_t', derefcnt=1, name='s')]),
 'wcsftime': Function(type='size_t', derefcnt=0, name='wcsftime', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxsize'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='tm', derefcnt=1, name='tp')]),
 'wcsftime_l': Function(type='size_t', derefcnt=0, name='wcsftime_l', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxsize'), Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='tm', derefcnt=1, name='tp'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcslen': Function(type='size_t', derefcnt=0, name='wcslen', args=[Argument(type='wchar_t', derefcnt=1, name='s')]),
 'wcsncasecmp': Function(type='int', derefcnt=0, name='wcsncasecmp', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcsncasecmp_l': Function(type='int', derefcnt=0, name='wcsncasecmp_l', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcsncat': Function(type='wchar_t', derefcnt=1, name='wcsncat', args=[Argument(type='wchar_t', derefcnt=1, name='dest'), Argument(type='wchar_t', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcsncmp': Function(type='int', derefcnt=0, name='wcsncmp', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcsncpy': Function(type='wchar_t', derefcnt=1, name='wcsncpy', args=[Argument(type='wchar_t', derefcnt=1, name='dest'), Argument(type='wchar_t', derefcnt=1, name='src'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcsnlen': Function(type='size_t', derefcnt=0, name='wcsnlen', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='maxlen')]),
 'wcsnrtombs': Function(type='size_t', derefcnt=0, name='wcsnrtombs', args=[Argument(type='char', derefcnt=1, name='dst'), Argument(type='wchar_t', derefcnt=2, name='src'), Argument(type='size_t', derefcnt=0, name='nwc'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='mbstate_t', derefcnt=1, name='ps')]),
 'wcspbrk': Function(type='wchar_t', derefcnt=1, name='wcspbrk', args=[Argument(type='wchar_t', derefcnt=1, name='wcs'), Argument(type='wchar_t', derefcnt=1, name='accept')]),
 'wcsrchr': Function(type='wchar_t', derefcnt=1, name='wcsrchr', args=[Argument(type='wchar_t', derefcnt=1, name='wcs'), Argument(type='wchar_t', derefcnt=0, name='wc')]),
 'wcsrtombs': Function(type='size_t', derefcnt=0, name='wcsrtombs', args=[Argument(type='char', derefcnt=1, name='dst'), Argument(type='wchar_t', derefcnt=2, name='src'), Argument(type='size_t', derefcnt=0, name='len'), Argument(type='mbstate_t', derefcnt=1, name='ps')]),
 'wcsspn': Function(type='size_t', derefcnt=0, name='wcsspn', args=[Argument(type='wchar_t', derefcnt=1, name='wcs'), Argument(type='wchar_t', derefcnt=1, name='accept')]),
 'wcsstr': Function(type='wchar_t', derefcnt=1, name='wcsstr', args=[Argument(type='wchar_t', derefcnt=1, name='haystack'), Argument(type='wchar_t', derefcnt=1, name='needle')]),
 'wcstod': Function(type='double', derefcnt=0, name='wcstod', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr')]),
 'wcstod_l': Function(type='double', derefcnt=0, name='wcstod_l', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcstof': Function(type='float', derefcnt=0, name='wcstof', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr')]),
 'wcstof_l': Function(type='float', derefcnt=0, name='wcstof_l', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcstoimax': Function(type='intmax_t', derefcnt=0, name='wcstoimax', args=[Argument(type='gwchar_t', derefcnt=1, name='nptr'), Argument(type='gwchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcstok': Function(type='wchar_t', derefcnt=1, name='wcstok', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=1, name='delim'), Argument(type='wchar_t', derefcnt=2, name='ptr')]),
 'wcstol': Function(type='long', derefcnt=0, name='wcstol', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcstol_l': Function(type='long', derefcnt=0, name='wcstol_l', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcstold': Function(type='long', derefcnt=0, name='wcstold', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr')]),
 'wcstold_l': Function(type='long', derefcnt=0, name='wcstold_l', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcstoll': Function(type='long', derefcnt=0, name='wcstoll', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcstoll_l': Function(type='long', derefcnt=0, name='wcstoll_l', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcstombs': Function(type='size_t', derefcnt=0, name='wcstombs', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=1, name='pwcs'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcstoq': Function(type='long', derefcnt=0, name='wcstoq', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcstoul': Function(type='unsigned', derefcnt=0, name='wcstoul', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcstoul_l': Function(type='unsigned', derefcnt=0, name='wcstoul_l', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcstoull': Function(type='unsigned', derefcnt=0, name='wcstoull', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcstoull_l': Function(type='unsigned', derefcnt=0, name='wcstoull_l', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wcstoumax': Function(type='uintmax_t', derefcnt=0, name='wcstoumax', args=[Argument(type='gwchar_t', derefcnt=1, name='nptr'), Argument(type='gwchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcstouq': Function(type='unsigned', derefcnt=0, name='wcstouq', args=[Argument(type='wchar_t', derefcnt=1, name='nptr'), Argument(type='wchar_t', derefcnt=2, name='endptr'), Argument(type='int', derefcnt=0, name='base')]),
 'wcswcs': Function(type='wchar_t', derefcnt=1, name='wcswcs', args=[Argument(type='wchar_t', derefcnt=1, name='haystack'), Argument(type='wchar_t', derefcnt=1, name='needle')]),
 'wcswidth': Function(type='int', derefcnt=0, name='wcswidth', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcsxfrm': Function(type='size_t', derefcnt=0, name='wcsxfrm', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wcsxfrm_l': Function(type='size_t', derefcnt=0, name='wcsxfrm_l', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n'), Argument(type='locale_t', derefcnt=0, name='loc')]),
 'wctob': Function(type='int', derefcnt=0, name='wctob', args=[Argument(type='wint_t', derefcnt=0, name='c')]),
 'wctomb': Function(type='int', derefcnt=0, name='wctomb', args=[Argument(type='char', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=0, name='wchar')]),
 'wctrans': Function(type='wctrans_t', derefcnt=0, name='wctrans', args=[Argument(type='char', derefcnt=1, name='property')]),
 'wctrans_l': Function(type='wctrans_t', derefcnt=0, name='wctrans_l', args=[Argument(type='char', derefcnt=1, name='property'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'wctype': Function(type='wctype_t', derefcnt=0, name='wctype', args=[Argument(type='char', derefcnt=1, name='property')]),
 'wctype_l': Function(type='wctype_t', derefcnt=0, name='wctype_l', args=[Argument(type='char', derefcnt=1, name='property'), Argument(type='locale_t', derefcnt=0, name='locale')]),
 'wcwidth': Function(type='int', derefcnt=0, name='wcwidth', args=[Argument(type='wchar_t', derefcnt=0, name='c')]),
 'wmemchr': Function(type='wchar_t', derefcnt=1, name='wmemchr', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=0, name='c'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wmemcmp': Function(type='int', derefcnt=0, name='wmemcmp', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wmemcpy': Function(type='wchar_t', derefcnt=1, name='wmemcpy', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wmemmove': Function(type='wchar_t', derefcnt=1, name='wmemmove', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wmempcpy': Function(type='wchar_t', derefcnt=1, name='wmempcpy', args=[Argument(type='wchar_t', derefcnt=1, name='s1'), Argument(type='wchar_t', derefcnt=1, name='s2'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wmemset': Function(type='wchar_t', derefcnt=1, name='wmemset', args=[Argument(type='wchar_t', derefcnt=1, name='s'), Argument(type='wchar_t', derefcnt=0, name='c'), Argument(type='size_t', derefcnt=0, name='n')]),
 'wordexp': Function(type='int', derefcnt=0, name='wordexp', args=[Argument(type='char', derefcnt=1, name='words'), Argument(type='wordexp_t', derefcnt=1, name='pwordexp'), Argument(type='int', derefcnt=0, name='flags')]),
 'wordfree': Function(type='void', derefcnt=0, name='wordfree', args=[Argument(type='wordexp_t', derefcnt=1, name='wordexp')]),
 'wprintf': Function(type='int', derefcnt=0, name='wprintf', args=[Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'write': Function(type='ssize_t', derefcnt=0, name='write', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='void', derefcnt=1, name='buf'), Argument(type='size_t', derefcnt=0, name='n')]),
 'writev': Function(type='ssize_t', derefcnt=0, name='writev', args=[Argument(type='int', derefcnt=0, name='fd'), Argument(type='iovec', derefcnt=1, name='iovec'), Argument(type='int', derefcnt=0, name='count')]),
 'wscanf': Function(type='int', derefcnt=0, name='wscanf', args=[Argument(type='wchar_t', derefcnt=1, name='format'), Argument(type='int', derefcnt=0, name='vararg')]),
 'xmknod': Function(type='int', derefcnt=0, name='xmknod', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode'), Argument(type='dev_t', derefcnt=1, name='dev')]),
 'xmknodat': Function(type='int', derefcnt=0, name='xmknodat', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='int', derefcnt=0, name='fd'), Argument(type='char', derefcnt=1, name='path'), Argument(type='mode_t', derefcnt=0, name='mode'), Argument(type='dev_t', derefcnt=1, name='dev')]),
 'xpg_basename': Function(type='char', derefcnt=1, name='xpg_basename', args=[Argument(type='char', derefcnt=1, name='path')]),
 'xstat': Function(type='int', derefcnt=0, name='xstat', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat', derefcnt=1, name='stat_buf')]),
 'xstat64': Function(type='int', derefcnt=0, name='xstat64', args=[Argument(type='int', derefcnt=0, name='ver'), Argument(type='char', derefcnt=1, name='filename'), Argument(type='stat64', derefcnt=1, name='stat_buf')]),
 'y0': Function(type='double', derefcnt=0, name='y0', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'y0f': Function(type='float', derefcnt=0, name='y0f', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'y0l': Function(type='long', derefcnt=0, name='y0l', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'y1': Function(type='double', derefcnt=0, name='y1', args=[Argument(type='double', derefcnt=0, name='arg0')]),
 'y1f': Function(type='float', derefcnt=0, name='y1f', args=[Argument(type='float', derefcnt=0, name='arg0')]),
 'y1l': Function(type='long', derefcnt=0, name='y1l', args=[Argument(type='long', derefcnt=0, name='arg0')]),
 'yn': Function(type='double', derefcnt=0, name='yn', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='double', derefcnt=0, name='arg1')]),
 'ynf': Function(type='float', derefcnt=0, name='ynf', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='float', derefcnt=0, name='arg1')]),
 'ynl': Function(type='long', derefcnt=0, name='ynl', args=[Argument(type='int', derefcnt=0, name='arg0'), Argument(type='long', derefcnt=0, name='arg1')]),
 'zError': Function(type='char', derefcnt=1, name='zError', args=[Argument(type='int', derefcnt=0, name='arg0')]),
 'zlibCompileFlags': Function(type='uLong', derefcnt=0, name='zlibCompileFlags', args=[]),
 'zlibVersion': Function(type='char', derefcnt=1, name='zlibVersion', args=[])}
