# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 NXP
# Copyright © 2019 Status Research & Development GmbH.
# Copyright © 2021 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from .wp_drm_lease_connector_v1 import WpDrmLeaseConnectorV1
from .wp_drm_lease_request_v1 import WpDrmLeaseRequestV1


class WpDrmLeaseDeviceV1(Interface):
    """Lease device

    This protocol is used by Wayland compositors which act as Direct
    Renderering Manager (DRM) masters to lease DRM resources to Wayland
    clients.

    The compositor will advertise one :class:`WpDrmLeaseDeviceV1` global for
    each DRM node. Some time after a client binds to the
    :class:`WpDrmLeaseDeviceV1` global, the compositor will send a drm_fd event
    followed by zero, one or more connector events. After all currently
    available connectors have been sent, the compositor will send a
    :func:`WpDrmLeaseDeviceV1.done()` event.

    When the list of connectors available for lease changes the compositor will
    send :func:`WpDrmLeaseDeviceV1.connector()` events for added connectors and
    :func:`WpDrmLeaseConnectorV1.withdrawn()
    <pywayland.protocol.drm_lease_v1.WpDrmLeaseConnectorV1.withdrawn>` events
    for removed connectors, followed by a :func:`WpDrmLeaseDeviceV1.done()`
    event.

    The compositor will indicate when a device is gone by removing the global
    via a :func:`WlRegistry.global_remove()
    <pywayland.protocol.wayland.WlRegistry.global_remove>` event. Upon
    receiving this event, the client should destroy any matching
    :class:`WpDrmLeaseDeviceV1` object.

    To destroy a :class:`WpDrmLeaseDeviceV1` object, the client must first
    issue a release request. Upon receiving this request, the compositor will
    immediately send a released event and destroy the object. The client must
    continue to process and discard drm_fd and connector events until it
    receives the released event. Upon receiving the released event, the client
    can safely cleanup any client-side resources.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "wp_drm_lease_device_v1"
    version = 1


class WpDrmLeaseDeviceV1Proxy(Proxy):
    interface = WpDrmLeaseDeviceV1

    @WpDrmLeaseDeviceV1.request(
        Argument(ArgumentType.NewId, interface=WpDrmLeaseRequestV1),
    )
    def create_lease_request(self):
        """Create a lease request object

        Creates a lease request object.

        See the documentation for
        :class:`~pywayland.protocol.drm_lease_v1.WpDrmLeaseRequestV1` for
        details.

        :returns:
            :class:`~pywayland.protocol.drm_lease_v1.WpDrmLeaseRequestV1`
        """
        id = self._marshal_constructor(0, WpDrmLeaseRequestV1)
        return id

    @WpDrmLeaseDeviceV1.request()
    def release(self):
        """Release this object

        Indicates the client no longer wishes to use this object. In response
        the compositor will immediately send the released event and destroy
        this object. It can however not guarantee that the client won't receive
        connector events before the released event. The client must not send
        any requests after this one, doing so will raise a
        :class:`~pywayland.protocol.wayland.WlDisplay` error. Existing
        connectors, lease request and leases will not be affected.
        """
        self._marshal(1)


class WpDrmLeaseDeviceV1Resource(Resource):
    interface = WpDrmLeaseDeviceV1

    @WpDrmLeaseDeviceV1.event(
        Argument(ArgumentType.FileDescriptor),
    )
    def drm_fd(self, fd):
        """Open a non-master fd for this drm node

        The compositor will send this event when the
        :class:`WpDrmLeaseDeviceV1` global is bound, although there are no
        guarantees as to how long this takes - the compositor might need to
        wait until regaining DRM master. The included fd is a non-master DRM
        file descriptor opened for this device and the compositor must not
        authenticate it. The purpose of this event is to give the client the
        ability to query DRM and discover information which may help them pick
        the appropriate DRM device or select the appropriate connectors
        therein.

        :param fd:
            DRM file descriptor
        :type fd:
            `ArgumentType.FileDescriptor`
        """
        self._post_event(0, fd)

    @WpDrmLeaseDeviceV1.event(
        Argument(ArgumentType.NewId, interface=WpDrmLeaseConnectorV1),
    )
    def connector(self, id):
        """Advertise connectors available for leases

        The compositor will use this event to advertise connectors available
        for lease by clients. This object may be passed into a lease request to
        indicate the client would like to lease that connector, see
        :func:`WpDrmLeaseRequestV1.request_connector()
        <pywayland.protocol.drm_lease_v1.WpDrmLeaseRequestV1.request_connector>`
        for details. While the compositor will make a best effort to not send
        disconnected connectors, no guarantees can be made.

        The compositor must send the drm_fd event before sending connectors.
        After the drm_fd event it will send all available connectors but may
        send additional connectors at any time.

        :param id:
        :type id:
            :class:`~pywayland.protocol.drm_lease_v1.WpDrmLeaseConnectorV1`
        """
        self._post_event(1, id)

    @WpDrmLeaseDeviceV1.event()
    def done(self):
        """Signals grouping of connectors

        The compositor will send this event to indicate that it has sent all
        currently available connectors after the client binds to the global or
        when it updates the connector list, for example on hotplug, drm master
        change or when a leased connector becomes available again. It will
        similarly send this event to group
        :func:`WpDrmLeaseConnectorV1.withdrawn()
        <pywayland.protocol.drm_lease_v1.WpDrmLeaseConnectorV1.withdrawn>`
        events of connectors of this device.
        """
        self._post_event(2)

    @WpDrmLeaseDeviceV1.event()
    def released(self):
        """The compositor has finished using the device

        This event is sent in response to the release request and indicates
        that the compositor is done sending connector events. The compositor
        will destroy this object immediately after sending the event and it
        will become invalid. The client should release any resources associated
        with this device after receiving this event.
        """
        self._post_event(3)


class WpDrmLeaseDeviceV1Global(Global):
    interface = WpDrmLeaseDeviceV1


WpDrmLeaseDeviceV1._gen_c()
WpDrmLeaseDeviceV1.proxy_class = WpDrmLeaseDeviceV1Proxy
WpDrmLeaseDeviceV1.resource_class = WpDrmLeaseDeviceV1Resource
WpDrmLeaseDeviceV1.global_class = WpDrmLeaseDeviceV1Global
