// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega1284RFR2.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega1284rfr2
// +build avr,atmega1284rfr2

// Device information for the ATmega1284RFR2.
package avr

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega1284RFR2"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET             = 0  // External Pin,Power-on Reset,Brown-out Reset,Watchdog Reset,and JTAG AVR Reset. See Datasheet.
	IRQ_INT0              = 1  // External Interrupt Request 0
	IRQ_INT1              = 2  // External Interrupt Request 1
	IRQ_INT2              = 3  // External Interrupt Request 2
	IRQ_INT3              = 4  // External Interrupt Request 3
	IRQ_INT4              = 5  // External Interrupt Request 4
	IRQ_INT5              = 6  // External Interrupt Request 5
	IRQ_INT6              = 7  // External Interrupt Request 6
	IRQ_INT7              = 8  // External Interrupt Request 7
	IRQ_PCINT0            = 9  // Pin Change Interrupt Request 0
	IRQ_PCINT1            = 10 // Pin Change Interrupt Request 1
	IRQ_PCINT2            = 11 // Pin Change Interrupt Request 2
	IRQ_WDT               = 12 // Watchdog Time-out Interrupt
	IRQ_TIMER2_COMPA      = 13 // Timer/Counter2 Compare Match A
	IRQ_TIMER2_COMPB      = 14 // Timer/Counter2 Compare Match B
	IRQ_TIMER2_OVF        = 15 // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT       = 16 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA      = 17 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB      = 18 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_COMPC      = 19 // Timer/Counter1 Compare Match C
	IRQ_TIMER1_OVF        = 20 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA      = 21 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB      = 22 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF        = 23 // Timer/Counter0 Overflow
	IRQ_SPI_STC           = 24 // SPI Serial Transfer Complete
	IRQ_USART0_RX         = 25 // USART0, Rx Complete
	IRQ_USART0_UDRE       = 26 // USART0 Data register Empty
	IRQ_USART0_TX         = 27 // USART0, Tx Complete
	IRQ_ANALOG_COMP       = 28 // Analog Comparator
	IRQ_ADC               = 29 // ADC Conversion Complete
	IRQ_EE_READY          = 30 // EEPROM Ready
	IRQ_TIMER3_CAPT       = 31 // Timer/Counter3 Capture Event
	IRQ_TIMER3_COMPA      = 32 // Timer/Counter3 Compare Match A
	IRQ_TIMER3_COMPB      = 33 // Timer/Counter3 Compare Match B
	IRQ_TIMER3_COMPC      = 34 // Timer/Counter3 Compare Match C
	IRQ_TIMER3_OVF        = 35 // Timer/Counter3 Overflow
	IRQ_USART1_RX         = 36 // USART1, Rx Complete
	IRQ_USART1_UDRE       = 37 // USART1 Data register Empty
	IRQ_USART1_TX         = 38 // USART1, Tx Complete
	IRQ_TWI               = 39 // 2-wire Serial Interface
	IRQ_SPM_READY         = 40 // Store Program Memory Read
	IRQ_TIMER4_CAPT       = 41 // Timer/Counter4 Capture Event
	IRQ_TIMER4_COMPA      = 42 // Timer/Counter4 Compare Match A
	IRQ_TIMER4_COMPB      = 43 // Timer/Counter4 Compare Match B
	IRQ_TIMER4_COMPC      = 44 // Timer/Counter4 Compare Match C
	IRQ_TIMER4_OVF        = 45 // Timer/Counter4 Overflow
	IRQ_TIMER5_CAPT       = 46 // Timer/Counter5 Capture Event
	IRQ_TIMER5_COMPA      = 47 // Timer/Counter5 Compare Match A
	IRQ_TIMER5_COMPB      = 48 // Timer/Counter5 Compare Match B
	IRQ_TIMER5_COMPC      = 49 // Timer/Counter5 Compare Match C
	IRQ_TIMER5_OVF        = 50 // Timer/Counter5 Overflow
	IRQ_TRX24_PLL_LOCK    = 57 // TRX24 - PLL lock interrupt
	IRQ_TRX24_PLL_UNLOCK  = 58 // TRX24 - PLL unlock interrupt
	IRQ_TRX24_RX_START    = 59 // TRX24 - Receive start interrupt
	IRQ_TRX24_RX_END      = 60 // TRX24 - RX_END interrupt
	IRQ_TRX24_CCA_ED_DONE = 61 // TRX24 - CCA/ED done interrupt
	IRQ_TRX24_XAH_AMI     = 62 // TRX24 - XAH - AMI
	IRQ_TRX24_TX_END      = 63 // TRX24 - TX_END interrupt
	IRQ_TRX24_AWAKE       = 64 // TRX24 AWAKE - tranceiver is reaching state TRX_OFF
	IRQ_SCNT_CMP1         = 65 // Symbol counter - compare match 1 interrupt
	IRQ_SCNT_CMP2         = 66 // Symbol counter - compare match 2 interrupt
	IRQ_SCNT_CMP3         = 67 // Symbol counter - compare match 3 interrupt
	IRQ_SCNT_OVFL         = 68 // Symbol counter - overflow interrupt
	IRQ_SCNT_BACKOFF      = 69 // Symbol counter - backoff interrupt
	IRQ_AES_READY         = 70 // AES engine ready interrupt
	IRQ_BAT_LOW           = 71 // Battery monitor indicates supply voltage below threshold
	IRQ_TRX24_TX_START    = 72 // TRX24 TX start interrupt
	IRQ_TRX24_AMI0        = 73 // Address match interrupt of address filter 0
	IRQ_TRX24_AMI1        = 74 // Address match interrupt of address filter 1
	IRQ_TRX24_AMI2        = 75 // Address match interrupt of address filter 2
	IRQ_TRX24_AMI3        = 76 // Address match interrupt of address filter 3
	IRQ_max               = 76 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_RESET, "__vector_RESET")
	_ = interrupt.Register(IRQ_INT0, "__vector_INT0")
	_ = interrupt.Register(IRQ_INT1, "__vector_INT1")
	_ = interrupt.Register(IRQ_INT2, "__vector_INT2")
	_ = interrupt.Register(IRQ_INT3, "__vector_INT3")
	_ = interrupt.Register(IRQ_INT4, "__vector_INT4")
	_ = interrupt.Register(IRQ_INT5, "__vector_INT5")
	_ = interrupt.Register(IRQ_INT6, "__vector_INT6")
	_ = interrupt.Register(IRQ_INT7, "__vector_INT7")
	_ = interrupt.Register(IRQ_PCINT0, "__vector_PCINT0")
	_ = interrupt.Register(IRQ_PCINT1, "__vector_PCINT1")
	_ = interrupt.Register(IRQ_PCINT2, "__vector_PCINT2")
	_ = interrupt.Register(IRQ_WDT, "__vector_WDT")
	_ = interrupt.Register(IRQ_TIMER2_COMPA, "__vector_TIMER2_COMPA")
	_ = interrupt.Register(IRQ_TIMER2_COMPB, "__vector_TIMER2_COMPB")
	_ = interrupt.Register(IRQ_TIMER2_OVF, "__vector_TIMER2_OVF")
	_ = interrupt.Register(IRQ_TIMER1_CAPT, "__vector_TIMER1_CAPT")
	_ = interrupt.Register(IRQ_TIMER1_COMPA, "__vector_TIMER1_COMPA")
	_ = interrupt.Register(IRQ_TIMER1_COMPB, "__vector_TIMER1_COMPB")
	_ = interrupt.Register(IRQ_TIMER1_COMPC, "__vector_TIMER1_COMPC")
	_ = interrupt.Register(IRQ_TIMER1_OVF, "__vector_TIMER1_OVF")
	_ = interrupt.Register(IRQ_TIMER0_COMPA, "__vector_TIMER0_COMPA")
	_ = interrupt.Register(IRQ_TIMER0_COMPB, "__vector_TIMER0_COMPB")
	_ = interrupt.Register(IRQ_TIMER0_OVF, "__vector_TIMER0_OVF")
	_ = interrupt.Register(IRQ_SPI_STC, "__vector_SPI_STC")
	_ = interrupt.Register(IRQ_USART0_RX, "__vector_USART0_RX")
	_ = interrupt.Register(IRQ_USART0_UDRE, "__vector_USART0_UDRE")
	_ = interrupt.Register(IRQ_USART0_TX, "__vector_USART0_TX")
	_ = interrupt.Register(IRQ_ANALOG_COMP, "__vector_ANALOG_COMP")
	_ = interrupt.Register(IRQ_ADC, "__vector_ADC")
	_ = interrupt.Register(IRQ_EE_READY, "__vector_EE_READY")
	_ = interrupt.Register(IRQ_TIMER3_CAPT, "__vector_TIMER3_CAPT")
	_ = interrupt.Register(IRQ_TIMER3_COMPA, "__vector_TIMER3_COMPA")
	_ = interrupt.Register(IRQ_TIMER3_COMPB, "__vector_TIMER3_COMPB")
	_ = interrupt.Register(IRQ_TIMER3_COMPC, "__vector_TIMER3_COMPC")
	_ = interrupt.Register(IRQ_TIMER3_OVF, "__vector_TIMER3_OVF")
	_ = interrupt.Register(IRQ_USART1_RX, "__vector_USART1_RX")
	_ = interrupt.Register(IRQ_USART1_UDRE, "__vector_USART1_UDRE")
	_ = interrupt.Register(IRQ_USART1_TX, "__vector_USART1_TX")
	_ = interrupt.Register(IRQ_TWI, "__vector_TWI")
	_ = interrupt.Register(IRQ_SPM_READY, "__vector_SPM_READY")
	_ = interrupt.Register(IRQ_TIMER4_CAPT, "__vector_TIMER4_CAPT")
	_ = interrupt.Register(IRQ_TIMER4_COMPA, "__vector_TIMER4_COMPA")
	_ = interrupt.Register(IRQ_TIMER4_COMPB, "__vector_TIMER4_COMPB")
	_ = interrupt.Register(IRQ_TIMER4_COMPC, "__vector_TIMER4_COMPC")
	_ = interrupt.Register(IRQ_TIMER4_OVF, "__vector_TIMER4_OVF")
	_ = interrupt.Register(IRQ_TIMER5_CAPT, "__vector_TIMER5_CAPT")
	_ = interrupt.Register(IRQ_TIMER5_COMPA, "__vector_TIMER5_COMPA")
	_ = interrupt.Register(IRQ_TIMER5_COMPB, "__vector_TIMER5_COMPB")
	_ = interrupt.Register(IRQ_TIMER5_COMPC, "__vector_TIMER5_COMPC")
	_ = interrupt.Register(IRQ_TIMER5_OVF, "__vector_TIMER5_OVF")
	_ = interrupt.Register(IRQ_TRX24_PLL_LOCK, "__vector_TRX24_PLL_LOCK")
	_ = interrupt.Register(IRQ_TRX24_PLL_UNLOCK, "__vector_TRX24_PLL_UNLOCK")
	_ = interrupt.Register(IRQ_TRX24_RX_START, "__vector_TRX24_RX_START")
	_ = interrupt.Register(IRQ_TRX24_RX_END, "__vector_TRX24_RX_END")
	_ = interrupt.Register(IRQ_TRX24_CCA_ED_DONE, "__vector_TRX24_CCA_ED_DONE")
	_ = interrupt.Register(IRQ_TRX24_XAH_AMI, "__vector_TRX24_XAH_AMI")
	_ = interrupt.Register(IRQ_TRX24_TX_END, "__vector_TRX24_TX_END")
	_ = interrupt.Register(IRQ_TRX24_AWAKE, "__vector_TRX24_AWAKE")
	_ = interrupt.Register(IRQ_SCNT_CMP1, "__vector_SCNT_CMP1")
	_ = interrupt.Register(IRQ_SCNT_CMP2, "__vector_SCNT_CMP2")
	_ = interrupt.Register(IRQ_SCNT_CMP3, "__vector_SCNT_CMP3")
	_ = interrupt.Register(IRQ_SCNT_OVFL, "__vector_SCNT_OVFL")
	_ = interrupt.Register(IRQ_SCNT_BACKOFF, "__vector_SCNT_BACKOFF")
	_ = interrupt.Register(IRQ_AES_READY, "__vector_AES_READY")
	_ = interrupt.Register(IRQ_BAT_LOW, "__vector_BAT_LOW")
	_ = interrupt.Register(IRQ_TRX24_TX_START, "__vector_TRX24_TX_START")
	_ = interrupt.Register(IRQ_TRX24_AMI0, "__vector_TRX24_AMI0")
	_ = interrupt.Register(IRQ_TRX24_AMI1, "__vector_TRX24_AMI1")
	_ = interrupt.Register(IRQ_TRX24_AMI2, "__vector_TRX24_AMI2")
	_ = interrupt.Register(IRQ_TRX24_AMI3, "__vector_TRX24_AMI3")
)

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Analog Comparator
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	DIDR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))

	// USART
	UDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc6)))
	UBRR0L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc4)))
	UBRR0H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc5)))
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))

	// Two Wire Serial Interface
	TWAMR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbd)))
	TWBR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	TWAR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	PORTF = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	DDRF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))
	PINF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	PORTG = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	DDRG  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x33)))
	PING  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))

	// Timer/Counter, 8-bit Async
	TIMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x70)))
	TIFR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	TCCR2A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb0)))
	TCCR2B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb1)))
	TCNT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb2)))
	OCR2B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb4)))
	OCR2A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb3)))
	ASSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb6)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// Timer/Counter, 16-bit
	TCCR5A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x120)))
	TCCR5B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x121)))
	TCCR5C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x122)))
	TCNT5L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x124)))
	TCNT5H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x125)))
	OCR5AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x128)))
	OCR5AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x129)))
	OCR5BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12a)))
	OCR5BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12b)))
	OCR5CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12c)))
	OCR5CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12d)))
	ICR5L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x126)))
	ICR5H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x127)))
	TIMSK5 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x73)))
	TIFR5  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	TCCR4A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa0)))
	TCCR4B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa1)))
	TCCR4C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa2)))
	TCNT4L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa4)))
	TCNT4H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa5)))
	OCR4AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa8)))
	OCR4AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa9)))
	OCR4BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaa)))
	OCR4BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xab)))
	OCR4CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xac)))
	OCR4CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xad)))
	ICR4L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa6)))
	ICR4H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa7)))
	TIMSK4 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x72)))
	TIFR4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	TCCR3A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))
	TCCR3B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	TCCR3C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	TCNT3L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x94)))
	TCNT3H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x95)))
	OCR3AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x98)))
	OCR3AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x99)))
	OCR3BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9a)))
	OCR3BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9b)))
	OCR3CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9c)))
	OCR3CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9d)))
	ICR3L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	ICR3H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))
	TIMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x71)))
	TIFR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	OCR1CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8c)))
	OCR1CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8d)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))

	// Low-Power 2.4 GHz Transceiver
	PARCR         = (*volatile.Register8)(unsafe.Pointer(uintptr(0x138)))
	MAFSA0L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x10e)))
	MAFSA0H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x10f)))
	MAFPA0L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x110)))
	MAFPA0H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x111)))
	MAFSA1L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x112)))
	MAFSA1H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x113)))
	MAFPA1L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x114)))
	MAFPA1H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x115)))
	MAFSA2L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x116)))
	MAFSA2H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x117)))
	MAFPA2L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x118)))
	MAFPA2H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x119)))
	MAFSA3L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x11a)))
	MAFSA3H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x11b)))
	MAFPA3L       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x11c)))
	MAFPA3H       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x11d)))
	MAFCR0        = (*volatile.Register8)(unsafe.Pointer(uintptr(0x10c)))
	MAFCR1        = (*volatile.Register8)(unsafe.Pointer(uintptr(0x10d)))
	AES_CTRL      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x13c)))
	AES_STATUS    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x13d)))
	AES_STATE     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x13e)))
	AES_KEY       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x13f)))
	TRX_STATUS    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x141)))
	TRX_STATE     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x142)))
	TRX_CTRL_0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x143)))
	TRX_CTRL_1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x144)))
	PHY_TX_PWR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x145)))
	PHY_RSSI      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x146)))
	PHY_ED_LEVEL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x147)))
	PHY_CC_CCA    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x148)))
	CCA_THRES     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x149)))
	RX_CTRL       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x14a)))
	SFD_VALUE     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x14b)))
	TRX_CTRL_2    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x14c)))
	ANT_DIV       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x14d)))
	IRQ_MASK      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x14e)))
	IRQ_STATUS    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x14f)))
	IRQ_MASK1     = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbe)))
	IRQ_STATUS1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbf)))
	VREG_CTRL     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x150)))
	BATMON        = (*volatile.Register8)(unsafe.Pointer(uintptr(0x151)))
	XOSC_CTRL     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x152)))
	CC_CTRL_0     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x153)))
	CC_CTRL_1     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x154)))
	RX_SYN        = (*volatile.Register8)(unsafe.Pointer(uintptr(0x155)))
	TRX_RPC       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x156)))
	XAH_CTRL_1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x157)))
	FTN_CTRL      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x158)))
	PLL_CF        = (*volatile.Register8)(unsafe.Pointer(uintptr(0x15a)))
	PLL_DCU       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x15b)))
	PART_NUM      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x15c)))
	VERSION_NUM   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x15d)))
	MAN_ID_0      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x15e)))
	MAN_ID_1      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x15f)))
	SHORT_ADDR_0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x160)))
	SHORT_ADDR_1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x161)))
	PAN_ID_0      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x162)))
	PAN_ID_1      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x163)))
	IEEE_ADDR_0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x164)))
	IEEE_ADDR_1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x165)))
	IEEE_ADDR_2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x166)))
	IEEE_ADDR_3   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x167)))
	IEEE_ADDR_4   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x168)))
	IEEE_ADDR_5   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x169)))
	IEEE_ADDR_6   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x16a)))
	IEEE_ADDR_7   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x16b)))
	XAH_CTRL_0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x16c)))
	CSMA_SEED_0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x16d)))
	CSMA_SEED_1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x16e)))
	CSMA_BE       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x16f)))
	TST_CTRL_DIGI = (*volatile.Register8)(unsafe.Pointer(uintptr(0x176)))
	TST_RX_LENGTH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x17b)))
	TRXFBST       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x180)))
	TRXFBEND      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1ff)))

	// MAC Symbol Counter
	SCTSTRHH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfc)))
	SCTSTRHL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfb)))
	SCTSTRLH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfa)))
	SCTSTRLL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf9)))
	SCOCR1HH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))
	SCOCR1HL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	SCOCR1LH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	SCOCR1LL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	SCOCR2HH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	SCOCR2HL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	SCOCR2LH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	SCOCR2LL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	SCOCR3HH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	SCOCR3HL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xef)))
	SCOCR3LH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xee)))
	SCOCR3LL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xed)))
	SCTSRHH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xec)))
	SCTSRHL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xeb)))
	SCTSRLH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xea)))
	SCTSRLL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	SCBTSRHH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	SCBTSRHL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe7)))
	SCBTSRLH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	SCBTSRLL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	SCCNTHH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	SCCNTHL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	SCCNTLH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	SCCNTLL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	SCIRQS   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))
	SCIRQM   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	SCSR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	SCCR1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdd)))
	SCCR0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdc)))
	SCCSR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdb)))
	SCRSTRHH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xda)))
	SCRSTRHL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd9)))
	SCRSTRLH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	SCRSTRLL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd7)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// JTAG Interface
	OCDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EICRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCSRC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x77)))
	DIDR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	RAMPZ  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PRR2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x63)))
	PRR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x65)))
	PRR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))

	// FLASH Controller
	NEMCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x75)))
	BGCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x67)))

	// Power Controller
	TRXPR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x139)))
	DRTRAM0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x135)))
	DRTRAM1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x134)))
	DRTRAM2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x133)))
	DRTRAM3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x132)))
	LLDRL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x130)))
	LLDRH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x131)))
	LLCR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12f)))
	DPDS0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x136)))
	DPDS1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x137)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODLEVEL0 = 0x1 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL1 = 0x2 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL2 = 0x4 // Brown-out Detector trigger level

	// HIGH
	HIGH_OCDEN   = 0x80 // On-Chip Debug Enabled
	HIGH_JTAGEN  = 0x40 // JTAG Interface Enabled
	HIGH_SPIEN   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON   = 0x10 // Watchdog timer always on
	HIGH_EESAVE  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0 = 0x2  // Select Boot Size
	HIGH_BOOTSZ1 = 0x4  // Select Boot Size
	HIGH_BOOTRST = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8     = 0x80 // Divide clock by 8 internally
	LOW_CKOUT      = 0x40 // Clock output on PORTE7
	LOW_CKSEL_SUT0 = 0x1  // Select Clock Source : Start-up time
	LOW_CKSEL_SUT1 = 0x2  // Select Clock Source : Start-up time
	LOW_CKSEL_SUT2 = 0x4  // Select Clock Source : Start-up time
	LOW_CKSEL_SUT3 = 0x8  // Select Clock Source : Start-up time
	LOW_CKSEL_SUT4 = 0x10 // Select Clock Source : Start-up time
	LOW_CKSEL_SUT5 = 0x20 // Select Clock Source : Start-up time
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0   = 0x1  // Memory Lock
	LOCKBIT_LB1   = 0x2  // Memory Lock
	LOCKBIT_BLB00 = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01 = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB10 = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11 = 0x20 // Boot Loader Protection Mode
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD   = 0x80 // Analog Comparator Disable
	ACSR_ACBG  = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO   = 0x20 // Analog Compare Output
	ACSR_ACI   = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE  = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC  = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0 = 0x1  // Analog Comparator Interrupt Mode Select
	ACSR_ACIS1 = 0x2  // Analog Comparator Interrupt Mode Select

	// DIDR1: Digital Input Disable Register 1
	DIDR1_AIN1D = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN0D = 0x1 // AIN0 Digital Input Disable
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWAMR: TWI (Slave) Address Mask Register
	TWAMR_TWAM0 = 0x2  // TWI Address Mask
	TWAMR_TWAM1 = 0x4  // TWI Address Mask
	TWAMR_TWAM2 = 0x8  // TWI Address Mask
	TWAMR_TWAM3 = 0x10 // TWI Address Mask
	TWAMR_TWAM4 = 0x20 // TWI Address Mask
	TWAMR_TWAM5 = 0x40 // TWI Address Mask
	TWAMR_TWAM6 = 0x80 // TWI Address Mask
	TWAMR_Res   = 0x1  // Reserved Bit

	// TWCR: TWI Control Register
	TWCR_TWINT = 0x80 // TWI Interrupt Flag
	TWCR_TWEA  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA = 0x20 // TWI START Condition Bit
	TWCR_TWSTO = 0x10 // TWI STOP Condition Bit
	TWCR_TWWC  = 0x8  // TWI Write Collision Flag
	TWCR_TWEN  = 0x4  // TWI Enable Bit
	TWCR_Res   = 0x2  // Reserved Bit
	TWCR_TWIE  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0  = 0x8  // TWI Status
	TWSR_TWS1  = 0x10 // TWI Status
	TWSR_TWS2  = 0x20 // TWI Status
	TWSR_TWS3  = 0x40 // TWI Status
	TWSR_TWS4  = 0x80 // TWI Status
	TWSR_Res   = 0x4  // Reserved Bit
	TWSR_TWPS0 = 0x1  // TWI Prescaler Bits
	TWSR_TWPS1 = 0x2  // TWI Prescaler Bits

	// TWAR: TWI (Slave) Address Register
	TWAR_TWA0  = 0x2  // TWI (Slave) Address
	TWAR_TWA1  = 0x4  // TWI (Slave) Address
	TWAR_TWA2  = 0x8  // TWI (Slave) Address
	TWAR_TWA3  = 0x10 // TWI (Slave) Address
	TWAR_TWA4  = 0x20 // TWI (Slave) Address
	TWAR_TWA5  = 0x40 // TWI (Slave) Address
	TWAR_TWA6  = 0x80 // TWI (Slave) Address
	TWAR_TWGCE = 0x1  // TWI General Call Recognition Enable Bit
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE = 0x80 // SPI Interrupt Enable
	SPCR_SPE  = 0x40 // SPI Enable
	SPCR_DORD = 0x20 // Data Order
	SPCR_MSTR = 0x10 // Master/Slave Select
	SPCR_CPOL = 0x8  // Clock polarity
	SPCR_CPHA = 0x4  // Clock Phase
	SPCR_SPR0 = 0x1  // SPI Clock Rate Select 1 and 0
	SPCR_SPR1 = 0x2  // SPI Clock Rate Select 1 and 0

	// SPSR: SPI Status Register
	SPSR_SPIF  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL  = 0x40 // Write Collision Flag
	SPSR_Res0  = 0x2  // Reserved
	SPSR_Res1  = 0x4  // Reserved
	SPSR_Res2  = 0x8  // Reserved
	SPSR_Res3  = 0x10 // Reserved
	SPSR_Res4  = 0x20 // Reserved
	SPSR_SPI2X = 0x1  // Double SPI Speed Bit
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0B: Timer/Counter0 Control Register B
	TCCR0B_FOC0A = 0x80 // Force Output Compare A
	TCCR0B_FOC0B = 0x40 // Force Output Compare B
	TCCR0B_Res0  = 0x10 // Reserved Bit
	TCCR0B_Res1  = 0x20 // Reserved Bit
	TCCR0B_WGM02 = 0x8
	TCCR0B_CS00  = 0x1 // Clock Select
	TCCR0B_CS01  = 0x2 // Clock Select
	TCCR0B_CS02  = 0x4 // Clock Select

	// TCCR0A: Timer/Counter0 Control Register A
	TCCR0A_COM0A0 = 0x40 // Compare Match Output A Mode
	TCCR0A_COM0A1 = 0x80 // Compare Match Output A Mode
	TCCR0A_COM0B0 = 0x10 // Compare Match Output B Mode
	TCCR0A_COM0B1 = 0x20 // Compare Match Output B Mode
	TCCR0A_Res0   = 0x4  // Reserved Bit
	TCCR0A_Res1   = 0x8  // Reserved Bit
	TCCR0A_WGM00  = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01  = 0x2  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_Res0   = 0x8  // Reserved
	TIMSK0_Res1   = 0x10 // Reserved
	TIMSK0_Res2   = 0x20 // Reserved
	TIMSK0_Res3   = 0x40 // Reserved
	TIMSK0_Res4   = 0x80 // Reserved
	TIMSK0_OCIE0B = 0x4  // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A = 0x2  // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0  = 0x1  // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag Register
	TIFR0_Res0  = 0x8  // Reserved
	TIFR0_Res1  = 0x10 // Reserved
	TIFR0_Res2  = 0x20 // Reserved
	TIFR0_Res3  = 0x40 // Reserved
	TIFR0_Res4  = 0x80 // Reserved
	TIFR0_OCF0B = 0x4  // Timer/Counter0 Output Compare B Match Flag
	TIFR0_OCF0A = 0x2  // Timer/Counter0 Output Compare A Match Flag
	TIFR0_TOV0  = 0x1  // Timer/Counter0 Overflow Flag
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TIMSK2: Timer/Counter Interrupt Mask register
	TIMSK2_Res0   = 0x8  // Reserved Bit
	TIMSK2_Res1   = 0x10 // Reserved Bit
	TIMSK2_Res2   = 0x20 // Reserved Bit
	TIMSK2_Res3   = 0x40 // Reserved Bit
	TIMSK2_Res4   = 0x80 // Reserved Bit
	TIMSK2_OCIE2B = 0x4  // Timer/Counter2 Output Compare Match B Interrupt Enable
	TIMSK2_OCIE2A = 0x2  // Timer/Counter2 Output Compare Match A Interrupt Enable
	TIMSK2_TOIE2  = 0x1  // Timer/Counter2 Overflow Interrupt Enable

	// TIFR2: Timer/Counter Interrupt Flag Register
	TIFR2_Res0  = 0x8  // Reserved Bit
	TIFR2_Res1  = 0x10 // Reserved Bit
	TIFR2_Res2  = 0x20 // Reserved Bit
	TIFR2_Res3  = 0x40 // Reserved Bit
	TIFR2_Res4  = 0x80 // Reserved Bit
	TIFR2_OCF2B = 0x4  // Output Compare Flag 2 B
	TIFR2_OCF2A = 0x2  // Output Compare Flag 2 A
	TIFR2_TOV2  = 0x1  // Timer/Counter2 Overflow Flag

	// TCCR2A: Timer/Counter2 Control Register A
	TCCR2A_COM2A0 = 0x40 // Compare Match Output A Mode
	TCCR2A_COM2A1 = 0x80 // Compare Match Output A Mode
	TCCR2A_COM2B0 = 0x10 // Compare Match Output B Mode
	TCCR2A_COM2B1 = 0x20 // Compare Match Output B Mode
	TCCR2A_Res0   = 0x4  // Reserved
	TCCR2A_Res1   = 0x8  // Reserved
	TCCR2A_WGM20  = 0x1  // Waveform Generation Mode
	TCCR2A_WGM21  = 0x2  // Waveform Generation Mode

	// TCCR2B: Timer/Counter2 Control Register B
	TCCR2B_FOC2A = 0x80 // Force Output Compare A
	TCCR2B_FOC2B = 0x40 // Force Output Compare B
	TCCR2B_Res0  = 0x10 // Reserved
	TCCR2B_Res1  = 0x20 // Reserved
	TCCR2B_WGM22 = 0x8  // Waveform Generation Mode
	TCCR2B_CS20  = 0x1  // Clock Select
	TCCR2B_CS21  = 0x2  // Clock Select
	TCCR2B_CS22  = 0x4  // Clock Select

	// ASSR: Asynchronous Status Register
	ASSR_EXCLKAMR = 0x80 // Enable External Clock Input for AMR
	ASSR_EXCLK    = 0x40 // Enable External Clock Input
	ASSR_AS2      = 0x20 // Timer/Counter2 Asynchronous Mode
	ASSR_TCN2UB   = 0x10 // Timer/Counter2 Update Busy
	ASSR_OCR2AUB  = 0x8  // Timer/Counter2 Output Compare Register A Update Busy
	ASSR_OCR2BUB  = 0x4  // Timer/Counter2 Output Compare Register B Update Busy
	ASSR_TCR2AUB  = 0x2  // Timer/Counter2 Control Register A Update Busy
	ASSR_TCR2BUB  = 0x1  // Timer/Counter2 Control Register B Update Busy
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0 = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1 = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2 = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3 = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE = 0x10 // Watchdog Change Enable
	WDTCSR_WDE  = 0x8  // Watch Dog Enable
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR5A: Timer/Counter5 Control Register A
	TCCR5A_COM5A0 = 0x40 // Compare Output Mode for Channel A
	TCCR5A_COM5A1 = 0x80 // Compare Output Mode for Channel A
	TCCR5A_COM5B0 = 0x10 // Compare Output Mode for Channel B
	TCCR5A_COM5B1 = 0x20 // Compare Output Mode for Channel B
	TCCR5A_COM5C0 = 0x4  // Compare Output Mode for Channel C
	TCCR5A_COM5C1 = 0x8  // Compare Output Mode for Channel C
	TCCR5A_WGM50  = 0x1  // Waveform Generation Mode
	TCCR5A_WGM51  = 0x2  // Waveform Generation Mode

	// TCCR5B: Timer/Counter5 Control Register B
	TCCR5B_ICNC5 = 0x80 // Input Capture 5 Noise Canceller
	TCCR5B_ICES5 = 0x40 // Input Capture 5 Edge Select
	TCCR5B_Res   = 0x20 // Reserved Bit
	TCCR5B_WGM50 = 0x8  // Waveform Generation Mode
	TCCR5B_WGM51 = 0x10 // Waveform Generation Mode
	TCCR5B_CS50  = 0x1  // Clock Select
	TCCR5B_CS51  = 0x2  // Clock Select
	TCCR5B_CS52  = 0x4  // Clock Select

	// TCCR5C: Timer/Counter5 Control Register C
	TCCR5C_FOC5A = 0x80 // Force Output Compare for Channel A
	TCCR5C_FOC5B = 0x40 // Force Output Compare for Channel B
	TCCR5C_FOC5C = 0x20 // Force Output Compare for Channel C
	TCCR5C_Res0  = 0x1  // Reserved
	TCCR5C_Res1  = 0x2  // Reserved
	TCCR5C_Res2  = 0x4  // Reserved
	TCCR5C_Res3  = 0x8  // Reserved
	TCCR5C_Res4  = 0x10 // Reserved

	// TIMSK5: Timer/Counter5 Interrupt Mask Register
	TIMSK5_ICIE5  = 0x20 // Timer/Counter5 Input Capture Interrupt Enable
	TIMSK5_OCIE5C = 0x8  // Timer/Counter5 Output Compare C Match Interrupt Enable
	TIMSK5_OCIE5B = 0x4  // Timer/Counter5 Output Compare B Match Interrupt Enable
	TIMSK5_OCIE5A = 0x2  // Timer/Counter5 Output Compare A Match Interrupt Enable
	TIMSK5_TOIE5  = 0x1  // Timer/Counter5 Overflow Interrupt Enable

	// TIFR5: Timer/Counter5 Interrupt Flag Register
	TIFR5_ICF5  = 0x20 // Timer/Counter5 Input Capture Flag
	TIFR5_OCF5C = 0x8  // Timer/Counter5 Output Compare C Match Flag
	TIFR5_OCF5B = 0x4  // Timer/Counter5 Output Compare B Match Flag
	TIFR5_OCF5A = 0x2  // Timer/Counter5 Output Compare A Match Flag
	TIFR5_TOV5  = 0x1  // Timer/Counter5 Overflow Flag

	// TCCR4A: Timer/Counter4 Control Register A
	TCCR4A_COM4A0 = 0x40 // Compare Output Mode for Channel A
	TCCR4A_COM4A1 = 0x80 // Compare Output Mode for Channel A
	TCCR4A_COM4B0 = 0x10 // Compare Output Mode for Channel B
	TCCR4A_COM4B1 = 0x20 // Compare Output Mode for Channel B
	TCCR4A_COM4C0 = 0x4  // Compare Output Mode for Channel C
	TCCR4A_COM4C1 = 0x8  // Compare Output Mode for Channel C
	TCCR4A_WGM40  = 0x1  // Waveform Generation Mode
	TCCR4A_WGM41  = 0x2  // Waveform Generation Mode

	// TCCR4B: Timer/Counter4 Control Register B
	TCCR4B_ICNC4 = 0x80 // Input Capture 4 Noise Canceller
	TCCR4B_ICES4 = 0x40 // Input Capture 4 Edge Select
	TCCR4B_Res   = 0x20 // Reserved Bit
	TCCR4B_WGM40 = 0x8  // Waveform Generation Mode
	TCCR4B_WGM41 = 0x10 // Waveform Generation Mode
	TCCR4B_CS40  = 0x1  // Clock Select
	TCCR4B_CS41  = 0x2  // Clock Select
	TCCR4B_CS42  = 0x4  // Clock Select

	// TCCR4C: Timer/Counter4 Control Register C
	TCCR4C_FOC4A = 0x80 // Force Output Compare for Channel A
	TCCR4C_FOC4B = 0x40 // Force Output Compare for Channel B
	TCCR4C_FOC4C = 0x20 // Force Output Compare for Channel C
	TCCR4C_Res0  = 0x1  // Reserved
	TCCR4C_Res1  = 0x2  // Reserved
	TCCR4C_Res2  = 0x4  // Reserved
	TCCR4C_Res3  = 0x8  // Reserved
	TCCR4C_Res4  = 0x10 // Reserved

	// TIMSK4: Timer/Counter4 Interrupt Mask Register
	TIMSK4_ICIE4  = 0x20 // Timer/Counter4 Input Capture Interrupt Enable
	TIMSK4_OCIE4C = 0x8  // Timer/Counter4 Output Compare C Match Interrupt Enable
	TIMSK4_OCIE4B = 0x4  // Timer/Counter4 Output Compare B Match Interrupt Enable
	TIMSK4_OCIE4A = 0x2  // Timer/Counter4 Output Compare A Match Interrupt Enable
	TIMSK4_TOIE4  = 0x1  // Timer/Counter4 Overflow Interrupt Enable

	// TIFR4: Timer/Counter4 Interrupt Flag Register
	TIFR4_ICF4  = 0x20 // Timer/Counter4 Input Capture Flag
	TIFR4_OCF4C = 0x8  // Timer/Counter4 Output Compare C Match Flag
	TIFR4_OCF4B = 0x4  // Timer/Counter4 Output Compare B Match Flag
	TIFR4_OCF4A = 0x2  // Timer/Counter4 Output Compare A Match Flag
	TIFR4_TOV4  = 0x1  // Timer/Counter4 Overflow Flag

	// TCCR3A: Timer/Counter3 Control Register A
	TCCR3A_COM3A0 = 0x40 // Compare Output Mode for Channel A
	TCCR3A_COM3A1 = 0x80 // Compare Output Mode for Channel A
	TCCR3A_COM3B0 = 0x10 // Compare Output Mode for Channel B
	TCCR3A_COM3B1 = 0x20 // Compare Output Mode for Channel B
	TCCR3A_COM3C0 = 0x4  // Compare Output Mode for Channel C
	TCCR3A_COM3C1 = 0x8  // Compare Output Mode for Channel C
	TCCR3A_WGM30  = 0x1  // Waveform Generation Mode
	TCCR3A_WGM31  = 0x2  // Waveform Generation Mode

	// TCCR3B: Timer/Counter3 Control Register B
	TCCR3B_ICNC3 = 0x80 // Input Capture 3 Noise Canceller
	TCCR3B_ICES3 = 0x40 // Input Capture 3 Edge Select
	TCCR3B_Res   = 0x20 // Reserved Bit
	TCCR3B_WGM30 = 0x8  // Waveform Generation Mode
	TCCR3B_WGM31 = 0x10 // Waveform Generation Mode
	TCCR3B_CS30  = 0x1  // Clock Select
	TCCR3B_CS31  = 0x2  // Clock Select
	TCCR3B_CS32  = 0x4  // Clock Select

	// TCCR3C: Timer/Counter3 Control Register C
	TCCR3C_FOC3A = 0x80 // Force Output Compare for Channel A
	TCCR3C_FOC3B = 0x40 // Force Output Compare for Channel B
	TCCR3C_FOC3C = 0x20 // Force Output Compare for Channel C
	TCCR3C_Res0  = 0x1  // Reserved
	TCCR3C_Res1  = 0x2  // Reserved
	TCCR3C_Res2  = 0x4  // Reserved
	TCCR3C_Res3  = 0x8  // Reserved
	TCCR3C_Res4  = 0x10 // Reserved

	// TIMSK3: Timer/Counter3 Interrupt Mask Register
	TIMSK3_ICIE3  = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_OCIE3C = 0x8  // Timer/Counter3 Output Compare C Match Interrupt Enable
	TIMSK3_OCIE3B = 0x4  // Timer/Counter3 Output Compare B Match Interrupt Enable
	TIMSK3_OCIE3A = 0x2  // Timer/Counter3 Output Compare A Match Interrupt Enable
	TIMSK3_TOIE3  = 0x1  // Timer/Counter3 Overflow Interrupt Enable

	// TIFR3: Timer/Counter3 Interrupt Flag Register
	TIFR3_ICF3  = 0x20 // Timer/Counter3 Input Capture Flag
	TIFR3_OCF3C = 0x8  // Timer/Counter3 Output Compare C Match Flag
	TIFR3_OCF3B = 0x4  // Timer/Counter3 Output Compare B Match Flag
	TIFR3_OCF3A = 0x2  // Timer/Counter3 Output Compare A Match Flag
	TIFR3_TOV3  = 0x1  // Timer/Counter3 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0 = 0x40 // Compare Output Mode for Channel A
	TCCR1A_COM1A1 = 0x80 // Compare Output Mode for Channel A
	TCCR1A_COM1B0 = 0x10 // Compare Output Mode for Channel B
	TCCR1A_COM1B1 = 0x20 // Compare Output Mode for Channel B
	TCCR1A_COM1C0 = 0x4  // Compare Output Mode for Channel C
	TCCR1A_COM1C1 = 0x8  // Compare Output Mode for Channel C
	TCCR1A_WGM10  = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11  = 0x2  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1 = 0x80 // Input Capture 1 Noise Canceller
	TCCR1B_ICES1 = 0x40 // Input Capture 1 Edge Select
	TCCR1B_Res   = 0x20 // Reserved Bit
	TCCR1B_WGM10 = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11 = 0x10 // Waveform Generation Mode
	TCCR1B_CS10  = 0x1  // Clock Select
	TCCR1B_CS11  = 0x2  // Clock Select
	TCCR1B_CS12  = 0x4  // Clock Select

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A = 0x80 // Force Output Compare for Channel A
	TCCR1C_FOC1B = 0x40 // Force Output Compare for Channel B
	TCCR1C_FOC1C = 0x20 // Force Output Compare for Channel C
	TCCR1C_Res0  = 0x1  // Reserved
	TCCR1C_Res1  = 0x2  // Reserved
	TCCR1C_Res2  = 0x4  // Reserved
	TCCR1C_Res3  = 0x8  // Reserved
	TCCR1C_Res4  = 0x10 // Reserved

	// TIMSK1: Timer/Counter1 Interrupt Mask Register
	TIMSK1_ICIE1  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1C = 0x8  // Timer/Counter1 Output Compare C Match Interrupt Enable
	TIMSK1_OCIE1B = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1A = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_TOIE1  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter1 Interrupt Flag Register
	TIFR1_ICF1  = 0x20 // Timer/Counter1 Input Capture Flag
	TIFR1_OCF1C = 0x8  // Timer/Counter1 Output Compare C Match Flag
	TIFR1_OCF1B = 0x4  // Timer/Counter1 Output Compare B Match Flag
	TIFR1_OCF1A = 0x2  // Timer/Counter1 Output Compare A Match Flag
	TIFR1_TOV1  = 0x1  // Timer/Counter1 Overflow Flag
)

// Bitfields for TRX24: Low-Power 2.4 GHz Transceiver
const (
	// PARCR: Power Amplifier Ramp up/down Control Register
	PARCR_PALTD0 = 0x20 // ext. PA Ramp Down Lead Time
	PARCR_PALTD1 = 0x40 // ext. PA Ramp Down Lead Time
	PARCR_PALTD2 = 0x80 // ext. PA Ramp Down Lead Time
	PARCR_PALTU0 = 0x4  // ext. PA Ramp Up Lead Time
	PARCR_PALTU1 = 0x8  // ext. PA Ramp Up Lead Time
	PARCR_PALTU2 = 0x10 // ext. PA Ramp Up Lead Time
	PARCR_PARDFI = 0x2  // Power Amplifier Ramp Down Frequency Inversion
	PARCR_PARUFI = 0x1  // Power Amplifier Ramp Up Frequency Inversion

	// MAFSA0L: Transceiver MAC Short Address Register for Frame Filter 0 (Low Byte)
	MAFSA0L_MAFSA0L0 = 0x1  // MAC Short Address low Byte for Frame Filter 0
	MAFSA0L_MAFSA0L1 = 0x2  // MAC Short Address low Byte for Frame Filter 0
	MAFSA0L_MAFSA0L2 = 0x4  // MAC Short Address low Byte for Frame Filter 0
	MAFSA0L_MAFSA0L3 = 0x8  // MAC Short Address low Byte for Frame Filter 0
	MAFSA0L_MAFSA0L4 = 0x10 // MAC Short Address low Byte for Frame Filter 0
	MAFSA0L_MAFSA0L5 = 0x20 // MAC Short Address low Byte for Frame Filter 0
	MAFSA0L_MAFSA0L6 = 0x40 // MAC Short Address low Byte for Frame Filter 0
	MAFSA0L_MAFSA0L7 = 0x80 // MAC Short Address low Byte for Frame Filter 0

	// MAFSA0H: Transceiver MAC Short Address Register for Frame Filter 0 (High Byte)
	MAFSA0H_MAFSA0H0 = 0x1  // MAC Short Address high Byte for Frame Filter 0
	MAFSA0H_MAFSA0H1 = 0x2  // MAC Short Address high Byte for Frame Filter 0
	MAFSA0H_MAFSA0H2 = 0x4  // MAC Short Address high Byte for Frame Filter 0
	MAFSA0H_MAFSA0H3 = 0x8  // MAC Short Address high Byte for Frame Filter 0
	MAFSA0H_MAFSA0H4 = 0x10 // MAC Short Address high Byte for Frame Filter 0
	MAFSA0H_MAFSA0H5 = 0x20 // MAC Short Address high Byte for Frame Filter 0
	MAFSA0H_MAFSA0H6 = 0x40 // MAC Short Address high Byte for Frame Filter 0
	MAFSA0H_MAFSA0H7 = 0x80 // MAC Short Address high Byte for Frame Filter 0

	// MAFPA0L: Transceiver Personal Area Network ID Register for Frame Filter 0 (Low Byte)
	MAFPA0L_MAFPA0L0 = 0x1  // MAC Personal Area Network ID low Byte for Frame Filter 0
	MAFPA0L_MAFPA0L1 = 0x2  // MAC Personal Area Network ID low Byte for Frame Filter 0
	MAFPA0L_MAFPA0L2 = 0x4  // MAC Personal Area Network ID low Byte for Frame Filter 0
	MAFPA0L_MAFPA0L3 = 0x8  // MAC Personal Area Network ID low Byte for Frame Filter 0
	MAFPA0L_MAFPA0L4 = 0x10 // MAC Personal Area Network ID low Byte for Frame Filter 0
	MAFPA0L_MAFPA0L5 = 0x20 // MAC Personal Area Network ID low Byte for Frame Filter 0
	MAFPA0L_MAFPA0L6 = 0x40 // MAC Personal Area Network ID low Byte for Frame Filter 0
	MAFPA0L_MAFPA0L7 = 0x80 // MAC Personal Area Network ID low Byte for Frame Filter 0

	// MAFPA0H: Transceiver Personal Area Network ID Register for Frame Filter 0 (High Byte)
	MAFPA0H_MAFPA0H0 = 0x1  // MAC Personal Area Network ID high Byte for Frame Filter 0
	MAFPA0H_MAFPA0H1 = 0x2  // MAC Personal Area Network ID high Byte for Frame Filter 0
	MAFPA0H_MAFPA0H2 = 0x4  // MAC Personal Area Network ID high Byte for Frame Filter 0
	MAFPA0H_MAFPA0H3 = 0x8  // MAC Personal Area Network ID high Byte for Frame Filter 0
	MAFPA0H_MAFPA0H4 = 0x10 // MAC Personal Area Network ID high Byte for Frame Filter 0
	MAFPA0H_MAFPA0H5 = 0x20 // MAC Personal Area Network ID high Byte for Frame Filter 0
	MAFPA0H_MAFPA0H6 = 0x40 // MAC Personal Area Network ID high Byte for Frame Filter 0
	MAFPA0H_MAFPA0H7 = 0x80 // MAC Personal Area Network ID high Byte for Frame Filter 0

	// MAFSA1L: Transceiver MAC Short Address Register for Frame Filter 1 (Low Byte)
	MAFSA1L_MAFSA1L0 = 0x1  // MAC Short Address low Byte for Frame Filter 1
	MAFSA1L_MAFSA1L1 = 0x2  // MAC Short Address low Byte for Frame Filter 1
	MAFSA1L_MAFSA1L2 = 0x4  // MAC Short Address low Byte for Frame Filter 1
	MAFSA1L_MAFSA1L3 = 0x8  // MAC Short Address low Byte for Frame Filter 1
	MAFSA1L_MAFSA1L4 = 0x10 // MAC Short Address low Byte for Frame Filter 1
	MAFSA1L_MAFSA1L5 = 0x20 // MAC Short Address low Byte for Frame Filter 1
	MAFSA1L_MAFSA1L6 = 0x40 // MAC Short Address low Byte for Frame Filter 1
	MAFSA1L_MAFSA1L7 = 0x80 // MAC Short Address low Byte for Frame Filter 1

	// MAFSA1H: Transceiver MAC Short Address Register for Frame Filter 1 (High Byte)
	MAFSA1H_MAFSA1H0 = 0x1  // MAC Short Address high Byte for Frame Filter 1
	MAFSA1H_MAFSA1H1 = 0x2  // MAC Short Address high Byte for Frame Filter 1
	MAFSA1H_MAFSA1H2 = 0x4  // MAC Short Address high Byte for Frame Filter 1
	MAFSA1H_MAFSA1H3 = 0x8  // MAC Short Address high Byte for Frame Filter 1
	MAFSA1H_MAFSA1H4 = 0x10 // MAC Short Address high Byte for Frame Filter 1
	MAFSA1H_MAFSA1H5 = 0x20 // MAC Short Address high Byte for Frame Filter 1
	MAFSA1H_MAFSA1H6 = 0x40 // MAC Short Address high Byte for Frame Filter 1
	MAFSA1H_MAFSA1H7 = 0x80 // MAC Short Address high Byte for Frame Filter 1

	// MAFPA1L: Transceiver Personal Area Network ID Register for Frame Filter 1 (Low Byte)
	MAFPA1L_MAFPA1L0 = 0x1  // MAC Personal Area Network ID low Byte for Frame Filter 1
	MAFPA1L_MAFPA1L1 = 0x2  // MAC Personal Area Network ID low Byte for Frame Filter 1
	MAFPA1L_MAFPA1L2 = 0x4  // MAC Personal Area Network ID low Byte for Frame Filter 1
	MAFPA1L_MAFPA1L3 = 0x8  // MAC Personal Area Network ID low Byte for Frame Filter 1
	MAFPA1L_MAFPA1L4 = 0x10 // MAC Personal Area Network ID low Byte for Frame Filter 1
	MAFPA1L_MAFPA1L5 = 0x20 // MAC Personal Area Network ID low Byte for Frame Filter 1
	MAFPA1L_MAFPA1L6 = 0x40 // MAC Personal Area Network ID low Byte for Frame Filter 1
	MAFPA1L_MAFPA1L7 = 0x80 // MAC Personal Area Network ID low Byte for Frame Filter 1

	// MAFPA1H: Transceiver Personal Area Network ID Register for Frame Filter 1 (High Byte)
	MAFPA1H_MAFPA1H0 = 0x1  // MAC Personal Area Network ID high Byte for Frame Filter 1
	MAFPA1H_MAFPA1H1 = 0x2  // MAC Personal Area Network ID high Byte for Frame Filter 1
	MAFPA1H_MAFPA1H2 = 0x4  // MAC Personal Area Network ID high Byte for Frame Filter 1
	MAFPA1H_MAFPA1H3 = 0x8  // MAC Personal Area Network ID high Byte for Frame Filter 1
	MAFPA1H_MAFPA1H4 = 0x10 // MAC Personal Area Network ID high Byte for Frame Filter 1
	MAFPA1H_MAFPA1H5 = 0x20 // MAC Personal Area Network ID high Byte for Frame Filter 1
	MAFPA1H_MAFPA1H6 = 0x40 // MAC Personal Area Network ID high Byte for Frame Filter 1
	MAFPA1H_MAFPA1H7 = 0x80 // MAC Personal Area Network ID high Byte for Frame Filter 1

	// MAFSA2L: Transceiver MAC Short Address Register for Frame Filter 2 (Low Byte)
	MAFSA2L_MAFSA2L0 = 0x1  // MAC Short Address low Byte for Frame Filter 2
	MAFSA2L_MAFSA2L1 = 0x2  // MAC Short Address low Byte for Frame Filter 2
	MAFSA2L_MAFSA2L2 = 0x4  // MAC Short Address low Byte for Frame Filter 2
	MAFSA2L_MAFSA2L3 = 0x8  // MAC Short Address low Byte for Frame Filter 2
	MAFSA2L_MAFSA2L4 = 0x10 // MAC Short Address low Byte for Frame Filter 2
	MAFSA2L_MAFSA2L5 = 0x20 // MAC Short Address low Byte for Frame Filter 2
	MAFSA2L_MAFSA2L6 = 0x40 // MAC Short Address low Byte for Frame Filter 2
	MAFSA2L_MAFSA2L7 = 0x80 // MAC Short Address low Byte for Frame Filter 2

	// MAFSA2H: Transceiver MAC Short Address Register for Frame Filter 2 (High Byte)
	MAFSA2H_MAFSA2H0 = 0x1  // MAC Short Address high Byte for Frame Filter 2
	MAFSA2H_MAFSA2H1 = 0x2  // MAC Short Address high Byte for Frame Filter 2
	MAFSA2H_MAFSA2H2 = 0x4  // MAC Short Address high Byte for Frame Filter 2
	MAFSA2H_MAFSA2H3 = 0x8  // MAC Short Address high Byte for Frame Filter 2
	MAFSA2H_MAFSA2H4 = 0x10 // MAC Short Address high Byte for Frame Filter 2
	MAFSA2H_MAFSA2H5 = 0x20 // MAC Short Address high Byte for Frame Filter 2
	MAFSA2H_MAFSA2H6 = 0x40 // MAC Short Address high Byte for Frame Filter 2
	MAFSA2H_MAFSA2H7 = 0x80 // MAC Short Address high Byte for Frame Filter 2

	// MAFPA2L: Transceiver Personal Area Network ID Register for Frame Filter 2 (Low Byte)
	MAFPA2L_MAFPA2L0 = 0x1  // MAC Personal Area Network ID low Byte for Frame Filter 2
	MAFPA2L_MAFPA2L1 = 0x2  // MAC Personal Area Network ID low Byte for Frame Filter 2
	MAFPA2L_MAFPA2L2 = 0x4  // MAC Personal Area Network ID low Byte for Frame Filter 2
	MAFPA2L_MAFPA2L3 = 0x8  // MAC Personal Area Network ID low Byte for Frame Filter 2
	MAFPA2L_MAFPA2L4 = 0x10 // MAC Personal Area Network ID low Byte for Frame Filter 2
	MAFPA2L_MAFPA2L5 = 0x20 // MAC Personal Area Network ID low Byte for Frame Filter 2
	MAFPA2L_MAFPA2L6 = 0x40 // MAC Personal Area Network ID low Byte for Frame Filter 2
	MAFPA2L_MAFPA2L7 = 0x80 // MAC Personal Area Network ID low Byte for Frame Filter 2

	// MAFPA2H: Transceiver Personal Area Network ID Register for Frame Filter 2 (High Byte)
	MAFPA2H_MAFPA2H0 = 0x1  // MAC Personal Area Network ID high Byte for Frame Filter 2
	MAFPA2H_MAFPA2H1 = 0x2  // MAC Personal Area Network ID high Byte for Frame Filter 2
	MAFPA2H_MAFPA2H2 = 0x4  // MAC Personal Area Network ID high Byte for Frame Filter 2
	MAFPA2H_MAFPA2H3 = 0x8  // MAC Personal Area Network ID high Byte for Frame Filter 2
	MAFPA2H_MAFPA2H4 = 0x10 // MAC Personal Area Network ID high Byte for Frame Filter 2
	MAFPA2H_MAFPA2H5 = 0x20 // MAC Personal Area Network ID high Byte for Frame Filter 2
	MAFPA2H_MAFPA2H6 = 0x40 // MAC Personal Area Network ID high Byte for Frame Filter 2
	MAFPA2H_MAFPA2H7 = 0x80 // MAC Personal Area Network ID high Byte for Frame Filter 2

	// MAFSA3L: Transceiver MAC Short Address Register for Frame Filter 3 (Low Byte)
	MAFSA3L_MAFSA3L0 = 0x1  // MAC Short Address low Byte for Frame Filter 3
	MAFSA3L_MAFSA3L1 = 0x2  // MAC Short Address low Byte for Frame Filter 3
	MAFSA3L_MAFSA3L2 = 0x4  // MAC Short Address low Byte for Frame Filter 3
	MAFSA3L_MAFSA3L3 = 0x8  // MAC Short Address low Byte for Frame Filter 3
	MAFSA3L_MAFSA3L4 = 0x10 // MAC Short Address low Byte for Frame Filter 3
	MAFSA3L_MAFSA3L5 = 0x20 // MAC Short Address low Byte for Frame Filter 3
	MAFSA3L_MAFSA3L6 = 0x40 // MAC Short Address low Byte for Frame Filter 3
	MAFSA3L_MAFSA3L7 = 0x80 // MAC Short Address low Byte for Frame Filter 3

	// MAFSA3H: Transceiver MAC Short Address Register for Frame Filter 3 (High Byte)
	MAFSA3H_MAFSA3H0 = 0x1  // MAC Short Address high Byte for Frame Filter 3
	MAFSA3H_MAFSA3H1 = 0x2  // MAC Short Address high Byte for Frame Filter 3
	MAFSA3H_MAFSA3H2 = 0x4  // MAC Short Address high Byte for Frame Filter 3
	MAFSA3H_MAFSA3H3 = 0x8  // MAC Short Address high Byte for Frame Filter 3
	MAFSA3H_MAFSA3H4 = 0x10 // MAC Short Address high Byte for Frame Filter 3
	MAFSA3H_MAFSA3H5 = 0x20 // MAC Short Address high Byte for Frame Filter 3
	MAFSA3H_MAFSA3H6 = 0x40 // MAC Short Address high Byte for Frame Filter 3
	MAFSA3H_MAFSA3H7 = 0x80 // MAC Short Address high Byte for Frame Filter 3

	// MAFPA3L: Transceiver Personal Area Network ID Register for Frame Filter 3 (Low Byte)
	MAFPA3L_MAFPA3L0 = 0x1  // MAC Personal Area Network ID low Byte for Frame Filter 3
	MAFPA3L_MAFPA3L1 = 0x2  // MAC Personal Area Network ID low Byte for Frame Filter 3
	MAFPA3L_MAFPA3L2 = 0x4  // MAC Personal Area Network ID low Byte for Frame Filter 3
	MAFPA3L_MAFPA3L3 = 0x8  // MAC Personal Area Network ID low Byte for Frame Filter 3
	MAFPA3L_MAFPA3L4 = 0x10 // MAC Personal Area Network ID low Byte for Frame Filter 3
	MAFPA3L_MAFPA3L5 = 0x20 // MAC Personal Area Network ID low Byte for Frame Filter 3
	MAFPA3L_MAFPA3L6 = 0x40 // MAC Personal Area Network ID low Byte for Frame Filter 3
	MAFPA3L_MAFPA3L7 = 0x80 // MAC Personal Area Network ID low Byte for Frame Filter 3

	// MAFPA3H: Transceiver Personal Area Network ID Register for Frame Filter 3 (High Byte)
	MAFPA3H_MAFPA3H0 = 0x1  // MAC Personal Area Network ID high Byte for Frame Filter 3
	MAFPA3H_MAFPA3H1 = 0x2  // MAC Personal Area Network ID high Byte for Frame Filter 3
	MAFPA3H_MAFPA3H2 = 0x4  // MAC Personal Area Network ID high Byte for Frame Filter 3
	MAFPA3H_MAFPA3H3 = 0x8  // MAC Personal Area Network ID high Byte for Frame Filter 3
	MAFPA3H_MAFPA3H4 = 0x10 // MAC Personal Area Network ID high Byte for Frame Filter 3
	MAFPA3H_MAFPA3H5 = 0x20 // MAC Personal Area Network ID high Byte for Frame Filter 3
	MAFPA3H_MAFPA3H6 = 0x40 // MAC Personal Area Network ID high Byte for Frame Filter 3
	MAFPA3H_MAFPA3H7 = 0x80 // MAC Personal Area Network ID high Byte for Frame Filter 3

	// MAFCR0: Multiple Address Filter Configuration Register 0
	MAFCR0_Res0   = 0x10 // Reserved Bit
	MAFCR0_Res1   = 0x20 // Reserved Bit
	MAFCR0_Res2   = 0x40 // Reserved Bit
	MAFCR0_Res3   = 0x80 // Reserved Bit
	MAFCR0_MAF3EN = 0x8  // Multiple Address Filter 3 Enable
	MAFCR0_MAF2EN = 0x4  // Multiple Address Filter 2 Enable
	MAFCR0_MAF1EN = 0x2  // Multiple Address Filter 1 Enable
	MAFCR0_MAF0EN = 0x1  // Multiple Address Filter 0 Enable

	// MAFCR1: Multiple Address Filter Configuration Register 1
	MAFCR1_AACK_3_SET_PD     = 0x80 // Set Data Pending bit for address filter 3.
	MAFCR1_AACK_3_I_AM_COORD = 0x40 // Enable PAN Coordinator mode for address filter 3.
	MAFCR1_AACK_2_SET_PD     = 0x20 // Set Data Pending bit for address filter 2.
	MAFCR1_AACK_2_I_AM_COORD = 0x10 // Enable PAN Coordinator mode for address filter 2.
	MAFCR1_AACK_1_SET_PD     = 0x8  // Set Data Pending bit for address filter 1.
	MAFCR1_AACK_1_I_AM_COORD = 0x4  // Enable PAN Coordinator mode for address filter 1.
	MAFCR1_AACK_0_SET_PD     = 0x2  // Set Data Pending bit for address filter 0.
	MAFCR1_AACK_0_I_AM_COORD = 0x1  // Enable PAN Coordinator mode for address filter 0.

	// AES_CTRL: AES Control Register
	AES_CTRL_AES_REQUEST = 0x80 // Request AES Operation.
	AES_CTRL_AES_MODE    = 0x20 // Set AES Operation Mode
	AES_CTRL_AES_DIR     = 0x8  // Set AES Operation Direction
	AES_CTRL_AES_IM      = 0x4  // AES Interrupt Enable

	// AES_STATUS: AES Status Register
	AES_STATUS_AES_ER   = 0x80 // AES Operation Finished with Error
	AES_STATUS_Res0     = 0x2  // Reserved
	AES_STATUS_Res1     = 0x4  // Reserved
	AES_STATUS_Res2     = 0x8  // Reserved
	AES_STATUS_Res3     = 0x10 // Reserved
	AES_STATUS_Res4     = 0x20 // Reserved
	AES_STATUS_Res5     = 0x40 // Reserved
	AES_STATUS_AES_DONE = 0x1  // AES Operation Finished with Success

	// AES_STATE: AES Plain and Cipher Text Buffer Register
	AES_STATE_AES_STATE0 = 0x1  // AES Plain and Cipher Text Buffer
	AES_STATE_AES_STATE1 = 0x2  // AES Plain and Cipher Text Buffer
	AES_STATE_AES_STATE2 = 0x4  // AES Plain and Cipher Text Buffer
	AES_STATE_AES_STATE3 = 0x8  // AES Plain and Cipher Text Buffer
	AES_STATE_AES_STATE4 = 0x10 // AES Plain and Cipher Text Buffer
	AES_STATE_AES_STATE5 = 0x20 // AES Plain and Cipher Text Buffer
	AES_STATE_AES_STATE6 = 0x40 // AES Plain and Cipher Text Buffer
	AES_STATE_AES_STATE7 = 0x80 // AES Plain and Cipher Text Buffer

	// AES_KEY: AES Encryption and Decryption Key Buffer Register
	AES_KEY_AES_KEY0 = 0x1  // AES Encryption/Decryption Key Buffer
	AES_KEY_AES_KEY1 = 0x2  // AES Encryption/Decryption Key Buffer
	AES_KEY_AES_KEY2 = 0x4  // AES Encryption/Decryption Key Buffer
	AES_KEY_AES_KEY3 = 0x8  // AES Encryption/Decryption Key Buffer
	AES_KEY_AES_KEY4 = 0x10 // AES Encryption/Decryption Key Buffer
	AES_KEY_AES_KEY5 = 0x20 // AES Encryption/Decryption Key Buffer
	AES_KEY_AES_KEY6 = 0x40 // AES Encryption/Decryption Key Buffer
	AES_KEY_AES_KEY7 = 0x80 // AES Encryption/Decryption Key Buffer

	// TRX_STATUS: Transceiver Status Register
	TRX_STATUS_CCA_DONE    = 0x80 // CCA Algorithm Status
	TRX_STATUS_CCA_STATUS  = 0x40 // CCA Status Result
	TRX_STATUS_TST_STATUS  = 0x20 // Test mode status
	TRX_STATUS_TRX_STATUS0 = 0x1  // Transceiver Main Status
	TRX_STATUS_TRX_STATUS1 = 0x2  // Transceiver Main Status
	TRX_STATUS_TRX_STATUS2 = 0x4  // Transceiver Main Status
	TRX_STATUS_TRX_STATUS3 = 0x8  // Transceiver Main Status
	TRX_STATUS_TRX_STATUS4 = 0x10 // Transceiver Main Status

	// TRX_STATE: Transceiver State Control Register
	TRX_STATE_TRAC_STATUS0 = 0x20 // Transaction Status
	TRX_STATE_TRAC_STATUS1 = 0x40 // Transaction Status
	TRX_STATE_TRAC_STATUS2 = 0x80 // Transaction Status
	TRX_STATE_TRX_CMD0     = 0x1  // State Control Command
	TRX_STATE_TRX_CMD1     = 0x2  // State Control Command
	TRX_STATE_TRX_CMD2     = 0x4  // State Control Command
	TRX_STATE_TRX_CMD3     = 0x8  // State Control Command
	TRX_STATE_TRX_CMD4     = 0x10 // State Control Command

	// TRX_CTRL_0: Reserved
	TRX_CTRL_0_Res7       = 0x80 // Reserved
	TRX_CTRL_0_PMU_EN     = 0x40 // Enable Phase Measurement Unit
	TRX_CTRL_0_PMU_START  = 0x20 // Start of Phase Measurement Unit
	TRX_CTRL_0_PMU_IF_INV = 0x10 // PMU IF Inverse
	TRX_CTRL_0_Res0       = 0x1  // Reserved
	TRX_CTRL_0_Res1       = 0x2  // Reserved
	TRX_CTRL_0_Res2       = 0x4  // Reserved
	TRX_CTRL_0_Res3       = 0x8  // Reserved

	// TRX_CTRL_1: Transceiver Control Register 1
	TRX_CTRL_1_PA_EXT_EN      = 0x80 // External PA support enable
	TRX_CTRL_1_IRQ_2_EXT_EN   = 0x40 // Connect Frame Start IRQ to TC1
	TRX_CTRL_1_TX_AUTO_CRC_ON = 0x20 // Enable Automatic CRC Calculation
	TRX_CTRL_1_PLL_TX_FLT     = 0x10 // Enable PLL TX filter
	TRX_CTRL_1_Res0           = 0x1  // Reserved
	TRX_CTRL_1_Res1           = 0x2  // Reserved
	TRX_CTRL_1_Res2           = 0x4  // Reserved
	TRX_CTRL_1_Res3           = 0x8  // Reserved

	// PHY_TX_PWR: Transceiver Transmit Power Control Register
	PHY_TX_PWR_Res0    = 0x10 // Reserved
	PHY_TX_PWR_Res1    = 0x20 // Reserved
	PHY_TX_PWR_Res2    = 0x40 // Reserved
	PHY_TX_PWR_Res3    = 0x80 // Reserved
	PHY_TX_PWR_TX_PWR0 = 0x1  // Transmit Power Setting
	PHY_TX_PWR_TX_PWR1 = 0x2  // Transmit Power Setting
	PHY_TX_PWR_TX_PWR2 = 0x4  // Transmit Power Setting
	PHY_TX_PWR_TX_PWR3 = 0x8  // Transmit Power Setting

	// PHY_RSSI: Receiver Signal Strength Indicator Register
	PHY_RSSI_RX_CRC_VALID = 0x80 // Received Frame CRC Status
	PHY_RSSI_RND_VALUE0   = 0x20 // Random Value
	PHY_RSSI_RND_VALUE1   = 0x40 // Random Value
	PHY_RSSI_RSSI0        = 0x1  // Receiver Signal Strength Indicator
	PHY_RSSI_RSSI1        = 0x2  // Receiver Signal Strength Indicator
	PHY_RSSI_RSSI2        = 0x4  // Receiver Signal Strength Indicator
	PHY_RSSI_RSSI3        = 0x8  // Receiver Signal Strength Indicator
	PHY_RSSI_RSSI4        = 0x10 // Receiver Signal Strength Indicator

	// PHY_ED_LEVEL: Transceiver Energy Detection Level Register
	PHY_ED_LEVEL_ED_LEVEL0 = 0x1  // Energy Detection Level
	PHY_ED_LEVEL_ED_LEVEL1 = 0x2  // Energy Detection Level
	PHY_ED_LEVEL_ED_LEVEL2 = 0x4  // Energy Detection Level
	PHY_ED_LEVEL_ED_LEVEL3 = 0x8  // Energy Detection Level
	PHY_ED_LEVEL_ED_LEVEL4 = 0x10 // Energy Detection Level
	PHY_ED_LEVEL_ED_LEVEL5 = 0x20 // Energy Detection Level
	PHY_ED_LEVEL_ED_LEVEL6 = 0x40 // Energy Detection Level
	PHY_ED_LEVEL_ED_LEVEL7 = 0x80 // Energy Detection Level

	// PHY_CC_CCA: Transceiver Clear Channel Assessment (CCA) Control Register
	PHY_CC_CCA_CCA_REQUEST = 0x80 // Manual CCA Measurement Request
	PHY_CC_CCA_CCA_MODE0   = 0x20 // Select CCA Measurement Mode
	PHY_CC_CCA_CCA_MODE1   = 0x40 // Select CCA Measurement Mode
	PHY_CC_CCA_CHANNEL0    = 0x1  // RX/TX Channel Selection
	PHY_CC_CCA_CHANNEL1    = 0x2  // RX/TX Channel Selection
	PHY_CC_CCA_CHANNEL2    = 0x4  // RX/TX Channel Selection
	PHY_CC_CCA_CHANNEL3    = 0x8  // RX/TX Channel Selection
	PHY_CC_CCA_CHANNEL4    = 0x10 // RX/TX Channel Selection

	// CCA_THRES: Transceiver CCA Threshold Setting Register
	CCA_THRES_CCA_CS_THRES0 = 0x10 // CS Threshold Level for CCA Measurement
	CCA_THRES_CCA_CS_THRES1 = 0x20 // CS Threshold Level for CCA Measurement
	CCA_THRES_CCA_CS_THRES2 = 0x40 // CS Threshold Level for CCA Measurement
	CCA_THRES_CCA_CS_THRES3 = 0x80 // CS Threshold Level for CCA Measurement
	CCA_THRES_CCA_ED_THRES0 = 0x1  // ED Threshold Level for CCA Measurement
	CCA_THRES_CCA_ED_THRES1 = 0x2  // ED Threshold Level for CCA Measurement
	CCA_THRES_CCA_ED_THRES2 = 0x4  // ED Threshold Level for CCA Measurement
	CCA_THRES_CCA_ED_THRES3 = 0x8  // ED Threshold Level for CCA Measurement

	// RX_CTRL: Transceiver Receive Control Register
	RX_CTRL_PDT_THRES0 = 0x1 // Receiver Sensitivity Control
	RX_CTRL_PDT_THRES1 = 0x2 // Receiver Sensitivity Control
	RX_CTRL_PDT_THRES2 = 0x4 // Receiver Sensitivity Control
	RX_CTRL_PDT_THRES3 = 0x8 // Receiver Sensitivity Control

	// SFD_VALUE: Start of Frame Delimiter Value Register
	SFD_VALUE_SFD_VALUE0 = 0x1  // Start of Frame Delimiter Value
	SFD_VALUE_SFD_VALUE1 = 0x2  // Start of Frame Delimiter Value
	SFD_VALUE_SFD_VALUE2 = 0x4  // Start of Frame Delimiter Value
	SFD_VALUE_SFD_VALUE3 = 0x8  // Start of Frame Delimiter Value
	SFD_VALUE_SFD_VALUE4 = 0x10 // Start of Frame Delimiter Value
	SFD_VALUE_SFD_VALUE5 = 0x20 // Start of Frame Delimiter Value
	SFD_VALUE_SFD_VALUE6 = 0x40 // Start of Frame Delimiter Value
	SFD_VALUE_SFD_VALUE7 = 0x80 // Start of Frame Delimiter Value

	// TRX_CTRL_2: Transceiver Control Register 2
	TRX_CTRL_2_RX_SAFE_MODE     = 0x80 // RX Safe Mode
	TRX_CTRL_2_Res0             = 0x4  // Reserved
	TRX_CTRL_2_Res1             = 0x8  // Reserved
	TRX_CTRL_2_Res2             = 0x10 // Reserved
	TRX_CTRL_2_Res3             = 0x20 // Reserved
	TRX_CTRL_2_Res4             = 0x40 // Reserved
	TRX_CTRL_2_OQPSK_DATA_RATE0 = 0x1  // Data Rate Selection
	TRX_CTRL_2_OQPSK_DATA_RATE1 = 0x2  // Data Rate Selection

	// ANT_DIV: Antenna Diversity Control Register
	ANT_DIV_ANT_SEL       = 0x80 // Antenna Diversity Antenna Status
	ANT_DIV_Res0          = 0x10 // Reserved
	ANT_DIV_Res1          = 0x20 // Reserved
	ANT_DIV_Res2          = 0x40 // Reserved
	ANT_DIV_ANT_DIV_EN    = 0x8  // Enable Antenna Diversity
	ANT_DIV_ANT_EXT_SW_EN = 0x4  // Enable External Antenna Switch Control
	ANT_DIV_ANT_CTRL0     = 0x1  // Static Antenna Diversity Switch Control
	ANT_DIV_ANT_CTRL1     = 0x2  // Static Antenna Diversity Switch Control

	// IRQ_MASK: Transceiver Interrupt Enable Register
	IRQ_MASK_AWAKE_EN       = 0x80 // Awake Interrupt Enable
	IRQ_MASK_TX_END_EN      = 0x40 // TX_END Interrupt Enable
	IRQ_MASK_AMI_EN         = 0x20 // Address Match Interrupt Enable
	IRQ_MASK_CCA_ED_DONE_EN = 0x10 // End of ED Measurement Interrupt Enable
	IRQ_MASK_RX_END_EN      = 0x8  // RX_END Interrupt Enable
	IRQ_MASK_RX_START_EN    = 0x4  // RX_START Interrupt Enable
	IRQ_MASK_PLL_UNLOCK_EN  = 0x2  // PLL Unlock Interrupt Enable
	IRQ_MASK_PLL_LOCK_EN    = 0x1  // PLL Lock Interrupt Enable

	// IRQ_STATUS: Transceiver Interrupt Status Register
	IRQ_STATUS_AWAKE       = 0x80 // Awake Interrupt Status
	IRQ_STATUS_TX_END      = 0x40 // TX_END Interrupt Status
	IRQ_STATUS_AMI         = 0x20 // Address Match Interrupt Status
	IRQ_STATUS_CCA_ED_DONE = 0x10 // End of ED Measurement Interrupt Status
	IRQ_STATUS_RX_END      = 0x8  // RX_END Interrupt Status
	IRQ_STATUS_RX_START    = 0x4  // RX_START Interrupt Status
	IRQ_STATUS_PLL_UNLOCK  = 0x2  // PLL Unlock Interrupt Status
	IRQ_STATUS_PLL_LOCK    = 0x1  // PLL Lock Interrupt Status

	// IRQ_MASK1: Transceiver Interrupt Enable Register 1
	IRQ_MASK1_Res0         = 0x20 // Reserved Bit
	IRQ_MASK1_Res1         = 0x40 // Reserved Bit
	IRQ_MASK1_Res2         = 0x80 // Reserved Bit
	IRQ_MASK1_MAF_3_AMI_EN = 0x10 // Address Match Interrupt enable Address filter 3
	IRQ_MASK1_MAF_2_AMI_EN = 0x8  // Address Match Interrupt enable Address filter 2
	IRQ_MASK1_MAF_1_AMI_EN = 0x4  // Address Match Interrupt enable Address filter 1
	IRQ_MASK1_MAF_0_AMI_EN = 0x2  // Address Match Interrupt enable Address filter 0
	IRQ_MASK1_TX_START_EN  = 0x1  // Transmit Start Interrupt enable

	// IRQ_STATUS1: Transceiver Interrupt Status Register 1
	IRQ_STATUS1_Res0      = 0x20 // Reserved Bit
	IRQ_STATUS1_Res1      = 0x40 // Reserved Bit
	IRQ_STATUS1_Res2      = 0x80 // Reserved Bit
	IRQ_STATUS1_MAF_3_AMI = 0x10 // Address Match Interrupt Status Address filter 3
	IRQ_STATUS1_MAF_2_AMI = 0x8  // Address Match Interrupt Status Address filter 2
	IRQ_STATUS1_MAF_1_AMI = 0x4  // Address Match Interrupt Status Address filter 1
	IRQ_STATUS1_MAF_0_AMI = 0x2  // Address Match Interrupt Status Address filter 0
	IRQ_STATUS1_TX_START  = 0x1  // Transmit Start Interrupt Status

	// VREG_CTRL: Voltage Regulator Control and Status Register
	VREG_CTRL_AVREG_EXT = 0x80 // Use External AVDD Regulator
	VREG_CTRL_AVDD_OK   = 0x40 // AVDD Supply Voltage Valid
	VREG_CTRL_DVREG_EXT = 0x8  // Use External DVDD Regulator
	VREG_CTRL_DVDD_OK   = 0x4  // DVDD Supply Voltage Valid

	// BATMON: Battery Monitor Control and Status Register
	BATMON_BAT_LOW     = 0x80 // Battery Monitor Interrupt Status
	BATMON_BAT_LOW_EN  = 0x40 // Battery Monitor Interrupt Enable
	BATMON_BATMON_OK   = 0x20 // Battery Monitor Status
	BATMON_BATMON_HR   = 0x10 // Battery Monitor Voltage Range
	BATMON_BATMON_VTH0 = 0x1  // Battery Monitor Threshold Voltage
	BATMON_BATMON_VTH1 = 0x2  // Battery Monitor Threshold Voltage
	BATMON_BATMON_VTH2 = 0x4  // Battery Monitor Threshold Voltage
	BATMON_BATMON_VTH3 = 0x8  // Battery Monitor Threshold Voltage

	// XOSC_CTRL: Crystal Oscillator Control Register
	XOSC_CTRL_XTAL_MODE0 = 0x10 // Crystal Oscillator Operating Mode
	XOSC_CTRL_XTAL_MODE1 = 0x20 // Crystal Oscillator Operating Mode
	XOSC_CTRL_XTAL_MODE2 = 0x40 // Crystal Oscillator Operating Mode
	XOSC_CTRL_XTAL_MODE3 = 0x80 // Crystal Oscillator Operating Mode
	XOSC_CTRL_XTAL_TRIM0 = 0x1  // Crystal Oscillator Load Capacitance Trimming
	XOSC_CTRL_XTAL_TRIM1 = 0x2  // Crystal Oscillator Load Capacitance Trimming
	XOSC_CTRL_XTAL_TRIM2 = 0x4  // Crystal Oscillator Load Capacitance Trimming
	XOSC_CTRL_XTAL_TRIM3 = 0x8  // Crystal Oscillator Load Capacitance Trimming

	// CC_CTRL_0: Channel Control Register 0
	CC_CTRL_0_CC_NUMBER0 = 0x1  // Channel Number
	CC_CTRL_0_CC_NUMBER1 = 0x2  // Channel Number
	CC_CTRL_0_CC_NUMBER2 = 0x4  // Channel Number
	CC_CTRL_0_CC_NUMBER3 = 0x8  // Channel Number
	CC_CTRL_0_CC_NUMBER4 = 0x10 // Channel Number
	CC_CTRL_0_CC_NUMBER5 = 0x20 // Channel Number
	CC_CTRL_0_CC_NUMBER6 = 0x40 // Channel Number
	CC_CTRL_0_CC_NUMBER7 = 0x80 // Channel Number

	// CC_CTRL_1: Channel Control Register 1
	CC_CTRL_1_CC_BAND0 = 0x1 // Channel Band
	CC_CTRL_1_CC_BAND1 = 0x2 // Channel Band
	CC_CTRL_1_CC_BAND2 = 0x4 // Channel Band
	CC_CTRL_1_CC_BAND3 = 0x8 // Channel Band

	// RX_SYN: Transceiver Receiver Sensitivity Control Register
	RX_SYN_RX_PDT_DIS    = 0x80 // Prevent Frame Reception
	RX_SYN_RX_OVERRIDE   = 0x40 // Receiver Override Function
	RX_SYN_Res0          = 0x10 // Reserved
	RX_SYN_Res1          = 0x20 // Reserved
	RX_SYN_RX_PDT_LEVEL0 = 0x1  // Reduce Receiver Sensitivity
	RX_SYN_RX_PDT_LEVEL1 = 0x2  // Reduce Receiver Sensitivity
	RX_SYN_RX_PDT_LEVEL2 = 0x4  // Reduce Receiver Sensitivity
	RX_SYN_RX_PDT_LEVEL3 = 0x8  // Reduce Receiver Sensitivity

	// TRX_RPC: Transceiver Reduced Power Consumption Control
	TRX_RPC_RX_RPC_CTRL0 = 0x40 // Smart Receiving Mode Timing
	TRX_RPC_RX_RPC_CTRL1 = 0x80 // Smart Receiving Mode Timing
	TRX_RPC_RX_RPC_EN    = 0x20 // Reciver Smart Receiving Mode Enable
	TRX_RPC_PDT_RPC_EN   = 0x10 // Smart Receiving Mode Reduced Sensitivity Enable
	TRX_RPC_PLL_RPC_EN   = 0x8  // PLL Smart Receiving Mode Enable
	TRX_RPC_Res0         = 0x4  // Reserved
	TRX_RPC_IPAN_RPC_EN  = 0x2  // Smart Receiving Mode IPAN Handling Enable
	TRX_RPC_XAH_RPC_EN   = 0x1  // Smart Receiving in Extended Operating Modes Enable

	// XAH_CTRL_1: Transceiver Acknowledgment Frame Control Register 1
	XAH_CTRL_1_AACK_FLTR_RES_FT = 0x20 // Filter Reserved Frames
	XAH_CTRL_1_AACK_UPLD_RES_FT = 0x10 // Process Reserved Frames
	XAH_CTRL_1_AACK_ACK_TIME    = 0x4  // Reduce Acknowledgment Time
	XAH_CTRL_1_AACK_PROM_MODE   = 0x2  // Enable Promiscuous Mode

	// FTN_CTRL: Transceiver Filter Tuning Control Register
	FTN_CTRL_FTN_START = 0x80 // Start Calibration Loop of Filter Tuning Network

	// PLL_CF: Transceiver Center Frequency Calibration Control Register
	PLL_CF_PLL_CF_START = 0x80 // Start Center Frequency Calibration

	// PLL_DCU: Transceiver Delay Cell Calibration Control Register
	PLL_DCU_PLL_DCU_START = 0x80 // Start Delay Cell Calibration

	// PART_NUM: Device Identification Register (Part Number)
	PART_NUM_PART_NUM0 = 0x1  // Part Number
	PART_NUM_PART_NUM1 = 0x2  // Part Number
	PART_NUM_PART_NUM2 = 0x4  // Part Number
	PART_NUM_PART_NUM3 = 0x8  // Part Number
	PART_NUM_PART_NUM4 = 0x10 // Part Number
	PART_NUM_PART_NUM5 = 0x20 // Part Number
	PART_NUM_PART_NUM6 = 0x40 // Part Number
	PART_NUM_PART_NUM7 = 0x80 // Part Number

	// VERSION_NUM: Device Identification Register (Version Number)
	VERSION_NUM_VERSION_NUM0 = 0x1  // Version Number
	VERSION_NUM_VERSION_NUM1 = 0x2  // Version Number
	VERSION_NUM_VERSION_NUM2 = 0x4  // Version Number
	VERSION_NUM_VERSION_NUM3 = 0x8  // Version Number
	VERSION_NUM_VERSION_NUM4 = 0x10 // Version Number
	VERSION_NUM_VERSION_NUM5 = 0x20 // Version Number
	VERSION_NUM_VERSION_NUM6 = 0x40 // Version Number
	VERSION_NUM_VERSION_NUM7 = 0x80 // Version Number

	// MAN_ID_0: Device Identification Register (Manufacture ID Low Byte)
	MAN_ID_0_MAN_ID_07 = 0x80 // Manufacturer ID (Low Byte)
	MAN_ID_0_MAN_ID_06 = 0x40 // Manufacturer ID (Low Byte)
	MAN_ID_0_MAN_ID_05 = 0x20 // Manufacturer ID (Low Byte)
	MAN_ID_0_MAN_ID_04 = 0x10 // Manufacturer ID (Low Byte)
	MAN_ID_0_MAN_ID_03 = 0x8  // Manufacturer ID (Low Byte)
	MAN_ID_0_MAN_ID_02 = 0x4  // Manufacturer ID (Low Byte)
	MAN_ID_0_MAN_ID_01 = 0x2  // Manufacturer ID (Low Byte)
	MAN_ID_0_MAN_ID_00 = 0x1  // Manufacturer ID (Low Byte)

	// MAN_ID_1: Device Identification Register (Manufacture ID High Byte)
	MAN_ID_1_MAN_ID_0 = 0x1  // Manufacturer ID (High Byte)
	MAN_ID_1_MAN_ID_1 = 0x2  // Manufacturer ID (High Byte)
	MAN_ID_1_MAN_ID_2 = 0x4  // Manufacturer ID (High Byte)
	MAN_ID_1_MAN_ID_3 = 0x8  // Manufacturer ID (High Byte)
	MAN_ID_1_MAN_ID_4 = 0x10 // Manufacturer ID (High Byte)
	MAN_ID_1_MAN_ID_5 = 0x20 // Manufacturer ID (High Byte)
	MAN_ID_1_MAN_ID_6 = 0x40 // Manufacturer ID (High Byte)
	MAN_ID_1_MAN_ID_7 = 0x80 // Manufacturer ID (High Byte)

	// SHORT_ADDR_0: Transceiver MAC Short Address Register (Low Byte)
	SHORT_ADDR_0_SHORT_ADDR_07 = 0x80 // MAC Short Address
	SHORT_ADDR_0_SHORT_ADDR_06 = 0x40 // MAC Short Address
	SHORT_ADDR_0_SHORT_ADDR_05 = 0x20 // MAC Short Address
	SHORT_ADDR_0_SHORT_ADDR_04 = 0x10 // MAC Short Address
	SHORT_ADDR_0_SHORT_ADDR_03 = 0x8  // MAC Short Address
	SHORT_ADDR_0_SHORT_ADDR_02 = 0x4  // MAC Short Address
	SHORT_ADDR_0_SHORT_ADDR_01 = 0x2  // MAC Short Address
	SHORT_ADDR_0_SHORT_ADDR_00 = 0x1  // MAC Short Address

	// SHORT_ADDR_1: Transceiver MAC Short Address Register (High Byte)
	SHORT_ADDR_1_SHORT_ADDR_0 = 0x1  // MAC Short Address
	SHORT_ADDR_1_SHORT_ADDR_1 = 0x2  // MAC Short Address
	SHORT_ADDR_1_SHORT_ADDR_2 = 0x4  // MAC Short Address
	SHORT_ADDR_1_SHORT_ADDR_3 = 0x8  // MAC Short Address
	SHORT_ADDR_1_SHORT_ADDR_4 = 0x10 // MAC Short Address
	SHORT_ADDR_1_SHORT_ADDR_5 = 0x20 // MAC Short Address
	SHORT_ADDR_1_SHORT_ADDR_6 = 0x40 // MAC Short Address
	SHORT_ADDR_1_SHORT_ADDR_7 = 0x80 // MAC Short Address

	// PAN_ID_0: Transceiver Personal Area Network ID Register (Low Byte)
	PAN_ID_0_PAN_ID_07 = 0x80 // MAC Personal Area Network ID
	PAN_ID_0_PAN_ID_06 = 0x40 // MAC Personal Area Network ID
	PAN_ID_0_PAN_ID_05 = 0x20 // MAC Personal Area Network ID
	PAN_ID_0_PAN_ID_04 = 0x10 // MAC Personal Area Network ID
	PAN_ID_0_PAN_ID_03 = 0x8  // MAC Personal Area Network ID
	PAN_ID_0_PAN_ID_02 = 0x4  // MAC Personal Area Network ID
	PAN_ID_0_PAN_ID_01 = 0x2  // MAC Personal Area Network ID
	PAN_ID_0_PAN_ID_00 = 0x1  // MAC Personal Area Network ID

	// PAN_ID_1: Transceiver Personal Area Network ID Register (High Byte)
	PAN_ID_1_PAN_ID_0 = 0x1  // MAC Personal Area Network ID
	PAN_ID_1_PAN_ID_1 = 0x2  // MAC Personal Area Network ID
	PAN_ID_1_PAN_ID_2 = 0x4  // MAC Personal Area Network ID
	PAN_ID_1_PAN_ID_3 = 0x8  // MAC Personal Area Network ID
	PAN_ID_1_PAN_ID_4 = 0x10 // MAC Personal Area Network ID
	PAN_ID_1_PAN_ID_5 = 0x20 // MAC Personal Area Network ID
	PAN_ID_1_PAN_ID_6 = 0x40 // MAC Personal Area Network ID
	PAN_ID_1_PAN_ID_7 = 0x80 // MAC Personal Area Network ID

	// IEEE_ADDR_0: Transceiver MAC IEEE Address Register 0
	IEEE_ADDR_0_IEEE_ADDR_07 = 0x80 // MAC IEEE Address
	IEEE_ADDR_0_IEEE_ADDR_06 = 0x40 // MAC IEEE Address
	IEEE_ADDR_0_IEEE_ADDR_05 = 0x20 // MAC IEEE Address
	IEEE_ADDR_0_IEEE_ADDR_04 = 0x10 // MAC IEEE Address
	IEEE_ADDR_0_IEEE_ADDR_03 = 0x8  // MAC IEEE Address
	IEEE_ADDR_0_IEEE_ADDR_02 = 0x4  // MAC IEEE Address
	IEEE_ADDR_0_IEEE_ADDR_01 = 0x2  // MAC IEEE Address
	IEEE_ADDR_0_IEEE_ADDR_00 = 0x1  // MAC IEEE Address

	// IEEE_ADDR_1: Transceiver MAC IEEE Address Register 1
	IEEE_ADDR_1_IEEE_ADDR_0 = 0x1  // MAC IEEE Address
	IEEE_ADDR_1_IEEE_ADDR_1 = 0x2  // MAC IEEE Address
	IEEE_ADDR_1_IEEE_ADDR_2 = 0x4  // MAC IEEE Address
	IEEE_ADDR_1_IEEE_ADDR_3 = 0x8  // MAC IEEE Address
	IEEE_ADDR_1_IEEE_ADDR_4 = 0x10 // MAC IEEE Address
	IEEE_ADDR_1_IEEE_ADDR_5 = 0x20 // MAC IEEE Address
	IEEE_ADDR_1_IEEE_ADDR_6 = 0x40 // MAC IEEE Address
	IEEE_ADDR_1_IEEE_ADDR_7 = 0x80 // MAC IEEE Address

	// IEEE_ADDR_2: Transceiver MAC IEEE Address Register 2
	IEEE_ADDR_2_IEEE_ADDR_0 = 0x1  // MAC IEEE Address
	IEEE_ADDR_2_IEEE_ADDR_1 = 0x2  // MAC IEEE Address
	IEEE_ADDR_2_IEEE_ADDR_2 = 0x4  // MAC IEEE Address
	IEEE_ADDR_2_IEEE_ADDR_3 = 0x8  // MAC IEEE Address
	IEEE_ADDR_2_IEEE_ADDR_4 = 0x10 // MAC IEEE Address
	IEEE_ADDR_2_IEEE_ADDR_5 = 0x20 // MAC IEEE Address
	IEEE_ADDR_2_IEEE_ADDR_6 = 0x40 // MAC IEEE Address
	IEEE_ADDR_2_IEEE_ADDR_7 = 0x80 // MAC IEEE Address

	// IEEE_ADDR_3: Transceiver MAC IEEE Address Register 3
	IEEE_ADDR_3_IEEE_ADDR_0 = 0x1  // MAC IEEE Address
	IEEE_ADDR_3_IEEE_ADDR_1 = 0x2  // MAC IEEE Address
	IEEE_ADDR_3_IEEE_ADDR_2 = 0x4  // MAC IEEE Address
	IEEE_ADDR_3_IEEE_ADDR_3 = 0x8  // MAC IEEE Address
	IEEE_ADDR_3_IEEE_ADDR_4 = 0x10 // MAC IEEE Address
	IEEE_ADDR_3_IEEE_ADDR_5 = 0x20 // MAC IEEE Address
	IEEE_ADDR_3_IEEE_ADDR_6 = 0x40 // MAC IEEE Address
	IEEE_ADDR_3_IEEE_ADDR_7 = 0x80 // MAC IEEE Address

	// IEEE_ADDR_4: Transceiver MAC IEEE Address Register 4
	IEEE_ADDR_4_IEEE_ADDR_0 = 0x1  // MAC IEEE Address
	IEEE_ADDR_4_IEEE_ADDR_1 = 0x2  // MAC IEEE Address
	IEEE_ADDR_4_IEEE_ADDR_2 = 0x4  // MAC IEEE Address
	IEEE_ADDR_4_IEEE_ADDR_3 = 0x8  // MAC IEEE Address
	IEEE_ADDR_4_IEEE_ADDR_4 = 0x10 // MAC IEEE Address
	IEEE_ADDR_4_IEEE_ADDR_5 = 0x20 // MAC IEEE Address
	IEEE_ADDR_4_IEEE_ADDR_6 = 0x40 // MAC IEEE Address
	IEEE_ADDR_4_IEEE_ADDR_7 = 0x80 // MAC IEEE Address

	// IEEE_ADDR_5: Transceiver MAC IEEE Address Register 5
	IEEE_ADDR_5_IEEE_ADDR_0 = 0x1  // MAC IEEE Address
	IEEE_ADDR_5_IEEE_ADDR_1 = 0x2  // MAC IEEE Address
	IEEE_ADDR_5_IEEE_ADDR_2 = 0x4  // MAC IEEE Address
	IEEE_ADDR_5_IEEE_ADDR_3 = 0x8  // MAC IEEE Address
	IEEE_ADDR_5_IEEE_ADDR_4 = 0x10 // MAC IEEE Address
	IEEE_ADDR_5_IEEE_ADDR_5 = 0x20 // MAC IEEE Address
	IEEE_ADDR_5_IEEE_ADDR_6 = 0x40 // MAC IEEE Address
	IEEE_ADDR_5_IEEE_ADDR_7 = 0x80 // MAC IEEE Address

	// IEEE_ADDR_6: Transceiver MAC IEEE Address Register 6
	IEEE_ADDR_6_IEEE_ADDR_0 = 0x1  // MAC IEEE Address
	IEEE_ADDR_6_IEEE_ADDR_1 = 0x2  // MAC IEEE Address
	IEEE_ADDR_6_IEEE_ADDR_2 = 0x4  // MAC IEEE Address
	IEEE_ADDR_6_IEEE_ADDR_3 = 0x8  // MAC IEEE Address
	IEEE_ADDR_6_IEEE_ADDR_4 = 0x10 // MAC IEEE Address
	IEEE_ADDR_6_IEEE_ADDR_5 = 0x20 // MAC IEEE Address
	IEEE_ADDR_6_IEEE_ADDR_6 = 0x40 // MAC IEEE Address
	IEEE_ADDR_6_IEEE_ADDR_7 = 0x80 // MAC IEEE Address

	// IEEE_ADDR_7: Transceiver MAC IEEE Address Register 7
	IEEE_ADDR_7_IEEE_ADDR_0 = 0x1  // MAC IEEE Address
	IEEE_ADDR_7_IEEE_ADDR_1 = 0x2  // MAC IEEE Address
	IEEE_ADDR_7_IEEE_ADDR_2 = 0x4  // MAC IEEE Address
	IEEE_ADDR_7_IEEE_ADDR_3 = 0x8  // MAC IEEE Address
	IEEE_ADDR_7_IEEE_ADDR_4 = 0x10 // MAC IEEE Address
	IEEE_ADDR_7_IEEE_ADDR_5 = 0x20 // MAC IEEE Address
	IEEE_ADDR_7_IEEE_ADDR_6 = 0x40 // MAC IEEE Address
	IEEE_ADDR_7_IEEE_ADDR_7 = 0x80 // MAC IEEE Address

	// XAH_CTRL_0: Transceiver Extended Operating Mode Control Register
	XAH_CTRL_0_MAX_FRAME_RETRIES0 = 0x10 // Maximum Number of Frame Re-transmission Attempts
	XAH_CTRL_0_MAX_FRAME_RETRIES1 = 0x20 // Maximum Number of Frame Re-transmission Attempts
	XAH_CTRL_0_MAX_FRAME_RETRIES2 = 0x40 // Maximum Number of Frame Re-transmission Attempts
	XAH_CTRL_0_MAX_FRAME_RETRIES3 = 0x80 // Maximum Number of Frame Re-transmission Attempts
	XAH_CTRL_0_MAX_CSMA_RETRIES0  = 0x2  // Maximum Number of CSMA-CA Procedure Repetition Attempts
	XAH_CTRL_0_MAX_CSMA_RETRIES1  = 0x4  // Maximum Number of CSMA-CA Procedure Repetition Attempts
	XAH_CTRL_0_MAX_CSMA_RETRIES2  = 0x8  // Maximum Number of CSMA-CA Procedure Repetition Attempts
	XAH_CTRL_0_SLOTTED_OPERATION  = 0x1  // Set Slotted Acknowledgment

	// CSMA_SEED_0: Transceiver CSMA-CA Random Number Generator Seed Register
	CSMA_SEED_0_CSMA_SEED_07 = 0x80 // Seed Value for CSMA Random Number Generator
	CSMA_SEED_0_CSMA_SEED_06 = 0x40 // Seed Value for CSMA Random Number Generator
	CSMA_SEED_0_CSMA_SEED_05 = 0x20 // Seed Value for CSMA Random Number Generator
	CSMA_SEED_0_CSMA_SEED_04 = 0x10 // Seed Value for CSMA Random Number Generator
	CSMA_SEED_0_CSMA_SEED_03 = 0x8  // Seed Value for CSMA Random Number Generator
	CSMA_SEED_0_CSMA_SEED_02 = 0x4  // Seed Value for CSMA Random Number Generator
	CSMA_SEED_0_CSMA_SEED_01 = 0x2  // Seed Value for CSMA Random Number Generator
	CSMA_SEED_0_CSMA_SEED_00 = 0x1  // Seed Value for CSMA Random Number Generator

	// CSMA_SEED_1: Transceiver Acknowledgment Frame Control Register 2
	CSMA_SEED_1_AACK_FVN_MODE0  = 0x40 // Acknowledgment Frame Filter Mode
	CSMA_SEED_1_AACK_FVN_MODE1  = 0x80 // Acknowledgment Frame Filter Mode
	CSMA_SEED_1_AACK_SET_PD     = 0x20 // Set Frame Pending Sub-field
	CSMA_SEED_1_AACK_DIS_ACK    = 0x10 // Disable Acknowledgment Frame Transmission
	CSMA_SEED_1_AACK_I_AM_COORD = 0x8  // Set Personal Area Network Coordinator
	CSMA_SEED_1_CSMA_SEED_10    = 0x1  // Seed Value for CSMA Random Number Generator
	CSMA_SEED_1_CSMA_SEED_11    = 0x2  // Seed Value for CSMA Random Number Generator
	CSMA_SEED_1_CSMA_SEED_12    = 0x4  // Seed Value for CSMA Random Number Generator

	// CSMA_BE: Transceiver CSMA-CA Back-off Exponent Control Register
	CSMA_BE_MAX_BE0 = 0x10 // Maximum Back-off Exponent
	CSMA_BE_MAX_BE1 = 0x20 // Maximum Back-off Exponent
	CSMA_BE_MAX_BE2 = 0x40 // Maximum Back-off Exponent
	CSMA_BE_MAX_BE3 = 0x80 // Maximum Back-off Exponent
	CSMA_BE_MIN_BE0 = 0x1  // Minimum Back-off Exponent
	CSMA_BE_MIN_BE1 = 0x2  // Minimum Back-off Exponent
	CSMA_BE_MIN_BE2 = 0x4  // Minimum Back-off Exponent
	CSMA_BE_MIN_BE3 = 0x8  // Minimum Back-off Exponent

	// TST_CTRL_DIGI: Transceiver Digital Test Control Register
	TST_CTRL_DIGI_TST_CTRL_DIG0 = 0x1 // Digital Test Controller Register
	TST_CTRL_DIGI_TST_CTRL_DIG1 = 0x2 // Digital Test Controller Register
	TST_CTRL_DIGI_TST_CTRL_DIG2 = 0x4 // Digital Test Controller Register
	TST_CTRL_DIGI_TST_CTRL_DIG3 = 0x8 // Digital Test Controller Register

	// TST_RX_LENGTH: Transceiver Received Frame Length Register
	TST_RX_LENGTH_RX_LENGTH0 = 0x1  // Received Frame Length
	TST_RX_LENGTH_RX_LENGTH1 = 0x2  // Received Frame Length
	TST_RX_LENGTH_RX_LENGTH2 = 0x4  // Received Frame Length
	TST_RX_LENGTH_RX_LENGTH3 = 0x8  // Received Frame Length
	TST_RX_LENGTH_RX_LENGTH4 = 0x10 // Received Frame Length
	TST_RX_LENGTH_RX_LENGTH5 = 0x20 // Received Frame Length
	TST_RX_LENGTH_RX_LENGTH6 = 0x40 // Received Frame Length
	TST_RX_LENGTH_RX_LENGTH7 = 0x80 // Received Frame Length
)

// Bitfields for SYMCNT: MAC Symbol Counter
const (
	// SCTSTRHH: Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH0 = 0x1  // Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH1 = 0x2  // Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH2 = 0x4  // Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH3 = 0x8  // Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH4 = 0x10 // Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH5 = 0x20 // Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH6 = 0x40 // Symbol Counter Transmit Frame Timestamp Register HH-Byte
	SCTSTRHH_SCTSTRHH7 = 0x80 // Symbol Counter Transmit Frame Timestamp Register HH-Byte

	// SCTSTRHL: Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL0 = 0x1  // Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL1 = 0x2  // Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL2 = 0x4  // Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL3 = 0x8  // Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL4 = 0x10 // Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL5 = 0x20 // Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL6 = 0x40 // Symbol Counter Transmit Frame Timestamp Register HL-Byte
	SCTSTRHL_SCTSTRHL7 = 0x80 // Symbol Counter Transmit Frame Timestamp Register HL-Byte

	// SCTSTRLH: Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH0 = 0x1  // Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH1 = 0x2  // Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH2 = 0x4  // Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH3 = 0x8  // Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH4 = 0x10 // Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH5 = 0x20 // Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH6 = 0x40 // Symbol Counter Transmit Frame Timestamp Register LH-Byte
	SCTSTRLH_SCTSTRLH7 = 0x80 // Symbol Counter Transmit Frame Timestamp Register LH-Byte

	// SCTSTRLL: Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL0 = 0x1  // Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL1 = 0x2  // Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL2 = 0x4  // Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL3 = 0x8  // Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL4 = 0x10 // Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL5 = 0x20 // Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL6 = 0x40 // Symbol Counter Transmit Frame Timestamp Register LL-Byte
	SCTSTRLL_SCTSTRLL7 = 0x80 // Symbol Counter Transmit Frame Timestamp Register LL-Byte

	// SCOCR1HH: Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH0 = 0x1  // Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH1 = 0x2  // Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH2 = 0x4  // Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH3 = 0x8  // Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH4 = 0x10 // Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH5 = 0x20 // Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH6 = 0x40 // Symbol Counter Output Compare Register 1 HH-Byte
	SCOCR1HH_SCOCR1HH7 = 0x80 // Symbol Counter Output Compare Register 1 HH-Byte

	// SCOCR1HL: Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL0 = 0x1  // Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL1 = 0x2  // Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL2 = 0x4  // Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL3 = 0x8  // Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL4 = 0x10 // Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL5 = 0x20 // Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL6 = 0x40 // Symbol Counter Output Compare Register 1 HL-Byte
	SCOCR1HL_SCOCR1HL7 = 0x80 // Symbol Counter Output Compare Register 1 HL-Byte

	// SCOCR1LH: Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH0 = 0x1  // Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH1 = 0x2  // Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH2 = 0x4  // Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH3 = 0x8  // Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH4 = 0x10 // Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH5 = 0x20 // Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH6 = 0x40 // Symbol Counter Output Compare Register 1 LH-Byte
	SCOCR1LH_SCOCR1LH7 = 0x80 // Symbol Counter Output Compare Register 1 LH-Byte

	// SCOCR1LL: Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL0 = 0x1  // Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL1 = 0x2  // Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL2 = 0x4  // Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL3 = 0x8  // Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL4 = 0x10 // Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL5 = 0x20 // Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL6 = 0x40 // Symbol Counter Output Compare Register 1 LL-Byte
	SCOCR1LL_SCOCR1LL7 = 0x80 // Symbol Counter Output Compare Register 1 LL-Byte

	// SCOCR2HH: Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH0 = 0x1  // Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH1 = 0x2  // Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH2 = 0x4  // Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH3 = 0x8  // Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH4 = 0x10 // Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH5 = 0x20 // Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH6 = 0x40 // Symbol Counter Output Compare Register 2 HH-Byte
	SCOCR2HH_SCOCR2HH7 = 0x80 // Symbol Counter Output Compare Register 2 HH-Byte

	// SCOCR2HL: Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL0 = 0x1  // Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL1 = 0x2  // Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL2 = 0x4  // Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL3 = 0x8  // Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL4 = 0x10 // Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL5 = 0x20 // Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL6 = 0x40 // Symbol Counter Output Compare Register 2 HL-Byte
	SCOCR2HL_SCOCR2HL7 = 0x80 // Symbol Counter Output Compare Register 2 HL-Byte

	// SCOCR2LH: Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH0 = 0x1  // Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH1 = 0x2  // Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH2 = 0x4  // Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH3 = 0x8  // Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH4 = 0x10 // Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH5 = 0x20 // Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH6 = 0x40 // Symbol Counter Output Compare Register 2 LH-Byte
	SCOCR2LH_SCOCR2LH7 = 0x80 // Symbol Counter Output Compare Register 2 LH-Byte

	// SCOCR2LL: Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL0 = 0x1  // Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL1 = 0x2  // Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL2 = 0x4  // Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL3 = 0x8  // Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL4 = 0x10 // Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL5 = 0x20 // Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL6 = 0x40 // Symbol Counter Output Compare Register 2 LL-Byte
	SCOCR2LL_SCOCR2LL7 = 0x80 // Symbol Counter Output Compare Register 2 LL-Byte

	// SCOCR3HH: Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH0 = 0x1  // Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH1 = 0x2  // Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH2 = 0x4  // Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH3 = 0x8  // Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH4 = 0x10 // Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH5 = 0x20 // Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH6 = 0x40 // Symbol Counter Output Compare Register 3 HH-Byte
	SCOCR3HH_SCOCR3HH7 = 0x80 // Symbol Counter Output Compare Register 3 HH-Byte

	// SCOCR3HL: Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL0 = 0x1  // Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL1 = 0x2  // Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL2 = 0x4  // Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL3 = 0x8  // Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL4 = 0x10 // Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL5 = 0x20 // Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL6 = 0x40 // Symbol Counter Output Compare Register 3 HL-Byte
	SCOCR3HL_SCOCR3HL7 = 0x80 // Symbol Counter Output Compare Register 3 HL-Byte

	// SCOCR3LH: Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH0 = 0x1  // Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH1 = 0x2  // Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH2 = 0x4  // Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH3 = 0x8  // Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH4 = 0x10 // Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH5 = 0x20 // Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH6 = 0x40 // Symbol Counter Output Compare Register 3 LH-Byte
	SCOCR3LH_SCOCR3LH7 = 0x80 // Symbol Counter Output Compare Register 3 LH-Byte

	// SCOCR3LL: Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL0 = 0x1  // Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL1 = 0x2  // Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL2 = 0x4  // Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL3 = 0x8  // Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL4 = 0x10 // Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL5 = 0x20 // Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL6 = 0x40 // Symbol Counter Output Compare Register 3 LL-Byte
	SCOCR3LL_SCOCR3LL7 = 0x80 // Symbol Counter Output Compare Register 3 LL-Byte

	// SCTSRHH: Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH0 = 0x1  // Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH1 = 0x2  // Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH2 = 0x4  // Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH3 = 0x8  // Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH4 = 0x10 // Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH5 = 0x20 // Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH6 = 0x40 // Symbol Counter Frame Timestamp Register HH-Byte
	SCTSRHH_SCTSRHH7 = 0x80 // Symbol Counter Frame Timestamp Register HH-Byte

	// SCTSRHL: Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL0 = 0x1  // Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL1 = 0x2  // Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL2 = 0x4  // Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL3 = 0x8  // Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL4 = 0x10 // Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL5 = 0x20 // Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL6 = 0x40 // Symbol Counter Frame Timestamp Register HL-Byte
	SCTSRHL_SCTSRHL7 = 0x80 // Symbol Counter Frame Timestamp Register HL-Byte

	// SCTSRLH: Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH0 = 0x1  // Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH1 = 0x2  // Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH2 = 0x4  // Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH3 = 0x8  // Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH4 = 0x10 // Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH5 = 0x20 // Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH6 = 0x40 // Symbol Counter Frame Timestamp Register LH-Byte
	SCTSRLH_SCTSRLH7 = 0x80 // Symbol Counter Frame Timestamp Register LH-Byte

	// SCTSRLL: Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL0 = 0x1  // Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL1 = 0x2  // Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL2 = 0x4  // Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL3 = 0x8  // Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL4 = 0x10 // Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL5 = 0x20 // Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL6 = 0x40 // Symbol Counter Frame Timestamp Register LL-Byte
	SCTSRLL_SCTSRLL7 = 0x80 // Symbol Counter Frame Timestamp Register LL-Byte

	// SCBTSRHH: Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH0 = 0x1  // Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH1 = 0x2  // Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH2 = 0x4  // Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH3 = 0x8  // Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH4 = 0x10 // Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH5 = 0x20 // Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH6 = 0x40 // Symbol Counter Beacon Timestamp Register HH-Byte
	SCBTSRHH_SCBTSRHH7 = 0x80 // Symbol Counter Beacon Timestamp Register HH-Byte

	// SCBTSRHL: Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL0 = 0x1  // Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL1 = 0x2  // Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL2 = 0x4  // Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL3 = 0x8  // Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL4 = 0x10 // Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL5 = 0x20 // Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL6 = 0x40 // Symbol Counter Beacon Timestamp Register HL-Byte
	SCBTSRHL_SCBTSRHL7 = 0x80 // Symbol Counter Beacon Timestamp Register HL-Byte

	// SCBTSRLH: Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH0 = 0x1  // Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH1 = 0x2  // Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH2 = 0x4  // Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH3 = 0x8  // Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH4 = 0x10 // Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH5 = 0x20 // Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH6 = 0x40 // Symbol Counter Beacon Timestamp Register LH-Byte
	SCBTSRLH_SCBTSRLH7 = 0x80 // Symbol Counter Beacon Timestamp Register LH-Byte

	// SCBTSRLL: Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL0 = 0x1  // Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL1 = 0x2  // Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL2 = 0x4  // Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL3 = 0x8  // Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL4 = 0x10 // Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL5 = 0x20 // Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL6 = 0x40 // Symbol Counter Beacon Timestamp Register LL-Byte
	SCBTSRLL_SCBTSRLL7 = 0x80 // Symbol Counter Beacon Timestamp Register LL-Byte

	// SCCNTHH: Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH0 = 0x1  // Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH1 = 0x2  // Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH2 = 0x4  // Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH3 = 0x8  // Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH4 = 0x10 // Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH5 = 0x20 // Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH6 = 0x40 // Symbol Counter Register HH-Byte
	SCCNTHH_SCCNTHH7 = 0x80 // Symbol Counter Register HH-Byte

	// SCCNTHL: Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL0 = 0x1  // Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL1 = 0x2  // Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL2 = 0x4  // Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL3 = 0x8  // Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL4 = 0x10 // Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL5 = 0x20 // Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL6 = 0x40 // Symbol Counter Register HL-Byte
	SCCNTHL_SCCNTHL7 = 0x80 // Symbol Counter Register HL-Byte

	// SCCNTLH: Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH0 = 0x1  // Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH1 = 0x2  // Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH2 = 0x4  // Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH3 = 0x8  // Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH4 = 0x10 // Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH5 = 0x20 // Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH6 = 0x40 // Symbol Counter Register LH-Byte
	SCCNTLH_SCCNTLH7 = 0x80 // Symbol Counter Register LH-Byte

	// SCCNTLL: Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL0 = 0x1  // Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL1 = 0x2  // Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL2 = 0x4  // Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL3 = 0x8  // Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL4 = 0x10 // Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL5 = 0x20 // Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL6 = 0x40 // Symbol Counter Register LL-Byte
	SCCNTLL_SCCNTLL7 = 0x80 // Symbol Counter Register LL-Byte

	// SCIRQS: Symbol Counter Interrupt Status Register
	SCIRQS_Res0    = 0x20 // Reserved Bit
	SCIRQS_Res1    = 0x40 // Reserved Bit
	SCIRQS_Res2    = 0x80 // Reserved Bit
	SCIRQS_IRQSBO  = 0x10 // Backoff Slot Counter IRQ
	SCIRQS_IRQSOF  = 0x8  // Symbol Counter Overflow IRQ
	SCIRQS_IRQSCP0 = 0x1  // Compare Unit 3 Compare Match IRQ
	SCIRQS_IRQSCP1 = 0x2  // Compare Unit 3 Compare Match IRQ
	SCIRQS_IRQSCP2 = 0x4  // Compare Unit 3 Compare Match IRQ

	// SCIRQM: Symbol Counter Interrupt Mask Register
	SCIRQM_Res0    = 0x20 // Reserved Bit
	SCIRQM_Res1    = 0x40 // Reserved Bit
	SCIRQM_Res2    = 0x80 // Reserved Bit
	SCIRQM_IRQMBO  = 0x10 // Backoff Slot Counter IRQ enable
	SCIRQM_IRQMOF  = 0x8  // Symbol Counter Overflow IRQ enable
	SCIRQM_IRQMCP0 = 0x1  // Symbol Counter Compare Match 3 IRQ enable
	SCIRQM_IRQMCP1 = 0x2  // Symbol Counter Compare Match 3 IRQ enable
	SCIRQM_IRQMCP2 = 0x4  // Symbol Counter Compare Match 3 IRQ enable

	// SCSR: Symbol Counter Status Register
	SCSR_Res0  = 0x2  // Reserved Bit
	SCSR_Res1  = 0x4  // Reserved Bit
	SCSR_Res2  = 0x8  // Reserved Bit
	SCSR_Res3  = 0x10 // Reserved Bit
	SCSR_Res4  = 0x20 // Reserved Bit
	SCSR_Res5  = 0x40 // Reserved Bit
	SCSR_Res6  = 0x80 // Reserved Bit
	SCSR_SCBSY = 0x1  // Symbol Counter busy

	// SCCR1: Symbol Counter Control Register 1
	SCCR1_Res0     = 0x40 // Reserved Bit
	SCCR1_Res1     = 0x80 // Reserved Bit
	SCCR1_SCBTSM   = 0x20 // Symbol Counter Beacon Timestamp Mask Register
	SCCR1_SCCKDIV0 = 0x4  // Clock divider for synchronous clock source (16MHz Transceiver Clock)
	SCCR1_SCCKDIV1 = 0x8  // Clock divider for synchronous clock source (16MHz Transceiver Clock)
	SCCR1_SCCKDIV2 = 0x10 // Clock divider for synchronous clock source (16MHz Transceiver Clock)
	SCCR1_SCEECLK  = 0x2  // Enable External Clock Source on PG2
	SCCR1_SCENBO   = 0x1  // Backoff Slot Counter enable

	// SCCR0: Symbol Counter Control Register 0
	SCCR0_SCRES   = 0x80 // Symbol Counter Synchronization
	SCCR0_SCMBTS  = 0x40 // Manual Beacon Timestamp
	SCCR0_SCEN    = 0x20 // Symbol Counter enable
	SCCR0_SCCKSEL = 0x10 // Symbol Counter Clock Source select
	SCCR0_SCTSE   = 0x8  // Symbol Counter Automatic Timestamping enable
	SCCR0_SCCMP0  = 0x1  // Symbol Counter Compare Unit 3 Mode select
	SCCR0_SCCMP1  = 0x2  // Symbol Counter Compare Unit 3 Mode select
	SCCR0_SCCMP2  = 0x4  // Symbol Counter Compare Unit 3 Mode select

	// SCCSR: Symbol Counter Compare Source Register
	SCCSR_Res0   = 0x40 // Reserved Bit
	SCCSR_Res1   = 0x80 // Reserved Bit
	SCCSR_SCCS30 = 0x10 // Symbol Counter Compare Source select register for Compare Unit 3
	SCCSR_SCCS31 = 0x20 // Symbol Counter Compare Source select register for Compare Unit 3
	SCCSR_SCCS20 = 0x4  // Symbol Counter Compare Source select register for Compare Unit 2
	SCCSR_SCCS21 = 0x8  // Symbol Counter Compare Source select register for Compare Unit 2
	SCCSR_SCCS10 = 0x1  // Symbol Counter Compare Source select register for Compare Units
	SCCSR_SCCS11 = 0x2  // Symbol Counter Compare Source select register for Compare Units

	// SCRSTRHH: Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH0 = 0x1  // Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH1 = 0x2  // Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH2 = 0x4  // Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH3 = 0x8  // Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH4 = 0x10 // Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH5 = 0x20 // Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH6 = 0x40 // Symbol Counter Received Frame Timestamp Register HH-Byte
	SCRSTRHH_SCRSTRHH7 = 0x80 // Symbol Counter Received Frame Timestamp Register HH-Byte

	// SCRSTRHL: Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL0 = 0x1  // Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL1 = 0x2  // Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL2 = 0x4  // Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL3 = 0x8  // Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL4 = 0x10 // Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL5 = 0x20 // Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL6 = 0x40 // Symbol Counter Received Frame Timestamp Register HL-Byte
	SCRSTRHL_SCRSTRHL7 = 0x80 // Symbol Counter Received Frame Timestamp Register HL-Byte

	// SCRSTRLH: Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH0 = 0x1  // Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH1 = 0x2  // Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH2 = 0x4  // Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH3 = 0x8  // Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH4 = 0x10 // Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH5 = 0x20 // Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH6 = 0x40 // Symbol Counter Received Frame Timestamp Register LH-Byte
	SCRSTRLH_SCRSTRLH7 = 0x80 // Symbol Counter Received Frame Timestamp Register LH-Byte

	// SCRSTRLL: Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL0 = 0x1  // Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL1 = 0x2  // Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL2 = 0x4  // Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL3 = 0x8  // Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL4 = 0x10 // Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL5 = 0x20 // Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL6 = 0x40 // Symbol Counter Received Frame Timestamp Register LL-Byte
	SCRSTRLL_SCRSTRLL7 = 0x80 // Symbol Counter Received Frame Timestamp Register LL-Byte
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_Res0  = 0x40 // Reserved
	EECR_Res1  = 0x80 // Reserved
	EECR_EEPM0 = 0x10 // EEPROM Programming Mode
	EECR_EEPM1 = 0x20 // EEPROM Programming Mode
	EECR_EERIE = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE = 0x4  // EEPROM Master Write Enable
	EECR_EEPE  = 0x2  // EEPROM Programming Enable
	EECR_EERE  = 0x1  // EEPROM Read Enable
)

// Bitfields for JTAG: JTAG Interface
const (
	// OCDR: On-Chip Debug Register
	OCDR_OCDR0 = 0x1  // On-Chip Debug Register Data
	OCDR_OCDR1 = 0x2  // On-Chip Debug Register Data
	OCDR_OCDR2 = 0x4  // On-Chip Debug Register Data
	OCDR_OCDR3 = 0x8  // On-Chip Debug Register Data
	OCDR_OCDR4 = 0x10 // On-Chip Debug Register Data
	OCDR_OCDR5 = 0x20 // On-Chip Debug Register Data
	OCDR_OCDR6 = 0x40 // On-Chip Debug Register Data
	OCDR_OCDR7 = 0x80 // On-Chip Debug Register Data
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register A
	EICRA_ISC30 = 0x40 // External Interrupt 3 Sense Control Bit
	EICRA_ISC31 = 0x80 // External Interrupt 3 Sense Control Bit
	EICRA_ISC20 = 0x10 // External Interrupt 2 Sense Control Bit
	EICRA_ISC21 = 0x20 // External Interrupt 2 Sense Control Bit
	EICRA_ISC10 = 0x4  // External Interrupt 1 Sense Control Bit
	EICRA_ISC11 = 0x8  // External Interrupt 1 Sense Control Bit
	EICRA_ISC00 = 0x1  // External Interrupt 0 Sense Control Bit
	EICRA_ISC01 = 0x2  // External Interrupt 0 Sense Control Bit

	// EICRB: External Interrupt Control Register B
	EICRB_ISC70 = 0x40 // External Interrupt 7 Sense Control Bit
	EICRB_ISC71 = 0x80 // External Interrupt 7 Sense Control Bit
	EICRB_ISC60 = 0x10 // External Interrupt 6 Sense Control Bit
	EICRB_ISC61 = 0x20 // External Interrupt 6 Sense Control Bit
	EICRB_ISC50 = 0x4  // External Interrupt 5 Sense Control Bit
	EICRB_ISC51 = 0x8  // External Interrupt 5 Sense Control Bit
	EICRB_ISC40 = 0x1  // External Interrupt 4 Sense Control Bit
	EICRB_ISC41 = 0x2  // External Interrupt 4 Sense Control Bit

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0 = 0x1  // External Interrupt Request Enable
	EIMSK_INT1 = 0x2  // External Interrupt Request Enable
	EIMSK_INT2 = 0x4  // External Interrupt Request Enable
	EIMSK_INT3 = 0x8  // External Interrupt Request Enable
	EIMSK_INT4 = 0x10 // External Interrupt Request Enable
	EIMSK_INT5 = 0x20 // External Interrupt Request Enable
	EIMSK_INT6 = 0x40 // External Interrupt Request Enable
	EIMSK_INT7 = 0x80 // External Interrupt Request Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0 = 0x1  // External Interrupt Flag
	EIFR_INTF1 = 0x2  // External Interrupt Flag
	EIFR_INTF2 = 0x4  // External Interrupt Flag
	EIFR_INTF3 = 0x8  // External Interrupt Flag
	EIFR_INTF4 = 0x10 // External Interrupt Flag
	EIFR_INTF5 = 0x20 // External Interrupt Flag
	EIFR_INTF6 = 0x40 // External Interrupt Flag
	EIFR_INTF7 = 0x80 // External Interrupt Flag

	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0 = 0x1  // Pin Change Enable Mask
	PCMSK2_PCINT1 = 0x2  // Pin Change Enable Mask
	PCMSK2_PCINT2 = 0x4  // Pin Change Enable Mask
	PCMSK2_PCINT3 = 0x8  // Pin Change Enable Mask
	PCMSK2_PCINT4 = 0x10 // Pin Change Enable Mask
	PCMSK2_PCINT5 = 0x20 // Pin Change Enable Mask
	PCMSK2_PCINT6 = 0x40 // Pin Change Enable Mask
	PCMSK2_PCINT7 = 0x80 // Pin Change Enable Mask

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0 = 0x1  // Pin Change Enable Mask
	PCMSK1_PCINT1 = 0x2  // Pin Change Enable Mask
	PCMSK1_PCINT2 = 0x4  // Pin Change Enable Mask
	PCMSK1_PCINT3 = 0x8  // Pin Change Enable Mask
	PCMSK1_PCINT4 = 0x10 // Pin Change Enable Mask
	PCMSK1_PCINT5 = 0x20 // Pin Change Enable Mask
	PCMSK1_PCINT6 = 0x40 // Pin Change Enable Mask
	PCMSK1_PCINT7 = 0x80 // Pin Change Enable Mask

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0 = 0x1  // Pin Change Enable Mask
	PCMSK0_PCINT1 = 0x2  // Pin Change Enable Mask
	PCMSK0_PCINT2 = 0x4  // Pin Change Enable Mask
	PCMSK0_PCINT3 = 0x8  // Pin Change Enable Mask
	PCMSK0_PCINT4 = 0x10 // Pin Change Enable Mask
	PCMSK0_PCINT5 = 0x20 // Pin Change Enable Mask
	PCMSK0_PCINT6 = 0x40 // Pin Change Enable Mask
	PCMSK0_PCINT7 = 0x80 // Pin Change Enable Mask

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_Res0  = 0x8  // Reserved Bit
	PCIFR_Res1  = 0x10 // Reserved Bit
	PCIFR_Res2  = 0x20 // Reserved Bit
	PCIFR_Res3  = 0x40 // Reserved Bit
	PCIFR_Res4  = 0x80 // Reserved Bit
	PCIFR_PCIF0 = 0x1  // Pin Change Interrupt Flags
	PCIFR_PCIF1 = 0x2  // Pin Change Interrupt Flags
	PCIFR_PCIF2 = 0x4  // Pin Change Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_Res0  = 0x8  // Reserved Bit
	PCICR_Res1  = 0x10 // Reserved Bit
	PCICR_Res2  = 0x20 // Reserved Bit
	PCICR_Res3  = 0x40 // Reserved Bit
	PCICR_Res4  = 0x80 // Reserved Bit
	PCICR_PCIE0 = 0x1  // Pin Change Interrupt Enables
	PCICR_PCIE1 = 0x2  // Pin Change Interrupt Enables
	PCICR_PCIE2 = 0x4  // Pin Change Interrupt Enables
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC Multiplexer Selection Register
	ADMUX_REFS0 = 0x40 // Reference Selection Bits
	ADMUX_REFS1 = 0x80 // Reference Selection Bits
	ADMUX_ADLAR = 0x20 // ADC Left Adjust Result
	ADMUX_MUX0  = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1  = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2  = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3  = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4  = 0x10 // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status Register A
	ADCSRA_ADEN  = 0x80 // ADC Enable
	ADCSRA_ADSC  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0 = 0x1  // ADC  Prescaler Select Bits
	ADCSRA_ADPS1 = 0x2  // ADC  Prescaler Select Bits
	ADCSRA_ADPS2 = 0x4  // ADC  Prescaler Select Bits

	// ADCSRC: The ADC Control and Status Register C
	ADCSRC_ADTHT0 = 0x40 // ADC Track-and-Hold Time
	ADCSRC_ADTHT1 = 0x80 // ADC Track-and-Hold Time
	ADCSRC_Res0   = 0x20 // Reserved
	ADCSRC_ADSUT0 = 0x1  // ADC Start-up Time
	ADCSRC_ADSUT1 = 0x2  // ADC Start-up Time
	ADCSRC_ADSUT2 = 0x4  // ADC Start-up Time
	ADCSRC_ADSUT3 = 0x8  // ADC Start-up Time
	ADCSRC_ADSUT4 = 0x10 // ADC Start-up Time

	// DIDR2: Digital Input Disable Register 2
	DIDR2_ADC15D = 0x80 // Reserved Bits
	DIDR2_ADC14D = 0x40 // Reserved Bits
	DIDR2_ADC13D = 0x20 // Reserved Bits
	DIDR2_ADC12D = 0x10 // Reserved Bits
	DIDR2_ADC11D = 0x8  // Reserved Bits
	DIDR2_ADC10D = 0x4  // Reserved Bits
	DIDR2_ADC9D  = 0x2  // Reserved Bits
	DIDR2_ADC8D  = 0x1  // Reserved Bits

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC7D = 0x80 // Disable ADC7:0 Digital Input
	DIDR0_ADC6D = 0x40 // Disable ADC7:0 Digital Input
	DIDR0_ADC5D = 0x20 // Disable ADC7:0 Digital Input
	DIDR0_ADC4D = 0x10 // Disable ADC7:0 Digital Input
	DIDR0_ADC3D = 0x8  // Disable ADC7:0 Digital Input
	DIDR0_ADC2D = 0x4  // Disable ADC7:0 Digital Input
	DIDR0_ADC1D = 0x2  // Disable ADC7:0 Digital Input
	DIDR0_ADC0D = 0x1  // Disable ADC7:0 Digital Input
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE = 0x10 // Read While Write Section Read Enable
	SPMCSR_BLBSET = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT  = 0x4  // Page Write
	SPMCSR_PGERS  = 0x2  // Page Erase
	SPMCSR_SPMEN  = 0x1  // Store Program Memory Enable
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I = 0x80 // Global Interrupt Enable
	SREG_T = 0x40 // Bit Copy Storage
	SREG_H = 0x20 // Half Carry Flag
	SREG_S = 0x10 // Sign Bit
	SREG_V = 0x8  // Two's Complement Overflow Flag
	SREG_N = 0x4  // Negative Flag
	SREG_Z = 0x2  // Zero Flag
	SREG_C = 0x1  // Carry Flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_CAL0 = 0x1  // Oscillator Calibration Tuning Value
	OSCCAL_CAL1 = 0x2  // Oscillator Calibration Tuning Value
	OSCCAL_CAL2 = 0x4  // Oscillator Calibration Tuning Value
	OSCCAL_CAL3 = 0x8  // Oscillator Calibration Tuning Value
	OSCCAL_CAL4 = 0x10 // Oscillator Calibration Tuning Value
	OSCCAL_CAL5 = 0x20 // Oscillator Calibration Tuning Value
	OSCCAL_CAL6 = 0x40 // Oscillator Calibration Tuning Value
	OSCCAL_CAL7 = 0x80 // Oscillator Calibration Tuning Value

	// CLKPR: Clock Prescale Register
	CLKPR_CLKPCE = 0x80 // Clock Prescaler Change Enable
	CLKPR_Res0   = 0x10 // Reserved
	CLKPR_Res1   = 0x20 // Reserved
	CLKPR_Res2   = 0x40 // Reserved
	CLKPR_CLKPS0 = 0x1  // Clock Prescaler Select Bits
	CLKPR_CLKPS1 = 0x2  // Clock Prescaler Select Bits
	CLKPR_CLKPS2 = 0x4  // Clock Prescaler Select Bits
	CLKPR_CLKPS3 = 0x8  // Clock Prescaler Select Bits

	// SMCR: Sleep Mode Control Register
	SMCR_Res0 = 0x10 // Reserved
	SMCR_Res1 = 0x20 // Reserved
	SMCR_Res2 = 0x40 // Reserved
	SMCR_Res3 = 0x80 // Reserved
	SMCR_SM0  = 0x2  // Sleep Mode Select bits
	SMCR_SM1  = 0x4  // Sleep Mode Select bits
	SMCR_SM2  = 0x8  // Sleep Mode Select bits
	SMCR_SE   = 0x1  // Sleep Enable

	// RAMPZ: Extended Z-pointer Register for ELPM/SPM
	RAMPZ_Res0   = 0x2  // Reserved
	RAMPZ_Res1   = 0x4  // Reserved
	RAMPZ_Res2   = 0x8  // Reserved
	RAMPZ_Res3   = 0x10 // Reserved
	RAMPZ_Res4   = 0x20 // Reserved
	RAMPZ_Res5   = 0x40 // Reserved
	RAMPZ_Res6   = 0x80 // Reserved
	RAMPZ_RAMPZ0 = 0x1  // Extended Z-Pointer Value

	// GPIOR2: General Purpose I/O Register 2
	GPIOR2_GPIOR0 = 0x1  // General Purpose I/O Register 2 Value
	GPIOR2_GPIOR1 = 0x2  // General Purpose I/O Register 2 Value
	GPIOR2_GPIOR2 = 0x4  // General Purpose I/O Register 2 Value
	GPIOR2_GPIOR3 = 0x8  // General Purpose I/O Register 2 Value
	GPIOR2_GPIOR4 = 0x10 // General Purpose I/O Register 2 Value
	GPIOR2_GPIOR5 = 0x20 // General Purpose I/O Register 2 Value
	GPIOR2_GPIOR6 = 0x40 // General Purpose I/O Register 2 Value
	GPIOR2_GPIOR7 = 0x80 // General Purpose I/O Register 2 Value

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0 = 0x1  // General Purpose I/O Register 1 Value
	GPIOR1_GPIOR1 = 0x2  // General Purpose I/O Register 1 Value
	GPIOR1_GPIOR2 = 0x4  // General Purpose I/O Register 1 Value
	GPIOR1_GPIOR3 = 0x8  // General Purpose I/O Register 1 Value
	GPIOR1_GPIOR4 = 0x10 // General Purpose I/O Register 1 Value
	GPIOR1_GPIOR5 = 0x20 // General Purpose I/O Register 1 Value
	GPIOR1_GPIOR6 = 0x40 // General Purpose I/O Register 1 Value
	GPIOR1_GPIOR7 = 0x80 // General Purpose I/O Register 1 Value

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07 = 0x80 // General Purpose I/O Register 0 Value
	GPIOR0_GPIOR06 = 0x40 // General Purpose I/O Register 0 Value
	GPIOR0_GPIOR05 = 0x20 // General Purpose I/O Register 0 Value
	GPIOR0_GPIOR04 = 0x10 // General Purpose I/O Register 0 Value
	GPIOR0_GPIOR03 = 0x8  // General Purpose I/O Register 0 Value
	GPIOR0_GPIOR02 = 0x4  // General Purpose I/O Register 0 Value
	GPIOR0_GPIOR01 = 0x2  // General Purpose I/O Register 0 Value
	GPIOR0_GPIOR00 = 0x1  // General Purpose I/O Register 0 Value

	// PRR2: Power Reduction Register 2
	PRR2_PRRAM3 = 0x8 // Power Reduction SRAM3
	PRR2_PRRAM2 = 0x4 // Power Reduction SRAM2
	PRR2_PRRAM1 = 0x2 // Power Reduction SRAM1
	PRR2_PRRAM0 = 0x1 // Power Reduction SRAM0

	// PRR1: Power Reduction Register 1
	PRR1_Res      = 0x80 // Reserved Bit
	PRR1_PRTRX24  = 0x40 // Power Reduction Transceiver
	PRR1_PRTIM5   = 0x20 // Power Reduction Timer/Counter5
	PRR1_PRTIM4   = 0x10 // Power Reduction Timer/Counter4
	PRR1_PRTIM3   = 0x8  // Power Reduction Timer/Counter3
	PRR1_PRUSART1 = 0x1  // Power Reduction USART1

	// PRR0: Power Reduction Register0
	PRR0_PRTWI    = 0x80 // Power Reduction TWI
	PRR0_PRTIM2   = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM0   = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRPGA    = 0x10 // Power Reduction PGA
	PRR0_PRTIM1   = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRSPI    = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRUSART0 = 0x2  // Power Reduction USART
	PRR0_PRADC    = 0x1  // Power Reduction ADC
)

// Bitfields for FLASH: FLASH Controller
const (
	// NEMCR: Flash Extended-Mode Control-Register
	NEMCR_ENEAM = 0x40 // Enable Extended Address Mode for Extra Rows
	NEMCR_AEAM0 = 0x10 // Address for Extended Address Mode of Extra Rows
	NEMCR_AEAM1 = 0x20 // Address for Extended Address Mode of Extra Rows

	// BGCR: Reference Voltage Calibration Register
	BGCR_Res         = 0x80 // Reserved Bit
	BGCR_BGCAL_FINE0 = 0x8  // Fine Calibration Bits
	BGCR_BGCAL_FINE1 = 0x10 // Fine Calibration Bits
	BGCR_BGCAL_FINE2 = 0x20 // Fine Calibration Bits
	BGCR_BGCAL_FINE3 = 0x40 // Fine Calibration Bits
	BGCR_BGCAL0      = 0x1  // Coarse Calibration Bits
	BGCR_BGCAL1      = 0x2  // Coarse Calibration Bits
	BGCR_BGCAL2      = 0x4  // Coarse Calibration Bits
)

// Bitfields for PWRCTRL: Power Controller
const (
	// TRXPR: Transceiver Pin Register
	TRXPR_Res0   = 0x10 // Reserved
	TRXPR_Res1   = 0x20 // Reserved
	TRXPR_Res2   = 0x40 // Reserved
	TRXPR_Res3   = 0x80 // Reserved
	TRXPR_SLPTR  = 0x2  // Multi-purpose Transceiver Control Bit
	TRXPR_TRXRST = 0x1  // Force Transceiver Reset

	// DRTRAM0: Data Retention Configuration Register #0
	DRTRAM0_Res0    = 0x40 // Reserved
	DRTRAM0_Res1    = 0x80 // Reserved
	DRTRAM0_DRTSWOK = 0x20 // DRT Switch OK
	DRTRAM0_ENDRT   = 0x10 // Enable SRAM Data Retention

	// DRTRAM1: Data Retention Configuration Register #1
	DRTRAM1_Res0    = 0x40 // Reserved
	DRTRAM1_Res1    = 0x80 // Reserved
	DRTRAM1_DRTSWOK = 0x20 // DRT Switch OK
	DRTRAM1_ENDRT   = 0x10 // Enable SRAM Data Retention

	// DRTRAM2: Data Retention Configuration Register #2
	DRTRAM2_Res     = 0x40 // Reserved Bit
	DRTRAM2_DRTSWOK = 0x20 // DRT Switch OK
	DRTRAM2_ENDRT   = 0x10 // Enable SRAM Data Retention

	// DRTRAM3: Data Retention Configuration Register #3
	DRTRAM3_Res0    = 0x40 // Reserved
	DRTRAM3_Res1    = 0x80 // Reserved
	DRTRAM3_DRTSWOK = 0x20 // DRT Switch OK
	DRTRAM3_ENDRT   = 0x10 // Enable SRAM Data Retention

	// LLDRL: Low Leakage Voltage Regulator Data Register (Low-Byte)
	LLDRL_Res0   = 0x10 // Reserved
	LLDRL_Res1   = 0x20 // Reserved
	LLDRL_Res2   = 0x40 // Reserved
	LLDRL_Res3   = 0x80 // Reserved
	LLDRL_LLDRL0 = 0x1  // Low-Byte Data Register Bits
	LLDRL_LLDRL1 = 0x2  // Low-Byte Data Register Bits
	LLDRL_LLDRL2 = 0x4  // Low-Byte Data Register Bits
	LLDRL_LLDRL3 = 0x8  // Low-Byte Data Register Bits

	// LLDRH: Low Leakage Voltage Regulator Data Register (High-Byte)
	LLDRH_Res0   = 0x20 // Reserved
	LLDRH_Res1   = 0x40 // Reserved
	LLDRH_Res2   = 0x80 // Reserved
	LLDRH_LLDRH0 = 0x1  // High-Byte Data Register Bits
	LLDRH_LLDRH1 = 0x2  // High-Byte Data Register Bits
	LLDRH_LLDRH2 = 0x4  // High-Byte Data Register Bits
	LLDRH_LLDRH3 = 0x8  // High-Byte Data Register Bits
	LLDRH_LLDRH4 = 0x10 // High-Byte Data Register Bits

	// LLCR: Low Leakage Voltage Regulator Control Register
	LLCR_Res0    = 0x40 // Reserved Bit
	LLCR_Res1    = 0x80 // Reserved Bit
	LLCR_LLDONE  = 0x20 // Calibration Done
	LLCR_LLCOMP  = 0x10 // Comparator Output
	LLCR_LLCAL   = 0x8  // Calibration Active
	LLCR_LLTCO   = 0x4  // Temperature Coefficient of Current Source
	LLCR_LLSHORT = 0x2  // Short Lower Calibration Circuit
	LLCR_LLENCAL = 0x1  // Enable Automatic Calibration

	// DPDS0: Port Driver Strength Register 0
	DPDS0_PFDRV0 = 0x40 // Driver Strength Port F
	DPDS0_PFDRV1 = 0x80 // Driver Strength Port F
	DPDS0_PEDRV0 = 0x10 // Driver Strength Port E
	DPDS0_PEDRV1 = 0x20 // Driver Strength Port E
	DPDS0_PDDRV0 = 0x4  // Driver Strength Port D
	DPDS0_PDDRV1 = 0x8  // Driver Strength Port D
	DPDS0_PBDRV0 = 0x1  // Driver Strength Port B
	DPDS0_PBDRV1 = 0x2  // Driver Strength Port B

	// DPDS1: Port Driver Strength Register 1
	DPDS1_Res0   = 0x4  // Reserved
	DPDS1_Res1   = 0x8  // Reserved
	DPDS1_Res2   = 0x10 // Reserved
	DPDS1_Res3   = 0x20 // Reserved
	DPDS1_Res4   = 0x40 // Reserved
	DPDS1_Res5   = 0x80 // Reserved
	DPDS1_PGDRV0 = 0x1  // Driver Strength Port G
	DPDS1_PGDRV1 = 0x2  // Driver Strength Port G
)
