// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega2561.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega2561
// +build avr,atmega2561

// Device information for the ATmega2561.
package avr

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega2561"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin,Power-on Reset,Brown-out Reset,Watchdog Reset,and JTAG AVR Reset. See Datasheet.
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_INT2         = 3  // External Interrupt Request 2
	IRQ_INT3         = 4  // External Interrupt Request 3
	IRQ_INT4         = 5  // External Interrupt Request 4
	IRQ_INT5         = 6  // External Interrupt Request 5
	IRQ_INT6         = 7  // External Interrupt Request 6
	IRQ_INT7         = 8  // External Interrupt Request 7
	IRQ_PCINT0       = 9  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 10 // Pin Change Interrupt Request 1
	IRQ_PCINT2       = 11 // Pin Change Interrupt Request 2
	IRQ_WDT          = 12 // Watchdog Time-out Interrupt
	IRQ_TIMER2_COMPA = 13 // Timer/Counter2 Compare Match A
	IRQ_TIMER2_COMPB = 14 // Timer/Counter2 Compare Match B
	IRQ_TIMER2_OVF   = 15 // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT  = 16 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 17 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 18 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_COMPC = 19 // Timer/Counter1 Compare Match C
	IRQ_TIMER1_OVF   = 20 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 21 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 22 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 23 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 24 // SPI Serial Transfer Complete
	IRQ_USART0_RX    = 25 // USART0, Rx Complete
	IRQ_USART0_UDRE  = 26 // USART0 Data register Empty
	IRQ_USART0_TX    = 27 // USART0, Tx Complete
	IRQ_ANALOG_COMP  = 28 // Analog Comparator
	IRQ_ADC          = 29 // ADC Conversion Complete
	IRQ_EE_READY     = 30 // EEPROM Ready
	IRQ_TIMER3_CAPT  = 31 // Timer/Counter3 Capture Event
	IRQ_TIMER3_COMPA = 32 // Timer/Counter3 Compare Match A
	IRQ_TIMER3_COMPB = 33 // Timer/Counter3 Compare Match B
	IRQ_TIMER3_COMPC = 34 // Timer/Counter3 Compare Match C
	IRQ_TIMER3_OVF   = 35 // Timer/Counter3 Overflow
	IRQ_USART1_RX    = 36 // USART1, Rx Complete
	IRQ_USART1_UDRE  = 37 // USART1 Data register Empty
	IRQ_USART1_TX    = 38 // USART1, Tx Complete
	IRQ_TWI          = 39 // 2-wire Serial Interface
	IRQ_SPM_READY    = 40 // Store Program Memory Read
	IRQ_TIMER4_CAPT  = 41 // Timer/Counter4 Capture Event
	IRQ_TIMER4_COMPA = 42 // Timer/Counter4 Compare Match A
	IRQ_TIMER4_COMPB = 43 // Timer/Counter4 Compare Match B
	IRQ_TIMER4_COMPC = 44 // Timer/Counter4 Compare Match C
	IRQ_TIMER4_OVF   = 45 // Timer/Counter4 Overflow
	IRQ_TIMER5_CAPT  = 46 // Timer/Counter5 Capture Event
	IRQ_TIMER5_COMPA = 47 // Timer/Counter5 Compare Match A
	IRQ_TIMER5_COMPB = 48 // Timer/Counter5 Compare Match B
	IRQ_TIMER5_COMPC = 49 // Timer/Counter5 Compare Match C
	IRQ_TIMER5_OVF   = 50 // Timer/Counter5 Overflow
	IRQ_USART2_RX    = 51 // USART2, Rx Complete
	IRQ_USART2_UDRE  = 52 // USART2 Data register Empty
	IRQ_USART2_TX    = 53 // USART2, Tx Complete
	IRQ_USART3_RX    = 54 // USART3, Rx Complete
	IRQ_USART3_UDRE  = 55 // USART3 Data register Empty
	IRQ_USART3_TX    = 56 // USART3, Tx Complete
	IRQ_max          = 56 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_RESET, "__vector_RESET")
	_ = interrupt.Register(IRQ_INT0, "__vector_INT0")
	_ = interrupt.Register(IRQ_INT1, "__vector_INT1")
	_ = interrupt.Register(IRQ_INT2, "__vector_INT2")
	_ = interrupt.Register(IRQ_INT3, "__vector_INT3")
	_ = interrupt.Register(IRQ_INT4, "__vector_INT4")
	_ = interrupt.Register(IRQ_INT5, "__vector_INT5")
	_ = interrupt.Register(IRQ_INT6, "__vector_INT6")
	_ = interrupt.Register(IRQ_INT7, "__vector_INT7")
	_ = interrupt.Register(IRQ_PCINT0, "__vector_PCINT0")
	_ = interrupt.Register(IRQ_PCINT1, "__vector_PCINT1")
	_ = interrupt.Register(IRQ_PCINT2, "__vector_PCINT2")
	_ = interrupt.Register(IRQ_WDT, "__vector_WDT")
	_ = interrupt.Register(IRQ_TIMER2_COMPA, "__vector_TIMER2_COMPA")
	_ = interrupt.Register(IRQ_TIMER2_COMPB, "__vector_TIMER2_COMPB")
	_ = interrupt.Register(IRQ_TIMER2_OVF, "__vector_TIMER2_OVF")
	_ = interrupt.Register(IRQ_TIMER1_CAPT, "__vector_TIMER1_CAPT")
	_ = interrupt.Register(IRQ_TIMER1_COMPA, "__vector_TIMER1_COMPA")
	_ = interrupt.Register(IRQ_TIMER1_COMPB, "__vector_TIMER1_COMPB")
	_ = interrupt.Register(IRQ_TIMER1_COMPC, "__vector_TIMER1_COMPC")
	_ = interrupt.Register(IRQ_TIMER1_OVF, "__vector_TIMER1_OVF")
	_ = interrupt.Register(IRQ_TIMER0_COMPA, "__vector_TIMER0_COMPA")
	_ = interrupt.Register(IRQ_TIMER0_COMPB, "__vector_TIMER0_COMPB")
	_ = interrupt.Register(IRQ_TIMER0_OVF, "__vector_TIMER0_OVF")
	_ = interrupt.Register(IRQ_SPI_STC, "__vector_SPI_STC")
	_ = interrupt.Register(IRQ_USART0_RX, "__vector_USART0_RX")
	_ = interrupt.Register(IRQ_USART0_UDRE, "__vector_USART0_UDRE")
	_ = interrupt.Register(IRQ_USART0_TX, "__vector_USART0_TX")
	_ = interrupt.Register(IRQ_ANALOG_COMP, "__vector_ANALOG_COMP")
	_ = interrupt.Register(IRQ_ADC, "__vector_ADC")
	_ = interrupt.Register(IRQ_EE_READY, "__vector_EE_READY")
	_ = interrupt.Register(IRQ_TIMER3_CAPT, "__vector_TIMER3_CAPT")
	_ = interrupt.Register(IRQ_TIMER3_COMPA, "__vector_TIMER3_COMPA")
	_ = interrupt.Register(IRQ_TIMER3_COMPB, "__vector_TIMER3_COMPB")
	_ = interrupt.Register(IRQ_TIMER3_COMPC, "__vector_TIMER3_COMPC")
	_ = interrupt.Register(IRQ_TIMER3_OVF, "__vector_TIMER3_OVF")
	_ = interrupt.Register(IRQ_USART1_RX, "__vector_USART1_RX")
	_ = interrupt.Register(IRQ_USART1_UDRE, "__vector_USART1_UDRE")
	_ = interrupt.Register(IRQ_USART1_TX, "__vector_USART1_TX")
	_ = interrupt.Register(IRQ_TWI, "__vector_TWI")
	_ = interrupt.Register(IRQ_SPM_READY, "__vector_SPM_READY")
	_ = interrupt.Register(IRQ_TIMER4_CAPT, "__vector_TIMER4_CAPT")
	_ = interrupt.Register(IRQ_TIMER4_COMPA, "__vector_TIMER4_COMPA")
	_ = interrupt.Register(IRQ_TIMER4_COMPB, "__vector_TIMER4_COMPB")
	_ = interrupt.Register(IRQ_TIMER4_COMPC, "__vector_TIMER4_COMPC")
	_ = interrupt.Register(IRQ_TIMER4_OVF, "__vector_TIMER4_OVF")
	_ = interrupt.Register(IRQ_TIMER5_CAPT, "__vector_TIMER5_CAPT")
	_ = interrupt.Register(IRQ_TIMER5_COMPA, "__vector_TIMER5_COMPA")
	_ = interrupt.Register(IRQ_TIMER5_COMPB, "__vector_TIMER5_COMPB")
	_ = interrupt.Register(IRQ_TIMER5_COMPC, "__vector_TIMER5_COMPC")
	_ = interrupt.Register(IRQ_TIMER5_OVF, "__vector_TIMER5_OVF")
	_ = interrupt.Register(IRQ_USART2_RX, "__vector_USART2_RX")
	_ = interrupt.Register(IRQ_USART2_UDRE, "__vector_USART2_UDRE")
	_ = interrupt.Register(IRQ_USART2_TX, "__vector_USART2_TX")
	_ = interrupt.Register(IRQ_USART3_RX, "__vector_USART3_RX")
	_ = interrupt.Register(IRQ_USART3_UDRE, "__vector_USART3_UDRE")
	_ = interrupt.Register(IRQ_USART3_TX, "__vector_USART3_TX")
)

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Analog Comparator
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	DIDR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))

	// USART
	UDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc6)))
	UCSR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc0)))
	UCSR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc1)))
	UCSR0C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc2)))
	UBRR0L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc4)))
	UBRR0H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc5)))
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))

	// Two Wire Serial Interface
	TWAMR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbd)))
	TWBR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	TWAR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	PORTF = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	DDRF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))
	PINF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	PORTG = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	DDRG  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x33)))
	PING  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))

	// Timer/Counter, 8-bit Async
	TIMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x70)))
	TIFR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	TCCR2A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb0)))
	TCCR2B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb1)))
	TCNT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb2)))
	OCR2B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb4)))
	OCR2A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb3)))
	ASSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb6)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Timer/Counter, 16-bit
	TCCR5A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x120)))
	TCCR5B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x121)))
	TCCR5C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x122)))
	TCNT5L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x124)))
	TCNT5H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x125)))
	OCR5AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x128)))
	OCR5AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x129)))
	OCR5BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12a)))
	OCR5BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12b)))
	OCR5CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12c)))
	OCR5CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x12d)))
	ICR5L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x126)))
	ICR5H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x127)))
	TIMSK5 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x73)))
	TIFR5  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	TCCR4A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa0)))
	TCCR4B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa1)))
	TCCR4C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa2)))
	TCNT4L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa4)))
	TCNT4H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa5)))
	OCR4AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa8)))
	OCR4AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa9)))
	OCR4BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaa)))
	OCR4BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xab)))
	OCR4CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xac)))
	OCR4CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xad)))
	ICR4L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa6)))
	ICR4H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa7)))
	TIMSK4 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x72)))
	TIFR4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	TCCR3A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))
	TCCR3B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	TCCR3C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	TCNT3L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x94)))
	TCNT3H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x95)))
	OCR3AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x98)))
	OCR3AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x99)))
	OCR3BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9a)))
	OCR3BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9b)))
	OCR3CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9c)))
	OCR3CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9d)))
	ICR3L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	ICR3H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))
	TIMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x71)))
	TIFR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	OCR1CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8c)))
	OCR1CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8d)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))

	// JTAG Interface
	OCDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EICRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	XMCRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x74)))
	XMCRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x75)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	EIND   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	RAMPZ  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PRR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x65)))
	PRR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	DIDR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODLEVEL0 = 0x1 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL1 = 0x2 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL2 = 0x4 // Brown-out Detector trigger level

	// HIGH
	HIGH_OCDEN   = 0x80 // On-Chip Debug Enabled
	HIGH_JTAGEN  = 0x40 // JTAG Interface Enabled
	HIGH_SPIEN   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON   = 0x10 // Watchdog timer always on
	HIGH_EESAVE  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0 = 0x2  // Select Boot Size
	HIGH_BOOTSZ1 = 0x4  // Select Boot Size
	HIGH_BOOTRST = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8     = 0x80 // Divide clock by 8 internally
	LOW_CKOUT      = 0x40 // Clock output on PORTE7
	LOW_SUT_CKSEL0 = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1 = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2 = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3 = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4 = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5 = 0x20 // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0   = 0x1  // Memory Lock
	LOCKBIT_LB1   = 0x2  // Memory Lock
	LOCKBIT_BLB00 = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01 = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB10 = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11 = 0x20 // Boot Loader Protection Mode
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD   = 0x80 // Analog Comparator Disable
	ACSR_ACBG  = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO   = 0x20 // Analog Compare Output
	ACSR_ACI   = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE  = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC  = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0 = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1 = 0x2  // Analog Comparator Interrupt Mode Select bits

	// DIDR1: Digital Input Disable Register 1
	DIDR1_AIN1D = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN0D = 0x1 // AIN0 Digital Input Disable
)

// Bitfields for USART: USART
const (
	// UCSR0A: USART Control and Status Register A
	UCSR0A_RXC0  = 0x80 // USART Receive Complete
	UCSR0A_TXC0  = 0x40 // USART Transmitt Complete
	UCSR0A_UDRE0 = 0x20 // USART Data Register Empty
	UCSR0A_FE0   = 0x10 // Framing Error
	UCSR0A_DOR0  = 0x8  // Data overRun
	UCSR0A_UPE0  = 0x4  // Parity Error
	UCSR0A_U2X0  = 0x2  // Double the USART transmission speed
	UCSR0A_MPCM0 = 0x1  // Multi-processor Communication Mode

	// UCSR0B: USART Control and Status Register B
	UCSR0B_RXCIE0 = 0x80 // RX Complete Interrupt Enable
	UCSR0B_TXCIE0 = 0x40 // TX Complete Interrupt Enable
	UCSR0B_UDRIE0 = 0x20 // USART Data register Empty Interrupt Enable
	UCSR0B_RXEN0  = 0x10 // Receiver Enable
	UCSR0B_TXEN0  = 0x8  // Transmitter Enable
	UCSR0B_UCSZ02 = 0x4  // Character Size
	UCSR0B_RXB80  = 0x2  // Receive Data Bit 8
	UCSR0B_TXB80  = 0x1  // Transmit Data Bit 8

	// UCSR0C: USART Control and Status Register C
	UCSR0C_UMSEL00 = 0x40 // USART Mode Select
	UCSR0C_UMSEL01 = 0x80 // USART Mode Select
	UCSR0C_UPM00   = 0x10 // Parity Mode Bits
	UCSR0C_UPM01   = 0x20 // Parity Mode Bits
	UCSR0C_USBS0   = 0x8  // Stop Bit Select
	UCSR0C_UCSZ00  = 0x2  // Character Size
	UCSR0C_UCSZ01  = 0x4  // Character Size
	UCSR0C_UCPOL0  = 0x1  // Clock Polarity

	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1  = 0x80 // USART Receive Complete
	UCSR1A_TXC1  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1 = 0x20 // USART Data Register Empty
	UCSR1A_FE1   = 0x10 // Framing Error
	UCSR1A_DOR1  = 0x8  // Data overRun
	UCSR1A_UPE1  = 0x4  // Parity Error
	UCSR1A_U2X1  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1 = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1 = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1 = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1 = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1  = 0x10 // Receiver Enable
	UCSR1B_TXEN1  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12 = 0x4  // Character Size
	UCSR1B_RXB81  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_UMSEL10 = 0x40 // USART Mode Select
	UCSR1C_UMSEL11 = 0x80 // USART Mode Select
	UCSR1C_UPM10   = 0x10 // Parity Mode Bits
	UCSR1C_UPM11   = 0x20 // Parity Mode Bits
	UCSR1C_USBS1   = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10  = 0x2  // Character Size
	UCSR1C_UCSZ11  = 0x4  // Character Size
	UCSR1C_UCPOL1  = 0x1  // Clock Polarity
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWAMR: TWI (Slave) Address Mask Register
	TWAMR_TWAM0 = 0x2
	TWAMR_TWAM1 = 0x4
	TWAMR_TWAM2 = 0x8
	TWAMR_TWAM3 = 0x10
	TWAMR_TWAM4 = 0x20
	TWAMR_TWAM5 = 0x40
	TWAMR_TWAM6 = 0x80

	// TWCR: TWI Control Register
	TWCR_TWINT = 0x80 // TWI Interrupt Flag
	TWCR_TWEA  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA = 0x20 // TWI Start Condition Bit
	TWCR_TWSTO = 0x10 // TWI Stop Condition Bit
	TWCR_TWWC  = 0x8  // TWI Write Collition Flag
	TWCR_TWEN  = 0x4  // TWI Enable Bit
	TWCR_TWIE  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0  = 0x8  // TWI Status
	TWSR_TWS1  = 0x10 // TWI Status
	TWSR_TWS2  = 0x20 // TWI Status
	TWSR_TWS3  = 0x40 // TWI Status
	TWSR_TWS4  = 0x80 // TWI Status
	TWSR_TWPS0 = 0x1  // TWI Prescaler
	TWSR_TWPS1 = 0x2  // TWI Prescaler

	// TWAR: TWI (Slave) Address register
	TWAR_TWA0  = 0x2  // TWI (Slave) Address register Bits
	TWAR_TWA1  = 0x4  // TWI (Slave) Address register Bits
	TWAR_TWA2  = 0x8  // TWI (Slave) Address register Bits
	TWAR_TWA3  = 0x10 // TWI (Slave) Address register Bits
	TWAR_TWA4  = 0x20 // TWI (Slave) Address register Bits
	TWAR_TWA5  = 0x40 // TWI (Slave) Address register Bits
	TWAR_TWA6  = 0x80 // TWI (Slave) Address register Bits
	TWAR_TWGCE = 0x1  // TWI General Call Recognition Enable Bit
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE = 0x80 // SPI Interrupt Enable
	SPCR_SPE  = 0x40 // SPI Enable
	SPCR_DORD = 0x20 // Data Order
	SPCR_MSTR = 0x10 // Master/Slave Select
	SPCR_CPOL = 0x8  // Clock polarity
	SPCR_CPHA = 0x4  // Clock Phase
	SPCR_SPR0 = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1 = 0x2  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL  = 0x40 // Write Collision Flag
	SPSR_SPI2X = 0x1  // Double SPI Speed Bit
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A = 0x80 // Force Output Compare A
	TCCR0B_FOC0B = 0x40 // Force Output Compare B
	TCCR0B_WGM02 = 0x8
	TCCR0B_CS00  = 0x1 // Clock Select
	TCCR0B_CS01  = 0x2 // Clock Select
	TCCR0B_CS02  = 0x4 // Clock Select

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0 = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1 = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0 = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1 = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00  = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01  = 0x2  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0  = 0x1 // Timer/Counter0 Overflow Flag
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TIMSK2: Timer/Counter Interrupt Mask register
	TIMSK2_OCIE2B = 0x4 // Timer/Counter2 Output Compare Match B Interrupt Enable
	TIMSK2_OCIE2A = 0x2 // Timer/Counter2 Output Compare Match A Interrupt Enable
	TIMSK2_TOIE2  = 0x1 // Timer/Counter2 Overflow Interrupt Enable

	// TIFR2: Timer/Counter Interrupt Flag Register
	TIFR2_OCF2B = 0x4 // Output Compare Flag 2B
	TIFR2_OCF2A = 0x2 // Output Compare Flag 2A
	TIFR2_TOV2  = 0x1 // Timer/Counter2 Overflow Flag

	// TCCR2A: Timer/Counter2 Control Register A
	TCCR2A_COM2A0 = 0x40 // Compare Output Mode bits
	TCCR2A_COM2A1 = 0x80 // Compare Output Mode bits
	TCCR2A_COM2B0 = 0x10 // Compare Output Mode bits
	TCCR2A_COM2B1 = 0x20 // Compare Output Mode bits
	TCCR2A_WGM20  = 0x1  // Waveform Genration Mode
	TCCR2A_WGM21  = 0x2  // Waveform Genration Mode

	// TCCR2B: Timer/Counter2 Control Register B
	TCCR2B_FOC2A = 0x80 // Force Output Compare A
	TCCR2B_FOC2B = 0x40 // Force Output Compare B
	TCCR2B_WGM22 = 0x8  // Waveform Generation Mode
	TCCR2B_CS20  = 0x1  // Clock Select bits
	TCCR2B_CS21  = 0x2  // Clock Select bits
	TCCR2B_CS22  = 0x4  // Clock Select bits

	// ASSR: Asynchronous Status Register
	ASSR_EXCLK   = 0x40 // Enable External Clock Input
	ASSR_AS2     = 0x20 // Asynchronous Timer/Counter2
	ASSR_TCN2UB  = 0x10 // Timer/Counter2 Update Busy
	ASSR_OCR2AUB = 0x8  // Output Compare Register2 Update Busy
	ASSR_OCR2BUB = 0x4  // Output Compare Register 2 Update Busy
	ASSR_TCR2AUB = 0x2  // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2BUB = 0x1  // Timer/Counter Control Register2 Update Busy
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0 = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1 = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2 = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3 = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE = 0x10 // Watchdog Change Enable
	WDTCSR_WDE  = 0x8  // Watch Dog Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0 = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1 = 0x20 // EEPROM Programming Mode Bits
	EECR_EERIE = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE = 0x4  // EEPROM Master Write Enable
	EECR_EEPE  = 0x2  // EEPROM Write Enable
	EECR_EERE  = 0x1  // EEPROM Read Enable
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR5A: Timer/Counter5 Control Register A
	TCCR5A_COM5A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR5A_COM5A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR5A_COM5B0 = 0x10 // Compare Output Mode 5B, bits
	TCCR5A_COM5B1 = 0x20 // Compare Output Mode 5B, bits
	TCCR5A_COM5C0 = 0x4  // Compare Output Mode 5C, bits
	TCCR5A_COM5C1 = 0x8  // Compare Output Mode 5C, bits
	TCCR5A_WGM50  = 0x1  // Waveform Generation Mode
	TCCR5A_WGM51  = 0x2  // Waveform Generation Mode

	// TCCR5B: Timer/Counter5 Control Register B
	TCCR5B_ICNC5 = 0x80 // Input Capture 5 Noise Canceler
	TCCR5B_ICES5 = 0x40 // Input Capture 5 Edge Select
	TCCR5B_WGM50 = 0x8  // Waveform Generation Mode
	TCCR5B_WGM51 = 0x10 // Waveform Generation Mode
	TCCR5B_CS50  = 0x1  // Prescaler source of Timer/Counter 5
	TCCR5B_CS51  = 0x2  // Prescaler source of Timer/Counter 5
	TCCR5B_CS52  = 0x4  // Prescaler source of Timer/Counter 5

	// TCCR5C: Timer/Counter 5 Control Register C
	TCCR5C_FOC5A = 0x80 // Force Output Compare 5A
	TCCR5C_FOC5B = 0x40 // Force Output Compare 5B
	TCCR5C_FOC5C = 0x20 // Force Output Compare 5C

	// TIMSK5: Timer/Counter5 Interrupt Mask Register
	TIMSK5_ICIE5  = 0x20 // Timer/Counter5 Input Capture Interrupt Enable
	TIMSK5_OCIE5C = 0x8  // Timer/Counter5 Output Compare C Match Interrupt Enable
	TIMSK5_OCIE5B = 0x4  // Timer/Counter5 Output Compare B Match Interrupt Enable
	TIMSK5_OCIE5A = 0x2  // Timer/Counter5 Output Compare A Match Interrupt Enable
	TIMSK5_TOIE5  = 0x1  // Timer/Counter5 Overflow Interrupt Enable

	// TIFR5: Timer/Counter5 Interrupt Flag register
	TIFR5_ICF5  = 0x20 // Input Capture Flag 5
	TIFR5_OCF5C = 0x8  // Output Compare Flag 5C
	TIFR5_OCF5B = 0x4  // Output Compare Flag 5B
	TIFR5_OCF5A = 0x2  // Output Compare Flag 5A
	TIFR5_TOV5  = 0x1  // Timer/Counter5 Overflow Flag

	// TCCR4A: Timer/Counter4 Control Register A
	TCCR4A_COM4A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR4A_COM4A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR4A_COM4B0 = 0x10 // Compare Output Mode 4B, bits
	TCCR4A_COM4B1 = 0x20 // Compare Output Mode 4B, bits
	TCCR4A_COM4C0 = 0x4  // Compare Output Mode 4C, bits
	TCCR4A_COM4C1 = 0x8  // Compare Output Mode 4C, bits
	TCCR4A_WGM40  = 0x1  // Waveform Generation Mode
	TCCR4A_WGM41  = 0x2  // Waveform Generation Mode

	// TCCR4B: Timer/Counter4 Control Register B
	TCCR4B_ICNC4 = 0x80 // Input Capture 4 Noise Canceler
	TCCR4B_ICES4 = 0x40 // Input Capture 4 Edge Select
	TCCR4B_WGM40 = 0x8  // Waveform Generation Mode
	TCCR4B_WGM41 = 0x10 // Waveform Generation Mode
	TCCR4B_CS40  = 0x1  // Prescaler source of Timer/Counter 4
	TCCR4B_CS41  = 0x2  // Prescaler source of Timer/Counter 4
	TCCR4B_CS42  = 0x4  // Prescaler source of Timer/Counter 4

	// TCCR4C: Timer/Counter 4 Control Register C
	TCCR4C_FOC4A = 0x80 // Force Output Compare 4A
	TCCR4C_FOC4B = 0x40 // Force Output Compare 4B
	TCCR4C_FOC4C = 0x20 // Force Output Compare 4C

	// TIMSK4: Timer/Counter4 Interrupt Mask Register
	TIMSK4_ICIE4  = 0x20 // Timer/Counter4 Input Capture Interrupt Enable
	TIMSK4_OCIE4C = 0x8  // Timer/Counter4 Output Compare C Match Interrupt Enable
	TIMSK4_OCIE4B = 0x4  // Timer/Counter4 Output Compare B Match Interrupt Enable
	TIMSK4_OCIE4A = 0x2  // Timer/Counter4 Output Compare A Match Interrupt Enable
	TIMSK4_TOIE4  = 0x1  // Timer/Counter4 Overflow Interrupt Enable

	// TIFR4: Timer/Counter4 Interrupt Flag register
	TIFR4_ICF4  = 0x20 // Input Capture Flag 4
	TIFR4_OCF4C = 0x8  // Output Compare Flag 4C
	TIFR4_OCF4B = 0x4  // Output Compare Flag 4B
	TIFR4_OCF4A = 0x2  // Output Compare Flag 4A
	TIFR4_TOV4  = 0x1  // Timer/Counter4 Overflow Flag

	// TCCR3A: Timer/Counter3 Control Register A
	TCCR3A_COM3A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR3A_COM3A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR3A_COM3B0 = 0x10 // Compare Output Mode 3B, bits
	TCCR3A_COM3B1 = 0x20 // Compare Output Mode 3B, bits
	TCCR3A_COM3C0 = 0x4  // Compare Output Mode 3C, bits
	TCCR3A_COM3C1 = 0x8  // Compare Output Mode 3C, bits
	TCCR3A_WGM30  = 0x1  // Waveform Generation Mode
	TCCR3A_WGM31  = 0x2  // Waveform Generation Mode

	// TCCR3B: Timer/Counter3 Control Register B
	TCCR3B_ICNC3 = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICES3 = 0x40 // Input Capture 3 Edge Select
	TCCR3B_WGM30 = 0x8  // Waveform Generation Mode
	TCCR3B_WGM31 = 0x10 // Waveform Generation Mode
	TCCR3B_CS30  = 0x1  // Prescaler source of Timer/Counter 3
	TCCR3B_CS31  = 0x2  // Prescaler source of Timer/Counter 3
	TCCR3B_CS32  = 0x4  // Prescaler source of Timer/Counter 3

	// TCCR3C: Timer/Counter 3 Control Register C
	TCCR3C_FOC3A = 0x80 // Force Output Compare 3A
	TCCR3C_FOC3B = 0x40 // Force Output Compare 3B
	TCCR3C_FOC3C = 0x20 // Force Output Compare 3C

	// TIMSK3: Timer/Counter3 Interrupt Mask Register
	TIMSK3_ICIE3  = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_OCIE3C = 0x8  // Timer/Counter3 Output Compare C Match Interrupt Enable
	TIMSK3_OCIE3B = 0x4  // Timer/Counter3 Output Compare B Match Interrupt Enable
	TIMSK3_OCIE3A = 0x2  // Timer/Counter3 Output Compare A Match Interrupt Enable
	TIMSK3_TOIE3  = 0x1  // Timer/Counter3 Overflow Interrupt Enable

	// TIFR3: Timer/Counter3 Interrupt Flag register
	TIFR3_ICF3  = 0x20 // Input Capture Flag 3
	TIFR3_OCF3C = 0x8  // Output Compare Flag 3C
	TIFR3_OCF3B = 0x4  // Output Compare Flag 3B
	TIFR3_OCF3A = 0x2  // Output Compare Flag 3A
	TIFR3_TOV3  = 0x1  // Timer/Counter3 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0 = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1 = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1C0 = 0x4  // Compare Output Mode 1C, bits
	TCCR1A_COM1C1 = 0x8  // Compare Output Mode 1C, bits
	TCCR1A_WGM10  = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11  = 0x2  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1 = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1 = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10 = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11 = 0x10 // Waveform Generation Mode
	TCCR1B_CS10  = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11  = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12  = 0x4  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter 1 Control Register C
	TCCR1C_FOC1A = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1B = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1C = 0x20 // Force Output Compare 1C

	// TIMSK1: Timer/Counter1 Interrupt Mask Register
	TIMSK1_ICIE1  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1C = 0x8  // Timer/Counter1 Output Compare C Match Interrupt Enable
	TIMSK1_OCIE1B = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1A = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_TOIE1  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter1 Interrupt Flag register
	TIFR1_ICF1  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1C = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1B = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1  = 0x1  // Timer/Counter1 Overflow Flag
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register A
	EICRA_ISC30 = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31 = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC20 = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21 = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC10 = 0x4  // External Interrupt Sense Control Bit
	EICRA_ISC11 = 0x8  // External Interrupt Sense Control Bit
	EICRA_ISC00 = 0x1  // External Interrupt Sense Control Bit
	EICRA_ISC01 = 0x2  // External Interrupt Sense Control Bit

	// EICRB: External Interrupt Control Register B
	EICRB_ISC70 = 0x40 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC71 = 0x80 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC60 = 0x10 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC61 = 0x20 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC50 = 0x4  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC51 = 0x8  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC40 = 0x1  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC41 = 0x2  // External Interrupt 7-4 Sense Control Bit

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0 = 0x1  // External Interrupt Request 7 Enable
	EIMSK_INT1 = 0x2  // External Interrupt Request 7 Enable
	EIMSK_INT2 = 0x4  // External Interrupt Request 7 Enable
	EIMSK_INT3 = 0x8  // External Interrupt Request 7 Enable
	EIMSK_INT4 = 0x10 // External Interrupt Request 7 Enable
	EIMSK_INT5 = 0x20 // External Interrupt Request 7 Enable
	EIMSK_INT6 = 0x40 // External Interrupt Request 7 Enable
	EIMSK_INT7 = 0x80 // External Interrupt Request 7 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0 = 0x1  // External Interrupt Flags
	EIFR_INTF1 = 0x2  // External Interrupt Flags
	EIFR_INTF2 = 0x4  // External Interrupt Flags
	EIFR_INTF3 = 0x8  // External Interrupt Flags
	EIFR_INTF4 = 0x10 // External Interrupt Flags
	EIFR_INTF5 = 0x20 // External Interrupt Flags
	EIFR_INTF6 = 0x40 // External Interrupt Flags
	EIFR_INTF7 = 0x80 // External Interrupt Flags

	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0 = 0x1  // Pin Change Mask interrupt
	PCMSK2_PCINT1 = 0x2  // Pin Change Mask interrupt
	PCMSK2_PCINT2 = 0x4  // Pin Change Mask interrupt
	PCMSK2_PCINT3 = 0x8  // Pin Change Mask interrupt
	PCMSK2_PCINT4 = 0x10 // Pin Change Mask interrupt
	PCMSK2_PCINT5 = 0x20 // Pin Change Mask interrupt
	PCMSK2_PCINT6 = 0x40 // Pin Change Mask interrupt
	PCMSK2_PCINT7 = 0x80 // Pin Change Mask interrupt

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0 = 0x1  // Pin Change Mask interrupt
	PCMSK1_PCINT1 = 0x2  // Pin Change Mask interrupt
	PCMSK1_PCINT2 = 0x4  // Pin Change Mask interrupt
	PCMSK1_PCINT3 = 0x8  // Pin Change Mask interrupt
	PCMSK1_PCINT4 = 0x10 // Pin Change Mask interrupt
	PCMSK1_PCINT5 = 0x20 // Pin Change Mask interrupt
	PCMSK1_PCINT6 = 0x40 // Pin Change Mask interrupt
	PCMSK1_PCINT7 = 0x80 // Pin Change Mask interrupt

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0 = 0x1  // Pin Change Mask interrupt
	PCMSK0_PCINT1 = 0x2  // Pin Change Mask interrupt
	PCMSK0_PCINT2 = 0x4  // Pin Change Mask interrupt
	PCMSK0_PCINT3 = 0x8  // Pin Change Mask interrupt
	PCMSK0_PCINT4 = 0x10 // Pin Change Mask interrupt
	PCMSK0_PCINT5 = 0x20 // Pin Change Mask interrupt
	PCMSK0_PCINT6 = 0x40 // Pin Change Mask interrupt
	PCMSK0_PCINT7 = 0x80 // Pin Change Mask interrupt

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0 = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1 = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF2 = 0x4 // Pin Change Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0 = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1 = 0x2 // Pin Change Interrupt Enables
	PCICR_PCIE2 = 0x4 // Pin Change Interrupt Enables
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I = 0x80 // Global Interrupt Enable
	SREG_T = 0x40 // Bit Copy Storage
	SREG_H = 0x20 // Half Carry Flag
	SREG_S = 0x10 // Sign Bit
	SREG_V = 0x8  // Two's Complement Overflow Flag
	SREG_N = 0x4  // Negative Flag
	SREG_Z = 0x2  // Zero Flag
	SREG_C = 0x1  // Carry Flag

	// XMCRA: External Memory Control Register A
	XMCRA_SRE   = 0x80 // External SRAM Enable
	XMCRA_SRL0  = 0x10 // Wait state page limit
	XMCRA_SRL1  = 0x20 // Wait state page limit
	XMCRA_SRL2  = 0x40 // Wait state page limit
	XMCRA_SRW10 = 0x4  // Wait state select bit upper page
	XMCRA_SRW11 = 0x8  // Wait state select bit upper page
	XMCRA_SRW00 = 0x1  // Wait state select bit lower page
	XMCRA_SRW01 = 0x2  // Wait state select bit lower page

	// XMCRB: External Memory Control Register B
	XMCRB_XMBK = 0x80 // External Memory Bus Keeper Enable
	XMCRB_XMM0 = 0x1  // External Memory High Mask
	XMCRB_XMM1 = 0x2  // External Memory High Mask
	XMCRB_XMM2 = 0x4  // External Memory High Mask

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0 = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1 = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2 = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3 = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4 = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5 = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6 = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7 = 0x80 // Oscillator Calibration

	// CLKPR
	CLKPR_CLKPCE = 0x80
	CLKPR_CLKPS0 = 0x1
	CLKPR_CLKPS1 = 0x2
	CLKPR_CLKPS2 = 0x4
	CLKPR_CLKPS3 = 0x8

	// SMCR: Sleep Mode Control Register
	SMCR_SM0 = 0x2 // Sleep Mode Select bits
	SMCR_SM1 = 0x4 // Sleep Mode Select bits
	SMCR_SM2 = 0x8 // Sleep Mode Select bits
	SMCR_SE  = 0x1 // Sleep Enable

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0 = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1 = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2 = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3 = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4 = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5 = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6 = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7 = 0x80 // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0 = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1 = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2 = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3 = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4 = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5 = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6 = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7 = 0x80 // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07 = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06 = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05 = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04 = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03 = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02 = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01 = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00 = 0x1  // General Purpose IO Register 0 bit 0

	// PRR1: Power Reduction Register1
	PRR1_PRTIM5   = 0x20 // Power Reduction Timer/Counter5
	PRR1_PRTIM4   = 0x10 // Power Reduction Timer/Counter4
	PRR1_PRTIM3   = 0x8  // Power Reduction Timer/Counter3
	PRR1_PRUSART3 = 0x4  // Power Reduction USART3
	PRR1_PRUSART2 = 0x2  // Power Reduction USART2
	PRR1_PRUSART1 = 0x1  // Power Reduction USART1

	// PRR0: Power Reduction Register0
	PRR0_PRTWI    = 0x80 // Power Reduction TWI
	PRR0_PRTIM2   = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM0   = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM1   = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRSPI    = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRUSART0 = 0x2  // Power Reduction USART0
	PRR0_PRADC    = 0x1  // Power Reduction ADC
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0 = 0x40 // Reference Selection Bits
	ADMUX_REFS1 = 0x80 // Reference Selection Bits
	ADMUX_ADLAR = 0x20 // Left Adjust Result
	ADMUX_MUX0  = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1  = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2  = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3  = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4  = 0x10 // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register A
	ADCSRA_ADEN  = 0x80 // ADC Enable
	ADCSRA_ADSC  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE = 0x20 // ADC  Auto Trigger Enable
	ADCSRA_ADIF  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0 = 0x1  // ADC  Prescaler Select Bits
	ADCSRA_ADPS1 = 0x2  // ADC  Prescaler Select Bits
	ADCSRA_ADPS2 = 0x4  // ADC  Prescaler Select Bits

	// DIDR2: Digital Input Disable Register
	DIDR2_ADC15D = 0x80
	DIDR2_ADC14D = 0x40
	DIDR2_ADC13D = 0x20
	DIDR2_ADC12D = 0x10
	DIDR2_ADC11D = 0x8
	DIDR2_ADC10D = 0x4
	DIDR2_ADC9D  = 0x2
	DIDR2_ADC8D  = 0x1

	// DIDR0: Digital Input Disable Register
	DIDR0_ADC7D = 0x80
	DIDR0_ADC6D = 0x40
	DIDR0_ADC5D = 0x20
	DIDR0_ADC4D = 0x10
	DIDR0_ADC3D = 0x8
	DIDR0_ADC2D = 0x4
	DIDR0_ADC1D = 0x2
	DIDR0_ADC0D = 0x1
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT  = 0x4  // Page Write
	SPMCSR_PGERS  = 0x2  // Page Erase
	SPMCSR_SPMEN  = 0x1  // Store Program Memory Enable
)
