"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const sinon = require("sinon");
const sinonChai = require("sinon-chai");
const chai = require("chai");
const yamlCommands_1 = require("../src/languageservice/services/yamlCommands");
const commandExecutor_1 = require("../src/languageserver/commandExecutor");
const vscode_uri_1 = require("vscode-uri");
const expect = chai.expect;
chai.use(sinonChai);
describe('Yaml Commands', () => {
    const JSON_SCHEMA_LOCAL = 'file://some/path/schema.json';
    const sandbox = sinon.createSandbox();
    let commandExecutorStub;
    beforeEach(() => {
        commandExecutorStub = sandbox.stub(commandExecutor_1.commandExecutor, 'registerCommand');
    });
    afterEach(() => {
        sandbox.restore();
    });
    it('should register handler for "JumpToSchema" command', () => {
        yamlCommands_1.registerCommands(commandExecutor_1.commandExecutor, {});
        expect(commandExecutorStub).to.have.been.calledWithMatch(sinon.match('jumpToSchema'), sinon.match.func);
    });
    it('JumpToSchema handler should call "showDocument"', () => __awaiter(void 0, void 0, void 0, function* () {
        const showDocumentStub = sandbox.stub();
        const connection = {
            window: {
                showDocument: showDocumentStub,
            },
        };
        showDocumentStub.resolves(true);
        yamlCommands_1.registerCommands(commandExecutor_1.commandExecutor, connection);
        const arg = commandExecutorStub.args[0];
        yield arg[1](JSON_SCHEMA_LOCAL);
        expect(showDocumentStub).to.have.been.calledWith({ uri: JSON_SCHEMA_LOCAL, external: false, takeFocus: true });
    }));
    it('JumpToSchema handler should call "showDocument" with plain win path', () => __awaiter(void 0, void 0, void 0, function* () {
        const showDocumentStub = sandbox.stub();
        const connection = {
            window: {
                showDocument: showDocumentStub,
            },
        };
        showDocumentStub.resolves(true);
        yamlCommands_1.registerCommands(commandExecutor_1.commandExecutor, connection);
        const arg = commandExecutorStub.args[0];
        yield arg[1]('a:\\some\\path\\to\\schema.json');
        expect(showDocumentStub).to.have.been.calledWith({
            uri: vscode_uri_1.URI.file('a:\\some\\path\\to\\schema.json').toString(),
            external: false,
            takeFocus: true,
        });
    }));
});
//# sourceMappingURL=yamlCommands.test.js.map