set(SndFile_VERSION 1.0.31)
set(SndFile_VERSION_MAJOR 1)
set(SndFile_VERSION_MINOR 0)
set(SndFile_VERSION_PATCH 31)

set (SndFile_WITH_EXTERNAL_LIBS 1)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was SndFileConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/SndFile" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include (CMakeFindDependencyMacro)

if (SndFile_WITH_EXTERNAL_LIBS AND NOT ON)
	find_dependency (Ogg 1.3)
	find_dependency (Vorbis)
	find_dependency (FLAC)
	find_dependency (Opus)
endif ()

include (${CMAKE_CURRENT_LIST_DIR}/SndFileTargets.cmake)

set_and_check (SndFile_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set (SNDFILE_INCLUDE_DIR ${SndFile_INCLUDE_DIR})

set (SndFile_LIBRARY SndFile::sndfile)
set (SNDFILE_LIBRARY SndFile::sndfile)
set (SndFile_LIBRARIES SndFile::sndfile)
set (SNDFILE_LIBRARIES SndFile::sndfile)


check_required_components(SndFile)

set (SNDFILE_FOUND 1)
