/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogRecord;
import org.apache.juli.FileHandler;

public class AsyncFileHandler
extends FileHandler {
    public static final int OVERFLOW_DROP_LAST = 1;
    public static final int OVERFLOW_DROP_FIRST = 2;
    public static final int OVERFLOW_DROP_FLUSH = 3;
    public static final int OVERFLOW_DROP_CURRENT = 4;
    public static final int DEFAULT_OVERFLOW_DROP_TYPE = 1;
    public static final int DEFAULT_MAX_RECORDS = 10000;
    public static final int DEFAULT_LOGGER_SLEEP_TIME = 1000;
    public static final int OVERFLOW_DROP_TYPE = Integer.parseInt(System.getProperty("org.apache.juli.AsyncOverflowDropType", Integer.toString(1)));
    public static final int MAX_RECORDS = Integer.parseInt(System.getProperty("org.apache.juli.AsyncMaxRecordCount", Integer.toString(10000)));
    public static final int LOGGER_SLEEP_TIME = Integer.parseInt(System.getProperty("org.apache.juli.AsyncLoggerPollInterval", Integer.toString(1000)));
    protected static final LinkedBlockingDeque<LogEntry> queue = new LinkedBlockingDeque(MAX_RECORDS);
    protected static final LoggerThread logger = new LoggerThread();
    protected volatile boolean closed = false;

    public AsyncFileHandler() {
        this(null, null, null);
    }

    public AsyncFileHandler(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public AsyncFileHandler(String string, String string2, String string3, Integer n) {
        super(string, string2, string3, n);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
    }

    @Override
    public void open() {
        if (!this.closed) {
            return;
        }
        this.closed = false;
        super.open();
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        logRecord.getSourceMethodName();
        LogEntry logEntry = new LogEntry(logRecord, this);
        boolean bl = false;
        try {
            while (!bl && !queue.offer(logEntry)) {
                switch (OVERFLOW_DROP_TYPE) {
                    case 1: {
                        queue.pollLast();
                        break;
                    }
                    case 2: {
                        queue.pollFirst();
                        break;
                    }
                    case 3: {
                        bl = queue.offer(logEntry, 1000L, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case 4: {
                        bl = true;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void publishInternal(LogRecord logRecord) {
        super.publish(logRecord);
    }

    static {
        logger.start();
    }

    protected static class LogEntry {
        private final LogRecord record;
        private final AsyncFileHandler handler;

        public LogEntry(LogRecord logRecord, AsyncFileHandler asyncFileHandler) {
            this.record = logRecord;
            this.handler = asyncFileHandler;
        }

        public boolean flush() {
            if (this.handler.closed) {
                return false;
            }
            this.handler.publishInternal(this.record);
            return true;
        }
    }

    protected static class LoggerThread
    extends Thread {
        public LoggerThread() {
            this.setDaemon(true);
            this.setName("AsyncFileHandlerWriter-" + System.identityHashCode(this));
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        LogEntry logEntry;
                        if ((logEntry = queue.poll(LOGGER_SLEEP_TIME, TimeUnit.MILLISECONDS)) == null) {
                            continue;
                        }
                        logEntry.flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

