/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tomcat.dbcp.pool2.impl.CallStack;

public class SecurityManagerCallStack
implements CallStack {
    private final String messageFormat;
    private final DateFormat dateFormat;
    private final PrivateSecurityManager securityManager;
    private volatile Snapshot snapshot;

    public SecurityManagerCallStack(String string, boolean bl) {
        this.messageFormat = string;
        this.dateFormat = bl ? new SimpleDateFormat(string) : null;
        this.securityManager = AccessController.doPrivileged(() -> new PrivateSecurityManager());
    }

    @Override
    public void clear() {
        this.snapshot = null;
    }

    @Override
    public void fillInStackTrace() {
        this.snapshot = new Snapshot(this.securityManager.getCallStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean printStackTrace(PrintWriter printWriter) {
        String string;
        Snapshot snapshot = this.snapshot;
        if (snapshot == null) {
            return false;
        }
        if (this.dateFormat == null) {
            string = this.messageFormat;
        } else {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                string = this.dateFormat.format(snapshot.timestampMillis);
            }
        }
        printWriter.println(string);
        snapshot.stack.forEach(weakReference -> printWriter.println(weakReference.get()));
        return true;
    }

    private static class Snapshot {
        private final long timestampMillis = System.currentTimeMillis();
        private final List<WeakReference<Class<?>>> stack;

        private Snapshot(List<WeakReference<Class<?>>> list) {
            this.stack = list;
        }
    }

    private static class PrivateSecurityManager
    extends SecurityManager {
        private PrivateSecurityManager() {
        }

        private List<WeakReference<Class<?>>> getCallStack() {
            Stream<WeakReference> stream = Stream.of(this.getClassContext()).map(WeakReference::new);
            return stream.collect(Collectors.toList());
        }
    }
}

