/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.HostnameUtil;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PKIXUtil;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.jsse.provider.X509TrustManagerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvX509TrustManager
extends BCX509ExtendedTrustManager {
    private static final Logger LOG = Logger.getLogger(ProvX509TrustManager.class.getName());
    private static final boolean provCheckRevocation = PropertyUtils.getBooleanSystemProperty("com.sun.net.ssl.checkRevocation", false);
    private static final boolean provTrustManagerCheckEKU = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.trustManager.checkEKU", true);
    private static final Map<String, Integer> keyUsagesServer = ProvX509TrustManager.createKeyUsagesServer();
    private final boolean isInFipsMode;
    private final JcaJceHelper helper;
    private final Set<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParametersTemplate;
    private final X509TrustManager exportX509TrustManager;

    private static void addKeyUsageServer(Map<String, Integer> map, int n, int ... nArray) {
        for (int n2 : nArray) {
            String string = JsseUtils.getAuthTypeServer(n2);
            if (null == map.put(string, n)) continue;
            throw new IllegalStateException("Duplicate keys in server key usages");
        }
    }

    private static Map<String, Integer> createKeyUsagesServer() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ProvX509TrustManager.addKeyUsageServer(hashMap, 0, 3, 5, 17, 19, 0);
        ProvX509TrustManager.addKeyUsageServer(hashMap, 2, 1);
        ProvX509TrustManager.addKeyUsageServer(hashMap, 4, 7, 9, 16, 18);
        return Collections.unmodifiableMap(hashMap);
    }

    ProvX509TrustManager(boolean bl, JcaJceHelper jcaJceHelper, Set<TrustAnchor> set) throws InvalidAlgorithmParameterException {
        this.isInFipsMode = bl;
        this.helper = jcaJceHelper;
        this.trustedCerts = ProvX509TrustManager.getTrustedCerts(set);
        if (this.trustedCerts.isEmpty()) {
            this.pkixParametersTemplate = null;
        } else {
            this.pkixParametersTemplate = new PKIXBuilderParameters(set, null);
            this.pkixParametersTemplate.setRevocationEnabled(provCheckRevocation);
        }
        this.exportX509TrustManager = X509TrustManagerUtil.exportX509TrustManager(this);
    }

    ProvX509TrustManager(boolean bl, JcaJceHelper jcaJceHelper, PKIXParameters pKIXParameters) throws InvalidAlgorithmParameterException {
        this.isInFipsMode = bl;
        this.helper = jcaJceHelper;
        this.trustedCerts = ProvX509TrustManager.getTrustedCerts(pKIXParameters.getTrustAnchors());
        if (this.trustedCerts.isEmpty()) {
            this.pkixParametersTemplate = null;
        } else if (pKIXParameters instanceof PKIXBuilderParameters) {
            this.pkixParametersTemplate = (PKIXBuilderParameters)pKIXParameters;
        } else {
            this.pkixParametersTemplate = new PKIXBuilderParameters(pKIXParameters.getTrustAnchors(), null);
            this.pkixParametersTemplate.setAnyPolicyInhibited(pKIXParameters.isAnyPolicyInhibited());
            this.pkixParametersTemplate.setCertPathCheckers(pKIXParameters.getCertPathCheckers());
            this.pkixParametersTemplate.setCertStores(pKIXParameters.getCertStores());
            this.pkixParametersTemplate.setDate(pKIXParameters.getDate());
            this.pkixParametersTemplate.setExplicitPolicyRequired(pKIXParameters.isExplicitPolicyRequired());
            this.pkixParametersTemplate.setInitialPolicies(pKIXParameters.getInitialPolicies());
            this.pkixParametersTemplate.setPolicyMappingInhibited(pKIXParameters.isPolicyMappingInhibited());
            this.pkixParametersTemplate.setPolicyQualifiersRejected(pKIXParameters.getPolicyQualifiersRejected());
            this.pkixParametersTemplate.setRevocationEnabled(pKIXParameters.isRevocationEnabled());
            this.pkixParametersTemplate.setSigProvider(pKIXParameters.getSigProvider());
        }
        this.exportX509TrustManager = X509TrustManagerUtil.exportX509TrustManager(this);
    }

    X509TrustManager getExportX509TrustManager() {
        return this.exportX509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, null, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, TransportData.from(socket), false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, TransportData.from(sSLEngine), false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, TransportData.from(socket), true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, TransportData.from(sSLEngine), true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustedCerts.toArray(new X509Certificate[this.trustedCerts.size()]);
    }

    private X509Certificate[] buildCertPath(X509Certificate[] x509CertificateArray, BCAlgorithmConstraints bCAlgorithmConstraints, List<byte[]> list) throws GeneralSecurityException {
        CertPathBuilder certPathBuilder;
        CertStore certStore;
        X509Certificate x509Certificate = x509CertificateArray[0];
        if (this.trustedCerts.contains(x509Certificate)) {
            return new X509Certificate[]{x509Certificate};
        }
        CertificateFactory certificateFactory = this.helper.createCertificateFactory("X.509");
        Provider provider = certificateFactory.getProvider();
        CertStoreParameters certStoreParameters = this.getCertStoreParameters(x509Certificate, x509CertificateArray);
        try {
            certStore = CertStore.getInstance("Collection", certStoreParameters, provider);
        }
        catch (GeneralSecurityException generalSecurityException) {
            certStore = CertStore.getInstance("Collection", certStoreParameters);
        }
        try {
            certPathBuilder = CertPathBuilder.getInstance("PKIX", provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            certPathBuilder = CertPathBuilder.getInstance("PKIX");
        }
        PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.pkixParametersTemplate.clone();
        pKIXBuilderParameters.addCertPathChecker(new ProvAlgorithmChecker(this.isInFipsMode, this.helper, bCAlgorithmConstraints));
        pKIXBuilderParameters.addCertStore(certStore);
        pKIXBuilderParameters.setTargetCertConstraints(ProvX509TrustManager.createTargetCertConstraints(x509Certificate, pKIXBuilderParameters.getTargetCertConstraints()));
        if (!list.isEmpty()) {
            ProvX509TrustManager.addStatusResponses(certPathBuilder, pKIXBuilderParameters, x509CertificateArray, list);
        }
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
        return ProvX509TrustManager.getTrustedChain(pKIXCertPathBuilderResult.getCertPath(), pKIXCertPathBuilderResult.getTrustAnchor());
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, TransportData transportData, boolean bl) throws CertificateException {
        if (null == x509CertificateArray || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException("'chain' must be a chain of at least one certificate");
        }
        if (null == string || string.length() < 1) {
            throw new IllegalArgumentException("'authType' must be a non-null, non-empty string");
        }
        if (null == this.pkixParametersTemplate) {
            throw new CertificateException("Unable to build a CertPath: no PKIXBuilderParameters available");
        }
        X509Certificate[] x509CertificateArray2 = this.validateChain(x509CertificateArray, string, transportData, bl);
        ProvX509TrustManager.checkExtendedTrust(x509CertificateArray2, string, transportData, bl);
    }

    private CertStoreParameters getCertStoreParameters(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(x509CertificateArray.length);
        arrayList.add(x509Certificate);
        for (int i = 1; i < x509CertificateArray.length; ++i) {
            if (this.trustedCerts.contains(x509CertificateArray[i])) continue;
            arrayList.add(x509CertificateArray[i]);
        }
        return new CollectionCertStoreParameters(Collections.unmodifiableCollection(arrayList));
    }

    private X509Certificate[] validateChain(X509Certificate[] x509CertificateArray, String string, TransportData transportData, boolean bl) throws CertificateException {
        try {
            BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, false);
            List<byte[]> list = TransportData.getStatusResponses(transportData);
            X509Certificate[] x509CertificateArray2 = this.buildCertPath(x509CertificateArray, bCAlgorithmConstraints, list);
            KeyPurposeId keyPurposeId = ProvX509TrustManager.getRequiredExtendedKeyUsage(bl);
            int n = ProvX509TrustManager.getRequiredKeyUsage(bl, string);
            ProvAlgorithmChecker.checkCertPathExtras(this.helper, bCAlgorithmConstraints, x509CertificateArray2, keyPurposeId, n);
            return x509CertificateArray2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateException("Unable to construct a valid chain", generalSecurityException);
        }
    }

    static void checkEndpointID(String string, X509Certificate x509Certificate, String string2) throws CertificateException {
        string = JsseUtils.stripSquareBrackets(string);
        if (string2.equalsIgnoreCase("HTTPS")) {
            HostnameUtil.checkHostname(string, x509Certificate, true);
        } else if (string2.equalsIgnoreCase("LDAP") || string2.equalsIgnoreCase("LDAPS")) {
            HostnameUtil.checkHostname(string, x509Certificate, false);
        } else {
            throw new CertificateException("Unknown endpoint ID algorithm: " + string2);
        }
    }

    static void checkExtendedTrust(X509Certificate[] x509CertificateArray, String string, TransportData transportData, boolean bl) throws CertificateException {
        BCSSLParameters bCSSLParameters;
        String string2;
        if (null != transportData && null != (string2 = (bCSSLParameters = transportData.getParameters()).getEndpointIdentificationAlgorithm()) && string2.length() > 0) {
            BCExtendedSSLSession bCExtendedSSLSession = transportData.getHandshakeSession();
            if (null == bCExtendedSSLSession) {
                throw new CertificateException("No handshake session");
            }
            ProvX509TrustManager.checkEndpointID(x509CertificateArray[0], string2, bl, bCExtendedSSLSession);
        }
    }

    static KeyPurposeId getRequiredExtendedKeyUsage(boolean bl) {
        return !provTrustManagerCheckEKU ? null : (bl ? KeyPurposeId.id_kp_serverAuth : KeyPurposeId.id_kp_clientAuth);
    }

    static int getRequiredKeyUsage(boolean bl, String string) throws CertificateException {
        if (!bl) {
            return 0;
        }
        Integer n = keyUsagesServer.get(string);
        if (null == n) {
            throw new CertificateException("Unsupported server authType: " + string);
        }
        return n;
    }

    private static void addStatusResponses(CertPathBuilder certPathBuilder, PKIXBuilderParameters pKIXBuilderParameters, X509Certificate[] x509CertificateArray, List<byte[]> list) {
        HashMap<X509Certificate, byte[]> hashMap = new HashMap<X509Certificate, byte[]>();
        int n = Math.min(x509CertificateArray.length, list.size());
        for (int i = 0; i < n; ++i) {
            X509Certificate x509Certificate;
            byte[] byArray = list.get(i);
            if (null == byArray || byArray.length <= 0 || hashMap.containsKey(x509Certificate = x509CertificateArray[i])) continue;
            hashMap.put(x509Certificate, byArray);
        }
        if (!hashMap.isEmpty()) {
            try {
                PKIXUtil.addStatusResponses(certPathBuilder, pKIXBuilderParameters, hashMap);
            }
            catch (RuntimeException runtimeException) {
                LOG.log(Level.FINE, "Failed to add status responses for revocation checking", runtimeException);
            }
        }
    }

    private static void checkEndpointID(X509Certificate x509Certificate, String string, boolean bl, BCExtendedSSLSession bCExtendedSSLSession) throws CertificateException {
        String string2;
        BCSNIHostName bCSNIHostName;
        String string3 = bCExtendedSSLSession.getPeerHost();
        if (bl && null != (bCSNIHostName = JsseUtils.getSNIHostName(bCExtendedSSLSession.getRequestedServerNames())) && !(string2 = bCSNIHostName.getAsciiName()).equalsIgnoreCase(string3)) {
            try {
                ProvX509TrustManager.checkEndpointID(string2, x509Certificate, string);
                return;
            }
            catch (CertificateException certificateException) {
                LOG.log(Level.FINE, "Server's endpoint ID did not match the SNI host_name: " + string2, certificateException);
            }
        }
        ProvX509TrustManager.checkEndpointID(string3, x509Certificate, string);
    }

    private static X509CertSelector createTargetCertConstraints(final X509Certificate x509Certificate, final CertSelector certSelector) {
        return new X509CertSelector(){
            {
                this.setCertificate(x509Certificate);
            }

            public boolean match(Certificate certificate) {
                return super.match(certificate) && (null == certSelector || certSelector.match(certificate));
            }
        };
    }

    private static X509Certificate getTrustedCert(TrustAnchor trustAnchor) throws CertificateException {
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (null == x509Certificate) {
            throw new CertificateException("No certificate for TrustAnchor");
        }
        return x509Certificate;
    }

    private static Set<X509Certificate> getTrustedCerts(Set<TrustAnchor> set) {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>(set.size());
        for (TrustAnchor trustAnchor : set) {
            X509Certificate x509Certificate;
            if (null == trustAnchor || null == (x509Certificate = trustAnchor.getTrustedCert())) continue;
            hashSet.add(x509Certificate);
        }
        return hashSet;
    }

    private static X509Certificate[] getTrustedChain(CertPath certPath, TrustAnchor trustAnchor) throws CertificateException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = new X509Certificate[list.size() + 1];
        list.toArray(x509CertificateArray);
        x509CertificateArray[x509CertificateArray.length - 1] = ProvX509TrustManager.getTrustedCert(trustAnchor);
        return x509CertificateArray;
    }
}

