/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.jcip.annotations.NotThreadSafe;
import org.dom4j.Element;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketExtension;

@NotThreadSafe
public class IQ
extends Packet {
    private static final Logger Log = LoggerFactory.getLogger(Packet.class);
    private static int sequence = 0;
    private static Random random = new Random();

    public IQ() {
        this.element = docFactory.createDocument().addElement("iq");
        String id = random.nextInt(1000) + "-" + sequence++;
        this.setType(Type.get);
        this.setID(id);
    }

    public IQ(Type type) {
        this.element = docFactory.createDocument().addElement("iq");
        this.setType(type);
        String id = random.nextInt(1000) + "-" + sequence++;
        this.setID(id);
    }

    public IQ(Type type, String ID) {
        this.element = docFactory.createDocument().addElement("iq");
        this.setType(type);
        this.setID(ID);
    }

    public IQ(Element element) {
        super(element);
    }

    public IQ(Element element, boolean skipValidation) {
        super(element, skipValidation);
    }

    private IQ(IQ iq) {
        Element elementCopy = iq.element.createCopy();
        docFactory.createDocument().add(elementCopy);
        this.element = elementCopy;
        this.toJID = iq.toJID;
        this.fromJID = iq.fromJID;
    }

    public Type getType() {
        String type = this.element.attributeValue("type");
        if (type != null) {
            return Type.valueOf(type);
        }
        return null;
    }

    public void setType(Type type) {
        this.element.addAttribute("type", type == null ? null : type.toString());
    }

    public boolean isRequest() {
        Type type = this.getType();
        return type != null && (type.equals((Object)Type.get) || type.equals((Object)Type.set));
    }

    public boolean isResponse() {
        Type type = this.getType();
        return type != null && (type.equals((Object)Type.result) || type.equals((Object)Type.error));
    }

    public Element getChildElement() {
        List elements = this.element.elements();
        if (elements.isEmpty()) {
            return null;
        }
        for (Element element : elements) {
            String namespace = element.getNamespaceURI();
            if (namespace.equals("") || namespace.equals("jabber:client") || namespace.equals("jabber:server")) continue;
            return element;
        }
        return null;
    }

    public void setChildElement(Element childElement) {
        Iterator i = this.element.elementIterator();
        while (i.hasNext()) {
            this.element.remove((Element)i.next());
        }
        this.element.add(childElement);
    }

    public Element setChildElement(String name, String namespace) {
        Iterator i = this.element.elementIterator();
        while (i.hasNext()) {
            this.element.remove((Element)i.next());
        }
        return this.element.addElement(name, namespace);
    }

    @Override
    public void addExtension(PacketExtension extension) {
        Element childElement = this.getChildElement();
        if (childElement == null) {
            throw new IllegalStateException("Cannot add packet extension when child element is null");
        }
        childElement.add(extension.getElement());
    }

    @Override
    public PacketExtension getExtension(String name, String namespace) {
        Class<? extends PacketExtension> extensionClass;
        Element childElement = this.getChildElement();
        if (childElement == null) {
            return null;
        }
        List extensions = childElement.elements(QName.get((String)name, (String)namespace));
        if (!extensions.isEmpty() && (extensionClass = PacketExtension.getExtensionClass(name, namespace)) != null) {
            try {
                Constructor<? extends PacketExtension> constructor = extensionClass.getDeclaredConstructor(Element.class);
                return constructor.newInstance(extensions.get(0));
            }
            catch (Exception e) {
                Log.warn("Packet extension (name " + name + ", namespace " + namespace + ") cannot be found.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean deleteExtension(String name, String namespace) {
        Element childElement = this.getChildElement();
        if (childElement == null) {
            return false;
        }
        List extensions = childElement.elements(QName.get((String)name, (String)namespace));
        if (!extensions.isEmpty()) {
            childElement.remove((Element)extensions.get(0));
            return true;
        }
        return false;
    }

    @Override
    public IQ createCopy() {
        return new IQ(this);
    }

    public static IQ createResultIQ(IQ iq) {
        if (iq.getType() != Type.get && iq.getType() != Type.set) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + iq.toXML());
        }
        IQ result = new IQ(Type.result, iq.getID());
        result.setFrom(iq.getTo());
        result.setTo(iq.getFrom());
        return result;
    }

    public static enum Type {
        get,
        set,
        result,
        error;

    }
}

