/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NotNull
    public static List<PsiClassType> getThrownExceptions(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            @Override
            public void visitElement(@NotNull PsiElement psiElement) {
                PsiElement parent2;
                if (psiElement == null) {
                    Visitor.$$$reportNull$$$0(0);
                }
                if (psiElement != element && (parent2 = psiElement.getParent()) instanceof PsiAnonymousClass && !(psiElement instanceof PsiExpressionList)) {
                    return;
                }
                super.visitElement(psiElement);
            }

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                this.visitElement(aClass);
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodRef = expression2.getMethodExpression();
                JavaResolveResult resolveResult = methodRef.advancedResolve(false);
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression2);
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression2) {
                JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression2);
            }

            @Override
            public void visitThrowStatement(PsiThrowStatement statement2) {
                PsiExpression expr = statement2.getException();
                if (expr != null) {
                    ExceptionUtil.addExceptions(result2, StreamEx.of(ExceptionUtil.getPreciseThrowTypes(expr)).select(PsiClassType.class).toList());
                }
                super.visitThrowStatement(statement2);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            @Override
            public void visitResourceList(PsiResourceList resourceList) {
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            @Override
            public void visitTryStatement(PsiTryStatement statement2) {
                ExceptionUtil.addExceptions(result2, ExceptionUtil.getTryExceptions(statement2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/ExceptionUtil$1Visitor", "visitElement"));
            }
        }
        element.accept(new Visitor());
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement psiResourceListElement : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(psiResourceListElement, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiCodeBlock));
        }
        PsiCodeBlock psiCodeBlock = tryStatement.getFinallyBlock();
        if (psiCodeBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(psiCodeBlock.getProject()).getControlFlow(psiCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list2 = ExceptionUtil.getThrownExceptions(psiCodeBlock);
                if (!BitUtil.isSet(completionReasons, 1)) {
                    array = new ArrayList<PsiClassType>(list2);
                } else {
                    ExceptionUtil.addExceptions(array, list2);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        if (place == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        if ((referenceTypes = method.getThrowsList().getReferencedTypes()).length == 0) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(14);
            }
            return list2;
        }
        GlobalSearchScope scope2 = place.getResolveScope();
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiType type2 : referenceTypes) {
            if ((type2 = PsiClassImplUtil.correctType(substitutor2.substitute(type2), scope2)) instanceof PsiCapturedWildcardType) {
                type2 = ((PsiCapturedWildcardType)type2).getUpperBound();
            }
            if (!(type2 instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type2);
        }
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<? extends PsiClassType> exceptions) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        for (PsiClassType psiClassType : exceptions) {
            ExceptionUtil.addException(array, psiClassType);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        return ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        Set<PsiClassType> set = ContainerUtil.notNullize(ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls ? c -> false : expression2 -> {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            return method == PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
        }));
        if (set == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        return set;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, @NotNull Predicate<? super PsiCallExpression> callFilter) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        if (callFilter == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, callFilter);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression != null ? ExceptionUtil.collectUnhandledExceptions(qualifierExpression, topElement, null, callFilter) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement2 = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement2, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor2 = (PsiMethod)element.getParent();
                PsiClass aClass = constructor2.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || !superConstructor.getParameterList().isEmpty()) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.getHandlePlace(element, exceptionType, topElement) != HandlePlace.UNHANDLED) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers = aClass.getInitializers();
                    THashSet thrownByInitializer = new THashSet();
                    for (PsiClassInitializer initializer2 : initializers) {
                        if (initializer2.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions(initializer2.getBody(), initializer2, (Set<PsiClassType>)thrownByInitializer, callFilter);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.getHandlePlace(constructor2.getBody(), thrown, topElement) != HandlePlace.UNHANDLED) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = new ArrayList<PsiClassType>(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, (Set<PsiClassType>)foundExceptions, callFilter);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult;
        PsiElement resolve2;
        if (methodReferenceExpression == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        if ((resolve2 = (resolveResult = methodReferenceExpression.advancedResolve(false)).getElement()) instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            return ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve2, referenceNameElement, topElement, resolveResult::getSubstitutor);
        }
        List<PsiClassType> list2 = Collections.emptyList();
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(28);
        }
        return list2;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements2;
        if (constructorBody == null) {
            ExceptionUtil.$$$reportNull$$$0(29);
        }
        if ((statements2 = constructorBody.getStatements()).length == 0) {
            return false;
        }
        if (!(statements2[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements2[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final PsiElement @NotNull [] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(30);
        }
        final ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getOwnUnhandledExceptions(element));
                super.visitElement(element);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/ExceptionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor2);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getOwnUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(32);
        }
        if (element instanceof PsiEnumConstant) {
            PsiMethod method = ((PsiEnumConstant)element).resolveMethod();
            if (method != null) {
                return ExceptionUtil.getUnhandledExceptions(method, element, null, () -> PsiSubstitutor.EMPTY);
            }
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(33);
            }
            return list2;
        }
        if (element instanceof PsiCallExpression) {
            return ExceptionUtil.getUnhandledExceptions((PsiCallExpression)element, null);
        }
        if (element instanceof PsiThrowStatement) {
            return ExceptionUtil.getUnhandledExceptions((PsiThrowStatement)element, null);
        }
        if (element instanceof PsiMethodReferenceExpression) {
            return ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, null);
        }
        if (element instanceof PsiResourceListElement) {
            return ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, null);
        }
        List<PsiClassType> list3 = Collections.emptyList();
        if (list3 == null) {
            ExceptionUtil.$$$reportNull$$$0(34);
        }
        return list3;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(36);
        }
        return ExceptionUtil.getUnhandledExceptions(methodCall, topElement, c -> false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, @NotNull Predicate<? super PsiCallExpression> skipCondition) {
        block18: {
            block19: {
                if (methodCall == null) {
                    ExceptionUtil.$$$reportNull$$$0(37);
                }
                if (skipCondition == null) {
                    ExceptionUtil.$$$reportNull$$$0(38);
                }
                if (MethodCandidateInfo.isOverloadCheck()) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        ExceptionUtil.$$$reportNull$$$0(39);
                    }
                    return v0;
                }
                result = PsiDiamondType.getDiamondsAwareResolveResult(methodCall);
                element = result.getElement();
                v1 = method = element instanceof PsiMethod != false ? (PsiMethod)element : null;
                if (method == null) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        ExceptionUtil.$$$reportNull$$$0(40);
                    }
                    return v2;
                }
                if (skipCondition.test(methodCall)) {
                    v3 = Collections.emptyList();
                    if (v3 == null) {
                        ExceptionUtil.$$$reportNull$$$0(41);
                    }
                    return v3;
                }
                thrownExceptions = method.getThrowsList().getReferencedTypes();
                if (thrownExceptions.length == 0) {
                    v4 = Collections.emptyList();
                    if (v4 == null) {
                        ExceptionUtil.$$$reportNull$$$0(42);
                    }
                    return v4;
                }
                if (ExceptionUtil.isArrayClone(method, methodCall) || !(methodCall instanceof PsiMethodCallExpression)) break block18;
                containingFile = methodCall.getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), (Function<CandidateInfo, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getUnhandledExceptions$5(com.intellij.psi.PsiMethod com.intellij.psi.infos.CandidateInfo ), (Lcom/intellij/psi/infos/CandidateInfo;)Lcom/intellij/openapi/util/Pair;)((PsiMethod)method));
                    if (candidates.isEmpty()) break block18;
                    scope = methodCall.getResolveScope();
                    ex = ExceptionUtil.collectSubstituted(result.getSubstitutor(), thrownExceptions, scope);
lbl38:
                    // 2 sources

                    for (Pair pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v5 = Collections.emptyList();
                            break block19;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl56
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v6 = Collections.emptyList();
                    if (v6 == null) {
                        ExceptionUtil.$$$reportNull$$$0(45);
                    }
                    return v6;
                }
            }
            if (v5 == null) {
                ExceptionUtil.$$$reportNull$$$0(43);
            }
            return v5;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                ** GOTO lbl38
lbl56:
                // 1 sources

                v7 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY));
            }
            if (v7 == null) {
                ExceptionUtil.$$$reportNull$$$0(44);
            }
            return v7;
        }
        return ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, (Supplier<PsiSubstitutor>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getSubstitutor(), ()Lcom/intellij/psi/PsiSubstitutor;)((JavaResolveResult)result));
    }

    public static void retainExceptions(List<PsiClassType> ex, List<? extends PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator2 = ex.iterator();
        while (iterator2.hasNext()) {
            PsiClassType classType = iterator2.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom(classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom(psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator2.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor2, PsiClassType[] thrownExceptions, GlobalSearchScope scope2) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType2 = PsiClassImplUtil.correctType(substitutor2.substitute(thrownException), scope2);
            if (psiType2 instanceof PsiClassType) {
                ex.add((PsiClassType)psiType2);
                continue;
            }
            if (!(psiType2 instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType2).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex;
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(46);
        }
        List<PsiClassType> list2 = (ex = ExceptionUtil.getExceptionsFromClose(resource)) != null ? ex : Collections.emptyList();
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(48);
        }
        PsiType type2 = resource.getType();
        return ExceptionUtil.getUnhandledCloserExceptions(resource, topElement, type2);
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type2) {
        List<PsiClassType> ex = type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, place.getResolveScope()) : null;
        List<PsiClassType> list2 = ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY)) : Collections.emptyList();
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(49);
        }
        return list2;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        return type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type2, GlobalSearchScope scope2) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType(type2);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods2 = PsiUtil.getResourceCloserMethodsForType((PsiClassType)type2);
        if (methods2 != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method : methods2) {
                PsiSubstitutor substitutor2;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor2 = TypeConversionUtil.getClassSubstitutor(closerClass, resourceClass, resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope2);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope2));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(50);
        }
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types2 = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types2) {
                PsiType upperBound;
                PsiClassType classType = null;
                if (subType instanceof PsiClassType) {
                    classType = (PsiClassType)subType;
                } else if (subType instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)subType).getUpperBound()) instanceof PsiClassType) {
                    classType = (PsiClassType)upperBound;
                }
                if (classType == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(throwStatement, classType, topElement) != HandlePlace.UNHANDLED) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            ExceptionUtil.$$$reportNull$$$0(51);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type2;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            List<PsiType> list2 = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(52);
            }
            return list2;
        }
        if (expression2 != null && (type2 = expression2.getType()) != null) {
            List<PsiType> list3 = Collections.singletonList(type2);
            if (list3 == null) {
                ExceptionUtil.$$$reportNull$$$0(53);
            }
            return list3;
        }
        List<PsiType> list4 = Collections.emptyList();
        if (list4 == null) {
            ExceptionUtil.$$$reportNull$$$0(54);
        }
        return list4;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull Supplier<? extends PsiSubstitutor> substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(55);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(56);
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(57);
            }
            return list2;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        if (referencedTypes.length == 0) {
            List<PsiClassType> list3 = Collections.emptyList();
            if (list3 == null) {
                ExceptionUtil.$$$reportNull$$$0(58);
            }
            return list3;
        }
        List<PsiClassType> list4 = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor2.get(), referencedTypes);
        if (list4 == null) {
            ExceptionUtil.$$$reportNull$$$0(59);
        }
        return list4;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor2, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards(substitutor2.substitute(referencedType), false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(element, classType, topElement) != HandlePlace.UNHANDLED) continue;
                result2.add((PsiClassType)type2);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(60);
        }
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(61);
        }
        return InheritanceUtil.isInheritor(type2, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type2, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(63);
        }
        return ExceptionUtil.isGeneralExceptionType(type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        String canonicalText;
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(64);
        }
        return "java.lang.Throwable".equals(canonicalText = type2.getCanonicalText()) || "java.lang.Exception".equals(canonicalText);
    }

    @NotNull
    public static HandlePlace getHandlePlace(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, @Nullable PsiElement topElement) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(67);
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            HandlePlace handlePlace = HandlePlace.UNHANDLED;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(68);
            }
            return handlePlace;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(69);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiClass) {
            if (!(parent2 instanceof PsiAnonymousClass)) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(70);
                }
                return handlePlace;
            }
            return ExceptionUtil.getHandlePlace(parent2, exceptionType, topElement);
        }
        if (parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent2).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent2).getFunctionalInterfaceType();
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(71);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent2).hasModifierProperty("static")) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(72);
                }
                return handlePlace;
            }
            if (!(parent2.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent2).getContainingClass();
                HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(73);
                }
                return handlePlace;
            }
        } else if (parent2 instanceof PsiTryStatement) {
            HandlePlace place;
            PsiTryStatement tryStatement = (PsiTryStatement)parent2;
            if (tryStatement.getTryBlock() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace = place;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(74);
                }
                return handlePlace;
            }
            if (tryStatement.getResourceList() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace = place;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(75);
                }
                return handlePlace;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                HandlePlace handlePlace = HandlePlace.UNKNOWN;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(76);
                }
                return handlePlace;
            }
        } else {
            if (parent2 instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent2;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                HandlePlace handlePlace = HandlePlace.fromBoolean(exceptionHandler != null && exceptionHandler.isHandledException(exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(77);
                }
                return handlePlace;
            }
            if (PsiImplUtil.isInServerPage(parent2) && parent2 instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.UNKNOWN;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(78);
                }
                return handlePlace;
            }
            if (parent2 instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.fromBoolean(false);
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(79);
                }
                return handlePlace;
            }
            if (parent2 instanceof PsiField && ((PsiField)parent2).getInitializer() == element) {
                PsiClass aClass = ((PsiField)parent2).getContainingClass();
                if (aClass != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent2).hasModifierProperty("static")) {
                    HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
                    if (handlePlace == null) {
                        ExceptionUtil.$$$reportNull$$$0(80);
                    }
                    return handlePlace;
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : CustomExceptionHandler.KEY.getExtensionList()) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    HandlePlace handlePlace = HandlePlace.UNKNOWN;
                    if (handlePlace == null) {
                        ExceptionUtil.$$$reportNull$$$0(81);
                    }
                    return handlePlace;
                }
            }
        }
        return ExceptionUtil.getHandlePlace(parent2, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(82);
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(interfaceType))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(83);
        }
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors2 = aClass.getConstructors();
        boolean thrown = constructors2.length != 0;
        for (PsiMethod constructor2 : constructors2) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor2, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    @NotNull
    private static HandlePlace getCaughtPlace(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(84);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(85);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            HandlePlace handlePlace = HandlePlace.UNKNOWN;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(86);
            }
            return handlePlace;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return new HandlePlace.TryCatch(tryStatement, parameter);
        }
        HandlePlace handlePlace = HandlePlace.UNHANDLED;
        if (handlePlace == null) {
            ExceptionUtil.$$$reportNull$$$0(87);
        }
        return handlePlace;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            ExceptionUtil.$$$reportNull$$$0(88);
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet(completionReasons, 1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(89);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(90);
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(91);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(92);
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor2);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, PsiClassType @NotNull [] referencedTypes, PsiSubstitutor substitutor2) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(95);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(96);
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType2 = substitutor2.substitute(classType);
            if (psiType2 == null || !psiType2.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ Pair lambda$getUnhandledExceptions$5(PsiMethod method, CandidateInfo info) {
        PsiElement element1 = info.getElement();
        if (info instanceof MethodCandidateInfo && element1 != method && MethodSignatureUtil.areSignaturesEqual(method, (PsiMethod)element1) && !((PsiMethod)element1).hasModifierProperty("private") && !MethodSignatureUtil.isSuperMethod((PsiMethod)element1, method) && (!((MethodCandidateInfo)info).isToInferApplicability() || ((MethodCandidateInfo)info).isApplicable())) {
            return Pair.create((PsiMethod)element1, ((MethodCandidateInfo)info).getSubstitutor(false));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 5: 
            case 17: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 7: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 11: 
            case 55: 
            case 60: 
            case 89: 
            case 91: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCall";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callFilter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorBody";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 61: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 65: 
            case 67: 
            case 82: 
            case 83: 
            case 85: 
            case 90: 
            case 92: 
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwPlace";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownCheckedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUncheckedExceptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryExceptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethod";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 28: 
            case 31: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnUnhandledExceptions";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloserExceptions";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledCloserExceptions";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseThrowTypes";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlePlace";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaughtPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownCheckedExceptions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUncheckedExceptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTryExceptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethod";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addExceptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 50: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "firstStatementIsConstructorCall";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOwnUnhandledExceptions";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCloserExceptions";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledCloserExceptions";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClone";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedException";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedExceptionOrSuperclass";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralExceptionType";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isHandled";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getHandlePlace";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredBySAMMethod";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "areAllConstructorsThrow";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getCaughtPlace";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesAbruptly";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByMethodThrowsClause";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isHandledBy";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "sortExceptionsByHierarchy";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "canDeclareThrownExceptions";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HandlePlace {
        public static final HandlePlace UNHANDLED = new HandlePlace(){};
        public static final HandlePlace UNKNOWN = new HandlePlace(){};

        public static HandlePlace fromBoolean(boolean isHandled) {
            return isHandled ? UNKNOWN : UNHANDLED;
        }

        public static class TryCatch
        implements HandlePlace {
            private final PsiTryStatement myTryStatement;
            private final PsiParameter myParameter;

            public TryCatch(PsiTryStatement statement2, PsiParameter parameter) {
                this.myTryStatement = statement2;
                this.myParameter = parameter;
            }
        }
    }
}

