/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@ApiStatus.Internal
public class ModelBranchImpl
implements ModelBranch {
    private final Map<VirtualFile, VirtualFile> myVFileCopies;
    private final SimpleModificationTracker myFileSetChanges;
    private final Project myProject;

    @Override
    public long getBranchedPsiModificationCount() {
        return this.myFileSetChanges.getModificationCount() + this.myVFileCopies.values().stream().map(PsiManager.getInstance(this.myProject)::findFile).filter(Objects::nonNull).mapToLong(PsiFile::getModificationStamp).sum();
    }

    public static boolean hasBranchedFilesInScope(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(15);
        }
        return !ModelBranchImpl.processBranchedFilesInScope(scope2, __ -> false);
    }

    public static boolean processBranchedFilesInScope(@NotNull GlobalSearchScope scope2, @NotNull Processor<? super VirtualFile> processor2) {
        Collection<ModelBranch> branches;
        if (scope2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(17);
        }
        return (branches = scope2.getModelBranchesAffectingScope()).isEmpty() || ModelBranchImpl.processBranchedFilesInScope(scope2, processor2, branches);
    }

    private static boolean processBranchedFilesInScope(GlobalSearchScope scope2, Processor<? super VirtualFile> processor2, Collection<ModelBranch> branches) {
        for (ModelBranch branch : branches) {
            for (VirtualFile file2 : ((ModelBranchImpl)branch).myVFileCopies.values()) {
                if (!scope2.contains(file2) || processor2.process(file2)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/ModelBranchImpl";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branched";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/ModelBranchImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFileCopy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainPsiCopy";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOriginalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performInBranch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runAfterMerge";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "obtainFileCopy";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileCopy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "obtainPsiCopy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPsiCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceCopy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalPsi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modifyScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasBranchedFilesInScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processBranchedFilesInScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

