/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000eJ\u001c\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bJ\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\f\u0010\u001e\u001a\u00020\u0018*\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "globalTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;)V", "globalDeclarationTable", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "table", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/Map;", "assumeDeclarationSignature", "", "declaration", "signature", "computeSignatureByDeclaration", "isExportedDeclaration", "", "privateDeclarationSignature", "builder", "Lkotlin/Function0;", "signatureByDeclaration", "tryComputeBackendSpecificSignature", "isLocalDeclaration", "ir.serialization.common"})
public class DeclarationTable {
    @NotNull
    private final Map<IrDeclaration, IdSignature> table;
    @NotNull
    private final GlobalDeclarationTable globalDeclarationTable;
    @NotNull
    private final IdSignatureSerializer signaturer;

    public DeclarationTable(@NotNull GlobalDeclarationTable globalTable) {
        Intrinsics.checkNotNullParameter(globalTable, "globalTable");
        boolean bl = false;
        this.table = new LinkedHashMap();
        this.globalDeclarationTable = globalTable;
        this.signaturer = new IdSignatureSerializer(globalTable.getPublicIdSignatureComputer(), this);
    }

    @NotNull
    protected final Map<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    @NotNull
    protected GlobalDeclarationTable getGlobalDeclarationTable() {
        return this.globalDeclarationTable;
    }

    @NotNull
    public IdSignatureSerializer getSignaturer() {
        return this.signaturer;
    }

    private final boolean isLocalDeclaration(IrDeclaration $this$isLocalDeclaration) {
        return !this.isExportedDeclaration($this$isLocalDeclaration);
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.getGlobalDeclarationTable().isExportedDeclaration(declaration2);
    }

    @Nullable
    protected IdSignature tryComputeBackendSpecificSignature(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return null;
    }

    private final IdSignature computeSignatureByDeclaration(IrDeclaration declaration2) {
        IdSignature idSignature;
        IdSignature idSignature2 = this.tryComputeBackendSpecificSignature(declaration2);
        if (idSignature2 != null) {
            IdSignature idSignature3 = idSignature2;
            boolean bl = false;
            boolean bl2 = false;
            IdSignature it = idSignature3;
            boolean bl3 = false;
            return it;
        }
        if (this.isLocalDeclaration(declaration2)) {
            IdSignature idSignature4;
            Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
            boolean $i$f$getOrPut = false;
            IdSignature value$iv = $this$getOrPut$iv.get(declaration2);
            if (value$iv == null) {
                boolean bl = false;
                IdSignature answer$iv = this.getSignaturer().composeFileLocalIdSignature(declaration2);
                $this$getOrPut$iv.put(declaration2, answer$iv);
                idSignature4 = answer$iv;
            } else {
                idSignature4 = value$iv;
            }
            idSignature = idSignature4;
        } else {
            idSignature = this.getGlobalDeclarationTable().computeSignatureByDeclaration(declaration2);
        }
        return idSignature;
    }

    @NotNull
    public final IdSignature privateDeclarationSignature(@NotNull IrDeclaration declaration2, @NotNull Function0<? extends IdSignature> builder2) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        boolean bl = this.isLocalDeclaration(declaration2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        IdSignature value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            boolean bl5 = false;
            IdSignature answer$iv = builder2.invoke();
            $this$getOrPut$iv.put(declaration2, answer$iv);
            idSignature = answer$iv;
        } else {
            idSignature = value$iv;
        }
        return idSignature;
    }

    @NotNull
    public IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.computeSignatureByDeclaration(declaration2);
    }

    public final void assumeDeclarationSignature(@NotNull IrDeclaration declaration2, @NotNull IdSignature signature2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        boolean bl = this.table.get(declaration2) == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Declaration table already has signature for ", RenderIrElementKt.render(declaration2));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.table.put(declaration2, signature2);
    }
}

