/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArgumentsKt;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.js.K2JsIrCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.K2JSTranslator;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private static final Map<String, ModuleKind> moduleKindMap = new HashMap<String, ModuleKind>();
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap = new LinkedHashMap<String, SourceMapSourceEmbedding>();
    private K2JsIrCompiler irCompiler = null;
    private final K2JSCompilerPerformanceManager performanceManager = new K2JSCompilerPerformanceManager();

    @NotNull
    private K2JsIrCompiler getIrCompiler() {
        if (this.irCompiler == null) {
            this.irCompiler = new K2JsIrCompiler();
        }
        K2JsIrCompiler k2JsIrCompiler = this.irCompiler;
        if (k2JsIrCompiler == null) {
            K2JSCompiler.$$$reportNull$$$0(0);
        }
        return k2JsIrCompiler;
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $self, @NotNull K2JSCompilerArguments arguments2) {
        if ($self == null) {
            K2JSCompiler.$$$reportNull$$$0(1);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(2);
        }
    }

    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    @NotNull
    private static TranslationResult translate(@NotNull JsConfig.Reporter reporter, @NotNull List<KtFile> allKotlinFiles2, @NotNull JsAnalysisResult jsAnalysisResult, @NotNull MainCallParameters mainCallParameters, @NotNull JsConfig config) throws TranslationException {
        if (reporter == null) {
            K2JSCompiler.$$$reportNull$$$0(3);
        }
        if (allKotlinFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(4);
        }
        if (jsAnalysisResult == null) {
            K2JSCompiler.$$$reportNull$$$0(5);
        }
        if (mainCallParameters == null) {
            K2JSCompiler.$$$reportNull$$$0(6);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$0(7);
        }
        K2JSTranslator translator = new K2JSTranslator(config);
        IncrementalDataProvider incrementalDataProvider = config.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider != null) {
            HashMap<File, KtFile> nonCompiledSources = new HashMap<File, KtFile>(allKotlinFiles2.size());
            for (KtFile ktFile2 : allKotlinFiles2) {
                nonCompiledSources.put(VfsUtilCore.virtualToIoFile(ktFile2.getVirtualFile()), ktFile2);
            }
            Map<File, TranslationResultValue> compiledParts = incrementalDataProvider.getCompiledPackageParts();
            Object[] allSources = new File[compiledParts.size() + allKotlinFiles2.size()];
            int i = 0;
            for (File file2 : compiledParts.keySet()) {
                allSources[i++] = file2;
            }
            for (File file2 : nonCompiledSources.keySet()) {
                allSources[i++] = file2;
            }
            Arrays.sort(allSources);
            Set dirtyPackages = nonCompiledSources.values().stream().map(KtFile::getPackageFqName).collect(Collectors.toSet());
            HashMap<FqName, byte[]> packageMetadata2 = new HashMap<FqName, byte[]>();
            for (Map.Entry<String, byte[]> e : incrementalDataProvider.getPackageMetadata().entrySet()) {
                FqName name = new FqName(e.getKey());
                if (dirtyPackages.contains(name)) continue;
                packageMetadata2.put(name, e.getValue());
            }
            ArrayList<TranslationUnit> translationUnits = new ArrayList<TranslationUnit>();
            for (i = 0; i < allSources.length; ++i) {
                KtFile nonCompiled = (KtFile)nonCompiledSources.get(allSources[i]);
                if (nonCompiled != null) {
                    translationUnits.add(new TranslationUnit.SourceFile(nonCompiled));
                    continue;
                }
                TranslationResultValue translatedValue = compiledParts.get(allSources[i]);
                translationUnits.add(new TranslationUnit.BinaryAst(translatedValue.getBinaryAst(), translatedValue.getInlineData()));
            }
            TranslationResult translationResult = translator.translateUnits(reporter, translationUnits, mainCallParameters, jsAnalysisResult, packageMetadata2);
            if (translationResult == null) {
                K2JSCompiler.$$$reportNull$$$0(8);
            }
            return translationResult;
        }
        CollectionsKt.sortBy(allKotlinFiles2, ktFile -> VfsUtilCore.virtualToIoFile(ktFile.getVirtualFile()));
        TranslationResult translationResult = translator.translate(reporter, allKotlinFiles2, mainCallParameters, jsAnalysisResult);
        if (translationResult == null) {
            K2JSCompiler.$$$reportNull$$$0(9);
        }
        return translationResult;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        TranslationResult translationResult;
        AnalysisResult analysisResult2;
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(11);
        }
        if (rootDisposable == null) {
            K2JSCompiler.$$$reportNull$$$0(12);
        }
        final MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        ExitCode exitCode = ExitCode.OK;
        if (K2JSCompilerArgumentsKt.isIrBackendEnabled(arguments2)) {
            exitCode = this.getIrCompiler().doExecute(arguments2, configuration.copy(), rootDisposable, paths);
        }
        if (K2JSCompilerArgumentsKt.isPreIrBackendDisabled(arguments2)) {
            ExitCode exitCode2 = exitCode;
            if (exitCode2 == null) {
                K2JSCompiler.$$$reportNull$$$0(13);
            }
            return exitCode2;
        }
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                ExitCode exitCode3 = ExitCode.OK;
                if (exitCode3 == null) {
                    K2JSCompiler.$$$reportNull$$$0(14);
                }
                return exitCode3;
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
            ExitCode exitCode4 = ExitCode.COMPILATION_ERROR;
            if (exitCode4 == null) {
                K2JSCompiler.$$$reportNull$$$0(15);
            }
            return exitCode4;
        }
        ExitCode pluginLoadResult = this.loadPlugins(paths, arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            ExitCode exitCode5 = pluginLoadResult;
            if (exitCode5 == null) {
                K2JSCompiler.$$$reportNull$$$0(16);
            }
            return exitCode5;
        }
        configuration.put(JSConfigurationKeys.LIBRARIES, K2JSCompiler.configureLibraries(arguments2, paths, messageCollector));
        String[] commonSourcesArray = arguments2.getCommonSources();
        Set<Object> commonSources = commonSourcesArray == null ? Collections.emptySet() : SetsKt.setOf(commonSourcesArray);
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        environmentForJS.getConfiguration().put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, sourcesFiles)) {
            ExitCode exitCode6 = ExitCode.COMPILATION_ERROR;
            if (exitCode6 == null) {
                K2JSCompiler.$$$reportNull$$$0(17);
            }
            return exitCode6;
        }
        if (arguments2.getOutputFile() == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", null);
            ExitCode exitCode7 = ExitCode.COMPILATION_ERROR;
            if (exitCode7 == null) {
                K2JSCompiler.$$$reportNull$$$0(18);
            }
            return exitCode7;
        }
        if (messageCollector.hasErrors()) {
            ExitCode exitCode8 = ExitCode.COMPILATION_ERROR;
            if (exitCode8 == null) {
                K2JSCompiler.$$$reportNull$$$0(19);
            }
            return exitCode8;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "No source files", null);
            ExitCode exitCode9 = ExitCode.COMPILATION_ERROR;
            if (exitCode9 == null) {
                K2JSCompiler.$$$reportNull$$$0(20);
            }
            return exitCode9;
        }
        if (arguments2.getVerbose()) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector, sourcesFiles);
        }
        File outputFile = new File(arguments2.getOutputFile());
        configuration.put(CommonConfigurationKeys.MODULE_NAME, FileUtil.getNameWithoutExtension(outputFile));
        JsConfig config = new JsConfig(project, configuration, CompilerEnvironment.INSTANCE);
        JsConfig.Reporter reporter = new JsConfig.Reporter(){

            @Override
            public void error(@NotNull String message2) {
                if (message2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                messageCollector.report(CompilerMessageSeverity.ERROR, message2, null);
            }

            @Override
            public void warning(@NotNull String message2) {
                if (message2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                messageCollector.report(CompilerMessageSeverity.STRONG_WARNING, message2, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warning";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (config.checkLibFilesAndReportErrors(reporter)) {
            ExitCode exitCode10 = ExitCode.COMPILATION_ERROR;
            if (exitCode10 == null) {
                K2JSCompiler.$$$reportNull$$$0(21);
            }
            return exitCode10;
        }
        do {
            AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration));
            List<KtFile> sources = environmentForJS.getSourceFiles();
            analyzerWithCompilerReport.analyzeAndReport(sourcesFiles, () -> TopDownAnalyzerFacadeForJS.analyzeFiles(sources, config));
            if (analyzerWithCompilerReport.hasErrors()) {
                ExitCode exitCode11 = ExitCode.COMPILATION_ERROR;
                if (exitCode11 == null) {
                    K2JSCompiler.$$$reportNull$$$0(22);
                }
                return exitCode11;
            }
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            analysisResult2 = analyzerWithCompilerReport.getAnalysisResult();
            if (!(analysisResult2 instanceof JsAnalysisResult.RetryWithAdditionalRoots)) continue;
            environmentForJS.addKotlinSourceRoots(((JsAnalysisResult.RetryWithAdditionalRoots)analysisResult2).getAdditionalKotlinRoots());
        } while (analysisResult2 instanceof JsAnalysisResult.RetryWithAdditionalRoots);
        if (!analysisResult2.getShouldGenerateCode()) {
            ExitCode exitCode12 = ExitCode.OK;
            if (exitCode12 == null) {
                K2JSCompiler.$$$reportNull$$$0(23);
            }
            return exitCode12;
        }
        assert (analysisResult2 instanceof JsAnalysisResult) : "analysisResult should be instance of JsAnalysisResult, but " + analysisResult2;
        JsAnalysisResult jsAnalysisResult = (JsAnalysisResult)analysisResult2;
        File outputPrefixFile = null;
        if (arguments2.getOutputPrefix() != null && !(outputPrefixFile = new File(arguments2.getOutputPrefix())).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.getOutputPrefix() + "' not found", null);
            ExitCode exitCode13 = ExitCode.COMPILATION_ERROR;
            if (exitCode13 == null) {
                K2JSCompiler.$$$reportNull$$$0(24);
            }
            return exitCode13;
        }
        File outputPostfixFile = null;
        if (arguments2.getOutputPostfix() != null && !(outputPostfixFile = new File(arguments2.getOutputPostfix())).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.getOutputPostfix() + "' not found", null);
            ExitCode exitCode14 = ExitCode.COMPILATION_ERROR;
            if (exitCode14 == null) {
                K2JSCompiler.$$$reportNull$$$0(25);
            }
            return exitCode14;
        }
        File outputDir2 = outputFile.getParentFile();
        if (outputDir2 == null) {
            outputDir2 = outputFile.getAbsoluteFile().getParentFile();
        }
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            ExitCode exitCode15 = ExitCode.COMPILATION_ERROR;
            if (exitCode15 == null) {
                K2JSCompiler.$$$reportNull$$$0(26);
            }
            return exitCode15;
        }
        if (config.getConfiguration().getBoolean(JSConfigurationKeys.SOURCE_MAP)) {
            K2JSCompiler.checkDuplicateSourceFileNames(messageCollector, sourcesFiles, config);
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.getMain());
        try {
            translationResult = K2JSCompiler.translate(reporter, sourcesFiles, jsAnalysisResult, mainCallParameters, config);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(translationResult.getDiagnostics(), messageCollector);
        if (translationResult instanceof TranslationResult.Fail) {
            ExitCode exitCode16 = ExitCode.COMPILATION_ERROR;
            if (exitCode16 == null) {
                K2JSCompiler.$$$reportNull$$$0(27);
            }
            return exitCode16;
        }
        TranslationResult.SuccessBase successResult = (TranslationResult.SuccessBase)translationResult;
        OutputFileCollection outputFiles = successResult.getOutputFiles(outputFile, outputPrefixFile, outputPostfixFile);
        if (outputFile.isDirectory()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Cannot open output file '" + outputFile.getPath() + "': is a directory", null);
            ExitCode exitCode17 = ExitCode.COMPILATION_ERROR;
            if (exitCode17 == null) {
                K2JSCompiler.$$$reportNull$$$0(28);
            }
            return exitCode17;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        OutputUtilsKt.writeAll(outputFiles, outputDir2, messageCollector, configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES));
        ExitCode exitCode18 = ExitCode.OK;
        if (exitCode18 == null) {
            K2JSCompiler.$$$reportNull$$$0(29);
        }
        return exitCode18;
    }

    private static void checkDuplicateSourceFileNames(@NotNull MessageCollector log2, @NotNull List<KtFile> sourceFiles2, @NotNull JsConfig config) {
        if (log2 == null) {
            K2JSCompiler.$$$reportNull$$$0(30);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(31);
        }
        if (config == null) {
            K2JSCompiler.$$$reportNull$$$0(32);
        }
        if (config.getSourceMapRoots().isEmpty()) {
            return;
        }
        SourceFilePathResolver pathResolver = SourceFilePathResolver.create(config);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        HashSet<String> duplicatePaths = new HashSet<String>();
        try {
            for (KtFile sourceFile : sourceFiles2) {
                String path2 = sourceFile.getVirtualFile().getPath();
                String relativePath = pathResolver.getPathRelativeToSourceRoots(new File(sourceFile.getVirtualFile().getPath()));
                String existingPath = (String)pathMap.get(relativePath);
                if (existingPath != null) {
                    if (!duplicatePaths.add(relativePath)) continue;
                    log2.report(CompilerMessageSeverity.WARNING, "There are files with same path '" + relativePath + "', relative to source roots: '" + path2 + "' and '" + existingPath + "'. This will likely cause problems with debugger", null);
                    continue;
                }
                pathMap.put(relativePath, path2);
            }
        }
        catch (IOException e) {
            log2.report(CompilerMessageSeverity.ERROR, "IO error occurred validating source path:\n" + ExceptionUtil.getThrowableText(e), null);
        }
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector, @NotNull List<KtFile> sourceFiles2) {
        if (messageCollector == null) {
            K2JSCompiler.$$$reportNull$$$0(33);
        }
        if (sourceFiles2 == null) {
            K2JSCompiler.$$$reportNull$$$0(34);
        }
        List<String> fileNames = CollectionsKt.map(sourceFiles2, file2 -> {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            if (virtualFile2 != null) {
                return MessageUtil.virtualFileToPath(virtualFile2);
            }
            return file2.getName() + " (no virtual file)";
        });
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ExpectActualTracker expectActualTracker;
        LookupTracker lookupTracker;
        IncrementalResultsConsumer incrementalResultsConsumer;
        ModuleKind moduleKind;
        if (configuration == null) {
            K2JSCompiler.$$$reportNull$$$0(35);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(36);
        }
        if (services == null) {
            K2JSCompiler.$$$reportNull$$$0(37);
        }
        if (K2JSCompilerArgumentsKt.isIrBackendEnabled(arguments2)) {
            this.getIrCompiler().setupPlatformSpecificArgumentsAndServices(configuration, arguments2, services);
        }
        if (K2JSCompilerArgumentsKt.isPreIrBackendDisabled(arguments2)) {
            return;
        }
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.getTarget() != null) assert ("v5".equals(arguments2.getTarget())) : "Unsupported ECMA version: " + arguments2.getTarget();
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                configuration.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, arguments2.getSourceMapPrefix());
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty(arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                List<String> sourceMapSourceRootList = StringUtil.split(sourceMapSourceRoots, File.pathSeparator);
                configuration.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        if (!arguments2.getFriendModulesDisabled() && arguments2.getFriendModules() != null) {
            List<String> friendPaths = ArraysKt.filterNot(arguments2.getFriendModules().split(File.pathSeparator), String::isEmpty);
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        configuration.put(JSConfigurationKeys.METADATA_ONLY, arguments2.getMetadataOnly());
        String moduleKindName = arguments2.getModuleKind();
        ModuleKind moduleKind2 = moduleKind = moduleKindName != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        IncrementalDataProvider incrementalDataProvider = services.get(IncrementalDataProvider.class);
        if (incrementalDataProvider != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, incrementalDataProvider);
        }
        if ((incrementalResultsConsumer = services.get(IncrementalResultsConsumer.class)) != null) {
            configuration.put(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, incrementalResultsConsumer);
        }
        if ((lookupTracker = services.get(LookupTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, lookupTracker);
        }
        if ((expectActualTracker = services.get(ExpectActualTracker.class)) != null) {
            configuration.put(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, expectActualTracker);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message2 = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join(sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector.report(CompilerMessageSeverity.ERROR, message2, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
    }

    @NotNull
    private static List<String> configureLibraries(@NotNull K2JSCompilerArguments arguments2, @Nullable KotlinPaths paths, @NotNull MessageCollector messageCollector) {
        File stdlibJar;
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(38);
        }
        if (messageCollector == null) {
            K2JSCompiler.$$$reportNull$$$0(39);
        }
        SmartList<String> libraries = new SmartList<String>();
        if (!arguments2.getNoStdlib() && (stdlibJar = UtilsKt.getLibraryFromHome(paths, KotlinPaths::getJsStdLibJarPath, "kotlin-stdlib-js.jar", messageCollector, "'-no-stdlib'")) != null) {
            libraries.add(stdlibJar.getAbsolutePath());
        }
        if (arguments2.getLibraries() != null) {
            libraries.addAll(ArraysKt.filterNot(arguments2.getLibraries().split(File.pathSeparator), String::isEmpty));
        }
        SmartList<String> smartList = libraries;
        if (smartList == null) {
            K2JSCompiler.$$$reportNull$$$0(40);
        }
        return smartList;
    }

    @NotNull
    static String calculateSourceMapSourceRoot(@NotNull MessageCollector messageCollector, @NotNull K2JSCompilerArguments arguments2) {
        if (messageCollector == null) {
            K2JSCompiler.$$$reportNull$$$0(41);
        }
        if (arguments2 == null) {
            K2JSCompiler.$$$reportNull$$$0(42);
        }
        File commonPath = null;
        ArrayList<File> pathToRoot = new ArrayList<File>();
        HashMap pathToRootIndexes = new HashMap();
        try {
            for (String path2 : arguments2.getFreeArgs()) {
                File file2;
                if (commonPath == null) {
                    commonPath = file2;
                    for (file2 = new File(path2).getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                        pathToRoot.add(file2);
                    }
                    Collections.reverse(pathToRoot);
                    for (int i = 0; i < pathToRoot.size(); ++i) {
                        pathToRootIndexes.put(pathToRoot.get(i), i);
                    }
                    continue;
                }
                while (file2 != null) {
                    Integer existingIndex = (Integer)pathToRootIndexes.get(file2);
                    if (existingIndex != null) {
                        existingIndex = Math.min(existingIndex, pathToRoot.size() - 1);
                        pathToRoot.subList(existingIndex + 1, pathToRoot.size()).clear();
                        commonPath = (File)pathToRoot.get(pathToRoot.size() - 1);
                        break;
                    }
                    file2 = file2.getParentFile();
                }
                if (file2 != null) continue;
                break;
            }
        }
        catch (IOException e) {
            String text2 = ExceptionUtil.getThrowableText(e);
            messageCollector.report(CompilerMessageSeverity.ERROR, "IO error occurred calculating source root:\n" + text2, null);
            return ".";
        }
        return commonPath != null ? commonPath.getPath() : ".";
    }

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        K2JSCompilerPerformanceManager k2JSCompilerPerformanceManager = this.performanceManager;
        if (k2JSCompilerPerformanceManager == null) {
            K2JSCompiler.$$$reportNull$$$0(43);
        }
        return k2JSCompilerPerformanceManager;
    }

    private static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-js";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        if (versionArray == null) {
            K2JSCompiler.$$$reportNull$$$0(44);
        }
        return new JsMetadataVersion(versionArray);
    }

    static {
        moduleKindMap.put("plain", ModuleKind.PLAIN);
        moduleKindMap.put("commonjs", ModuleKind.COMMON_JS);
        moduleKindMap.put("amd", ModuleKind.AMD);
        moduleKindMap.put("umd", ModuleKind.UMD);
        sourceMapContentEmbeddingMap.put("always", SourceMapSourceEmbedding.ALWAYS);
        sourceMapContentEmbeddingMap.put("never", SourceMapSourceEmbedding.NEVER);
        sourceMapContentEmbeddingMap.put("inlining", SourceMapSourceEmbedding.INLINING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "$self";
                break;
            }
            case 2: 
            case 10: 
            case 36: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allKotlinFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsAnalysisResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 7: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDisposable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 33: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIrCompiler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLibraries";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerformanceManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPlatformOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateSourceFileNames";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "reportCompiledSourcesList";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatformSpecificArgumentsAndServices";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "configureLibraries";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "calculateSourceMapSourceRoot";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createMetadataVersion";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class K2JSCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2JSCompilerPerformanceManager() {
            super("Kotlin to JS Compiler");
        }
    }
}

