/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirPartiallyResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.resolve.AnnotationTargetLists;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotatedDeclarationChecker;", "()V", "deprecatedClassId", "Lorg/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinClassId", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAnnotationTarget", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "checkAnnotationUseSiteTarget", "annotated", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "checkDeprecatedCalls", "deprecatedSinceKotlinCall", "deprecatedCall", "getActualTargetList", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetList;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkers"})
public final class FirAnnotationChecker
extends FirDeclarationChecker<FirAnnotatedDeclaration> {
    @NotNull
    public static final FirAnnotationChecker INSTANCE = new FirAnnotationChecker();
    @NotNull
    private static final FqName deprecatedClassId = new FqName("kotlin.Deprecated");
    @NotNull
    private static final FqName deprecatedSinceKotlinClassId = new FqName("kotlin.DeprecatedSinceKotlin");

    private FirAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotatedDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirAnnotationCall deprecatedCall = null;
        FirAnnotationCall deprecatedSinceKotlinCall = null;
        for (FirAnnotationCall annotation2 : declaration2.getAnnotations()) {
            boolean bl;
            CheckerContext it;
            List<String> list2;
            FirAnnotationContainer firAnnotationContainer;
            FqName fqName2 = ResolveUtilsKt.fqName(annotation2, context2.getSession());
            if (Intrinsics.areEqual(fqName2, deprecatedClassId)) {
                deprecatedCall = annotation2;
            } else if (Intrinsics.areEqual(fqName2, deprecatedSinceKotlinClassId)) {
                deprecatedSinceKotlinCall = annotation2;
            }
            boolean $i$f$withSuppressedDiagnostics = false;
            FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)annotation2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)annotation2) : null;
            if (firAnnotationContainer == null) {
                list2 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer;
                boolean bl2 = false;
                boolean bl3 = false;
                FirAnnotationContainer it$iv = firAnnotationContainer3;
                boolean bl4 = false;
                list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv = list2;
            if (arguments$iv != null) {
                it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                bl = false;
                INSTANCE.checkAnnotationTarget(declaration2, annotation2, context2, reporter);
                continue;
            }
            it = context2;
            bl = false;
            INSTANCE.checkAnnotationTarget(declaration2, annotation2, context2, reporter);
        }
        if (deprecatedSinceKotlinCall != null) {
            List<String> list3;
            FirAnnotationContainer firAnnotationContainer;
            FirElement element$iv = deprecatedSinceKotlinCall;
            boolean $i$f$withSuppressedDiagnostics = false;
            FirAnnotationContainer firAnnotationContainer4 = firAnnotationContainer = element$iv instanceof FirAnnotationContainer ? (FirAnnotationContainer)element$iv : null;
            if (firAnnotationContainer == null) {
                list3 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer;
                boolean bl = false;
                boolean bl5 = false;
                FirAnnotationContainer it$iv = firAnnotationContainer5;
                boolean bl6 = false;
                list3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv = list3;
            if (arguments$iv != null) {
                CheckerContext it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                boolean bl = false;
                INSTANCE.checkDeprecatedCalls(deprecatedSinceKotlinCall, deprecatedCall, context2, reporter);
            } else {
                CheckerContext it = context2;
                boolean bl = false;
                INSTANCE.checkDeprecatedCalls(deprecatedSinceKotlinCall, deprecatedCall, context2, reporter);
            }
        }
    }

    private final void checkAnnotationTarget(FirAnnotatedDeclaration declaration2, FirAnnotationCall annotation2, CheckerContext context2, DiagnosticReporter reporter) {
        String string2;
        String targetDescription;
        FirSourceElement firSourceElement;
        if (declaration2 instanceof FirValueParameter && ((firSourceElement = declaration2.getSource()) == null ? false : LightTreePositioningStrategiesKt.hasValOrVar(firSourceElement))) {
            return;
        }
        AnnotationTargetList actualTargets = this.getActualTargetList(declaration2);
        Set<KotlinTarget> applicableTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession());
        AnnotationUseSiteTarget useSiteTarget = annotation2.getUseSiteTarget();
        if (useSiteTarget != null) {
            this.checkAnnotationUseSiteTarget(declaration2, annotation2, useSiteTarget, context2, reporter);
        }
        if (FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getDefaultTargets()) || FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getCanBeSubstituted()) || FirAnnotationChecker.checkAnnotationTarget$checkWithUseSiteTargets(useSiteTarget, actualTargets, applicableTargets)) {
            return;
        }
        KotlinTarget kotlinTarget = CollectionsKt.firstOrNull(actualTargets.getDefaultTargets());
        String string3 = kotlinTarget == null ? "unidentified target" : (targetDescription = (string2 = kotlinTarget.getDescription()) == null ? "unidentified target" : string2);
        if (useSiteTarget != null) {
            DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), targetDescription, useSiteTarget.getRenderName(), context2, null, 32, null);
        } else {
            DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), targetDescription, context2, null, 16, null);
        }
    }

    private final void checkAnnotationUseSiteTarget(FirAnnotatedDeclaration annotated, FirAnnotationCall annotation2, AnnotationUseSiteTarget target, CheckerContext context2, DiagnosticReporter reporter) {
        AnnotationUseSiteTarget annotationUseSiteTarget = target;
        int n = WhenMappings.$EnumSwitchMapping$0[annotationUseSiteTarget.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                if (!(annotated instanceof FirProperty) || ((FirProperty)annotated).getDelegateFieldSymbol() == null || FirDeclarationUtilKt.getHasBackingField((FirProperty)annotated)) break;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD(), context2, null, 8, null);
                break;
            }
            case 4: {
                if (!(annotated instanceof FirProperty) || ((FirProperty)annotated).getDelegateFieldSymbol() != null) break;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE(), context2, null, 8, null);
                break;
            }
            case 5: 
            case 6: {
                if (!(annotated instanceof FirProperty) || ((FirProperty)annotated).isLocal()) {
                    DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY(), target.getRenderName(), context2, null, 16, null);
                    break;
                }
                if (((FirProperty)annotated).isVar()) break;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_IMMUTABLE(), target.getRenderName(), context2, null, 16, null);
                break;
            }
            case 7: {
                FirSourceElement firSourceElement;
                if (annotated instanceof FirValueParameter) {
                    FirDeclaration container2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                    if (container2 instanceof FirConstructor && ((FirConstructor)container2).isPrimary()) {
                        DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION_TARGET(), target.getRenderName(), context2, null, 16, null);
                        break;
                    }
                    DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), context2, null, 8, null);
                    break;
                }
                if (annotated instanceof FirProperty && Intrinsics.areEqual((firSourceElement = annotated.getSource()) == null ? null : firSourceElement.getKind(), FirFakeSourceElementKind.PropertyFromParameter.INSTANCE)) break;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), context2, null, 8, null);
                break;
            }
            case 8: {
                if (annotated instanceof FirFile) break;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_FILE_TARGET(), context2, null, 8, null);
                break;
            }
            case 9: {
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), "declaration", target.getRenderName(), context2, null, 32, null);
            }
        }
    }

    private final void checkDeprecatedCalls(FirAnnotationCall deprecatedSinceKotlinCall, FirAnnotationCall deprecatedCall, CheckerContext context2, DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        block9: {
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration2;
                FirDeclaration firDeclaration3;
                FirDeclaration firDeclaration4;
                FirDeclaration firDeclaration5 = it$iv;
                if (!(firDeclaration5 instanceof FirFile)) {
                    firDeclaration5 = null;
                }
                if ((firDeclaration4 = (FirDeclaration)((FirFile)firDeclaration5)) == null) {
                    firDeclaration3 = null;
                } else {
                    FirDeclaration firDeclaration6 = firDeclaration4;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirDeclaration it = firDeclaration6;
                    firDeclaration3 = firDeclaration2 = true ? firDeclaration6 : null;
                }
                if (firDeclaration2 == null) continue;
                firDeclaration = firDeclaration2;
                break block9;
            }
            firDeclaration = null;
        }
        FirFile closestFirFile = (FirFile)firDeclaration;
        if (closestFirFile != null && !closestFirFile.getPackageFqName().startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE().shortName())) {
            DiagnosticReporterKt.reportOn$default(reporter, deprecatedSinceKotlinCall.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE(), context2, null, 8, null);
        }
        if (deprecatedCall == null) {
            DiagnosticReporterKt.reportOn$default(reporter, deprecatedSinceKotlinCall.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED(), context2, null, 8, null);
        } else {
            FirCall $this$argumentMapping$iv = deprecatedCall;
            boolean $i$f$getArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$argumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : (argumentList$iv instanceof FirPartiallyResolvedArgumentList ? ((FirPartiallyResolvedArgumentList)argumentList$iv).getMapping() : null);
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMapping = linkedHashMap;
            for (FirValueParameter value2 : argumentMapping.values()) {
                if (!Intrinsics.areEqual(value2.getName().getIdentifier(), "level")) continue;
                DiagnosticReporterKt.reportOn$default(reporter, deprecatedSinceKotlinCall.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL(), context2, null, 8, null);
                break;
            }
        }
    }

    private final AnnotationTargetList getActualTargetList(FirDeclaration annotated) {
        AnnotationTargetList annotationTargetList;
        FirDeclaration firDeclaration = annotated;
        if (firDeclaration instanceof FirRegularClass) {
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)annotated;
            boolean $i$f$isInner = false;
            FirRegularClass $this$isCompanion$iv = (FirRegularClass)annotated;
            boolean $i$f$isCompanion = false;
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)annotated;
            boolean $i$f$isLocal = false;
            AnnotationTargetList annotationTargetList2 = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(((FirRegularClass)annotated).getClassKind(), $this$isInner$iv.getStatus().isInner(), $this$isCompanion$iv.getStatus().isCompanion(), $this$isLocal$iv.getSymbol().getClassId().isLocal()), null, null, 6, null);
            annotationTargetList = annotationTargetList2;
        } else if (firDeclaration instanceof KtDestructuringDeclarationEntry) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_LOCAL_VARIABLE();
        } else if (firDeclaration instanceof FirProperty) {
            FirSourceElement $this$isLocal$iv;
            annotationTargetList = ((FirProperty)annotated).isLocal() ? (Intrinsics.areEqual(($this$isLocal$iv = annotated.getSource()) == null ? null : $this$isLocal$iv.getKind(), FirFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : AnnotationTargetLists.INSTANCE.getT_LOCAL_VARIABLE()) : (((FirProperty)annotated).getSymbol().getCallableId().getClassId() != null ? (Intrinsics.areEqual(($this$isLocal$iv = annotated.getSource()) == null ? null : $this$isLocal$iv.getKind(), FirFakeSourceElementKind.PropertyFromParameter.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.T_MEMBER_PROPERTY(FirDeclarationUtilKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null)) : AnnotationTargetLists.INSTANCE.T_TOP_LEVEL_PROPERTY(FirDeclarationUtilKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null));
        } else if (firDeclaration instanceof FirValueParameter) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITHOUT_VAL();
        } else if (firDeclaration instanceof FirConstructor) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_CONSTRUCTOR();
        } else if (firDeclaration instanceof FirAnonymousFunction) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_FUNCTION_EXPRESSION();
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)annotated;
            boolean $i$f$isLocal = false;
            annotationTargetList = Intrinsics.areEqual($this$isLocal$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_LOCAL_FUNCTION() : (((FirSimpleFunction)annotated).getSymbol().getCallableId().getClassId() != null ? AnnotationTargetLists.INSTANCE.getT_MEMBER_FUNCTION() : AnnotationTargetLists.INSTANCE.getT_TOP_LEVEL_FUNCTION());
        } else {
            FirSourceElement firSourceElement;
            annotationTargetList = firDeclaration instanceof FirTypeAlias ? AnnotationTargetLists.INSTANCE.getT_TYPEALIAS() : (firDeclaration instanceof FirPropertyAccessor ? (((FirPropertyAccessor)annotated).isGetter() ? AnnotationTargetLists.INSTANCE.getT_PROPERTY_GETTER() : AnnotationTargetLists.INSTANCE.getT_PROPERTY_SETTER()) : (firDeclaration instanceof FirFile ? AnnotationTargetLists.INSTANCE.getT_FILE() : (firDeclaration instanceof FirTypeParameter ? AnnotationTargetLists.INSTANCE.getT_TYPE_PARAMETER() : (firDeclaration instanceof FirAnonymousInitializer ? AnnotationTargetLists.INSTANCE.getT_INITIALIZER() : (firDeclaration instanceof KtDestructuringDeclaration ? AnnotationTargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : (firDeclaration instanceof KtLambdaExpression ? AnnotationTargetLists.INSTANCE.getT_FUNCTION_LITERAL() : (firDeclaration instanceof FirAnonymousObject ? (Intrinsics.areEqual((firSourceElement = annotated.getSource()) == null ? null : firSourceElement.getKind(), FirFakeSourceElementKind.EnumInitializer.INSTANCE) ? new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(ClassKind.ENUM_ENTRY, false, false, false), null, null, 6, null) : AnnotationTargetLists.INSTANCE.getT_OBJECT_LITERAL()) : AnnotationTargetLists.INSTANCE.getEMPTY())))))));
        }
        return annotationTargetList;
    }

    private static final boolean checkAnnotationTarget$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget, List<? extends KotlinTarget> targets) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget) == it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkAnnotationTarget$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget, AnnotationTargetList actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl;
        block4: {
            if (useSiteTarget == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget);
            Iterable $this$any$iv = actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 1;
            nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 2;
            nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 3;
            nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 4;
            nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 5;
            nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 6;
            nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 7;
            nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 8;
            nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

