/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirPartiallyResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.RequireKotlinConstants;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JP\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\"\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u001fj\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 `!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "annotationFqNamesWithVersion", "", "Lorg/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinFqName", "sinceKotlinFqName", "versionArgumentName", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAnnotationArgumentWithSubElements", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkAnnotationsWithVersion", "fqName", "annotationCall", "checkDeprecatedSinceKotlin", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "argumentMapping", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "parseVersionExpressionOrReport", "Lorg/jetbrains/kotlin/config/ApiVersion;", "checkers"})
public final class FirAnnotationArgumentChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirAnnotationArgumentChecker INSTANCE = new FirAnnotationArgumentChecker();
    @NotNull
    private static final Name versionArgumentName;
    @NotNull
    private static final FqName deprecatedSinceKotlinFqName;
    @NotNull
    private static final FqName sinceKotlinFqName;
    @NotNull
    private static final Set<FqName> annotationFqNamesWithVersion;

    private FirAnnotationArgumentChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Object $this$argumentMapping$iv = expression2;
        boolean $i$f$getArgumentMapping = false;
        FirArgumentList argumentList$iv22 = $this$argumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv22 instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv22).getMapping() : (argumentList$iv22 instanceof FirPartiallyResolvedArgumentList ? ((FirPartiallyResolvedArgumentList)argumentList$iv22).getMapping() : null);
        if (linkedHashMap == null) {
            return;
        }
        LinkedHashMap<FirExpression, FirValueParameter> argumentMapping = linkedHashMap;
        FqName fqName2 = ResolveUtilsKt.fqName(expression2, context2.getSession());
        Iterator<FirExpression> iterator2 = argumentMapping;
        boolean argumentList$iv22 = false;
        $this$argumentMapping$iv = iterator2.entrySet().iterator();
        while ($this$argumentMapping$iv.hasNext()) {
            Object object;
            Object object2;
            Iterator<FirExpression> iterator3 = iterator2 = (Map.Entry)$this$argumentMapping$iv.next();
            boolean bl = false;
            FirExpression arg = (FirExpression)iterator3.getKey();
            Object object3 = object2 = arg instanceof FirNamedArgumentExpression ? (FirNamedArgumentExpression)arg : null;
            Object argExpression = object2 == null ? arg : ((object = ((FirNamedArgumentExpression)object2).getExpression()) == null ? arg : object);
            if ((object2 = this.checkAnnotationArgumentWithSubElements((FirExpression)argExpression, context2.getSession(), reporter, context2)) == null) continue;
            object = object2;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            DiagnosticReporterKt.reportOn$default(reporter, ((FirExpression)argExpression).getSource(), (FirDiagnosticFactory0)it, context2, null, 8, null);
        }
        this.checkAnnotationsWithVersion(fqName2, expression2, context2, reporter);
        this.checkDeprecatedSinceKotlin(expression2.getSource(), fqName2, argumentMapping, context2, reporter);
        List<FirExpression> args = expression2.getArgumentList().getArguments();
        for (FirExpression arg : args) {
            for (FirAnnotationCall ann : FirExpressionUtilKt.unwrapArgument(arg).getAnnotations()) {
                DiagnosticReporterKt.reportOn$default(reporter, ann.getSource(), FirErrors.INSTANCE.getANNOTATION_USED_AS_ANNOTATION_ARGUMENT(), context2, null, 8, null);
            }
        }
    }

    private final FirDiagnosticFactory0 checkAnnotationArgumentWithSubElements(FirExpression expression2, FirSession session2, DiagnosticReporter reporter, CheckerContext context2) {
        FirExpression firExpression2 = expression2;
        if (firExpression2 instanceof FirArrayOfCall) {
            return FirAnnotationArgumentChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(session2, reporter, context2, ((FirArrayOfCall)expression2).getArgumentList());
        }
        if (firExpression2 instanceof FirVarargArgumentsExpression) {
            for (FirExpression arg : ((FirVarargArgumentsExpression)expression2).getArguments()) {
                FirExpression unwrappedArg = FirExpressionUtilKt.unwrapArgument(arg);
                FirDiagnosticFactory0 firDiagnosticFactory0 = this.checkAnnotationArgumentWithSubElements(unwrappedArg, session2, reporter, context2);
                if (firDiagnosticFactory0 == null) continue;
                FirDiagnosticFactory0 firDiagnosticFactory02 = firDiagnosticFactory0;
                boolean bl = false;
                boolean bl2 = false;
                FirDiagnosticFactory0 it = firDiagnosticFactory02;
                boolean bl3 = false;
                DiagnosticReporterKt.reportOn$default(reporter, unwrappedArg.getSource(), it, context2, null, 8, null);
            }
        } else {
            FirDiagnosticFactory0 firDiagnosticFactory0;
            ConstantArgumentKind constantArgumentKind = FirConstChecksKt.checkConstantArguments(expression2, session2);
            int n = constantArgumentKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[constantArgumentKind.ordinal()];
            switch (n) {
                case 1: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_CONST();
                    break;
                }
                case 2: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST();
                    break;
                }
                case 3: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL();
                    break;
                }
                case 4: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR();
                    break;
                }
                case 5: {
                    firDiagnosticFactory0 = FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
                    break;
                }
                case -1: {
                    if (expression2 instanceof FirFunctionCall) {
                        firDiagnosticFactory0 = FirAnnotationArgumentChecker.checkAnnotationArgumentWithSubElements$checkArgumentList(session2, reporter, context2, ((FirFunctionCall)expression2).getArgumentList());
                        break;
                    }
                    firDiagnosticFactory0 = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return firDiagnosticFactory0;
        }
        return null;
    }

    private final ApiVersion parseVersionExpressionOrReport(FirExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        Object object;
        Object object2;
        Object object3;
        FirConstExpression firConstExpression;
        FirConstExpression firConstExpression2 = firConstExpression = expression2 instanceof FirConstExpression ? (FirConstExpression)expression2 : null;
        if (firConstExpression == null) {
            FirNamedArgumentExpression firNamedArgumentExpression = expression2 instanceof FirNamedArgumentExpression ? (FirNamedArgumentExpression)expression2 : null;
            object3 = firNamedArgumentExpression == null ? null : firNamedArgumentExpression.getExpression();
            Object object4 = object2 = object3 instanceof FirConstExpression ? (FirConstExpression)object3 : null;
            if (object2 == null) {
                return null;
            }
            object = object2;
        } else {
            object = firConstExpression;
        }
        FirConstExpression constantExpression = object;
        object3 = constantExpression.getValue();
        Object object5 = object2 = object3 instanceof String ? (String)object3 : null;
        if (object2 == null) {
            return null;
        }
        String stringValue = object2;
        object2 = stringValue;
        object3 = RequireKotlinConstants.INSTANCE.getVERSION_REGEX();
        boolean bl = false;
        if (!((Regex)object3).matches((CharSequence)object2)) {
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), context2, null, 8, null);
            return null;
        }
        ApiVersion version = ApiVersion.Companion.parse(stringValue);
        if (version == null) {
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), context2, null, 8, null);
        }
        return version;
    }

    private final void checkAnnotationsWithVersion(FqName fqName2, FirAnnotationCall annotationCall, CheckerContext context2, DiagnosticReporter reporter) {
        ApiVersion specified;
        if (!CollectionsKt.contains((Iterable)annotationFqNamesWithVersion, fqName2)) {
            return;
        }
        FirExpression firExpression2 = FirAnnotationHelpersKt.findArgumentByName(annotationCall, versionArgumentName);
        if (firExpression2 == null) {
            return;
        }
        FirExpression versionExpression = firExpression2;
        ApiVersion apiVersion = this.parseVersionExpressionOrReport(versionExpression, context2, reporter);
        if (apiVersion == null) {
            return;
        }
        ApiVersion version = apiVersion;
        if (Intrinsics.areEqual(fqName2, sinceKotlinFqName) && version.compareTo(specified = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).getApiVersion()) > 0) {
            DiagnosticReporterKt.reportOn$default(reporter, versionExpression.getSource(), FirErrors.INSTANCE.getNEWER_VERSION_IN_SINCE_KOTLIN(), specified.getVersionString(), context2, null, 16, null);
        }
    }

    private final void checkDeprecatedSinceKotlin(FirSourceElement source, FqName fqName2, LinkedHashMap<FirExpression, FirValueParameter> argumentMapping, CheckerContext context2, DiagnosticReporter reporter) {
        if (!Intrinsics.areEqual(fqName2, deprecatedSinceKotlinFqName)) {
            return;
        }
        if (argumentMapping.size() == 0) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS(), context2, null, 8, null);
        }
        ApiVersion warningSince = null;
        ApiVersion errorSince = null;
        ApiVersion hiddenSince = null;
        Map map = argumentMapping;
        boolean bl = false;
        for (Map.Entry argument2 : map.entrySet()) {
            block33: {
                String string2 = ((FirValueParameter)argument2.getValue()).getName().getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string2, "argument.value.name.identifier");
                switch (string2) {
                    case "hiddenSince": 
                    case "warningSince": 
                    case "errorSince": {
                        String identifier;
                        ApiVersion version = this.parseVersionExpressionOrReport((FirExpression)argument2.getKey(), context2, reporter);
                        if (version == null) break;
                        switch (identifier) {
                            case "warningSince": {
                                warningSince = version;
                                break block33;
                            }
                            case "errorSince": {
                                errorSince = version;
                                break block33;
                            }
                            case "hiddenSince": {
                                hiddenSince = version;
                            }
                        }
                    }
                }
            }
        }
        boolean isReportDeprecatedSinceKotlinWithUnorderedVersions = false;
        if (warningSince != null) {
            if (errorSince != null) {
                boolean bl2 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(errorSince) > 0;
            }
            if (hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
                boolean bl3 = isReportDeprecatedSinceKotlinWithUnorderedVersions = warningSince.compareTo(hiddenSince) > 0;
            }
        }
        if (errorSince != null && hiddenSince != null && !isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            boolean bl4 = isReportDeprecatedSinceKotlinWithUnorderedVersions = errorSince.compareTo(hiddenSince) > 0;
        }
        if (isReportDeprecatedSinceKotlinWithUnorderedVersions) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS(), context2, null, 8, null);
        }
    }

    private static final FirDiagnosticFactory0 checkAnnotationArgumentWithSubElements$checkArgumentList(FirSession $session, DiagnosticReporter $reporter, CheckerContext $context, FirArgumentList args) {
        boolean usedNonConst = false;
        for (FirExpression arg : args.getArguments()) {
            FirSourceElement sourceForReport = arg.getSource();
            FirDiagnosticFactory0 err = INSTANCE.checkAnnotationArgumentWithSubElements(arg, $session, $reporter, $context);
            if (err == null) continue;
            if (!Intrinsics.areEqual(err, FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL())) {
                usedNonConst = true;
            }
            DiagnosticReporterKt.reportOn$default($reporter, sourceForReport, err, $context, null, 8, null);
        }
        return usedNonConst ? FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION() : null;
    }

    static {
        FqName[] fqNameArray = Name.identifier("version");
        Intrinsics.checkNotNullExpressionValue(fqNameArray, "identifier(\"version\")");
        versionArgumentName = fqNameArray;
        deprecatedSinceKotlinFqName = new FqName("kotlin.DeprecatedSinceKotlin");
        sinceKotlinFqName = new FqName("kotlin.SinceKotlin");
        fqNameArray = new FqName[]{RequireKotlinConstants.INSTANCE.getFQ_NAME(), sinceKotlinFqName};
        annotationFqNamesWithVersion = SetsKt.setOf(fqNameArray);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantArgumentKind.values().length];
            nArray[ConstantArgumentKind.NOT_CONST.ordinal()] = 1;
            nArray[ConstantArgumentKind.ENUM_NOT_CONST.ordinal()] = 2;
            nArray[ConstantArgumentKind.NOT_KCLASS_LITERAL.ordinal()] = 3;
            nArray[ConstantArgumentKind.KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR.ordinal()] = 4;
            nArray[ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

