/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/java/FirJavaVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "()V", "platformVisibilityCheck", "", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "java"})
public final class FirJavaVisibilityChecker
extends FirVisibilityChecker {
    @NotNull
    public static final FirJavaVisibilityChecker INSTANCE = new FirJavaVisibilityChecker();

    private FirJavaVisibilityChecker() {
    }

    @Override
    protected boolean platformVisibilityCheck(@NotNull Visibility declarationVisibility, @NotNull AbstractFirBasedSymbol<?> symbol2, @NotNull FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @Nullable ReceiverValue dispatchReceiver, @NotNull FirSession session2) {
        ClassId ownerId;
        Intrinsics.checkNotNullParameter(declarationVisibility, "declarationVisibility");
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(useSiteFile, "useSiteFile");
        Intrinsics.checkNotNullParameter(containingDeclarations, "containingDeclarations");
        Intrinsics.checkNotNullParameter(session2, "session");
        Visibility visibility2 = declarationVisibility;
        return (Intrinsics.areEqual(visibility2, JavaVisibilities.ProtectedAndPackage.INSTANCE) ? true : Intrinsics.areEqual(visibility2, JavaVisibilities.ProtectedStaticVisibility.INSTANCE)) ? (Intrinsics.areEqual(this.packageFqName(symbol2), useSiteFile.getPackageFqName()) ? true : (ownerId = FirVisibilityCheckerKt.getOwnerId(symbol2)) != null && this.canSeeProtectedMemberOf(containingDeclarations, dispatchReceiver, ownerId, session2)) : (Intrinsics.areEqual(visibility2, JavaVisibilities.PackageVisibility.INSTANCE) ? Intrinsics.areEqual(this.packageFqName(symbol2), useSiteFile.getPackageFqName()) : true);
    }
}

