/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractExplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractExplicitReceiverValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "explicitReceiver", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "getExplicitReceiver", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "resolve"})
public final class ExpressionReceiverValue
extends AbstractExplicitReceiverValue<FirExpression>
implements ReceiverValue {
    @NotNull
    private final FirExpression explicitReceiver;

    public ExpressionReceiverValue(@NotNull FirExpression explicitReceiver) {
        Intrinsics.checkNotNullParameter(explicitReceiver, "explicitReceiver");
        this.explicitReceiver = explicitReceiver;
    }

    @Override
    @NotNull
    public FirExpression getExplicitReceiver() {
        return this.explicitReceiver;
    }

    @Override
    @Nullable
    public FirTypeScope scope(@NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirExpression firExpression2 = this.getReceiverExpression();
        FirExpressionWithSmartcast firExpressionWithSmartcast = firExpression2 instanceof FirExpressionWithSmartcast ? (FirExpressionWithSmartcast)firExpression2 : null;
        FirTypeScope firTypeScope = firExpressionWithSmartcast == null ? null : ScopeUtilsKt.smartcastScope(firExpressionWithSmartcast, useSiteSession, scopeSession);
        return firTypeScope == null ? ScopeUtilsKt.scope(this.getType(), useSiteSession, scopeSession, FakeOverrideTypeCalculator.DoNothing.INSTANCE) : firTypeScope;
    }
}

