/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001<B\u001d\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB\u001d\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\fB%\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0010B+\b\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0014J\u0006\u00100\u001a\u00020\bJ\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000fJ\u0012\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0002J\u0014\u00108\u001a\u0002052\n\b\u0002\u00109\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010:\u001a\u0002052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010;\u001a\u00020\bH\u0016R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001d\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "", "common", "Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "stackTrace", "", "", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Common;Ljava/util/List;)V", "wrapper", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;Ljava/util/List;)V", "exception", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Ljava/lang/Throwable;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;Ljava/util/List;)V", "cause", "getCause", "()Ljava/lang/Throwable;", "causeProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exceptionFqName", "exceptionHierarchy", "getFields", "()Ljava/util/List;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "message", "getMessage", "()Ljava/lang/String;", "messageProperty", "outerClass", "getOuterClass", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "setOuterClass", "(Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;)V", "superWrapperClass", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "upValues", "getUpValues", "getFullDescription", "isSubtypeOf", "", "ancestor", "setCause", "", "causeValue", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "setMessage", "messageValue", "setUpCauseIfNeeded", "toString", "Companion", "ir.interpreter"})
public final class ExceptionState
extends Throwable
implements Complex,
StateWithClosure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final List<Variable> fields;
    @NotNull
    private final List<Variable> upValues;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Variable outerClass;
    private String exceptionFqName;
    @NotNull
    private final List<String> exceptionHierarchy;
    @NotNull
    private final IrProperty messageProperty;
    @NotNull
    private final IrProperty causeProperty;
    @NotNull
    private final List<String> stackTrace;

    private ExceptionState(IrClass irClass2, List<Variable> fields2, List<String> stackTrace) {
        boolean bl;
        block5: {
            this.irClass = irClass2;
            this.fields = fields2;
            boolean bl2 = false;
            this.upValues = new ArrayList();
            bl2 = false;
            this.exceptionHierarchy = new ArrayList();
            this.messageProperty = ExceptionState.Companion.getPropertyByName(this.getIrClass(), "message");
            this.causeProperty = ExceptionState.Companion.getPropertyByName(this.getIrClass(), "cause");
            this.stackTrace = CollectionsKt.reversed((Iterable)stackTrace);
            if (this.exceptionFqName == null) {
                this.exceptionFqName = this.irClassFqName();
            }
            Iterable $this$none$iv = this.getFields();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Variable it = (Variable)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getSymbol(), this.messageProperty.getSymbol())) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            ExceptionState.setMessage$default(this, null, 1, null);
        }
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public List<Variable> getUpValues() {
        return this.upValues;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Variable getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Variable variable2) {
        this.outerClass = variable2;
    }

    @Override
    @Nullable
    public String getMessage() {
        State state = this.getField(this.messageProperty.getSymbol());
        return state == null ? null : StateKt.asStringOrNull(state);
    }

    @Override
    @Nullable
    public Throwable getCause() {
        ExceptionState exceptionState;
        State state = this.getField(this.causeProperty.getSymbol());
        if (state == null) {
            exceptionState = null;
        } else {
            State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            State it = state2;
            boolean bl3 = false;
            exceptionState = it instanceof ExceptionState ? (ExceptionState)it : null;
        }
        return exceptionState;
    }

    public ExceptionState(@NotNull Common common, @NotNull List<String> stackTrace) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(common, "common");
        Intrinsics.checkNotNullParameter(stackTrace, "stackTrace");
        this(common.getIrClass(), common.getFields(), stackTrace);
        Wrapper wrapper = common.getSuperWrapperClass();
        Object object = wrapper == null ? null : wrapper.getValue();
        Throwable throwable2 = throwable = object instanceof Throwable ? (Throwable)object : null;
        if (throwable != null) {
            object = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            this.setMessage(((Throwable)it).getMessage());
        }
        this.setUpCauseIfNeeded(common.getSuperWrapperClass());
    }

    public ExceptionState(@NotNull Wrapper wrapper, @NotNull List<String> stackTrace) {
        Intrinsics.checkNotNullParameter(wrapper, "wrapper");
        Intrinsics.checkNotNullParameter(stackTrace, "stackTrace");
        this((Throwable)wrapper.getValue(), wrapper.getIrClass(), stackTrace);
        this.setUpCauseIfNeeded(wrapper);
    }

    public ExceptionState(@NotNull Throwable exception, @NotNull IrClass irClass2, @NotNull List<String> stackTrace) {
        Intrinsics.checkNotNullParameter(exception, "exception");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(stackTrace, "stackTrace");
        this(irClass2, ExceptionState.Companion.evaluateFields(exception, irClass2, stackTrace), CollectionsKt.plus((Collection)stackTrace, (Iterable)ExceptionState.Companion.evaluateAdditionalStackTrace(exception)));
        this.setCause(null);
        if (!Intrinsics.areEqual(irClass2.getName().asString(), exception.getClass().getSimpleName())) {
            String string2;
            Object object = exception.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(object, "exception::class.java.name");
            this.exceptionFqName = object;
            object = this;
            Collection collection = ((ExceptionState)object).exceptionHierarchy;
            Object object2 = this.exceptionFqName;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string2 = null;
            } else {
                string2 = object2;
            }
            object2 = string2;
            boolean bl = false;
            collection.add(object2);
            Sequence<Class<?>> $this$forEach$iv = SequencesKt.generateSequence(exception.getClass().getSuperclass(), (Function1)4.INSTANCE);
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                Class it = (Class)element$iv;
                boolean bl2 = false;
                ExceptionState exceptionState = this;
                Collection collection2 = exceptionState.exceptionHierarchy;
                String string3 = it.getName();
                boolean bl3 = false;
                collection2.add(string3);
            }
            this.exceptionHierarchy.remove(CollectionsKt.getLastIndex(this.exceptionHierarchy));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpCauseIfNeeded(Wrapper wrapper) {
        Object object = wrapper;
        Object object2 = object == null ? null : ((Wrapper)object).getValue();
        Object object3 = object2 instanceof Throwable ? (Throwable)object2 : null;
        Throwable throwable = object3 == null ? null : ((Throwable)object3).getCause();
        ExceptionState cause = throwable instanceof ExceptionState ? (ExceptionState)throwable : null;
        this.setCause(cause);
        if (this.getMessage() == null && cause != null) {
            Object object4;
            Object object5;
            object3 = cause.exceptionFqName;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                object5 = null;
            } else {
                object5 = object3;
            }
            object3 = cause.getMessage();
            if (object3 == null) {
                object4 = "";
            } else {
                void it;
                object = object3;
                boolean bl = false;
                boolean bl2 = false;
                Object object6 = object;
                Object object7 = object5;
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus(": ", it);
                object5 = object7;
                object2 = string2;
                object4 = object2 == null ? "" : object2;
            }
            String causeMessage = Intrinsics.stringPlus((String)object5, object4);
            this.setMessage(causeMessage);
        }
    }

    public final boolean isSubtypeOf(@NotNull IrClass ancestor) {
        Intrinsics.checkNotNullParameter(ancestor, "ancestor");
        Collection collection = this.exceptionHierarchy;
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean bl2;
            block4: {
                Iterable $this$any$iv = this.exceptionHierarchy;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        CharSequence charSequence = it;
                        String string2 = ancestor.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string2, "ancestor.name.asString()");
                        if (!StringsKt.contains$default(charSequence, string2, false, 2, null)) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        return IrUtilsKt.isSubclassOf(this.getIrClass(), ancestor);
    }

    private final void setMessage(String messageValue) {
        IrSymbol irSymbol2 = this.messageProperty.getSymbol();
        IrSimpleFunction irSimpleFunction = this.messageProperty.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        this.setField(new Variable(irSymbol2, new Primitive<String>(messageValue, irSimpleFunction.getReturnType())));
    }

    static /* synthetic */ void setMessage$default(ExceptionState exceptionState, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        exceptionState.setMessage(string2);
    }

    private final void setCause(State causeValue) {
        State state;
        IrSymbol irSymbol2 = this.causeProperty.getSymbol();
        State state2 = causeValue;
        if (state2 == null) {
            IrSimpleFunction irSimpleFunction = this.causeProperty.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction);
            state = new Primitive<Object>(null, irSimpleFunction.getReturnType());
        } else {
            state = state2;
        }
        this.setField(new Variable(irSymbol2, state));
    }

    @NotNull
    public final String getFullDescription() {
        Object object;
        Object object2;
        boolean bl;
        String string2 = this.getMessage();
        boolean bl2 = false;
        boolean bl3 = false;
        String it = string2;
        boolean bl4 = false;
        String string3 = it;
        if (string3 == null) {
            bl = false;
        } else {
            CharSequence charSequence = string3;
            boolean bl5 = false;
            bl = charSequence.length() > 0;
        }
        String message2 = bl ? Intrinsics.stringPlus(": ", it) : "";
        Collection collection = this.stackTrace;
        bl3 = false;
        String prefix = !collection.isEmpty() ? "\n\t" : "";
        String postfix = this.stackTrace.size() > 10 ? "\n\t..." : "";
        Object object3 = this.getCause();
        Object object4 = object2 = object3 instanceof ExceptionState ? (ExceptionState)object3 : null;
        String causeMessage = object2 == null ? "" : ((string3 = StringsKt.replaceFirst$default((String)(object3 = ((ExceptionState)object2).getFullDescription()), "Exception ", "\nCaused by: ", false, 4, null)) == null ? "" : string3);
        StringBuilder stringBuilder2 = new StringBuilder().append("Exception ");
        object2 = this.exceptionFqName;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
            object = null;
        } else {
            object = object2;
        }
        int n = this.stackTrace.size();
        int n2 = 10;
        boolean bl6 = false;
        return stringBuilder2.append((String)object).append(message2).append(CollectionsKt.joinToString$default(this.stackTrace.subList(0, Math.min(n, n2)), "\n\t", prefix, postfix, 0, null, null, 56, null)).append(causeMessage).toString();
    }

    @Override
    @NotNull
    public String toString() {
        String string2;
        String string3;
        String string4 = this.getMessage();
        if (string4 == null) {
            string3 = null;
        } else {
            String string5;
            String string6 = string4;
            boolean bl = false;
            boolean bl2 = false;
            String it = string6;
            boolean bl3 = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            String string7 = this.exceptionFqName;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string5 = null;
            } else {
                string5 = string7;
            }
            string3 = stringBuilder2.append(string5).append(": ").append(it).toString();
        }
        String string8 = string3;
        if (string8 == null) {
            string4 = this.exceptionFqName;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string2 = null;
            } else {
                string2 = string4;
            }
        } else {
            string2 = string8;
        }
        return string2;
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        return Complex.DefaultImpls.getField(this, symbol2);
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        return Complex.DefaultImpls.getIrFunctionByIrCall(this, expression2);
    }

    @Override
    @NotNull
    public IrSimpleFunction getOverridden(@NotNull IrSimpleFunction owner) {
        return Complex.DefaultImpls.getOverridden(this, owner);
    }

    @Override
    @NotNull
    public String irClassFqName() {
        return Complex.DefaultImpls.irClassFqName(this);
    }

    @Override
    public void setField(@NotNull Variable newVar) {
        Complex.DefaultImpls.setField(this, newVar);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion;", "", "()V", "evaluateAdditionalStackTrace", "", "", "e", "", "evaluateFields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "exception", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stackTrace", "getPropertyByName", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "name", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        private final IrProperty getPropertyByName(IrClass $this$getPropertyByName, String name) {
            Iterable $this$single$iv = $this$getPropertyByName.getDeclarations();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), name)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty property2 = single$iv;
            IrSimpleFunction irSimpleFunction = property2.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction);
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)UtilsKt.getLastOverridden(irSimpleFunction)).getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(irPropertySymbol);
            return (IrProperty)irPropertySymbol.getOwner();
        }

        /*
         * WARNING - void declaration
         */
        private final List<Variable> evaluateFields(Throwable exception, IrClass irClass2, List<String> stackTrace) {
            Object object;
            List<Variable> list2;
            Object object2;
            boolean bl;
            Variable[] variableArray;
            Variable variable2;
            IrProperty messageProperty = this.getPropertyByName(irClass2, "message");
            IrProperty causeProperty = this.getPropertyByName(irClass2, "cause");
            IrSymbol irSymbol2 = messageProperty.getSymbol();
            String string2 = exception.getMessage();
            IrSimpleFunction irSimpleFunction = messageProperty.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction);
            Variable messageVar = new Variable(irSymbol2, UtilsKt.toState(string2, irSimpleFunction.getReturnType()));
            Variable[] variableArray2 = exception.getCause();
            if (variableArray2 == null) {
                variable2 = null;
            } else {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                variableArray = variableArray2;
                boolean bl2 = false;
                bl = false;
                Variable[] it = variableArray;
                boolean bl3 = false;
                IrSymbol irSymbol3 = causeProperty.getSymbol();
                Collection collection2 = stackTrace;
                Object object3 = it.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(object3, "it.stackTrace");
                object3 = ArraysKt.reversed((Object[])object3);
                object2 = collection2;
                IrClass irClass3 = irClass2;
                Variable[] variableArray3 = it;
                IrSymbol irSymbol4 = irSymbol3;
                boolean $i$f$map = false;
                void var20_23 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string3 = Intrinsics.stringPlus("at ", it2);
                    collection.add(string3);
                }
                collection = (List)destination$iv$iv;
                List<String> list3 = CollectionsKt.plus(object2, (Iterable)collection);
                IrClass irClass4 = irClass3;
                Variable[] variableArray4 = variableArray3;
                State state = new ExceptionState((Throwable)variableArray4, irClass4, list3);
                IrSymbol irSymbol5 = irSymbol4;
                variable2 = new Variable(irSymbol5, state);
            }
            Variable causeVar = variable2;
            variableArray = causeVar;
            if (variableArray == null) {
                list2 = null;
            } else {
                Variable[] variableArray5 = variableArray;
                bl = false;
                boolean bl5 = false;
                Variable[] it = variableArray5;
                boolean bl6 = false;
                object2 = new Variable[]{messageVar, it};
                list2 = CollectionsKt.mutableListOf(object2);
            }
            variableArray2 = list2;
            if (variableArray2 == null) {
                variableArray = new Variable[]{messageVar};
                object = CollectionsKt.mutableListOf(variableArray);
            } else {
                object = variableArray2;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> evaluateAdditionalStackTrace(Throwable e) {
            boolean bl;
            Object[] $this$any$iv;
            List additionalStack;
            block6: {
                boolean bl2 = false;
                additionalStack = new ArrayList();
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
                $this$any$iv = stackTraceElementArray;
                boolean $i$f$any22 = false;
                for (Object object : $this$any$iv) {
                    StackTraceElement it = (StackTraceElement)object;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getClassName(), "java.lang.invoke.MethodHandle")) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                StackTraceElement[] $i$f$any22 = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue($i$f$any22, "e.stackTrace");
                $this$any$iv = $i$f$any22;
                int n = $this$any$iv.length;
                for (int $i$f$any22 = 0; $i$f$any22 < n; ++$i$f$any22) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    int index2 = $i$f$any22;
                    Object stackTraceElement = $this$any$iv[$i$f$any22];
                    if (!Intrinsics.areEqual(((StackTraceElement)stackTraceElement).getMethodName(), "invokeWithArguments")) continue;
                    StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
                    Iterable iterable = CollectionsKt.reversed((Iterable)ArraysKt.slice((Object[])stackTraceElementArray, RangesKt.until(0, index2)));
                    List list2 = additionalStack;
                    boolean $i$f$map = false;
                    Iterable bl3 = iterable;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StackTraceElement stackTraceElement2 = (StackTraceElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        String string2 = Intrinsics.stringPlus("at ", it);
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    list2.addAll((Collection)collection);
                    break;
                }
                Object object = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(object, "e.stackTrace");
                object = ArraysKt.first((Object[])object);
                int n2 = 0;
                int n3 = 0;
                StackTraceElement stackTraceElement = (StackTraceElement)object;
                boolean bl5 = false;
                String lastNeededValue = stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName();
                block3: for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "cause.stackTrace");
                    object = stackTraceElementArray;
                    n3 = ((StackTraceElement[])object).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        int n4 = n2;
                        StackTraceElement[] causeStackTraceElement = object[n2];
                        StackTraceElement[] stackTraceElementArray2 = causeStackTraceElement;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        StackTraceElement[] it2 = stackTraceElementArray2;
                        boolean bl8 = false;
                        String currentStackTraceValue = it2.getClassName() + '.' + it2.getMethodName();
                        if (!Intrinsics.areEqual(currentStackTraceValue, lastNeededValue)) continue;
                        stackTraceElementArray2 = cause.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray2, "cause.stackTrace");
                        cause.setStackTrace((StackTraceElement[])ArraysKt.reversedArray(ArraysKt.sliceArray((Object[])stackTraceElementArray2, RangesKt.until(0, n4))));
                        continue block3;
                    }
                }
            }
            return additionalStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

