/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsObjectLiteral
extends JsLiteral {
    private final List<JsPropertyInitializer> properties;
    private boolean multiline;

    public JsObjectLiteral() {
        this(new SmartList<JsPropertyInitializer>());
    }

    public JsObjectLiteral(boolean multiline) {
        this(new SmartList<JsPropertyInitializer>(), multiline);
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public JsObjectLiteral(List<JsPropertyInitializer> properties2) {
        this(properties2, false);
    }

    public JsObjectLiteral(List<JsPropertyInitializer> properties2, boolean multiline) {
        this.properties = properties2;
        this.multiline = multiline;
    }

    public List<JsPropertyInitializer> getPropertyInitializers() {
        return this.properties;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitObjectLiteral(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.properties);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx2) {
        if (v.visit(this, ctx2)) {
            v.acceptList(this.properties);
        }
        v.endVisit(this, ctx2);
    }

    @Override
    @NotNull
    public JsObjectLiteral deepCopy() {
        JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(AstUtil.deepCopy(this.properties), this.multiline).withMetadataFrom(this);
        if (jsObjectLiteral == null) {
            JsObjectLiteral.$$$reportNull$$$0(0);
        }
        return jsObjectLiteral;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsObjectLiteral", "deepCopy"));
    }
}

