/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016JB\u0010\u000b\u001a&\u0012\u0004\u0012\u00020\r\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedSyntheticExtensionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "computeSuitableDescriptorAndError", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "descriptor", "Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;", "frontend.java"})
public final class ProtectedSyntheticExtensionCallChecker
implements CallChecker {
    @NotNull
    public static final ProtectedSyntheticExtensionCallChecker INSTANCE = new ProtectedSyntheticExtensionCallChecker();

    private ProtectedSyntheticExtensionCallChecker() {
    }

    @NotNull
    public final Pair<FunctionDescriptor, DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor>> computeSuitableDescriptorAndError(@NotNull SyntheticJavaPropertyDescriptor descriptor2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        KtExpression ktExpression;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        CallPosition callPosition = context2.getResolutionContext().callPosition;
        Intrinsics.checkNotNullExpressionValue(callPosition, "context.resolutionContext.callPosition");
        CallPosition callPosition2 = callPosition;
        boolean isLeftSide = callPosition2 instanceof CallPosition.PropertyAssignment && Intrinsics.areEqual((ktDotQualifiedExpression = (ktExpression = ((CallPosition.PropertyAssignment)callPosition2).getLeftPart()) instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null) == null ? null : ktDotQualifiedExpression.getSelectorExpression(), reportOn);
        FunctionDescriptor getMethod = descriptor2.getGetMethod();
        FunctionDescriptor setMethod = descriptor2.getSetMethod();
        boolean isImprovingDiagnosticsEnabled = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ImproveReportingDiagnosticsOnProtectedMembersOfBaseClass);
        boolean needToTakeSetter = isImprovingDiagnosticsEnabled && isLeftSide;
        FunctionDescriptor suitableDescriptor = needToTakeSetter && setMethod != null ? setMethod : getMethod;
        return TuplesKt.to(suitableDescriptor, needToTakeSetter && setMethod != null ? Errors.INVISIBLE_SETTER : Errors.INVISIBLE_MEMBER);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        DeclarationDescriptor from;
        DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor> error;
        Object descriptor2;
        block8: {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context2, "context");
            descriptor2 = resolvedCall2.getResultingDescriptor();
            if (!(descriptor2 instanceof SyntheticJavaPropertyDescriptor)) {
                return;
            }
            Pair<FunctionDescriptor, DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor>> pair = this.computeSuitableDescriptorAndError((SyntheticJavaPropertyDescriptor)descriptor2, reportOn, context2);
            FunctionDescriptor sourceFunction = pair.component1();
            error = pair.component2();
            from = context2.getScope().getOwnerDescriptor();
            if (!DescriptorVisibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)descriptor2, from)) {
                return;
            }
            if (resolvedCall2.getDispatchReceiver() != null && resolvedCall2.getExtensionReceiver() == null) {
                return;
            }
            ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
            if (receiverValue == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
            }
            ReceiverValue receiverValue2 = receiverValue;
            Collection collection = CollectionsKt.listOf(receiverValue2.getType());
            DataFlowInfo dataFlowInfo = context2.getDataFlowInfo();
            DataFlowValueFactory dataFlowValueFactory = context2.getDataFlowValueFactory();
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
            List receiverTypes = CollectionsKt.plus(collection, (Iterable)dataFlowInfo.getStableTypes(dataFlowValueFactory.createDataFlowValue(receiverValue2, bindingContext, context2.getScope().getOwnerDescriptor()), context2.getLanguageVersionSettings()));
            Iterable $this$none$iv = receiverTypes;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!DescriptorVisibilities.isVisible(SmartCastUtilKt.getReceiverValueWithSmartCast(null, it), sourceFunction, from)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            context2.getTrace().report(error.on(reportOn, (DeclarationDescriptor)descriptor2, ((SyntheticJavaPropertyDescriptor)descriptor2).getVisibility(), from));
        }
    }
}

