/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.osx;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.io.IOException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jna.osx.CLibrary;

public class OsXNativePty
extends JnaNativePty {
    private static final CLibrary C_LIBRARY = Native.loadLibrary(Platform.C_LIBRARY_NAME, CLibrary.class);

    public static OsXNativePty current() throws IOException {
        int slave = 0;
        byte[] buf = new byte[64];
        C_LIBRARY.ttyname_r(slave, buf, buf.length);
        int len = 0;
        while (buf[len] != 0) {
            ++len;
        }
        String name = new String(buf, 0, len);
        return new OsXNativePty(-1, null, slave, FileDescriptor.in, name);
    }

    public static OsXNativePty open(Attributes attr, Size size) throws IOException {
        int[] master = new int[1];
        int[] slave = new int[1];
        byte[] buf = new byte[64];
        C_LIBRARY.openpty(master, slave, buf, attr != null ? new CLibrary.termios(attr) : null, size != null ? new CLibrary.winsize(size) : null);
        int len = 0;
        while (buf[len] != 0) {
            ++len;
        }
        String name = new String(buf, 0, len);
        return new OsXNativePty(master[0], OsXNativePty.newDescriptor(master[0]), slave[0], OsXNativePty.newDescriptor(slave[0]), name);
    }

    public OsXNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, String name) {
        super(master, masterFD, slave, slaveFD, name);
    }

    @Override
    public Attributes getAttr() throws IOException {
        CLibrary.termios termios2 = new CLibrary.termios();
        C_LIBRARY.tcgetattr(this.getSlave(), termios2);
        return termios2.toAttributes();
    }

    @Override
    public void setAttr(Attributes attr) throws IOException {
        CLibrary.termios termios2 = new CLibrary.termios(attr);
        C_LIBRARY.tcsetattr(this.getSlave(), 0, termios2);
    }

    @Override
    public Size getSize() throws IOException {
        CLibrary.winsize sz = new CLibrary.winsize();
        C_LIBRARY.ioctl(this.getSlave(), new NativeLong(1074295912L), sz);
        return sz.toSize();
    }

    @Override
    public void setSize(Size size) throws IOException {
        CLibrary.winsize sz = new CLibrary.winsize(size);
        C_LIBRARY.ioctl(this.getSlave(), new NativeLong(2148037735L), sz);
    }
}

