/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplInterpreter;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ConsoleReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.IdeReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.ReplWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "replConfiguration", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;)V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "replInitializer", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter;", "replInterpreter", "getReplInterpreter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter;", "writer", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "getWriter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "doRun", "", "eval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "line", "", "one", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$WhatNextAfterOneLine;", "next", "oneCommand", "", "command", "Companion", "WhatNextAfterOneLine", "kotlin-scripting-compiler"})
public final class ReplFromTerminal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplConfiguration replConfiguration;
    @NotNull
    private final Future<ReplInterpreter> replInitializer;
    @NotNull
    private final MessageCollector messageCollector;

    public ReplFromTerminal(@NotNull Disposable disposable, @NotNull CompilerConfiguration compilerConfiguration, @NotNull ReplConfiguration replConfiguration) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)replConfiguration, (String)"replConfiguration");
        this.replConfiguration = replConfiguration;
        Object object = Executors.newSingleThreadExecutor().submit(() -> ReplFromTerminal.replInitializer$lambda-0(disposable, compilerConfiguration, this));
        Intrinsics.checkNotNullExpressionValue(object, (String)"newSingleThreadExecutor(\u2026replConfiguration)\n    })");
        this.replInitializer = object;
        object = compilerConfiguration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compilerConfiguration.ge\u2026ys.MESSAGE_COLLECTOR_KEY)");
        this.messageCollector = (MessageCollector)object;
    }

    private final ReplInterpreter getReplInterpreter() {
        ReplInterpreter replInterpreter = this.replInitializer.get();
        Intrinsics.checkNotNullExpressionValue((Object)replInterpreter, (String)"replInitializer.get()");
        return replInterpreter;
    }

    private final ReplWriter getWriter() {
        return this.replConfiguration.getWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRun() {
        try {
            GroupingMessageCollector groupingMessageCollector;
            ReplWriter replWriter = this.getWriter();
            boolean bl = false;
            boolean bl2 = false;
            ReplWriter $this$doRun_u24lambda_u2d1 = replWriter;
            boolean bl3 = false;
            $this$doRun_u24lambda_u2d1.printlnWelcomeMessage("Welcome to Kotlin version " + KotlinCompilerVersion.VERSION + " (JRE " + System.getProperty("java.runtime.version") + ')');
            $this$doRun_u24lambda_u2d1.printlnWelcomeMessage("Type :help for help, :quit for quit");
            boolean hasErrors = this.messageCollector.hasErrors();
            MessageCollector messageCollector2 = this.messageCollector;
            GroupingMessageCollector groupingMessageCollector2 = groupingMessageCollector = messageCollector2 instanceof GroupingMessageCollector ? (GroupingMessageCollector)messageCollector2 : null;
            if (groupingMessageCollector != null) {
                groupingMessageCollector.flush();
            }
            if (hasErrors) {
                return;
            }
            WhatNextAfterOneLine next = WhatNextAfterOneLine.READ_LINE;
            while ((next = this.one(next)) != WhatNextAfterOneLine.QUIT) {
            }
        }
        catch (Exception e) {
            this.replConfiguration.getExceptionReporter().report(e);
            throw e;
        }
        finally {
            try {
                this.replConfiguration.getCommandReader().flushHistory();
            }
            catch (Exception e) {
                this.replConfiguration.getExceptionReporter().report(e);
                throw e;
            }
        }
    }

    private final WhatNextAfterOneLine one(WhatNextAfterOneLine next) {
        String string = this.replConfiguration.getCommandReader().readLine(next);
        if (string == null) {
            return WhatNextAfterOneLine.QUIT;
        }
        String line = string;
        if (StringsKt.startsWith$default((String)(line = ReplUtilKt.replUnescapeLineBreaks((String)line)), (String)":", (boolean)false, (int)2, null) && (line.length() == 1 || line.charAt(1) != ':')) {
            String string2 = line;
            int n = 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            boolean notQuit = this.oneCommand(string4);
            return notQuit ? WhatNextAfterOneLine.READ_LINE : WhatNextAfterOneLine.QUIT;
        }
        ReplEvalResult lineResult = this.eval(line);
        return lineResult instanceof ReplEvalResult.Incomplete ? WhatNextAfterOneLine.INCOMPLETE : WhatNextAfterOneLine.READ_LINE;
    }

    private final ReplEvalResult eval(String line) {
        ReplEvalResult evalResult = this.getReplInterpreter().eval(line);
        ReplEvalResult replEvalResult = evalResult;
        if (replEvalResult instanceof ReplEvalResult.ValueResult ? true : replEvalResult instanceof ReplEvalResult.UnitResult) {
            this.getWriter().notifyCommandSuccess();
            if (evalResult instanceof ReplEvalResult.ValueResult) {
                this.getWriter().outputCommandResult(evalResult.toString());
            }
        } else if (replEvalResult instanceof ReplEvalResult.Error.Runtime) {
            this.getWriter().outputRuntimeError(((ReplEvalResult.Error.Runtime)evalResult).getMessage());
        } else if (replEvalResult instanceof ReplEvalResult.Error.CompileTime) {
            this.getWriter().outputRuntimeError(((ReplEvalResult.Error.CompileTime)evalResult).getMessage());
        } else if (replEvalResult instanceof ReplEvalResult.Incomplete) {
            this.getWriter().notifyIncomplete();
        } else if (replEvalResult instanceof ReplEvalResult.HistoryMismatch) {
            // empty if block
        }
        return evalResult;
    }

    private final boolean oneCommand(String command) throws Exception {
        List split = ReplFromTerminal.Companion.splitCommand(command);
        Collection collection = split;
        boolean bl = false;
        if (!collection.isEmpty() && Intrinsics.areEqual((Object)command, (Object)"help")) {
            this.getWriter().printlnHelpMessage("Available commands:\n:help                   show this help\n:quit                   exit the interpreter\n:dump bytecode          dump classes to terminal\n:load <file>            load script from specified file");
            return true;
        }
        if (split.size() >= 2 && Intrinsics.areEqual(split.get(0), (Object)"dump") && Intrinsics.areEqual(split.get(1), (Object)"bytecode")) {
            this.getReplInterpreter().dumpClasses(new PrintWriter(System.out));
            return true;
        }
        collection = split;
        bl = false;
        if (!collection.isEmpty() && Intrinsics.areEqual(split.get(0), (Object)"quit")) {
            return false;
        }
        if (split.size() >= 2 && Intrinsics.areEqual(split.get(0), (Object)"load")) {
            String fileName = (String)split.get(1);
            try {
                String string = FileUtil.loadFile((File)new File(fileName));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(File(fileName))");
                String scriptText = string;
                this.eval(scriptText);
            }
            catch (IOException e) {
                this.getWriter().outputCompileError(Intrinsics.stringPlus((String)"Can not load script: ", (Object)e.getMessage()));
            }
            return true;
        }
        this.getWriter().printlnHelpMessage("Unknown command\nType :help for help");
        return true;
    }

    private static final ReplInterpreter replInitializer$lambda-0(Disposable $disposable, CompilerConfiguration $compilerConfiguration, ReplFromTerminal this$0) {
        Intrinsics.checkNotNullParameter((Object)$disposable, (String)"$disposable");
        Intrinsics.checkNotNullParameter((Object)$compilerConfiguration, (String)"$compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new ReplInterpreter($disposable, $compilerConfiguration, this$0.replConfiguration);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$WhatNextAfterOneLine;", "", "(Ljava/lang/String;I)V", "READ_LINE", "INCOMPLETE", "QUIT", "kotlin-scripting-compiler"})
    public static final class WhatNextAfterOneLine
    extends Enum<WhatNextAfterOneLine> {
        public static final /* enum */ WhatNextAfterOneLine READ_LINE = new WhatNextAfterOneLine();
        public static final /* enum */ WhatNextAfterOneLine INCOMPLETE = new WhatNextAfterOneLine();
        public static final /* enum */ WhatNextAfterOneLine QUIT = new WhatNextAfterOneLine();
        private static final /* synthetic */ WhatNextAfterOneLine[] $VALUES;

        public static WhatNextAfterOneLine[] values() {
            return (WhatNextAfterOneLine[])$VALUES.clone();
        }

        public static WhatNextAfterOneLine valueOf(String value) {
            return Enum.valueOf(WhatNextAfterOneLine.class, value);
        }

        static {
            $VALUES = whatNextAfterOneLineArray = new WhatNextAfterOneLine[]{WhatNextAfterOneLine.READ_LINE, WhatNextAfterOneLine.INCOMPLETE, WhatNextAfterOneLine.QUIT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$Companion;", "", "()V", "run", "", "disposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "splitCommand", "", "", "command", "kotlin-scripting-compiler"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> splitCommand(String command) {
            List list;
            CharSequence charSequence = command;
            String string = " ";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p0 = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = p0;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            return CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
        }

        public final void run(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            boolean replIdeMode = Intrinsics.areEqual((Object)System.getProperty("kotlin.repl.ideMode"), (Object)"true");
            ReplConfiguration replConfiguration = replIdeMode ? (ReplConfiguration)new IdeReplConfiguration() : (ReplConfiguration)new ConsoleReplConfiguration();
            try {
                new ReplFromTerminal(disposable, configuration, replConfiguration).doRun();
            }
            catch (Exception e) {
                replConfiguration.getExceptionReporter().report(e);
                throw e;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

