
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was MauiKitConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/MauiKit" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(Qt5Core 5.14.0)

# Any changes in this ".cmake" file will be overwritten by CMake, the source is the ".cmake.in" file.

foreach(PKG IN LISTS MauiKit_FIND_COMPONENTS)
    find_package(MauiKit${PKG})
    if(MauiKit_FIND_REQUIRED_${PKG})
        set_package_properties(MauiKit${PKG} PROPERTIES TYPE REQUIRED)
    else()
        set_package_properties(MauiKit${PKG} PROPERTIES TYPE OPTIONAL)
    endif()

    set(MauiKit_${PKG}_FOUND ${MauiKit${PKG}_FOUND})
endforeach()

include("${CMAKE_CURRENT_LIST_DIR}/MauiKitTargets.cmake")

set(MauiKit_INSTALL_PREFIX "${PACKAGE_PREFIX_DIR}")

#set(Kirigami2_LIBRARIES KF5::Kirigami2)

if(ANDROID)
    set(MAUIKIT_ANDROID_DIR "/usr/share/MauiKitAndroid")
endif()


