# This file has been autogenerated by the pywayland scanner

# Copyright © 2015 Samsung Electronics Co., Ltd
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlSurface
from .zwp_idle_inhibitor_v1 import ZwpIdleInhibitorV1


class ZwpIdleInhibitManagerV1(Interface):
    """Control behavior when display idles

    This interface permits inhibiting the idle behavior such as screen
    blanking, locking, and screensaving.  The client binds the idle manager
    globally, then creates idle-inhibitor objects for each surface.

    Warning! The protocol described in this file is experimental and backward
    incompatible changes may be made. Backward compatible changes may be added
    together with the corresponding interface version bump. Backward
    incompatible changes are done by bumping the version number in the protocol
    and interface names and resetting the interface version. Once the protocol
    is to be declared stable, the 'z' prefix and the version number in the
    protocol and interface names are removed and the interface version number
    is reset.
    """

    name = "zwp_idle_inhibit_manager_v1"
    version = 1


class ZwpIdleInhibitManagerV1Proxy(Proxy):
    interface = ZwpIdleInhibitManagerV1

    @ZwpIdleInhibitManagerV1.request()
    def destroy(self):
        """Destroy the idle inhibitor object

        Destroy the inhibit manager.
        """
        self._marshal(0)
        self._destroy()

    @ZwpIdleInhibitManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpIdleInhibitorV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def create_inhibitor(self, surface):
        """Create a new inhibitor object

        Create a new inhibitor object associated with the given surface.

        :param surface:
            the surface that inhibits the idle behavior
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.idle_inhibit_unstable_v1.ZwpIdleInhibitorV1`
        """
        id = self._marshal_constructor(1, ZwpIdleInhibitorV1, surface)
        return id


class ZwpIdleInhibitManagerV1Resource(Resource):
    interface = ZwpIdleInhibitManagerV1


class ZwpIdleInhibitManagerV1Global(Global):
    interface = ZwpIdleInhibitManagerV1


ZwpIdleInhibitManagerV1._gen_c()
ZwpIdleInhibitManagerV1.proxy_class = ZwpIdleInhibitManagerV1Proxy
ZwpIdleInhibitManagerV1.resource_class = ZwpIdleInhibitManagerV1Resource
ZwpIdleInhibitManagerV1.global_class = ZwpIdleInhibitManagerV1Global
