# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

import enum

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlSeat


class ZxdgPopupV6(Interface):
    """Short-lived, popup surfaces for menus

    A popup surface is a short-lived, temporary surface. It can be used to
    implement for example menus, popovers, tooltips and other similar user
    interface concepts.

    A popup can be made to take an explicit grab. See :func:`XdgPopup.grab()
    <pywayland.protocol.xdg_shell.XdgPopup.grab>` for details.

    When the popup is dismissed, a popup_done event will be sent out, and at
    the same time the surface will be unmapped. See the
    :func:`XdgPopup.popup_done()
    <pywayland.protocol.xdg_shell.XdgPopup.popup_done>` event for details.

    Explicitly destroying the :class:`~pywayland.protocol.xdg_shell.XdgPopup`
    object will also dismiss the popup and unmap the surface. Clients that want
    to dismiss the popup when another surface of their own is clicked should
    dismiss the popup using the destroy request.

    The parent surface must have either the
    :class:`~pywayland.protocol.xdg_shell.XdgToplevel` or
    :class:`~pywayland.protocol.xdg_shell.XdgPopup` surface role.

    A newly created :class:`~pywayland.protocol.xdg_shell.XdgPopup` will be
    stacked on top of all previously created
    :class:`~pywayland.protocol.xdg_shell.XdgPopup` surfaces associated with
    the same :class:`~pywayland.protocol.xdg_shell.XdgToplevel`.

    The parent of an :class:`~pywayland.protocol.xdg_shell.XdgPopup` must be
    mapped (see the :class:`~pywayland.protocol.xdg_shell.XdgSurface`
    description) before the :class:`~pywayland.protocol.xdg_shell.XdgPopup`
    itself.

    The x and y arguments passed when creating the popup object specify where
    the top left of the popup should be placed, relative to the local surface
    coordinates of the parent surface. See :func:`XdgSurface.get_popup()
    <pywayland.protocol.xdg_shell.XdgSurface.get_popup>`. An
    :class:`~pywayland.protocol.xdg_shell.XdgPopup` must intersect with or be
    at least partially adjacent to its parent surface.

    The client must call :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` on the corresponding
    :class:`~pywayland.protocol.wayland.WlSurface` for the
    :class:`~pywayland.protocol.xdg_shell.XdgPopup` state to take effect.
    """

    name = "zxdg_popup_v6"
    version = 1

    class error(enum.IntEnum):
        invalid_grab = 0


class ZxdgPopupV6Proxy(Proxy):
    interface = ZxdgPopupV6

    @ZxdgPopupV6.request()
    def destroy(self):
        """Remove :class:`~pywayland.protocol.xdg_shell.XdgPopup` interface

        This destroys the popup. Explicitly destroying the
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` object will also
        dismiss the popup, and unmap the surface.

        If this :class:`~pywayland.protocol.xdg_shell.XdgPopup` is not the
        "topmost" popup, a protocol error will be sent.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgPopupV6.request(
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
    )
    def grab(self, seat, serial):
        """Make the popup take an explicit grab

        This request makes the created popup take an explicit grab. An explicit
        grab will be dismissed when the user dismisses the popup, or when the
        client destroys the :class:`~pywayland.protocol.xdg_shell.XdgPopup`.
        This can be done by the user clicking outside the surface, using the
        keyboard, or even locking the screen through closing the lid or a
        timeout.

        If the compositor denies the grab, the popup will be immediately
        dismissed.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event. The serial number of
        the event should be passed as 'serial'.

        The parent of a grabbing popup must either be an
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel` surface or another
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` with an explicit grab.
        If the parent is another
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` it means that the
        popups are nested, with this popup now being the topmost popup.

        Nested popups must be destroyed in the reverse order they were created
        in, e.g. the only popup you are allowed to destroy at all times is the
        topmost one.

        When compositors choose to dismiss a popup, they may dismiss every
        nested grabbing popup as well. When a compositor dismisses popups, it
        will follow the same dismissing order as required from the client.

        The parent of a grabbing popup must either be another
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` with an active explicit
        grab, or an :class:`~pywayland.protocol.xdg_shell.XdgPopup` or
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel`, if there are no
        explicit grabs already taken.

        If the topmost grabbing popup is destroyed, the grab will be returned
        to the parent of the popup, if that parent previously had an explicit
        grab.

        If the parent is a grabbing popup which has already been dismissed,
        this popup will be immediately dismissed. If the parent is a popup that
        did not take an explicit grab, an error will be raised.

        During a popup grab, the client owning the grab will receive pointer
        and touch events for all their surfaces as normal (similar to an
        "owner-events" grab in X11 parlance), while the top most grabbing popup
        will always have keyboard focus.

        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(1, seat, serial)


class ZxdgPopupV6Resource(Resource):
    interface = ZxdgPopupV6

    @ZxdgPopupV6.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def configure(self, x, y, width, height):
        """Configure the popup surface

        This event asks the popup surface to configure itself given the
        configuration. The configured state should not be applied immediately.
        See :func:`XdgSurface.configure()
        <pywayland.protocol.xdg_shell.XdgSurface.configure>` for details.

        The x and y arguments represent the position the popup was placed at
        given the :class:`~pywayland.protocol.xdg_shell.XdgPositioner` rule,
        relative to the upper left corner of the window geometry of the parent
        surface.

        :param x:
            x position relative to parent surface window geometry
        :type x:
            `ArgumentType.Int`
        :param y:
            y position relative to parent surface window geometry
        :type y:
            `ArgumentType.Int`
        :param width:
            window geometry width
        :type width:
            `ArgumentType.Int`
        :param height:
            window geometry height
        :type height:
            `ArgumentType.Int`
        """
        self._post_event(0, x, y, width, height)

    @ZxdgPopupV6.event()
    def popup_done(self):
        """Popup interaction is done

        The popup_done event is sent out when a popup is dismissed by the
        compositor. The client should destroy the
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` object at this point.
        """
        self._post_event(1)


class ZxdgPopupV6Global(Global):
    interface = ZxdgPopupV6


ZxdgPopupV6._gen_c()
ZxdgPopupV6.proxy_class = ZxdgPopupV6Proxy
ZxdgPopupV6.resource_class = ZxdgPopupV6Resource
ZxdgPopupV6.global_class = ZxdgPopupV6Global
