/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    private static Logger log = Logger.getLogger(EncryptedKeyResolver.class.getName());
    private Key kek;
    private String algorithm;
    private List<KeyResolverSpi> internalKeyResolvers;

    public EncryptedKeyResolver(String algorithm) {
        this.kek = null;
        this.algorithm = algorithm;
    }

    public EncryptedKeyResolver(String algorithm, Key kek) {
        this.algorithm = algorithm;
        this.kek = kek;
    }

    public void registerInternalKeyResolver(KeyResolverSpi realKeyResolver) {
        if (this.internalKeyResolvers == null) {
            this.internalKeyResolvers = new ArrayList<KeyResolverSpi>();
        }
        this.internalKeyResolvers.add(realKeyResolver);
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        SecretKey key;
        block8: {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "EncryptedKeyResolver - Can I resolve " + element.getTagName());
            }
            if (element == null) {
                return null;
            }
            key = null;
            boolean isEncryptedKey = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
            if (isEncryptedKey) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Passed an Encrypted Key");
                }
                try {
                    XMLCipher cipher = XMLCipher.getInstance();
                    cipher.init(4, this.kek);
                    if (this.internalKeyResolvers != null) {
                        int size = this.internalKeyResolvers.size();
                        for (int i = 0; i < size; ++i) {
                            cipher.registerInternalKeyResolver(this.internalKeyResolvers.get(i));
                        }
                    }
                    EncryptedKey ek = cipher.loadEncryptedKey(element);
                    key = (SecretKey)cipher.decryptKey(ek, this.algorithm);
                }
                catch (XMLEncryptionException e) {
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        return key;
    }
}

