/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.CksumType;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Checksum {
    private int cksumType;
    private byte[] checksum;
    public static final int CKSUMTYPE_NULL = 0;
    public static final int CKSUMTYPE_CRC32 = 1;
    public static final int CKSUMTYPE_RSA_MD4 = 2;
    public static final int CKSUMTYPE_RSA_MD4_DES = 3;
    public static final int CKSUMTYPE_DES_MAC = 4;
    public static final int CKSUMTYPE_DES_MAC_K = 5;
    public static final int CKSUMTYPE_RSA_MD4_DES_K = 6;
    public static final int CKSUMTYPE_RSA_MD5 = 7;
    public static final int CKSUMTYPE_RSA_MD5_DES = 8;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3_KD = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES128 = 15;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES256 = 16;
    public static final int CKSUMTYPE_HMAC_MD5_ARCFOUR = -138;
    static int CKSUMTYPE_DEFAULT;
    static int SAFECKSUMTYPE_DEFAULT;
    private static boolean DEBUG;

    public static void initStatic() {
        String temp = null;
        Config cfg = null;
        try {
            cfg = Config.getInstance();
            temp = cfg.get("libdefaults", "default_checksum");
            CKSUMTYPE_DEFAULT = temp != null ? Config.getType(temp) : -1;
        }
        catch (Exception exc) {
            if (DEBUG) {
                System.out.println("Exception in getting default checksum value from the configuration. No default checksum set.");
                exc.printStackTrace();
            }
            CKSUMTYPE_DEFAULT = -1;
        }
        try {
            temp = cfg.get("libdefaults", "safe_checksum_type");
            SAFECKSUMTYPE_DEFAULT = temp != null ? Config.getType(temp) : -1;
        }
        catch (Exception exc) {
            if (DEBUG) {
                System.out.println("Exception in getting safe default checksum value from the configuration Setting.  No safe default checksum set.");
                exc.printStackTrace();
            }
            SAFECKSUMTYPE_DEFAULT = -1;
        }
    }

    public Checksum(byte[] data, int new_cksumType) {
        this.cksumType = new_cksumType;
        this.checksum = data;
    }

    public Checksum(int new_cksumType, byte[] data, EncryptionKey key, int usage) throws KdcErrException, KrbApErrException, KrbCryptoException {
        this.cksumType = new_cksumType == -1 ? EType.getInstance(key.getEType()).checksumType() : new_cksumType;
        this.checksum = CksumType.getInstance(this.cksumType).calculateChecksum(data, data.length, key.getBytes(), usage);
    }

    public boolean verifyKeyedChecksum(byte[] data, EncryptionKey key, int usage) throws KdcErrException, KrbApErrException, KrbCryptoException {
        CksumType cksumEngine = CksumType.getInstance(this.cksumType);
        if (!cksumEngine.isKeyed()) {
            throw new KrbApErrException(50);
        }
        return cksumEngine.verifyChecksum(data, data.length, key.getBytes(), this.checksum, usage);
    }

    boolean isEqual(Checksum cksum) throws KdcErrException {
        if (this.cksumType != cksum.cksumType) {
            return false;
        }
        return CksumType.isChecksumEqual(this.checksum, cksum.checksum);
    }

    private Checksum(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.cksumType = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.checksum = der.getData().getOctetString();
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.cksumType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putOctetString(this.checksum);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public static Checksum parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new Checksum(subDer);
    }

    public final byte[] getBytes() {
        return this.checksum;
    }

    public final int getType() {
        return this.cksumType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Checksum)) {
            return false;
        }
        try {
            return this.isEqual((Checksum)obj);
        }
        catch (KdcErrException kee) {
            return false;
        }
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.cksumType;
        if (this.checksum != null) {
            result = 37 * result + Arrays.hashCode(this.checksum);
        }
        return result;
    }

    static {
        DEBUG = Krb5.DEBUG;
        Checksum.initStatic();
    }
}

