/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.GroupTitle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeGroupTitle
extends GroupTitle {
    private String csname;

    public DateTimeGroupTitle(DateFormat dateFormat, Date date, String string, boolean bl, boolean bl2) {
        super(null, dateFormat.format(date), date.getTime(), string);
        SimpleDateFormat simpleDateFormat;
        if (bl && bl2) {
            simpleDateFormat = new SimpleDateFormat("{yyyy}{MM}{dd}{HH}{mm}{ss}{Z}");
            this.csname = "datetimegroup";
        } else if (bl) {
            simpleDateFormat = new SimpleDateFormat("{yyyy}{MM}{dd}{G}");
            this.csname = "dategroup";
        } else {
            simpleDateFormat = new SimpleDateFormat("{HH}{mm}{ss}{Z}");
            this.csname = "timegroup";
        }
        this.setTitle(simpleDateFormat.format(date));
    }

    @Override
    public String getCsSetName() {
        return "bibglsset" + this.csname + "title";
    }

    @Override
    public String getCsLabelName() {
        return "bibgls" + this.csname;
    }

    @Override
    public String format(String string) {
        return String.format("%s{%s}{%d}{%s}", this.getTitle(), this.getActual(), this.getId(), this.type == null ? "" : this.getType());
    }
}

