/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.apache.coyote.http11.upgrade.servlet31.ReadListener;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractServletInputStream
extends ServletInputStream {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11.upgrade");
    private volatile boolean closeRequired = false;
    private volatile Boolean ready = Boolean.TRUE;
    private volatile ReadListener listener = null;
    private volatile ClassLoader applicationLoader = null;

    public final boolean isFinished() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isFinished.ise"));
        }
        return false;
    }

    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isReady.ise"));
        }
        if (this.ready != null) {
            return this.ready;
        }
        try {
            this.ready = this.doIsReady();
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
        return this.ready;
    }

    public final void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.null"));
        }
        if (this.listener != null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.set"));
        }
        this.listener = readListener;
        this.applicationLoader = Thread.currentThread().getContextClassLoader();
        this.ready = null;
    }

    public final int read() throws IOException {
        this.preReadChecks();
        return this.readInternal();
    }

    public final int readLine(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.preReadChecks();
        if (n2 <= 0) {
            return 0;
        }
        int n4 = 0;
        while ((n3 = this.readInternal()) != -1) {
            byArray[n++] = (byte)n3;
            if (n3 != 10 && ++n4 != n2) continue;
        }
        return n4 > 0 ? n4 : -1;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        this.preReadChecks();
        try {
            return this.doRead(this.listener == null, byArray, n, n2);
        }
        catch (IOException iOException) {
            this.closeRequired = true;
            throw iOException;
        }
    }

    public void close() throws IOException {
        this.closeRequired = true;
        this.doClose();
    }

    private void preReadChecks() {
        if (!(this.listener == null || this.ready != null && this.ready.booleanValue())) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.ise"));
        }
        this.ready = null;
    }

    private int readInternal() throws IOException {
        int n;
        byte[] byArray = new byte[1];
        try {
            n = this.doRead(this.listener == null, byArray, 0, 1);
        }
        catch (IOException iOException) {
            this.closeRequired = true;
            throw iOException;
        }
        if (n == 0) {
            return -1;
        }
        if (n == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    protected final void onAllDataRead() throws IOException {
        if (this.listener == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.applicationLoader);
            this.listener.onAllDataRead();
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    protected final void onDataAvailable() throws IOException {
        if (this.listener == null) {
            return;
        }
        this.ready = Boolean.TRUE;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.applicationLoader);
            this.listener.onDataAvailable();
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onError(Throwable throwable) {
        if (this.listener == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.applicationLoader);
            this.listener.onError(throwable);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
        this.ready = Boolean.FALSE;
    }

    protected final boolean isCloseRequired() {
        return this.closeRequired;
    }

    protected abstract boolean doIsReady() throws IOException;

    protected abstract int doRead(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void doClose() throws IOException;
}

