/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.TestIdentifier;

@API(status=API.Status.STABLE, since="1.0")
public class TestPlan {
    private final Set<TestIdentifier> roots = Collections.synchronizedSet(new LinkedHashSet(4));
    private final Map<String, Set<TestIdentifier>> children = new ConcurrentHashMap<String, Set<TestIdentifier>>(32);
    private final Map<String, TestIdentifier> allIdentifiers = new ConcurrentHashMap<String, TestIdentifier>(32);
    private final boolean containsTests;

    @API(status=API.Status.INTERNAL, since="1.0")
    public static TestPlan from(Collection<TestDescriptor> engineDescriptors) {
        Preconditions.notNull(engineDescriptors, (String)"Cannot create TestPlan from a null collection of TestDescriptors");
        TestPlan testPlan = new TestPlan(engineDescriptors.stream().anyMatch(TestDescriptor::containsTests));
        TestDescriptor.Visitor visitor = descriptor -> testPlan.add(TestIdentifier.from(descriptor));
        engineDescriptors.forEach(engineDescriptor -> engineDescriptor.accept(visitor));
        return testPlan;
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    protected TestPlan(boolean containsTests) {
        this.containsTests = containsTests;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4")
    public void add(TestIdentifier testIdentifier) {
        Preconditions.notNull((Object)testIdentifier, (String)"testIdentifier must not be null");
        this.allIdentifiers.put(testIdentifier.getUniqueId(), testIdentifier);
        if (testIdentifier.getParentId().isPresent()) {
            String parentId = testIdentifier.getParentId().get();
            Set directChildren = this.children.computeIfAbsent(parentId, key -> Collections.synchronizedSet(new LinkedHashSet(16)));
            directChildren.add(testIdentifier);
        } else {
            this.roots.add(testIdentifier);
        }
    }

    public Set<TestIdentifier> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    public Optional<TestIdentifier> getParent(TestIdentifier child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        return child.getParentId().map(this::getTestIdentifier);
    }

    public Set<TestIdentifier> getChildren(TestIdentifier parent) {
        Preconditions.notNull((Object)parent, (String)"parent must not be null");
        return this.getChildren(parent.getUniqueId());
    }

    public Set<TestIdentifier> getChildren(String parentId) {
        Preconditions.notBlank((String)parentId, (String)"parent ID must not be null or blank");
        return this.children.containsKey(parentId) ? Collections.unmodifiableSet(this.children.get(parentId)) : Collections.emptySet();
    }

    public TestIdentifier getTestIdentifier(String uniqueId) throws PreconditionViolationException {
        Preconditions.notBlank((String)uniqueId, (String)"unique ID must not be null or blank");
        Preconditions.condition((boolean)this.allIdentifiers.containsKey(uniqueId), () -> "No TestIdentifier with unique ID [" + uniqueId + "] has been added to this TestPlan.");
        return this.allIdentifiers.get(uniqueId);
    }

    public long countTestIdentifiers(Predicate<? super TestIdentifier> predicate) {
        Preconditions.notNull(predicate, (String)"Predicate must not be null");
        return this.allIdentifiers.values().stream().filter(predicate).count();
    }

    public Set<TestIdentifier> getDescendants(TestIdentifier parent) {
        Preconditions.notNull((Object)parent, (String)"parent must not be null");
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>(16);
        Set<TestIdentifier> children = this.getChildren(parent);
        result.addAll(children);
        for (TestIdentifier child : children) {
            result.addAll(this.getDescendants(child));
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean containsTests() {
        return this.containsTests;
    }
}

