/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.ByteArrayOutputStream;
import sun.font.GlyphList;
import sun.font.StrikeCache;

public class XRGlyphCacheEntry {
    long glyphInfoPtr;
    int lastUsed;
    boolean pinned;
    int xOff;
    int yOff;
    int glyphSet;

    public XRGlyphCacheEntry(long glyphInfoPtr, GlyphList gl) {
        this.glyphInfoPtr = glyphInfoPtr;
        this.xOff = Math.round(this.getXAdvance());
        this.yOff = Math.round(this.getYAdvance());
    }

    public int getXOff() {
        return this.xOff;
    }

    public int getYOff() {
        return this.yOff;
    }

    public void setGlyphSet(int glyphSet) {
        this.glyphSet = glyphSet;
    }

    public int getGlyphSet() {
        return this.glyphSet;
    }

    public static int getGlyphID(long glyphInfoPtr) {
        return (int)StrikeCache.unsafe.getAddress(glyphInfoPtr + (long)StrikeCache.cacheCellOffset);
    }

    public static void setGlyphID(long glyphInfoPtr, int id) {
        StrikeCache.unsafe.putAddress(glyphInfoPtr + (long)StrikeCache.cacheCellOffset, id);
    }

    public int getGlyphID() {
        return XRGlyphCacheEntry.getGlyphID(this.glyphInfoPtr);
    }

    public void setGlyphID(int id) {
        XRGlyphCacheEntry.setGlyphID(this.glyphInfoPtr, id);
    }

    public float getXAdvance() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.xAdvanceOffset);
    }

    public float getYAdvance() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.yAdvanceOffset);
    }

    public int getSourceRowBytes() {
        return StrikeCache.unsafe.getShort(this.glyphInfoPtr + (long)StrikeCache.rowBytesOffset);
    }

    public int getWidth() {
        return StrikeCache.unsafe.getShort(this.glyphInfoPtr + (long)StrikeCache.widthOffset);
    }

    public int getHeight() {
        return StrikeCache.unsafe.getShort(this.glyphInfoPtr + (long)StrikeCache.heightOffset);
    }

    public void writePixelData(ByteArrayOutputStream os, boolean uploadAsLCD) {
        long pixelDataAddress = StrikeCache.unsafe.getAddress(this.glyphInfoPtr + (long)StrikeCache.pixelDataOffset);
        if (pixelDataAddress == 0L) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int rowBytes = this.getSourceRowBytes();
        int paddedWidth = this.getPaddedWidth(uploadAsLCD);
        if (!uploadAsLCD) {
            for (int line = 0; line < height; ++line) {
                for (int x = 0; x < paddedWidth; ++x) {
                    if (x < width) {
                        os.write(StrikeCache.unsafe.getByte(pixelDataAddress + (long)(line * rowBytes + x)));
                        continue;
                    }
                    os.write(0);
                }
            }
        } else {
            for (int line = 0; line < height; ++line) {
                int rowStart = line * rowBytes;
                int rowBytesWidth = width * 3;
                for (int srcpix = 0; srcpix < rowBytesWidth; srcpix += 3) {
                    os.write(StrikeCache.unsafe.getByte(pixelDataAddress + (long)(rowStart + srcpix + 2)));
                    os.write(StrikeCache.unsafe.getByte(pixelDataAddress + (long)(rowStart + srcpix + 1)));
                    os.write(StrikeCache.unsafe.getByte(pixelDataAddress + (long)(rowStart + srcpix + 0)));
                    os.write(255);
                }
            }
        }
    }

    public float getTopLeftXOffset() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.topLeftXOffset);
    }

    public float getTopLeftYOffset() {
        return StrikeCache.unsafe.getFloat(this.glyphInfoPtr + (long)StrikeCache.topLeftYOffset);
    }

    public long getGlyphInfoPtr() {
        return this.glyphInfoPtr;
    }

    public boolean isGrayscale(boolean listContainsLCDGlyphs) {
        return this.getSourceRowBytes() == this.getWidth() && (this.getWidth() != 0 || this.getHeight() != 0 || !listContainsLCDGlyphs);
    }

    public int getPaddedWidth(boolean listContainsLCDGlyphs) {
        int width = this.getWidth();
        return this.isGrayscale(listContainsLCDGlyphs) ? (int)Math.ceil((double)width / 4.0) * 4 : width;
    }

    public int getDestinationRowBytes(boolean listContainsLCDGlyphs) {
        boolean grayscale = this.isGrayscale(listContainsLCDGlyphs);
        return grayscale ? this.getPaddedWidth(grayscale) : this.getWidth() * 4;
    }

    public int getGlyphDataLenth(boolean listContainsLCDGlyphs) {
        return this.getDestinationRowBytes(listContainsLCDGlyphs) * this.getHeight();
    }

    public void setPinned() {
        this.pinned = true;
    }

    public void setUnpinned() {
        this.pinned = false;
    }

    public int getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(int lastUsed) {
        this.lastUsed = lastUsed;
    }

    public int getPixelCnt() {
        return this.getWidth() * this.getHeight();
    }

    public boolean isPinned() {
        return this.pinned;
    }
}

