/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLSessionImpl;
import sun.security.util.AnchorCertificates;
import sun.security.util.HostnameChecker;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final String validatorType;
    private final Collection<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile Validator clientValidator;
    private volatile Validator serverValidator;

    X509TrustManagerImpl(String string, Collection<X509Certificate> collection) {
        this.validatorType = string;
        this.pkixParams = null;
        if (collection == null) {
            collection = Collections.emptySet();
        }
        this.trustedCerts = collection;
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,trustmanager")) {
            SSLLogger.fine("adding as trusted certificates", collection.toArray(new X509Certificate[0]));
        }
    }

    X509TrustManagerImpl(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        this.validatorType = string;
        this.pkixParams = pKIXBuilderParameters;
        Validator validator = this.getValidator("tls server");
        this.trustedCerts = validator.getTrustedCertificates();
        this.serverValidator = validator;
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,trustmanager")) {
            SSLLogger.fine("adding as trusted certificates", this.trustedCerts.toArray(new X509Certificate[0]));
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, false);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCerts.size()];
        this.trustedCerts.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Validator checkTrustedInit(X509Certificate[] x509CertificateArray, String string, boolean bl) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Validator validator = null;
        if (bl) {
            validator = this.clientValidator;
            if (validator == null) {
                X509TrustManagerImpl x509TrustManagerImpl = this;
                synchronized (x509TrustManagerImpl) {
                    validator = this.clientValidator;
                    if (validator == null) {
                        this.clientValidator = validator = this.getValidator("tls client");
                    }
                }
            }
        } else {
            validator = this.serverValidator;
            if (validator == null) {
                X509TrustManagerImpl x509TrustManagerImpl = this;
                synchronized (x509TrustManagerImpl) {
                    validator = this.serverValidator;
                    if (validator == null) {
                        this.serverValidator = validator = this.getValidator("tls server");
                    }
                }
            }
        }
        return validator;
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        X509Certificate[] x509CertificateArray2 = null;
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLAlgorithmConstraints sSLAlgorithmConstraints;
            Object object;
            List<byte[]> list;
            SSLSocket sSLSocket = (SSLSocket)socket;
            SSLSession sSLSession = sSLSocket.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            boolean bl2 = sSLSession instanceof ExtendedSSLSession;
            if (bl2 && ProtocolVersion.useTLS12PlusSpec(sSLSession.getProtocol())) {
                list = (ExtendedSSLSession)sSLSession;
                object = ((ExtendedSSLSession)((Object)list)).getLocalSupportedSignatureAlgorithms();
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, (String[])object, false);
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, false);
            }
            list = Collections.emptyList();
            if (!bl && bl2 && sSLSession instanceof SSLSessionImpl) {
                list = ((SSLSessionImpl)sSLSession).getStatusResponses();
            }
            x509CertificateArray2 = X509TrustManagerImpl.validate(validator, x509CertificateArray, list, sSLAlgorithmConstraints, bl ? null : string);
            object = sSLSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (object != null && !((String)object).isEmpty()) {
                X509TrustManagerImpl.checkIdentity(sSLSession, x509CertificateArray2, (String)object, bl);
            }
        } else {
            x509CertificateArray2 = X509TrustManagerImpl.validate(validator, x509CertificateArray, Collections.emptyList(), null, bl ? null : string);
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,trustmanager")) {
            SSLLogger.fine("Found trusted certificate", x509CertificateArray2[x509CertificateArray2.length - 1]);
        }
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        X509Certificate[] x509CertificateArray2 = null;
        if (sSLEngine != null) {
            SSLAlgorithmConstraints sSLAlgorithmConstraints;
            Object object;
            List<byte[]> list;
            SSLSession sSLSession = sSLEngine.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            boolean bl2 = sSLSession instanceof ExtendedSSLSession;
            if (bl2 && ProtocolVersion.useTLS12PlusSpec(sSLSession.getProtocol())) {
                list = (ExtendedSSLSession)sSLSession;
                object = ((ExtendedSSLSession)((Object)list)).getLocalSupportedSignatureAlgorithms();
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, (String[])object, false);
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, false);
            }
            list = Collections.emptyList();
            if (!bl && bl2 && sSLSession instanceof SSLSessionImpl) {
                list = ((SSLSessionImpl)sSLSession).getStatusResponses();
            }
            x509CertificateArray2 = X509TrustManagerImpl.validate(validator, x509CertificateArray, list, sSLAlgorithmConstraints, bl ? null : string);
            object = sSLEngine.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (object != null && !((String)object).isEmpty()) {
                X509TrustManagerImpl.checkIdentity(sSLSession, x509CertificateArray2, (String)object, bl);
            }
        } else {
            x509CertificateArray2 = X509TrustManagerImpl.validate(validator, x509CertificateArray, Collections.emptyList(), null, bl ? null : string);
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl,trustmanager")) {
            SSLLogger.fine("Found trusted certificate", x509CertificateArray2[x509CertificateArray2.length - 1]);
        }
    }

    private Validator getValidator(String string) {
        Validator validator = this.pkixParams == null ? Validator.getInstance(this.validatorType, string, this.trustedCerts) : Validator.getInstance(this.validatorType, string, this.pkixParams);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] validate(Validator validator, X509Certificate[] x509CertificateArray, List<byte[]> list, AlgorithmConstraints algorithmConstraints, String string) throws CertificateException {
        Object object = JsseJce.beginFipsProvider();
        try {
            X509Certificate[] x509CertificateArray2 = validator.validate(x509CertificateArray, null, list, algorithmConstraints, string);
            return x509CertificateArray2;
        }
        finally {
            JsseJce.endFipsProvider(object);
        }
    }

    private static String getHostNameInSNI(List<SNIServerName> list) {
        SNIHostName sNIHostName = null;
        for (SNIServerName sNIServerName : list) {
            if (sNIServerName.getType() != 0) continue;
            if (sNIServerName instanceof SNIHostName) {
                sNIHostName = (SNIHostName)sNIServerName;
                break;
            }
            try {
                sNIHostName = new SNIHostName(sNIServerName.getEncoded());
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,trustmanager")) break;
                SSLLogger.fine("Illegal server name: " + sNIServerName, new Object[0]);
                break;
            }
        }
        if (sNIHostName != null) {
            return sNIHostName.getAsciiName();
        }
        return null;
    }

    static List<SNIServerName> getRequestedServerNames(Socket socket) {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            return X509TrustManagerImpl.getRequestedServerNames(((SSLSocket)socket).getHandshakeSession());
        }
        return Collections.emptyList();
    }

    static List<SNIServerName> getRequestedServerNames(SSLEngine sSLEngine) {
        if (sSLEngine != null) {
            return X509TrustManagerImpl.getRequestedServerNames(sSLEngine.getHandshakeSession());
        }
        return Collections.emptyList();
    }

    private static List<SNIServerName> getRequestedServerNames(SSLSession sSLSession) {
        if (sSLSession != null && sSLSession instanceof ExtendedSSLSession) {
            return ((ExtendedSSLSession)sSLSession).getRequestedServerNames();
        }
        return Collections.emptyList();
    }

    static void checkIdentity(SSLSession sSLSession, X509Certificate[] x509CertificateArray, String string, boolean bl) throws CertificateException {
        String string2;
        boolean bl2;
        boolean bl3;
        block4: {
            List<SNIServerName> list;
            String string3;
            bl3 = AnchorCertificates.contains(x509CertificateArray[x509CertificateArray.length - 1]);
            bl2 = false;
            string2 = sSLSession.getPeerHost();
            if (!bl && (string3 = X509TrustManagerImpl.getHostNameInSNI(list = X509TrustManagerImpl.getRequestedServerNames(sSLSession))) != null) {
                try {
                    X509TrustManagerImpl.checkIdentity(string3, x509CertificateArray[0], string, bl3);
                    bl2 = true;
                }
                catch (CertificateException certificateException) {
                    if (!string3.equalsIgnoreCase(string2)) break block4;
                    throw certificateException;
                }
            }
        }
        if (!bl2) {
            X509TrustManagerImpl.checkIdentity(string2, x509CertificateArray[0], string, bl3);
        }
    }

    static void checkIdentity(String string, X509Certificate x509Certificate, String string2) throws CertificateException {
        X509TrustManagerImpl.checkIdentity(string, x509Certificate, string2, false);
    }

    private static void checkIdentity(String string, X509Certificate x509Certificate, String string2, boolean bl) throws CertificateException {
        if (string2 != null && !string2.isEmpty()) {
            if (string != null && string.startsWith("[") && string.endsWith("]")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string2.equalsIgnoreCase("HTTPS")) {
                HostnameChecker.getInstance((byte)1).match(string, x509Certificate, bl);
            } else if (string2.equalsIgnoreCase("LDAP") || string2.equalsIgnoreCase("LDAPS")) {
                HostnameChecker.getInstance((byte)2).match(string, x509Certificate, bl);
            } else {
                throw new CertificateException("Unknown identification algorithm: " + string2);
            }
        }
    }
}

