
#ifndef KTEXTWIDGETS_EXPORT_H
#define KTEXTWIDGETS_EXPORT_H

#ifdef KTEXTWIDGETS_STATIC_DEFINE
#  define KTEXTWIDGETS_EXPORT
#  define KTEXTWIDGETS_NO_EXPORT
#else
#  ifndef KTEXTWIDGETS_EXPORT
#    ifdef KF5TextWidgets_EXPORTS
        /* We are building this library */
#      define KTEXTWIDGETS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KTEXTWIDGETS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KTEXTWIDGETS_NO_EXPORT
#    define KTEXTWIDGETS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KTEXTWIDGETS_DECL_DEPRECATED
#  define KTEXTWIDGETS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KTEXTWIDGETS_DECL_DEPRECATED_EXPORT
#  define KTEXTWIDGETS_DECL_DEPRECATED_EXPORT KTEXTWIDGETS_EXPORT KTEXTWIDGETS_DECL_DEPRECATED
#endif

#ifndef KTEXTWIDGETS_DECL_DEPRECATED_NO_EXPORT
#  define KTEXTWIDGETS_DECL_DEPRECATED_NO_EXPORT KTEXTWIDGETS_NO_EXPORT KTEXTWIDGETS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KTEXTWIDGETS_NO_DEPRECATED
#    define KTEXTWIDGETS_NO_DEPRECATED
#  endif
#endif

#define KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KTEXTWIDGETS_NO_DEPRECATED) && !defined(KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KTEXTWIDGETS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KTEXTWIDGETS_NO_DEPRECATED_WARNINGS) && !defined(KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KTEXTWIDGETS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KTEXTWIDGETS_NO_DEPRECATED)
#  undef KTEXTWIDGETS_DEPRECATED
#  define KTEXTWIDGETS_DEPRECATED_EXPORT KTEXTWIDGETS_EXPORT
#  define KTEXTWIDGETS_DEPRECATED_NO_EXPORT KTEXTWIDGETS_NO_EXPORT
#elif defined(KTEXTWIDGETS_NO_DEPRECATED_WARNINGS)
#  define KTEXTWIDGETS_DEPRECATED
#  define KTEXTWIDGETS_DEPRECATED_EXPORT KTEXTWIDGETS_EXPORT
#  define KTEXTWIDGETS_DEPRECATED_NO_EXPORT KTEXTWIDGETS_NO_EXPORT
#else
#  define KTEXTWIDGETS_DEPRECATED KTEXTWIDGETS_DECL_DEPRECATED
#  define KTEXTWIDGETS_DEPRECATED_EXPORT KTEXTWIDGETS_DECL_DEPRECATED_EXPORT
#  define KTEXTWIDGETS_DEPRECATED_NO_EXPORT KTEXTWIDGETS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KTEXTWIDGETS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KTEXTWIDGETS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KTEXTWIDGETS_NO_DEPRECATED
#  define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55700
#endif
#ifdef KTEXTWIDGETS_NO_DEPRECATED_WARNINGS
#  define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE
#  ifdef KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE 0x55700
#  endif
#endif

#ifndef KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KTEXTWIDGETS_DEPRECATED
#  define KTEXTWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KTEXTWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_0(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_0(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x54100
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_65(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_65(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x54600
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_70(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_70(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x54700
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_71(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_71(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_81(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_81(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x55300
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_83(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_83(text)
#endif
#define KTEXTWIDGETS_DEPRECATED_VERSION_5(minor, text)      KTEXTWIDGETS_DEPRECATED_VERSION_5_##minor(text)
#define KTEXTWIDGETS_DEPRECATED_VERSION(major, minor, text) KTEXTWIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KTEXTWIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTWIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KTEXTWIDGETS_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTWIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KTEXTWIDGETS_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KTEXTWIDGETS_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KTEXTWIDGETS_EXPORT_H


#define KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KTEXTWIDGETS_NO_DEPRECATED) && !defined(KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KTEXTWIDGETS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KTEXTWIDGETS_NO_DEPRECATED_WARNINGS) && !defined(KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KTEXTWIDGETS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KTEXTWIDGETS_NO_DEPRECATED)
#  undef KTEXTWIDGETS_DEPRECATED
#  define KTEXTWIDGETS_DEPRECATED_EXPORT KTEXTWIDGETS_EXPORT
#  define KTEXTWIDGETS_DEPRECATED_NO_EXPORT KTEXTWIDGETS_NO_EXPORT
#elif defined(KTEXTWIDGETS_NO_DEPRECATED_WARNINGS)
#  define KTEXTWIDGETS_DEPRECATED
#  define KTEXTWIDGETS_DEPRECATED_EXPORT KTEXTWIDGETS_EXPORT
#  define KTEXTWIDGETS_DEPRECATED_NO_EXPORT KTEXTWIDGETS_NO_EXPORT
#else
#  define KTEXTWIDGETS_DEPRECATED KTEXTWIDGETS_DECL_DEPRECATED
#  define KTEXTWIDGETS_DEPRECATED_EXPORT KTEXTWIDGETS_DECL_DEPRECATED_EXPORT
#  define KTEXTWIDGETS_DEPRECATED_NO_EXPORT KTEXTWIDGETS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KTEXTWIDGETS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KTEXTWIDGETS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KTEXTWIDGETS_NO_DEPRECATED
#  define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55700
#endif
#ifdef KTEXTWIDGETS_NO_DEPRECATED_WARNINGS
#  define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE
#  ifdef KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE 0x55700
#  endif
#endif

#ifndef KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KTEXTWIDGETS_DEPRECATED
#  define KTEXTWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KTEXTWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KTEXTWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_0(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_0(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x54100
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_65(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_65(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x54600
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_70(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_70(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x54700
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_71(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_71(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_81(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_81(text)
#endif

#if KTEXTWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x55300
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_83(text) KTEXTWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTWIDGETS_DEPRECATED_VERSION_5_83(text)
#endif
#define KTEXTWIDGETS_DEPRECATED_VERSION_5(minor, text)      KTEXTWIDGETS_DEPRECATED_VERSION_5_##minor(text)
#define KTEXTWIDGETS_DEPRECATED_VERSION(major, minor, text) KTEXTWIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KTEXTWIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTWIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KTEXTWIDGETS_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTWIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTWIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KTEXTWIDGETS_EXPORT_H */
