/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.HexUtils;

public final class MessageBytes
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int type = 0;
    public static final int T_NULL = 0;
    public static final int T_STR = 1;
    public static final int T_BYTES = 2;
    public static final int T_CHARS = 3;
    private int hashCode = 0;
    private boolean hasHashCode = false;
    private final ByteChunk byteC = new ByteChunk();
    private final CharChunk charC = new CharChunk();
    private String strValue;
    private boolean hasStrValue = false;
    private int intValue;
    private boolean hasIntValue = false;
    private long longValue;
    private boolean hasLongValue = false;
    private static MessageBytesFactory factory = new MessageBytesFactory();

    private MessageBytes() {
    }

    public static MessageBytes newInstance() {
        return factory.newInstance();
    }

    @Deprecated
    public MessageBytes getClone() {
        try {
            return (MessageBytes)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isNull() {
        return this.byteC.isNull() && this.charC.isNull() && !this.hasStrValue;
    }

    public void recycle() {
        this.type = 0;
        this.byteC.recycle();
        this.charC.recycle();
        this.strValue = null;
        this.hasStrValue = false;
        this.hasHashCode = false;
        this.hasIntValue = false;
        this.hasLongValue = false;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.byteC.setBytes(byArray, n, n2);
        this.type = 2;
        this.hasStrValue = false;
        this.hasHashCode = false;
        this.hasIntValue = false;
        this.hasLongValue = false;
    }

    public void setChars(char[] cArray, int n, int n2) {
        this.charC.setChars(cArray, n, n2);
        this.type = 3;
        this.hasStrValue = false;
        this.hasHashCode = false;
        this.hasIntValue = false;
        this.hasLongValue = false;
    }

    public void setString(String string) {
        this.strValue = string;
        this.hasHashCode = false;
        this.hasIntValue = false;
        this.hasLongValue = false;
        if (string == null) {
            this.hasStrValue = false;
            this.type = 0;
        } else {
            this.hasStrValue = true;
            this.type = 1;
        }
    }

    public String toString() {
        if (this.hasStrValue) {
            return this.strValue;
        }
        switch (this.type) {
            case 3: {
                this.strValue = this.charC.toString();
                this.hasStrValue = true;
                return this.strValue;
            }
            case 2: {
                this.strValue = this.byteC.toString();
                this.hasStrValue = true;
                return this.strValue;
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public ByteChunk getByteChunk() {
        return this.byteC;
    }

    public CharChunk getCharChunk() {
        return this.charC;
    }

    public String getString() {
        return this.strValue;
    }

    public Charset getCharset() {
        return this.byteC.getCharset();
    }

    public void setCharset(Charset charset) {
        this.byteC.setCharset(charset);
    }

    public void toBytes() {
        if (this.isNull()) {
            return;
        }
        if (!this.byteC.isNull()) {
            this.type = 2;
            return;
        }
        this.toString();
        this.type = 2;
        Charset charset = this.byteC.getCharset();
        ByteBuffer byteBuffer = charset.encode(this.strValue);
        this.byteC.setBytes(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
    }

    public void toChars() {
        if (this.isNull()) {
            return;
        }
        if (!this.charC.isNull()) {
            this.type = 3;
            return;
        }
        this.toString();
        this.type = 3;
        char[] cArray = this.strValue.toCharArray();
        this.charC.setChars(cArray, 0, cArray.length);
    }

    public int getLength() {
        if (this.type == 2) {
            return this.byteC.getLength();
        }
        if (this.type == 3) {
            return this.charC.getLength();
        }
        if (this.type == 1) {
            return this.strValue.length();
        }
        this.toString();
        if (this.strValue == null) {
            return 0;
        }
        return this.strValue.length();
    }

    public boolean equals(String string) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null) {
                    return string == null;
                }
                return this.strValue.equals(string);
            }
            case 3: {
                return this.charC.equals(string);
            }
            case 2: {
                return this.byteC.equals(string);
            }
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null) {
                    return string == null;
                }
                return this.strValue.equalsIgnoreCase(string);
            }
            case 3: {
                return this.charC.equalsIgnoreCase(string);
            }
            case 2: {
                return this.byteC.equalsIgnoreCase(string);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof MessageBytes) {
            return this.equals((MessageBytes)object);
        }
        return false;
    }

    public boolean equals(MessageBytes messageBytes) {
        switch (this.type) {
            case 1: {
                return messageBytes.equals(this.strValue);
            }
        }
        if (messageBytes.type != 3 && messageBytes.type != 2) {
            return this.equals(messageBytes.toString());
        }
        if (messageBytes.type == 3 && this.type == 3) {
            return this.charC.equals(messageBytes.charC);
        }
        if (messageBytes.type == 2 && this.type == 2) {
            return this.byteC.equals(messageBytes.byteC);
        }
        if (messageBytes.type == 3 && this.type == 2) {
            return this.byteC.equals(messageBytes.charC);
        }
        if (messageBytes.type == 2 && this.type == 3) {
            return messageBytes.byteC.equals(this.charC);
        }
        return true;
    }

    @Deprecated
    public boolean startsWith(String string) {
        switch (this.type) {
            case 1: {
                return this.strValue.startsWith(string);
            }
            case 3: {
                return this.charC.startsWith(string);
            }
            case 2: {
                return this.byteC.startsWith(string);
            }
        }
        return false;
    }

    public boolean startsWithIgnoreCase(String string, int n) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null) {
                    return false;
                }
                if (this.strValue.length() < n + string.length()) {
                    return false;
                }
                for (int i = 0; i < string.length(); ++i) {
                    if (Ascii.toLower(string.charAt(i)) == Ascii.toLower(this.strValue.charAt(n + i))) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                return this.charC.startsWithIgnoreCase(string, n);
            }
            case 2: {
                return this.byteC.startsWithIgnoreCase(string, n);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hasHashCode) {
            return this.hashCode;
        }
        int n = 0;
        this.hashCode = n = this.hash();
        this.hasHashCode = true;
        return n;
    }

    private int hash() {
        int n = 0;
        switch (this.type) {
            case 1: {
                for (int i = 0; i < this.strValue.length(); ++i) {
                    n = n * 37 + this.strValue.charAt(i);
                }
                return n;
            }
            case 3: {
                return this.charC.hash();
            }
            case 2: {
                return this.byteC.hash();
            }
        }
        return 0;
    }

    @Deprecated
    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(String string, int n) {
        this.toString();
        return this.strValue.indexOf(string, n);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOfIgnoreCase(String string, int n) {
        this.toString();
        String string2 = this.strValue.toUpperCase(Locale.ENGLISH);
        String string3 = string.toUpperCase(Locale.ENGLISH);
        return string2.indexOf(string3, n);
    }

    @Deprecated
    public int indexOf(char c, int n) {
        switch (this.type) {
            case 1: {
                return this.strValue.indexOf(c, n);
            }
            case 3: {
                return this.charC.indexOf(c, n);
            }
            case 2: {
                return this.byteC.indexOf(c, n);
            }
        }
        return -1;
    }

    public void duplicate(MessageBytes messageBytes) throws IOException {
        switch (messageBytes.getType()) {
            case 2: {
                this.type = 2;
                ByteChunk byteChunk = messageBytes.getByteChunk();
                this.byteC.allocate(2 * byteChunk.getLength(), -1);
                this.byteC.append(byteChunk);
                break;
            }
            case 3: {
                this.type = 3;
                CharChunk charChunk = messageBytes.getCharChunk();
                this.charC.allocate(2 * charChunk.getLength(), -1);
                this.charC.append(charChunk);
                break;
            }
            case 1: {
                this.type = 1;
                String string = messageBytes.getString();
                this.setString(string);
            }
        }
        this.setCharset(messageBytes.getCharset());
    }

    @Deprecated
    public void setInt(int n) {
        int n2;
        this.byteC.allocate(16, 32);
        int n3 = n;
        byte[] byArray = this.byteC.getBuffer();
        int n4 = 0;
        int n5 = 0;
        if (n == 0) {
            byArray[n5++] = 48;
        }
        if (n < 0) {
            n3 = -n;
            byArray[n5++] = 45;
        }
        while (n3 > 0) {
            n2 = n3 % 10;
            n3 /= 10;
            byArray[n5++] = HexUtils.getHex(n2);
        }
        this.byteC.setOffset(0);
        this.byteC.setEnd(n5);
        --n5;
        if (n < 0) {
            ++n4;
        }
        while (n5 > n4) {
            n2 = byArray[n4];
            byArray[n4] = byArray[n5];
            byArray[n5] = n2;
            ++n4;
            --n5;
        }
        this.intValue = n;
        this.hasStrValue = false;
        this.hasHashCode = false;
        this.hasIntValue = true;
        this.hasLongValue = false;
        this.type = 2;
    }

    public void setLong(long l) {
        int n;
        this.byteC.allocate(32, 64);
        long l2 = l;
        byte[] byArray = this.byteC.getBuffer();
        int n2 = 0;
        int n3 = 0;
        if (l == 0L) {
            byArray[n3++] = 48;
        }
        if (l < 0L) {
            l2 = -l;
            byArray[n3++] = 45;
        }
        while (l2 > 0L) {
            n = (int)(l2 % 10L);
            l2 /= 10L;
            byArray[n3++] = HexUtils.getHex(n);
        }
        this.byteC.setOffset(0);
        this.byteC.setEnd(n3);
        --n3;
        if (l < 0L) {
            ++n2;
        }
        while (n3 > n2) {
            n = byArray[n2];
            byArray[n2] = byArray[n3];
            byArray[n3] = n;
            ++n2;
            --n3;
        }
        this.longValue = l;
        this.hasStrValue = false;
        this.hasHashCode = false;
        this.hasIntValue = false;
        this.hasLongValue = true;
        this.type = 2;
    }

    @Deprecated
    public int getInt() {
        if (this.hasIntValue) {
            return this.intValue;
        }
        switch (this.type) {
            case 2: {
                this.intValue = this.byteC.getInt();
                break;
            }
            default: {
                this.intValue = Integer.parseInt(this.toString());
            }
        }
        this.hasIntValue = true;
        return this.intValue;
    }

    public long getLong() {
        if (this.hasLongValue) {
            return this.longValue;
        }
        switch (this.type) {
            case 2: {
                this.longValue = this.byteC.getLong();
                break;
            }
            default: {
                this.longValue = Long.parseLong(this.toString());
            }
        }
        this.hasLongValue = true;
        return this.longValue;
    }

    @Deprecated
    public static void setFactory(MessageBytesFactory messageBytesFactory) {
        factory = messageBytesFactory;
    }

    public static class MessageBytesFactory {
        protected MessageBytesFactory() {
        }

        public MessageBytes newInstance() {
            return new MessageBytes();
        }
    }
}

