/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JniLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JniLifecycleListener.class);
    private String libraryName = "";
    private String libraryPath = "";

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("before_start".equals(lifecycleEvent.getType())) {
            if (!this.libraryName.isEmpty()) {
                System.loadLibrary(this.libraryName);
                log.info((Object)("Loaded native library " + this.libraryName));
            } else if (!this.libraryPath.isEmpty()) {
                System.load(this.libraryPath);
                log.info((Object)("Loaded native library from " + this.libraryPath));
            } else {
                throw new IllegalArgumentException("Either libraryName or libraryPath must be set");
            }
        }
    }

    public void setLibraryName(String string) {
        if (!this.libraryPath.isEmpty()) {
            throw new IllegalArgumentException("Either libraryName or libraryPath may be set, not both.");
        }
        this.libraryName = string;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryPath(String string) {
        if (!this.libraryName.isEmpty()) {
            throw new IllegalArgumentException("Either libraryName or libraryPath may be set, not both.");
        }
        this.libraryPath = string;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }
}

