/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.Constants;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.DefaultMatcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class FastMatcher
extends AbstractMatcher {
    private static final int SIZE_LIMIT = 0x100000;
    private static final int LINE_LIMIT = 4096;
    private static final Logger LOG = Logger.getLogger(FastMatcher.class.getName());
    private SearchPattern searchPattern;
    private Pattern pattern;
    private DefaultMatcher defaultMatcher = null;
    private static final Pattern linePattern = Pattern.compile("(.*)(\\r\\n|\\n|\\r)");
    private boolean trivial;
    private boolean asciiPattern;
    private long totalTime;
    private int fileMatches = 0;
    private int itemMatches = 0;
    private boolean multiline = false;

    public FastMatcher(SearchPattern searchPattern) {
        boolean bl = this.trivial = searchPattern.getSearchExpression() == null || searchPattern.getSearchExpression().isEmpty();
        if (!this.trivial) {
            this.searchPattern = searchPattern;
            String string = searchPattern.getSearchExpression();
            this.pattern = TextRegexpUtil.makeTextPattern(searchPattern);
            this.multiline = TextRegexpUtil.canBeMultilinePattern(string);
            boolean bl2 = this.asciiPattern = string.matches("\\p{ASCII}+") && !string.contains(".") && !string.matches(".*\\\\[0xXuU].*");
            if (this.asciiPattern) {
                LOG.info("Using ASCII pattern");
            }
        }
    }

    @Override
    public MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        if (this.trivial) {
            return new MatchingObject.Def(fileObject, null, null);
        }
        searchListener.fileContentMatchingStarted(fileObject.getPath());
        long l = System.currentTimeMillis();
        File file = FileUtil.toFile((FileObject)fileObject);
        MatchingObject.Def def = fileObject.getSize() > 0x100000L || file == null ? this.checkBig(fileObject, file, searchListener) : this.checkSmall(fileObject, file, searchListener);
        this.totalTime += System.currentTimeMillis() - l;
        return def;
    }

    @Override
    public void terminate() {
        if (this.defaultMatcher != null) {
            this.defaultMatcher.terminate();
        }
    }

    private DefaultMatcher getDefaultMatcher() {
        if (this.defaultMatcher == null) {
            this.defaultMatcher = new DefaultMatcher(this.searchPattern);
        }
        return this.defaultMatcher;
    }

    private List<TextDetail> matchWholeFile(CharSequence charSequence, FileObject fileObject) throws DataObjectNotFoundException {
        Matcher matcher = this.pattern.matcher(charSequence);
        DataObject dataObject = null;
        LineInfoHelper lineInfoHelper = new LineInfoHelper(charSequence);
        LinkedList<TextDetail> linkedList = null;
        while (matcher.find()) {
            if (linkedList == null) {
                linkedList = new LinkedList<TextDetail>();
                dataObject = DataObject.find((FileObject)fileObject);
                ++this.fileMatches;
            }
            ++this.itemMatches;
            TextDetail textDetail = new TextDetail(dataObject, this.searchPattern);
            lineInfoHelper.findAndSetPositionInfo(textDetail, matcher.start(), matcher.end(), matcher.group());
            linkedList.add(textDetail);
            if (this.fileMatches < Constants.COUNT_LIMIT && this.itemMatches < Constants.DETAILS_COUNT_LIMIT) continue;
            break;
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TextDetail> matchLines(CharSequence charSequence, FileObject fileObject) throws DataObjectNotFoundException, IOException {
        LineInfo lineInfo;
        ArrayList<Object> arrayList = null;
        DataObject dataObject = null;
        int n = 0;
        int n2 = Constants.DETAILS_COUNT_LIMIT;
        boolean bl = true;
        LineReader lineReader = new LineReader(charSequence);
        while ((lineInfo = lineReader.readNext()) != null && bl && n < n2) {
            Object object;
            Matcher matcher = this.pattern.matcher(lineInfo.getString());
            while (matcher.find() && bl) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                object = this.createLineMatchTextDetail(dataObject, lineInfo.getNumber(), matcher, lineInfo.getString(), lineInfo.start);
                arrayList.add(object);
                ++n;
            }
            if (lineInfo.getNumber() % 50 != 0) continue;
            object = this;
            synchronized (object) {
                bl = true;
            }
        }
        return arrayList;
    }

    private TextDetail createLineMatchTextDetail(DataObject dataObject, int n, Matcher matcher, String string, int n2) {
        TextDetail textDetail = new TextDetail(dataObject, this.searchPattern);
        textDetail.setLine(n);
        textDetail.setColumn(matcher.start() + 1);
        textDetail.setMatchedText(matcher.group());
        textDetail.setStartOffset(n2 + matcher.start());
        textDetail.setEndOffset(n2 + matcher.end());
        textDetail.setMarkLength(matcher.end() - matcher.start());
        textDetail.setLineText(string);
        return textDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MatchingObject.Def checkSmall(FileObject fileObject, File file, SearchListener searchListener) {
        MatchingObject.Def def;
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        MappedByteBuffer mappedByteBuffer;
        block24: {
            block25: {
                MatchingObject.Def def2;
                block22: {
                    block23: {
                        MatchingObject.Def def3;
                        block20: {
                            block21: {
                                mappedByteBuffer = null;
                                abstractInterruptibleChannel = null;
                                try {
                                    MatchingObject.Def def4;
                                    List<TextDetail> list;
                                    FileInputStream fileInputStream = new FileInputStream(file);
                                    abstractInterruptibleChannel = fileInputStream.getChannel();
                                    int n = (int)((FileChannel)abstractInterruptibleChannel).size();
                                    mappedByteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_ONLY, 0L, n);
                                    if (this.asciiPattern && !this.matchesIgnoringEncoding(mappedByteBuffer)) {
                                        def3 = null;
                                        if (abstractInterruptibleChannel == null) break block20;
                                        break block21;
                                    }
                                    Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
                                    CharsetDecoder charsetDecoder = this.prepareDecoder(charset);
                                    charsetDecoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                                    CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
                                    List<TextDetail> list2 = list = this.multiline ? this.matchWholeFile(charBuffer, fileObject) : this.matchLines(charBuffer, fileObject);
                                    if (list == null) {
                                        def2 = null;
                                        if (abstractInterruptibleChannel == null) break block22;
                                        break block23;
                                    }
                                    def = def4 = new MatchingObject.Def(fileObject, charsetDecoder.charset(), list);
                                    if (abstractInterruptibleChannel == null) break block24;
                                    break block25;
                                }
                                catch (Exception exception) {
                                    searchListener.generalError(exception);
                                    MatchingObject.Def def5 = null;
                                    return def5;
                                }
                            }
                            try {
                                abstractInterruptibleChannel.close();
                            }
                            catch (IOException iOException) {
                                searchListener.generalError(iOException);
                            }
                        }
                        this.unmap(mappedByteBuffer);
                        return def3;
                    }
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {
                        searchListener.generalError(iOException);
                    }
                }
                this.unmap(mappedByteBuffer);
                return def2;
            }
            try {
                abstractInterruptibleChannel.close();
            }
            catch (IOException iOException) {
                searchListener.generalError(iOException);
            }
        }
        this.unmap(mappedByteBuffer);
        return def;
        finally {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {
                    searchListener.generalError(iOException);
                }
            }
            this.unmap(mappedByteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatchingObject.Def checkBig(FileObject fileObject, File file, SearchListener searchListener) {
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        CharsetDecoder charsetDecoder = this.prepareDecoder(charset);
        try (LongCharSequence longCharSequence = null;){
            MatchingObject.Def def;
            List<TextDetail> list;
            longCharSequence = new LongCharSequence(file, charset);
            List<TextDetail> list2 = list = this.multiline ? this.matchWholeFile(longCharSequence, fileObject) : this.matchLines(longCharSequence, fileObject);
            if (list == null) {
                MatchingObject.Def def2 = null;
                return def2;
            }
            MatchingObject.Def def3 = def = new MatchingObject.Def(fileObject, charsetDecoder.charset(), list);
            return def3;
        }
    }

    private boolean matchesIgnoringEncoding(ByteBuffer byteBuffer) {
        Matcher matcher = this.pattern.matcher(new FastCharSequence(byteBuffer, 0));
        boolean bl = matcher.find();
        return bl;
    }

    private void unmap(MappedByteBuffer mappedByteBuffer) {
        try {
            Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)mappedByteBuffer, new Object[0]);
            object.getClass().getMethod("clean", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class LineInfo {
        private int start;
        private int length = 0;
        private int number;
        private StringBuilder sb = new StringBuilder();
        private String string = null;

        LineInfo(int n, int n2) {
            this.start = n;
            this.number = n2;
        }

        private void appendCharacter(int n) throws IOException {
            this.sb.append((char)n);
            ++this.length;
            if (this.length > 4096) {
                throw new IOException("Line is too long: " + this.number);
            }
        }

        String getString() {
            return this.string;
        }

        int getNumber() {
            return this.number;
        }

        int getFileStart() {
            return this.start;
        }

        int getFileEnd() {
            return this.start + this.length;
        }

        private boolean isNotEmpty() {
            return this.length > 0;
        }

        int getLength() {
            return this.length;
        }

        void close() {
            this.string = this.sb.toString();
            this.sb = null;
        }
    }

    class LineReader {
        int lastChar = 0;
        int pos = 0;
        int line = 1;
        int length = 0;
        CharSequence charSequence;

        LineReader(CharSequence charSequence) throws IOException {
            this.charSequence = charSequence;
            this.length = charSequence.length();
        }

        LineInfo readNext() throws IOException {
            LineInfo lineInfo = new LineInfo(this.pos, this.line);
            if (this.pos >= this.length) {
                return null;
            }
            while (this.pos < this.length) {
                char c = this.charSequence.charAt(this.pos);
                ++this.pos;
                if (c == '\n' && this.lastChar == 13) {
                    lineInfo = new LineInfo(this.pos, this.line);
                } else {
                    if (this.isLineTerminator(c)) {
                        ++this.line;
                        this.lastChar = c;
                        lineInfo.close();
                        return lineInfo;
                    }
                    lineInfo.appendCharacter(c);
                }
                this.lastChar = c;
            }
            lineInfo.close();
            return lineInfo;
        }

        private boolean isLineTerminator(int n) {
            return n == 10 || n == 13 || n == 8232 || n == 133 || n == 8233;
        }
    }

    private class LineInfoHelper {
        private CharSequence charSequence;
        private Matcher lineMatcher;
        private int lastStartPos = 0;
        private int currentLineNumber = 0;
        private int currentLineStart = -1;
        private int currentLineEnd = -1;
        private String lastLine = null;

        public LineInfoHelper(CharSequence charSequence) {
            this.charSequence = charSequence;
            this.lineMatcher = linePattern.matcher(charSequence);
        }

        public void findAndSetPositionInfo(TextDetail textDetail, int n, int n2, String string) {
            if (n < this.lastStartPos) {
                throw new IllegalStateException("Start offset lower than the previous one.");
            }
            this.updateStateForPosition(n);
            this.setTextDetailInfo(textDetail, n, n2, string);
        }

        private void updateStateForPosition(int n) {
            if (n > this.currentLineEnd) {
                boolean bl = false;
                while (this.lineMatcher.find()) {
                    ++this.currentLineNumber;
                    this.currentLineEnd = this.lineMatcher.end() - 1;
                    if (this.lineMatcher.end() <= n) continue;
                    this.currentLineStart = this.lineMatcher.start();
                    this.lastLine = this.lineMatcher.group().trim();
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (this.currentLineNumber == 0) {
                        this.setupOnlyLine();
                    } else {
                        this.setupLastLine();
                    }
                }
            }
        }

        private void setTextDetailInfo(TextDetail textDetail, int n, int n2, String string) {
            textDetail.setLine(this.currentLineNumber);
            textDetail.setStartOffset(n);
            textDetail.setEndOffset(n2);
            textDetail.setMarkLength(n2 - n);
            textDetail.setMatchedText(string);
            textDetail.setColumn(n - this.currentLineStart + 1);
            textDetail.setLineText(this.lastLine);
        }

        private void setupLastLine() {
            ++this.currentLineNumber;
            this.currentLineStart = this.currentLineEnd + 1;
            this.currentLineEnd = this.charSequence.length();
            this.lastLine = this.charSequence.subSequence(this.currentLineStart, this.currentLineEnd).toString().trim();
        }

        private void setupOnlyLine() {
            this.currentLineNumber = 1;
            String string = this.charSequence.toString();
            this.currentLineStart = 0;
            this.currentLineEnd = string.length();
            this.lastLine = string.trim();
        }
    }

    private class LongCharSequence
    implements CharSequence {
        private long fileSize;
        private FileInputStream fileInputStream;
        private FileChannel fileChannel;
        private Charset charset;
        private int currentStart = -1;
        private CharBuffer currentBuffer = CharBuffer.allocate(0x100000);
        private CharsetDecoder currentDecoder = null;
        private int length = -1;
        private long readBytes = 0L;
        private int lastIndex = 0;
        private int returns = 0;
        private int retrieves = 0;
        private int maps = 0;

        public LongCharSequence(File file, Charset charset) throws FileNotFoundException {
            this.charset = charset;
            this.fileInputStream = new FileInputStream(file);
            this.fileChannel = this.fileInputStream.getChannel();
            this.fileSize = file.length();
        }

        public void reset() {
            this.currentDecoder = FastMatcher.this.prepareDecoder(this.charset);
            this.currentDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.readBytes = 0L;
            this.currentBuffer.clear();
            this.currentStart = -1;
        }

        @Override
        public int length() {
            if (this.length != -1) {
                return this.length;
            }
            long l = System.currentTimeMillis();
            int n = 0;
            MappedByteBuffer mappedByteBuffer = null;
            CharBuffer charBuffer = CharBuffer.allocate(0x100000);
            CharsetDecoder charsetDecoder = FastMatcher.this.prepareDecoder(this.charset);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
            try {
                boolean bl;
                int n2;
                for (long i = 0L; i < this.fileSize; i += (long)n2) {
                    CoderResult coderResult;
                    mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, i, Math.min(0x100000L, this.fileSize - i));
                    do {
                        charBuffer.clear();
                        coderResult = charsetDecoder.decode(mappedByteBuffer, charBuffer, i + 0x100000L >= this.fileSize);
                        if (coderResult.isUnmappable() || coderResult.isMalformed() || coderResult.isError()) {
                            throw new IOException("Error decoding file: " + coderResult.toString() + " ");
                        }
                        if (i + 0x100000L >= this.fileSize) {
                            LOG.info("Coding end");
                        }
                        n += charBuffer.position();
                    } while (coderResult.isOverflow());
                    n2 = mappedByteBuffer.position();
                    FastMatcher.this.unmap(mappedByteBuffer);
                }
                charBuffer.clear();
                do {
                    bl = charsetDecoder.flush(charBuffer).isOverflow();
                    n += charBuffer.position();
                    charBuffer.clear();
                } while (bl);
            }
            catch (IOException iOException) {
                if (mappedByteBuffer != null) {
                    FastMatcher.this.unmap(mappedByteBuffer);
                }
                Exceptions.printStackTrace((Throwable)iOException);
            }
            this.length = n;
            LOG.log(Level.INFO, "Length computed in {0} ms.", System.currentTimeMillis() - l);
            return this.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public char charAt(int n) {
            boolean bl;
            int n2;
            block16: {
                if (n < this.lastIndex) {
                    ++this.returns;
                }
                this.lastIndex = n;
                if (n > this.length()) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.isInBuffer(n)) {
                    return this.getFromBuffer(n);
                }
                if (n < this.currentStart || this.currentStart == -1) {
                    this.reset();
                }
                ++this.retrieves;
                Buffer buffer = null;
                try {
                    while (this.readBytes < this.fileSize) {
                        try {
                            CoderResult coderResult;
                            buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.readBytes, Math.min(0x100000L, this.fileSize - this.readBytes));
                            ++this.maps;
                            do {
                                this.currentStart = this.currentStart == -1 ? 0 : this.currentStart + this.currentBuffer.limit();
                                this.currentBuffer.clear();
                                coderResult = this.currentDecoder.decode((ByteBuffer)buffer, this.currentBuffer, this.readBytes + 0x100000L >= this.fileSize);
                                this.currentBuffer.flip();
                                n2 = this.currentBuffer.limit();
                                if (this.currentStart + n2 > n) {
                                    char c = this.getFromBuffer(n);
                                    return c;
                                }
                                if (coderResult.isUnmappable()) throw new IOException("Error decoding file: " + coderResult.toString() + " ");
                                if (coderResult.isMalformed()) throw new IOException("Error decoding file: " + coderResult.toString() + " ");
                                if (!coderResult.isError()) continue;
                                throw new IOException("Error decoding file: " + coderResult.toString() + " ");
                            } while (coderResult.isOverflow());
                        }
                        finally {
                            if (buffer == null) continue;
                            int n3 = buffer.position();
                            this.readBytes += (long)n3;
                            FastMatcher.this.unmap((MappedByteBuffer)buffer);
                        }
                    }
                    break block16;
                }
                catch (IOException iOException) {
                    if (buffer != null) {
                        FastMatcher.this.unmap(buffer);
                    }
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                throw new IllegalStateException("Cannot get character.");
            }
            do {
                bl = this.currentDecoder.flush(this.currentBuffer).isOverflow();
                n2 = this.currentBuffer.position();
                if (n2 + this.currentStart > n) {
                    this.currentBuffer.flip();
                    return this.currentBuffer.get(n - this.currentStart);
                }
                this.currentBuffer.clear();
                this.currentStart += n2;
            } while (bl);
            throw new IllegalStateException("Cannot get character.");
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            if (n2 - n < 4096) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = n; i < n2; ++i) {
                    stringBuilder.append(this.charAt(i));
                }
                return stringBuilder.toString();
            }
            throw new IllegalArgumentException("Long subSequences are not supported.");
        }

        @Override
        public String toString() {
            return this.subSequence(0, this.length()).toString();
        }

        public void close() {
            if (this.fileChannel != null) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.fileInputStream != null) {
                try {
                    this.fileInputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        public void terminate() {
        }

        private boolean isInBuffer(int n) {
            return this.currentStart != -1 && n >= this.currentStart && n < this.currentStart + this.currentBuffer.limit();
        }

        private char getFromBuffer(int n) {
            char c = this.currentBuffer.charAt(n - this.currentStart);
            return c;
        }
    }

    private class FastCharSequence
    implements CharSequence {
        private ByteBuffer bb;
        private int start;

        public FastCharSequence(ByteBuffer byteBuffer, int n) {
            this.bb = byteBuffer;
            this.start = n;
        }

        @Override
        public int length() {
            return this.bb.limit();
        }

        @Override
        public char charAt(int n) {
            return (char)this.bb.get(this.start + n);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new FastCharSequence(this.bb, n);
        }
    }
}

