# RAML Definition System

[![Build Status](https://travis-ci.org/raml-org/raml-definition-system.svg?branch=master)](https://travis-ci.org/raml-org/raml-definition-system)

> This repository contains a set of interfaces that represents a declarative description of the RAML specification.

**IMPORTANT: This is still in development and should be considered alpha.**

## Installation

### From NPM

```
npm install raml-definition-system --save
```

### From Sources

```
npm install
```

## Generate

Make sure you executed all necessary installation steps before you try to generate anything. See section [From Sources](#from-sources) for more information.

The result files can be found inside the `dist/` repository ending with `.json`.

### Build Sources

 ```
 npm run build
 ```

### JSON Structure for the Definition System

One can either use the provided interfaces in TypeScript or a JSON representation of the definition system that can be generated by running either the [complete build](#build sources) or `npm run generateJSON`.

## Contribute

The `raml-definition-system` is an open source project and any contribution is always welcome. **Please bear in mind that the definition system is a full reflection of the RAML specification and must not contain anything that is not mentioned inside the specification. Therefore, contribution to the actual interfaces should be limited to bug fixes only.**

1. Check for open issues or open a fresh issue to start a discussion around an idea or a bug.
2. Fork the repository on Github and make your changes on the **develop** branch (or branch off of it).
4. Send a pull request (with the develop branch as the target).

A big thank you goes out to everyone who helped with the project, the [contributors](https://github.com/raml-org/raml-definition-system/graphs/contributors) and everyone who took the time to report issues and give feedback.

You can also directly get in touch with us. Simply send us an email to: info@raml.org

## RAML version support

Currently, the definition system provides interfaces for RAML 0.8 and 1.0 RC1 version.

## License

Apache License 2.0
