/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { isDocument, visit } from 'yaml';
export function getParent(doc, nodeToFind) {
    let parentNode;
    visit(doc, (_, node, path) => {
        if (node === nodeToFind) {
            parentNode = path[path.length - 1];
            return visit.BREAK;
        }
    });
    if (isDocument(parentNode)) {
        return undefined;
    }
    return parentNode;
}
//# sourceMappingURL=astUtils.js.map