/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "yaml"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getParent = void 0;
    const yaml_1 = require("yaml");
    function getParent(doc, nodeToFind) {
        let parentNode;
        yaml_1.visit(doc, (_, node, path) => {
            if (node === nodeToFind) {
                parentNode = path[path.length - 1];
                return yaml_1.visit.BREAK;
            }
        });
        if (yaml_1.isDocument(parentNode)) {
            return undefined;
        }
        return parentNode;
    }
    exports.getParent = getParent;
});
//# sourceMappingURL=astUtils.js.map