/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.GeneralRouter;
import net.osmand.router.VehicleRouter;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RoutingConfiguration {
    public static final int DEFAULT_MEMORY_LIMIT = 30;
    public final float DEVIATION_RADIUS = 3000.0f;
    public Map<String, String> attributes = new LinkedHashMap<String, String>();
    public float heuristicCoefficient = 1.0f;
    public int ZOOM_TO_LOAD_TILES = 16;
    public int memoryLimitation;
    public int planRoadDirection = 0;
    public GeneralRouter router = new GeneralRouter(GeneralRouter.GeneralRouterProfile.CAR, new LinkedHashMap<String, String>());
    public String routerName = "";
    public Double initialDirection;
    public float recalculateDistance = 20000.0f;
    private static Builder DEFAULT;

    private static int parseSilentInt(String t, int v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Integer.parseInt(t);
    }

    private static float parseSilentFloat(String t, float v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Float.parseFloat(t);
    }

    public static Builder getDefault() {
        if (DEFAULT == null) {
            try {
                DEFAULT = RoutingConfiguration.parseFromInputStream(OsmWindow.getInstance().getResource("routing.xml"));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return DEFAULT;
    }

    public static Builder parseFromInputStream(InputStream is) throws IOException, XmlPullParserException {
        int tok;
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        Builder config = new Builder();
        GeneralRouter currentRouter = null;
        GeneralRouter.RouteDataObjectAttribute currentAttribute = null;
        String preType = null;
        Stack<RoutingRule> rulesStck = new Stack<RoutingRule>();
        parser.setInput(is, "UTF-8");
        while ((tok = parser.next()) != 1) {
            String pname;
            if (tok == 2) {
                String name = parser.getName();
                if ("osmand_routing_config".equals(name)) {
                    config.defaultRouter = parser.getAttributeValue("", "defaultProfile");
                    continue;
                }
                if ("routingProfile".equals(name)) {
                    currentRouter = RoutingConfiguration.parseRoutingProfile(parser, config);
                    continue;
                }
                if ("attribute".equals(name)) {
                    RoutingConfiguration.parseAttribute(parser, config, currentRouter);
                    continue;
                }
                if ("parameter".equals(name)) {
                    RoutingConfiguration.parseRoutingParameter(parser, currentRouter);
                    continue;
                }
                if ("point".equals(name) || "way".equals(name)) {
                    String attribute = parser.getAttributeValue("", "attribute");
                    currentAttribute = GeneralRouter.RouteDataObjectAttribute.getValueOf(attribute);
                    preType = parser.getAttributeValue("", "type");
                    continue;
                }
                RoutingConfiguration.parseRoutingRule(parser, currentRouter, currentAttribute, preType, rulesStck);
                continue;
            }
            if (tok != 3 || !RoutingConfiguration.checkTag(pname = parser.getName())) continue;
            rulesStck.pop();
        }
        is.close();
        return config;
    }

    private static void parseRoutingParameter(XmlPullParser parser, GeneralRouter currentRouter) {
        String description = parser.getAttributeValue("", "description");
        String name = parser.getAttributeValue("", "name");
        String id2 = parser.getAttributeValue("", "id");
        String type = parser.getAttributeValue("", "type");
        if (type.equalsIgnoreCase("boolean")) {
            currentRouter.registerBooleanParameter(id2, name, description);
        } else if (type.equalsIgnoreCase("numeric")) {
            String values = parser.getAttributeValue("", "values");
            String valueDescriptions = parser.getAttributeValue("", "valueDescriptions");
            String[] strValues = values.split(",");
            Double[] vls = new Double[strValues.length];
            for (int i = 0; i < vls.length; ++i) {
                vls[i] = Double.parseDouble(strValues[i].trim());
            }
            currentRouter.registerNumericParameter(id2, name, description, vls, valueDescriptions.split(","));
        } else {
            throw new UnsupportedOperationException("Unsupported routing parameter type - " + type);
        }
    }

    private static void parseRoutingRule(XmlPullParser parser, GeneralRouter currentRouter, GeneralRouter.RouteDataObjectAttribute attr, String parentType, Stack<RoutingRule> stack) {
        String pname = parser.getName();
        if (RoutingConfiguration.checkTag(pname)) {
            if (attr == null) {
                throw new NullPointerException("Select tag filter outside road attribute < " + pname + " > : " + parser.getLineNumber());
            }
            RoutingRule rr = new RoutingRule();
            rr.tagName = pname;
            rr.t = parser.getAttributeValue("", "t");
            rr.v = parser.getAttributeValue("", "v");
            rr.param = parser.getAttributeValue("", "param");
            rr.value1 = parser.getAttributeValue("", "value1");
            rr.value2 = parser.getAttributeValue("", "value2");
            rr.type = parser.getAttributeValue("", "type");
            if ((rr.type == null || rr.type.length() == 0) && parentType != null && parentType.length() > 0) {
                rr.type = parentType;
            }
            GeneralRouter.RouteAttributeContext ctx = currentRouter.getObjContext(attr);
            if ("select".equals(rr.tagName)) {
                String val = parser.getAttributeValue("", "value");
                String type = rr.type;
                ctx.registerNewRule(val, type);
                RoutingConfiguration.addSubclause(rr, ctx);
                for (int i = 0; i < stack.size(); ++i) {
                    RoutingConfiguration.addSubclause((RoutingRule)stack.get(i), ctx);
                }
            } else if (stack.size() > 0 && stack.peek().tagName.equals("select")) {
                RoutingConfiguration.addSubclause(rr, ctx);
            }
            stack.push(rr);
        }
    }

    private static boolean checkTag(String pname) {
        return "select".equals(pname) || "if".equals(pname) || "ifnot".equals(pname) || "gt".equals(pname) || "le".equals(pname);
    }

    private static void addSubclause(RoutingRule rr, GeneralRouter.RouteAttributeContext ctx) {
        boolean not = "ifnot".equals(rr.tagName);
        if (!Algorithms.isEmpty(rr.param)) {
            ctx.getLastRule().registerAndParamCondition(rr.param, not);
        }
        if (!Algorithms.isEmpty(rr.t)) {
            ctx.getLastRule().registerAndTagValueCondition(rr.t, Algorithms.isEmpty(rr.v) ? null : rr.v, not);
        }
        if (rr.tagName.equals("gt")) {
            ctx.getLastRule().registerGreatCondition(rr.value1, rr.value2, rr.type);
        } else if (rr.tagName.equals("le")) {
            ctx.getLastRule().registerLessCondition(rr.value1, rr.value2, rr.type);
        }
    }

    private static GeneralRouter parseRoutingProfile(XmlPullParser parser, Builder config) {
        String currentSelectedRouter = parser.getAttributeValue("", "name");
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attrs.put(parser.getAttributeName(i), parser.getAttributeValue(i));
        }
        GeneralRouter.GeneralRouterProfile c = (GeneralRouter.GeneralRouterProfile)Algorithms.parseEnumValue((Enum[])GeneralRouter.GeneralRouterProfile.values(), (String)parser.getAttributeValue("", "baseProfile"), (Enum)GeneralRouter.GeneralRouterProfile.CAR);
        GeneralRouter currentRouter = new GeneralRouter(c, attrs);
        config.routers.put(currentSelectedRouter, currentRouter);
        return currentRouter;
    }

    private static void parseAttribute(XmlPullParser parser, Builder config, GeneralRouter currentRouter) {
        if (currentRouter != null) {
            currentRouter.addAttribute(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
        } else {
            config.attributes.put(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
        }
    }

    private static class RoutingRule {
        String tagName;
        String t;
        String v;
        String param;
        String value1;
        String value2;
        String type;

        private RoutingRule() {
        }
    }

    public static class Builder {
        private String defaultRouter = "";
        private Map<String, GeneralRouter> routers = new LinkedHashMap<String, GeneralRouter>();
        private Map<String, String> attributes = new LinkedHashMap<String, String>();
        private HashMap<Long, Location> impassableRoadLocations = new HashMap();
        private List<RouteDataObject> impassableRoads = new ArrayList<RouteDataObject>();

        public RoutingConfiguration build(String router, int memoryLimitMB) {
            return this.build(router, null, memoryLimitMB, null);
        }

        public RoutingConfiguration build(String router, int memoryLimitMB, Map<String, String> params) {
            return this.build(router, null, memoryLimitMB, params);
        }

        public RoutingConfiguration build(String router, Double direction, int memoryLimitMB, Map<String, String> params) {
            if (!this.routers.containsKey(router)) {
                router = this.defaultRouter;
            }
            RoutingConfiguration i = new RoutingConfiguration();
            if (this.routers.containsKey(router)) {
                i.router = this.routers.get(router);
                if (params != null) {
                    i.router = i.router.build((Map)params);
                }
                i.routerName = router;
            }
            this.attributes.put("routerName", router);
            i.attributes.putAll(this.attributes);
            i.initialDirection = direction;
            i.recalculateDistance = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "recalculateDistanceHelp"), i.recalculateDistance);
            i.heuristicCoefficient = RoutingConfiguration.parseSilentFloat(this.getAttribute(i.router, "heuristicCoefficient"), i.heuristicCoefficient);
            i.router.addImpassableRoads(this.impassableRoadLocations.keySet());
            i.ZOOM_TO_LOAD_TILES = RoutingConfiguration.parseSilentInt(this.getAttribute(i.router, "zoomToLoadTiles"), i.ZOOM_TO_LOAD_TILES);
            int desirable = RoutingConfiguration.parseSilentInt(this.getAttribute(i.router, "memoryLimitInMB"), 0);
            if (desirable != 0) {
                i.memoryLimitation = desirable * 0x100000;
            } else {
                if (memoryLimitMB == 0) {
                    memoryLimitMB = 30;
                }
                i.memoryLimitation = memoryLimitMB * 0x100000;
            }
            i.planRoadDirection = RoutingConfiguration.parseSilentInt(this.getAttribute(i.router, "planRoadDirection"), i.planRoadDirection);
            return i;
        }

        public List<RouteDataObject> getImpassableRoads() {
            return this.impassableRoads;
        }

        public Map<Long, Location> getImpassableRoadLocations() {
            return this.impassableRoadLocations;
        }

        public void addImpassableRoad(RouteDataObject route, Location location) {
            if (!this.impassableRoadLocations.containsKey(route.id)) {
                this.impassableRoadLocations.put(route.id, location);
                this.impassableRoads.add(route);
            }
        }

        private String getAttribute(VehicleRouter router, String propertyName) {
            if (router.containsAttribute(propertyName)) {
                return router.getAttribute(propertyName);
            }
            return this.attributes.get(propertyName);
        }

        public String getDefaultRouter() {
            return this.defaultRouter;
        }

        public GeneralRouter getRouter(String applicationMode) {
            return this.routers.get(applicationMode);
        }

        public void removeImpassableRoad(RouteDataObject obj) {
            this.impassableRoadLocations.remove(obj.id);
            this.impassableRoads.remove(obj);
        }
    }
}

