/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.NetMask;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class RemoteCIDRValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(RemoteCIDRValve.class);
    private final List<NetMask> allow = new ArrayList<NetMask>();
    private final List<NetMask> deny = new ArrayList<NetMask>();

    public RemoteCIDRValve() {
        super(true);
    }

    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    public void setAllow(String string) {
        List<String> list = this.fillFromInput(string, this.allow);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", new Object[]{"allow"}));
    }

    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    public void setDeny(String string) {
        List<String> list = this.fillFromInput(string, this.deny);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", new Object[]{"deny"}));
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.isAllowed(request.getRequest().getRemoteAddr())) {
            this.getNext().invoke(request, response);
        } else {
            response.sendError(403);
        }
    }

    private boolean isAllowed(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            log.error((Object)sm.getString("remoteCidrValve.noRemoteIp"), (Throwable)unknownHostException);
            return false;
        }
        for (NetMask netMask : this.deny) {
            if (!netMask.matches(inetAddress)) continue;
            return false;
        }
        for (NetMask netMask : this.allow) {
            if (!netMask.matches(inetAddress)) continue;
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    private List<String> fillFromInput(String string, List<NetMask> list) {
        list.clear();
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : string.split("\\s*,\\s*")) {
            try {
                NetMask netMask = new NetMask(string2);
                list.add(netMask);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                linkedList.add(string2 + ": " + illegalArgumentException.getMessage());
            }
        }
        return Collections.unmodifiableList(linkedList);
    }
}

