/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transform.FileTransformer;
import org.eclipse.aether.transform.FileTransformerManager;

@Named
public class DefaultDeployer
implements Deployer,
Service {
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private UpdateCheckManager updateCheckManager;
    private Collection<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultDeployer() {
    }

    @Inject
    DefaultDeployer(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, UpdateCheckManager updateCheckManager, Set<MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setUpdateCheckManager(updateCheckManager);
        this.setMetadataGeneratorFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setMetadataGeneratorFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    public DefaultDeployer setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public DefaultDeployer setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultDeployer setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public DefaultDeployer setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultDeployer setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public DefaultDeployer addMetadataGeneratorFactory(MetadataGeneratorFactory factory) {
        this.metadataFactories.add(Objects.requireNonNull(factory, "metadata generator factory cannot be null"));
        return this;
    }

    public DefaultDeployer setMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public DefaultDeployer setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultDeployer setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    @Override
    public DeployResult deploy(RepositorySystemSession session2, DeployRequest request) throws DeploymentException {
        try {
            Utils.checkOffline(session2, this.offlineController, request.getRepository());
        }
        catch (RepositoryOfflineException e2) {
            throw new DeploymentException("Cannot deploy while " + request.getRepository().getId() + " (" + request.getRepository().getUrl() + ") is in offline mode", e2);
        }
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session2, false);){
            DeployResult deployResult = this.deploy(syncContext, session2, request);
            return deployResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private DeployResult deploy(SyncContext syncContext, RepositorySystemSession session2, DeployRequest request) throws DeploymentException {
        RepositoryConnector connector;
        DeployResult result = new DeployResult(request);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        RemoteRepository repository = request.getRepository();
        try {
            connector = this.repositoryConnectorProvider.newRepositoryConnector(session2, repository);
        }
        catch (NoRepositoryConnectorException e2) {
            throw new DeploymentException("Failed to deploy artifacts/metadata: " + e2.getMessage(), e2);
        }
        try {
            List<? extends MetadataGenerator> generators = this.getMetadataGenerators(session2, request);
            FileTransformerManager fileTransformerManager = session2.getFileTransformerManager();
            ArrayList<ArtifactUpload> artifactUploads = new ArrayList<ArtifactUpload>();
            ArrayList<MetadataUpload> metadataUploads = new ArrayList<MetadataUpload>();
            IdentityHashMap processedMetadata = new IdentityHashMap();
            EventCatapult catapult = new EventCatapult(session2, trace, repository, this.repositoryEventDispatcher);
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
            List<Metadata> metadatas = Utils.prepareMetadata(generators, artifacts);
            syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
            for (Metadata metadata : metadatas) {
                this.upload(metadataUploads, session2, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            for (int i = 0; i < artifacts.size(); ++i) {
                void var17_23;
                Artifact artifact = (Artifact)artifacts.get(i);
                for (MetadataGenerator metadataGenerator : generators) {
                    Artifact artifact2 = metadataGenerator.transformArtifact((Artifact)var17_23);
                }
                artifacts.set(i, (Artifact)var17_23);
                Collection<FileTransformer> fileTransformers = fileTransformerManager.getTransformersForArtifact((Artifact)var17_23);
                if (!fileTransformers.isEmpty()) {
                    for (FileTransformer fileTransformer : fileTransformers) {
                        Artifact targetArtifact = fileTransformer.transformArtifact((Artifact)var17_23);
                        ArtifactUpload upload = new ArtifactUpload(targetArtifact, var17_23.getFile(), fileTransformer);
                        upload.setTrace(trace);
                        upload.setListener(new ArtifactUploadListener(catapult, upload));
                        artifactUploads.add(upload);
                    }
                    continue;
                }
                ArtifactUpload artifactUpload = new ArtifactUpload((Artifact)var17_23, var17_23.getFile());
                artifactUpload.setTrace(trace);
                artifactUpload.setListener(new ArtifactUploadListener(catapult, artifactUpload));
                artifactUploads.add(artifactUpload);
            }
            connector.put(artifactUploads, null);
            for (ArtifactUpload artifactUpload : artifactUploads) {
                if (artifactUpload.getException() != null) {
                    throw new DeploymentException("Failed to deploy artifacts: " + artifactUpload.getException().getMessage(), artifactUpload.getException());
                }
                result.addArtifact(artifactUpload.getArtifact());
            }
            metadatas = Utils.finishMetadata(generators, artifacts);
            syncContext.acquire(null, metadatas);
            for (Metadata metadata : metadatas) {
                this.upload(metadataUploads, session2, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            for (Metadata metadata : request.getMetadata()) {
                if (processedMetadata.containsKey(metadata)) continue;
                this.upload(metadataUploads, session2, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            connector.put(null, metadataUploads);
            for (MetadataUpload metadataUpload : metadataUploads) {
                if (metadataUpload.getException() != null) {
                    throw new DeploymentException("Failed to deploy metadata: " + metadataUpload.getException().getMessage(), metadataUpload.getException());
                }
                result.addMetadata(metadataUpload.getMetadata());
            }
        }
        finally {
            connector.close();
        }
        return result;
    }

    private List<? extends MetadataGenerator> getMetadataGenerators(RepositorySystemSession session2, DeployRequest request) {
        PrioritizedComponents<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(session2, this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (PrioritizedComponent<MetadataGeneratorFactory> factory : factories.getEnabled()) {
            MetadataGenerator generator = factory.getComponent().newInstance(session2, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void upload(Collection<MetadataUpload> metadataUploads, RepositorySystemSession session2, Metadata metadata, RemoteRepository repository, RepositoryConnector connector, EventCatapult catapult) throws DeploymentException {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        File basedir = lrm.getRepository().getBasedir();
        File dstFile = new File(basedir, lrm.getPathForRemoteMetadata(metadata, repository, ""));
        if (metadata instanceof MergeableMetadata) {
            if (!((MergeableMetadata)metadata).isMerged()) {
                RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_RESOLVING);
                event2.setTrace(catapult.getTrace());
                event2.setMetadata(metadata);
                event2.setRepository(repository);
                this.repositoryEventDispatcher.dispatch(event2.build());
                event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_DOWNLOADING);
                event2.setTrace(catapult.getTrace());
                event2.setMetadata(metadata);
                event2.setRepository(repository);
                this.repositoryEventDispatcher.dispatch(event2.build());
                RepositoryPolicy policy = this.getPolicy(session2, repository, metadata.getNature());
                MetadataDownload download = new MetadataDownload();
                download.setMetadata(metadata);
                download.setFile(dstFile);
                download.setChecksumPolicy(policy.getChecksumPolicy());
                download.setListener(SafeTransferListener.wrap(session2));
                download.setTrace(catapult.getTrace());
                connector.get(null, Arrays.asList(download));
                MetadataTransferException error = download.getException();
                if (error instanceof MetadataNotFoundException) {
                    dstFile.delete();
                }
                event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_DOWNLOADED);
                event2.setTrace(catapult.getTrace());
                event2.setMetadata(metadata);
                event2.setRepository(repository);
                event2.setException(error);
                event2.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch(event2.build());
                event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_RESOLVED);
                event2.setTrace(catapult.getTrace());
                event2.setMetadata(metadata);
                event2.setRepository(repository);
                event2.setException(error);
                event2.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch(event2.build());
                if (error != null && !(error instanceof MetadataNotFoundException)) {
                    throw new DeploymentException("Failed to retrieve remote metadata " + metadata + ": " + error.getMessage(), error);
                }
            }
            try {
                ((MergeableMetadata)metadata).merge(dstFile, dstFile);
            }
            catch (RepositoryException e2) {
                throw new DeploymentException("Failed to update metadata " + metadata + ": " + e2.getMessage(), e2);
            }
        }
        if (metadata.getFile() == null) {
            throw new DeploymentException("Failed to update metadata " + metadata + ": No file attached.");
        }
        try {
            this.fileProcessor.copy(metadata.getFile(), dstFile);
        }
        catch (IOException e3) {
            throw new DeploymentException("Failed to update metadata " + metadata + ": " + e3.getMessage(), e3);
        }
        UpdateCheck<Metadata, MetadataTransferException> check2 = new UpdateCheck<Metadata, MetadataTransferException>();
        check2.setItem(metadata);
        check2.setFile(dstFile);
        check2.setRepository(repository);
        check2.setAuthoritativeRepository(repository);
        this.updateCheckManager.touchMetadata(session2, check2);
        MetadataUpload upload = new MetadataUpload(metadata, dstFile);
        upload.setTrace(catapult.getTrace());
        upload.setListener(new MetadataUploadListener(catapult, upload));
        metadataUploads.add(upload);
    }

    private RepositoryPolicy getPolicy(RepositorySystemSession session2, RemoteRepository repository, Metadata.Nature nature) {
        boolean releases = !Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session2, repository, releases, snapshots);
    }

    static final class MetadataUploadListener
    extends SafeTransferListener {
        private final EventCatapult catapult;
        private final MetadataUpload transfer;

        MetadataUploadListener(EventCatapult catapult, MetadataUpload transfer) {
            super(catapult.getSession());
            this.catapult = catapult;
            this.transfer = transfer;
        }

        @Override
        public void transferInitiated(TransferEvent event2) throws TransferCancelledException {
            super.transferInitiated(event2);
            this.catapult.metadataDeploying(this.transfer.getMetadata(), this.transfer.getFile());
        }

        @Override
        public void transferFailed(TransferEvent event2) {
            super.transferFailed(event2);
            this.catapult.metadataDeployed(this.transfer.getMetadata(), this.transfer.getFile(), this.transfer.getException());
        }

        @Override
        public void transferSucceeded(TransferEvent event2) {
            super.transferSucceeded(event2);
            this.catapult.metadataDeployed(this.transfer.getMetadata(), this.transfer.getFile(), null);
        }
    }

    static final class ArtifactUploadListener
    extends SafeTransferListener {
        private final EventCatapult catapult;
        private final ArtifactUpload transfer;

        ArtifactUploadListener(EventCatapult catapult, ArtifactUpload transfer) {
            super(catapult.getSession());
            this.catapult = catapult;
            this.transfer = transfer;
        }

        @Override
        public void transferInitiated(TransferEvent event2) throws TransferCancelledException {
            super.transferInitiated(event2);
            this.catapult.artifactDeploying(this.transfer.getArtifact(), this.transfer.getFile());
        }

        @Override
        public void transferFailed(TransferEvent event2) {
            super.transferFailed(event2);
            this.catapult.artifactDeployed(this.transfer.getArtifact(), this.transfer.getFile(), this.transfer.getException());
        }

        @Override
        public void transferSucceeded(TransferEvent event2) {
            super.transferSucceeded(event2);
            this.catapult.artifactDeployed(this.transfer.getArtifact(), this.transfer.getFile(), null);
        }
    }

    static final class EventCatapult {
        private final RepositorySystemSession session;
        private final RequestTrace trace;
        private final RemoteRepository repository;
        private final RepositoryEventDispatcher dispatcher;

        EventCatapult(RepositorySystemSession session2, RequestTrace trace, RemoteRepository repository, RepositoryEventDispatcher dispatcher) {
            this.session = session2;
            this.trace = trace;
            this.repository = repository;
            this.dispatcher = dispatcher;
        }

        public RepositorySystemSession getSession() {
            return this.session;
        }

        public RequestTrace getTrace() {
            return this.trace;
        }

        public void artifactDeploying(Artifact artifact, File file2) {
            RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.ARTIFACT_DEPLOYING);
            event2.setTrace(this.trace);
            event2.setArtifact(artifact);
            event2.setRepository(this.repository);
            event2.setFile(file2);
            this.dispatcher.dispatch(event2.build());
        }

        public void artifactDeployed(Artifact artifact, File file2, ArtifactTransferException exception) {
            RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.ARTIFACT_DEPLOYED);
            event2.setTrace(this.trace);
            event2.setArtifact(artifact);
            event2.setRepository(this.repository);
            event2.setFile(file2);
            event2.setException(exception);
            this.dispatcher.dispatch(event2.build());
        }

        public void metadataDeploying(Metadata metadata, File file2) {
            RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.METADATA_DEPLOYING);
            event2.setTrace(this.trace);
            event2.setMetadata(metadata);
            event2.setRepository(this.repository);
            event2.setFile(file2);
            this.dispatcher.dispatch(event2.build());
        }

        public void metadataDeployed(Metadata metadata, File file2, Exception exception) {
            RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.METADATA_DEPLOYED);
            event2.setTrace(this.trace);
            event2.setMetadata(metadata);
            event2.setRepository(this.repository);
            event2.setFile(file2);
            event2.setException(exception);
            this.dispatcher.dispatch(event2.build());
        }
    }
}

