/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.common.FreeMindTask;
import freemind.common.XmlBindingTools;
import freemind.controller.MenuItemEnabledListener;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.generated.instance.Place;
import freemind.controller.actions.generated.instance.Result;
import freemind.controller.actions.generated.instance.Reversegeocode;
import freemind.controller.actions.generated.instance.Searchresults;
import freemind.extensions.ExportHook;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.common.plugins.MapNodePositionHolderBase;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.EditNodeTextField;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import plugins.map.JCursorMapViewer;
import plugins.map.MapDialog;
import plugins.map.MapMarkerBase;
import plugins.map.MapMarkerLocation;
import plugins.map.MapNodePositionHolder;
import plugins.map.MapSearchMarkerLocation;

public class FreeMindMapController
extends JMapController
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener,
KeyListener {
    private static final int MODIFIERS_WITHOUT_SHIFT = 0x7FFFFFFE;
    private static final String NODE_MAP_HOME_PROPERTY = "node_map_home";
    private static final String MAP_DIALOG_PROGRESS_MESSAGE = "MapDialog.progressMessage";
    private static final String MAP_DIALOG_ADD_PLACES = "MapDialog.addPlaces";
    private static final String XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final int MOUSE_BUTTONS_MASK = 7168;
    private static final int MAC_MOUSE_BUTTON3_MASK = 1152;
    private static final int MAC_MOUSE_BUTTON1_MASK = 1024;
    private static final int SCROLL_MARGIN = 5;
    private static final int SCROLL_PIXEL_AMOUNT = 25;
    private static final String OSM_NOMINATIM_CONNECT_TIMEOUT_IN_MS = "osm_nominatim_connect_timeout_in_ms";
    private static final String OSM_NOMINATIM_READ_TIMEOUT_IN_MS = "osm_nominatim_read_timeout_in_ms";
    private static final int MOVE_PIXEL_AMOUNT = 50;
    private static final float PAGE_DOWN_FACTOR = 0.85f;
    private static final int POSITION_HOLDER_LIMIT = 50;
    private static final long WHEEL_ZOOM_MINIMAL_TIME_BETWEEN_CHANGES = 333L;
    protected static Logger logger = Resources.getInstance().getLogger("plugins.map.FreeMindMapController");
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private final MindMapController mMindMapController;
    private final JDialog mMapDialog;
    private final MapDialog mMapHook;
    private Point lastDragPoint;
    private Point mDragStartingPoint;
    private boolean mMovementEnabled = true;
    private boolean isMoving = false;
    private boolean mClickEnabled = true;
    private int movementMouseButton = 1;
    private int movementMouseButtonMask = 1024;
    private boolean mWheelZoomEnabled = true;
    private JPopupMenu mContextPopupMenu;
    private MapNodePositionHolder mCurrentPopupPositionHolder;
    private boolean isMapNodeMoving = false;
    private MapNodePositionHolder mMapNodeMovingSource = null;
    private Timer mMouseHitsNodeTimer;
    private boolean mIsRectangularSelect;
    private Coordinate mRectangularStart;
    private Vector mPositionHolderVector = new Vector();
    private int mPositionHolderIndex = -1;
    private static TileSourceStore[] sTileSources = new TileSourceStore[]{new TileSourceStore((TileSource)new OsmTileSource.Mapnik(), "M"), new TileSourceStore((TileSource)new OsmTileSource.CycleMap(), "C"), new TileSourceStore((TileSource)new TransportMap(), "T"), new TileSourceStore((TileSource)new MapQuestOpenMap(), "Q")};
    protected final ControllerPopupMenuListener popupListenerSingleton = new ControllerPopupMenuListener();
    private MouseEvent mTimerMouseEvent;
    private Action mZoomInAction;
    private Action mZoomOutAction;
    private MoveForwardAction mMoveForwardAction;
    private MoveBackwardAction mMoveBackwardAction;
    JMenuBar mMenuBar;
    private long mWheelZoomLastTime = 0L;
    private Vector mCursorPositionListeners = new Vector();
    private JPopupMenu mSearchPopupMenu;

    JCursorMapViewer getMap() {
        return (JCursorMapViewer)this.map;
    }

    public void addMapPictureToNode() {
        if (this.mCurrentPopupPositionHolder == null) {
            return;
        }
        FreeMindMapController.addPictureToNode(this.mCurrentPopupPositionHolder, this.mMindMapController);
    }

    public static void addPictureToNode(MapNodePositionHolder positionHolder, MindMapController mindMapController) {
        File tooltipFile = positionHolder.getTooltipFile(true);
        if (!tooltipFile.exists() && !positionHolder.createToolTip(true)) {
            return;
        }
        MindMapNode selected = positionHolder.getNode();
        MindMapNode addNewNode = mindMapController.addNewNode(selected, 0, selected.isLeft());
        mindMapController.setNodeText(addNewNode, positionHolder.getImageHtml());
    }

    public FreeMindMapController(JMapViewer map, MindMapController pMindMapController, JDialog pMapDialog, MapDialog pMapHook) {
        super(map);
        this.mMapHook = pMapHook;
        this.mMindMapController = pMindMapController;
        this.mMapDialog = pMapDialog;
        this.mMouseHitsNodeTimer = new Timer(500, this);
        this.mMouseHitsNodeTimer.setRepeats(false);
        PlaceNodeAction placeAction = new PlaceNodeAction();
        ShowNodeAction showAction = new ShowNodeAction();
        this.mZoomInAction = new ZoomAction(1);
        this.mZoomOutAction = new ZoomAction(-1);
        SetDisplayToFitMapMarkers setDisplayToFitMapMarkers = new SetDisplayToFitMapMarkers();
        ShowMapMarker showMapMarker = new ShowMapMarker();
        TileGridVisible tileGridVisible = new TileGridVisible();
        ZoomControlsVisible zoomControlsVisible = new ZoomControlsVisible();
        SearchControlVisible searchControlVisible = new SearchControlVisible();
        GotoSearch gotoSearch = new GotoSearch();
        HideFoldedNodes hideFoldedNodes = new HideFoldedNodes();
        NewNodeAction newNodeAction = new NewNodeAction();
        MaxmimalZoomToCursorAction maxmimalZoomToCursorAction = new MaxmimalZoomToCursorAction();
        CopyLinkToClipboardAction copyLinkToClipboardAction = new CopyLinkToClipboardAction();
        CopyCoordinatesToClipboardAction copyCoordinatesToClipboardAction = new CopyCoordinatesToClipboardAction();
        ExportMapAction exportAction = new ExportMapAction();
        StructuredMenuHolder menuHolder = new StructuredMenuHolder();
        this.mMenuBar = new JMenuBar();
        JMenu mainItem = new JMenu(this.getText("MapControllerPopupDialog.Actions"));
        menuHolder.addMenu(mainItem, "main/actions/.");
        this.addAccelerator(menuHolder.addAction((Action)placeAction, "main/actions/place"), "keystroke_plugins/map/MapDialog_Place");
        menuHolder.addAction((Action)exportAction, "main/actions/exportPng");
        this.addAccelerator(menuHolder.addAction((Action)pMapHook.getCloseAction(), "main/actions/close"), "keystroke_plugins/map/MapDialog_Close");
        JMenu searchItem = new JMenu(this.getText("MapControllerPopupDialog.Search"));
        menuHolder.addMenu(searchItem, "main/search/.");
        this.addAccelerator(menuHolder.addAction((Action)searchControlVisible, "main/search/showSearchControl"), "keystroke_plugins/map/MapDialog_toggle_search");
        this.addAccelerator(menuHolder.addAction((Action)gotoSearch, "main/search/gotoSearch"), "keystroke_plugins/map/MapDialog_goto_search");
        this.addAccelerator(menuHolder.addAction((Action)new LimitSearchToRegionAction(), "main/search/limitSearchToRegion"), "keystroke_plugins/map/MapDialog_limitSearchToRegion");
        JMenu viewItem = new JMenu(this.getText("MapControllerPopupDialog.Views"));
        menuHolder.addMenu(viewItem, "main/view/.");
        menuHolder.addAction((Action)showAction, "main/view/showNode");
        menuHolder.addAction((Action)setDisplayToFitMapMarkers, "main/view/setDisplayToFitMapMarkers");
        menuHolder.addSeparator("main/view/");
        for (int i = 0; i < sTileSources.length; ++i) {
            TileSource source = FreeMindMapController.sTileSources[i].mTileSource;
            this.addAccelerator(menuHolder.addAction((Action)new ChangeTileSource(source), "main/view/" + i), "keystroke_plugins/map/MapDialog_tileSource_" + i);
        }
        menuHolder.addSeparator("main/view/");
        menuHolder.addAction((Action)showMapMarker, "main/view/showMapMarker");
        menuHolder.addAction((Action)tileGridVisible, "main/view/tileGridVisible");
        menuHolder.addAction((Action)zoomControlsVisible, "main/view/zoomControlsVisible");
        this.addAccelerator(menuHolder.addAction((Action)hideFoldedNodes, "main/view/hideFoldedNodes"), "keystroke_plugins/map/MapDialog_hideFoldedNodes");
        menuHolder.addSeparator("main/view/");
        this.addAccelerator(menuHolder.addAction(this.mZoomInAction, "main/view/ZoomInAction"), "keystroke_plugins/map/MapDialog_zoomIn");
        this.addAccelerator(menuHolder.addAction(this.mZoomOutAction, "main/view/ZoomOutAction"), "keystroke_plugins/map/MapDialog_zoomOut");
        JMenu navigationItem = new JMenu(this.getText("MapControllerPopupDialog.Navigation"));
        menuHolder.addMenu(navigationItem, "main/navigation/.");
        this.addAccelerator(menuHolder.addAction((Action)new SetHomeAction(), "main/navigation/SetHome"), "keystroke_plugins/map/MapDialogSetHome");
        this.addAccelerator(menuHolder.addAction((Action)new MoveHomeAction(), "main/navigation/MoveHome"), "keystroke_plugins/map/MapDialogMoveHome");
        menuHolder.addSeparator("main/navigation/");
        this.mMoveBackwardAction = new MoveBackwardAction();
        this.addAccelerator(menuHolder.addAction((Action)this.mMoveBackwardAction, "main/navigation/moveBackward"), "keystroke_plugins/map/MapDialog_moveBackward");
        this.mMoveForwardAction = new MoveForwardAction();
        this.addAccelerator(menuHolder.addAction((Action)this.mMoveForwardAction, "main/navigation/moveForward"), "keystroke_plugins/map/MapDialog_moveForward");
        menuHolder.addSeparator("main/navigation/");
        this.addAccelerator(menuHolder.addAction((Action)new MoveLeftAction(), "main/navigation/moveLeft"), "keystroke_plugins/map/MapDialog_moveLeft");
        this.addAccelerator(menuHolder.addAction((Action)new MoveRightAction(), "main/navigation/moveRight"), "keystroke_plugins/map/MapDialog_moveRight");
        this.addAccelerator(menuHolder.addAction((Action)new MoveUpAction(), "main/navigation/moveUp"), "keystroke_plugins/map/MapDialog_moveUp");
        this.addAccelerator(menuHolder.addAction((Action)new MoveDownAction(), "main/navigation/moveDown"), "keystroke_plugins/map/MapDialog_moveDown");
        menuHolder.addSeparator("main/navigation/");
        menuHolder.updateMenus(this.mMenuBar, "main/");
        this.mMapDialog.setJMenuBar(this.mMenuBar);
        menuHolder.addAction((Action)newNodeAction, "popup/newNode");
        menuHolder.addAction((Action)placeAction, "popup/place");
        menuHolder.addSeparator("popup/");
        menuHolder.addAction((Action)maxmimalZoomToCursorAction, "popup/maxmimalZoomToCursorAction");
        menuHolder.addSeparator("popup/");
        menuHolder.addAction((Action)copyLinkToClipboardAction, "popup/copyLinkToClipboardAction");
        menuHolder.addAction((Action)copyCoordinatesToClipboardAction, "popup/copyCoordinatesToClipboardAction");
        menuHolder.updateMenus(this.mPopupMenu, "popup/");
        menuHolder.addAction((Action)new EditNodeInContextMenu(), "contextPopup/editNodeInContextMenu");
        menuHolder.addAction((Action)new RemoveNodeLocationInContextMenu(), "contextPopup/RemoveNodeLocationInContextMenu");
        menuHolder.addAction((Action)new SelectNodeInContextMenu(), "contextPopup/SelectNodeInContextMenu");
        menuHolder.addAction((Action)new SelectNodeAndCloseInContextMenu(), "contextPopup/SelectNodeAndCloseInContextMenu");
        menuHolder.addSeparator("contextPopup/");
        menuHolder.addAction((Action)new ShowNodeMapInContextMenu(), "contextPopup/showNodeMapInContextMenu");
        menuHolder.addAction((Action)maxmimalZoomToCursorAction, "contextPopup/maxmimalZoomToCursorAction");
        menuHolder.addSeparator("contextPopup/");
        menuHolder.addAction((Action)copyLinkToClipboardAction, "contextPopup/copyLinkToClipboardAction");
        menuHolder.addAction((Action)new AddMapPictureToNode(), "contextPopup/addPictureToNode");
        menuHolder.updateMenus(this.getContextPopupMenu(), "contextPopup/");
        menuHolder.addAction((Action)maxmimalZoomToCursorAction, "searchPopup/maxmimalZoomToCursorAction");
        menuHolder.updateMenus(this.getSearchPopupMenu(), "searchPopup/");
        this.mMapDialog.addKeyListener(this);
    }

    public void addAccelerator(JMenuItem menuItem, String key) {
        String keyProp = this.mMindMapController.getFrame().getProperty(key);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyProp);
        menuItem.getAction().putValue("AcceleratorKey", keyStroke);
    }

    protected MapNodePositionHolderBase placeNode(MindMapNode pSelected) {
        Coordinate cursorPosition = this.getMap().getCursorPosition();
        Coordinate position = this.map.getPosition();
        int zoom = this.map.getZoom();
        return this.placeNodeAt(pSelected, cursorPosition, position, zoom);
    }

    protected MapNodePositionHolderBase placeNodeAt(MindMapNode pSelected, Coordinate cursorPosition, Coordinate position, int zoom) {
        MapNodePositionHolder hook = MapNodePositionHolder.getHook(pSelected);
        if (hook == null) {
            hook = this.addHookToNode(pSelected);
        }
        if (hook != null) {
            String tileSource = this.getTileSourceAsString();
            hook.changePosition(cursorPosition, position, zoom, tileSource);
        } else {
            logger.warning("Hook not found although it was recently added. Node was " + pSelected);
        }
        return hook;
    }

    public String getTileSourceAsString() {
        String tileSource = FreeMindMapController.getTileSourceName(this.getTileSource());
        return tileSource;
    }

    public TileSource getTileSource() {
        return this.getMap().getTileController().getTileSource();
    }

    public void removeNodePosition(MindMapNode selected) {
        MapNodePositionHolder hook = MapNodePositionHolder.getHook(selected);
        if (hook != null) {
            this.addHookToNode(selected);
        }
    }

    public void showSelectedNodes() {
        int y;
        int x;
        MindMapNode selected = this.mMindMapController.getSelected();
        List selecteds = this.mMindMapController.getSelecteds();
        if (selecteds.size() == 1) {
            MapNodePositionHolder hook = MapNodePositionHolder.getHook(selected);
            if (hook != null) {
                this.showNode(hook);
            }
            return;
        }
        int x_min = Integer.MAX_VALUE;
        int y_min = Integer.MAX_VALUE;
        int x_max = Integer.MIN_VALUE;
        int y_max = Integer.MIN_VALUE;
        int mapZoomMax = this.getMaxZoom();
        for (MindMapNode node : selecteds) {
            MapNodePositionHolder hook = MapNodePositionHolder.getHook(node);
            if (hook == null) continue;
            x = OsmMercator.LonToX((double)hook.getPosition().getLon(), (int)mapZoomMax);
            y = OsmMercator.LatToY((double)hook.getPosition().getLat(), (int)mapZoomMax);
            x_max = Math.max(x_max, x);
            y_max = Math.max(y_max, y);
            x_min = Math.min(x_min, x);
            y_min = Math.min(y_min, y);
            if (node != selected) continue;
            this.setCursorPosition(hook.getPosition());
            FreeMindMapController.changeTileSource(hook.getTileSource(), this.map);
        }
        int height = Math.max(0, this.getMap().getHeight());
        int width = Math.max(0, this.getMap().getWidth());
        int newZoom = mapZoomMax;
        x = x_max - x_min;
        for (y = y_max - y_min; x > width || y > height; x >>= 1, y >>= 1) {
            --newZoom;
        }
        x = x_min + (x_max - x_min) / 2;
        y = y_min + (y_max - y_min) / 2;
        int z = 1 << mapZoomMax - newZoom;
        this.getMap().setDisplayPosition(x /= z, y /= z, newZoom);
    }

    public int getMaxZoom() {
        return this.getTileSource().getMaxZoom();
    }

    public void showNode(MapNodePositionHolder hook) {
        int zoom = hook.getZoom();
        FreeMindMapController.changeTileSource(hook.getTileSource(), this.map);
        this.setCursorPosition(hook, zoom);
    }

    public void setCursorPosition(MapNodePositionHolder hook, int zoom) {
        Coordinate position = hook.getPosition();
        Coordinate mapCenter = hook.getMapCenter();
        this.setZoom(zoom);
        if (mapCenter != null) {
            logger.fine("Set display position to " + mapCenter + " and cursor to " + position + " and zoom " + zoom + " where max zoom is " + this.getMaxZoom());
            this.map.setDisplayPositionByLatLon(mapCenter.getLat(), mapCenter.getLon(), zoom);
        }
        this.setCursorPosition(position);
    }

    protected void setCursorPosition(Coordinate position) {
        this.getMap().setCursorPosition(position);
        if (this.map.getMapPosition(position, true) == null) {
            this.map.setDisplayPositionByLatLon(position.getLat(), position.getLon(), this.map.getZoom());
        }
        this.storeMapPosition(position);
        for (CursorPositionListener listener : this.mCursorPositionListeners) {
            listener.cursorPositionChanged(position);
        }
    }

    protected void setZoom(int zoom) {
        if (zoom > this.getMaxZoom()) {
            zoom = this.getMaxZoom();
        }
        if (zoom == 0) {
            zoom = this.map.getZoom();
        }
        this.map.setZoom(zoom);
    }

    public static TileSource changeTileSource(String pTileSource, JMapViewer pMap) {
        logger.fine("Searching for tile source " + pTileSource);
        TileSourceStore tileSource = FreeMindMapController.getTileSourceByName(pTileSource);
        if (tileSource != null && pMap != null) {
            pMap.setTileSource(tileSource.mTileSource);
            return tileSource.mTileSource;
        }
        return null;
    }

    public static TileSourceStore getTileSourceByName(String sourceName) {
        for (int i = 0; i < sTileSources.length; ++i) {
            TileSourceStore source = sTileSources[i];
            if (!Tools.safeEquals((String)FreeMindMapController.getTileSourceName(source.mTileSource), (String)sourceName)) continue;
            logger.fine("Found  tile source " + source);
            return source;
        }
        return null;
    }

    public static String getTileSourceName(TileSource source) {
        return source.getClass().getName();
    }

    public MapNodePositionHolder addHookToNode(MindMapNode selected) {
        Vector selecteds = Tools.getVectorWithSingleElement((Object)selected);
        this.mMindMapController.addHook(selected, (List)selecteds, "plugins/map/MapNodePositionHolder.properties", null);
        MapNodePositionHolder hook = MapNodePositionHolder.getHook(selected);
        return hook;
    }

    private String getText(String pString) {
        return this.mMindMapController.getText(pString);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.mMovementEnabled || !this.isMoving && !this.isMapNodeMoving && !this.mIsRectangularSelect) {
            return;
        }
        if (this.isMapNodeMoving) {
            this.lastDragPoint = e.getPoint();
            int diffx = 0;
            int diffy = 0;
            if (e.getX() < 5) {
                diffx = -25;
            }
            if (this.map.getWidth() - e.getX() < 5) {
                diffx = 25;
            }
            if (e.getY() < 5) {
                diffy = -25;
            }
            if (this.map.getHeight() - e.getY() < 5) {
                diffy = 25;
            }
            this.map.moveMap(diffx, diffy);
            return;
        }
        if (this.mIsRectangularSelect) {
            this.getMap().setRectangular(this.mRectangularStart, this.getCoordinateFromMouseEvent(e));
            this.getMap().setDrawRectangular(true);
            this.getMap().repaint();
            return;
        }
        if ((e.getModifiersEx() & 0x1C00) == this.movementMouseButtonMask) {
            this.moveMapOnDrag(e);
        }
    }

    public void moveMapOnDrag(MouseEvent e) {
        Point p = e.getPoint();
        if (this.lastDragPoint != null) {
            int diffx = this.lastDragPoint.x - p.x;
            int diffy = this.lastDragPoint.y - p.y;
            this.map.moveMap(diffx, diffy);
        }
        this.lastDragPoint = p;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mClickEnabled) {
            return;
        }
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            this.newNode(e);
            return;
        }
        if (e.getButton() == 1 || Tools.isMacOsX() && e.getModifiersEx() == 1024) {
            this.setCursorPosition(e);
        }
    }

    private void setMouseControl(boolean pEnable) {
        this.setMovementEnabled(pEnable);
        this.setWheelZoomEnabled(pEnable);
        this.setClickEnabled(pEnable);
    }

    private void newNode(MouseEvent pEvent) {
        MindMapNode targetNode = this.mMindMapController.getSelected();
        MindMapNode newNode = this.insertNewNode(targetNode);
        NodeView nodeView = this.mMindMapController.getNodeView(newNode);
        this.mMindMapController.select(nodeView);
        this.mMindMapController.setBlocked(true);
        this.setMouseControl(false);
        Point point = pEvent.getPoint();
        Tools.convertPointToAncestor((Component)((Component)pEvent.getSource()), (Point)point, (Component)this.map);
        this.storeMapPosition(this.getMap().getCursorPosition());
        MapEditTextFieldControl editControl = new MapEditTextFieldControl(nodeView, newNode, targetNode, false);
        MapEditNoteTextField textfield = new MapEditNoteTextField(nodeView, "", null, (ModeController)this.mMindMapController, editControl, (JComponent)this.map, point);
        textfield.show();
    }

    public MindMapNode insertNewNode(MindMapNode targetNode) {
        int childPosition;
        MindMapNode parent;
        if (targetNode.isRoot()) {
            parent = targetNode;
            childPosition = 0;
        } else {
            parent = targetNode.getParentNode();
            childPosition = parent.getChildPosition(targetNode);
            ++childPosition;
        }
        MindMapNode newNode = this.mMindMapController.addNewNode(parent, childPosition, targetNode.isLeft());
        return newNode;
    }

    private void editNode(MapNodePositionHolder pPositionHolder, MouseEvent pEvent) {
        MindMapNode editNode = pPositionHolder.getNode();
        NodeView nodeView = this.mMindMapController.getNodeView(editNode);
        if (nodeView == null) {
            return;
        }
        this.mMindMapController.select(nodeView);
        this.mMindMapController.setBlocked(true);
        this.setMouseControl(false);
        Point point = pEvent.getPoint();
        Tools.convertPointToAncestor((Component)((Component)pEvent.getSource()), (Point)point, (Component)this.map);
        MapEditTextFieldControl editControl = new MapEditTextFieldControl(nodeView, editNode, editNode, true);
        MapEditNoteTextField textfield = new MapEditNoteTextField(nodeView, editNode.getText(), null, (ModeController)this.mMindMapController, editControl, (JComponent)this.map, point);
        textfield.show();
    }

    public void setCursorPosition(MouseEvent e) {
        Coordinate coordinates = this.map.getPosition(e.getPoint());
        this.setCursorPosition(coordinates);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.mClickEnabled) {
            return;
        }
        this.showPopupMenu(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getButton() == this.movementMouseButton || Tools.isMacOsX() && e.getModifiersEx() == 1024) {
            if (e.isShiftDown()) {
                this.mIsRectangularSelect = true;
                this.mRectangularStart = this.getCoordinateFromMouseEvent(e);
                logger.fine("Starting rect on " + this.mRectangularStart);
                return;
            }
            MapMarkerBase mapMarker = this.checkHit(e);
            if (mapMarker instanceof MapMarkerLocation) {
                MapNodePositionHolder posHolder = ((MapMarkerLocation)mapMarker).getNodePositionHolder();
                this.mDragStartingPoint = new Point(e.getPoint());
                this.correctPointByMapCenter(this.mDragStartingPoint);
                this.isMapNodeMoving = true;
                this.mMapNodeMovingSource = posHolder;
                this.setCursor(13, true);
                return;
            }
            this.lastDragPoint = null;
            this.isMoving = true;
        }
    }

    protected void correctPointByMapCenter(Point dragStartingPoint) {
        Point center = this.getMap().getCenter();
        dragStartingPoint.translate(center.x, center.y);
    }

    public MapMarkerBase checkHit(MouseEvent e) {
        for (MapMarkerBase location : this.map.getMapMarkerList()) {
            Coordinate locationC = location.getCoordinate();
            Point locationXY = this.map.getMapPosition(locationC, true);
            if (locationXY == null) continue;
            boolean checkHitResult = location.checkHit(e.getX() - locationXY.x, e.getY() - locationXY.y);
            logger.fine("Checking for hit for location " + location + " at location " + locationXY + " to event " + e.getX() + " and " + e.getY() + " is " + checkHitResult);
            if (!checkHitResult) continue;
            return location;
        }
        return null;
    }

    public Coordinate getCoordinateFromMouseEvent(MouseEvent e) {
        Coordinate mousePosition = this.map.getPosition(new Point(e.getX(), e.getY()));
        return mousePosition;
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popupmenu = this.getPopupMenu();
            MapMarkerBase mapMarker = this.checkHit(e);
            if (mapMarker instanceof MapMarkerLocation) {
                MapNodePositionHolder posHolder;
                this.mCurrentPopupPositionHolder = posHolder = ((MapMarkerLocation)mapMarker).getNodePositionHolder();
                this.setCursorPosition(posHolder.getPosition());
                this.getContextPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
            if (mapMarker instanceof MapSearchMarkerLocation) {
                MapSearchMarkerLocation location = (MapSearchMarkerLocation)mapMarker;
                this.setCursorPosition(location.getCoordinate());
                this.getSearchPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
            this.mCurrentPopupPositionHolder = null;
            if (popupmenu != null) {
                this.setCursorPosition(e);
                popupmenu.show(e.getComponent(), e.getX(), e.getY());
                e.consume();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.mClickEnabled) {
            return;
        }
        this.showPopupMenu(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getButton() == this.movementMouseButton || Tools.isMacOsX() && e.getButton() == 1) {
            Coordinate coordinates = this.getCoordinateFromMouseEvent(e);
            if (this.isMapNodeMoving) {
                Point currentPoint = new Point(e.getPoint());
                this.correctPointByMapCenter(currentPoint);
                if (this.mDragStartingPoint.distance(currentPoint) > 5.0) {
                    Coordinate mousePosition = coordinates;
                    this.mMapNodeMovingSource.changePosition(mousePosition, this.map.getPosition(), this.map.getZoom(), this.getTileSourceAsString());
                } else {
                    MindMapNode node = this.mMapNodeMovingSource.getNode();
                    if (e.isShiftDown()) {
                        Vector<MindMapNode> sel = new Vector<MindMapNode>(this.mMindMapController.getSelecteds());
                        if (sel.contains(node)) {
                            sel.remove(node);
                            node = this.mMindMapController.getSelected();
                        } else {
                            sel.add(node);
                        }
                        this.mMindMapController.select(node, sel);
                    } else {
                        this.selectNode(node);
                    }
                }
                this.mMapNodeMovingSource = null;
                this.setCursor(0, false);
            }
            if (this.mIsRectangularSelect) {
                Vector<MindMapNode> mapNodePositionHolders = new Vector<MindMapNode>();
                Rectangle r = this.getMap().getRectangle(this.mRectangularStart, coordinates);
                if (r != null) {
                    MindMapNode last = null;
                    for (MapNodePositionHolder holder : this.mMapHook.getMapNodePositionHolders()) {
                        Coordinate pointPosition = holder.getPosition();
                        Point mapPosition = this.getMap().getMapPosition(pointPosition, true);
                        if (mapPosition == null || !r.contains(mapPosition)) continue;
                        mapNodePositionHolders.add(holder.getNode());
                        last = holder.getNode();
                    }
                    if (last != null) {
                        this.mMindMapController.select(last, mapNodePositionHolders);
                    }
                }
            }
            this.getMap().setDrawRectangular(false);
            this.mIsRectangularSelect = false;
            this.mRectangularStart = null;
            this.isMapNodeMoving = false;
            if (this.lastDragPoint != null) {
                this.storeMapPosition(coordinates);
            }
            this.lastDragPoint = null;
            this.isMoving = false;
        }
    }

    protected void storeMapPosition(Coordinate coordinates) {
        PositionHolder currentPosition;
        PositionHolder holder = new PositionHolder(coordinates.getLat(), coordinates.getLon(), this.getMap().getZoom());
        Vector positionHolderVector = this.getPositionHolderVector();
        if (this.getPositionHolderIndex() >= 0 && (currentPosition = (PositionHolder)positionHolderVector.get(this.getPositionHolderIndex())).equals(holder)) {
            return;
        }
        while (this.getPositionHolderIndex() < positionHolderVector.size() - 1) {
            positionHolderVector.remove(positionHolderVector.size() - 1);
        }
        logger.fine("Storing position " + holder + " at index " + this.getPositionHolderIndex());
        positionHolderVector.insertElementAt(holder, this.getPositionHolderIndex() + 1);
        this.setPositionHolderIndex(this.getPositionHolderIndex() + 1);
        while (positionHolderVector.size() >= 50 && this.getPositionHolderIndex() > 0) {
            this.setPositionHolderIndex(Math.max(this.getPositionHolderIndex() - 1, 0));
            positionHolderVector.remove(0);
        }
        this.mMoveForwardAction.setEnabled(this.mMoveForwardAction.isEnabled());
        this.mMoveBackwardAction.setEnabled(this.mMoveBackwardAction.isEnabled());
    }

    protected void setCursor(int defaultCursor, boolean pVisible) {
        Component glassPane = this.getGlassPane();
        glassPane.setCursor(Cursor.getPredefinedCursor(defaultCursor));
        glassPane.setVisible(pVisible);
    }

    public Component getGlassPane() {
        return this.map.getRootPane().getGlassPane();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.mWheelZoomEnabled && System.currentTimeMillis() - this.mWheelZoomLastTime >= 333L) {
            int wheelRotation = e.getWheelRotation();
            if (Math.abs(wheelRotation) > 2) {
                wheelRotation = (int)(2.0f * Math.signum(wheelRotation));
            }
            this.map.setZoom(this.map.getZoom() - wheelRotation, e.getPoint());
            this.mWheelZoomLastTime = System.currentTimeMillis();
        }
    }

    public boolean isMovementEnabled() {
        return this.mMovementEnabled;
    }

    public void setMovementEnabled(boolean movementEnabled) {
        this.mMovementEnabled = movementEnabled;
    }

    public int getMovementMouseButton() {
        return this.movementMouseButton;
    }

    public JPopupMenu getPopupMenu() {
        return this.mPopupMenu;
    }

    public JPopupMenu getContextPopupMenu() {
        if (this.mContextPopupMenu == null) {
            this.mContextPopupMenu = new JPopupMenu();
            this.mContextPopupMenu.addPopupMenuListener(this.popupListenerSingleton);
        }
        return this.mContextPopupMenu;
    }

    public JPopupMenu getSearchPopupMenu() {
        if (this.mSearchPopupMenu == null) {
            this.mSearchPopupMenu = new JPopupMenu();
            this.mSearchPopupMenu.addPopupMenuListener(this.popupListenerSingleton);
        }
        return this.mSearchPopupMenu;
    }

    public void setMovementMouseButton(int movementMouseButton) {
        this.movementMouseButton = movementMouseButton;
        switch (movementMouseButton) {
            case 1: {
                this.movementMouseButtonMask = 1024;
                break;
            }
            case 2: {
                this.movementMouseButtonMask = 2048;
                break;
            }
            case 3: {
                this.movementMouseButtonMask = 4096;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported button");
            }
        }
    }

    public boolean isWheelZoomEnabled() {
        return this.mWheelZoomEnabled;
    }

    public void setWheelZoomEnabled(boolean wheelZoomEnabled) {
        this.mWheelZoomEnabled = wheelZoomEnabled;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.mMovementEnabled) {
            return;
        }
        if (Tools.isMacOsX()) {
            if (this.isMapNodeMoving) {
                this.lastDragPoint = e.getPoint();
                return;
            }
            if (this.isMoving && e.getModifiersEx() == 0) {
                this.moveMapOnDrag(e);
                return;
            }
        }
        this.mMouseHitsNodeTimer.restart();
        this.mTimerMouseEvent = e;
    }

    public void setCursorPosition(Place pPlace) {
        this.map.setDisplayPositionByLatLon(pPlace.getLat(), pPlace.getLon(), this.map.getZoom());
        Coordinate cursorPosition = new Coordinate(pPlace.getLat(), pPlace.getLon());
        this.setCursorPosition(cursorPosition);
    }

    public boolean search(MapDialog.ResultTableModel dataModel, JTable mResultTable, String mSearchText, Color mTableOriginalBackgroundColor) {
        boolean returnValue = true;
        this.setCursor(3, true);
        try {
            dataModel.clear();
            mResultTable.setBackground(Color.GRAY);
            Searchresults results = this.getSearchResults(mSearchText);
            if (results == null) {
                mResultTable.setBackground(Color.RED);
            } else {
                for (Place place : results.getListPlaceList()) {
                    logger.fine("Found place " + place.getDisplayName());
                    if (Tools.safeEquals((String)"ERROR", (String)place.getOsmType())) {
                        mResultTable.setBackground(Color.RED);
                        returnValue = false;
                    } else if (Tools.safeEquals((String)"WARNING", (String)place.getOsmType())) {
                        mResultTable.setBackground(Color.YELLOW);
                        returnValue = false;
                    } else {
                        mResultTable.setBackground(Color.WHITE);
                        mResultTable.setBackground(mTableOriginalBackgroundColor);
                    }
                    dataModel.addPlace(place);
                }
            }
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            returnValue = false;
        }
        this.setCursor(0, false);
        return returnValue;
    }

    public Reversegeocode getReverseLookup(Coordinate pCoordinate, int pZoom) {
        StringBuilder b = new StringBuilder();
        b.append("http://nominatim.openstreetmap.org/reverse?format=xml&email=christianfoltin%40users.sourceforge.net&addressdetails=0");
        b.append("&accept-language=").append(Locale.getDefault().getLanguage());
        b.append("&lat=");
        b.append(pCoordinate.getLat());
        b.append("&lon=");
        b.append(pCoordinate.getLon());
        b.append("&zoom=");
        b.append(pZoom);
        try {
            String result = this.wget(b);
            Reversegeocode reversegeocode = (Reversegeocode)XmlBindingTools.getInstance().unMarshall(result);
            return reversegeocode;
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            return null;
        }
    }

    public Searchresults getSearchResults(String pText) {
        String result = "unknown";
        Searchresults results = new Searchresults();
        StringBuilder b = new StringBuilder();
        boolean limitSearchToRegion = this.mMapHook.isLimitSearchToRegion();
        try {
            b.append("http://nominatim.openstreetmap.org/search/?email=christianfoltin%40users.sourceforge.net&q=");
            b.append(URLEncoder.encode(pText, "UTF-8"));
            b.append("&format=xml&limit=30&accept-language=").append(Locale.getDefault().getLanguage());
            if (limitSearchToRegion) {
                Coordinate topLeftCorner = this.getMap().getPosition(0, 0);
                Coordinate bottomRightCorner = this.getMap().getPosition(this.getMap().getWidth(), this.getMap().getHeight());
                b.append("&viewbox=");
                b.append(topLeftCorner.getLon());
                b.append(",");
                b.append(topLeftCorner.getLat());
                b.append(",");
                b.append(bottomRightCorner.getLon());
                b.append(",");
                b.append(bottomRightCorner.getLat());
                b.append("&bounded=1");
            }
            result = this.wget(b);
            results = (Searchresults)XmlBindingTools.getInstance().unMarshall(result);
            if (results == null) {
                logger.warning(result + " can't be parsed");
            }
        }
        catch (Exception e) {
            logger.fine("Searching for " + b.toString() + " gave an error");
            String errorString = e.toString();
            Resources.getInstance().logException((Throwable)e);
            logger.warning("Result was " + result);
            results.addPlace(this.getErrorPlace(errorString, "ERROR"));
        }
        if (results.getListPlaceList().isEmpty()) {
            String textId = limitSearchToRegion ? "plugins.map.FreeMindMapController.LimitedSearchWithoutResult" : "plugins.map.FreeMindMapController.SearchWithoutResult";
            Object[] messageArguments = new Object[]{pText};
            MessageFormat formatter = new MessageFormat(this.mMindMapController.getText(textId));
            String message = formatter.format(messageArguments);
            results.addPlace(this.getErrorPlace(message, "WARNING"));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String wget(StringBuilder b) throws MalformedURLException, IOException, UnsupportedEncodingException {
        String result;
        this.mMindMapController.getFrame().setWaitingCursor(true);
        try {
            logger.fine("Searching for " + b.toString());
            URL url = new URL(b.toString());
            URLConnection urlConnection = url.openConnection();
            if (Tools.isAboveJava4()) {
                urlConnection.setConnectTimeout(Resources.getInstance().getIntProperty(OSM_NOMINATIM_CONNECT_TIMEOUT_IN_MS, 10000));
                urlConnection.setReadTimeout(Resources.getInstance().getIntProperty(OSM_NOMINATIM_READ_TIMEOUT_IN_MS, 30000));
            }
            InputStream urlStream = urlConnection.getInputStream();
            result = Tools.getFile((Reader)new InputStreamReader(urlStream));
            result = new String(result.getBytes(), "UTF-8");
            logger.fine(result + " was received for search " + b);
        }
        finally {
            this.mMindMapController.getFrame().setWaitingCursor(false);
        }
        return result;
    }

    protected Place getErrorPlace(String errorString, String errorLevel) {
        Place place = new Place();
        place.setDisplayName(errorString);
        place.setOsmType(errorLevel);
        Coordinate cursorPosition = this.getMap().getCursorPosition();
        place.setLat(cursorPosition.getLat());
        place.setLon(cursorPosition.getLon());
        return place;
    }

    public boolean isClickEnabled() {
        return this.mClickEnabled;
    }

    public void setClickEnabled(boolean pClickEnabled) {
        this.mClickEnabled = pClickEnabled;
    }

    public static TileSourceStore[] getmTileSources() {
        return sTileSources;
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        String statusText = "";
        MapMarkerBase mapMarker = this.checkHit(this.mTimerMouseEvent);
        if (mapMarker instanceof MapMarkerLocation) {
            MapNodePositionHolder posHolder = ((MapMarkerLocation)mapMarker).getNodePositionHolder();
            logger.fine("Looking for hit on node " + (Object)((Object)posHolder));
            if (posHolder != null) {
                statusText = Tools.getNodeTextHierarchy((MindMapNode)posHolder.getNode(), (MindMapController)this.mMapHook.getMindMapController()) + ". ";
            }
        }
        Coordinate coordinate = this.getCoordinateFromMouseEvent(this.mTimerMouseEvent);
        Coordinate cursorPosition = this.getMap().getCursorPosition();
        double distance = OsmMercator.getDistance((double)coordinate.getLat(), (double)coordinate.getLon(), (double)cursorPosition.getLat(), (double)cursorPosition.getLon()) / 1000.0;
        Object[] messageArguments = new Object[]{new Double(distance), new Double(coordinate.getLat()), new Double(coordinate.getLon())};
        MessageFormat formatter = new MessageFormat(this.mMindMapController.getText("plugins/map/MapDialog_Distance"));
        String message = formatter.format(messageArguments);
        statusText = statusText + message;
        this.mMapHook.getStatusLabel().setText(statusText);
    }

    protected void selectContextMenuNode() {
        MindMapNode node = this.mCurrentPopupPositionHolder.getNode();
        this.selectNode(node);
    }

    protected void selectNode(MindMapNode node) {
        this.mMindMapController.select(node, (List)Tools.getVectorWithSingleElement((Object)node));
    }

    public static String getLink(MapNodePositionHolder hook) {
        String tileSource = hook.getTileSource();
        Coordinate position = hook.getPosition();
        Coordinate mapCenter = hook.getMapCenter();
        int zoom = hook.getZoom();
        return FreeMindMapController.getLink(tileSource, position, mapCenter, zoom);
    }

    public static String getLink(String tileSource, Coordinate position, Coordinate mapCenter, int zoom) {
        String layer = "M";
        TileSourceStore tileSourceByName = FreeMindMapController.getTileSourceByName(tileSource);
        if (tileSourceByName != null) {
            layer = tileSourceByName.mLayerName;
        }
        String link = "http://www.openstreetmap.org/?mlat=" + position.getLat() + "&mlon=" + position.getLon() + "&lat=" + mapCenter.getLat() + "&lon=" + mapCenter.getLon() + "&zoom=" + zoom + "&layers=" + layer;
        return link;
    }

    @Override
    public void keyTyped(KeyEvent pEvent) {
        if (this.mMapHook.isSearchBarVisible()) {
            return;
        }
        Action[] specialKeyActions = new Action[]{this.mZoomInAction, this.mZoomOutAction};
        Tools.invokeActionsToKeyboardLayoutDependantCharacters((KeyEvent)pEvent, (Action[])specialKeyActions, (Object)this.mMapDialog);
        if (!pEvent.isConsumed() && !pEvent.isActionKey() && Character.isLetter(pEvent.getKeyChar()) && (pEvent.getModifiers() & 0x7FFFFFFE) == 0) {
            this.mMapHook.toggleSearchBar(pEvent);
            this.mMapHook.setSingleSearch();
        }
    }

    @Override
    public void keyReleased(KeyEvent pEvent) {
    }

    @Override
    public void keyPressed(KeyEvent pEvent) {
        if (this.mMapHook.isSearchBarVisible()) {
            return;
        }
        int modifiers = pEvent.getModifiers() & 0x7FFFFFFE;
        if (modifiers == 0) {
            int dx = 50;
            int dy = 50;
            if (pEvent.isShiftDown()) {
                dx = (int)((float)this.map.getWidth() * 0.85f);
                dy = (int)((float)this.map.getHeight() * 0.85f);
            }
            switch (pEvent.getKeyCode()) {
                case 37: {
                    this.map.moveMap(-dx, 0);
                    pEvent.consume();
                    break;
                }
                case 39: {
                    this.map.moveMap(dx, 0);
                    pEvent.consume();
                    break;
                }
                case 38: {
                    this.map.moveMap(0, -dy);
                    pEvent.consume();
                    break;
                }
                case 40: {
                    this.map.moveMap(0, dy);
                    pEvent.consume();
                }
            }
        }
    }

    public Vector getPositionHolderVector() {
        return this.mPositionHolderVector;
    }

    public int getPositionHolderIndex() {
        return this.mPositionHolderIndex;
    }

    public boolean checkPositionHolderIndex(int positionHolderIndex) {
        return positionHolderIndex >= -1 && positionHolderIndex < this.mPositionHolderVector.size();
    }

    public void setPositionHolderIndex(int positionHolderIndex) {
        if (!this.checkPositionHolderIndex(positionHolderIndex)) {
            throw new IllegalArgumentException("Index out of range " + positionHolderIndex);
        }
        this.mPositionHolderIndex = positionHolderIndex;
    }

    public void addCursorPositionListener(CursorPositionListener pListener) {
        this.mCursorPositionListeners.add(pListener);
    }

    public void addNode(MindMapNode pSelected, Place pPlace) {
        this.addNode(pSelected, pPlace.getDisplayName(), pPlace.getLat(), pPlace.getLon());
    }

    public void addNode(MindMapNode pSelected, String pText, double lat, double lon) {
        MindMapNode targetNode = pSelected;
        MindMapNode newNode = this.insertNewNode(targetNode);
        this.mMindMapController.setNodeText(newNode, pText);
        this.placeNodeAt(newNode, new Coordinate(lat, lon), this.map.getPosition(), this.map.getZoom());
    }

    public void addSearchResultsToMap(int[] pSelectedRows) {
        AddSearchResultsToMapTask task = new AddSearchResultsToMapTask(pSelectedRows);
        task.start();
    }

    private ModeController getMindMapController() {
        return this.mMindMapController;
    }

    private class AddSearchResultsToMapTask
    extends FreeMindTask {
        private Place[] mPlaces;

        public AddSearchResultsToMapTask(int[] pSelectedRows) {
            super((RootPaneContainer)FreeMindMapController.this.mMapDialog, pSelectedRows.length, FreeMindMapController.MAP_DIALOG_PROGRESS_MESSAGE);
            this.mPlaces = new Place[pSelectedRows.length];
            for (int i = 0; i < pSelectedRows.length; ++i) {
                this.mPlaces[i] = FreeMindMapController.this.mMapHook.getPlace(pSelectedRows[i]);
            }
        }

        protected boolean processAction() throws Exception {
            int selIndex = this.getRounds();
            final Place place = this.mPlaces[selIndex];
            this.mProgressDescription = new FreeMindTask.ProgressDescription((FreeMindTask)this, FreeMindMapController.MAP_DIALOG_ADD_PLACES, new Object[]{place.getDisplayName()});
            final MindMapNode selected = FreeMindMapController.this.getMindMapController().getSelected();
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FreeMindMapController.this.addNode(selected, place);
                }
            });
            return true;
        }
    }

    private class ControllerPopupMenuListener
    implements PopupMenuListener {
        private ControllerPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            FreeMindMapController.this.setMouseControl(false);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            FreeMindMapController.this.setMouseControl(true);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            FreeMindMapController.this.setMouseControl(true);
        }
    }

    private final class ExportMapAction
    extends AbstractAction {
        public ExportMapAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.ExportMapMenu"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            File chosenFile = ExportHook.chooseImageFile((String)"png", (String)FreeMindMapController.this.getText("Portable_Network_Graphic"), null, (ModeController)FreeMindMapController.this.mMindMapController);
            if (chosenFile == null) {
                return;
            }
            boolean zoomContolsVisible = FreeMindMapController.this.map.getZoomContolsVisible();
            try {
                FreeMindMapController.this.mMindMapController.getFrame().setWaitingCursor(true);
                FreeMindMapController.this.map.setZoomContolsVisible(false);
                BufferedImage myImage = (BufferedImage)FreeMindMapController.this.map.createImage(FreeMindMapController.this.map.getWidth(), FreeMindMapController.this.map.getHeight());
                FreeMindMapController.this.map.print(myImage.getGraphics());
                FileOutputStream out = new FileOutputStream(chosenFile);
                ImageIO.write((RenderedImage)myImage, "png", out);
                out.close();
            }
            catch (IOException e1) {
                Resources.getInstance().logException((Throwable)e1);
            }
            FreeMindMapController.this.map.setZoomContolsVisible(zoomContolsVisible);
            FreeMindMapController.this.mMindMapController.getFrame().setWaitingCursor(false);
        }
    }

    private final class RemoveNodeLocationInContextMenu
    extends AbstractAction {
        public RemoveNodeLocationInContextMenu() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.RemoveNodeLocationInContextMenu"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (FreeMindMapController.this.mCurrentPopupPositionHolder != null) {
                MindMapNode node = FreeMindMapController.this.mCurrentPopupPositionHolder.getNode();
                FreeMindMapController.this.removeNodePosition(node);
            }
        }
    }

    private final class SelectNodeAndCloseInContextMenu
    extends AbstractAction {
        public SelectNodeAndCloseInContextMenu() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.SelectNodeAndCloseInContextMenu"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (FreeMindMapController.this.mCurrentPopupPositionHolder != null) {
                FreeMindMapController.this.selectContextMenuNode();
                FreeMindMapController.this.mMapHook.disposeDialog();
            }
        }
    }

    private final class SelectNodeInContextMenu
    extends AbstractAction {
        public SelectNodeInContextMenu() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.SelectNodeInContextMenu"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (FreeMindMapController.this.mCurrentPopupPositionHolder != null) {
                FreeMindMapController.this.selectContextMenuNode();
            }
        }
    }

    private final class ShowNodeMapInContextMenu
    extends AbstractAction {
        public ShowNodeMapInContextMenu() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.ShowNodeMapInContextMenu"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (FreeMindMapController.this.mCurrentPopupPositionHolder != null) {
                FreeMindMapController.this.showNode(FreeMindMapController.this.mCurrentPopupPositionHolder);
            }
        }
    }

    private final class CopyCoordinatesToClipboardAction
    extends AbstractAction {
        public CopyCoordinatesToClipboardAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.CopyCoordinatesToClipboardAction"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            String coordinates = FreeMindMapController.this.mCurrentPopupPositionHolder != null ? this.getCoordinates(FreeMindMapController.this.mCurrentPopupPositionHolder.getPosition()) : this.getCoordinates(FreeMindMapController.this.getMap().getCursorPosition());
            Tools.getClipboard().setContents(new StringSelection(coordinates), null);
        }

        private String getCoordinates(Coordinate pCoordinate) {
            return pCoordinate.getLat() + " " + pCoordinate.getLon();
        }
    }

    private final class CopyLinkToClipboardAction
    extends AbstractAction {
        public CopyLinkToClipboardAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.CopyLinkToClipboardAction"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            String link;
            if (FreeMindMapController.this.mCurrentPopupPositionHolder != null) {
                link = FreeMindMapController.getLink(FreeMindMapController.this.mCurrentPopupPositionHolder);
            } else {
                Coordinate cursorPosition = FreeMindMapController.this.getMap().getCursorPosition();
                Coordinate position = FreeMindMapController.this.getMap().getPosition();
                int zoom = FreeMindMapController.this.getMap().getZoom();
                link = FreeMindMapController.getLink(FreeMindMapController.this.getTileSourceAsString(), cursorPosition, position, zoom);
            }
            Tools.getClipboard().setContents(new StringSelection(link), null);
        }
    }

    private final class ZoomAction
    extends AbstractAction {
        private final int mZoomDelta;

        public ZoomAction(int pZoomDelta) {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.ZoomAction" + pZoomDelta));
            this.mZoomDelta = pZoomDelta;
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            Coordinate mapCenter = FreeMindMapController.this.getMap().getPosition();
            int zoom = FreeMindMapController.this.getMap().getZoom() + this.mZoomDelta;
            if (zoom < 0) {
                zoom = 0;
            }
            if (zoom > FreeMindMapController.this.getMaxZoom()) {
                zoom = FreeMindMapController.this.getMaxZoom();
            }
            FreeMindMapController.this.map.setDisplayPositionByLatLon(mapCenter.getLat(), mapCenter.getLon(), zoom);
        }
    }

    private final class MaxmimalZoomToCursorAction
    extends AbstractAction {
        private static final int CURSOR_MAXIMAL_ZOOM_HANDBREAK = 2;

        public MaxmimalZoomToCursorAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.MaxmimalZoomToCursorAction"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            Coordinate cursorPosition = FreeMindMapController.this.getMap().getCursorPosition();
            int zoom = FreeMindMapController.this.getMaxZoom() - 2;
            if (FreeMindMapController.this.getMap().getZoom() >= zoom) {
                zoom += 2;
            }
            FreeMindMapController.this.map.setDisplayPositionByLatLon(cursorPosition.getLat(), cursorPosition.getLon(), zoom);
        }
    }

    private final class EditNodeInContextMenu
    extends AbstractAction {
        public EditNodeInContextMenu() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.EditNodeInContextMenu"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (FreeMindMapController.this.mCurrentPopupPositionHolder == null) {
                return;
            }
            FreeMindMapController.this.setCursorPosition(FreeMindMapController.this.mCurrentPopupPositionHolder.getPosition());
            Point pos = FreeMindMapController.this.getMap().getMapPosition(FreeMindMapController.this.mCurrentPopupPositionHolder.getPosition(), true);
            MindMapNode node = FreeMindMapController.this.mCurrentPopupPositionHolder.getNode();
            while (!node.isRoot()) {
                if (node.isFolded()) {
                    FreeMindMapController.this.mMindMapController.setFolded(node, false);
                }
                node = node.getParentNode();
            }
            pos = MapMarkerLocation.adjustToTextfieldLocation(pos);
            MouseEvent e = new MouseEvent((Component)FreeMindMapController.this.map, 0, 0L, 0, pos.x, pos.y, 1, false);
            FreeMindMapController.this.editNode(FreeMindMapController.this.mCurrentPopupPositionHolder, e);
        }
    }

    private final class NewNodeReverseLookupAction
    extends AbstractAction {
        public NewNodeReverseLookupAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.NewNodeReverseLookupAction"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            Coordinate pos = FreeMindMapController.this.getMap().getCursorPosition();
            Reversegeocode reverseLookup = FreeMindMapController.this.getReverseLookup(pos, FreeMindMapController.this.getMap().getZoom());
            if (reverseLookup != null) {
                for (Result result : reverseLookup.getListResultList()) {
                    FreeMindMapController.this.addNode(FreeMindMapController.this.mMindMapController.getSelected(), result.getContent(), result.getLat(), result.getLon());
                }
            }
        }
    }

    private final class NewNodeAction
    extends AbstractAction {
        public NewNodeAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.NewNodeAction"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            Point pos = FreeMindMapController.this.getMap().getMapPosition(FreeMindMapController.this.getMap().getCursorPosition(), true);
            MouseEvent e = new MouseEvent((Component)FreeMindMapController.this.map, 0, 0L, 0, pos.x, pos.y, 1, false);
            FreeMindMapController.this.newNode(e);
        }
    }

    private final class AddMapPictureToNode
    extends AbstractAction {
        public AddMapPictureToNode() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.AddMapPictureToNode"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.addMapPictureToNode();
        }
    }

    private final class GotoSearch
    extends AbstractAction {
        public GotoSearch() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.GotoSearch"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (!FreeMindMapController.this.mMapHook.isSearchBarVisible()) {
                FreeMindMapController.this.mMapHook.toggleSearchBar();
            } else {
                FreeMindMapController.this.mMapHook.focusSearchTerm();
            }
        }
    }

    private final class LimitSearchToRegionAction
    extends AbstractAction
    implements MenuItemSelectedListener {
        public LimitSearchToRegionAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.LimitSearchToRegionAction"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.mMapHook.toggleLimitSearchToRegion();
            FreeMindMapController.this.mMapHook.focusSearchTerm();
        }

        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return FreeMindMapController.this.mMapHook.isLimitSearchToRegion();
        }
    }

    private final class SearchControlVisible
    extends AbstractAction
    implements MenuItemSelectedListener {
        public SearchControlVisible() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.SearchControlVisible"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.mMapHook.toggleSearchBar();
        }

        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return FreeMindMapController.this.mMapHook.isSearchBarVisible();
        }
    }

    private final class HideFoldedNodes
    extends AbstractAction
    implements MenuItemSelectedListener {
        public HideFoldedNodes() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.HideFoldedNodes"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.getMap().setHideFoldedNodes(!FreeMindMapController.this.getMap().isHideFoldedNodes());
            FreeMindMapController.this.mMapHook.addMarkersToMap();
        }

        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return FreeMindMapController.this.getMap().isHideFoldedNodes();
        }
    }

    private final class ZoomControlsVisible
    extends AbstractAction
    implements MenuItemSelectedListener {
        public ZoomControlsVisible() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.ZoomControlsVisible"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.map.setZoomContolsVisible(!FreeMindMapController.this.map.getZoomContolsVisible());
        }

        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return FreeMindMapController.this.map.getZoomContolsVisible();
        }
    }

    private final class TileGridVisible
    extends AbstractAction
    implements MenuItemSelectedListener {
        public TileGridVisible() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.TileGridVisible"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.map.setTileGridVisible(!FreeMindMapController.this.map.isTileGridVisible());
        }

        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return FreeMindMapController.this.map.isTileGridVisible();
        }
    }

    private final class ShowMapMarker
    extends AbstractAction
    implements MenuItemSelectedListener {
        public ShowMapMarker() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.ShowMapMarker"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.map.setMapMarkerVisible(!FreeMindMapController.this.map.getMapMarkersVisible());
        }

        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return FreeMindMapController.this.map.getMapMarkersVisible();
        }
    }

    private final class SetDisplayToFitMapMarkers
    extends AbstractAction {
        public SetDisplayToFitMapMarkers() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.SetDisplayToFitMapMarkers"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.map.setDisplayToFitMapMarkers();
        }
    }

    private final class SetHomeAction
    extends AbstractAction {
        public SetHomeAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.SetHome"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            Coordinate cursorPosition = FreeMindMapController.this.getMap().getCursorPosition();
            String propertyValue = cursorPosition.getLat() + ":" + cursorPosition.getLon() + ":" + FreeMindMapController.this.map.getZoom();
            FreeMindMapController.this.mMindMapController.getController().setProperty(FreeMindMapController.NODE_MAP_HOME_PROPERTY, propertyValue);
        }
    }

    private final class MoveHomeAction
    extends AbstractAction
    implements MenuItemEnabledListener {
        public MoveHomeAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.MoveHome"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            PositionHolder posHolder = this.getPosHolder();
            if (posHolder == null) {
                return;
            }
            FreeMindMapController.this.setZoom(posHolder.zoom);
            Coordinate coordinates = posHolder.getCoordinate();
            FreeMindMapController.this.setCursorPosition(coordinates);
        }

        public PositionHolder getPosHolder() {
            try {
                String homeProperty = Resources.getInstance().getProperty(FreeMindMapController.NODE_MAP_HOME_PROPERTY);
                if (homeProperty == null || homeProperty.isEmpty()) {
                    return null;
                }
                String[] splitResult = homeProperty.split(":");
                if (splitResult.length != 3) {
                    return null;
                }
                double lat = Double.parseDouble(splitResult[0]);
                double lon = Double.parseDouble(splitResult[1]);
                int zoom = Integer.parseInt(splitResult[2]);
                return new PositionHolder(lat, lon, zoom);
            }
            catch (Exception e) {
                Resources.getInstance().logException((Throwable)e);
                return null;
            }
        }

        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            return this.getPosHolder() != null;
        }
    }

    public static final class PositionHolder {
        double lat;
        double lon;
        int zoom;

        public PositionHolder(double pLat, double pLon, int pZoom) {
            this.lat = pLat;
            this.lon = pLon;
            this.zoom = pZoom;
        }

        public String toString() {
            return "PositionHolder [lat=" + this.lat + ", lon=" + this.lon + ", zoom=" + this.zoom + "]";
        }

        public Coordinate getCoordinate() {
            return new Coordinate(this.lat, this.lon);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.lat);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.lon);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.zoom;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PositionHolder other = (PositionHolder)obj;
            if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
                return false;
            }
            if (Double.doubleToLongBits(this.lon) != Double.doubleToLongBits(other.lon)) {
                return false;
            }
            return this.zoom == other.zoom;
        }
    }

    private final class MoveBackwardAction
    extends AbstractAction
    implements MenuItemEnabledListener {
        public MoveBackwardAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.moveBackward"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (this.isEnabledCheck()) {
                PositionHolder posHolder = (PositionHolder)FreeMindMapController.this.getPositionHolderVector().get(FreeMindMapController.this.getPositionHolderIndex() - 1);
                FreeMindMapController.this.getMap().setCursorPosition(posHolder.getCoordinate());
                FreeMindMapController.this.map.setDisplayPositionByLatLon(posHolder.lat, posHolder.lon, posHolder.zoom);
                FreeMindMapController.this.setPositionHolderIndex(FreeMindMapController.this.getPositionHolderIndex() - 1);
            }
        }

        protected boolean isEnabledCheck() {
            return FreeMindMapController.this.getPositionHolderIndex() > 0;
        }

        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            return this.isEnabledCheck();
        }
    }

    private final class MoveForwardAction
    extends AbstractAction
    implements MenuItemEnabledListener {
        public MoveForwardAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.moveForward"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (this.isEnabledCheck()) {
                PositionHolder posHolder = (PositionHolder)FreeMindMapController.this.getPositionHolderVector().get(FreeMindMapController.this.getPositionHolderIndex() + 1);
                FreeMindMapController.this.getMap().setCursorPosition(posHolder.getCoordinate());
                FreeMindMapController.this.map.setDisplayPositionByLatLon(posHolder.lat, posHolder.lon, posHolder.zoom);
                FreeMindMapController.this.setPositionHolderIndex(FreeMindMapController.this.getPositionHolderIndex() + 1);
            }
        }

        protected boolean isEnabledCheck() {
            return FreeMindMapController.this.getPositionHolderIndex() >= 0 && FreeMindMapController.this.getPositionHolderIndex() < FreeMindMapController.this.getPositionHolderVector().size() - 1;
        }

        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            return this.isEnabledCheck();
        }
    }

    private final class MoveDownAction
    extends MoveAction {
        public MoveDownAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.moveDown"));
        }

        @Override
        public boolean destinationQuadrantCheck(int x1, int y1, int x2, int y2, boolean alternative) {
            if (alternative) {
                return y2 > y1;
            }
            return y2 > y1 && Math.abs(y2 - y1) > Math.abs(x2 - x1);
        }
    }

    private final class MoveUpAction
    extends MoveAction {
        public MoveUpAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.moveUp"));
        }

        @Override
        public boolean destinationQuadrantCheck(int x1, int y1, int x2, int y2, boolean alternative) {
            if (alternative) {
                return y2 < y1;
            }
            return y2 < y1 && Math.abs(y2 - y1) > Math.abs(x2 - x1);
        }
    }

    private final class MoveRightAction
    extends MoveAction {
        public MoveRightAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.moveRight"));
        }

        @Override
        public boolean destinationQuadrantCheck(int x1, int y1, int x2, int y2, boolean alternative) {
            if (alternative) {
                return x2 > x1;
            }
            return x2 > x1 && Math.abs(y2 - y1) < Math.abs(x2 - x1);
        }
    }

    private final class MoveLeftAction
    extends MoveAction {
        public MoveLeftAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.moveLeft"));
        }

        @Override
        public boolean destinationQuadrantCheck(int x1, int y1, int x2, int y2, boolean alternative) {
            if (alternative) {
                return x2 < x1;
            }
            return x2 < x1 && Math.abs(y2 - y1) < Math.abs(x2 - x1);
        }
    }

    private abstract class MoveAction
    extends AbstractAction {
        public MoveAction(String pText) {
            super(pText);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.searchForNearestNode(false)) {
                this.searchForNearestNode(true);
            }
        }

        protected boolean searchForNearestNode(boolean alternative) {
            boolean returnValue = false;
            Coordinate cursorPosition = FreeMindMapController.this.getMap().getCursorPosition();
            HashSet mapNodePositionHolders = new HashSet(FreeMindMapController.this.mMapHook.getMapNodePositionHolders());
            logger.fine("Before removal " + mapNodePositionHolders.size() + " elements");
            Iterator it = mapNodePositionHolders.iterator();
            while (it.hasNext()) {
                MapNodePositionHolder holder = (MapNodePositionHolder)((Object)it.next());
                Coordinate pointPosition = holder.getPosition();
                boolean inDestinationQuadrant = this.destinationQuadrantCheck(cursorPosition, pointPosition, alternative);
                if (inDestinationQuadrant && !this.safeEquals(pointPosition, cursorPosition)) continue;
                it.remove();
            }
            logger.fine("After removal " + mapNodePositionHolders.size() + " elements");
            MapNodePositionHolder nearest = null;
            double distance = Double.MAX_VALUE;
            for (MapNodePositionHolder holder : mapNodePositionHolders) {
                double newDist = this.dist(holder.getPosition(), cursorPosition);
                logger.fine("Position " + (Object)((Object)holder) + " is " + newDist);
                if (!(newDist < distance)) continue;
                distance = newDist;
                nearest = holder;
            }
            if (nearest != null) {
                FreeMindMapController.this.selectNode(nearest.getNode());
                FreeMindMapController.this.setCursorPosition(nearest, FreeMindMapController.this.map.getZoom());
                returnValue = true;
            }
            return returnValue;
        }

        public boolean destinationQuadrantCheck(Coordinate cursorPosition, Coordinate pointPosition, boolean alternative) {
            int mapZoomMax = FreeMindMapController.this.getMaxZoom();
            int x1 = OsmMercator.LonToX((double)cursorPosition.getLon(), (int)mapZoomMax);
            int y1 = OsmMercator.LatToY((double)cursorPosition.getLat(), (int)mapZoomMax);
            int x2 = OsmMercator.LonToX((double)pointPosition.getLon(), (int)mapZoomMax);
            int y2 = OsmMercator.LatToY((double)pointPosition.getLat(), (int)mapZoomMax);
            return this.destinationQuadrantCheck(x1, y1, x2, y2, alternative);
        }

        public abstract boolean destinationQuadrantCheck(int var1, int var2, int var3, int var4, boolean var5);

        private boolean safeEquals(Coordinate p1, Coordinate p2) {
            return p1 != null && p2 != null && p1.getLon() == p2.getLon() && p1.getLat() == p2.getLat() || p1 == null && p2 == null;
        }

        private double dist(Coordinate p1, Coordinate p2) {
            return OsmMercator.getDistance((double)p1.getLat(), (double)p1.getLon(), (double)p2.getLat(), (double)p2.getLon());
        }
    }

    private final class ShowNodeAction
    extends AbstractAction {
        public ShowNodeAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.show_nodes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FreeMindMapController.this.showSelectedNodes();
        }
    }

    private final class PlaceNodeAction
    extends AbstractAction {
        public PlaceNodeAction() {
            super(FreeMindMapController.this.getText("MapControllerPopupDialog.place"), MapNodePositionHolder.getMapLocationIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FreeMindMapController.this.placeNode(FreeMindMapController.this.mMindMapController.getSelected());
        }
    }

    public class ChangeTileSource
    extends AbstractAction
    implements MenuItemSelectedListener {
        private final TileSource mSource;

        public ChangeTileSource(TileSource pSource) {
            super(Resources.getInstance().getText("map_ChangeTileSource_" + FreeMindMapController.getTileSourceName(pSource)));
            this.mSource = pSource;
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            FreeMindMapController.this.map.setTileSource(this.mSource);
        }

        public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
            return FreeMindMapController.this.getTileSource() == this.mSource;
        }
    }

    private final class MapEditNoteTextField
    extends EditNodeTextField {
        private final Point mPoint;

        private MapEditNoteTextField(NodeView pNode, String pText, KeyEvent pFirstEvent, ModeController pController, EditNodeBase.EditControl pEditControl, JComponent pParent, Point pPoint) {
            super(pNode, pText, pFirstEvent, pController, pEditControl, pParent, pParent);
            this.mPoint = pPoint;
        }

        protected void setTextfieldLoaction(Point pMPoint) {
            this.textfield.setLocation(this.mPoint);
        }

        protected void addTextfield() {
            this.mParent.add(this.textfield);
        }
    }

    private final class MapEditTextFieldControl
    implements EditNodeBase.EditControl {
        private final NodeView mNodeView;
        private final MindMapNode mNewNode;
        private final MindMapNode mTargetNode;
        private boolean mIsEditOfExistingNode;

        private MapEditTextFieldControl(NodeView pNodeView, MindMapNode pNewNode, MindMapNode pTargetNode, boolean pIsEditOfExistingNode) {
            this.mNodeView = pNodeView;
            this.mNewNode = pNewNode;
            this.mTargetNode = pTargetNode;
            this.mIsEditOfExistingNode = pIsEditOfExistingNode;
        }

        public void cancel() {
            if (!this.mIsEditOfExistingNode) {
                FreeMindMapController.this.mMindMapController.getView().selectAsTheOnlyOneSelected(this.mNodeView);
                FreeMindMapController.this.mMindMapController.cut((List)Tools.getVectorWithSingleElement((Object)this.mNewNode));
                FreeMindMapController.this.mMindMapController.select(FreeMindMapController.this.mMindMapController.getNodeView(this.mTargetNode));
            }
            this.endEdit();
        }

        public void ok(String newText) {
            FreeMindMapController.this.mMindMapController.setNodeText(this.mNewNode, newText);
            MapNodePositionHolderBase hook = FreeMindMapController.this.placeNode(this.mNewNode);
            this.endEdit();
        }

        private void endEdit() {
            FreeMindMapController.this.setMouseControl(true);
            FreeMindMapController.this.mMindMapController.setBlocked(false);
            FreeMindMapController.this.mMapDialog.requestFocus();
        }

        public void split(String newText, int position) {
        }
    }

    public static class MapQuestOpenMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://otile%s.mqcdn.com/tiles/1.0.0/osm";
        private static final String[] SERVER = new String[]{"1", "2", "3", "4"};
        private int SERVER_NUM = 0;

        public MapQuestOpenMap() {
            super("OSM MapQuest.Open Map", PATTERN);
        }

        public String getBaseUrl() {
            String url = String.format(this.baseUrl, SERVER[this.SERVER_NUM]);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return url;
        }

        public int getMaxZoom() {
            return 18;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.LastModified;
        }
    }

    public static class TransportMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.tile2.opencyclemap.org/transport";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int SERVER_NUM = 0;

        public TransportMap() {
            super("OSM Transport Map", PATTERN);
        }

        public String getBaseUrl() {
            String url = String.format(this.baseUrl, SERVER[this.SERVER_NUM]);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return url;
        }

        public int getMaxZoom() {
            return 18;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.LastModified;
        }
    }

    public static class TileSourceStore {
        TileSource mTileSource;
        String mLayerName;

        public TileSourceStore(TileSource pTileSource, String pLayerName) {
            this.mTileSource = pTileSource;
            this.mLayerName = pLayerName;
        }
    }

    public static interface CursorPositionListener {
        public void cursorPositionChanged(Coordinate var1);
    }
}

