/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JpegSegmentData
implements Serializable {
    static final long serialVersionUID = 7110175216435025451L;
    private final HashMap _segmentDataMap = new HashMap(10);

    public void addSegment(byte segmentMarker, byte[] segmentBytes) {
        List segmentList = this.getOrCreateSegmentList(segmentMarker);
        segmentList.add(segmentBytes);
    }

    public byte[] getSegment(byte segmentMarker) {
        return this.getSegment(segmentMarker, 0);
    }

    public byte[] getSegment(byte segmentMarker, int occurrence) {
        List segmentList = this.getSegmentList(segmentMarker);
        if (segmentList == null || segmentList.size() <= occurrence) {
            return null;
        }
        return (byte[])segmentList.get(occurrence);
    }

    public int getSegmentCount(byte segmentMarker) {
        List segmentList = this.getSegmentList(segmentMarker);
        if (segmentList == null) {
            return 0;
        }
        return segmentList.size();
    }

    public void removeSegmentOccurrence(byte segmentMarker, int occurrence) {
        List segmentList = (List)this._segmentDataMap.get(new Byte(segmentMarker));
        segmentList.remove(occurrence);
    }

    public void removeSegment(byte segmentMarker) {
        this._segmentDataMap.remove(new Byte(segmentMarker));
    }

    private List getSegmentList(byte segmentMarker) {
        return (List)this._segmentDataMap.get(new Byte(segmentMarker));
    }

    private List getOrCreateSegmentList(byte segmentMarker) {
        List segmentList;
        Byte key = new Byte(segmentMarker);
        if (this._segmentDataMap.containsKey(key)) {
            segmentList = (List)this._segmentDataMap.get(key);
        } else {
            segmentList = new ArrayList();
            this._segmentDataMap.put(key, segmentList);
        }
        return segmentList;
    }

    public boolean containsSegment(byte segmentMarker) {
        return this._segmentDataMap.containsKey(new Byte(segmentMarker));
    }

    public static void ToFile(File file, JpegSegmentData segmentData) throws IOException {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(file));
            outputStream.writeObject(segmentData);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static JpegSegmentData FromFile(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(file));
            JpegSegmentData jpegSegmentData = (JpegSegmentData)inputStream.readObject();
            return jpegSegmentData;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

