/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.Field;
import tim.prune.gui.WholeNumberField;

public class AddTimeOffset
extends GenericFunction {
    private JDialog _dialog = null;
    private JRadioButton _addRadio = null;
    private JRadioButton _subtractRadio = null;
    private WholeNumberField _dayField = null;
    private WholeNumberField _hourField = null;
    private WholeNumberField _minuteField = null;
    private JButton _okButton = null;

    public AddTimeOffset(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.addtimeoffset";
    }

    @Override
    public void begin() {
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        if (!this._app.getTrackInfo().getTrack().hasData(Field.TIMESTAMP, n, n2)) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.addtimeoffset.notimestamps");
            return;
        }
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        this._addRadio = new JRadioButton(I18nManager.getText("dialog.addtimeoffset.add"));
        this._addRadio.setSelected(true);
        jPanel3.add(this._addRadio);
        this._subtractRadio = new JRadioButton(I18nManager.getText("dialog.addtimeoffset.subtract"));
        this._subtractRadio.setSelected(false);
        jPanel3.add(this._subtractRadio);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._addRadio);
        buttonGroup.add(this._subtractRadio);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2));
        jPanel4.add(AddTimeOffset.makeRightLabel("dialog.addtimeoffset.days"));
        this._dayField = new WholeNumberField(4);
        jPanel4.add(this._dayField);
        jPanel4.add(AddTimeOffset.makeRightLabel("dialog.addtimeoffset.hours"));
        this._hourField = new WholeNumberField(3);
        jPanel4.add(this._hourField);
        jPanel4.add(AddTimeOffset.makeRightLabel("dialog.addtimeoffset.minutes"));
        this._minuteField = new WholeNumberField(3);
        jPanel4.add(this._minuteField);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                boolean bl = "1234567890".indexOf(keyEvent.getKeyChar()) >= 0;
                AddTimeOffset.this._okButton.setEnabled(bl || AddTimeOffset.this.getOffsetSecs() != 0L);
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AddTimeOffset.this._okButton.setEnabled(AddTimeOffset.this.getOffsetSecs() != 0L);
            }
        };
        this._dayField.addKeyListener(keyAdapter);
        this._hourField.addKeyListener(keyAdapter);
        this._minuteField.addKeyListener(keyAdapter);
        this._dayField.addMouseListener(mouseAdapter);
        this._hourField.addMouseListener(mouseAdapter);
        this._minuteField.addMouseListener(mouseAdapter);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTimeOffset.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel5.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTimeOffset.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private static final JLabel makeRightLabel(String string) {
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText(string)) + " : ");
        jLabel.setHorizontalAlignment(4);
        return jLabel;
    }

    private long getOffsetSecs() {
        long l = (long)this._minuteField.getValue() * 60L + (long)this._hourField.getValue() * 60L * 60L + (long)this._dayField.getValue() * 60L * 60L * 24L;
        if (this._subtractRadio.isSelected()) {
            l = -l;
        }
        return l;
    }

    private void finish() {
        long l = this.getOffsetSecs();
        if (l != 0L) {
            this._app.finishAddTimeOffsetSeconds(l);
            this._dialog.dispose();
        }
    }
}

