/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.UploadNoteLayerTask;
import org.openstreetmap.josm.gui.io.importexport.NoteExporter;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NoteLayer
extends AbstractModifiableLayer
implements MouseListener,
NoteData.NoteDataUpdateListener {
    private static final Pattern SENTENCE_MARKS_WESTERN = Pattern.compile("([\\.\\?\\!])(?:[\\h\\v]+)([\\p{L}\\p{Punct}])");
    private static final Pattern SENTENCE_MARKS_EASTERN = Pattern.compile("(\\u3002)([\\p{L}\\p{Punct}])");
    private static final Pattern HTTP_LINK = Pattern.compile("(https?://[^\\s\\(\\)<>]+)");
    private static final Pattern HTML_LINK = Pattern.compile("<a href=\"[^\"]+\">([^<]+)</a>");
    private static final Pattern HTML_LINK_MARK = Pattern.compile("<a href=\"([^\"]+)([\\.\\?\\!])\">([^<]+)(?:[\\.\\?\\!])</a>");
    private static final Pattern SLASH = Pattern.compile("([^/])/([^/])");
    private final NoteData noteData;
    private Note displayedNote;
    private HtmlPanel displayedPanel;
    private JWindow displayedWindow;

    public NoteLayer(Collection<Note> notes, String name) {
        this(new NoteData(notes), name);
    }

    public NoteLayer(NoteData noteData, String name) {
        super(name);
        this.noteData = Objects.requireNonNull(noteData);
        this.noteData.addNoteDataUpdateListener(this);
    }

    public NoteLayer() {
        this(Collections.emptySet(), I18n.tr("Notes", new Object[0]));
    }

    @Override
    public void hookUpMapView() {
        MainApplication.getMap().mapView.addMouseListener(this);
    }

    @Override
    public synchronized void destroy() {
        MainApplication.getMap().mapView.removeMouseListener(this);
        this.noteData.removeNoteDataUpdateListener(this);
        this.hideNoteWindow();
        super.destroy();
    }

    public NoteData getNoteData() {
        return this.noteData;
    }

    @Override
    public boolean isModified() {
        return this.noteData.isModified();
    }

    @Override
    public boolean isDownloadable() {
        return true;
    }

    @Override
    public boolean isUploadable() {
        return true;
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.isModified();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.isModified();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        int iconHeight = ImageProvider.ImageSizes.SMALLICON.getAdjustedHeight();
        int iconWidth = ImageProvider.ImageSizes.SMALLICON.getAdjustedWidth();
        for (Note note : this.noteData.getNotes()) {
            Point p = mv.getPoint(note.getLatLon());
            ImageIcon icon = note.getId() < 0L ? ImageProvider.get("dialogs/notes", "note_new", ImageProvider.ImageSizes.SMALLICON) : (note.getState() == Note.State.CLOSED ? ImageProvider.get("dialogs/notes", "note_closed", ImageProvider.ImageSizes.SMALLICON) : ImageProvider.get("dialogs/notes", "note_open", ImageProvider.ImageSizes.SMALLICON));
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            g.drawImage(icon.getImage(), p.x - width / 2, p.y - height, MainApplication.getMap().mapView);
        }
        Note selectedNote = this.noteData.getSelectedNote();
        if (selectedNote != null) {
            this.paintSelectedNote(g, mv, iconHeight, iconWidth, selectedNote);
        } else {
            this.hideNoteWindow();
        }
    }

    private void hideNoteWindow() {
        if (this.displayedWindow != null) {
            this.displayedWindow.setVisible(false);
            for (MouseWheelListener listener : this.displayedWindow.getMouseWheelListeners()) {
                this.displayedWindow.removeMouseWheelListener(listener);
            }
            this.displayedWindow.dispose();
            this.displayedWindow = null;
            this.displayedPanel = null;
            this.displayedNote = null;
        }
    }

    private void paintSelectedNote(Graphics2D g, MapView mv, int iconHeight, int iconWidth, Note selectedNote) {
        Point pTooltip;
        Point p = mv.getPoint(selectedNote.getLatLon());
        g.setColor(ColorHelper.html2color(Config.getPref().get("color.selected")));
        g.drawRect(p.x - iconWidth / 2, p.y - iconHeight, iconWidth - 1, iconHeight - 1);
        if (this.displayedNote != null && !this.displayedNote.equals(selectedNote)) {
            this.hideNoteWindow();
        }
        int xl = p.x - iconWidth / 2 - 5;
        int xr = p.x + iconWidth / 2 + 5;
        int yb = p.y - iconHeight - 1;
        int yt = p.y + iconHeight / 2 + 2;
        String text = NoteLayer.getNoteToolTip(selectedNote);
        if (this.displayedWindow == null) {
            this.displayedPanel = new HtmlPanel(text);
            this.displayedPanel.setBackground(UIManager.getColor("ToolTip.background"));
            this.displayedPanel.setForeground(UIManager.getColor("ToolTip.foreground"));
            this.displayedPanel.setFont(UIManager.getFont("ToolTip.font"));
            this.displayedPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.displayedPanel.enableClickableHyperlinks();
            pTooltip = this.fixPanelSizeAndLocation(mv, text, xl, xr, yt, yb);
            this.displayedWindow = new JWindow(MainApplication.getMainFrame());
            this.displayedWindow.setAutoRequestFocus(false);
            this.displayedWindow.add(this.displayedPanel);
            this.displayedWindow.addMouseWheelListener(e -> mv.getMapMover().mouseWheelMoved((MouseWheelEvent)SwingUtilities.convertMouseEvent(this.displayedWindow, e, mv)));
        } else {
            this.displayedPanel.setText(text);
            pTooltip = this.fixPanelSizeAndLocation(mv, text, xl, xr, yt, yb);
        }
        this.displayedWindow.pack();
        this.displayedWindow.setLocation(pTooltip);
        this.displayedWindow.setVisible(mv.contains(p));
        this.displayedNote = selectedNote;
    }

    private Point fixPanelSizeAndLocation(MapView mv, String text, int xl, int xr, int yt, int yb) {
        int leftMaxWidth = (int)(0.95 * (double)xl);
        int rightMaxWidth = (int)(0.95 * (double)mv.getWidth() - (double)xr);
        int topMaxHeight = (int)(0.95 * (double)yt);
        int bottomMaxHeight = (int)(0.95 * (double)mv.getHeight() - (double)yb);
        int maxWidth = Math.max(leftMaxWidth, rightMaxWidth);
        int maxHeight = Math.max(topMaxHeight, bottomMaxHeight);
        JEditorPane pane = this.displayedPanel.getEditorPane();
        Dimension d = pane.getPreferredSize();
        if ((d.width > maxWidth || d.height > maxHeight) && Config.getPref().getBoolean("note.text.break-on-sentence-mark", false)) {
            this.displayedPanel.setText(NoteLayer.insertLineBreaks(text));
        }
        d = pane.getPreferredSize();
        if (d.width > maxWidth || d.height > maxHeight) {
            View v = (View)pane.getClientProperty("html");
            if (v == null) {
                BasicHTML.updateRenderer(pane, text);
                v = (View)pane.getClientProperty("html");
            }
            if (v != null) {
                v.setSize(maxWidth, 0.0f);
                int w = (int)Math.ceil(v.getPreferredSpan(0));
                int h = (int)Math.ceil(v.getPreferredSpan(1)) + 20;
                pane.setPreferredSize(new Dimension(w, h));
            }
        }
        d = pane.getPreferredSize();
        Point screenloc = mv.getLocationOnScreen();
        return new Point(screenloc.x + (d.width > rightMaxWidth && d.width <= leftMaxWidth ? xl - d.width : xr), screenloc.y + (d.height > bottomMaxHeight && d.height <= topMaxHeight ? yt - d.height - 10 : yb));
    }

    static String insertLineBreaks(String longText) {
        return SENTENCE_MARKS_WESTERN.matcher(SENTENCE_MARKS_EASTERN.matcher(longText).replaceAll("$1<br>$2")).replaceAll("$1<br>$2");
    }

    public static String getNoteToolTip(Note note) {
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(I18n.tr("Note", new Object[0])).append(' ').append(note.getId());
        for (NoteComment comment : note.getComments()) {
            String commentText = comment.getText();
            if (commentText == null || commentText.trim().isEmpty()) continue;
            sb.append("<hr/>");
            String userName = XmlWriter.encode(comment.getUser().getName());
            if (userName == null || userName.trim().isEmpty()) {
                userName = "&lt;Anonymous&gt;";
            }
            sb.append(userName).append(" on ").append(DateUtils.getDateFormatter(FormatStyle.MEDIUM).format(comment.getCommentTimestamp())).append(":<br>");
            String htmlText = XmlWriter.encode(comment.getText(), true);
            htmlText = htmlText.replace("&#xA;", "<br>");
            htmlText = NoteLayer.replaceLinks(htmlText);
            sb.append(htmlText);
        }
        sb.append("</html>");
        String result = sb.toString();
        Logging.debug(result);
        return result;
    }

    static String replaceLinks(String htmlText) {
        String result = HTTP_LINK.matcher(htmlText).replaceAll("<a href=\"$1\">$1</a>");
        Matcher m1 = HTML_LINK.matcher(result = HTML_LINK_MARK.matcher(result).replaceAll("<a href=\"$1\">$3</a>$2"));
        if (m1.find()) {
            int last = 0;
            StringBuffer sb = new StringBuffer();
            do {
                sb.append(result, last, m1.start());
                last = m1.end();
                String link = m1.group(0);
                Matcher m2 = SLASH.matcher(link).region(link.indexOf(62), link.lastIndexOf(60));
                while (m2.find()) {
                    m2.appendReplacement(sb, "$1/\u200b$2");
                }
                m2.appendTail(sb);
            } while (m1.find());
            result = sb.append(result, last, result.length()).toString();
        }
        return result;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/notes", "note_open", ImageProvider.ImageSizes.SMALLICON);
    }

    @Override
    public String getToolTipText() {
        int size = this.noteData.getNotes().size();
        return I18n.trn("{0} note", "{0} notes", size, size);
    }

    @Override
    public void mergeFrom(Layer from) {
        if (from instanceof NoteLayer && this != from) {
            this.noteData.mergeFrom(((NoteLayer)from).noteData);
        }
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Note note : this.noteData.getNotes()) {
            v.visit(note.getLatLon());
        }
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.tr("Notes layer", new Object[0])).append('\n').append(I18n.tr("Total notes:", new Object[0])).append(' ').append(this.noteData.getNotes().size()).append('\n').append(I18n.tr("Changes need uploading?", new Object[0])).append(' ').append(this.isModified());
        return sb.toString();
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), MainApplication.getMenu().autoScaleActions.get((Object)AutoScaleAction.AutoScaleMode.LAYER), LayerListDialog.getInstance().createDeleteLayerAction(), new LayerListPopup.InfoAction(this), new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this)};
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Point clickPoint = e.getPoint();
        double snapDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        int iconHeight = ImageProvider.ImageSizes.SMALLICON.getAdjustedHeight();
        Note closestNote = null;
        for (Note note : this.noteData.getNotes()) {
            Point notePoint = MainApplication.getMap().mapView.getPoint(note.getLatLon());
            notePoint.setLocation(notePoint.getX(), notePoint.getY() - (double)iconHeight / 2.0);
            double dist = clickPoint.distanceSq(notePoint);
            if (!(minDistance > dist) || !(clickPoint.distance(notePoint) < snapDistance)) continue;
            minDistance = dist;
            closestNote = note;
        }
        this.noteData.setSelectedNote(closestNote);
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Note file", new Object[0]), NoteExporter.FILE_FILTER);
    }

    @Override
    public AbstractIOTask createUploadTask(ProgressMonitor monitor) {
        return new UploadNoteLayerTask(this, monitor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void noteDataUpdated(NoteData data) {
        this.invalidate();
    }

    @Override
    public void selectedNoteChanged(NoteData noteData) {
        this.invalidate();
    }

    @Override
    public String getChangesetSourceTag() {
        return "Notes";
    }

    @Override
    public boolean autosave(File file) throws IOException {
        new NoteExporter().exportData(file, this);
        return true;
    }

    @Override
    public Data getData() {
        return this.getNoteData();
    }
}

