/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeepCopyIrTreeWithDeclarationsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerialTypeInfo;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializableCodegen;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrBuilderExtension;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.extensions.SerializationPluginContext;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0014\u0010!\u001a\u00020\u0017*\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0004H\u0002J*\u0010#\u001a\u00020$*\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020$H\u0002J\u001c\u0010)\u001a\u00020**\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\f\u0010/\u001a\u00020**\u00020\u001fH\u0002J\u001c\u00100\u001a\u00020**\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u001eH\u0002J\f\u00101\u001a\u00020**\u00020\u001fH\u0002J\f\u00102\u001a\u00020\u0014*\u00020\u0004H\u0002J\u0014\u00103\u001a\u00020\u0017*\u0002042\u0006\u0010\"\u001a\u00020\u0004H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializableIrGenerator;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerializableCodegen;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrBuilderExtension;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "compilerContext", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "addElementFun", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getCompilerContext", "()Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "serialDescClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "serialDescImplClass", "isInternalSerializable", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "generateInternalConstructor", "", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateWriteSelfMethod", "methodDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "createCachedDescriptorProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "companionObject", "generateSuperNonSerializableCall", "superClass", "generateSuperSerializableCall", "", "allValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "propertiesStart", "getAddElementToDescriptorExpr", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "property", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "serialDescVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getInstantiateDescriptorExpr", "getParametrizedSerialDescriptorExpr", "getStaticSerialDescriptorExpr", "hasSerializableAnnotationWithoutArgs", "insertTypeArgumentsForSuperClass", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrDelegatingConstructorCallImpl;", "Companion", "kotlinx-serialization-compiler-plugin"})
public final class SerializableIrGenerator
extends SerializableCodegen
implements IrBuilderExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final SerializationPluginContext compilerContext;
    @NotNull
    private final ClassDescriptor serialDescClass;
    @NotNull
    private final ClassDescriptor serialDescImplClass;
    @NotNull
    private final IrFunctionSymbol addElementFun;

    public SerializableIrGenerator(@NotNull IrClass irClass, @NotNull SerializationPluginContext compilerContext, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)compilerContext, (String)"compilerContext");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        super(irClass.getDescriptor(), bindingContext);
        this.irClass = irClass;
        this.compilerContext = compilerContext;
        this.serialDescClass = SearchUtilsKt.getClassFromSerializationDescriptorsPackage(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.getSerializableDescriptor())), "SerialDescriptor");
        this.serialDescImplClass = SearchUtilsKt.getClassFromInternalSerializationPackage(this.getSerializableDescriptor(), "PluginGeneratedSerialDescriptor");
        this.addElementFun = IrBuilderExtension.DefaultImpls.referenceFunctionSymbol$default(this, this.serialDescImplClass, "addElement", null, 2, null);
    }

    @NotNull
    public final IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public SerializationPluginContext getCompilerContext() {
        return this.compilerContext;
    }

    private final boolean hasSerializableAnnotationWithoutArgs(IrClass $this$hasSerializableAnnotationWithoutArgs) {
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation((IrAnnotationContainer)((IrAnnotationContainer)$this$hasSerializableAnnotationWithoutArgs), (FqName)SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName());
        if (irConstructorCall == null) {
            return false;
        }
        int n = 0;
        IrConstructorCall annot = irConstructorCall;
        int n2 = annot.getValueArgumentsCount();
        if (n < n2) {
            do {
                int i;
                if (annot.getValueArgument(i = n++) == null) continue;
                return false;
            } while (n < n2);
        }
        return true;
    }

    private final boolean isInternalSerializable(IrClass $this$isInternalSerializable) {
        return $this$isInternalSerializable.getKind() == ClassKind.CLASS && this.hasSerializableAnnotationWithoutArgs($this$isInternalSerializable);
    }

    @Override
    protected void generateInternalConstructor(@NotNull ClassConstructorDescriptor constructorDescriptor) {
        Intrinsics.checkNotNullParameter((Object)constructorDescriptor, (String)"constructorDescriptor");
        IrBuilderExtension.DefaultImpls.contributeConstructor$default(this, this.irClass, constructorDescriptor, false, false, (Function2)new Function2<IrBlockBodyBuilder, IrConstructor, Unit>(this){
            final /* synthetic */ SerializableIrGenerator this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final void invoke(@NotNull IrBlockBodyBuilder $this$contributeConstructor, @NotNull IrConstructor ctor) {
                Unit unit;
                void $this$single$iv;
                Object answer$iv;
                PropertyDescriptor propertyDescriptor;
                Collection collection;
                Object item$iv$iv2;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$contributeConstructor, (String)"$this$contributeConstructor");
                Intrinsics.checkNotNullParameter((Object)ctor, (String)"ctor");
                IrValueParameter irValueParameter = this.this$0.getIrClass().getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                IrValueParameter thiz = irValueParameter;
                List<SerializableProperty> serializableProperties = SerializableIrGenerator.access$getProperties(this.this$0).getSerializableProperties();
                Iterable $this$map$iv = serializableProperties;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    SerializableProperty serializableProperty = (SerializableProperty)item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    propertyDescriptor = it.getDescriptor();
                    collection.add(propertyDescriptor);
                }
                Set serialDescs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Function1<ValueParameterDescriptor, IrExpression> propertyByParamReplacer = this.this$0.createPropertyByParamReplacer((IrBuilderWithScope)$this$contributeConstructor, this.this$0.getIrClass(), serializableProperties, thiz, this.this$0.getBindingContext());
                Function1 initializerAdapter2 = IrBuilderExtension.DefaultImpls.createInitializerAdapter$default(this.this$0, this.this$0.getIrClass(), propertyByParamReplacer, null, 4, null);
                PropertyDescriptor current = null;
                $i$f$mapTo = false;
                Map statementsAfterSerializableProperty = new LinkedHashMap<K, V>();
                Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)this.this$0.getIrClass().getDeclarations());
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Object object;
                    boolean bl;
                    boolean $i$f$getOrPutNullable;
                    PropertyDescriptor key$iv;
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (it instanceof IrProperty && ((IrProperty)it).getBackingField() != null) {
                        Object object2;
                        if (serialDescs.contains(((IrProperty)it).getDescriptor())) {
                            current = ((IrProperty)it).getDescriptor();
                            continue;
                        }
                        IrField irField = ((IrProperty)it).getBackingField();
                        if ((irField == null ? null : irField.getInitializer()) == null) continue;
                        IrField irField2 = ((IrProperty)it).getBackingField();
                        Intrinsics.checkNotNull((Object)irField2);
                        IrExpressionBody irExpressionBody = irField2.getInitializer();
                        Intrinsics.checkNotNull((Object)irExpressionBody);
                        IrExpression expression = (IrExpression)initializerAdapter2.invoke((Object)irExpressionBody);
                        Map map = statementsAfterSerializableProperty;
                        key$iv = current;
                        $i$f$getOrPutNullable = false;
                        if (!map.containsKey(key$iv)) {
                            boolean bl3 = false;
                            bl = false;
                            answer$iv = new ArrayList<E>();
                            map.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = map.get(key$iv);
                        }
                        List list = (List)object2;
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$contributeConstructor;
                        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrValueDeclaration)((IrValueDeclaration)thiz));
                        IrField irField3 = ((IrProperty)it).getBackingField();
                        Intrinsics.checkNotNull((Object)irField3);
                        list.add(ExpressionHelpersKt.irSetField((IrBuilderWithScope)irBuilderWithScope, (IrExpression)irExpression, (IrField)irField3, (IrExpression)expression));
                        continue;
                    }
                    if (!(it instanceof IrAnonymousInitializer)) continue;
                    List statements = ((IrBlockBody)DeepCopyIrTreeWithDeclarationsKt.deepCopyWithVariables((IrElement)((IrElement)((IrAnonymousInitializer)it).getBody()))).getStatements();
                    Map map = statementsAfterSerializableProperty;
                    key$iv = current;
                    $i$f$getOrPutNullable = false;
                    if (!map.containsKey(key$iv)) {
                        boolean bl4 = false;
                        bl = false;
                        answer$iv = new ArrayList<E>();
                        map.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = map.get(key$iv);
                    }
                    ((List)object).addAll(statements);
                }
                FqName exceptionFqn = SearchUtilsKt.getSerializationPackageFqn("MissingFieldException");
                item$iv$iv2 = this.this$0.getCompilerContext().referenceConstructors(exceptionFqn);
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (E e : $this$single$iv) {
                    IrType irType;
                    IrConstructorSymbol it = (IrConstructorSymbol)e;
                    boolean bl = false;
                    answer$iv = (IrValueParameter)CollectionsKt.singleOrNull((List)((IrConstructor)it.getOwner()).getValueParameters());
                    if (!(answer$iv == null ? false : ((irType = answer$iv.getType()) == null ? false : IrTypePredicatesKt.isString((IrType)irType)))) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = e;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                IrConstructorSymbol exceptionCtorRef = single$iv;
                IrType exceptionType = ((IrConstructor)exceptionCtorRef.getOwner()).getReturnType();
                int seenVarsOffset = SerializablePropertiesKt.bitMaskSlotCount(serializableProperties);
                Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)seenVarsOffset);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                answer$iv = iterable2.iterator();
                while (answer$iv.hasNext()) {
                    void it;
                    int item$iv$iv3;
                    int n = item$iv$iv3 = ((IntIterator)answer$iv).nextInt();
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    propertyDescriptor = (IrValueParameter)ctor.getValueParameters().get((int)it);
                    collection.add(propertyDescriptor);
                }
                List seenVars = (List)destination$iv$iv2;
                IrClass superClass = this.this$0.getSuperClassOrAny(this.this$0.getIrClass());
                int startPropOffset = 0;
                if (this.this$0.useFieldMissingOptimization() && !KSerializationUtilKt.isAbstractOrSealedSerializableClass(SerializableIrGenerator.access$getSerializableDescriptor(this.this$0))) {
                    IrExpression irExpression;
                    if (TypeUtilKt.isStaticSerializable(SerializableIrGenerator.access$getSerializableDescriptor(this.this$0))) {
                        irExpression = SerializableIrGenerator.access$getStaticSerialDescriptorExpr(this.this$0, $this$contributeConstructor);
                    } else {
                        IrClass irClass = AdditionalIrUtilsKt.companionObject((IrClass)this.this$0.getIrClass());
                        Intrinsics.checkNotNull((Object)irClass);
                        IrClass companionObject = irClass;
                        irExpression = SerializableIrGenerator.access$getParametrizedSerialDescriptorExpr(this.this$0, $this$contributeConstructor, companionObject, SerializableIrGenerator.access$createCachedDescriptorProperty(this.this$0, $this$contributeConstructor, companionObject));
                    }
                    IrExpression irExpression2 = irExpression;
                    this.this$0.generateGoldenMaskCheck($this$contributeConstructor, seenVars, SerializableIrGenerator.access$getProperties(this.this$0), irExpression2);
                }
                if (Intrinsics.areEqual((Object)superClass.getSymbol(), (Object)this.this$0.getCompilerContext().getIrBuiltIns().getAnyClass())) {
                    this.this$0.generateAnySuperConstructorCall((IrBuilderWithScope)$this$contributeConstructor, $this$contributeConstructor);
                } else if (SerializableIrGenerator.access$isInternalSerializable(this.this$0, superClass)) {
                    startPropOffset = SerializableIrGenerator.access$generateSuperSerializableCall(this.this$0, $this$contributeConstructor, superClass, ctor.getValueParameters(), seenVarsOffset);
                } else {
                    SerializableIrGenerator.access$generateSuperNonSerializableCall(this.this$0, $this$contributeConstructor, superClass);
                }
                List list = (List)statementsAfterSerializableProperty.get(null);
                if (list == null) {
                    unit = null;
                } else {
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv : $this$forEach$iv2) {
                        IrStatement it = (IrStatement)element$iv;
                        boolean bl = false;
                        $this$contributeConstructor.unaryPlus(it);
                    }
                    unit = Unit.INSTANCE;
                }
                int n = startPropOffset;
                int n2 = serializableProperties.size();
                if (n < n2) {
                    void var17_38;
                    do {
                        Unit unit2;
                        IrExpression irExpression;
                        IrExpression initializerBody;
                        Object object;
                        IrField backingFieldToAssign;
                        void index = var17_38++;
                        SerializableProperty prop = serializableProperties.get((int)index);
                        IrValueParameter paramRef = (IrValueParameter)ctor.getValueParameters().get((int)(index + seenVarsOffset));
                        Intrinsics.checkNotNull((Object)this.this$0.getIrPropertyFrom(prop, this.this$0.getIrClass()).getBackingField());
                        IrSetFieldImpl assignParamExpr = ExpressionHelpersKt.irSetField((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrValueDeclaration)((IrValueDeclaration)thiz))), (IrField)backingFieldToAssign, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrValueDeclaration)((IrValueDeclaration)paramRef))));
                        if (prop.getOptional()) {
                            IrExpressionBody irExpressionBody = this.this$0.getIrField(prop).getInitializer();
                            Intrinsics.checkNotNull((Object)irExpressionBody);
                            object = initializerAdapter2.invoke((Object)irExpressionBody);
                            boolean bl = false;
                            boolean bl5 = false;
                            if (object == null) {
                                boolean bl6 = false;
                                String string = "Optional value without an initializer";
                                throw (Throwable)new IllegalArgumentException(string.toString());
                            }
                            initializerBody = (IrExpression)object;
                            irExpression = (IrExpression)ExpressionHelpersKt.irSetField((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrValueDeclaration)((IrValueDeclaration)thiz))), (IrField)backingFieldToAssign, (IrExpression)initializerBody);
                        } else {
                            if (this.this$0.useFieldMissingOptimization()) {
                                Unit unit3;
                                $this$contributeConstructor.unaryPlus((IrStatement)assignParamExpr);
                                initializerBody = (IrExpression)statementsAfterSerializableProperty.get(prop.getDescriptor());
                                if (initializerBody == null) {
                                    unit3 = null;
                                    continue;
                                }
                                Iterable $this$forEach$iv3 = (Iterable)initializerBody;
                                boolean $i$f$forEach3 = false;
                                for (T element$iv : $this$forEach$iv3) {
                                    IrStatement it = (IrStatement)element$iv;
                                    boolean bl = false;
                                    $this$contributeConstructor.unaryPlus(it);
                                }
                                unit3 = Unit.INSTANCE;
                                continue;
                            }
                            initializerBody = new IrExpression[]{(IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (String)prop.getName())};
                            irExpression = (IrExpression)LowerUtilsKt.irThrow((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrExpression)((IrExpression)this.this$0.irInvoke((IrBuilderWithScope)$this$contributeConstructor, null, (IrFunctionSymbol)exceptionCtorRef, (IrExpression[])initializerBody, exceptionType)));
                        }
                        IrExpression ifNotSeenExpr = irExpression;
                        IrExpression propNotSeenTest = ExpressionHelpersKt.irEquals$default((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrExpression)((IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (int)0, null, (int)2, null)), (IrExpression)this.this$0.irBinOp((IrBuilderWithScope)$this$contributeConstructor, OperatorNameConventions.AND, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrValueDeclaration)((IrValueDeclaration)seenVars.get(SerializablePropertiesKt.bitMaskSlotAt((int)index)))), (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (int)(1 << index % 32), null, (int)2, null)), null, (int)4, null);
                        $this$contributeConstructor.unaryPlus((IrStatement)ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeConstructor), (IrType)this.this$0.getCompilerContext().getIrBuiltIns().getUnitType(), (IrExpression)propNotSeenTest, (IrExpression)ifNotSeenExpr, (IrExpression)((IrExpression)assignParamExpr), null, (int)16, null));
                        object = (List)statementsAfterSerializableProperty.get(prop.getDescriptor());
                        if (object == null) {
                            unit2 = null;
                            continue;
                        }
                        Iterable $this$forEach$iv4 = (Iterable)object;
                        boolean $i$f$forEach4 = false;
                        for (T element$iv : $this$forEach$iv4) {
                            IrStatement it = (IrStatement)element$iv;
                            boolean bl = false;
                            $this$contributeConstructor.unaryPlus(it);
                        }
                        unit2 = Unit.INSTANCE;
                    } while (var17_38 < n2);
                }
            }
        }, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getStaticSerialDescriptorExpr(IrBlockBodyBuilder $this$getStaticSerialDescriptorExpr) {
        void $this$filterIsInstanceAndTo$iv$iv;
        void $this$filterIsInstanceAnd$iv;
        ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.getSerializableDescriptor());
        Intrinsics.checkNotNull((Object)classDescriptor);
        ClassDescriptor serializer = classDescriptor;
        Iterable iterable = this.irClass.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        void var7_5 = $this$filterIsInstanceAnd$iv;
        Collection destination$iv$iv = (Collection)new SmartList();
        boolean $i$f$filterIsInstanceAndTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
            if (!(element$iv$iv instanceof IrClass)) continue;
            IrClass it = (IrClass)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)serializer.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        IrClass irClass = (IrClass)CollectionsKt.singleOrNull((Iterable)destination$iv$iv);
        if (irClass == null) {
            throw new Exception(Intrinsics.stringPlus((String)"No class with name ", (Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)serializer))));
        }
        IrClass serializerIrClass = irClass;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter((IrClass)serializerIrClass, (String)"descriptor");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        IrSimpleFunctionSymbol serialDescriptorGetter = irSimpleFunctionSymbol;
        return (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$getStaticSerialDescriptorExpr), (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)serializerIrClass)), (IrExpression)((IrExpression)this.irGetObject((IrBuilderWithScope)$this$getStaticSerialDescriptorExpr, serializer)), (IrFunctionSymbol)((IrFunctionSymbol)((IrSimpleFunction)serialDescriptorGetter.getOwner()).getSymbol()));
    }

    private final IrExpression getParametrizedSerialDescriptorExpr(IrBlockBodyBuilder $this$getParametrizedSerialDescriptorExpr, IrClass companionObject, IrProperty property2) {
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$getParametrizedSerialDescriptorExpr;
        IrExpression irExpression = (IrExpression)this.irGetObject((IrBuilderWithScope)$this$getParametrizedSerialDescriptorExpr, companionObject);
        IrField irField = property2.getBackingField();
        Intrinsics.checkNotNull((Object)irField);
        return (IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)irBuilderWithScope, (IrExpression)irExpression, (IrField)irField);
    }

    private final IrProperty createCachedDescriptorProperty(IrBlockBodyBuilder $this$createCachedDescriptorProperty, IrClass companionObject) {
        SimpleType simpleType = this.serialDescClass.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"serialDescClass.defaultType");
        IrType serialDescIrType = this.toIrType((KotlinType)simpleType);
        return this.createCompanionValProperty(companionObject, serialDescIrType, SerialEntityNames.INSTANCE.getCACHED_DESCRIPTOR_FIELD_NAME(), (Function1<? super IrBlockBodyBuilder, Unit>)((Function1)new Function1<IrBlockBodyBuilder, Unit>(this){
            final /* synthetic */ SerializableIrGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IrBlockBodyBuilder $this$createCompanionValProperty) {
                Intrinsics.checkNotNullParameter((Object)$this$createCompanionValProperty, (String)"$this$createCompanionValProperty");
                IrVariable serialDescVar = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)((IrStatementsBuilder)$this$createCompanionValProperty), (IrExpression)SerializableIrGenerator.access$getInstantiateDescriptorExpr(this.this$0, $this$createCompanionValProperty), (String)"serialDesc", null, (boolean)false, (int)12, null);
                for (SerializableProperty property2 : SerializableIrGenerator.access$getProperties(this.this$0).getSerializableProperties()) {
                    $this$createCompanionValProperty.unaryPlus((IrStatement)SerializableIrGenerator.access$getAddElementToDescriptorExpr(this.this$0, $this$createCompanionValProperty, property2, serialDescVar));
                }
                $this$createCompanionValProperty.unaryPlus((IrStatement)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$createCompanionValProperty), (IrValueDeclaration)((IrValueDeclaration)serialDescVar)));
            }
        }));
    }

    private final IrExpression getInstantiateDescriptorExpr(IrBlockBodyBuilder $this$getInstantiateDescriptorExpr) {
        Collection<IrConstructorSymbol> classConstructors = this.getCompilerContext().referenceConstructors(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)this.serialDescImplClass)));
        Iterable $this$single$iv = classConstructors;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrConstructorSymbol it = (IrConstructorSymbol)element$iv;
            boolean bl = false;
            if (!((IrConstructor)it.getOwner()).isPrimary()) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        IrConstructorSymbol serialClassDescImplCtor = single$iv;
        IrExpression[] irExpressionArray = new IrExpression[]{(IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$getInstantiateDescriptorExpr), (String)TypeUtilKt.serialName(this.getSerializableDescriptor())), (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$getInstantiateDescriptorExpr)), (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)((IrBuilderWithScope)$this$getInstantiateDescriptorExpr), (int)this.getProperties().getSerializableProperties().size(), null, (int)2, null)};
        return (IrExpression)IrBuilderExtension.DefaultImpls.irInvoke$default(this, (IrBuilderWithScope)$this$getInstantiateDescriptorExpr, null, (IrFunctionSymbol)serialClassDescImplCtor, irExpressionArray, null, 8, null);
    }

    private final IrExpression getAddElementToDescriptorExpr(IrBlockBodyBuilder $this$getAddElementToDescriptorExpr, SerializableProperty property2, IrVariable serialDescVar) {
        IrExpression[] irExpressionArray = new IrExpression[]{(IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$getAddElementToDescriptorExpr), (String)property2.getName()), (IrExpression)ExpressionHelpersKt.irBoolean((IrBuilderWithScope)((IrBuilderWithScope)$this$getAddElementToDescriptorExpr), (boolean)property2.getOptional())};
        return (IrExpression)this.irInvoke((IrBuilderWithScope)$this$getAddElementToDescriptorExpr, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$getAddElementToDescriptorExpr), (IrValueDeclaration)((IrValueDeclaration)serialDescVar)), this.addElementFun, irExpressionArray, this.getCompilerContext().getIrBuiltIns().getUnitType());
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSuperNonSerializableCall(IrBlockBodyBuilder $this$generateSuperNonSerializableCall, IrClass superClass) {
        Object v0;
        block4: {
            void $this$singleOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = superClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrConstructor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl = false;
                if (!it.getValueParameters().isEmpty()) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrConstructor irConstructor = v0;
        if (irConstructor == null) {
            String string = "Non-serializable parent of serializable " + this.getSerializableDescriptor() + " must have no arg constructor";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        IrConstructor ctorRef = irConstructor;
        IrDelegatingConstructorCallImpl call = IrDelegatingConstructorCallImpl.Companion.fromSymbolDescriptor$default((IrDelegatingConstructorCallImpl.Companion)IrDelegatingConstructorCallImpl.Companion, (int)$this$generateSuperNonSerializableCall.getStartOffset(), (int)$this$generateSuperNonSerializableCall.getEndOffset(), (IrType)this.getCompilerContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)ctorRef.getSymbol(), (int)0, (int)0, (int)48, null);
        this.insertTypeArgumentsForSuperClass(call, superClass);
        $this$generateSuperNonSerializableCall.unaryPlus((IrStatement)call);
    }

    /*
     * WARNING - void declaration
     */
    private final void insertTypeArgumentsForSuperClass(IrDelegatingConstructorCallImpl $this$insertTypeArgumentsForSuperClass, IrClass superClass) {
        Object v0;
        block5: {
            Iterable iterable = this.irClass.getSuperTypes();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                IrType it = (IrType)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)IrTypesKt.getClassOrNull((IrType)it), (Object)superClass.getSymbol())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        Object object = v0;
        List superTypeCallArguments = object == null ? null : object.getArguments();
        object = superTypeCallArguments;
        if (object != null) {
            Iterable $this$forEachIndexed$iv = (Iterable)object;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void irTypeArgument;
                IrTypeProjection irTypeProjection;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrTypeArgument bl3 = (IrTypeArgument)item$iv;
                int index = n;
                boolean bl4 = false;
                IrTypeProjection irTypeProjection2 = irTypeProjection = irTypeArgument instanceof IrTypeProjection ? (IrTypeProjection)irTypeArgument : null;
                if (irTypeProjection == null) {
                    throw new IllegalStateException("Star projection in immediate argument for supertype");
                }
                IrTypeProjection argType = irTypeProjection;
                $this$insertTypeArgumentsForSuperClass.putTypeArgument(index, argType.getType());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int generateSuperSerializableCall(IrBlockBodyBuilder $this$generateSuperSerializableCall, IrClass superClass, List<? extends IrValueParameter> allValueParameters, int propertiesStart) {
        boolean bl = this.isInternalSerializable(superClass);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        IrConstructorSymbol superCtorRef = this.serializableSyntheticConstructor(superClass);
        List<SerializableProperty> superProperties = SerializablePropertiesKt.serializablePropertiesFor$default(this.getBindingContext(), superClass.getDescriptor(), null, 2, null).getSerializableProperties();
        int superSlots = SerializablePropertiesKt.bitMaskSlotCount(superProperties);
        List arguments = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)allValueParameters.subList(0, superSlots), (Iterable)allValueParameters.subList(propertiesStart, propertiesStart + superProperties.size())), (Object)CollectionsKt.last(allValueParameters));
        IrDelegatingConstructorCallImpl call = IrDelegatingConstructorCallImpl.Companion.fromSymbolDescriptor$default((IrDelegatingConstructorCallImpl.Companion)IrDelegatingConstructorCallImpl.Companion, (int)$this$generateSuperSerializableCall.getStartOffset(), (int)$this$generateSuperSerializableCall.getEndOffset(), (IrType)this.getCompilerContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)superCtorRef, (int)0, (int)0, (int)48, null);
        Iterable $this$forEachIndexed$iv = arguments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter;
            int n = index$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index = n;
            boolean bl7 = false;
            call.putValueArgument(index, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateSuperSerializableCall), (IrValueDeclaration)((IrValueDeclaration)parameter)));
        }
        this.insertTypeArgumentsForSuperClass(call, superClass);
        $this$generateSuperSerializableCall.unaryPlus((IrStatement)call);
        return superProperties.size();
    }

    @Override
    protected void generateWriteSelfMethod(@NotNull FunctionDescriptor methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        this.contributeFunction(this.irClass, methodDescriptor, true, (Function2<? super IrBlockBodyBuilder, ? super IrFunction, Unit>)((Function2)new Function2<IrBlockBodyBuilder, IrFunction, Unit>(this){
            final /* synthetic */ SerializableIrGenerator this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IrBlockBodyBuilder $this$contributeFunction, @NotNull IrFunction writeSelfFunction) {
                Intrinsics.checkNotNullParameter((Object)$this$contributeFunction, (String)"$this$contributeFunction");
                Intrinsics.checkNotNullParameter((Object)writeSelfFunction, (String)"writeSelfFunction");
                IrValueParameter objectToSerialize = (IrValueParameter)writeSelfFunction.getValueParameters().get(0);
                IrValueParameter localOutput = (IrValueParameter)writeSelfFunction.getValueParameters().get(1);
                IrValueParameter localSerialDesc = (IrValueParameter)writeSelfFunction.getValueParameters().get(2);
                List<SerializableProperty> serializableProperties = SerializableIrGenerator.access$getProperties(this.this$0).getSerializableProperties();
                ClassDescriptor kOutputClass = SearchUtilsKt.getClassFromSerializationPackage(SerializableIrGenerator.access$getSerializableDescriptor(this.this$0), "CompositeEncoder");
                Function1<ValueParameterDescriptor, IrExpression> propertyByParamReplacer = this.this$0.createPropertyByParamReplacer((IrBuilderWithScope)$this$contributeFunction, this.this$0.getIrClass(), serializableProperties, objectToSerialize, this.this$0.getBindingContext());
                IrValueParameter irValueParameter = this.this$0.getIrClass().getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                IrValueParameterSymbol thisSymbol = irValueParameter.getSymbol();
                Function1<IrExpressionBody, IrExpression> initializerAdapter2 = this.this$0.createInitializerAdapter(this.this$0.getIrClass(), propertyByParamReplacer, (Pair<? extends IrValueSymbol, ? extends Function0<? extends IrExpression>>)TuplesKt.to((Object)thisSymbol, (Object)new Function0<IrGetValueImpl>($this$contributeFunction, objectToSerialize){
                    final /* synthetic */ IrBlockBodyBuilder $this_contributeFunction;
                    final /* synthetic */ IrValueParameter $objectToSerialize;
                    {
                        this.$this_contributeFunction = $this_contributeFunction;
                        this.$objectToSerialize = $objectToSerialize;
                        super(0);
                    }

                    @NotNull
                    public final IrGetValueImpl invoke() {
                        return ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)this.$this_contributeFunction), (IrValueDeclaration)((IrValueDeclaration)this.$objectToSerialize));
                    }
                }));
                int ignoreIndexTo = -1;
                IrClass superClass = this.this$0.getSuperClassOrAny(this.this$0.getIrClass());
                if (KSerializationUtilKt.isInternalSerializable(superClass.getDescriptor())) {
                    ignoreIndexTo = SerializablePropertiesKt.serializablePropertiesFor$default(this.this$0.getBindingContext(), superClass.getDescriptor(), null, 2, null).getSize();
                    Object superWriteSelfF = null;
                    superWriteSelfF = this.this$0.findWriteSelfMethod(superClass);
                    if (superWriteSelfF != null) {
                        Collection<IrType> collection;
                        TypeProjection arg;
                        Collection collection2;
                        Iterable $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        Object object;
                        int n;
                        ClassDescriptor p0;
                        IrElement irElement;
                        IrSimpleFunction key$iv;
                        if (superWriteSelfF.getDispatchReceiverParameter() != null) {
                            Object object2;
                            void $this$getOrPut$iv;
                            Map<IrSimpleFunction, IrSimpleFunction> map = this.this$0.getCompilerContext().getCopiedStaticWriteSelf$kotlinx_serialization_compiler_plugin();
                            key$iv = superWriteSelfF;
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                void p1;
                                boolean bl = false;
                                IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)superWriteSelfF;
                                boolean $i$f$deepCopyWithSymbols = false;
                                DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                                IrElementVisitorVoidKt.acceptVoid((IrElement)$this$deepCopyWithSymbols_u24default$iv, (IrElementVisitorVoid)((IrElementVisitorVoid)symbolRemapper$iv));
                                DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper((SymbolRemapper)symbolRemapper$iv);
                                TypeRemapper typeRemapper = (TypeRemapper)typeRemapper$iv;
                                SymbolRemapper symbolRemapper = (SymbolRemapper)symbolRemapper$iv;
                                irElement = $this$deepCopyWithSymbols_u24default$iv;
                                DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)p1);
                                IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irElement.transform((IrElementTransformer)deepCopyIrTreeWithSymbols, null), (IrDeclarationParent)((IrDeclarationParent)superClass));
                                if (irElement2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
                                }
                                $this$deepCopyWithSymbols_u24default$iv = (IrElement)((IrSimpleFunction)irElement2);
                                n = 0;
                                $i$f$deepCopyWithSymbols = false;
                                IrSimpleFunction it = (IrSimpleFunction)$this$deepCopyWithSymbols_u24default$iv;
                                boolean bl2 = false;
                                it.setDispatchReceiverParameter(null);
                                IrSimpleFunction answer$iv = object = (IrSimpleFunction)$this$deepCopyWithSymbols_u24default$iv;
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object2 = answer$iv;
                            } else {
                                object2 = value$iv;
                            }
                            superWriteSelfF = object2;
                        }
                        key$iv = new IrSimpleFunction[]{(IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeFunction), (IrValueDeclaration)((IrValueDeclaration)objectToSerialize)), (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeFunction), (IrValueDeclaration)((IrValueDeclaration)localOutput)), (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$contributeFunction), (IrValueDeclaration)((IrValueDeclaration)localSerialDesc))};
                        List args2 = CollectionsKt.mutableListOf((Object[])key$iv);
                        Collection $i$f$getOrPut = SerializableIrGenerator.access$getSerializableDescriptor(this.this$0).getTypeConstructor().getSupertypes();
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$getOrPut, (String)"serializableDescriptor.typeConstructor.supertypes");
                        Iterable $this$single$iv = $i$f$getOrPut;
                        boolean $i$f$single22 = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $this$single$iv) {
                            KotlinType it = (KotlinType)element$iv;
                            boolean bl = false;
                            p0 = KSerializationUtilKt.toClassDescriptor(it);
                            if (!(p0 == null ? false : KSerializationUtilKt.isInternalSerializable(p0))) continue;
                            if (found$iv) {
                                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        List typeArgsForParent = ((KotlinType)single$iv).getArguments();
                        Iterable $i$f$single22 = typeArgsForParent;
                        SerializableIrGenerator serializableIrGenerator = this.this$0;
                        boolean $i$f$map = false;
                        Iterator<T> $i$f$deepCopyWithSymbols = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv) {
                            irElement = (TypeProjection)item$iv$iv;
                            collection2 = destination$iv$iv;
                            boolean bl = false;
                            n = SerializableIrGenerator.access$getSerializableDescriptor(serializableIrGenerator).getDefaultType().getArguments().indexOf(arg);
                            boolean bl3 = false;
                            boolean bl4 = false;
                            int it = n;
                            boolean bl5 = false;
                            Integer genericIdx = it == -1 ? null : Integer.valueOf(it);
                            AbstractSerialGenerator abstractSerialGenerator = serializableIrGenerator;
                            ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)SerializableIrGenerator.access$getSerializableDescriptor(serializableIrGenerator)));
                            KotlinType kotlinType = arg.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arg.type");
                            ClassDescriptor serial = TypeUtilKt.findTypeSerializerOrContext$default(abstractSerialGenerator, moduleDescriptor, kotlinType, null, 4, null);
                            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$contributeFunction;
                            AbstractSerialGenerator abstractSerialGenerator2 = serializableIrGenerator;
                            ModuleDescriptor moduleDescriptor2 = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)SerializableIrGenerator.access$getSerializableDescriptor(serializableIrGenerator)));
                            kotlinType = arg.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arg.type");
                            Intrinsics.checkNotNull((Object)serializableIrGenerator.serializerInstance(irBuilderWithScope, abstractSerialGenerator2, serial, moduleDescriptor2, kotlinType, genericIdx, (Function2<? super Integer, ? super KotlinType, ? extends IrExpression>)((Function2)new Function2<Integer, KotlinType, IrExpression>($this$contributeFunction, writeSelfFunction){
                                final /* synthetic */ IrBlockBodyBuilder $this_contributeFunction;
                                final /* synthetic */ IrFunction $writeSelfFunction;
                                {
                                    this.$this_contributeFunction = $this_contributeFunction;
                                    this.$writeSelfFunction = $writeSelfFunction;
                                    super(2);
                                }

                                @NotNull
                                public final IrExpression invoke(int it, @NotNull KotlinType $noName_1) {
                                    Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                                    return (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)this.$this_contributeFunction), (IrValueDeclaration)((IrValueDeclaration)this.$writeSelfFunction.getValueParameters().get(3 + it)));
                                }
                            })));
                            collection2.add(object);
                        }
                        List parentWriteSelfSerializers2 = (List)destination$iv$iv;
                        $this$map$iv = typeArgsForParent;
                        serializableIrGenerator = this.this$0;
                        IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)superWriteSelfF.getSymbol();
                        IrExpression irExpression = null;
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$contributeFunction;
                        object = this.this$0;
                        collection2 = $this$contributeFunction;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            arg = (TypeProjection)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            KotlinType kotlinType = it.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                            IrType irType = serializableIrGenerator.toIrType(kotlinType);
                            collection.add(irType);
                        }
                        collection = (List)destination$iv$iv;
                        collection2.unaryPlus((IrStatement)IrBuilderExtension.DefaultImpls.irInvoke$default((IrBuilderExtension)object, irBuilderWithScope, irExpression, irFunctionSymbol, (List)collection, CollectionsKt.plus((Collection)args2, (Iterable)parentWriteSelfSerializers2), null, 16, null));
                    }
                }
                this.this$0.serializeAllProperties($this$contributeFunction, this.this$0, this.this$0.getIrClass(), serializableProperties, (IrValueDeclaration)objectToSerialize, (IrValueDeclaration)localOutput, (IrValueDeclaration)localSerialDesc, kOutputClass, ignoreIndexTo, initializerAdapter2, (Function2<? super Integer, ? super KotlinType, ? extends IrExpression>)((Function2)new Function2<Integer, KotlinType, IrExpression>($this$contributeFunction, writeSelfFunction){
                    final /* synthetic */ IrBlockBodyBuilder $this_contributeFunction;
                    final /* synthetic */ IrFunction $writeSelfFunction;
                    {
                        this.$this_contributeFunction = $this_contributeFunction;
                        this.$writeSelfFunction = $writeSelfFunction;
                        super(2);
                    }

                    @NotNull
                    public final IrExpression invoke(int it, @NotNull KotlinType $noName_1) {
                        Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                        return (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)this.$this_contributeFunction), (IrValueDeclaration)((IrValueDeclaration)this.$writeSelfFunction.getValueParameters().get(3 + it)));
                    }
                }));
            }
        }));
    }

    @Override
    @NotNull
    public <T extends IrDeclaration> T buildWithScope(@NotNull T $this$buildWithScope, @NotNull Function1<? super T, Unit> builder) {
        return IrBuilderExtension.DefaultImpls.buildWithScope(this, $this$buildWithScope, builder);
    }

    @Override
    @NotNull
    public List<IrConstructorCall> collectSerialInfoAnnotations(@NotNull IrClass irClass) {
        return IrBuilderExtension.DefaultImpls.collectSerialInfoAnnotations(this, irClass);
    }

    @Override
    @NotNull
    public IrClassReference createClassReference(@NotNull KotlinType classType, int startOffset, int endOffset) {
        return IrBuilderExtension.DefaultImpls.createClassReference((IrBuilderExtension)this, classType, startOffset, endOffset);
    }

    @Override
    @NotNull
    public IrClassReference createClassReference(@NotNull IrClass irClass, int startOffset, int endOffset) {
        return IrBuilderExtension.DefaultImpls.createClassReference((IrBuilderExtension)this, irClass, startOffset, endOffset);
    }

    @Override
    @NotNull
    public IrProperty createCompanionValProperty(@NotNull IrClass companionClass, @NotNull IrType type, @NotNull Name name, @NotNull Function1<? super IrBlockBodyBuilder, Unit> initializerBuilder) {
        return IrBuilderExtension.DefaultImpls.createCompanionValProperty(this, companionClass, type, name, initializerBuilder);
    }

    @Override
    @NotNull
    public Function1<IrExpressionBody, IrExpression> createInitializerAdapter(@NotNull IrClass irClass, @NotNull Function1<? super ValueParameterDescriptor, ? extends IrExpression> paramGetReplacer, @Nullable Pair<? extends IrValueSymbol, ? extends Function0<? extends IrExpression>> thisGetReplacer) {
        return IrBuilderExtension.DefaultImpls.createInitializerAdapter(this, irClass, paramGetReplacer, thisGetReplacer);
    }

    @Override
    @NotNull
    public IrProperty createLazyProperty(@NotNull IrClass containingClass, @NotNull IrType targetIrType, @NotNull Name name, @NotNull Function1<? super IrBlockBodyBuilder, Unit> initializerBuilder) {
        return IrBuilderExtension.DefaultImpls.createLazyProperty(this, containingClass, targetIrType, name, initializerBuilder);
    }

    @Override
    @NotNull
    public IrFunction findEnumValuesMethod(@NotNull ClassDescriptor enumClass) {
        return IrBuilderExtension.DefaultImpls.findEnumValuesMethod(this, enumClass);
    }

    @Override
    @NotNull
    public IrExpression generateReceiverExpressionForFieldAccess(@NotNull IrValueSymbol ownerSymbol, @NotNull PropertyDescriptor property2) {
        return IrBuilderExtension.DefaultImpls.generateReceiverExpressionForFieldAccess(this, ownerSymbol, property2);
    }

    @Override
    @NotNull
    public IrProperty generateSimplePropertyWithBackingField(@NotNull PropertyDescriptor propertyDescriptor, @NotNull IrClass propertyParent, @NotNull Name fieldName) {
        return IrBuilderExtension.DefaultImpls.generateSimplePropertyWithBackingField(this, propertyDescriptor, propertyParent, fieldName);
    }

    @Override
    @NotNull
    public SimpleType kClassTypeFor(@NotNull TypeProjection projection) {
        return IrBuilderExtension.DefaultImpls.kClassTypeFor(this, projection);
    }

    @Override
    @NotNull
    public IrFunctionSymbol referenceFunctionSymbol(@NotNull ClassDescriptor $this$referenceFunctionSymbol, @NotNull String functionName, @NotNull Function1<? super IrSimpleFunction, Boolean> predicate) {
        return IrBuilderExtension.DefaultImpls.referenceFunctionSymbol(this, $this$referenceFunctionSymbol, functionName, predicate);
    }

    @Override
    @NotNull
    public IrExpression formEncodeDecodePropertyCall(@NotNull IrBlockBodyBuilder $this$formEncodeDecodePropertyCall, @NotNull AbstractSerialGenerator enclosingGenerator, @NotNull IrExpression encoder, @NotNull SerializableProperty property2, @NotNull Function2<? super IrExpression, ? super SerialTypeInfo, ? extends Pair<? extends IrFunctionSymbol, ? extends List<? extends IrExpression>>> whenHaveSerializer, @NotNull Function1<? super SerialTypeInfo, ? extends Pair<? extends IrFunctionSymbol, ? extends List<? extends IrExpression>>> whenDoNot, @Nullable Function2<? super Integer, ? super KotlinType, ? extends IrExpression> genericGetter, @Nullable IrType returnTypeHint) {
        return IrBuilderExtension.DefaultImpls.formEncodeDecodePropertyCall(this, $this$formEncodeDecodePropertyCall, enclosingGenerator, encoder, property2, whenHaveSerializer, whenDoNot, genericGetter, returnTypeHint);
    }

    @Override
    public void generateGoldenMaskCheck(@NotNull IrBlockBodyBuilder $this$generateGoldenMaskCheck, @NotNull List<? extends IrValueDeclaration> seenVars, @NotNull SerializableProperties properties, @NotNull IrExpression serialDescriptor) {
        IrBuilderExtension.DefaultImpls.generateGoldenMaskCheck(this, $this$generateGoldenMaskCheck, seenVars, properties, serialDescriptor);
    }

    @Override
    @NotNull
    public IrExpression getLazyValueExpression(@NotNull IrBlockBodyBuilder $this$getLazyValueExpression, @NotNull IrValueParameter thisParam, @NotNull IrProperty property2, @NotNull IrType type) {
        return IrBuilderExtension.DefaultImpls.getLazyValueExpression(this, $this$getLazyValueExpression, thisParam, property2, type);
    }

    @Override
    public void serializeAllProperties(@NotNull IrBlockBodyBuilder $this$serializeAllProperties, @NotNull AbstractSerialGenerator generator, @NotNull IrClass serializableIrClass, @NotNull List<SerializableProperty> serializableProperties, @NotNull IrValueDeclaration objectToSerialize, @NotNull IrValueDeclaration localOutput, @NotNull IrValueDeclaration localSerialDesc, @NotNull ClassDescriptor kOutputClass, int ignoreIndexTo, @NotNull Function1<? super IrExpressionBody, ? extends IrExpression> initializerAdapter2, @Nullable Function2<? super Integer, ? super KotlinType, ? extends IrExpression> genericGetter) {
        IrBuilderExtension.DefaultImpls.serializeAllProperties(this, $this$serializeAllProperties, generator, serializableIrClass, serializableProperties, objectToSerialize, localOutput, localSerialDesc, kOutputClass, ignoreIndexTo, initializerAdapter2, genericGetter);
    }

    @Override
    @Nullable
    public IrExpression callSerializerFromCompanion(@NotNull IrBuilderWithScope $this$callSerializerFromCompanion, @NotNull IrType thisIrType, @NotNull List<? extends IrType> typeArgs, @NotNull List<? extends IrExpression> args2) {
        return IrBuilderExtension.DefaultImpls.callSerializerFromCompanion(this, $this$callSerializerFromCompanion, thisIrType, typeArgs, args2);
    }

    @Override
    @NotNull
    public IrClassReference classReference(@NotNull IrBuilderWithScope $this$classReference, @NotNull KotlinType classType) {
        return IrBuilderExtension.DefaultImpls.classReference(this, $this$classReference, classType);
    }

    @Override
    @NotNull
    public List<IrExpression> copyAnnotationsFrom(@NotNull IrBuilderWithScope $this$copyAnnotationsFrom, @NotNull List<? extends IrConstructorCall> annotations) {
        return IrBuilderExtension.DefaultImpls.copyAnnotationsFrom(this, $this$copyAnnotationsFrom, annotations);
    }

    @Override
    @NotNull
    public IrExpression createArrayOfExpression(@NotNull IrBuilderWithScope $this$createArrayOfExpression, @NotNull IrType arrayElementType, @NotNull List<? extends IrExpression> arrayElements) {
        return IrBuilderExtension.DefaultImpls.createArrayOfExpression(this, $this$createArrayOfExpression, arrayElementType, arrayElements);
    }

    @Override
    @NotNull
    public IrExpression createPrimitiveArrayOfExpression(@NotNull IrBuilderWithScope $this$createPrimitiveArrayOfExpression, @NotNull IrType elementPrimitiveType, @NotNull List<? extends IrExpression> arrayElements) {
        return IrBuilderExtension.DefaultImpls.createPrimitiveArrayOfExpression(this, $this$createPrimitiveArrayOfExpression, elementPrimitiveType, arrayElements);
    }

    @Override
    @NotNull
    public Function1<ValueParameterDescriptor, IrExpression> createPropertyByParamReplacer(@NotNull IrBuilderWithScope $this$createPropertyByParamReplacer, @NotNull IrClass irClass, @NotNull List<SerializableProperty> serialProperties, @NotNull IrValueParameter instance, @NotNull BindingContext bindingContext) {
        return IrBuilderExtension.DefaultImpls.createPropertyByParamReplacer(this, $this$createPropertyByParamReplacer, irClass, serialProperties, instance, bindingContext);
    }

    @Override
    public void generateAnySuperConstructorCall(@NotNull IrBuilderWithScope $this$generateAnySuperConstructorCall, @NotNull IrBlockBodyBuilder toBuilder) {
        IrBuilderExtension.DefaultImpls.generateAnySuperConstructorCall(this, $this$generateAnySuperConstructorCall, toBuilder);
    }

    @Override
    @NotNull
    public IrExpression getProperty(@NotNull IrBuilderWithScope $this$getProperty, @NotNull IrExpression receiver, @NotNull IrProperty property2) {
        return IrBuilderExtension.DefaultImpls.getProperty(this, $this$getProperty, receiver, property2);
    }

    @Override
    @NotNull
    public IrExpression irBinOp(@NotNull IrBuilderWithScope $this$irBinOp, @NotNull Name name, @NotNull IrExpression lhs, @NotNull IrExpression rhs) {
        return IrBuilderExtension.DefaultImpls.irBinOp(this, $this$irBinOp, name, lhs, rhs);
    }

    @Override
    @NotNull
    public IrVarargImpl irEmptyVararg(@NotNull IrBuilderWithScope $this$irEmptyVararg, @NotNull ValueParameterDescriptor forValueParameter) {
        return IrBuilderExtension.DefaultImpls.irEmptyVararg(this, $this$irEmptyVararg, forValueParameter);
    }

    @Override
    @NotNull
    public IrGetObjectValueImpl irGetObject(@NotNull IrBuilderWithScope $this$irGetObject, @NotNull ClassDescriptor classDescriptor) {
        return IrBuilderExtension.DefaultImpls.irGetObject((IrBuilderExtension)this, $this$irGetObject, classDescriptor);
    }

    @Override
    @NotNull
    public IrGetObjectValueImpl irGetObject(@NotNull IrBuilderWithScope $this$irGetObject, @NotNull IrClass irObject) {
        return IrBuilderExtension.DefaultImpls.irGetObject((IrBuilderExtension)this, $this$irGetObject, irObject);
    }

    @Override
    @NotNull
    public IrMemberAccessExpression<?> irInvoke(@NotNull IrBuilderWithScope $this$irInvoke, @Nullable IrExpression dispatchReceiver, @NotNull IrFunctionSymbol callee, @NotNull List<? extends IrType> typeArguments, @NotNull List<? extends IrExpression> valueArguments, @Nullable IrType returnTypeHint) {
        return IrBuilderExtension.DefaultImpls.irInvoke(this, $this$irInvoke, dispatchReceiver, callee, typeArguments, valueArguments, returnTypeHint);
    }

    @Override
    @NotNull
    public IrMemberAccessExpression<?> irInvoke(@NotNull IrBuilderWithScope $this$irInvoke, @Nullable IrExpression dispatchReceiver, @NotNull IrFunctionSymbol callee, @NotNull IrExpression[] args2, @Nullable IrType typeHint) {
        return IrBuilderExtension.DefaultImpls.irInvoke(this, $this$irInvoke, dispatchReceiver, callee, args2, typeHint);
    }

    @Override
    @NotNull
    public IrWhen irWhen(@NotNull IrBuilderWithScope $this$irWhen, @Nullable IrType typeHint, @NotNull Function1<? super IrBuilderExtension.BranchBuilder, Unit> block) {
        return IrBuilderExtension.DefaultImpls.irWhen(this, $this$irWhen, typeHint, block);
    }

    @Override
    @Nullable
    public IrExpression serializerInstance(@NotNull IrBuilderWithScope $this$serializerInstance, @NotNull AbstractSerialGenerator enclosingGenerator, @Nullable ClassDescriptor serializerClassOriginal, @NotNull ModuleDescriptor module, @NotNull KotlinType kType, @Nullable Integer genericIndex, @Nullable Function2<? super Integer, ? super KotlinType, ? extends IrExpression> genericGetter) {
        return IrBuilderExtension.DefaultImpls.serializerInstance((IrBuilderExtension)this, $this$serializerInstance, enclosingGenerator, serializerClassOriginal, module, kType, genericIndex, genericGetter);
    }

    @Override
    @Nullable
    public IrExpression serializerInstance(@NotNull IrBuilderWithScope $this$serializerInstance, @NotNull SerializerIrGenerator enclosingGenerator, @NotNull IrValueParameter dispatchReceiverParameter, @Nullable ClassDescriptor serializerClassOriginal, @NotNull ModuleDescriptor module, @NotNull KotlinType kType, @Nullable Integer genericIndex) {
        return IrBuilderExtension.DefaultImpls.serializerInstance((IrBuilderExtension)this, $this$serializerInstance, enclosingGenerator, dispatchReceiverParameter, serializerClassOriginal, module, kType, genericIndex);
    }

    @Override
    @Nullable
    public IrExpression serializerTower(@NotNull IrBuilderWithScope $this$serializerTower, @NotNull SerializerIrGenerator generator, @NotNull IrValueParameter dispatchReceiverParameter, @NotNull SerializableProperty property2) {
        return IrBuilderExtension.DefaultImpls.serializerTower(this, $this$serializerTower, generator, dispatchReceiverParameter, property2);
    }

    @Override
    @NotNull
    public IrExpression setProperty(@NotNull IrBuilderWithScope $this$setProperty, @NotNull IrExpression receiver, @NotNull IrProperty property2, @NotNull IrExpression value) {
        return IrBuilderExtension.DefaultImpls.setProperty(this, $this$setProperty, receiver, property2, value);
    }

    @Override
    public void contributeAnonymousInitializer(@NotNull IrClass $this$contributeAnonymousInitializer, @NotNull Function1<? super IrBlockBodyBuilder, Unit> bodyGen) {
        IrBuilderExtension.DefaultImpls.contributeAnonymousInitializer(this, $this$contributeAnonymousInitializer, bodyGen);
    }

    @Override
    public void contributeConstructor(@NotNull IrClass $this$contributeConstructor, @NotNull ClassConstructorDescriptor descriptor, boolean declareNew, boolean overwriteValueParameters, @NotNull Function2<? super IrBlockBodyBuilder, ? super IrConstructor, Unit> bodyGen) {
        IrBuilderExtension.DefaultImpls.contributeConstructor(this, $this$contributeConstructor, descriptor, declareNew, overwriteValueParameters, bodyGen);
    }

    @Override
    public void contributeFunction(@NotNull IrClass $this$contributeFunction, @NotNull FunctionDescriptor descriptor, boolean ignoreWhenMissing, @NotNull Function2<? super IrBlockBodyBuilder, ? super IrFunction, Unit> bodyGen) {
        IrBuilderExtension.DefaultImpls.contributeFunction(this, $this$contributeFunction, descriptor, ignoreWhenMissing, bodyGen);
    }

    @Override
    @NotNull
    public IrFunctionExpression createLambdaExpression(@NotNull IrClass $this$createLambdaExpression, @NotNull IrType type, @NotNull Function1<? super IrBlockBodyBuilder, Unit> bodyGen) {
        return IrBuilderExtension.DefaultImpls.createLambdaExpression(this, $this$createLambdaExpression, type, bodyGen);
    }

    @Override
    @Nullable
    public IrSimpleFunction findWriteSelfMethod(@NotNull IrClass $this$findWriteSelfMethod) {
        return IrBuilderExtension.DefaultImpls.findWriteSelfMethod(this, $this$findWriteSelfMethod);
    }

    @Override
    @Nullable
    public IrClass getSuperClassNotAny(@NotNull IrClass $this$getSuperClassNotAny) {
        return IrBuilderExtension.DefaultImpls.getSuperClassNotAny(this, $this$getSuperClassNotAny);
    }

    @Override
    @NotNull
    public IrClass getSuperClassOrAny(@NotNull IrClass $this$getSuperClassOrAny) {
        return IrBuilderExtension.DefaultImpls.getSuperClassOrAny(this, $this$getSuperClassOrAny);
    }

    @Override
    @NotNull
    public IrProperty searchForProperty(@NotNull IrClass $this$searchForProperty, @NotNull PropertyDescriptor descriptor) {
        return IrBuilderExtension.DefaultImpls.searchForProperty(this, $this$searchForProperty, descriptor);
    }

    @Override
    public void copyTypeParamsFromDescriptor(@NotNull IrFunction $this$copyTypeParamsFromDescriptor, @NotNull FunctionDescriptor descriptor) {
        IrBuilderExtension.DefaultImpls.copyTypeParamsFromDescriptor(this, $this$copyTypeParamsFromDescriptor, descriptor);
    }

    @Override
    public void createParameterDeclarations(@NotNull IrFunction $this$createParameterDeclarations, @NotNull FunctionDescriptor descriptor, boolean overwriteValueParameters, boolean copyTypeParameters) {
        IrBuilderExtension.DefaultImpls.createParameterDeclarations(this, $this$createParameterDeclarations, descriptor, overwriteValueParameters, copyTypeParameters);
    }

    @Override
    @Nullable
    public Boolean getEncodeDefaultAnnotationValue(@NotNull IrProperty $this$getEncodeDefaultAnnotationValue) {
        return IrBuilderExtension.DefaultImpls.getEncodeDefaultAnnotationValue(this, $this$getEncodeDefaultAnnotationValue);
    }

    @Override
    @NotNull
    public IrType toIrType(@NotNull KotlinType $this$toIrType) {
        return IrBuilderExtension.DefaultImpls.toIrType(this, $this$toIrType);
    }

    @Override
    @NotNull
    public IrElseBranch elseBranch(@NotNull IrBuilderExtension.BranchBuilder $this$elseBranch, @NotNull IrExpression result) {
        return IrBuilderExtension.DefaultImpls.elseBranch(this, $this$elseBranch, result);
    }

    @Override
    @NotNull
    public IrProperty getIrPropertyFrom(@NotNull SerializableProperty $this$getIrPropertyFrom, @NotNull IrClass thisClass) {
        return IrBuilderExtension.DefaultImpls.getIrPropertyFrom(this, $this$getIrPropertyFrom, thisClass);
    }

    @Override
    @NotNull
    public IrConstructorSymbol serializableSyntheticConstructor(@NotNull IrClass forClass) {
        return IrBuilderExtension.DefaultImpls.serializableSyntheticConstructor(this, forClass);
    }

    @Override
    public boolean useFieldMissingOptimization() {
        return IrBuilderExtension.DefaultImpls.useFieldMissingOptimization(this);
    }

    @Override
    @NotNull
    public IrType wrapIrTypeIntoKSerializerIrType(@NotNull ModuleDescriptor module, @NotNull IrType type, @NotNull Variance variance) {
        return IrBuilderExtension.DefaultImpls.wrapIrTypeIntoKSerializerIrType(this, module, type, variance);
    }

    @Override
    @NotNull
    public IrField getIrField(@NotNull SerializableProperty $this$irField) {
        return IrBuilderExtension.DefaultImpls.getIrField(this, $this$irField);
    }

    public static final /* synthetic */ SerializableProperties access$getProperties(SerializableIrGenerator $this) {
        return $this.getProperties();
    }

    public static final /* synthetic */ ClassDescriptor access$getSerializableDescriptor(SerializableIrGenerator $this) {
        return $this.getSerializableDescriptor();
    }

    public static final /* synthetic */ IrExpression access$getStaticSerialDescriptorExpr(SerializableIrGenerator $this, IrBlockBodyBuilder $receiver) {
        return $this.getStaticSerialDescriptorExpr($receiver);
    }

    public static final /* synthetic */ IrExpression access$getParametrizedSerialDescriptorExpr(SerializableIrGenerator $this, IrBlockBodyBuilder $receiver, IrClass companionObject, IrProperty property2) {
        return $this.getParametrizedSerialDescriptorExpr($receiver, companionObject, property2);
    }

    public static final /* synthetic */ IrProperty access$createCachedDescriptorProperty(SerializableIrGenerator $this, IrBlockBodyBuilder $receiver, IrClass companionObject) {
        return $this.createCachedDescriptorProperty($receiver, companionObject);
    }

    public static final /* synthetic */ boolean access$isInternalSerializable(SerializableIrGenerator $this, IrClass $receiver) {
        return $this.isInternalSerializable($receiver);
    }

    public static final /* synthetic */ int access$generateSuperSerializableCall(SerializableIrGenerator $this, IrBlockBodyBuilder $receiver, IrClass superClass, List allValueParameters, int propertiesStart) {
        return $this.generateSuperSerializableCall($receiver, superClass, allValueParameters, propertiesStart);
    }

    public static final /* synthetic */ void access$generateSuperNonSerializableCall(SerializableIrGenerator $this, IrBlockBodyBuilder $receiver, IrClass superClass) {
        $this.generateSuperNonSerializableCall($receiver, superClass);
    }

    public static final /* synthetic */ IrExpression access$getInstantiateDescriptorExpr(SerializableIrGenerator $this, IrBlockBodyBuilder $receiver) {
        return $this.getInstantiateDescriptorExpr($receiver);
    }

    public static final /* synthetic */ IrExpression access$getAddElementToDescriptorExpr(SerializableIrGenerator $this, IrBlockBodyBuilder $receiver, SerializableProperty property2, IrVariable serialDescVar) {
        return $this.getAddElementToDescriptorExpr($receiver, property2, serialDescVar);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializableIrGenerator$Companion;", "", "()V", "generate", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlinx-serialization-compiler-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void generate(@NotNull IrClass irClass, @NotNull SerializationPluginContext context, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            ClassDescriptor serializableClass = irClass.getDescriptor();
            if (KSerializationUtilKt.isInternalSerializable(serializableClass)) {
                new SerializableIrGenerator(irClass, context, bindingContext).generate();
                PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irClass), (IrDeclarationParent)irClass.getParent());
            } else if (SerializationPluginDeclarationCheckerKt.getSerializableAnnotationIsUseless(serializableClass)) {
                throw new CompilationException("@Serializable annotation on " + serializableClass + " would be ignored because it is impossible to serialize it automatically. Provide serializer manually via e.g. companion object", null, SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)serializableClass)));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

