/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactoryKt;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedValueConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0085\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n*\u0001\u0011\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001uB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\tH\u0002J(\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J*\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001e\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 \u0018\u00010\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0002J0\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J$\u0010*\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0018\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\"\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010-2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u001e\u00106\u001a\u0004\u0018\u00010-2\n\u00107\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003J*\u00109\u001a\u0004\u0018\u00010\u00192\u0006\u0010:\u001a\u00020-2\u0006\u00104\u001a\u00020-2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0015H\u0002J2\u0010>\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010=\u001a\u00020\u00152\u0006\u0010?\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010@\u001a\u00020\tH\u0002J\"\u0010A\u001a\u0004\u0018\u00010\u00192\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0015H\u0002J\u0012\u0010B\u001a\u0004\u0018\u0001002\u0006\u0010C\u001a\u00020\u0003H\u0002J\u0010\u0010D\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010E\u001a\u00020\t2\u0006\u0010;\u001a\u00020<2\b\u00104\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010J\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020 2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0 2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001c\u0010N\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010O\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0010\u0010P\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010Q\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010R\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020S2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020U2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010V\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020W2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010X\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020Y2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020[2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\\\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020]2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010^\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010_\u001a\u00020`2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010g\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020h2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010i\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020j2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010k\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020l2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010m\u001a\u0006\u0012\u0002\b\u00030\u001f*\u00020+2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002Jn\u0010n\u001a\b\u0012\u0004\u0012\u0002Ho0\u001f\"\u0004\b\u0000\u0010o*\b\u0012\u0004\u0012\u0002Ho0!2\b\b\u0002\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010p\u001a\u00020\t2\b\b\u0002\u0010q\u001a\u00020\t2\b\b\u0002\u0010r\u001a\u00020\t2\b\b\u0002\u0010Q\u001a\u00020\t2\b\b\u0002\u0010P\u001a\u00020\t2\b\b\u0002\u0010s\u001a\u00020\t2\b\b\u0002\u0010t\u001a\u00020\tH\u0002J&\u0010n\u001a\b\u0012\u0004\u0012\u0002Ho0\u001f\"\u0004\b\u0000\u0010o*\b\u0012\u0004\u0012\u0002Ho0!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/types/KotlinType;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isIndependentContext", "", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "defaultValueForDontCreateIntegerLiteralType", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "stringExpressionEvaluator", "org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "canBeUsedInAnnotation", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkAccessibilityOfUnsignedTypes", "createCompileTimeConstant", "value", "", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "expectedType", "createConstant", "createConstantValueForArrayFunctionCall", "Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "createConstantValueForUnsignedTypeConstructor", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "representation", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "Lorg/jetbrains/kotlin/types/SimpleType;", "createIntegerCompileTimeConstant", "", "createOperationArgument", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "parameterType", "compileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "createOperationArgumentForFirstParameter", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createOperationArgumentForReceiver", "resolvedCall", "evaluate", "evaluateBinaryAndCheck", "receiver", "name", "", "callExpression", "evaluateCall", "receiverExpression", "isUnaryPlusMinus", "evaluateUnaryAndCheck", "getCompileTimeType", "c", "hasIntegerLiteralType", "isDivisionByZero", "isPropertyCompileTimeConstant", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "isPureConstant", "isStandaloneOnlyConstant", "resolveArguments", "valueArguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "shouldSkipComplexBooleanValue", "constant", "usesNonConstValAsConstant", "usesVariableAsConstant", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitCollectionLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "createSimpleIntCompileTimeConst", "wrap", "T", "isPure", "isUnsigned", "isUnsignedLong", "isConvertableConstVal", "dontCreateILT", "OperationArgument", "frontend"})
final class ConstantExpressionEvaluatorVisitor
extends KtVisitor<CompileTimeConstant<?>, KotlinType> {
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    private final boolean isIndependentContext;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final KotlinBuiltIns builtIns;
    private final boolean defaultValueForDontCreateIntegerLiteralType;
    @NotNull
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace, boolean isIndependentContext) {
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.isIndependentContext = isIndependentContext;
        this.languageVersionSettings = this.constantExpressionEvaluator.getLanguageVersionSettings$frontend();
        this.builtIns = this.constantExpressionEvaluator.getModule$frontend().getBuiltIns();
        this.defaultValueForDontCreateIntegerLiteralType = this.languageVersionSettings.supportsFeature(LanguageFeature.ApproximateIntegerLiteralTypesInReceiverPosition);
        this.stringExpressionEvaluator = new KtVisitor(this){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;
            {
                this.this$0 = $receiver;
            }

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                ConstantValue<?> constantValue = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(constantValue, "NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue2 = compileTimeConstant.toConstantValue((KotlinType)((Object)constantValue));
                if (ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constantValue2)) {
                    return null;
                }
                constantValue = constantValue2;
                if (constantValue instanceof ErrorValue ? true : constantValue instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap(this.this$0, constantValue instanceof NullValue ? new StringValue("null") : new StringValue(String.valueOf(constantValue2.boxedValue())), compileTimeConstant.getParameters());
            }

            @Nullable
            public final TypedCompileTimeConstant<String> evaluate(@NotNull KtStringTemplateEntry entry) {
                Intrinsics.checkNotNullParameter(entry, "entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            @Nullable
            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                Intrinsics.checkNotNullParameter(entry, "entry");
                Object object = entry.getExpression();
                if (object == null) {
                    return null;
                }
                Object object2 = object;
                Object expression2 = object2;
                if ((object2 = this.this$0.evaluate((KtExpression)expression2, ConstantExpressionEvaluatorVisitor.access$getBuiltIns$p(this.this$0).getStringType())) == null) {
                    typedCompileTimeConstant = null;
                } else {
                    object = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object;
                    boolean bl3 = false;
                    typedCompileTimeConstant = this.createStringConstant((CompileTimeConstant<?>)it);
                }
                return typedCompileTimeConstant;
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkNotNullParameter(entry, "entry");
                String string2 = entry.getText();
                Intrinsics.checkNotNullExpressionValue(string2, "entry.text");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string2), false, false, false, false, false, false, false, false, 255, null);
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkNotNullParameter(entry, "entry");
                String string2 = entry.getUnescapedValue();
                Intrinsics.checkNotNullExpressionValue(string2, "entry.unescapedValue");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string2), false, false, false, false, false, false, false, false, 255, null);
            }
        };
    }

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull KtExpression expression2, @Nullable KotlinType expectedType2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression2, bindingContext);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        KtVisitor ktVisitor = this;
        KotlinType kotlinType2 = expectedType2;
        if (kotlinType2 == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        } else {
            kotlinType = kotlinType2;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression2.accept(ktVisitor, kotlinType);
        if (compileTimeConstant != null) {
            if (this.shouldSkipComplexBooleanValue(expression2, compileTimeConstant)) {
                return null;
            }
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean shouldSkipComplexBooleanValue(KtExpression expression2, CompileTimeConstant<?> constant) {
        if (constant.isError()) {
            return false;
        }
        SimpleType simpleType2 = this.builtIns.getBooleanType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.booleanType");
        ConstantValue<?> constantValue = constant.toConstantValue(simpleType2);
        if (!TypeUtilsKt.isBoolean(constantValue.getType(this.constantExpressionEvaluator.getModule$frontend()))) {
            return false;
        }
        if (expression2 instanceof KtConstantExpression || constant.getParameters().getUsesVariableAsConstant()) {
            return false;
        }
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSimplificationOfNonTrivialConstBooleanExpressions)) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtWhenConditionWithExpression || parent2 instanceof KtContainerNode && (((KtContainerNode)parent2).getParent() instanceof KtWhileExpression || ((KtContainerNode)parent2).getParent() instanceof KtDoWhileExpression)) {
            Object obj = constantValue.getValue();
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            this.trace.report(Errors.NON_TRIVIAL_BOOLEAN_CONSTANT.on((KtExpression)((PsiElement)expression2), (boolean)((Boolean)obj)));
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable KotlinType expectedType2) {
        boolean isIntegerConstant;
        Serializable serializable;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        String string2 = expression2.getText();
        if (string2 == null) {
            return null;
        }
        String text2 = string2;
        IElementType iElementType = expression2.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "expression.node.elementType");
        IElementType nodeElementType = iElementType;
        if (Intrinsics.areEqual(nodeElementType, KtNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new NullValue(), false, false, false, false, false, false, false, false, 255, null);
        }
        IElementType iElementType2 = nodeElementType;
        if (Intrinsics.areEqual(iElementType2, KtNodeTypes.INTEGER_CONSTANT) ? true : Intrinsics.areEqual(iElementType2, KtNodeTypes.FLOAT_CONSTANT)) {
            serializable = ParseUtilsKt.parseNumericLiteral(text2, nodeElementType);
        } else if (Intrinsics.areEqual(iElementType2, KtNodeTypes.BOOLEAN_CONSTANT)) {
            serializable = Boolean.valueOf(ParseUtilsKt.parseBoolean(text2));
        } else if (Intrinsics.areEqual(iElementType2, KtNodeTypes.CHARACTER_CONSTANT)) {
            serializable = CompileTimeConstantChecker.parseChar(expression2);
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unsupported constant: ", expression2));
        }
        Serializable serializable2 = serializable;
        if (serializable2 == null) {
            return null;
        }
        Serializable result2 = serializable2;
        if (result2 instanceof Double) {
            double d = ((Number)result2).doubleValue();
            boolean bl = false;
            if (Double.isInfinite(d)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (((Number)result2).doubleValue() == 0.0 && !TypeConversionUtil.isFPZero(text2)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        if (result2 instanceof Float) {
            float f = ((Number)result2).floatValue();
            boolean bl = false;
            if (Float.isInfinite(f)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (((Number)result2).floatValue() == 0.0f && !TypeConversionUtil.isFPZero(text2)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        boolean isUnsignedLong = (isIntegerConstant = Intrinsics.areEqual(nodeElementType, KtNodeTypes.INTEGER_CONSTANT)) && ParseUtilsKt.hasUnsignedLongSuffix(text2);
        boolean isUnsigned = isUnsignedLong || ParseUtilsKt.hasUnsignedSuffix(text2);
        boolean isTyped = isUnsigned || ParseUtilsKt.hasLongSuffix(text2);
        return this.createConstant(result2, expectedType2, new CompileTimeConstant.Parameters(true, !isTyped, isUnsigned, isUnsignedLong, false, false, false, this.defaultValueForDontCreateIntegerLiteralType && this.isIndependentContext));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2);
        if (deparenthesizedExpression != null && !Intrinsics.areEqual(deparenthesizedExpression, expression2)) {
            return this.evaluate(deparenthesizedExpression, expectedType2);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull KtLabeledExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType2);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        boolean usesVariableAsConstant = false;
        boolean usesNonConstantVariableAsConstant = false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "expression.entries");
        KtStringTemplateEntry[] ktStringTemplateEntryArray2 = ktStringTemplateEntryArray;
        int n = 0;
        int n2 = ktStringTemplateEntryArray2.length;
        while (n < n2) {
            KtStringTemplateEntry entry = ktStringTemplateEntryArray2[n];
            ++n;
            Intrinsics.checkNotNullExpressionValue(entry, "entry");
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(entry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = true;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = true;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        return !interupted ? this.createConstant(sb.toString(), expectedType2, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, false, false, false, usesVariableAsConstant, usesNonConstantVariableAsConstant, false, false)) : null;
    }

    private final boolean isStandaloneOnlyConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        if (compileTimeConstant == null) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(compileTimeConstant);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkNotNullExpressionValue(ktExpression, "expression.left");
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression, expectedType2);
        if (compileTimeConstant != null && expectedType2 != null && !TypeUtils.noExpectedType(expectedType2)) {
            KotlinType kotlinType;
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
                kotlinType = ((TypedCompileTimeConstant)compileTimeConstant).getType();
            } else if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
                kotlinType = ((IntegerValueTypeConstant)compileTimeConstant).getType(expectedType2);
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus("Unexpected compileTimeConstant class: ", compileTimeConstant.getClass().getCanonicalName()));
            }
            KotlinType constantType = kotlinType;
            if (!TypeUtilsKt.isSubtypeOf(constantType, expectedType2)) {
                return null;
            }
        }
        return compileTimeConstant;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull KtBinaryExpression expression2, @Nullable KotlinType expectedType2) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Object object = expression2.getLeft();
        if (object == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression = object;
        object = expression2.getOperationToken();
        Intrinsics.checkNotNullExpressionValue(object, "expression.operationToken");
        ImmutableBiMap<KtSingleValueToken, Name> operationToken = object;
        object = OperatorConventions.BOOLEAN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(object, "BOOLEAN_OPERATIONS");
        object = (Map)object;
        boolean bl = false;
        if (object.containsKey(operationToken)) {
            boolean bl2;
            SimpleType simpleType2 = this.builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.booleanType");
            SimpleType booleanType = simpleType2;
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(leftExpression, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> leftConstant = compileTimeConstant;
            Object object2 = expression2.getRight();
            if (object2 == null) {
                return null;
            }
            Object object3 = object2;
            KtExpression rightExpression = object3;
            if ((object2 = this.evaluate(rightExpression, booleanType)) == null) {
                return null;
            }
            Object rightConstant = object2;
            Object leftValue = leftConstant.getValue(booleanType);
            Object rightValue = rightConstant.getValue(booleanType);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = operationToken;
            if (Intrinsics.areEqual(immutableBiMap, KtTokens.ANDAND)) {
                bl2 = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual(immutableBiMap, KtTokens.OROR)) {
                bl2 = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown boolean operation token ", operationToken));
            }
            boolean result2 = bl2;
            return this.createConstant(result2, expectedType2, new CompileTimeConstant.Parameters(true, false, false, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant(), false, false));
        }
        object = expression2.getOperationReference();
        Intrinsics.checkNotNullExpressionValue(object, "expression.operationReference");
        return ConstantExpressionEvaluatorVisitor.evaluateCall$default(this, (KtExpression)object, leftExpression, expectedType2, false, 8, null);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, @Nullable KotlinType expectedType2) {
        ResolvedCall resolvedCall2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        ResolvedCall resolvedCall3 = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall3 == null) {
            return null;
        }
        ResolvedCall resolvedCall4 = resolvedCall2 = resolvedCall3;
        return this.createConstantValueForArrayFunctionCall(resolvedCall4);
    }

    private final CompileTimeConstant<?> evaluateCall(KtExpression callExpression, KtExpression receiverExpression, KotlinType expectedType2, boolean isUnaryPlusMinus) {
        KtElement ktElement = callExpression;
        Object object = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(object, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, (BindingContext)object);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!KotlinBuiltIns.isUnderKotlinPackage(resolvedCall3.getResultingDescriptor())) {
            return null;
        }
        object = resolvedCall3.getResultingDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue(object, "resolvedCall.resultingDescriptor.name");
        Object resultingDescriptorName = object;
        OperationArgument operationArgument = this.createOperationArgumentForReceiver(resolvedCall3, receiverExpression);
        if (operationArgument == null) {
            return null;
        }
        OperationArgument argumentForReceiver = operationArgument;
        if (this.isStandaloneOnlyConstant(argumentForReceiver.getExpression())) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall3.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string2 = ((Name)resultingDescriptorName).asString();
            Intrinsics.checkNotNullExpressionValue(string2, "resultingDescriptorName.asString()");
            Object object2 = this.evaluateUnaryAndCheck(argumentForReceiver, string2, callExpression);
            if (object2 == null) {
                return null;
            }
            Object result2 = object2;
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant22 = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant22 = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            boolean isCharCode = argumentForReceiver.getCtcType() == CompileTimeType.CHAR && Intrinsics.areEqual(resultingDescriptorName, StandardNames.CHAR_CODE);
            boolean dontCreateILT = this.defaultValueForDontCreateIntegerLiteralType && !isUnaryPlusMinus && !this.hasIntegerLiteralType(receiverExpression);
            KotlinType kotlinType = expectedType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType kotlinType2 = kotlinType;
            Object object3 = result2;
            ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor = this;
            boolean bl3 = false;
            boolean bl4 = dontCreateILT;
            return constantExpressionEvaluatorVisitor.createConstant(object3, !bl4 ? kotlinType : null, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && !isCharCode && isArgumentPure, false, false, usesVariableAsConstant22, usesNonConstValAsConstant22, false, dontCreateILT));
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant<?> compileTimeConstant;
            Object isNumberConversionMethod;
            Map.Entry entry;
            Map.Entry canBeUsedInAnnotation = entry = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            boolean usesVariableAsConstant22 = false;
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)canBeUsedInAnnotation.getKey();
            Map.Entry usesVariableAsConstant22 = entry;
            boolean usesNonConstValAsConstant22 = false;
            ResolvedValueArgument argument2 = (ResolvedValueArgument)usesVariableAsConstant22.getValue();
            Intrinsics.checkNotNullExpressionValue(argument2, "argument");
            Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
            Object usesNonConstValAsConstant22 = this.createOperationArgumentForFirstParameter(argument2, parameter);
            if (usesNonConstValAsConstant22 == null) {
                return null;
            }
            Object argumentForParameter = usesNonConstValAsConstant22;
            if (this.isStandaloneOnlyConstant(((OperationArgument)argumentForParameter).getExpression())) {
                return null;
            }
            usesNonConstValAsConstant22 = ((Name)resultingDescriptorName).asString();
            Intrinsics.checkNotNullExpressionValue(usesNonConstValAsConstant22, "resultingDescriptorName.asString()");
            if (this.isDivisionByZero((String)usesNonConstValAsConstant22, ((OperationArgument)argumentForParameter).getValue())) {
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, KtExpression.class);
                Intrinsics.checkNotNull(ktExpression);
                isNumberConversionMethod = ktExpression;
                Intrinsics.checkNotNullExpressionValue(isNumberConversionMethod, "getParentOfType(receiver\u2026Expression::class.java)!!");
                KtExpression parentExpression = isNumberConversionMethod;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((KtExpression)((PsiElement)parentExpression)));
                if (ConstantExpressionEvaluatorKt.isIntegerType(argumentForReceiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(((OperationArgument)argumentForParameter).getValue()) || !this.languageVersionSettings.supportsFeature(LanguageFeature.DivisionByZeroInConstantExpressions)) {
                    return ConstantExpressionEvaluatorVisitor.wrap$default(this, ErrorValue.Companion.create("Division by zero"), false, false, false, false, false, false, false, false, 255, null);
                }
            }
            String isCharCode = ((Name)resultingDescriptorName).asString();
            Intrinsics.checkNotNullExpressionValue(isCharCode, "resultingDescriptorName.asString()");
            isNumberConversionMethod = this.evaluateBinaryAndCheck(argumentForReceiver, (OperationArgument)argumentForParameter, isCharCode, callExpression);
            if (isNumberConversionMethod == null) {
                return null;
            }
            Object result3 = isNumberConversionMethod;
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(((OperationArgument)argumentForParameter).getExpression());
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(((OperationArgument)argumentForParameter).getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(((OperationArgument)argumentForParameter).getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(((OperationArgument)argumentForParameter).getExpression());
            boolean dontCreateILT = this.defaultValueForDontCreateIntegerLiteralType && !this.hasIntegerLiteralType(receiverExpression);
            CompileTimeConstant.Parameters parameters2 = new CompileTimeConstant.Parameters(canBeUsedInAnnotation2, areArgumentsPure, false, false, usesVariableAsConstant, usesNonConstValAsConstant, false, dontCreateILT);
            Object object4 = resultingDescriptorName;
            if (Intrinsics.areEqual(object4, OperatorNameConventions.COMPARE_TO)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForCompareTo(result3, callExpression);
                compileTimeConstant = constantValue == null ? null : this.wrap(constantValue, parameters2);
            } else if (Intrinsics.areEqual(object4, OperatorNameConventions.EQUALS)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForEquals(result3, callExpression);
                compileTimeConstant = constantValue == null ? null : this.wrap(constantValue, parameters2);
            } else {
                KotlinType kotlinType = expectedType2;
                boolean bl = false;
                boolean bl5 = false;
                KotlinType kotlinType3 = kotlinType;
                Object object5 = result3;
                ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor = this;
                boolean bl6 = false;
                boolean bl7 = dontCreateILT;
                compileTimeConstant = constantExpressionEvaluatorVisitor.createConstant(object5, !bl7 ? kotlinType : null, parameters2);
            }
            return compileTimeConstant;
        }
        return null;
    }

    static /* synthetic */ CompileTimeConstant evaluateCall$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, KtExpression ktExpression, KtExpression ktExpression2, KotlinType kotlinType, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return constantExpressionEvaluatorVisitor.evaluateCall(ktExpression, ktExpression2, kotlinType, bl);
    }

    private final boolean usesVariableAsConstant(KtExpression expression2) {
        boolean bl;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant == null ? false : (bl = compileTimeConstant.getUsesVariableAsConstant());
    }

    private final boolean usesNonConstValAsConstant(KtExpression expression2) {
        boolean bl;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant == null ? false : (bl = compileTimeConstant.getUsesNonConstValAsConstant());
    }

    private final boolean canBeUsedInAnnotation(KtExpression expression2) {
        boolean bl;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant == null ? false : (bl = compileTimeConstant.getCanBeUsedInAnnotations());
    }

    private final boolean isPureConstant(KtExpression expression2) {
        boolean bl;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant == null ? false : (bl = compileTimeConstant.isPure());
    }

    private final boolean hasIntegerLiteralType(KtExpression expression2) {
        boolean bl;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant == null ? false : (bl = compileTimeConstant.getHasIntegerLiteralType());
    }

    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateUnaryAndCheck(name, receiver.getCtcType(), receiver.getValue(), new Function0<Unit>(this, callExpression){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;
            final /* synthetic */ KtExpression $callExpression;
            {
                this.this$0 = $receiver;
                this.$callExpression = $callExpression;
                super(0);
            }

            public final void invoke() {
                KtExpression ktExpression;
                PsiElement $this$getStrictParentOfType$iv = this.$callExpression;
                boolean $i$f$getStrictParentOfType = false;
                ConstantExpressionEvaluatorVisitor.access$getTrace$p(this.this$0).report(Errors.INTEGER_OVERFLOW.on((KtExpression)((PsiElement)((ktExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtExpression.class, true)) == null ? this.$callExpression : ktExpression))));
            }
        });
    }

    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateBinaryAndCheck(name, receiver.getCtcType(), receiver.getValue(), parameter.getCtcType(), parameter.getValue(), new Function0<Unit>(this, callExpression){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;
            final /* synthetic */ KtExpression $callExpression;
            {
                this.this$0 = $receiver;
                this.$callExpression = $callExpression;
                super(0);
            }

            public final void invoke() {
                KtExpression ktExpression;
                PsiElement $this$getStrictParentOfType$iv = this.$callExpression;
                boolean $i$f$getStrictParentOfType = false;
                ConstantExpressionEvaluatorVisitor.access$getTrace$p(this.this$0).report(Errors.INTEGER_OVERFLOW.on((KtExpression)((PsiElement)((ktExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtExpression.class, true)) == null ? this.$callExpression : ktExpression))));
            }
        });
    }

    private final boolean isDivisionByZero(String name, Object parameter) {
        return ConstantExpressionEvaluatorKt.access$getDIVISION_OPERATION_NAMES$p().contains(name) && ConstantExpressionEvaluatorKt.access$isZero(parameter);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull KtUnaryExpression expression2, @Nullable KotlinType expectedType2) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression2 = expression2.getBaseExpression();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression = ktExpression2;
        IElementType tokenType = expression2.getOperationToken();
        ktExpression2 = expression2.getOperationReference();
        Intrinsics.checkNotNullExpressionValue(ktExpression2, "expression.operationReference");
        return this.evaluateCall(ktExpression2, leftExpression, expectedType2, Intrinsics.areEqual(tokenType, KtTokens.PLUS) || Intrinsics.areEqual(tokenType, KtTokens.MINUS));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable KotlinType expectedType2) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            Object object = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassDescriptor)declarationDescriptor));
            if (object == null) {
                return null;
            }
            ClassId enumClassId = object;
            object = enumDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(object, "enumDescriptor.name");
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new EnumValue(enumClassId, (Name)object), false, false, false, false, false, false, false, false, 255, null);
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 != null && (callableDescriptor = resolvedCall2.getResultingDescriptor()) instanceof VariableDescriptor) {
            if (callableDescriptor instanceof PropertyDescriptor && ((PropertyDescriptor)callableDescriptor).getModality() != Modality.FINAL) {
                return null;
            }
            boolean isConvertableConstVal = ((VariableDescriptor)callableDescriptor).isConst() && ImplicitIntegerCoercion.INSTANCE.isEnabledForConstVal((VariableDescriptor)callableDescriptor) && ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer() instanceof IntValue;
            ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            return constantValue == null ? null : this.wrap(constantValue, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor), false, false, false, true, !((VariableDescriptor)callableDescriptor).isConst(), isConvertableConstVal, true));
        }
        return null;
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor2)) {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "descriptor.type");
            return ConstUtilKt.canBeUsedForConstVal(kotlinType);
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, @Nullable KotlinType expectedType2) {
        CompileTimeConstant result2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression selectorExpression = expression2.getSelectorExpression();
        if (selectorExpression instanceof KtCallExpression) {
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType2);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof KtSimpleNameExpression)) {
                return null;
            }
            KtExpression receiverExpression = expression2.getReceiverExpression();
            return ConstantExpressionEvaluatorVisitor.evaluateCall$default(this, calleeExpression, receiverExpression, expectedType2, false, 8, null);
        }
        if (selectorExpression instanceof KtSimpleNameExpression && (result2 = ConstantExpressionEvaluatorVisitor.evaluateCall$default(this, selectorExpression, expression2.getReceiverExpression(), expectedType2, false, 8, null)) != null) {
            return result2;
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType2);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull KtCallExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall2;
        CallableDescriptor resultingDescriptor = call2.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayFunctionCall(call2)) {
            return this.createConstantValueForArrayFunctionCall(call2);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            CompileTimeConstant compileTimeConstant;
            Object object = ((ConstructorDescriptor)resultingDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(object, "resultingDescriptor.constructedClass");
            ClassDescriptor classDescriptor = object;
            if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
                AnnotationDescriptorImpl descriptor2 = new AnnotationDescriptorImpl(classDescriptor.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments$frontend(call2, this.trace), SourceElement.NO_SOURCE);
                compileTimeConstant = ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor2), false, false, false, false, false, false, false, false, 255, null);
            } else if (InlineClassesUtilsKt.isInlineClass(classDescriptor) && UnsignedTypes.INSTANCE.isUnsignedClass(classDescriptor)) {
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)resultingDescriptor;
                InlineClassRepresentation<SimpleType> inlineClassRepresentation2 = classDescriptor.getInlineClassRepresentation();
                Intrinsics.checkNotNull(inlineClassRepresentation2);
                object = inlineClassRepresentation2;
                Intrinsics.checkNotNullExpressionValue(object, "classDescriptor.inlineClassRepresentation!!");
                compileTimeConstant = this.createConstantValueForUnsignedTypeConstructor(call2, constructorDescriptor, (InlineClassRepresentation<SimpleType>)object);
            } else {
                compileTimeConstant = null;
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final TypedCompileTimeConstant<?> createConstantValueForUnsignedTypeConstructor(ResolvedCall<?> call2, ConstructorDescriptor constructorDescriptor, InlineClassRepresentation<SimpleType> representation) {
        ConstantValue<?> constantValue;
        List<ValueArgument> list2;
        ValueArgument valueArgument;
        if (!constructorDescriptor.isPrimary()) {
            return null;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = call2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, "call.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = map;
        if (valueArguments.size() > 1) {
            return null;
        }
        Object object = (ResolvedValueArgument)CollectionsKt.singleOrNull((Iterable)valueArguments.values());
        ValueArgument valueArgument2 = object == null ? null : (valueArgument = (list2 = object.getArguments()) == null ? null : CollectionsKt.singleOrNull(list2));
        if (valueArgument == null) {
            return null;
        }
        ValueArgument argument2 = valueArgument;
        object = argument2.getArgumentExpression();
        if (object == null) {
            return null;
        }
        Object argumentExpression = object;
        SimpleType underlyingType = representation.getUnderlyingType();
        CompileTimeConstant<?> compileTimeConstant = this.evaluate((KtExpression)argumentExpression, underlyingType);
        Object object2 = compileTimeConstant;
        ConstantValue<?> constantValue2 = constantValue = object2 == null ? null : object2.toConstantValue(underlyingType);
        if (constantValue == null) {
            return null;
        }
        ConstantValue<?> evaluatedArgument = constantValue;
        object2 = ConstantValueFactory.INSTANCE.createUnsignedValue(evaluatedArgument);
        if (object2 == null) {
            return null;
        }
        CompileTimeConstant<?> unsignedValue = object2;
        return this.wrap((ConstantValue)((Object)unsignedValue), compileTimeConstant.getParameters());
    }

    /*
     * WARNING - void declaration
     */
    private final TypedCompileTimeConstant<List<ConstantValue<?>>> createConstantValueForArrayFunctionCall(ResolvedCall<?> call2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
        Object object;
        block10: {
            boolean bl7;
            Iterable $this$any$iv;
            boolean $i$f$any;
            List arguments2;
            block9: {
                Collection collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$flatMapTo$iv$iv;
                KotlinType kotlinType;
                KotlinType kotlinType2 = call2.getResultingDescriptor().getReturnType();
                if (kotlinType2 == null) {
                    return null;
                }
                KotlinType returnType2 = kotlinType = kotlinType2;
                kotlinType2 = this.builtIns.getArrayElementType(returnType2);
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "builtIns.getArrayElementType(returnType)");
                KotlinType componentType = kotlinType2;
                Iterable $this$flatMap$iv = call2.getValueArguments().values();
                boolean $i$f$flatMap22 = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv;
                    boolean bl8 = false;
                    List<ValueArgument> list2 = it.getArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, "it.arguments");
                    Iterable list$iv$iv = this.resolveArguments(list2, componentType);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                arguments2 = (List)destination$iv$iv;
                List evaluatedArguments = CollectionsKt.filterNotNull(arguments2);
                Iterable $i$f$flatMap22 = evaluatedArguments;
                object = ConstantValueFactory.INSTANCE;
                constantExpressionEvaluatorVisitor = this;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CompileTimeConstant bl8 = (CompileTimeConstant)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl9 = false;
                    ConstantValue constantValue = it.toConstantValue(componentType);
                    collection.add(constantValue);
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv = evaluatedArguments;
                bl6 = false;
                bl5 = false;
                bl4 = false;
                bl3 = false;
                object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, returnType2);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CompileTimeConstant it = (CompileTimeConstant)element$iv;
                        boolean bl10 = false;
                        if (!it.getUsesVariableAsConstant()) continue;
                        bl7 = true;
                        break block9;
                    }
                    bl7 = false;
                }
            }
            bl2 = bl7;
            $this$any$iv = arguments2;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CompileTimeConstant it = (CompileTimeConstant)element$iv;
                    boolean bl11 = false;
                    if (!(it == null || it.getUsesNonConstValAsConstant())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean bl12 = bl;
        return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl5, bl6, bl2, bl12, false, false, 207, null);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @Nullable KotlinType expectedType2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KotlinType kotlinType2 = this.trace.getType(expression2);
        Intrinsics.checkNotNull(kotlinType2);
        KotlinType kotlinType3 = kotlinType2;
        Intrinsics.checkNotNullExpressionValue(kotlinType3, "trace.getType(expression)!!");
        KotlinType kClassType = kotlinType3;
        if (KotlinTypeKt.isError(kClassType)) {
            return null;
        }
        ClassifierDescriptor descriptor2 = kClassType.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor) || !KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            return null;
        }
        TypeProjection typeProjection = CollectionsKt.singleOrNull(kClassType.getArguments());
        KotlinType kotlinType4 = kotlinType = typeProjection == null ? null : typeProjection.getType();
        if (kotlinType == null) {
            return null;
        }
        ConstantValue<?> constantValue = kotlinType;
        KotlinType type2 = constantValue;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitTypeParametersInClassLiteralsInAnnotationArguments) && ConstantExpressionEvaluator.Companion.isTypeParameterOrArrayOfTypeParameter$frontend(type2)) {
            return null;
        }
        constantValue = KClassValue.Companion.create(type2);
        return constantValue == null ? null : ConstantExpressionEvaluatorVisitor.wrap$default(this, constantValue, false, false, false, false, false, false, false, false, 255, null);
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments, KotlinType expectedType2) {
        boolean bl = false;
        ArrayList constants = new ArrayList();
        for (ValueArgument valueArgument : valueArguments) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            constants.add(this.evaluate(argumentExpression, expectedType2));
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitKtElement(@NotNull KtElement element, @Nullable KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall2, KtExpression expression2) {
        KotlinType kotlinType = ConstantExpressionEvaluatorKt.access$getReceiverExpressionType(resolvedCall2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType receiverExpressionType = kotlinType;
        CompileTimeType compileTimeType = this.getCompileTimeType(receiverExpressionType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType receiverCompileTimeType = compileTimeType;
        return this.createOperationArgument(expression2, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument2, ValueParameterDescriptor parameter) {
        Object object = parameter.getType();
        Intrinsics.checkNotNullExpressionValue(object, "parameter.type");
        CompileTimeType compileTimeType = this.getCompileTimeType((KotlinType)object);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType argumentCompileTimeType = compileTimeType;
        object = argument2.getArguments();
        Intrinsics.checkNotNullExpressionValue(object, "argument.arguments");
        Object arguments2 = object;
        if (arguments2.size() != 1) {
            return null;
        }
        Object object2 = ((ValueArgument)CollectionsKt.first(arguments2)).getArgumentExpression();
        if (object2 == null) {
            return null;
        }
        KtExpression argumentExpression = object2;
        object2 = parameter.getType();
        Intrinsics.checkNotNullExpressionValue(object2, "parameter.type");
        return this.createOperationArgument(argumentExpression, (KotlinType)object2, argumentCompileTimeType);
    }

    private final CompileTimeType getCompileTimeType(KotlinType c) {
        KotlinType kotlinType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual(kotlinType, this.builtIns.getIntType()) ? CompileTimeType.INT : (Intrinsics.areEqual(kotlinType, this.builtIns.getByteType()) ? CompileTimeType.BYTE : (Intrinsics.areEqual(kotlinType, this.builtIns.getShortType()) ? CompileTimeType.SHORT : (Intrinsics.areEqual(kotlinType, this.builtIns.getLongType()) ? CompileTimeType.LONG : (Intrinsics.areEqual(kotlinType, this.builtIns.getDoubleType()) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual(kotlinType, this.builtIns.getFloatType()) ? CompileTimeType.FLOAT : (Intrinsics.areEqual(kotlinType, this.builtIns.getCharType()) ? CompileTimeType.CHAR : (Intrinsics.areEqual(kotlinType, this.builtIns.getBooleanType()) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual(kotlinType, this.builtIns.getStringType()) ? CompileTimeType.STRING : (Intrinsics.areEqual(kotlinType, this.builtIns.getAnyType()) ? CompileTimeType.ANY : null)))))))));
    }

    private final OperationArgument createOperationArgument(KtExpression expression2, KotlinType parameterType, CompileTimeType compileTimeType) {
        Object object;
        CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.evaluateExpression$default(this.constantExpressionEvaluator, expression2, this.trace, parameterType, false, 8, null);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 instanceof TypedCompileTimeConstant && !TypeUtilsKt.isSubtypeOf(((TypedCompileTimeConstant)compileTimeConstant2).getType(), parameterType)) {
            return null;
        }
        ConstantValue constantValue = compileTimeConstant2.toConstantValue(parameterType);
        Object object2 = object = compileTimeType == CompileTimeType.ANY ? constantValue.boxedValue() : constantValue.getValue();
        if (object == null) {
            return null;
        }
        Object evaluationResult = object;
        return new OperationArgument(evaluationResult, compileTimeType, expression2);
    }

    private final CompileTimeConstant<?> createConstant(Object value2, KotlinType expectedType2, CompileTimeConstant.Parameters parameters2) {
        if (parameters2.isPure() || parameters2.isUnsignedNumberLiteral()) {
            KotlinType kotlinType;
            KotlinType kotlinType2 = expectedType2;
            if (kotlinType2 == null) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            } else {
                kotlinType = kotlinType2;
            }
            return this.createCompileTimeConstant(value2, parameters2, kotlinType);
        }
        ConstantValue<?> constantValue = ConstantValueFactory.INSTANCE.createConstantValue(value2);
        return constantValue == null ? null : this.wrap(constantValue, parameters2);
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value2, CompileTimeConstant.Parameters parameters2, KotlinType expectedType2) {
        CompileTimeConstant compileTimeConstant;
        Object object = value2;
        if (((object instanceof Byte ? true : object instanceof Short) ? true : object instanceof Integer) ? true : object instanceof Long) {
            if (value2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)value2).longValue(), parameters2, expectedType2);
        } else {
            ConstantValue<?> constantValue = ConstantValueFactory.INSTANCE.createConstantValue(value2);
            compileTimeConstant = constantValue == null ? null : this.wrap(constantValue, parameters2);
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value2, CompileTimeConstant.Parameters parameters2, KotlinType expectedType2) {
        if (parameters2.isUnsignedNumberLiteral() && !this.checkAccessibilityOfUnsignedTypes()) {
            return new UnsignedErrorValueTypeConstant(value2, parameters2);
        }
        if (parameters2.isUnsignedLongNumberLiteral()) {
            return this.wrap(new ULongValue(value2), parameters2);
        }
        if (TypeUtils.noExpectedType(expectedType2) || KotlinTypeKt.isError(expectedType2)) {
            return parameters2.getDontCreateILT() ? (CompileTimeConstant<?>)this.createSimpleIntCompileTimeConst(value2, parameters2) : CompileTimeConstantKt.createIntegerValueTypeConstant(value2, this.constantExpressionEvaluator.getModule$frontend(), parameters2, this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference));
        }
        ConstantValue<?> integerValue = ConstantValueFactory.INSTANCE.createIntegerConstantValue(value2, expectedType2, parameters2.isUnsignedNumberLiteral());
        if (integerValue != null) {
            return this.wrap(integerValue, parameters2);
        }
        return this.createSimpleIntCompileTimeConst(value2, parameters2);
    }

    private final TypedCompileTimeConstant<?> createSimpleIntCompileTimeConst(long $this$createSimpleIntCompileTimeConst, CompileTimeConstant.Parameters parameters2) {
        long l;
        long l2;
        long value2 = $this$createSimpleIntCompileTimeConst;
        return this.wrap(parameters2.isUnsignedNumberLiteral() ? (ConstantValue)((l2 = value2) == ConstantValueFactoryKt.fromUIntToLong((int)value2) ? (UnsignedValueConstant)new UIntValue((int)value2) : (UnsignedValueConstant)new ULongValue(value2)) : (ConstantValue)((l = value2) == (long)((int)value2) ? (IntegerValueConstant)new IntValue((int)value2) : (IntegerValueConstant)new LongValue(value2)), parameters2);
    }

    private final boolean checkAccessibilityOfUnsignedTypes() {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.constantExpressionEvaluator.getModule$frontend(), StandardNames.FqNames.uInt);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor uInt = classDescriptor;
        SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(uInt, this.languageVersionSettings);
        return !(accessibility instanceof SinceKotlinAccessibility.NotAccessible);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $this$wrap, CompileTimeConstant.Parameters parameters2) {
        return new TypedCompileTimeConstant<T>($this$wrap, this.constantExpressionEvaluator.getModule$frontend(), parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $this$wrap, boolean canBeUsedInAnnotation, boolean isPure, boolean isUnsigned, boolean isUnsignedLong, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant, boolean isConvertableConstVal, boolean dontCreateILT) {
        return this.wrap($this$wrap, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, isUnsigned, isUnsignedLong, usesVariableAsConstant, usesNonConstValAsConstant, isConvertableConstVal, dontCreateILT));
    }

    static /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl9 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        if ((n & 0x10) != 0) {
            bl5 = false;
        }
        if ((n & 0x20) != 0) {
            bl6 = false;
        }
        if ((n & 0x40) != 0) {
            bl7 = false;
        }
        if ((n & 0x80) != 0) {
            bl8 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8);
    }

    public static final /* synthetic */ BindingTrace access$getTrace$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.trace;
    }

    public static final /* synthetic */ TypedCompileTimeConstant access$wrap(ConstantExpressionEvaluatorVisitor $this, ConstantValue $receiver, CompileTimeConstant.Parameters parameters2) {
        return $this.wrap($receiver, parameters2);
    }

    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.builtIns;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "", "value", "ctcType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getCtcType", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getValue", "()Ljava/lang/Object;", "frontend"})
    private static final class OperationArgument {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType ctcType;
        @NotNull
        private final KtExpression expression;

        public OperationArgument(@NotNull Object value2, @NotNull CompileTimeType ctcType, @NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            Intrinsics.checkNotNullParameter((Object)ctcType, "ctcType");
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.value = value2;
            this.ctcType = ctcType;
            this.expression = expression2;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }
    }
}

